/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.GraphicBuffer;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.util.ArraySet;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.DisplayInfo;
import android.view.IApplicationToken;
import android.view.InputApplicationHandle;
import android.view.RemoteAnimationAdapter;
import android.view.RemoteAnimationDefinition;
import android.view.SurfaceControl;
import android.view.WindowManager;
import android.view.animation.Animation;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ToBooleanFunction;
import com.android.server.AttributeCache;
import com.android.server.LocalServices;
import com.android.server.display.color.ColorDisplayService;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.wm.AccessibilityController;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.AnimatingAppWindowTokenRegistry;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.AppTransition;
import com.android.server.wm.AppWindowThumbnail;
import com.android.server.wm.ConfigurationContainerListener;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.Letterbox;
import com.android.server.wm.LocalAnimationAdapter;
import com.android.server.wm.RecentsAnimationController;
import com.android.server.wm.RemoteAnimationController;
import com.android.server.wm.SnapshotStartingData;
import com.android.server.wm.SplashScreenStartingData;
import com.android.server.wm.StartingData;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowAnimationSpec;
import com.android.server.wm.WindowChangeAnimationSpec;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.function.Consumer;

class AppWindowToken
extends WindowToken
implements WindowManagerService.AppFreezeListener,
ConfigurationContainerListener {
    private static final String TAG = "WindowManager";
    @VisibleForTesting
    static final int Z_BOOST_BASE = 800570000;
    final IApplicationToken appToken;
    final ComponentName mActivityComponent;
    final boolean mVoiceInteraction;
    private boolean mFillsParent;
    boolean mShowForAllUsers;
    int mTargetSdk;
    private boolean mReparenting;
    private boolean mRemovingFromDisplay = false;
    long mInputDispatchingTimeoutNanos;
    private long mLastTransactionSequence = Long.MIN_VALUE;
    private int mNumInterestingWindows;
    private int mNumDrawnWindows;
    boolean inPendingTransaction;
    boolean allDrawn;
    private boolean mLastAllDrawn;
    private boolean mUseTransferredAnimation;
    boolean deferClearAllDrawn;
    boolean hiddenRequested;
    private boolean mClientHidden;
    boolean mDeferHidingClient;
    boolean reportedVisible;
    private boolean reportedDrawn;
    boolean removed;
    StartingData mStartingData;
    WindowState startingWindow;
    WindowManagerPolicy.StartingSurface startingSurface;
    boolean startingDisplayed;
    boolean startingMoved;
    private boolean mHiddenSetFromTransferredStartingWindow;
    boolean firstWindowDrawn;
    private final WindowState.UpdateReportedVisibilityResults mReportedVisibilityResults = new WindowState.UpdateReportedVisibilityResults();
    final InputApplicationHandle mInputApplicationHandle;
    boolean mIsExiting;
    boolean mLaunchTaskBehind;
    boolean mEnteringAnimation;
    private boolean mAlwaysFocusable;
    boolean mAppStopped;
    int mRotationAnimationHint;
    private int mPendingRelaunchCount;
    private boolean mLastContainsShowWhenLockedWindow;
    private boolean mLastContainsDismissKeyguardWindow;
    ArrayDeque<Rect> mFrozenBounds = new ArrayDeque();
    ArrayDeque<Configuration> mFrozenMergedConfig = new ArrayDeque();
    private float mSizeCompatScale = 1.0f;
    private Rect mSizeCompatBounds;
    private boolean mDisablePreviewScreenshots;
    private Task mLastParent;
    ActivityRecord mActivityRecord;
    private boolean mCanTurnScreenOn = true;
    private int mTransit;
    private int mTransitFlags;
    private boolean mLastSurfaceShowing = true;
    private AppWindowThumbnail mThumbnail;
    private final Rect mTransitStartRect = new Rect();
    private SurfaceControl mTransitChangeLeash = null;
    private boolean mFreezingScreen;
    @VisibleForTesting
    boolean mNeedsZBoost;
    private Letterbox mLetterbox;
    private final Point mTmpPoint = new Point();
    private final Rect mTmpRect = new Rect();
    private final Rect mTmpPrevBounds = new Rect();
    private RemoteAnimationDefinition mRemoteAnimationDefinition;
    private AnimatingAppWindowTokenRegistry mAnimatingAppWindowTokenRegistry;
    private boolean mWillCloseOrEnterPip;
    SurfaceControl mAnimationBoundsLayer;
    boolean mNeedsAnimationBoundsLayer;
    private static final int STARTING_WINDOW_TYPE_NONE = 0;
    private static final int STARTING_WINDOW_TYPE_SNAPSHOT = 1;
    private static final int STARTING_WINDOW_TYPE_SPLASH_SCREEN = 2;
    private AppSaturationInfo mLastAppSaturationInfo;
    private final ColorDisplayService.ColorTransformController mColorTransformController = (matrix, translation) -> this.mWmService.mH.post(() -> {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mWmService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mLastAppSaturationInfo == null) {
                    this.mLastAppSaturationInfo = new AppSaturationInfo();
                }
                this.mLastAppSaturationInfo.setSaturation(matrix, translation);
                this.updateColorTransform();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    });
    private final Runnable mAddStartingWindow = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block13: {
                var2_1 = AppWindowToken.this.mWmService.mGlobalLock;
                synchronized (var2_1) {
                    WindowManagerService.boostPriorityForLockedSection();
                    AppWindowToken.this.mWmService.mAnimationHandler.removeCallbacks(this);
                    if (AppWindowToken.this.mStartingData != null) ** break block12
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
                {
                    try {
                        startingData = AppWindowToken.this.mStartingData;
                    }
                    catch (Throwable var3_3) {
                        // MONITOREXIT @DISABLED, blocks:[4, 6] lbl15 : MonitorExitStatement: MONITOREXIT : var2_1
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw var3_3;
                    }
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                surface = null;
                try {
                    surface = startingData.createStartingSurface(AppWindowToken.this);
                }
                catch (Exception e) {
                    Slog.w("WindowManager", "Exception when adding starting window", e);
                }
                if (surface == null) break block13;
                abort = false;
                var4_6 = AppWindowToken.this.mWmService.mGlobalLock;
                synchronized (var4_6) {
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (AppWindowToken.this.removed || AppWindowToken.this.mStartingData == null) {
                            AppWindowToken.this.startingWindow = null;
                            AppWindowToken.this.mStartingData = null;
                            abort = true;
                        } else {
                            AppWindowToken.this.startingSurface = surface;
                        }
                    }
                    catch (Throwable var5_7) {
                        // MONITOREXIT @DISABLED, blocks:[5, 8] lbl41 : MonitorExitStatement: MONITOREXIT : var4_6
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw var5_7;
                    }
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                if (abort) {
                    surface.remove();
                }
            }
        }
    };

    AppWindowToken(WindowManagerService service, IApplicationToken token, ComponentName activityComponent, boolean voiceInteraction, DisplayContent dc, long inputDispatchingTimeoutNanos, boolean fullscreen, boolean showForAllUsers, int targetSdk, int orientation, int rotationAnimationHint, boolean launchTaskBehind, boolean alwaysFocusable, ActivityRecord activityRecord) {
        this(service, token, activityComponent, voiceInteraction, dc, fullscreen);
        this.mActivityRecord = activityRecord;
        this.mActivityRecord.registerConfigurationChangeListener(this);
        this.mInputDispatchingTimeoutNanos = inputDispatchingTimeoutNanos;
        this.mShowForAllUsers = showForAllUsers;
        this.mTargetSdk = targetSdk;
        this.mOrientation = orientation;
        this.mLaunchTaskBehind = launchTaskBehind;
        this.mAlwaysFocusable = alwaysFocusable;
        this.mRotationAnimationHint = rotationAnimationHint;
        this.setHidden(true);
        this.hiddenRequested = true;
        ColorDisplayService.ColorDisplayServiceInternal cds = LocalServices.getService(ColorDisplayService.ColorDisplayServiceInternal.class);
        cds.attachColorTransformController(activityRecord.packageName, activityRecord.mUserId, new WeakReference<ColorDisplayService.ColorTransformController>(this.mColorTransformController));
    }

    AppWindowToken(WindowManagerService service, IApplicationToken token, ComponentName activityComponent, boolean voiceInteraction, DisplayContent dc, boolean fillsParent) {
        super(service, token != null ? token.asBinder() : null, 2, true, dc, false);
        this.appToken = token;
        this.mActivityComponent = activityComponent;
        this.mVoiceInteraction = voiceInteraction;
        this.mFillsParent = fillsParent;
        this.mInputApplicationHandle = new InputApplicationHandle(this.appToken.asBinder());
    }

    void onFirstWindowDrawn(WindowState win, WindowStateAnimator winAnimator) {
        this.firstWindowDrawn = true;
        this.removeDeadWindows();
        if (this.startingWindow != null) {
            win.cancelAnimation();
        }
        this.removeStartingWindow();
        this.updateReportedVisibilityLocked();
    }

    void updateReportedVisibilityLocked() {
        boolean nowVisible;
        if (this.appToken == null) {
            return;
        }
        int count = this.mChildren.size();
        this.mReportedVisibilityResults.reset();
        for (int i = 0; i < count; ++i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            win.updateReportedVisibility(this.mReportedVisibilityResults);
        }
        int numInteresting = this.mReportedVisibilityResults.numInteresting;
        int numVisible = this.mReportedVisibilityResults.numVisible;
        int numDrawn = this.mReportedVisibilityResults.numDrawn;
        boolean nowGone = this.mReportedVisibilityResults.nowGone;
        boolean nowDrawn = numInteresting > 0 && numDrawn >= numInteresting;
        boolean bl = nowVisible = numInteresting > 0 && numVisible >= numInteresting && !this.isHidden();
        if (!nowGone) {
            if (!nowDrawn) {
                nowDrawn = this.reportedDrawn;
            }
            if (!nowVisible) {
                nowVisible = this.reportedVisible;
            }
        }
        if (nowDrawn != this.reportedDrawn) {
            if (this.mActivityRecord != null) {
                this.mActivityRecord.onWindowsDrawn(nowDrawn, SystemClock.uptimeMillis());
            }
            this.reportedDrawn = nowDrawn;
        }
        if (nowVisible != this.reportedVisible) {
            this.reportedVisible = nowVisible;
            if (this.mActivityRecord != null) {
                if (nowVisible) {
                    this.onWindowsVisible();
                } else {
                    this.onWindowsGone();
                }
            }
        }
    }

    private void onWindowsGone() {
        if (this.mActivityRecord == null) {
            return;
        }
        this.mActivityRecord.onWindowsGone();
    }

    private void onWindowsVisible() {
        if (this.mActivityRecord == null) {
            return;
        }
        this.mActivityRecord.onWindowsVisible();
    }

    boolean isClientHidden() {
        return this.mClientHidden;
    }

    void setClientHidden(boolean hideClient) {
        if (this.mClientHidden == hideClient || hideClient && this.mDeferHidingClient) {
            return;
        }
        this.mClientHidden = hideClient;
        this.sendAppVisibilityToClients();
    }

    void setVisibility(boolean visible, boolean deferHidingClient) {
        AppTransition appTransition = this.getDisplayContent().mAppTransition;
        if (!visible && this.hiddenRequested) {
            if (!deferHidingClient && this.mDeferHidingClient) {
                this.mDeferHidingClient = deferHidingClient;
                this.setClientHidden(true);
            }
            return;
        }
        DisplayContent displayContent = this.getDisplayContent();
        displayContent.mOpeningApps.remove(this);
        displayContent.mClosingApps.remove(this);
        if (this.isInChangeTransition()) {
            this.clearChangeLeash(this.getPendingTransaction(), true);
        }
        displayContent.mChangingApps.remove(this);
        this.waitingToShow = false;
        this.hiddenRequested = !visible;
        this.mDeferHidingClient = deferHidingClient;
        if (!visible) {
            this.removeDeadWindows();
        } else {
            if (!appTransition.isTransitionSet() && appTransition.isReady()) {
                displayContent.mOpeningApps.add(this);
            }
            this.startingMoved = false;
            if (this.isHidden() || this.mAppStopped) {
                this.clearAllDrawn();
                if (this.isHidden()) {
                    this.waitingToShow = true;
                    this.forAllWindows((WindowState w) -> {
                        if (w.mWinAnimator.mDrawState == 4) {
                            w.mWinAnimator.resetDrawState();
                            w.resetLastContentInsets();
                        }
                    }, true);
                }
            }
            this.setClientHidden(false);
            this.requestUpdateWallpaperIfNeeded();
            this.mAppStopped = false;
            this.transferStartingWindowFromHiddenAboveTokenIfNeeded();
        }
        if (this.okToAnimate() && appTransition.isTransitionSet()) {
            AppWindowToken focusedToken;
            WindowState win;
            this.inPendingTransaction = true;
            if (visible) {
                displayContent.mOpeningApps.add(this);
                this.mEnteringAnimation = true;
            } else {
                displayContent.mClosingApps.add(this);
                this.mEnteringAnimation = false;
            }
            if (appTransition.getAppTransition() == 16 && (win = this.getDisplayContent().findFocusedWindow()) != null && (focusedToken = win.mAppToken) != null) {
                focusedToken.setHidden(true);
                displayContent.mOpeningApps.add(focusedToken);
            }
            this.reportDescendantOrientationChangeIfNeeded();
            return;
        }
        this.commitVisibility(null, visible, -1, true, this.mVoiceInteraction);
        this.updateReportedVisibilityLocked();
    }

    boolean commitVisibility(WindowManager.LayoutParams lp, boolean visible, int transit, boolean performLayout, boolean isVoiceInteraction) {
        int i;
        boolean delayed = false;
        this.inPendingTransaction = false;
        this.mHiddenSetFromTransferredStartingWindow = false;
        boolean visibilityChanged = false;
        if (this.isHidden() == visible || this.isHidden() && this.mIsExiting || visible && this.waitingForReplacement()) {
            AccessibilityController accessibilityController = this.mWmService.mAccessibilityController;
            boolean changed = false;
            boolean runningAppAnimation = false;
            if (transit != -1) {
                if (this.mUseTransferredAnimation) {
                    runningAppAnimation = this.isReallyAnimating();
                } else if (this.applyAnimationLocked(lp, transit, visible, isVoiceInteraction)) {
                    runningAppAnimation = true;
                }
                delayed = runningAppAnimation;
                WindowState window = this.findMainWindow();
                if (window != null && accessibilityController != null) {
                    accessibilityController.onAppWindowTransitionLocked(window, transit);
                }
                changed = true;
            }
            int windowsCount = this.mChildren.size();
            for (int i2 = 0; i2 < windowsCount; ++i2) {
                WindowState win = (WindowState)this.mChildren.get(i2);
                changed |= win.onAppVisibilityChanged(visible, runningAppAnimation);
            }
            this.setHidden(!visible);
            this.hiddenRequested = !visible;
            visibilityChanged = true;
            if (!visible) {
                this.stopFreezingScreen(true, true);
            } else {
                if (this.startingWindow != null && !this.startingWindow.isDrawnLw()) {
                    this.startingWindow.clearPolicyVisibilityFlag(1);
                    this.startingWindow.mLegacyPolicyVisibilityAfterAnim = false;
                }
                this.forAllWindows(this.mWmService::makeWindowFreezingScreenIfNeededLocked, true);
            }
            if (changed) {
                this.getDisplayContent().getInputMonitor().setUpdateInputWindowsNeededLw();
                if (performLayout) {
                    this.mWmService.updateFocusedWindowLocked(3, false);
                    this.mWmService.mWindowPlacerLocked.performSurfacePlacement();
                }
                this.getDisplayContent().getInputMonitor().updateInputWindowsLw(false);
            }
        }
        this.mUseTransferredAnimation = false;
        if (this.isReallyAnimating()) {
            delayed = true;
        } else {
            this.onAnimationFinished();
        }
        for (i = this.mChildren.size() - 1; i >= 0 && !delayed; --i) {
            if (!((WindowState)this.mChildren.get(i)).isSelfOrChildAnimating()) continue;
            delayed = true;
        }
        if (visibilityChanged) {
            if (visible && !delayed) {
                this.mEnteringAnimation = true;
                this.mWmService.mActivityManagerAppTransitionNotifier.onAppTransitionFinishedLocked(this.token);
            }
            if (visible || !this.isReallyAnimating()) {
                this.setClientHidden(!visible);
            }
            if (!this.getDisplayContent().mClosingApps.contains(this) && !this.getDisplayContent().mOpeningApps.contains(this)) {
                this.getDisplayContent().getDockedDividerController().notifyAppVisibilityChanged();
                this.mWmService.mTaskSnapshotController.notifyAppVisibilityChanged(this, visible);
            }
            if (this.isHidden() && !delayed && !this.getDisplayContent().mAppTransition.isTransitionSet()) {
                SurfaceControl.openTransaction();
                for (i = this.mChildren.size() - 1; i >= 0; --i) {
                    ((WindowState)this.mChildren.get((int)i)).mWinAnimator.hide("immediately hidden");
                }
                SurfaceControl.closeTransaction();
            }
            this.reportDescendantOrientationChangeIfNeeded();
        }
        return delayed;
    }

    private void reportDescendantOrientationChangeIfNeeded() {
        if (this.mActivityRecord.getRequestedConfigurationOrientation() == this.getConfiguration().orientation || this.getOrientationIgnoreVisibility() == -2) {
            return;
        }
        IApplicationToken.Stub freezeToken = this.mActivityRecord.mayFreezeScreenLocked(this.mActivityRecord.app) ? this.mActivityRecord.appToken : null;
        this.onDescendantOrientationChanged(freezeToken, this.mActivityRecord);
    }

    WindowState getTopFullscreenWindow() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            if (win == null || !win.mAttrs.isFullscreen()) continue;
            return win;
        }
        return null;
    }

    WindowState findMainWindow() {
        return this.findMainWindow(true);
    }

    WindowState findMainWindow(boolean includeStartingApp) {
        WindowState candidate = null;
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            WindowState win = (WindowState)this.mChildren.get(j);
            int type = win.mAttrs.type;
            if (type != 1 && (!includeStartingApp || type != 3)) continue;
            if (win.mAnimatingExit) {
                candidate = win;
                continue;
            }
            return win;
        }
        return candidate;
    }

    boolean windowsAreFocusable() {
        if (this.mTargetSdk < 29) {
            int pid = this.mActivityRecord != null ? (this.mActivityRecord.app != null ? this.mActivityRecord.app.getPid() : 0) : 0;
            AppWindowToken topFocusedAppOfMyProcess = this.mWmService.mRoot.mTopFocusedAppByProcess.get(pid);
            if (topFocusedAppOfMyProcess != null && topFocusedAppOfMyProcess != this) {
                return false;
            }
        }
        return this.getWindowConfiguration().canReceiveKeys() || this.mAlwaysFocusable;
    }

    @Override
    boolean isVisible() {
        return !this.isHidden();
    }

    @Override
    void removeImmediately() {
        this.onRemovedFromDisplay();
        if (this.mActivityRecord != null) {
            this.mActivityRecord.unregisterConfigurationChangeListener(this);
        }
        super.removeImmediately();
    }

    @Override
    void removeIfPossible() {
        this.mIsExiting = false;
        this.removeAllWindowsIfPossible();
        this.removeImmediately();
    }

    @Override
    boolean checkCompleteDeferredRemoval() {
        if (this.mIsExiting) {
            this.removeIfPossible();
        }
        return super.checkCompleteDeferredRemoval();
    }

    void onRemovedFromDisplay() {
        if (this.mRemovingFromDisplay) {
            return;
        }
        this.mRemovingFromDisplay = true;
        boolean delayed = this.commitVisibility(null, false, -1, true, this.mVoiceInteraction);
        this.getDisplayContent().mOpeningApps.remove(this);
        this.getDisplayContent().mChangingApps.remove(this);
        this.getDisplayContent().mUnknownAppVisibilityController.appRemovedOrHidden(this);
        this.mWmService.mTaskSnapshotController.onAppRemoved(this);
        this.waitingToShow = false;
        if (this.getDisplayContent().mClosingApps.contains(this)) {
            delayed = true;
        } else if (this.getDisplayContent().mAppTransition.isTransitionSet()) {
            this.getDisplayContent().mClosingApps.add(this);
            delayed = true;
        }
        if (this.mStartingData != null) {
            this.removeStartingWindow();
        }
        if (this.isSelfAnimating()) {
            this.getDisplayContent().mNoAnimationNotifyOnTransitionFinished.add(this.token);
        }
        TaskStack stack = this.getStack();
        if (delayed && !this.isEmpty()) {
            if (stack != null) {
                stack.mExitingAppTokens.add(this);
            }
            this.mIsExiting = true;
        } else {
            this.cancelAnimation();
            if (stack != null) {
                stack.mExitingAppTokens.remove(this);
            }
            this.removeIfPossible();
        }
        this.removed = true;
        this.stopFreezingScreen(true, true);
        DisplayContent dc = this.getDisplayContent();
        if (dc.mFocusedApp == this) {
            dc.setFocusedApp(null);
            this.mWmService.updateFocusedWindowLocked(0, true);
        }
        if (this.mLetterbox != null) {
            this.mLetterbox.destroy();
            this.mLetterbox = null;
        }
        if (!delayed) {
            this.updateReportedVisibilityLocked();
        }
        this.mRemovingFromDisplay = false;
    }

    void clearAnimatingFlags() {
        boolean wallpaperMightChange = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            wallpaperMightChange |= win.clearAnimatingFlags();
        }
        if (wallpaperMightChange) {
            this.requestUpdateWallpaperIfNeeded();
        }
    }

    void destroySurfaces() {
        this.destroySurfaces(false);
    }

    private void destroySurfaces(boolean cleanupOnResume) {
        boolean destroyedSomething = false;
        ArrayList children = new ArrayList(this.mChildren);
        for (int i = children.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)children.get(i);
            destroyedSomething |= win.destroySurface(cleanupOnResume, this.mAppStopped);
        }
        if (destroyedSomething) {
            DisplayContent dc = this.getDisplayContent();
            dc.assignWindowLayers(true);
            this.updateLetterboxSurface(null);
        }
    }

    void notifyAppResumed(boolean wasStopped) {
        this.mAppStopped = false;
        this.setCanTurnScreenOn(true);
        if (!wasStopped) {
            this.destroySurfaces(true);
        }
    }

    void notifyAppStopped() {
        this.mAppStopped = true;
        this.destroySurfaces();
        this.removeStartingWindow();
    }

    void clearAllDrawn() {
        this.allDrawn = false;
        this.deferClearAllDrawn = false;
    }

    Task getTask() {
        return (Task)this.getParent();
    }

    TaskStack getStack() {
        Task task = this.getTask();
        if (task != null) {
            return task.mStack;
        }
        return null;
    }

    @Override
    void onParentChanged() {
        super.onParentChanged();
        Task task = this.getTask();
        if (!this.mReparenting) {
            if (task == null) {
                this.getDisplayContent().mClosingApps.remove(this);
            } else if (this.mLastParent != null && this.mLastParent.mStack != null) {
                task.mStack.mExitingAppTokens.remove(this);
            }
        }
        TaskStack stack = this.getStack();
        if (this.mAnimatingAppWindowTokenRegistry != null) {
            this.mAnimatingAppWindowTokenRegistry.notifyFinished(this);
        }
        this.mAnimatingAppWindowTokenRegistry = stack != null ? stack.getAnimatingAppWindowTokenRegistry() : null;
        this.mLastParent = task;
        this.updateColorTransform();
    }

    void postWindowRemoveStartingWindowCleanup(WindowState win) {
        if (this.startingWindow == win) {
            this.removeStartingWindow();
        } else if (this.mChildren.size() == 0) {
            this.mStartingData = null;
            if (this.mHiddenSetFromTransferredStartingWindow) {
                this.setHidden(true);
            }
        } else if (this.mChildren.size() == 1 && this.startingSurface != null && !this.isRelaunching()) {
            this.removeStartingWindow();
        }
    }

    void removeDeadWindows() {
        for (int winNdx = this.mChildren.size() - 1; winNdx >= 0; --winNdx) {
            WindowState win = (WindowState)this.mChildren.get(winNdx);
            if (!win.mAppDied) continue;
            win.mDestroying = true;
            win.removeIfPossible();
        }
    }

    boolean hasWindowsAlive() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if (((WindowState)this.mChildren.get((int)i)).mAppDied) continue;
            return true;
        }
        return false;
    }

    void setWillReplaceWindows(boolean animate) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.setWillReplaceWindow(animate);
        }
    }

    void setWillReplaceChildWindows() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.setWillReplaceChildWindows();
        }
    }

    void clearWillReplaceWindows() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.clearWillReplaceWindow();
        }
    }

    void requestUpdateWallpaperIfNeeded() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.requestUpdateWallpaperIfNeeded();
        }
    }

    boolean isRelaunching() {
        return this.mPendingRelaunchCount > 0;
    }

    boolean shouldFreezeBounds() {
        Task task = this.getTask();
        if (task == null || task.inFreeformWindowingMode()) {
            return false;
        }
        return this.getTask().isDragResizing();
    }

    void startRelaunching() {
        if (this.shouldFreezeBounds()) {
            this.freezeBounds();
        }
        this.detachChildren();
        ++this.mPendingRelaunchCount;
    }

    void detachChildren() {
        SurfaceControl.openTransaction();
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.mWinAnimator.detachChildren();
        }
        SurfaceControl.closeTransaction();
    }

    void finishRelaunching() {
        this.unfreezeBounds();
        if (this.mPendingRelaunchCount > 0) {
            --this.mPendingRelaunchCount;
        } else {
            this.checkKeyguardFlagsChanged();
        }
    }

    void clearRelaunching() {
        if (this.mPendingRelaunchCount == 0) {
            return;
        }
        this.unfreezeBounds();
        this.mPendingRelaunchCount = 0;
    }

    @Override
    protected boolean isFirstChildWindowGreaterThanSecond(WindowState newWindow, WindowState existingWindow) {
        int type1 = newWindow.mAttrs.type;
        int type2 = existingWindow.mAttrs.type;
        if (type1 == 1 && type2 != 1) {
            return false;
        }
        if (type1 != 1 && type2 == 1) {
            return true;
        }
        if (type1 == 3 && type2 != 3) {
            return true;
        }
        return type1 == 3 || type2 != 3;
    }

    @Override
    void addWindow(WindowState w) {
        super.addWindow(w);
        boolean gotReplacementWindow = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState candidate = (WindowState)this.mChildren.get(i);
            gotReplacementWindow |= candidate.setReplacementWindowIfNeeded(w);
        }
        if (gotReplacementWindow) {
            this.mWmService.scheduleWindowReplacementTimeouts(this);
        }
        this.checkKeyguardFlagsChanged();
    }

    @Override
    void removeChild(WindowState child) {
        if (!this.mChildren.contains(child)) {
            return;
        }
        super.removeChild(child);
        this.checkKeyguardFlagsChanged();
        this.updateLetterboxSurface(child);
    }

    private boolean waitingForReplacement() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState candidate = (WindowState)this.mChildren.get(i);
            if (!candidate.waitingForReplacement()) continue;
            return true;
        }
        return false;
    }

    void onWindowReplacementTimeout() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((WindowState)this.mChildren.get(i)).onWindowReplacementTimeout();
        }
    }

    void reparent(Task task, int position) {
        if (task == null) {
            throw new IllegalArgumentException("reparent: could not find task");
        }
        Task currentTask = this.getTask();
        if (task == currentTask) {
            throw new IllegalArgumentException("window token=" + this + " already child of task=" + currentTask);
        }
        if (currentTask.mStack != task.mStack) {
            throw new IllegalArgumentException("window token=" + this + " current task=" + currentTask + " belongs to a different stack than " + task);
        }
        DisplayContent prevDisplayContent = this.getDisplayContent();
        this.mReparenting = true;
        this.getParent().removeChild(this);
        task.addChild(this, position);
        this.mReparenting = false;
        DisplayContent displayContent = task.getDisplayContent();
        displayContent.setLayoutNeeded();
        if (prevDisplayContent != displayContent) {
            this.onDisplayChanged(displayContent);
            prevDisplayContent.setLayoutNeeded();
        }
        this.getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
    }

    @Override
    void onDisplayChanged(DisplayContent dc) {
        DisplayContent prevDc = this.mDisplayContent;
        super.onDisplayChanged(dc);
        if (prevDc == null || prevDc == this.mDisplayContent) {
            return;
        }
        if (prevDc.mOpeningApps.remove(this)) {
            this.mDisplayContent.mOpeningApps.add(this);
            this.mDisplayContent.prepareAppTransition(prevDc.mAppTransition.getAppTransition(), true);
            this.mDisplayContent.executeAppTransition();
        }
        if (prevDc.mChangingApps.remove(this)) {
            this.clearChangeLeash(this.getPendingTransaction(), true);
        }
        prevDc.mClosingApps.remove(this);
        if (prevDc.mFocusedApp == this) {
            Task task;
            prevDc.setFocusedApp(null);
            TaskStack stack = dc.getTopStack();
            if (stack != null && (task = (Task)stack.getTopChild()) != null && task.getTopChild() == this) {
                dc.setFocusedApp(this);
            }
        }
        if (this.mLetterbox != null) {
            this.mLetterbox.onMovedToDisplay(this.mDisplayContent.getDisplayId());
        }
    }

    private void freezeBounds() {
        Task task = this.getTask();
        this.mFrozenBounds.offer(new Rect(task.mPreparedFrozenBounds));
        if (task.mPreparedFrozenMergedConfig.equals(Configuration.EMPTY)) {
            this.mFrozenMergedConfig.offer(new Configuration(task.getConfiguration()));
        } else {
            this.mFrozenMergedConfig.offer(new Configuration(task.mPreparedFrozenMergedConfig));
        }
        task.mPreparedFrozenMergedConfig.unset();
    }

    private void unfreezeBounds() {
        if (this.mFrozenBounds.isEmpty()) {
            return;
        }
        this.mFrozenBounds.remove();
        if (!this.mFrozenMergedConfig.isEmpty()) {
            this.mFrozenMergedConfig.remove();
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            win.onUnfreezeBounds();
        }
        this.mWmService.mWindowPlacerLocked.performSurfacePlacement();
    }

    void setAppLayoutChanges(int changes, String reason) {
        if (!this.mChildren.isEmpty()) {
            DisplayContent dc = this.getDisplayContent();
            dc.pendingLayoutChanges |= changes;
        }
    }

    void removeReplacedWindowIfNeeded(WindowState replacement) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            if (!win.removeReplacedWindowIfNeeded(replacement)) continue;
            return;
        }
    }

    void startFreezingScreen() {
        if (!this.hiddenRequested) {
            if (!this.mFreezingScreen) {
                this.mFreezingScreen = true;
                this.mWmService.registerAppFreezeListener(this);
                ++this.mWmService.mAppsFreezingScreen;
                if (this.mWmService.mAppsFreezingScreen == 1) {
                    this.mWmService.startFreezingDisplayLocked(0, 0, this.getDisplayContent());
                    this.mWmService.mH.removeMessages(17);
                    this.mWmService.mH.sendEmptyMessageDelayed(17, 2000L);
                }
            }
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                WindowState w = (WindowState)this.mChildren.get(i);
                w.onStartFreezingScreen();
            }
        }
    }

    void stopFreezingScreen(boolean unfreezeSurfaceNow, boolean force) {
        if (!this.mFreezingScreen) {
            return;
        }
        int count = this.mChildren.size();
        boolean unfrozeWindows = false;
        for (int i = 0; i < count; ++i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            unfrozeWindows |= w.onStopFreezingScreen();
        }
        if (force || unfrozeWindows) {
            this.mFreezingScreen = false;
            this.mWmService.unregisterAppFreezeListener(this);
            --this.mWmService.mAppsFreezingScreen;
            this.mWmService.mLastFinishedFreezeSource = this;
        }
        if (unfreezeSurfaceNow) {
            if (unfrozeWindows) {
                this.mWmService.mWindowPlacerLocked.performSurfacePlacement();
            }
            this.mWmService.stopFreezingDisplayLocked();
        }
    }

    @Override
    public void onAppFreezeTimeout() {
        Slog.w(TAG, "Force clearing freeze: " + this);
        this.stopFreezingScreen(true, true);
    }

    void transferStartingWindowFromHiddenAboveTokenIfNeeded() {
        Task task = this.getTask();
        for (int i = task.mChildren.size() - 1; i >= 0; --i) {
            AppWindowToken fromToken = (AppWindowToken)task.mChildren.get(i);
            if (fromToken == this) {
                return;
            }
            if (!fromToken.hiddenRequested || !this.transferStartingWindow(fromToken.token)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean transferStartingWindow(IBinder transferFrom) {
        AppWindowToken fromToken = this.getDisplayContent().getAppWindowToken(transferFrom);
        if (fromToken == null) {
            return false;
        }
        WindowState tStartingWindow = fromToken.startingWindow;
        if (tStartingWindow != null && fromToken.startingSurface != null) {
            this.getDisplayContent().mSkipAppTransitionAnimation = true;
            long origId = Binder.clearCallingIdentity();
            try {
                this.mStartingData = fromToken.mStartingData;
                this.startingSurface = fromToken.startingSurface;
                this.startingDisplayed = fromToken.startingDisplayed;
                fromToken.startingDisplayed = false;
                this.startingWindow = tStartingWindow;
                this.reportedVisible = fromToken.reportedVisible;
                fromToken.mStartingData = null;
                fromToken.startingSurface = null;
                fromToken.startingWindow = null;
                fromToken.startingMoved = true;
                tStartingWindow.mToken = this;
                tStartingWindow.mAppToken = this;
                fromToken.removeChild(tStartingWindow);
                fromToken.postWindowRemoveStartingWindowCleanup(tStartingWindow);
                fromToken.mHiddenSetFromTransferredStartingWindow = false;
                this.addWindow(tStartingWindow);
                if (fromToken.allDrawn) {
                    this.allDrawn = true;
                    this.deferClearAllDrawn = fromToken.deferClearAllDrawn;
                }
                if (fromToken.firstWindowDrawn) {
                    this.firstWindowDrawn = true;
                }
                if (!fromToken.isHidden()) {
                    this.setHidden(false);
                    this.hiddenRequested = false;
                    this.mHiddenSetFromTransferredStartingWindow = true;
                }
                this.setClientHidden(fromToken.mClientHidden);
                this.transferAnimation(fromToken);
                this.mUseTransferredAnimation = true;
                this.mWmService.updateFocusedWindowLocked(3, true);
                this.getDisplayContent().setLayoutNeeded();
                this.mWmService.mWindowPlacerLocked.performSurfacePlacement();
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
            return true;
        }
        if (fromToken.mStartingData != null) {
            this.mStartingData = fromToken.mStartingData;
            fromToken.mStartingData = null;
            fromToken.startingMoved = true;
            this.scheduleAddStartingWindow();
            return true;
        }
        return false;
    }

    boolean isLastWindow(WindowState win) {
        return this.mChildren.size() == 1 && this.mChildren.get(0) == win;
    }

    @Override
    void onAppTransitionDone() {
        this.sendingToBottom = false;
    }

    @Override
    int getOrientation(int candidate) {
        if (candidate == 3) {
            return this.mOrientation;
        }
        if (!this.sendingToBottom && !this.getDisplayContent().mClosingApps.contains(this) && (this.isVisible() || this.getDisplayContent().mOpeningApps.contains(this))) {
            return this.mOrientation;
        }
        return -2;
    }

    int getOrientationIgnoreVisibility() {
        return this.mOrientation;
    }

    boolean inSizeCompatMode() {
        return this.mSizeCompatBounds != null;
    }

    @Override
    float getSizeCompatScale() {
        return this.inSizeCompatMode() ? this.mSizeCompatScale : super.getSizeCompatScale();
    }

    Rect getResolvedOverrideBounds() {
        return this.getResolvedOverrideConfiguration().windowConfiguration.getBounds();
    }

    @Override
    public void onConfigurationChanged(Configuration newParentConfig) {
        int winMode;
        int prevWinMode = this.getWindowingMode();
        this.mTmpPrevBounds.set(this.getBounds());
        super.onConfigurationChanged(newParentConfig);
        Task task = this.getTask();
        Rect overrideBounds = this.getResolvedOverrideBounds();
        if (!(task == null || overrideBounds.isEmpty() || task.mTaskRecord != null && task.mTaskRecord.getConfiguration().orientation != newParentConfig.orientation)) {
            Rect taskBounds = task.getBounds();
            if (overrideBounds.width() != taskBounds.width() || overrideBounds.height() > taskBounds.height()) {
                this.calculateCompatBoundsTransformation(newParentConfig);
                this.updateSurfacePosition();
            } else if (this.mSizeCompatBounds != null) {
                this.mSizeCompatBounds = null;
                this.mSizeCompatScale = 1.0f;
                this.updateSurfacePosition();
            }
        }
        if (prevWinMode == (winMode = this.getWindowingMode())) {
            return;
        }
        if (prevWinMode != 0 && winMode == 2) {
            this.mDisplayContent.mPinnedStackControllerLocked.resetReentrySnapFraction(this);
        } else if (prevWinMode == 2 && winMode != 0 && !this.isHidden()) {
            TaskStack pinnedStack = this.mDisplayContent.getPinnedStack();
            if (pinnedStack != null) {
                Rect stackBounds;
                if (pinnedStack.lastAnimatingBoundsWasToFullscreen()) {
                    stackBounds = pinnedStack.mPreAnimationBounds;
                } else {
                    stackBounds = this.mTmpRect;
                    pinnedStack.getBounds(stackBounds);
                }
                this.mDisplayContent.mPinnedStackControllerLocked.saveReentrySnapFraction(this, stackBounds);
            }
        } else if (this.shouldStartChangeTransition(prevWinMode, winMode)) {
            this.initializeChangeTransition(this.mTmpPrevBounds);
        }
    }

    private boolean shouldStartChangeTransition(int prevWinMode, int newWinMode) {
        if (this.mWmService.mDisableTransitionAnimation || !this.isVisible() || this.getDisplayContent().mAppTransition.isTransitionSet() || this.getSurfaceControl() == null) {
            return false;
        }
        return prevWinMode == 5 != (newWinMode == 5);
    }

    private void initializeChangeTransition(Rect startBounds) {
        SurfaceControl.ScreenshotGraphicBuffer snapshot;
        this.mDisplayContent.prepareAppTransition(27, false, 0, false);
        this.mDisplayContent.mChangingApps.add(this);
        this.mTransitStartRect.set(startBounds);
        SurfaceControl.Builder builder = this.makeAnimationLeash().setParent(this.getAnimationLeashParent()).setName(this.getSurfaceControl() + " - interim-change-leash");
        this.mTransitChangeLeash = builder.build();
        SurfaceControl.Transaction t = this.getPendingTransaction();
        t.setWindowCrop(this.mTransitChangeLeash, startBounds.width(), startBounds.height());
        t.setPosition(this.mTransitChangeLeash, startBounds.left, startBounds.top);
        t.show(this.mTransitChangeLeash);
        t.reparent(this.getSurfaceControl(), this.mTransitChangeLeash);
        this.onAnimationLeashCreated(t, this.mTransitChangeLeash);
        ArraySet<Integer> activityTypes = new ArraySet<Integer>();
        activityTypes.add(this.getActivityType());
        RemoteAnimationAdapter adapter = this.mDisplayContent.mAppTransitionController.getRemoteAnimationOverride(this, 27, activityTypes);
        if (adapter != null && !adapter.getChangeNeedsSnapshot()) {
            return;
        }
        Task task = this.getTask();
        if (this.mThumbnail == null && task != null && !this.hasCommittedReparentToAnimationLeash() && (snapshot = this.mWmService.mTaskSnapshotController.createTaskSnapshot(task, 1.0f)) != null) {
            this.mThumbnail = new AppWindowThumbnail(t, this, snapshot.getGraphicBuffer(), true);
        }
    }

    boolean isInChangeTransition() {
        return this.mTransitChangeLeash != null || AppTransition.isChangeTransit(this.mTransit);
    }

    @VisibleForTesting
    AppWindowThumbnail getThumbnail() {
        return this.mThumbnail;
    }

    private void calculateCompatBoundsTransformation(Configuration newParentConfig) {
        Rect parentAppBounds = newParentConfig.windowConfiguration.getAppBounds();
        Rect parentBounds = newParentConfig.windowConfiguration.getBounds();
        Rect viewportBounds = parentAppBounds != null ? parentAppBounds : parentBounds;
        Rect appBounds = this.getWindowConfiguration().getAppBounds();
        Rect contentBounds = appBounds != null ? appBounds : this.getResolvedOverrideBounds();
        float contentW = contentBounds.width();
        float contentH = contentBounds.height();
        float viewportW = viewportBounds.width();
        float viewportH = viewportBounds.height();
        this.mSizeCompatScale = contentW <= viewportW && contentH <= viewportH ? 1.0f : Math.min(viewportW / contentW, viewportH / contentH);
        int offsetX = (int)((viewportW - contentW * this.mSizeCompatScale + 1.0f) * 0.5f) + viewportBounds.left;
        if (this.mSizeCompatBounds == null) {
            this.mSizeCompatBounds = new Rect();
        }
        this.mSizeCompatBounds.set(contentBounds);
        this.mSizeCompatBounds.offsetTo(0, 0);
        this.mSizeCompatBounds.scale(this.mSizeCompatScale);
        this.mSizeCompatBounds.top = parentBounds.top;
        this.mSizeCompatBounds.bottom += viewportBounds.top;
        this.mSizeCompatBounds.left += offsetX;
        this.mSizeCompatBounds.right += offsetX;
    }

    @Override
    public Rect getBounds() {
        if (this.mSizeCompatBounds != null) {
            return this.mSizeCompatBounds;
        }
        return super.getBounds();
    }

    @Override
    public boolean matchParentBounds() {
        if (super.matchParentBounds()) {
            return true;
        }
        WindowContainer parent = this.getParent();
        return parent == null || parent.getBounds().equals(this.getResolvedOverrideBounds());
    }

    @Override
    void checkAppWindowsReadyToShow() {
        if (this.allDrawn == this.mLastAllDrawn) {
            return;
        }
        this.mLastAllDrawn = this.allDrawn;
        if (!this.allDrawn) {
            return;
        }
        if (this.mFreezingScreen) {
            this.showAllWindowsLocked();
            this.stopFreezingScreen(false, true);
            this.setAppLayoutChanges(4, "checkAppWindowsReadyToShow: freezingScreen");
        } else {
            this.setAppLayoutChanges(8, "checkAppWindowsReadyToShow");
            if (!this.getDisplayContent().mOpeningApps.contains(this) && this.canShowWindows()) {
                this.showAllWindowsLocked();
            }
        }
    }

    private boolean allDrawnStatesConsidered() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState child = (WindowState)this.mChildren.get(i);
            if (!child.mightAffectAllDrawn() || child.getDrawnStateEvaluated()) continue;
            return false;
        }
        return true;
    }

    void updateAllDrawn() {
        int numInteresting;
        if (!this.allDrawn && (numInteresting = this.mNumInterestingWindows) > 0 && this.allDrawnStatesConsidered() && this.mNumDrawnWindows >= numInteresting && !this.isRelaunching()) {
            this.allDrawn = true;
            if (this.mDisplayContent != null) {
                this.mDisplayContent.setLayoutNeeded();
            }
            this.mWmService.mH.obtainMessage(32, this.token).sendToTarget();
            TaskStack pinnedStack = this.mDisplayContent.getPinnedStack();
            if (pinnedStack != null) {
                pinnedStack.onAllWindowsDrawn();
            }
        }
    }

    boolean keyDispatchingTimedOut(String reason, int windowPid) {
        return this.mActivityRecord != null && this.mActivityRecord.keyDispatchingTimedOut(reason, windowPid);
    }

    boolean updateDrawnWindowStates(WindowState w) {
        w.setDrawnStateEvaluated(true);
        if (this.allDrawn && !this.mFreezingScreen) {
            return false;
        }
        if (this.mLastTransactionSequence != (long)this.mWmService.mTransactionSequence) {
            this.mLastTransactionSequence = this.mWmService.mTransactionSequence;
            this.mNumDrawnWindows = 0;
            this.startingDisplayed = false;
            this.mNumInterestingWindows = this.findMainWindow(false) != null ? 1 : 0;
        }
        WindowStateAnimator winAnimator = w.mWinAnimator;
        boolean isInterestingAndDrawn = false;
        if (!this.allDrawn && w.mightAffectAllDrawn()) {
            if (w != this.startingWindow) {
                if (w.isInteresting()) {
                    if (this.findMainWindow(false) != w) {
                        ++this.mNumInterestingWindows;
                    }
                    if (w.isDrawnLw()) {
                        ++this.mNumDrawnWindows;
                        isInterestingAndDrawn = true;
                    }
                }
            } else if (w.isDrawnLw()) {
                if (this.mActivityRecord != null) {
                    this.mActivityRecord.onStartingWindowDrawn(SystemClock.uptimeMillis());
                }
                this.startingDisplayed = true;
            }
        }
        return isInterestingAndDrawn;
    }

    void layoutLetterbox(WindowState winHint) {
        boolean needsLetterbox;
        WindowState w = this.findMainWindow();
        if (w == null || winHint != null && w != winHint) {
            return;
        }
        boolean surfaceReady = w.isDrawnLw() || w.mWinAnimator.mSurfaceDestroyDeferred || w.isDragResizeChanged();
        boolean bl = needsLetterbox = surfaceReady && w.isLetterboxedAppWindow() && this.fillsParent();
        if (needsLetterbox) {
            if (this.mLetterbox == null) {
                this.mLetterbox = new Letterbox(() -> this.makeChildSurface(null));
                this.mLetterbox.attachInput(w);
            }
            this.getPosition(this.mTmpPoint);
            Rect spaceToFill = this.inMultiWindowMode() || this.getStack() == null ? this.getTask().getDisplayedBounds() : this.getStack().getDisplayedBounds();
            this.mLetterbox.layout(spaceToFill, w.getFrameLw(), this.mTmpPoint);
        } else if (this.mLetterbox != null) {
            this.mLetterbox.hide();
        }
    }

    void updateLetterboxSurface(WindowState winHint) {
        WindowState w = this.findMainWindow();
        if (w != winHint && winHint != null && w != null) {
            return;
        }
        this.layoutLetterbox(winHint);
        if (this.mLetterbox != null && this.mLetterbox.needsApplySurfaceChanges()) {
            this.mLetterbox.applySurfaceChanges(this.getPendingTransaction());
        }
    }

    @Override
    boolean forAllWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        if (this.mIsExiting && !this.waitingForReplacement()) {
            return false;
        }
        return this.forAllWindowsUnchecked(callback, traverseTopToBottom);
    }

    @Override
    void forAllAppWindows(Consumer<AppWindowToken> callback) {
        callback.accept(this);
    }

    boolean forAllWindowsUnchecked(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        return super.forAllWindows(callback, traverseTopToBottom);
    }

    @Override
    AppWindowToken asAppWindowToken() {
        return this;
    }

    boolean addStartingWindow(String pkg, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int logo, int windowFlags, IBinder transferFrom, boolean newTask, boolean taskSwitch, boolean processRunning, boolean allowTaskSnapshot, boolean activityCreated, boolean fromRecents) {
        if (!this.okToDisplay()) {
            return false;
        }
        if (this.mStartingData != null) {
            return false;
        }
        WindowState mainWin = this.findMainWindow();
        if (mainWin != null && mainWin.mWinAnimator.getShown()) {
            return false;
        }
        ActivityManager.TaskSnapshot snapshot = this.mWmService.mTaskSnapshotController.getSnapshot(this.getTask().mTaskId, this.getTask().mUserId, false, false);
        int type = this.getStartingWindowType(newTask, taskSwitch, processRunning, allowTaskSnapshot, activityCreated, fromRecents, snapshot);
        if (type == 1) {
            return this.createSnapshot(snapshot);
        }
        if (theme != 0) {
            AttributeCache.Entry ent = AttributeCache.instance().get(pkg, theme, R.styleable.Window, this.mWmService.mCurrentUserId);
            if (ent == null) {
                return false;
            }
            boolean windowIsTranslucent = ent.array.getBoolean(5, false);
            boolean windowIsFloating = ent.array.getBoolean(4, false);
            boolean windowShowWallpaper = ent.array.getBoolean(14, false);
            boolean windowDisableStarting = ent.array.getBoolean(12, false);
            if (windowIsTranslucent) {
                return false;
            }
            if (windowIsFloating || windowDisableStarting) {
                return false;
            }
            if (windowShowWallpaper) {
                if (this.getDisplayContent().mWallpaperController.getWallpaperTarget() == null) {
                    windowFlags |= 0x100000;
                } else {
                    return false;
                }
            }
        }
        if (this.transferStartingWindow(transferFrom)) {
            return true;
        }
        if (type != 2) {
            return false;
        }
        this.mStartingData = new SplashScreenStartingData(this.mWmService, pkg, theme, compatInfo, nonLocalizedLabel, labelRes, icon, logo, windowFlags, this.getMergedOverrideConfiguration());
        this.scheduleAddStartingWindow();
        return true;
    }

    private boolean createSnapshot(ActivityManager.TaskSnapshot snapshot) {
        if (snapshot == null) {
            return false;
        }
        this.mStartingData = new SnapshotStartingData(this.mWmService, snapshot);
        this.scheduleAddStartingWindow();
        return true;
    }

    void scheduleAddStartingWindow() {
        if (!this.mWmService.mAnimationHandler.hasCallbacks(this.mAddStartingWindow)) {
            this.mWmService.mAnimationHandler.postAtFrontOfQueue(this.mAddStartingWindow);
        }
    }

    private int getStartingWindowType(boolean newTask, boolean taskSwitch, boolean processRunning, boolean allowTaskSnapshot, boolean activityCreated, boolean fromRecents, ActivityManager.TaskSnapshot snapshot) {
        if (this.getDisplayContent().mAppTransition.getAppTransition() == 19) {
            return 0;
        }
        if (newTask || !processRunning || taskSwitch && !activityCreated) {
            return 2;
        }
        if (taskSwitch && allowTaskSnapshot) {
            if (this.mWmService.mLowRamTaskSnapshotsAndRecents) {
                return 2;
            }
            return snapshot == null ? 0 : (this.snapshotOrientationSameAsTask(snapshot) || fromRecents ? 1 : 2);
        }
        return 0;
    }

    private boolean snapshotOrientationSameAsTask(ActivityManager.TaskSnapshot snapshot) {
        if (snapshot == null) {
            return false;
        }
        return this.getTask().getConfiguration().orientation == snapshot.getOrientation();
    }

    void removeStartingWindow() {
        WindowManagerPolicy.StartingSurface surface;
        if (this.startingWindow == null) {
            if (this.mStartingData != null) {
                this.mStartingData = null;
            }
            return;
        }
        if (this.mStartingData != null) {
            surface = this.startingSurface;
            this.mStartingData = null;
            this.startingSurface = null;
            this.startingWindow = null;
            this.startingDisplayed = false;
            if (surface == null) {
                return;
            }
        } else {
            return;
        }
        this.mWmService.mAnimationHandler.post(() -> {
            try {
                surface.remove();
            }
            catch (Exception e) {
                Slog.w(TAG, "Exception when removing starting window", e);
            }
        });
    }

    @Override
    boolean fillsParent() {
        return this.mFillsParent;
    }

    void setFillsParent(boolean fillsParent) {
        this.mFillsParent = fillsParent;
    }

    boolean containsDismissKeyguardWindow() {
        if (this.isRelaunching()) {
            return this.mLastContainsDismissKeyguardWindow;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if ((((WindowState)this.mChildren.get((int)i)).mAttrs.flags & 0x400000) == 0) continue;
            return true;
        }
        return false;
    }

    boolean containsShowWhenLockedWindow() {
        if (this.isRelaunching()) {
            return this.mLastContainsShowWhenLockedWindow;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if ((((WindowState)this.mChildren.get((int)i)).mAttrs.flags & 0x80000) == 0) continue;
            return true;
        }
        return false;
    }

    void checkKeyguardFlagsChanged() {
        boolean containsDismissKeyguard = this.containsDismissKeyguardWindow();
        boolean containsShowWhenLocked = this.containsShowWhenLockedWindow();
        if (containsDismissKeyguard != this.mLastContainsDismissKeyguardWindow || containsShowWhenLocked != this.mLastContainsShowWhenLockedWindow) {
            this.mWmService.notifyKeyguardFlagsChanged(null, this.getDisplayContent().getDisplayId());
        }
        this.mLastContainsDismissKeyguardWindow = containsDismissKeyguard;
        this.mLastContainsShowWhenLockedWindow = containsShowWhenLocked;
    }

    WindowState getImeTargetBelowWindow(WindowState w) {
        WindowState target;
        int index = this.mChildren.indexOf(w);
        if (index > 0 && (target = (WindowState)this.mChildren.get(index - 1)).canBeImeTarget()) {
            return target;
        }
        return null;
    }

    WindowState getHighestAnimLayerWindow(WindowState currentTarget) {
        WindowState candidate = null;
        for (int i = this.mChildren.indexOf(currentTarget); i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            if (w.mRemoved || candidate != null) continue;
            candidate = w;
        }
        return candidate;
    }

    void setDisablePreviewScreenshots(boolean disable) {
        this.mDisablePreviewScreenshots = disable;
    }

    void setCanTurnScreenOn(boolean canTurnScreenOn) {
        this.mCanTurnScreenOn = canTurnScreenOn;
    }

    boolean canTurnScreenOn() {
        return this.mCanTurnScreenOn;
    }

    boolean shouldUseAppThemeSnapshot() {
        return this.mDisablePreviewScreenshots || this.forAllWindows((WindowState w) -> (w.mAttrs.flags & 0x2000) != 0, true);
    }

    SurfaceControl getAppAnimationLayer() {
        return this.getAppAnimationLayer(this.isActivityTypeHome() ? 2 : (this.needsZBoost() ? 1 : 0));
    }

    @Override
    public SurfaceControl getAnimationLeashParent() {
        if (!this.inPinnedWindowingMode()) {
            return this.getAppAnimationLayer();
        }
        return this.getStack().getSurfaceControl();
    }

    @VisibleForTesting
    boolean shouldAnimate(int transit) {
        boolean isSplitScreenPrimary = this.getWindowingMode() == 3;
        boolean allowSplitScreenPrimaryAnimation = transit != 13;
        RecentsAnimationController controller = this.mWmService.getRecentsAnimationController();
        if (controller != null && controller.isAnimatingTask(this.getTask()) && controller.shouldCancelWithDeferredScreenshot()) {
            return false;
        }
        return !isSplitScreenPrimary || allowSplitScreenPrimaryAnimation;
    }

    private SurfaceControl createAnimationBoundsLayer(SurfaceControl.Transaction t) {
        SurfaceControl.Builder builder = this.makeAnimationLeash().setParent(this.getAnimationLeashParent()).setName(this.getSurfaceControl() + " - animation-bounds");
        SurfaceControl boundsLayer = builder.build();
        t.show(boundsLayer);
        return boundsLayer;
    }

    @Override
    Rect getDisplayedBounds() {
        Rect overrideDisplayedBounds;
        Task task = this.getTask();
        if (task != null && !(overrideDisplayedBounds = task.getOverrideDisplayedBounds()).isEmpty()) {
            return overrideDisplayedBounds;
        }
        return this.getBounds();
    }

    @VisibleForTesting
    Rect getAnimationBounds(int appStackClipMode) {
        if (appStackClipMode == 1 && this.getStack() != null) {
            return this.getStack().getBounds();
        }
        return this.getTask() != null ? this.getTask().getBounds() : this.getBounds();
    }

    boolean applyAnimationLocked(WindowManager.LayoutParams lp, int transit, boolean enter, boolean isVoiceInteraction) {
        if (this.mWmService.mDisableTransitionAnimation || !this.shouldAnimate(transit)) {
            this.cancelAnimation();
            return false;
        }
        Trace.traceBegin(32L, "AWT#applyAnimationLocked");
        if (this.okToAnimate()) {
            AnimationAdapter adapter;
            boolean isChanging;
            AnimationAdapter thumbnailAdapter = null;
            int appStackClipMode = this.getDisplayContent().mAppTransition.getAppStackClipMode();
            this.mTmpRect.set(this.getAnimationBounds(appStackClipMode));
            this.mTmpPoint.set(this.mTmpRect.left, this.mTmpRect.top);
            this.mTmpRect.offsetTo(0, 0);
            boolean bl = isChanging = AppTransition.isChangeTransit(transit) && enter && this.getDisplayContent().mChangingApps.contains(this);
            if (this.getDisplayContent().mAppTransition.getRemoteAnimationController() != null && !this.mSurfaceAnimator.isAnimationStartDelayed()) {
                RemoteAnimationController.RemoteAnimationRecord adapters = this.getDisplayContent().mAppTransition.getRemoteAnimationController().createRemoteAnimationRecord(this, this.mTmpPoint, this.mTmpRect, isChanging ? this.mTransitStartRect : null);
                adapter = adapters.mAdapter;
                thumbnailAdapter = adapters.mThumbnailAdapter;
            } else if (isChanging) {
                float durationScale = this.mWmService.getTransitionAnimationScaleLocked();
                this.mTmpRect.offsetTo(this.mTmpPoint.x, this.mTmpPoint.y);
                adapter = new LocalAnimationAdapter(new WindowChangeAnimationSpec(this.mTransitStartRect, this.mTmpRect, this.getDisplayContent().getDisplayInfo(), durationScale, true, false), this.mWmService.mSurfaceAnimationRunner);
                if (this.mThumbnail != null) {
                    thumbnailAdapter = new LocalAnimationAdapter(new WindowChangeAnimationSpec(this.mTransitStartRect, this.mTmpRect, this.getDisplayContent().getDisplayInfo(), durationScale, true, true), this.mWmService.mSurfaceAnimationRunner);
                }
                this.mTransit = transit;
                this.mTransitFlags = this.getDisplayContent().mAppTransition.getTransitFlags();
            } else {
                this.mNeedsAnimationBoundsLayer = appStackClipMode == 0;
                Animation a = this.loadAnimation(lp, transit, enter, isVoiceInteraction);
                if (a != null) {
                    float windowCornerRadius = !this.inMultiWindowMode() ? this.getDisplayContent().getWindowCornerRadius() : 0.0f;
                    adapter = new LocalAnimationAdapter(new WindowAnimationSpec(a, this.mTmpPoint, this.mTmpRect, this.getDisplayContent().mAppTransition.canSkipFirstFrame(), appStackClipMode, true, windowCornerRadius), this.mWmService.mSurfaceAnimationRunner);
                    if (a.getZAdjustment() == 1) {
                        this.mNeedsZBoost = true;
                    }
                    this.mTransit = transit;
                    this.mTransitFlags = this.getDisplayContent().mAppTransition.getTransitFlags();
                } else {
                    adapter = null;
                }
            }
            if (adapter != null) {
                this.startAnimation(this.getPendingTransaction(), adapter, !this.isVisible());
                if (adapter.getShowWallpaper()) {
                    this.mDisplayContent.pendingLayoutChanges |= 4;
                }
                if (thumbnailAdapter != null) {
                    this.mThumbnail.startAnimation(this.getPendingTransaction(), thumbnailAdapter, !this.isVisible());
                }
            }
        } else {
            this.cancelAnimation();
        }
        Trace.traceEnd(32L);
        return this.isReallyAnimating();
    }

    private Animation loadAnimation(WindowManager.LayoutParams lp, int transit, boolean enter, boolean isVoiceInteraction) {
        boolean freeform;
        DisplayContent displayContent = this.getTask().getDisplayContent();
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        int width = displayInfo.appWidth;
        int height = displayInfo.appHeight;
        WindowState win = this.findMainWindow();
        Rect frame = new Rect(0, 0, width, height);
        Rect displayFrame = new Rect(0, 0, displayInfo.logicalWidth, displayInfo.logicalHeight);
        Rect insets = new Rect();
        Rect stableInsets = new Rect();
        Rect surfaceInsets = null;
        boolean bl = freeform = win != null && win.inFreeformWindowingMode();
        if (win != null) {
            if (freeform) {
                frame.set(win.getFrameLw());
            } else if (win.isLetterboxedAppWindow()) {
                frame.set(this.getTask().getBounds());
            } else if (win.isDockedResizing()) {
                frame.set(this.getTask().getParent().getBounds());
            } else {
                frame.set(win.getContainingFrame());
            }
            surfaceInsets = win.getAttrs().surfaceInsets;
            win.getContentInsets(insets);
            win.getStableInsets(stableInsets);
        }
        if (this.mLaunchTaskBehind) {
            enter = false;
        }
        Configuration displayConfig = displayContent.getConfiguration();
        Animation a = this.getDisplayContent().mAppTransition.loadAnimation(lp, transit, enter, displayConfig.uiMode, displayConfig.orientation, frame, displayFrame, insets, surfaceInsets, stableInsets, isVoiceInteraction, freeform, this.getTask().mTaskId);
        if (a != null) {
            int containingWidth = frame.width();
            int containingHeight = frame.height();
            a.initialize(containingWidth, containingHeight, width, height);
            a.scaleCurrentDuration(this.mWmService.getTransitionAnimationScaleLocked());
        }
        return a;
    }

    @Override
    public boolean shouldDeferAnimationFinish(Runnable endDeferFinishCallback) {
        return this.mAnimatingAppWindowTokenRegistry != null && this.mAnimatingAppWindowTokenRegistry.notifyAboutToFinish(this, endDeferFinishCallback);
    }

    @Override
    public void onAnimationLeashLost(SurfaceControl.Transaction t) {
        super.onAnimationLeashLost(t);
        if (this.mAnimationBoundsLayer != null) {
            t.remove(this.mAnimationBoundsLayer);
            this.mAnimationBoundsLayer = null;
        }
        if (this.mAnimatingAppWindowTokenRegistry != null) {
            this.mAnimatingAppWindowTokenRegistry.notifyFinished(this);
        }
    }

    @Override
    protected void setLayer(SurfaceControl.Transaction t, int layer) {
        if (!this.mSurfaceAnimator.hasLeash()) {
            t.setLayer(this.mSurfaceControl, layer);
        }
    }

    @Override
    protected void setRelativeLayer(SurfaceControl.Transaction t, SurfaceControl relativeTo, int layer) {
        if (!this.mSurfaceAnimator.hasLeash()) {
            t.setRelativeLayer(this.mSurfaceControl, relativeTo, layer);
        }
    }

    @Override
    protected void reparentSurfaceControl(SurfaceControl.Transaction t, SurfaceControl newParent) {
        if (!this.mSurfaceAnimator.hasLeash()) {
            t.reparent(this.mSurfaceControl, newParent);
        }
    }

    @Override
    public void onAnimationLeashCreated(SurfaceControl.Transaction t, SurfaceControl leash) {
        int layer = 0;
        layer = !this.inPinnedWindowingMode() ? this.getPrefixOrderIndex() : this.getParent().getPrefixOrderIndex();
        if (this.mNeedsZBoost) {
            layer += 800570000;
        }
        if (!this.mNeedsAnimationBoundsLayer) {
            leash.setLayer(layer);
        }
        DisplayContent dc = this.getDisplayContent();
        dc.assignStackOrdering();
        if (leash == this.mTransitChangeLeash) {
            return;
        }
        if (this.mTransitChangeLeash != null) {
            this.clearChangeLeash(t, false);
        }
        if (this.mAnimatingAppWindowTokenRegistry != null) {
            this.mAnimatingAppWindowTokenRegistry.notifyStarting(this);
        }
        if (this.mNeedsAnimationBoundsLayer) {
            this.mTmpRect.setEmpty();
            Task task = this.getTask();
            if (this.getDisplayContent().mAppTransitionController.isTransitWithinTask(this.getTransit(), task)) {
                task.getBounds(this.mTmpRect);
            } else {
                TaskStack stack = this.getStack();
                if (stack == null) {
                    return;
                }
                stack.getBounds(this.mTmpRect);
            }
            this.mAnimationBoundsLayer = this.createAnimationBoundsLayer(t);
            t.setWindowCrop(this.mAnimationBoundsLayer, this.mTmpRect);
            t.setLayer(this.mAnimationBoundsLayer, layer);
            t.reparent(leash, this.mAnimationBoundsLayer);
        }
    }

    void showAllWindowsLocked() {
        this.forAllWindows((WindowState windowState) -> windowState.performShowLocked(), false);
    }

    @Override
    protected void onAnimationFinished() {
        super.onAnimationFinished();
        Trace.traceBegin(32L, "AWT#onAnimationFinished");
        this.mTransit = -1;
        this.mTransitFlags = 0;
        this.mNeedsZBoost = false;
        this.mNeedsAnimationBoundsLayer = false;
        this.setAppLayoutChanges(12, "AppWindowToken");
        this.clearThumbnail();
        this.setClientHidden(this.isHidden() && this.hiddenRequested);
        this.getDisplayContent().computeImeTargetIfNeeded(this);
        if (this.mThumbnail != null) {
            this.mThumbnail.destroy();
            this.mThumbnail = null;
        }
        ArrayList<WindowState> children = new ArrayList<WindowState>(this.mChildren);
        children.forEach(WindowState::onExitAnimationDone);
        this.getDisplayContent().mAppTransition.notifyAppTransitionFinishedLocked(this.token);
        this.scheduleAnimation();
        this.mActivityRecord.onAnimationFinished();
        Trace.traceEnd(32L);
    }

    @Override
    boolean isAppAnimating() {
        return this.isSelfAnimating();
    }

    @Override
    boolean isSelfAnimating() {
        return this.isWaitingForTransitionStart() || this.isReallyAnimating();
    }

    private boolean isReallyAnimating() {
        return super.isSelfAnimating();
    }

    private void clearChangeLeash(SurfaceControl.Transaction t, boolean cancel) {
        if (this.mTransitChangeLeash == null) {
            return;
        }
        if (cancel) {
            this.clearThumbnail();
            SurfaceControl sc = this.getSurfaceControl();
            SurfaceControl parentSc = this.getParentSurfaceControl();
            if (parentSc != null && sc != null) {
                t.reparent(sc, this.getParentSurfaceControl());
            }
        }
        t.hide(this.mTransitChangeLeash);
        t.remove(this.mTransitChangeLeash);
        this.mTransitChangeLeash = null;
        if (cancel) {
            this.onAnimationLeashLost(t);
        }
    }

    @Override
    void cancelAnimation() {
        this.cancelAnimationOnly();
        this.clearThumbnail();
        this.clearChangeLeash(this.getPendingTransaction(), true);
    }

    void cancelAnimationOnly() {
        super.cancelAnimation();
    }

    boolean isWaitingForTransitionStart() {
        return this.getDisplayContent().mAppTransition.isTransitionSet() && (this.getDisplayContent().mOpeningApps.contains(this) || this.getDisplayContent().mClosingApps.contains(this) || this.getDisplayContent().mChangingApps.contains(this));
    }

    public int getTransit() {
        return this.mTransit;
    }

    int getTransitFlags() {
        return this.mTransitFlags;
    }

    void attachThumbnailAnimation() {
        if (!this.isReallyAnimating()) {
            return;
        }
        int taskId = this.getTask().mTaskId;
        GraphicBuffer thumbnailHeader = this.getDisplayContent().mAppTransition.getAppTransitionThumbnailHeader(taskId);
        if (thumbnailHeader == null) {
            return;
        }
        this.clearThumbnail();
        this.mThumbnail = new AppWindowThumbnail(this.getPendingTransaction(), this, thumbnailHeader);
        this.mThumbnail.startAnimation(this.getPendingTransaction(), this.loadThumbnailAnimation(thumbnailHeader));
    }

    void attachCrossProfileAppsThumbnailAnimation() {
        Rect frame;
        if (!this.isReallyAnimating()) {
            return;
        }
        this.clearThumbnail();
        WindowState win = this.findMainWindow();
        if (win == null) {
            return;
        }
        int thumbnailDrawableRes = this.getTask().mUserId == this.mWmService.mCurrentUserId ? 17302280 : 17302360;
        GraphicBuffer thumbnail = this.getDisplayContent().mAppTransition.createCrossProfileAppsThumbnail(thumbnailDrawableRes, frame = win.getFrameLw());
        if (thumbnail == null) {
            return;
        }
        this.mThumbnail = new AppWindowThumbnail(this.getPendingTransaction(), this, thumbnail);
        Animation animation = this.getDisplayContent().mAppTransition.createCrossProfileAppsThumbnailAnimationLocked(win.getFrameLw());
        this.mThumbnail.startAnimation(this.getPendingTransaction(), animation, new Point(frame.left, frame.top));
    }

    private Animation loadThumbnailAnimation(GraphicBuffer thumbnailHeader) {
        DisplayInfo displayInfo = this.mDisplayContent.getDisplayInfo();
        WindowState win = this.findMainWindow();
        Rect appRect = win != null ? win.getContentFrameLw() : new Rect(0, 0, displayInfo.appWidth, displayInfo.appHeight);
        Rect insets = win != null ? win.getContentInsets() : null;
        Configuration displayConfig = this.mDisplayContent.getConfiguration();
        return this.getDisplayContent().mAppTransition.createThumbnailAspectScaleAnimationLocked(appRect, insets, thumbnailHeader, this.getTask().mTaskId, displayConfig.uiMode, displayConfig.orientation);
    }

    private void clearThumbnail() {
        if (this.mThumbnail == null) {
            return;
        }
        this.mThumbnail.destroy();
        this.mThumbnail = null;
    }

    void registerRemoteAnimations(RemoteAnimationDefinition definition) {
        this.mRemoteAnimationDefinition = definition;
    }

    RemoteAnimationDefinition getRemoteAnimationDefinition() {
        return this.mRemoteAnimationDefinition;
    }

    @Override
    void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        super.dump(pw, prefix, dumpAll);
        if (this.appToken != null) {
            pw.println(prefix + "app=true mVoiceInteraction=" + this.mVoiceInteraction);
        }
        pw.println(prefix + "component=" + this.mActivityComponent.flattenToShortString());
        pw.print(prefix);
        pw.print("task=");
        pw.println(this.getTask());
        pw.print(prefix);
        pw.print(" mFillsParent=");
        pw.print(this.mFillsParent);
        pw.print(" mOrientation=");
        pw.println(this.mOrientation);
        pw.println(prefix + "hiddenRequested=" + this.hiddenRequested + " mClientHidden=" + this.mClientHidden + (this.mDeferHidingClient ? " mDeferHidingClient=" + this.mDeferHidingClient : "") + " reportedDrawn=" + this.reportedDrawn + " reportedVisible=" + this.reportedVisible);
        if (this.paused) {
            pw.print(prefix);
            pw.print("paused=");
            pw.println(this.paused);
        }
        if (this.mAppStopped) {
            pw.print(prefix);
            pw.print("mAppStopped=");
            pw.println(this.mAppStopped);
        }
        if (this.mNumInterestingWindows != 0 || this.mNumDrawnWindows != 0 || this.allDrawn || this.mLastAllDrawn) {
            pw.print(prefix);
            pw.print("mNumInterestingWindows=");
            pw.print(this.mNumInterestingWindows);
            pw.print(" mNumDrawnWindows=");
            pw.print(this.mNumDrawnWindows);
            pw.print(" inPendingTransaction=");
            pw.print(this.inPendingTransaction);
            pw.print(" allDrawn=");
            pw.print(this.allDrawn);
            pw.print(" lastAllDrawn=");
            pw.print(this.mLastAllDrawn);
            pw.println(")");
        }
        if (this.inPendingTransaction) {
            pw.print(prefix);
            pw.print("inPendingTransaction=");
            pw.println(this.inPendingTransaction);
        }
        if (this.mStartingData != null || this.removed || this.firstWindowDrawn || this.mIsExiting) {
            pw.print(prefix);
            pw.print("startingData=");
            pw.print(this.mStartingData);
            pw.print(" removed=");
            pw.print(this.removed);
            pw.print(" firstWindowDrawn=");
            pw.print(this.firstWindowDrawn);
            pw.print(" mIsExiting=");
            pw.println(this.mIsExiting);
        }
        if (this.startingWindow != null || this.startingSurface != null || this.startingDisplayed || this.startingMoved || this.mHiddenSetFromTransferredStartingWindow) {
            pw.print(prefix);
            pw.print("startingWindow=");
            pw.print(this.startingWindow);
            pw.print(" startingSurface=");
            pw.print(this.startingSurface);
            pw.print(" startingDisplayed=");
            pw.print(this.startingDisplayed);
            pw.print(" startingMoved=");
            pw.print(this.startingMoved);
            pw.println(" mHiddenSetFromTransferredStartingWindow=" + this.mHiddenSetFromTransferredStartingWindow);
        }
        if (!this.mFrozenBounds.isEmpty()) {
            pw.print(prefix);
            pw.print("mFrozenBounds=");
            pw.println(this.mFrozenBounds);
            pw.print(prefix);
            pw.print("mFrozenMergedConfig=");
            pw.println(this.mFrozenMergedConfig);
        }
        if (this.mPendingRelaunchCount != 0) {
            pw.print(prefix);
            pw.print("mPendingRelaunchCount=");
            pw.println(this.mPendingRelaunchCount);
        }
        if (this.mSizeCompatScale != 1.0f || this.mSizeCompatBounds != null) {
            pw.println(prefix + "mSizeCompatScale=" + this.mSizeCompatScale + " mSizeCompatBounds=" + this.mSizeCompatBounds);
        }
        if (this.mRemovingFromDisplay) {
            pw.println(prefix + "mRemovingFromDisplay=" + this.mRemovingFromDisplay);
        }
    }

    @Override
    void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (hidden) {
            this.mDisplayContent.mPinnedStackControllerLocked.resetReentrySnapFraction(this);
        }
        this.scheduleAnimation();
    }

    @Override
    void prepareSurfaces() {
        boolean show;
        boolean reallyAnimating = super.isSelfAnimating();
        boolean bl = show = !this.isHidden() || reallyAnimating;
        if (this.mSurfaceControl != null) {
            if (show && !this.mLastSurfaceShowing) {
                this.getPendingTransaction().show(this.mSurfaceControl);
            } else if (!show && this.mLastSurfaceShowing) {
                this.getPendingTransaction().hide(this.mSurfaceControl);
            }
        }
        if (this.mThumbnail != null) {
            this.mThumbnail.setShowing(this.getPendingTransaction(), show);
        }
        this.mLastSurfaceShowing = show;
        super.prepareSurfaces();
    }

    boolean isSurfaceShowing() {
        return this.mLastSurfaceShowing;
    }

    boolean isFreezingScreen() {
        return this.mFreezingScreen;
    }

    @Override
    boolean needsZBoost() {
        return this.mNeedsZBoost || super.needsZBoost();
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, int logLevel) {
        if (logLevel == 2 && !this.isVisible()) {
            return;
        }
        long token = proto.start(fieldId);
        this.writeNameToProto(proto, 0x10900000001L);
        super.writeToProto(proto, 1146756268034L, logLevel);
        proto.write(1133871366147L, this.mLastSurfaceShowing);
        proto.write(1133871366148L, this.isWaitingForTransitionStart());
        proto.write(1133871366149L, this.isReallyAnimating());
        if (this.mThumbnail != null) {
            this.mThumbnail.writeToProto(proto, 1146756268038L);
        }
        proto.write(1133871366151L, this.mFillsParent);
        proto.write(0x10800000008L, this.mAppStopped);
        proto.write(1133871366153L, this.hiddenRequested);
        proto.write(1133871366154L, this.mClientHidden);
        proto.write(1133871366155L, this.mDeferHidingClient);
        proto.write(1133871366156L, this.reportedDrawn);
        proto.write(1133871366157L, this.reportedVisible);
        proto.write(1120986464270L, this.mNumInterestingWindows);
        proto.write(1120986464271L, this.mNumDrawnWindows);
        proto.write(0x10800000010L, this.allDrawn);
        proto.write(0x10800000011L, this.mLastAllDrawn);
        proto.write(1133871366162L, this.removed);
        if (this.startingWindow != null) {
            this.startingWindow.writeIdentifierToProto(proto, 1146756268051L);
        }
        proto.write(1133871366164L, this.startingDisplayed);
        proto.write(1133871366165L, this.startingMoved);
        proto.write(1133871366166L, this.mHiddenSetFromTransferredStartingWindow);
        for (Rect bounds : this.mFrozenBounds) {
            bounds.writeToProto(proto, 2246267895831L);
        }
        proto.end(token);
    }

    void writeNameToProto(ProtoOutputStream proto, long fieldId) {
        if (this.appToken == null) {
            return;
        }
        try {
            proto.write(fieldId, this.appToken.getName());
        }
        catch (RemoteException e) {
            Slog.e(TAG, e.toString());
        }
    }

    @Override
    public String toString() {
        if (this.stringName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("AppWindowToken{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" token=");
            sb.append(this.token);
            sb.append('}');
            this.stringName = sb.toString();
        }
        return this.stringName + (this.mIsExiting ? " mIsExiting=" : "");
    }

    Rect getLetterboxInsets() {
        if (this.mLetterbox != null) {
            return this.mLetterbox.getInsets();
        }
        return new Rect();
    }

    void getLetterboxInnerBounds(Rect outBounds) {
        if (this.mLetterbox != null) {
            outBounds.set(this.mLetterbox.getInnerFrame());
        } else {
            outBounds.setEmpty();
        }
    }

    boolean isLetterboxOverlappingWith(Rect rect) {
        return this.mLetterbox != null && this.mLetterbox.isOverlappingWith(rect);
    }

    void setWillCloseOrEnterPip(boolean willCloseOrEnterPip) {
        this.mWillCloseOrEnterPip = willCloseOrEnterPip;
    }

    boolean isClosingOrEnteringPip() {
        return this.isAnimating() && this.hiddenRequested || this.mWillCloseOrEnterPip;
    }

    boolean canShowWindows() {
        return this.allDrawn && (!this.isReallyAnimating() || !this.hasNonDefaultColorWindow());
    }

    private boolean hasNonDefaultColorWindow() {
        return this.forAllWindows((WindowState ws) -> ws.mAttrs.getColorMode() != 0, true);
    }

    private void updateColorTransform() {
        if (this.mSurfaceControl != null && this.mLastAppSaturationInfo != null) {
            this.getPendingTransaction().setColorTransform(this.mSurfaceControl, this.mLastAppSaturationInfo.mMatrix, this.mLastAppSaturationInfo.mTranslation);
            this.mWmService.scheduleAnimationLocked();
        }
    }

    private static class AppSaturationInfo {
        float[] mMatrix = new float[9];
        float[] mTranslation = new float[3];

        private AppSaturationInfo() {
        }

        void setSaturation(float[] matrix, float[] translation) {
            System.arraycopy(matrix, 0, this.mMatrix, 0, this.mMatrix.length);
            System.arraycopy(translation, 0, this.mTranslation, 0, this.mTranslation.length);
        }
    }
}

