/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.StatusBarManager;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.proto.ProtoOutputStream;
import com.android.server.LocalServices;
import com.android.server.UiThread;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.wm.PolicyControl;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;

public class BarController {
    private static final boolean DEBUG = false;
    private static final int TRANSIENT_BAR_NONE = 0;
    private static final int TRANSIENT_BAR_SHOW_REQUESTED = 1;
    private static final int TRANSIENT_BAR_SHOWING = 2;
    private static final int TRANSIENT_BAR_HIDING = 3;
    private static final int TRANSLUCENT_ANIMATION_DELAY_MS = 1000;
    private static final int MSG_NAV_BAR_VISIBILITY_CHANGED = 1;
    protected final String mTag;
    protected final int mDisplayId;
    private final int mTransientFlag;
    private final int mUnhideFlag;
    private final int mTranslucentFlag;
    private final int mTransparentFlag;
    private final int mStatusBarManagerId;
    private final int mTranslucentWmFlag;
    protected final Handler mHandler;
    private final Object mServiceAquireLock = new Object();
    private StatusBarManagerInternal mStatusBarInternal;
    protected WindowState mWin;
    private int mState = 0;
    private int mTransientBarState;
    private boolean mPendingShow;
    private long mLastTranslucent;
    private boolean mShowTransparent;
    private boolean mSetUnHideFlagWhenNextTransparent;
    private boolean mNoAnimationOnNextShow;
    private final Rect mContentFrame = new Rect();
    private OnBarVisibilityChangedListener mVisibilityChangeListener;

    BarController(String tag, int displayId, int transientFlag, int unhideFlag, int translucentFlag, int statusBarManagerId, int translucentWmFlag, int transparentFlag) {
        this.mTag = "BarController." + tag;
        this.mDisplayId = displayId;
        this.mTransientFlag = transientFlag;
        this.mUnhideFlag = unhideFlag;
        this.mTranslucentFlag = translucentFlag;
        this.mStatusBarManagerId = statusBarManagerId;
        this.mTranslucentWmFlag = translucentWmFlag;
        this.mTransparentFlag = transparentFlag;
        this.mHandler = new BarHandler();
    }

    void setWindow(WindowState win) {
        this.mWin = win;
    }

    void setContentFrame(Rect frame) {
        this.mContentFrame.set(frame);
    }

    void setShowTransparent(boolean transparent) {
        if (transparent != this.mShowTransparent) {
            this.mShowTransparent = transparent;
            this.mSetUnHideFlagWhenNextTransparent = transparent;
            this.mNoAnimationOnNextShow = true;
        }
    }

    void showTransient() {
        if (this.mWin != null) {
            this.setTransientBarState(1);
        }
    }

    boolean isTransientShowing() {
        return this.mTransientBarState == 2;
    }

    boolean isTransientShowRequested() {
        return this.mTransientBarState == 1;
    }

    boolean wasRecentlyTranslucent() {
        return SystemClock.uptimeMillis() - this.mLastTranslucent < 1000L;
    }

    void adjustSystemUiVisibilityLw(int oldVis, int vis) {
        if (this.mWin != null && this.mTransientBarState == 2 && (vis & this.mTransientFlag) == 0) {
            this.setTransientBarState(3);
            this.setBarShowingLw(false);
        } else if (this.mWin != null && (oldVis & this.mUnhideFlag) != 0 && (vis & this.mUnhideFlag) == 0) {
            this.setBarShowingLw(true);
        }
    }

    int applyTranslucentFlagLw(WindowState win, int vis, int oldVis) {
        if (this.mWin != null) {
            if (win != null && (win.getAttrs().privateFlags & 0x200) == 0) {
                int fl = PolicyControl.getWindowFlags(win, null);
                vis = (fl & this.mTranslucentWmFlag) != 0 ? (vis |= this.mTranslucentFlag) : (vis &= ~this.mTranslucentFlag);
                vis = (fl & Integer.MIN_VALUE) != 0 && this.isTransparentAllowed(win) ? (vis |= this.mTransparentFlag) : (vis &= ~this.mTransparentFlag);
            } else {
                vis = vis & ~this.mTranslucentFlag | oldVis & this.mTranslucentFlag;
                vis = vis & ~this.mTransparentFlag | oldVis & this.mTransparentFlag;
            }
        }
        return vis;
    }

    boolean isTransparentAllowed(WindowState win) {
        return win == null || !win.isLetterboxedOverlappingWith(this.mContentFrame);
    }

    boolean setBarShowingLw(boolean show) {
        if (this.mWin == null) {
            return false;
        }
        if (show && this.mTransientBarState == 3) {
            this.mPendingShow = true;
            return false;
        }
        boolean wasVis = this.mWin.isVisibleLw();
        boolean wasAnim = this.mWin.isAnimatingLw();
        boolean skipAnim = this.skipAnimation();
        boolean change = show ? this.mWin.showLw(!this.mNoAnimationOnNextShow && !skipAnim) : this.mWin.hideLw(!this.mNoAnimationOnNextShow && !skipAnim);
        this.mNoAnimationOnNextShow = false;
        int state = this.computeStateLw(wasVis, wasAnim, this.mWin, change);
        boolean stateChanged = this.updateStateLw(state);
        if (change && this.mVisibilityChangeListener != null) {
            this.mHandler.obtainMessage(1, show ? 1 : 0, 0).sendToTarget();
        }
        return change || stateChanged;
    }

    void setOnBarVisibilityChangedListener(OnBarVisibilityChangedListener listener, boolean invokeWithState) {
        this.mVisibilityChangeListener = listener;
        if (invokeWithState) {
            this.mHandler.obtainMessage(1, this.mState == 0 ? 1 : 0, 0).sendToTarget();
        }
    }

    protected boolean skipAnimation() {
        return !this.mWin.isDrawnLw();
    }

    private int computeStateLw(boolean wasVis, boolean wasAnim, WindowState win, boolean change) {
        if (win.isDrawnLw()) {
            boolean vis = win.isVisibleLw();
            boolean anim2 = win.isAnimatingLw();
            if (this.mState == 1 && !change && !vis) {
                return 2;
            }
            if (this.mState == 2 && vis) {
                return 0;
            }
            if (change) {
                if (wasVis && vis && !wasAnim && anim2) {
                    return 1;
                }
                return 0;
            }
        }
        return this.mState;
    }

    private boolean updateStateLw(final int state) {
        if (this.mWin != null && state != this.mState) {
            this.mState = state;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    StatusBarManagerInternal statusbar = BarController.this.getStatusBarInternal();
                    if (statusbar != null) {
                        statusbar.setWindowState(BarController.this.mDisplayId, BarController.this.mStatusBarManagerId, state);
                    }
                }
            });
            return true;
        }
        return false;
    }

    boolean checkHiddenLw() {
        if (this.mWin != null && this.mWin.isDrawnLw()) {
            if (!this.mWin.isVisibleLw() && !this.mWin.isAnimatingLw()) {
                this.updateStateLw(2);
            }
            if (this.mTransientBarState == 3 && !this.mWin.isVisibleLw()) {
                this.setTransientBarState(0);
                if (this.mPendingShow) {
                    this.setBarShowingLw(true);
                    this.mPendingShow = false;
                }
                return true;
            }
        }
        return false;
    }

    boolean checkShowTransientBarLw() {
        if (this.mTransientBarState == 2) {
            return false;
        }
        if (this.mTransientBarState == 1) {
            return false;
        }
        if (this.mWin == null) {
            return false;
        }
        return !this.mWin.isDisplayedLw();
    }

    int updateVisibilityLw(boolean transientAllowed, int oldVis, int vis) {
        if (this.mWin == null) {
            return vis;
        }
        if (this.isTransientShowing() || this.isTransientShowRequested()) {
            if (transientAllowed) {
                vis |= this.mTransientFlag;
                if ((oldVis & this.mTransientFlag) == 0) {
                    vis |= this.mUnhideFlag;
                }
                this.setTransientBarState(2);
            } else {
                this.setTransientBarState(0);
            }
        }
        if (this.mShowTransparent) {
            vis |= this.mTransparentFlag;
            if (this.mSetUnHideFlagWhenNextTransparent) {
                vis |= this.mUnhideFlag;
                this.mSetUnHideFlagWhenNextTransparent = false;
            }
        }
        if (this.mTransientBarState != 0) {
            vis |= this.mTransientFlag;
            vis &= 0xFFFFFFFE;
        }
        if ((vis & this.mTranslucentFlag) != 0 || (oldVis & this.mTranslucentFlag) != 0 || ((vis | oldVis) & this.mTransparentFlag) != 0) {
            this.mLastTranslucent = SystemClock.uptimeMillis();
        }
        return vis;
    }

    private void setTransientBarState(int state) {
        if (this.mWin != null && state != this.mTransientBarState) {
            if (this.mTransientBarState == 2 || state == 2) {
                this.mLastTranslucent = SystemClock.uptimeMillis();
            }
            this.mTransientBarState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatusBarManagerInternal getStatusBarInternal() {
        Object object = this.mServiceAquireLock;
        synchronized (object) {
            if (this.mStatusBarInternal == null) {
                this.mStatusBarInternal = LocalServices.getService(StatusBarManagerInternal.class);
            }
            return this.mStatusBarInternal;
        }
    }

    private static String transientBarStateToString(int state) {
        if (state == 3) {
            return "TRANSIENT_BAR_HIDING";
        }
        if (state == 2) {
            return "TRANSIENT_BAR_SHOWING";
        }
        if (state == 1) {
            return "TRANSIENT_BAR_SHOW_REQUESTED";
        }
        if (state == 0) {
            return "TRANSIENT_BAR_NONE";
        }
        throw new IllegalArgumentException("Unknown state " + state);
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10E00000001L, this.mState);
        proto.write(1159641169922L, this.mTransientBarState);
        proto.end(token);
    }

    void dump(PrintWriter pw, String prefix) {
        if (this.mWin != null) {
            pw.print(prefix);
            pw.println(this.mTag);
            pw.print(prefix);
            pw.print("  ");
            pw.print("mState");
            pw.print('=');
            pw.println(StatusBarManager.windowStateToString(this.mState));
            pw.print(prefix);
            pw.print("  ");
            pw.print("mTransientBar");
            pw.print('=');
            pw.println(BarController.transientBarStateToString(this.mTransientBarState));
            pw.print(prefix);
            pw.print("  mContentFrame=");
            pw.println(this.mContentFrame);
        }
    }

    static interface OnBarVisibilityChangedListener {
        public void onBarVisibilityChanged(boolean var1);
    }

    private class BarHandler
    extends Handler {
        BarHandler() {
            super(UiThread.getHandler().getLooper());
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    boolean visible;
                    boolean bl = visible = msg.arg1 != 0;
                    if (BarController.this.mVisibilityChangeListener == null) break;
                    BarController.this.mVisibilityChangeListener.onBarVisibilityChanged(visible);
                }
            }
        }
    }
}

