/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.WindowConfiguration;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.ConfigurationContainerListener;
import java.io.PrintWriter;
import java.util.ArrayList;

public abstract class ConfigurationContainer<E extends ConfigurationContainer> {
    private Rect mReturnBounds = new Rect();
    private Configuration mRequestedOverrideConfiguration = new Configuration();
    private Configuration mResolvedOverrideConfiguration = new Configuration();
    private boolean mHasOverrideConfiguration;
    private Configuration mFullConfiguration = new Configuration();
    private int mLastOverrideConfigurationChanges;
    private Configuration mMergedOverrideConfiguration = new Configuration();
    private ArrayList<ConfigurationContainerListener> mChangeListeners = new ArrayList();
    private final Configuration mTmpConfig = new Configuration();
    private final Rect mTmpRect = new Rect();
    static final int BOUNDS_CHANGE_NONE = 0;
    static final int BOUNDS_CHANGE_POSITION = 1;
    static final int BOUNDS_CHANGE_SIZE = 2;

    public Configuration getConfiguration() {
        return this.mFullConfiguration;
    }

    int getLastOverrideConfigurationChanges() {
        return this.mLastOverrideConfigurationChanges;
    }

    public void onConfigurationChanged(Configuration newParentConfig) {
        int i;
        this.mTmpConfig.setTo(this.mResolvedOverrideConfiguration);
        this.resolveOverrideConfiguration(newParentConfig);
        this.mFullConfiguration.setTo(newParentConfig);
        this.mLastOverrideConfigurationChanges = this.mFullConfiguration.updateFrom(this.mResolvedOverrideConfiguration);
        if (!this.mTmpConfig.equals(this.mResolvedOverrideConfiguration)) {
            this.onMergedOverrideConfigurationChanged();
            for (i = this.mChangeListeners.size() - 1; i >= 0; --i) {
                this.mChangeListeners.get(i).onRequestedOverrideConfigurationChanged(this.mResolvedOverrideConfiguration);
            }
        }
        for (i = this.getChildCount() - 1; i >= 0; --i) {
            E child = this.getChildAt(i);
            ((ConfigurationContainer)child).onConfigurationChanged(this.mFullConfiguration);
        }
    }

    void resolveOverrideConfiguration(Configuration newParentConfig) {
        this.mResolvedOverrideConfiguration.setTo(this.mRequestedOverrideConfiguration);
    }

    public Configuration getRequestedOverrideConfiguration() {
        return this.mRequestedOverrideConfiguration;
    }

    Configuration getResolvedOverrideConfiguration() {
        return this.mResolvedOverrideConfiguration;
    }

    public void onRequestedOverrideConfigurationChanged(Configuration overrideConfiguration) {
        this.mHasOverrideConfiguration = !Configuration.EMPTY.equals(overrideConfiguration);
        this.mRequestedOverrideConfiguration.setTo(overrideConfiguration);
        ConfigurationContainer parent = this.getParent();
        this.onConfigurationChanged(parent != null ? parent.getConfiguration() : Configuration.EMPTY);
    }

    public Configuration getMergedOverrideConfiguration() {
        return this.mMergedOverrideConfiguration;
    }

    void onMergedOverrideConfigurationChanged() {
        ConfigurationContainer parent = this.getParent();
        if (parent != null) {
            this.mMergedOverrideConfiguration.setTo(parent.getMergedOverrideConfiguration());
            this.mMergedOverrideConfiguration.updateFrom(this.mResolvedOverrideConfiguration);
        } else {
            this.mMergedOverrideConfiguration.setTo(this.mResolvedOverrideConfiguration);
        }
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            E child = this.getChildAt(i);
            ((ConfigurationContainer)child).onMergedOverrideConfigurationChanged();
        }
    }

    public boolean matchParentBounds() {
        return this.getRequestedOverrideBounds().isEmpty();
    }

    public boolean equivalentRequestedOverrideBounds(Rect bounds) {
        return ConfigurationContainer.equivalentBounds(this.getRequestedOverrideBounds(), bounds);
    }

    public static boolean equivalentBounds(Rect bounds, Rect other) {
        return bounds == other || bounds != null && (bounds.equals(other) || bounds.isEmpty() && other == null) || other != null && other.isEmpty() && bounds == null;
    }

    public Rect getBounds() {
        this.mReturnBounds.set(this.getConfiguration().windowConfiguration.getBounds());
        return this.mReturnBounds;
    }

    public void getBounds(Rect outBounds) {
        outBounds.set(this.getBounds());
    }

    public void getPosition(Point out) {
        Rect bounds = this.getBounds();
        out.set(bounds.left, bounds.top);
    }

    public Rect getRequestedOverrideBounds() {
        this.mReturnBounds.set(this.getRequestedOverrideConfiguration().windowConfiguration.getBounds());
        return this.mReturnBounds;
    }

    public boolean hasOverrideBounds() {
        return !this.getRequestedOverrideBounds().isEmpty();
    }

    public void getRequestedOverrideBounds(Rect outBounds) {
        outBounds.set(this.getRequestedOverrideBounds());
    }

    public int setBounds(Rect bounds) {
        int boundsChange = this.diffRequestedOverrideBounds(bounds);
        if (boundsChange == 0) {
            return boundsChange;
        }
        this.mTmpConfig.setTo(this.getRequestedOverrideConfiguration());
        this.mTmpConfig.windowConfiguration.setBounds(bounds);
        this.onRequestedOverrideConfigurationChanged(this.mTmpConfig);
        return boundsChange;
    }

    public int setBounds(int left, int top, int right, int bottom) {
        this.mTmpRect.set(left, top, right, bottom);
        return this.setBounds(this.mTmpRect);
    }

    int diffRequestedOverrideBounds(Rect bounds) {
        if (this.equivalentRequestedOverrideBounds(bounds)) {
            return 0;
        }
        int boundsChange = 0;
        Rect existingBounds = this.getRequestedOverrideBounds();
        if (bounds == null || existingBounds.left != bounds.left || existingBounds.top != bounds.top) {
            boundsChange |= 1;
        }
        if (bounds == null || existingBounds.width() != bounds.width() || existingBounds.height() != bounds.height()) {
            boundsChange |= 2;
        }
        return boundsChange;
    }

    boolean hasOverrideConfiguration() {
        return this.mHasOverrideConfiguration;
    }

    public WindowConfiguration getWindowConfiguration() {
        return this.mFullConfiguration.windowConfiguration;
    }

    public int getWindowingMode() {
        return this.mFullConfiguration.windowConfiguration.getWindowingMode();
    }

    public int getRequestedOverrideWindowingMode() {
        return this.mRequestedOverrideConfiguration.windowConfiguration.getWindowingMode();
    }

    public void setWindowingMode(int windowingMode) {
        this.mTmpConfig.setTo(this.getRequestedOverrideConfiguration());
        this.mTmpConfig.windowConfiguration.setWindowingMode(windowingMode);
        this.onRequestedOverrideConfigurationChanged(this.mTmpConfig);
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.mTmpConfig.setTo(this.getRequestedOverrideConfiguration());
        this.mTmpConfig.windowConfiguration.setAlwaysOnTop(alwaysOnTop);
        this.onRequestedOverrideConfigurationChanged(this.mTmpConfig);
    }

    void setDisplayWindowingMode(int windowingMode) {
        this.mTmpConfig.setTo(this.getRequestedOverrideConfiguration());
        this.mTmpConfig.windowConfiguration.setDisplayWindowingMode(windowingMode);
        this.onRequestedOverrideConfigurationChanged(this.mTmpConfig);
    }

    public boolean inMultiWindowMode() {
        int windowingMode = this.mFullConfiguration.windowConfiguration.getWindowingMode();
        return windowingMode != 1 && windowingMode != 0;
    }

    public boolean inSplitScreenWindowingMode() {
        int windowingMode = this.mFullConfiguration.windowConfiguration.getWindowingMode();
        return windowingMode == 3 || windowingMode == 4;
    }

    public boolean inSplitScreenSecondaryWindowingMode() {
        int windowingMode = this.mFullConfiguration.windowConfiguration.getWindowingMode();
        return windowingMode == 4;
    }

    public boolean inSplitScreenPrimaryWindowingMode() {
        return this.mFullConfiguration.windowConfiguration.getWindowingMode() == 3;
    }

    public boolean supportsSplitScreenWindowingMode() {
        return this.mFullConfiguration.windowConfiguration.supportSplitScreenWindowingMode();
    }

    public boolean inPinnedWindowingMode() {
        return this.mFullConfiguration.windowConfiguration.getWindowingMode() == 2;
    }

    public boolean inFreeformWindowingMode() {
        return this.mFullConfiguration.windowConfiguration.getWindowingMode() == 5;
    }

    public int getActivityType() {
        return this.mFullConfiguration.windowConfiguration.getActivityType();
    }

    public void setActivityType(int activityType) {
        int currentActivityType = this.getActivityType();
        if (currentActivityType == activityType) {
            return;
        }
        if (currentActivityType != 0) {
            throw new IllegalStateException("Can't change activity type once set: " + this + " activityType=" + WindowConfiguration.activityTypeToString(activityType));
        }
        this.mTmpConfig.setTo(this.getRequestedOverrideConfiguration());
        this.mTmpConfig.windowConfiguration.setActivityType(activityType);
        this.onRequestedOverrideConfigurationChanged(this.mTmpConfig);
    }

    public boolean isActivityTypeHome() {
        return this.getActivityType() == 2;
    }

    public boolean isActivityTypeRecents() {
        return this.getActivityType() == 3;
    }

    public boolean isActivityTypeAssistant() {
        return this.getActivityType() == 4;
    }

    public boolean isActivityTypeStandard() {
        return this.getActivityType() == 1;
    }

    public boolean isActivityTypeStandardOrUndefined() {
        int activityType = this.getActivityType();
        return activityType == 1 || activityType == 0;
    }

    public boolean hasCompatibleActivityType(ConfigurationContainer other) {
        int otherType;
        int thisType = this.getActivityType();
        if (thisType == (otherType = other.getActivityType())) {
            return true;
        }
        if (thisType == 4) {
            return false;
        }
        return thisType == 0 || otherType == 0;
    }

    public boolean isCompatible(int windowingMode, int activityType) {
        boolean sameWindowingMode;
        int thisActivityType = this.getActivityType();
        int thisWindowingMode = this.getWindowingMode();
        boolean sameActivityType = thisActivityType == activityType;
        boolean bl = sameWindowingMode = thisWindowingMode == windowingMode;
        if (sameActivityType && sameWindowingMode) {
            return true;
        }
        if (activityType != 0 && activityType != 1 || !this.isActivityTypeStandardOrUndefined()) {
            return sameActivityType;
        }
        return sameWindowingMode;
    }

    public void registerConfigurationChangeListener(ConfigurationContainerListener listener) {
        if (this.mChangeListeners.contains(listener)) {
            return;
        }
        this.mChangeListeners.add(listener);
        listener.onRequestedOverrideConfigurationChanged(this.mResolvedOverrideConfiguration);
    }

    public void unregisterConfigurationChangeListener(ConfigurationContainerListener listener) {
        this.mChangeListeners.remove(listener);
    }

    @VisibleForTesting
    boolean containsListener(ConfigurationContainerListener listener) {
        return this.mChangeListeners.contains(listener);
    }

    void onParentChanged() {
        ConfigurationContainer parent = this.getParent();
        if (parent != null) {
            this.onConfigurationChanged(parent.mFullConfiguration);
            this.onMergedOverrideConfigurationChanged();
        }
    }

    protected void writeToProto(ProtoOutputStream proto, long fieldId, int logLevel) {
        if (logLevel != 0 && !this.mHasOverrideConfiguration) {
            return;
        }
        long token = proto.start(fieldId);
        this.mRequestedOverrideConfiguration.writeToProto(proto, 0x10B00000001L, logLevel == 2);
        if (logLevel == 0) {
            this.mFullConfiguration.writeToProto(proto, 1146756268034L, false);
            this.mMergedOverrideConfiguration.writeToProto(proto, 1146756268035L, false);
        }
        proto.end(token);
    }

    public void dumpChildrenNames(PrintWriter pw, String prefix) {
        String childPrefix = prefix + " ";
        pw.println(this.getName() + " type=" + WindowConfiguration.activityTypeToString(this.getActivityType()) + " mode=" + WindowConfiguration.windowingModeToString(this.getWindowingMode()) + " override-mode=" + WindowConfiguration.windowingModeToString(this.getRequestedOverrideWindowingMode()));
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            E cc = this.getChildAt(i);
            pw.print(childPrefix + "#" + i + " ");
            ((ConfigurationContainer)cc).dumpChildrenNames(pw, childPrefix);
        }
    }

    String getName() {
        return this.toString();
    }

    public boolean isAlwaysOnTop() {
        return this.mFullConfiguration.windowConfiguration.isAlwaysOnTop();
    }

    protected abstract int getChildCount();

    protected abstract E getChildAt(int var1);

    protected abstract ConfigurationContainer getParent();
}

