/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import android.view.Surface;
import android.view.SurfaceControl;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.LocalAnimationAdapter;
import com.android.server.wm.SurfaceAnimator;
import com.android.server.wm.WindowContainer;
import java.io.PrintWriter;

class Dimmer {
    private static final String TAG = "WindowManager";
    private static final int DEFAULT_DIM_ANIM_DURATION = 200;
    private WindowContainer mHost;
    private WindowContainer mLastRequestedDimContainer;
    @VisibleForTesting
    DimState mDimState;
    private final SurfaceAnimatorStarter mSurfaceAnimatorStarter;

    Dimmer(WindowContainer host) {
        this(host, SurfaceAnimator::startAnimation);
    }

    Dimmer(WindowContainer host, SurfaceAnimatorStarter surfaceAnimatorStarter) {
        this.mHost = host;
        this.mSurfaceAnimatorStarter = surfaceAnimatorStarter;
    }

    private SurfaceControl makeDimLayer() {
        return this.mHost.makeChildSurface(null).setParent(this.mHost.getSurfaceControl()).setColorLayer().setName("Dim Layer for - " + this.mHost.getName()).build();
    }

    private DimState getDimState(WindowContainer container) {
        if (this.mDimState == null) {
            try {
                SurfaceControl ctl = this.makeDimLayer();
                this.mDimState = new DimState(ctl);
                if (container == null) {
                    this.mDimState.mDontReset = true;
                }
            }
            catch (Surface.OutOfResourcesException e) {
                Log.w(TAG, "OutOfResourcesException creating dim surface");
            }
        }
        this.mLastRequestedDimContainer = container;
        return this.mDimState;
    }

    private void dim(SurfaceControl.Transaction t, WindowContainer container, int relativeLayer, float alpha) {
        DimState d = this.getDimState(container);
        if (d == null) {
            return;
        }
        if (container != null) {
            t.setRelativeLayer(d.mDimLayer, container.getSurfaceControl(), relativeLayer);
        } else {
            t.setLayer(d.mDimLayer, Integer.MAX_VALUE);
        }
        t.setAlpha(d.mDimLayer, alpha);
        d.mDimming = true;
    }

    void stopDim(SurfaceControl.Transaction t) {
        if (this.mDimState != null) {
            t.hide(this.mDimState.mDimLayer);
            this.mDimState.isVisible = false;
            this.mDimState.mDontReset = false;
        }
    }

    void dimAbove(SurfaceControl.Transaction t, float alpha) {
        this.dim(t, null, 1, alpha);
    }

    void dimAbove(SurfaceControl.Transaction t, WindowContainer container, float alpha) {
        this.dim(t, container, 1, alpha);
    }

    void dimBelow(SurfaceControl.Transaction t, WindowContainer container, float alpha) {
        this.dim(t, container, -1, alpha);
    }

    void resetDimStates() {
        if (this.mDimState != null && !this.mDimState.mDontReset) {
            this.mDimState.mDimming = false;
        }
    }

    void dontAnimateExit() {
        if (this.mDimState != null) {
            this.mDimState.mAnimateExit = false;
        }
    }

    boolean updateDims(SurfaceControl.Transaction t, Rect bounds) {
        if (this.mDimState == null) {
            return false;
        }
        if (!this.mDimState.mDimming) {
            if (!this.mDimState.mAnimateExit) {
                if (this.mDimState.mDimLayer.isValid()) {
                    t.remove(this.mDimState.mDimLayer);
                }
            } else {
                this.startDimExit(this.mLastRequestedDimContainer, this.mDimState.mSurfaceAnimator, t);
            }
            this.mDimState = null;
            return false;
        }
        t.setPosition(this.mDimState.mDimLayer, bounds.left, bounds.top);
        t.setWindowCrop(this.mDimState.mDimLayer, bounds.width(), bounds.height());
        if (!this.mDimState.isVisible) {
            this.mDimState.isVisible = true;
            t.show(this.mDimState.mDimLayer);
            this.startDimEnter(this.mLastRequestedDimContainer, this.mDimState.mSurfaceAnimator, t);
        }
        return true;
    }

    private void startDimEnter(WindowContainer container, SurfaceAnimator animator2, SurfaceControl.Transaction t) {
        this.startAnim(container, animator2, t, 0.0f, 1.0f);
    }

    private void startDimExit(WindowContainer container, SurfaceAnimator animator2, SurfaceControl.Transaction t) {
        this.startAnim(container, animator2, t, 1.0f, 0.0f);
    }

    private void startAnim(WindowContainer container, SurfaceAnimator animator2, SurfaceControl.Transaction t, float startAlpha, float endAlpha) {
        this.mSurfaceAnimatorStarter.startAnimation(animator2, t, new LocalAnimationAdapter(new AlphaAnimationSpec(startAlpha, endAlpha, this.getDimDuration(container)), this.mHost.mWmService.mSurfaceAnimationRunner), false);
    }

    private long getDimDuration(WindowContainer container) {
        if (container == null) {
            return 0L;
        }
        AnimationAdapter animationAdapter = container.mSurfaceAnimator.getAnimation();
        return animationAdapter == null ? 200L : animationAdapter.getDurationHint();
    }

    private static class AlphaAnimationSpec
    implements LocalAnimationAdapter.AnimationSpec {
        private final long mDuration;
        private final float mFromAlpha;
        private final float mToAlpha;

        AlphaAnimationSpec(float fromAlpha, float toAlpha, long duration) {
            this.mFromAlpha = fromAlpha;
            this.mToAlpha = toAlpha;
            this.mDuration = duration;
        }

        @Override
        public long getDuration() {
            return this.mDuration;
        }

        @Override
        public void apply(SurfaceControl.Transaction t, SurfaceControl sc, long currentPlayTime) {
            float alpha = (float)currentPlayTime / (float)this.getDuration() * (this.mToAlpha - this.mFromAlpha) + this.mFromAlpha;
            t.setAlpha(sc, alpha);
        }

        @Override
        public void dump(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.print("from=");
            pw.print(this.mFromAlpha);
            pw.print(" to=");
            pw.print(this.mToAlpha);
            pw.print(" duration=");
            pw.println(this.mDuration);
        }

        @Override
        public void writeToProtoInner(ProtoOutputStream proto) {
            long token = proto.start(1146756268035L);
            proto.write(0x10200000001L, this.mFromAlpha);
            proto.write(0x10200000002L, this.mToAlpha);
            proto.write(0x10300000003L, this.mDuration);
            proto.end(token);
        }
    }

    @VisibleForTesting
    static interface SurfaceAnimatorStarter {
        public void startAnimation(SurfaceAnimator var1, SurfaceControl.Transaction var2, AnimationAdapter var3, boolean var4);
    }

    @VisibleForTesting
    class DimState {
        SurfaceControl mDimLayer;
        boolean mDimming;
        boolean isVisible;
        SurfaceAnimator mSurfaceAnimator;
        boolean mAnimateExit = true;
        boolean mDontReset;

        DimState(SurfaceControl dimLayer) {
            this.mDimLayer = dimLayer;
            this.mDimming = true;
            DimAnimatable dimAnimatable = new DimAnimatable(dimLayer);
            this.mSurfaceAnimator = new SurfaceAnimator(dimAnimatable, () -> {
                if (!this.mDimming) {
                    dimAnimatable.removeSurface();
                }
            }, ((Dimmer)Dimmer.this).mHost.mWmService);
        }
    }

    private class DimAnimatable
    implements SurfaceAnimator.Animatable {
        private SurfaceControl mDimLayer;

        private DimAnimatable(SurfaceControl dimLayer) {
            this.mDimLayer = dimLayer;
        }

        @Override
        public SurfaceControl.Transaction getPendingTransaction() {
            return Dimmer.this.mHost.getPendingTransaction();
        }

        @Override
        public void commitPendingTransaction() {
            Dimmer.this.mHost.commitPendingTransaction();
        }

        @Override
        public void onAnimationLeashCreated(SurfaceControl.Transaction t, SurfaceControl leash) {
        }

        @Override
        public void onAnimationLeashLost(SurfaceControl.Transaction t) {
        }

        @Override
        public SurfaceControl.Builder makeAnimationLeash() {
            return Dimmer.this.mHost.makeAnimationLeash();
        }

        @Override
        public SurfaceControl getAnimationLeashParent() {
            return Dimmer.this.mHost.getSurfaceControl();
        }

        @Override
        public SurfaceControl getSurfaceControl() {
            return this.mDimLayer;
        }

        @Override
        public SurfaceControl getParentSurfaceControl() {
            return Dimmer.this.mHost.getSurfaceControl();
        }

        @Override
        public int getSurfaceWidth() {
            return Dimmer.this.mHost.getSurfaceWidth();
        }

        @Override
        public int getSurfaceHeight() {
            return Dimmer.this.mHost.getSurfaceHeight();
        }

        void removeSurface() {
            if (this.mDimLayer != null && this.mDimLayer.isValid()) {
                this.getPendingTransaction().remove(this.mDimLayer);
            }
            this.mDimLayer = null;
        }
    }
}

