/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.animation.AnimationHandler;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.hardware.display.DisplayManagerInternal;
import android.metrics.LogMaker;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.ISystemGestureExclusionListener;
import android.view.InputChannel;
import android.view.InputDevice;
import android.view.InputWindowHandle;
import android.view.MagnificationSpec;
import android.view.RemoteAnimationDefinition;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.WindowManagerPolicyConstants;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.ToBooleanFunction;
import com.android.internal.util.function.TriConsumer;
import com.android.internal.util.function.pooled.PooledConsumer;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.AnimationThread;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.wm.ActivityDisplay;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppTransition;
import com.android.server.wm.AppTransitionController;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.BoundsAnimationController;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.Dimmer;
import com.android.server.wm.DisplayFrames;
import com.android.server.wm.DisplayPolicy;
import com.android.server.wm.DisplayRotation;
import com.android.server.wm.DockedStackDividerController;
import com.android.server.wm.InputMonitor;
import com.android.server.wm.InsetsStateController;
import com.android.server.wm.PinnedStackController;
import com.android.server.wm.PointerEventDispatcher;
import com.android.server.wm.RootWindowContainer;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.TaskTapPointerEventListener;
import com.android.server.wm.UnknownAppVisibilityController;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowSurfacePlacer;
import com.android.server.wm.WindowToken;
import com.android.server.wm.utils.DisplayRotationUtil;
import com.android.server.wm.utils.RegionUtils;
import com.android.server.wm.utils.RotationCache;
import com.android.server.wm.utils.WmDisplayCutout;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

class DisplayContent
extends WindowContainer<DisplayChildWindowContainer>
implements WindowManagerPolicy.DisplayContentInfo {
    private static final String TAG = "WindowManager";
    static final int FORCE_SCALING_MODE_AUTO = 0;
    static final int FORCE_SCALING_MODE_DISABLED = 1;
    private final int mDisplayId;
    ActivityDisplay mAcitvityDisplay;
    private final TaskStackContainers mTaskStackContainers;
    private final AboveAppWindowContainers mAboveAppWindowsContainers;
    private final NonAppWindowContainers mBelowAppWindowsContainers;
    private final NonAppWindowContainers mImeWindowsContainers;
    private WindowState mTmpWindow;
    private WindowState mTmpWindow2;
    private boolean mTmpRecoveringMemory;
    private boolean mUpdateImeTarget;
    private boolean mTmpInitial;
    private int mMaxUiWidth;
    final AppTransition mAppTransition;
    final AppTransitionController mAppTransitionController;
    boolean mSkipAppTransitionAnimation;
    final ArraySet<AppWindowToken> mOpeningApps;
    final ArraySet<AppWindowToken> mClosingApps;
    final ArraySet<AppWindowToken> mChangingApps;
    final UnknownAppVisibilityController mUnknownAppVisibilityController;
    BoundsAnimationController mBoundsAnimationController;
    private MetricsLogger mMetricsLogger;
    final List<IBinder> mNoAnimationNotifyOnTransitionFinished;
    private final HashMap<IBinder, WindowToken> mTokenMap;
    int mInitialDisplayWidth;
    int mInitialDisplayHeight;
    int mInitialDisplayDensity;
    DisplayCutout mInitialDisplayCutout;
    private final RotationCache<DisplayCutout, WmDisplayCutout> mDisplayCutoutCache;
    int mBaseDisplayWidth;
    int mBaseDisplayHeight;
    int mBaseDisplayDensity;
    boolean mDisplayScalingDisabled;
    private final DisplayInfo mDisplayInfo;
    private final Display mDisplay;
    private final DisplayMetrics mDisplayMetrics;
    private final DisplayPolicy mDisplayPolicy;
    private DisplayRotation mDisplayRotation;
    DisplayFrames mDisplayFrames;
    private final RemoteCallbackList<ISystemGestureExclusionListener> mSystemGestureExclusionListeners;
    private final Region mSystemGestureExclusion;
    private int mSystemGestureExclusionLimit;
    final DisplayMetrics mRealDisplayMetrics;
    private final DisplayMetrics mTmpDisplayMetrics;
    private final DisplayMetrics mCompatDisplayMetrics;
    float mCompatibleScreenScale;
    private int mRotation;
    private int mLastOrientation;
    private int mLastWindowForcedOrientation;
    private int mLastKeyguardForcedOrientation;
    @VisibleForTesting
    final float mCloseToSquareMaxAspectRatio;
    private boolean mIgnoreRotationForApps;
    private boolean mLastWallpaperVisible;
    private Rect mBaseDisplayRect;
    private boolean mLayoutNeeded;
    int pendingLayoutChanges;
    int mDeferredRotationPauseCount;
    boolean mWaitingForConfig;
    @VisibleForTesting
    boolean isDefaultDisplay;
    boolean mShouldOverrideDisplayConfiguration;
    final ArrayList<WindowToken> mExitingTokens;
    @VisibleForTesting
    final TaskTapPointerEventListener mTapDetector;
    private Region mTouchExcludeRegion;
    private final Rect mTmpRect;
    private final Rect mTmpRect2;
    private final RectF mTmpRectF;
    private final Matrix mTmpMatrix;
    private final Region mTmpRegion;
    private final Rect mTmpBounds;
    private final Configuration mTmpConfiguration;
    private boolean mDeferredRemoval;
    final DockedStackDividerController mDividerControllerLocked;
    final PinnedStackController mPinnedStackControllerLocked;
    final ArrayList<WindowState> mTapExcludedWindows;
    final ArraySet<WindowState> mTapExcludeProvidingWindows;
    private boolean mHaveBootMsg;
    private boolean mHaveApp;
    private boolean mHaveWallpaper;
    private boolean mHaveKeyguard;
    private final LinkedList<AppWindowToken> mTmpUpdateAllDrawn;
    private final TaskForResizePointSearchResult mTmpTaskForResizePointSearchResult;
    private final ApplySurfaceChangesTransactionState mTmpApplySurfaceChangesTransactionState;
    private boolean mRemovingDisplay;
    private boolean mDisplayReady;
    WallpaperController mWallpaperController;
    boolean mWallpaperMayChange;
    private final SurfaceSession mSession;
    WindowState mCurrentFocus;
    WindowState mLastFocus;
    ArrayList<WindowState> mLosingFocus;
    AppWindowToken mFocusedApp;
    final ArrayList<WindowState> mWinAddedSinceNullFocus;
    final ArrayList<WindowState> mWinRemovedSinceNullFocus;
    private SurfaceControl mOverlayLayer;
    private SurfaceControl mWindowingLayer;
    int mLayoutSeq;
    private int mDeferUpdateImeTargetCount;
    private final float[] mTmpFloats;
    private MagnificationSpec mMagnificationSpec;
    private InputMonitor mInputMonitor;
    private boolean mLastHasContent;
    private DisplayRotationUtil mRotationUtil;
    WindowState mInputMethodWindow;
    WindowState mInputMethodTarget;
    boolean mInputMethodTargetWaitingAnim;
    private final PointerEventDispatcher mPointerEventDispatcher;
    private final InsetsStateController mInsetsStateController;
    private WindowState mParentWindow;
    private Point mLocationInParentWindow;
    private SurfaceControl mParentSurfaceControl;
    private InputWindowHandle mPortalWindowHandle;
    private int mLastStatusBarVisibility;
    private int mLastDispatchedSystemUiVisibility;
    private final float mWindowCornerRadius;
    private final Consumer<WindowState> mUpdateWindowsForAnimator;
    private final Consumer<WindowState> mUpdateWallpaperForAnimator;
    private final Consumer<WindowState> mScheduleToastTimeout;
    private final ToBooleanFunction<WindowState> mFindFocusedWindow;
    private final Consumer<WindowState> mPerformLayout;
    private final Consumer<WindowState> mPerformLayoutAttached;
    private final Predicate<WindowState> mComputeImeTargetPredicate;
    private final Consumer<WindowState> mApplyPostLayoutPolicy;
    private final Consumer<WindowState> mApplySurfaceChangesTransaction;

    DisplayContent(Display display, WindowManagerService service, ActivityDisplay activityDisplay) {
        super(service);
        this.mTaskStackContainers = new TaskStackContainers(this.mWmService);
        this.mAboveAppWindowsContainers = new AboveAppWindowContainers("mAboveAppWindowsContainers", this.mWmService);
        this.mBelowAppWindowsContainers = new NonAppWindowContainers("mBelowAppWindowsContainers", this.mWmService);
        this.mImeWindowsContainers = new NonAppWindowContainers("mImeWindowsContainers", this.mWmService);
        this.mSkipAppTransitionAnimation = false;
        this.mOpeningApps = new ArraySet();
        this.mClosingApps = new ArraySet();
        this.mChangingApps = new ArraySet();
        this.mNoAnimationNotifyOnTransitionFinished = new ArrayList<IBinder>();
        this.mTokenMap = new HashMap();
        this.mInitialDisplayWidth = 0;
        this.mInitialDisplayHeight = 0;
        this.mInitialDisplayDensity = 0;
        this.mDisplayCutoutCache = new RotationCache<DisplayCutout, WmDisplayCutout>(this::calculateDisplayCutoutForRotationUncached);
        this.mBaseDisplayWidth = 0;
        this.mBaseDisplayHeight = 0;
        this.mBaseDisplayDensity = 0;
        this.mDisplayInfo = new DisplayInfo();
        this.mDisplayMetrics = new DisplayMetrics();
        this.mSystemGestureExclusionListeners = new RemoteCallbackList();
        this.mSystemGestureExclusion = new Region();
        this.mRealDisplayMetrics = new DisplayMetrics();
        this.mTmpDisplayMetrics = new DisplayMetrics();
        this.mCompatDisplayMetrics = new DisplayMetrics();
        this.mRotation = 0;
        this.mLastOrientation = -1;
        this.mLastWindowForcedOrientation = -1;
        this.mLastKeyguardForcedOrientation = -1;
        this.mLastWallpaperVisible = false;
        this.mBaseDisplayRect = new Rect();
        this.mShouldOverrideDisplayConfiguration = true;
        this.mExitingTokens = new ArrayList();
        this.mTouchExcludeRegion = new Region();
        this.mTmpRect = new Rect();
        this.mTmpRect2 = new Rect();
        this.mTmpRectF = new RectF();
        this.mTmpMatrix = new Matrix();
        this.mTmpRegion = new Region();
        this.mTmpBounds = new Rect();
        this.mTmpConfiguration = new Configuration();
        this.mTapExcludedWindows = new ArrayList();
        this.mTapExcludeProvidingWindows = new ArraySet();
        this.mHaveBootMsg = false;
        this.mHaveApp = false;
        this.mHaveWallpaper = false;
        this.mHaveKeyguard = true;
        this.mTmpUpdateAllDrawn = new LinkedList();
        this.mTmpTaskForResizePointSearchResult = new TaskForResizePointSearchResult();
        this.mTmpApplySurfaceChangesTransactionState = new ApplySurfaceChangesTransactionState();
        this.mRemovingDisplay = false;
        this.mDisplayReady = false;
        this.mWallpaperMayChange = false;
        this.mSession = new SurfaceSession();
        this.mCurrentFocus = null;
        this.mLastFocus = null;
        this.mLosingFocus = new ArrayList();
        this.mFocusedApp = null;
        this.mWinAddedSinceNullFocus = new ArrayList();
        this.mWinRemovedSinceNullFocus = new ArrayList();
        this.mLayoutSeq = 0;
        this.mTmpFloats = new float[9];
        this.mRotationUtil = new DisplayRotationUtil();
        this.mLocationInParentWindow = new Point();
        this.mLastStatusBarVisibility = 0;
        this.mLastDispatchedSystemUiVisibility = 0;
        this.mUpdateWindowsForAnimator = w -> {
            WindowStateAnimator winAnimator = w.mWinAnimator;
            AppWindowToken atoken = w.mAppToken;
            if (winAnimator.mDrawState == 3 && (atoken == null || atoken.canShowWindows()) && w.performShowLocked()) {
                this.pendingLayoutChanges |= 8;
            }
        };
        this.mUpdateWallpaperForAnimator = w -> {
            TaskStack stack;
            int color2;
            AnimationAdapter anim2;
            WindowStateAnimator winAnimator = w.mWinAnimator;
            if (winAnimator.mSurfaceController == null || !winAnimator.hasSurface()) {
                return;
            }
            AnimationAdapter animationAdapter = anim2 = w.mAppToken != null ? w.mAppToken.getAnimation() : w.getAnimation();
            if (anim2 != null && (color2 = anim2.getBackgroundColor()) != 0 && (stack = w.getStack()) != null) {
                stack.setAnimationBackground(winAnimator, color2);
            }
        };
        this.mScheduleToastTimeout = w -> {
            int lostFocusUid = this.mTmpWindow.mOwnerUid;
            WindowManagerService.H handler = this.mWmService.mH;
            if (w.mAttrs.type == 2005 && w.mOwnerUid == lostFocusUid && !handler.hasMessages(52, w)) {
                handler.sendMessageDelayed(handler.obtainMessage(52, w), w.mAttrs.hideTimeoutMilliseconds);
            }
        };
        this.mFindFocusedWindow = w -> {
            AppWindowToken focusedApp = this.mFocusedApp;
            if (!w.canReceiveKeys()) {
                return false;
            }
            AppWindowToken wtoken = w.mAppToken;
            if (wtoken != null && (wtoken.removed || wtoken.sendingToBottom)) {
                return false;
            }
            if (focusedApp == null) {
                this.mTmpWindow = w;
                return true;
            }
            if (!focusedApp.windowsAreFocusable()) {
                this.mTmpWindow = w;
                return true;
            }
            if (wtoken != null && w.mAttrs.type != 3 && focusedApp.compareTo(wtoken) > 0) {
                this.mTmpWindow = null;
                return true;
            }
            this.mTmpWindow = w;
            return true;
        };
        this.mPerformLayout = w -> {
            boolean gone;
            boolean bl = gone = this.mTmpWindow != null && this.mWmService.mPolicy.canBeHiddenByKeyguardLw((WindowManagerPolicy.WindowState)w) || w.isGoneForLayoutLw();
            if (!(gone && w.mHaveFrame && !w.mLayoutNeeded || w.mLayoutAttached)) {
                if (this.mTmpInitial) {
                    w.resetContentChanged();
                }
                if (w.mAttrs.type == 2023) {
                    this.mTmpWindow = w;
                }
                w.mLayoutNeeded = false;
                w.prelayout();
                boolean firstLayout = !w.isLaidOut();
                this.getDisplayPolicy().layoutWindowLw((WindowState)w, null, this.mDisplayFrames);
                w.mLayoutSeq = this.mLayoutSeq;
                if (firstLayout) {
                    w.updateLastInsetValues();
                }
                if (w.mAppToken != null) {
                    w.mAppToken.layoutLetterbox((WindowState)w);
                }
            }
        };
        this.mPerformLayoutAttached = w -> {
            if (w.mLayoutAttached) {
                if (this.mTmpWindow != null && this.mWmService.mPolicy.canBeHiddenByKeyguardLw((WindowManagerPolicy.WindowState)w)) {
                    return;
                }
                if (w.mViewVisibility != 8 && w.mRelayoutCalled || !w.mHaveFrame || w.mLayoutNeeded) {
                    if (this.mTmpInitial) {
                        w.resetContentChanged();
                    }
                    w.mLayoutNeeded = false;
                    w.prelayout();
                    this.getDisplayPolicy().layoutWindowLw((WindowState)w, w.getParentWindow(), this.mDisplayFrames);
                    w.mLayoutSeq = this.mLayoutSeq;
                }
            } else if (w.mAttrs.type == 2023) {
                this.mTmpWindow = this.mTmpWindow2;
            }
        };
        this.mComputeImeTargetPredicate = w -> w.canBeImeTarget();
        this.mApplyPostLayoutPolicy = w -> this.getDisplayPolicy().applyPostLayoutPolicyLw((WindowState)w, w.mAttrs, w.getParentWindow(), this.mInputMethodTarget);
        this.mApplySurfaceChangesTransaction = w -> {
            AppWindowToken atoken;
            WindowSurfacePlacer surfacePlacer = this.mWmService.mWindowPlacerLocked;
            boolean obscuredChanged = w.mObscured != this.mTmpApplySurfaceChangesTransactionState.obscured;
            RootWindowContainer root = this.mWmService.mRoot;
            w.mObscured = this.mTmpApplySurfaceChangesTransactionState.obscured;
            if (!this.mTmpApplySurfaceChangesTransactionState.obscured) {
                boolean isDisplayed = w.isDisplayedLw();
                if (isDisplayed && w.isObscuringDisplay()) {
                    root.mObscuringWindow = w;
                    this.mTmpApplySurfaceChangesTransactionState.obscured = true;
                }
                this.mTmpApplySurfaceChangesTransactionState.displayHasContent |= root.handleNotObscuredLocked((WindowState)w, this.mTmpApplySurfaceChangesTransactionState.obscured, this.mTmpApplySurfaceChangesTransactionState.syswin);
                if (w.mHasSurface && isDisplayed) {
                    int type = w.mAttrs.type;
                    if (type == 2008 || type == 2010 || (w.mAttrs.privateFlags & 0x400) != 0) {
                        this.mTmpApplySurfaceChangesTransactionState.syswin = true;
                    }
                    if (this.mTmpApplySurfaceChangesTransactionState.preferredRefreshRate == 0.0f && w.mAttrs.preferredRefreshRate != 0.0f) {
                        this.mTmpApplySurfaceChangesTransactionState.preferredRefreshRate = w.mAttrs.preferredRefreshRate;
                    }
                    int preferredModeId = this.getDisplayPolicy().getRefreshRatePolicy().getPreferredModeId((WindowState)w);
                    if (this.mTmpApplySurfaceChangesTransactionState.preferredModeId == 0 && preferredModeId != 0) {
                        this.mTmpApplySurfaceChangesTransactionState.preferredModeId = preferredModeId;
                    }
                }
            }
            if (obscuredChanged && w.isVisibleLw() && this.mWallpaperController.isWallpaperTarget((WindowState)w)) {
                this.mWallpaperController.updateWallpaperVisibility();
            }
            w.handleWindowMovedIfNeeded();
            WindowStateAnimator winAnimator = w.mWinAnimator;
            w.resetContentChanged();
            if (w.mHasSurface) {
                boolean committed = winAnimator.commitFinishDrawingLocked();
                if (this.isDefaultDisplay && committed) {
                    if (w.mAttrs.type == 2023) {
                        this.pendingLayoutChanges |= 1;
                    }
                    if ((w.mAttrs.flags & 0x100000) != 0) {
                        this.mWallpaperMayChange = true;
                        this.pendingLayoutChanges |= 4;
                    }
                }
            }
            if ((atoken = w.mAppToken) != null) {
                atoken.updateLetterboxSurface((WindowState)w);
                boolean updateAllDrawn = atoken.updateDrawnWindowStates((WindowState)w);
                if (updateAllDrawn && !this.mTmpUpdateAllDrawn.contains(atoken)) {
                    this.mTmpUpdateAllDrawn.add(atoken);
                }
            }
            if (!this.mLosingFocus.isEmpty() && w.isFocused() && w.isDisplayedLw()) {
                this.mWmService.mH.obtainMessage(3, this).sendToTarget();
            }
            w.updateResizingWindowIfNeeded();
        };
        this.mAcitvityDisplay = activityDisplay;
        if (service.mRoot.getDisplayContent(display.getDisplayId()) != null) {
            throw new IllegalArgumentException("Display with ID=" + display.getDisplayId() + " already exists=" + service.mRoot.getDisplayContent(display.getDisplayId()) + " new=" + display);
        }
        this.mDisplay = display;
        this.mDisplayId = display.getDisplayId();
        this.mWallpaperController = new WallpaperController(this.mWmService, this);
        display.getDisplayInfo(this.mDisplayInfo);
        display.getMetrics(this.mDisplayMetrics);
        this.mSystemGestureExclusionLimit = this.mWmService.mSystemGestureExclusionLimitDp * this.mDisplayMetrics.densityDpi / 160;
        this.isDefaultDisplay = this.mDisplayId == 0;
        this.mDisplayFrames = new DisplayFrames(this.mDisplayId, this.mDisplayInfo, this.calculateDisplayCutoutForRotation(this.mDisplayInfo.rotation));
        this.initializeDisplayBaseInfo();
        this.mAppTransition = new AppTransition(service.mContext, service, this);
        this.mAppTransition.registerListenerLocked(service.mActivityManagerAppTransitionNotifier);
        this.mAppTransitionController = new AppTransitionController(service, this);
        this.mUnknownAppVisibilityController = new UnknownAppVisibilityController(service, this);
        AnimationHandler animationHandler = new AnimationHandler();
        this.mBoundsAnimationController = new BoundsAnimationController(service.mContext, this.mAppTransition, AnimationThread.getHandler(), animationHandler);
        InputChannel inputChannel = this.mWmService.mInputManager.monitorInput("PointerEventDispatcher" + this.mDisplayId, this.mDisplayId);
        this.mPointerEventDispatcher = new PointerEventDispatcher(inputChannel);
        this.mTapDetector = new TaskTapPointerEventListener(this.mWmService, this);
        this.registerPointerEventListener(this.mTapDetector);
        this.registerPointerEventListener(this.mWmService.mMousePositionTracker);
        if (this.mWmService.mAtmService.getRecentTasks() != null) {
            this.registerPointerEventListener(this.mWmService.mAtmService.getRecentTasks().getInputListener());
        }
        this.mDisplayPolicy = new DisplayPolicy(service, this);
        this.mDisplayRotation = new DisplayRotation(service, this);
        this.mCloseToSquareMaxAspectRatio = service.mContext.getResources().getFloat(17105052);
        if (this.isDefaultDisplay) {
            this.mWmService.mPolicy.setDefaultDisplay(this);
        }
        if (this.mWmService.mDisplayReady) {
            this.mDisplayPolicy.onConfigurationChanged();
        }
        if (this.mWmService.mSystemReady) {
            this.mDisplayPolicy.systemReady();
        }
        this.mWindowCornerRadius = this.mDisplayPolicy.getWindowCornerRadius();
        this.mDividerControllerLocked = new DockedStackDividerController(service, this);
        this.mPinnedStackControllerLocked = new PinnedStackController(service, this);
        SurfaceControl.Builder b = this.mWmService.makeSurfaceBuilder(this.mSession).setOpaque(true).setContainerLayer();
        this.mWindowingLayer = b.setName("Display Root").build();
        this.mOverlayLayer = b.setName("Display Overlays").build();
        this.getPendingTransaction().setLayer(this.mWindowingLayer, 0).setLayerStack(this.mWindowingLayer, this.mDisplayId).show(this.mWindowingLayer).setLayer(this.mOverlayLayer, 1).setLayerStack(this.mOverlayLayer, this.mDisplayId).show(this.mOverlayLayer);
        this.getPendingTransaction().apply();
        super.addChild(this.mBelowAppWindowsContainers, null);
        super.addChild(this.mTaskStackContainers, null);
        super.addChild(this.mAboveAppWindowsContainers, null);
        super.addChild(this.mImeWindowsContainers, null);
        this.mWmService.mRoot.addChild(this, null);
        this.mDisplayReady = true;
        this.mWmService.mAnimator.addDisplayLocked(this.mDisplayId);
        this.mInputMonitor = new InputMonitor(service, this.mDisplayId);
        this.mInsetsStateController = new InsetsStateController(this);
    }

    boolean isReady() {
        return this.mWmService.mDisplayReady && this.mDisplayReady;
    }

    int getDisplayId() {
        return this.mDisplayId;
    }

    float getWindowCornerRadius() {
        return this.mWindowCornerRadius;
    }

    WindowToken getWindowToken(IBinder binder) {
        return this.mTokenMap.get(binder);
    }

    AppWindowToken getAppWindowToken(IBinder binder) {
        WindowToken token = this.getWindowToken(binder);
        if (token == null) {
            return null;
        }
        return token.asAppWindowToken();
    }

    private void addWindowToken(IBinder binder, WindowToken token) {
        DisplayContent dc = this.mWmService.mRoot.getWindowTokenDisplay(token);
        if (dc != null) {
            throw new IllegalArgumentException("Can't map token=" + token + " to display=" + this.getName() + " already mapped to display=" + dc + " tokens=" + dc.mTokenMap);
        }
        if (binder == null) {
            throw new IllegalArgumentException("Can't map token=" + token + " to display=" + this.getName() + " binder is null");
        }
        if (token == null) {
            throw new IllegalArgumentException("Can't map null token to display=" + this.getName() + " binder=" + binder);
        }
        this.mTokenMap.put(binder, token);
        if (token.asAppWindowToken() == null) {
            switch (token.windowType) {
                case 2013: {
                    this.mBelowAppWindowsContainers.addChild(token);
                    break;
                }
                case 2011: 
                case 2012: {
                    this.mImeWindowsContainers.addChild(token);
                    break;
                }
                default: {
                    this.mAboveAppWindowsContainers.addChild(token);
                }
            }
        }
    }

    WindowToken removeWindowToken(IBinder binder) {
        WindowToken token = this.mTokenMap.remove(binder);
        if (token != null && token.asAppWindowToken() == null) {
            token.setExiting();
        }
        return token;
    }

    void reParentWindowToken(WindowToken token) {
        DisplayContent prevDc = token.getDisplayContent();
        if (prevDc == this) {
            return;
        }
        if (prevDc != null) {
            if (prevDc.mTokenMap.remove(token.token) != null && token.asAppWindowToken() == null) {
                token.getParent().removeChild(token);
            }
            if (prevDc.mLastFocus == this.mCurrentFocus) {
                prevDc.mLastFocus = null;
            }
        }
        this.addWindowToken(token.token, token);
    }

    void removeAppToken(IBinder binder) {
        WindowToken token = this.removeWindowToken(binder);
        if (token == null) {
            Slog.w(TAG, "removeAppToken: Attempted to remove non-existing token: " + binder);
            return;
        }
        AppWindowToken appToken = token.asAppWindowToken();
        if (appToken == null) {
            Slog.w(TAG, "Attempted to remove non-App token: " + binder + " token=" + token);
            return;
        }
        appToken.onRemovedFromDisplay();
    }

    @Override
    public Display getDisplay() {
        return this.mDisplay;
    }

    DisplayInfo getDisplayInfo() {
        return this.mDisplayInfo;
    }

    DisplayMetrics getDisplayMetrics() {
        return this.mDisplayMetrics;
    }

    DisplayPolicy getDisplayPolicy() {
        return this.mDisplayPolicy;
    }

    @Override
    public DisplayRotation getDisplayRotation() {
        return this.mDisplayRotation;
    }

    void setInsetProvider(int type, WindowState win, TriConsumer<DisplayFrames, WindowState, Rect> frameProvider) {
        this.mInsetsStateController.getSourceProvider(type).setWindow(win, frameProvider);
    }

    InsetsStateController getInsetsStateController() {
        return this.mInsetsStateController;
    }

    @VisibleForTesting
    void setDisplayRotation(DisplayRotation displayRotation) {
        this.mDisplayRotation = displayRotation;
    }

    int getRotation() {
        return this.mRotation;
    }

    @VisibleForTesting
    void setRotation(int newRotation) {
        this.mRotation = newRotation;
        this.mDisplayRotation.setRotation(newRotation);
    }

    int getLastOrientation() {
        return this.mLastOrientation;
    }

    int getLastWindowForcedOrientation() {
        return this.mLastWindowForcedOrientation;
    }

    void registerRemoteAnimations(RemoteAnimationDefinition definition) {
        this.mAppTransitionController.registerRemoteAnimations(definition);
    }

    void pauseRotationLocked() {
        ++this.mDeferredRotationPauseCount;
    }

    void resumeRotationLocked() {
        if (this.mDeferredRotationPauseCount <= 0) {
            return;
        }
        --this.mDeferredRotationPauseCount;
        if (this.mDeferredRotationPauseCount == 0) {
            this.updateRotationAndSendNewConfigIfNeeded();
        }
    }

    boolean rotationNeedsUpdate() {
        int rotation;
        int lastOrientation = this.getLastOrientation();
        int oldRotation = this.getRotation();
        return oldRotation != (rotation = this.mDisplayRotation.rotationForOrientation(lastOrientation, oldRotation));
    }

    void initializeDisplayOverrideConfiguration() {
        if (this.mAcitvityDisplay != null) {
            this.mAcitvityDisplay.onInitializeOverrideConfiguration(this.getRequestedOverrideConfiguration());
        }
    }

    void sendNewConfiguration() {
        this.mWmService.mH.obtainMessage(18, this).sendToTarget();
    }

    @Override
    boolean onDescendantOrientationChanged(IBinder freezeDisplayToken, ConfigurationContainer requestingContainer) {
        Configuration config = this.updateOrientationFromAppTokens(this.getRequestedOverrideConfiguration(), freezeDisplayToken, false);
        boolean handled = this.getDisplayRotation().respectAppRequestedOrientation();
        if (config == null) {
            return handled;
        }
        if (handled && requestingContainer instanceof ActivityRecord) {
            ActivityRecord activityRecord = (ActivityRecord)requestingContainer;
            boolean kept = this.mWmService.mAtmService.updateDisplayOverrideConfigurationLocked(config, activityRecord, false, this.getDisplayId());
            activityRecord.frozenBeforeDestroy = true;
            if (!kept) {
                this.mWmService.mAtmService.mRootActivityContainer.resumeFocusedStacksTopActivities();
            }
        } else {
            this.mWmService.mAtmService.updateDisplayOverrideConfigurationLocked(config, null, false, this.getDisplayId());
        }
        return handled;
    }

    @Override
    boolean handlesOrientationChangeFromDescendant() {
        return this.getDisplayRotation().respectAppRequestedOrientation();
    }

    boolean updateOrientationFromAppTokens() {
        return this.updateOrientationFromAppTokens(false);
    }

    Configuration updateOrientationFromAppTokens(Configuration currentConfig, IBinder freezeDisplayToken, boolean forceUpdate) {
        if (!this.mDisplayReady) {
            return null;
        }
        Configuration config = null;
        if (this.updateOrientationFromAppTokens(forceUpdate)) {
            AppWindowToken atoken;
            if (freezeDisplayToken != null && !this.mWmService.mRoot.mOrientationChangeComplete && (atoken = this.getAppWindowToken(freezeDisplayToken)) != null) {
                atoken.startFreezingScreen();
            }
            config = new Configuration();
            this.computeScreenConfiguration(config);
        } else if (currentConfig != null) {
            this.mTmpConfiguration.unset();
            this.mTmpConfiguration.updateFrom(currentConfig);
            this.computeScreenConfiguration(this.mTmpConfiguration);
            if (currentConfig.diff(this.mTmpConfiguration) != 0) {
                this.mWaitingForConfig = true;
                this.setLayoutNeeded();
                int[] anim2 = new int[2];
                this.getDisplayPolicy().selectRotationAnimationLw(anim2);
                this.mWmService.startFreezingDisplayLocked(anim2[0], anim2[1], this);
                config = new Configuration(this.mTmpConfiguration);
            }
        }
        return config;
    }

    private boolean updateOrientationFromAppTokens(boolean forceUpdate) {
        int req = this.getOrientation();
        if (req != this.mLastOrientation || forceUpdate) {
            this.mLastOrientation = req;
            this.mDisplayRotation.setCurrentOrientation(req);
            return this.updateRotationUnchecked(forceUpdate);
        }
        return false;
    }

    boolean updateRotationAndSendNewConfigIfNeeded() {
        boolean changed = this.updateRotationUnchecked(false);
        if (changed) {
            this.sendNewConfiguration();
        }
        return changed;
    }

    boolean updateRotationUnchecked() {
        return this.updateRotationUnchecked(false);
    }

    boolean updateRotationUnchecked(boolean forceUpdate) {
        if (!forceUpdate) {
            if (this.mDeferredRotationPauseCount > 0) {
                return false;
            }
            ScreenRotationAnimation screenRotationAnimation = this.mWmService.mAnimator.getScreenRotationAnimationLocked(this.mDisplayId);
            if (screenRotationAnimation != null && screenRotationAnimation.isAnimating()) {
                return false;
            }
            if (this.mWmService.mDisplayFrozen) {
                return false;
            }
        }
        if (!this.mWmService.mDisplayEnabled) {
            return false;
        }
        int oldRotation = this.mRotation;
        int lastOrientation = this.mLastOrientation;
        int rotation = this.mDisplayRotation.rotationForOrientation(lastOrientation, oldRotation);
        boolean mayRotateSeamlessly = this.mDisplayPolicy.shouldRotateSeamlessly(this.mDisplayRotation, oldRotation, rotation);
        if (mayRotateSeamlessly) {
            WindowState seamlessRotated = this.getWindow(w -> w.mSeamlesslyRotated);
            if (seamlessRotated != null && !forceUpdate) {
                return false;
            }
            if (this.hasPinnedStack()) {
                mayRotateSeamlessly = false;
            }
            for (int i = 0; i < this.mWmService.mSessions.size(); ++i) {
                if (!this.mWmService.mSessions.valueAt(i).hasAlertWindowSurfaces()) continue;
                mayRotateSeamlessly = false;
                break;
            }
        }
        boolean rotateSeamlessly = mayRotateSeamlessly;
        if (oldRotation == rotation) {
            return false;
        }
        if (DisplayContent.deltaRotation(rotation, oldRotation) != 2) {
            this.mWaitingForConfig = true;
        }
        this.mRotation = rotation;
        this.mWmService.mWindowsFreezingScreen = 1;
        this.mWmService.mH.sendNewMessageDelayed(11, this, 2000L);
        this.setLayoutNeeded();
        int[] anim2 = new int[2];
        this.mDisplayPolicy.selectRotationAnimationLw(anim2);
        if (!rotateSeamlessly) {
            this.mWmService.startFreezingDisplayLocked(anim2[0], anim2[1], this);
        } else {
            this.mWmService.startSeamlessRotation();
        }
        return true;
    }

    void applyRotationLocked(int oldRotation, int rotation) {
        this.mDisplayRotation.setRotation(rotation);
        boolean rotateSeamlessly = this.mWmService.isRotatingSeamlessly();
        ScreenRotationAnimation screenRotationAnimation = rotateSeamlessly ? null : this.mWmService.mAnimator.getScreenRotationAnimationLocked(this.mDisplayId);
        this.updateDisplayAndOrientation(this.getConfiguration().uiMode, null);
        if (screenRotationAnimation != null && screenRotationAnimation.hasScreenshot() && screenRotationAnimation.setRotation(this.getPendingTransaction(), rotation, 10000L, this.mWmService.getTransitionAnimationScaleLocked(), this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight)) {
            this.mWmService.scheduleAnimationLocked();
        }
        this.forAllWindows((WindowState w) -> w.seamlesslyRotateIfAllowed(this.getPendingTransaction(), oldRotation, rotation, rotateSeamlessly), true);
        this.mWmService.mDisplayManagerInternal.performTraversal(this.getPendingTransaction());
        this.scheduleAnimation();
        this.forAllWindows((WindowState w) -> {
            if (w.mHasSurface && !rotateSeamlessly) {
                w.setOrientationChanging(true);
                this.mWmService.mRoot.mOrientationChangeComplete = false;
                w.mLastFreezeDuration = 0;
            }
            w.mReportOrientationChanged = true;
        }, true);
        if (rotateSeamlessly) {
            this.mWmService.mH.sendNewMessageDelayed(54, this, 2000L);
        }
        for (int i = this.mWmService.mRotationWatchers.size() - 1; i >= 0; --i) {
            WindowManagerService.RotationWatcher rotationWatcher = this.mWmService.mRotationWatchers.get(i);
            if (rotationWatcher.mDisplayId != this.mDisplayId) continue;
            try {
                rotationWatcher.mWatcher.onRotationChanged(rotation);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (screenRotationAnimation == null && this.mWmService.mAccessibilityController != null) {
            this.mWmService.mAccessibilityController.onRotationChangedLocked(this);
        }
    }

    void configureDisplayPolicy() {
        int longSize;
        int shortSize;
        int width = this.mBaseDisplayWidth;
        int height = this.mBaseDisplayHeight;
        if (width > height) {
            shortSize = height;
            longSize = width;
        } else {
            shortSize = width;
            longSize = height;
        }
        int shortSizeDp = shortSize * 160 / this.mBaseDisplayDensity;
        int longSizeDp = longSize * 160 / this.mBaseDisplayDensity;
        this.mDisplayPolicy.updateConfigurationAndScreenSizeDependentBehaviors();
        this.mDisplayRotation.configure(width, height, shortSizeDp, longSizeDp);
        this.mDisplayFrames.onDisplayInfoUpdated(this.mDisplayInfo, this.calculateDisplayCutoutForRotation(this.mDisplayInfo.rotation));
        this.mIgnoreRotationForApps = this.isNonDecorDisplayCloseToSquare(0, width, height);
    }

    private boolean isNonDecorDisplayCloseToSquare(int rotation, int width, int height) {
        int h;
        DisplayCutout displayCutout = this.calculateDisplayCutoutForRotation(rotation).getDisplayCutout();
        int uiMode = this.mWmService.mPolicy.getUiMode();
        int w = this.mDisplayPolicy.getNonDecorDisplayWidth(width, height, rotation, uiMode, displayCutout);
        float aspectRatio = (float)Math.max(w, h = this.mDisplayPolicy.getNonDecorDisplayHeight(width, height, rotation, uiMode, displayCutout)) / (float)Math.min(w, h);
        return aspectRatio <= this.mCloseToSquareMaxAspectRatio;
    }

    private DisplayInfo updateDisplayAndOrientation(int uiMode, Configuration outConfig) {
        boolean rotated = this.mRotation == 1 || this.mRotation == 3;
        int dw = rotated ? this.mBaseDisplayHeight : this.mBaseDisplayWidth;
        int dh = rotated ? this.mBaseDisplayWidth : this.mBaseDisplayHeight;
        WmDisplayCutout wmDisplayCutout = this.calculateDisplayCutoutForRotation(this.mRotation);
        DisplayCutout displayCutout = wmDisplayCutout.getDisplayCutout();
        int appWidth = this.mDisplayPolicy.getNonDecorDisplayWidth(dw, dh, this.mRotation, uiMode, displayCutout);
        int appHeight = this.mDisplayPolicy.getNonDecorDisplayHeight(dw, dh, this.mRotation, uiMode, displayCutout);
        this.mDisplayInfo.rotation = this.mRotation;
        this.mDisplayInfo.logicalWidth = dw;
        this.mDisplayInfo.logicalHeight = dh;
        this.mDisplayInfo.logicalDensityDpi = this.mBaseDisplayDensity;
        this.mDisplayInfo.appWidth = appWidth;
        this.mDisplayInfo.appHeight = appHeight;
        if (this.isDefaultDisplay) {
            this.mDisplayInfo.getLogicalMetrics(this.mRealDisplayMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
        }
        this.mDisplayInfo.displayCutout = displayCutout.isEmpty() ? null : displayCutout;
        this.mDisplayInfo.getAppMetrics(this.mDisplayMetrics);
        this.mDisplayInfo.flags = this.mDisplayScalingDisabled ? (this.mDisplayInfo.flags |= 0x40000000) : (this.mDisplayInfo.flags &= 0xBFFFFFFF);
        this.computeSizeRangesAndScreenLayout(this.mDisplayInfo, rotated, uiMode, dw, dh, this.mDisplayMetrics.density, outConfig);
        DisplayInfo overrideDisplayInfo = this.mShouldOverrideDisplayConfiguration ? this.mDisplayInfo : null;
        this.mWmService.mDisplayManagerInternal.setDisplayInfoOverrideFromWindowManager(this.mDisplayId, overrideDisplayInfo);
        this.mBaseDisplayRect.set(0, 0, dw, dh);
        if (this.isDefaultDisplay) {
            this.mCompatibleScreenScale = CompatibilityInfo.computeCompatibleScaling(this.mDisplayMetrics, this.mCompatDisplayMetrics);
        }
        return this.mDisplayInfo;
    }

    WmDisplayCutout calculateDisplayCutoutForRotation(int rotation) {
        return this.mDisplayCutoutCache.getOrCompute(this.mInitialDisplayCutout, rotation);
    }

    private WmDisplayCutout calculateDisplayCutoutForRotationUncached(DisplayCutout cutout, int rotation) {
        if (cutout == null || cutout == DisplayCutout.NO_CUTOUT) {
            return WmDisplayCutout.NO_CUTOUT;
        }
        if (rotation == 0) {
            return WmDisplayCutout.computeSafeInsets(cutout, this.mInitialDisplayWidth, this.mInitialDisplayHeight);
        }
        boolean rotated = rotation == 1 || rotation == 3;
        Rect[] newBounds = this.mRotationUtil.getRotatedBounds(WmDisplayCutout.computeSafeInsets(cutout, this.mInitialDisplayWidth, this.mInitialDisplayHeight).getDisplayCutout().getBoundingRectsAll(), rotation, this.mInitialDisplayWidth, this.mInitialDisplayHeight);
        return WmDisplayCutout.computeSafeInsets(DisplayCutout.fromBounds(newBounds), rotated ? this.mInitialDisplayHeight : this.mInitialDisplayWidth, rotated ? this.mInitialDisplayWidth : this.mInitialDisplayHeight);
    }

    void computeScreenConfiguration(Configuration config) {
        boolean hardKeyboardAvailable;
        DisplayInfo displayInfo = this.updateDisplayAndOrientation(config.uiMode, config);
        this.calculateBounds(displayInfo, this.mTmpBounds);
        config.windowConfiguration.setBounds(this.mTmpBounds);
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        config.orientation = dw <= dh ? 1 : 2;
        config.windowConfiguration.setWindowingMode(this.getWindowingMode());
        config.windowConfiguration.setDisplayWindowingMode(this.getWindowingMode());
        config.windowConfiguration.setRotation(displayInfo.rotation);
        float density = this.mDisplayMetrics.density;
        config.screenWidthDp = (int)((float)this.mDisplayPolicy.getConfigDisplayWidth(dw, dh, displayInfo.rotation, config.uiMode, displayInfo.displayCutout) / density);
        config.screenHeightDp = (int)((float)this.mDisplayPolicy.getConfigDisplayHeight(dw, dh, displayInfo.rotation, config.uiMode, displayInfo.displayCutout) / density);
        this.mDisplayPolicy.getNonDecorInsetsLw(displayInfo.rotation, dw, dh, displayInfo.displayCutout, this.mTmpRect);
        int leftInset = this.mTmpRect.left;
        int topInset = this.mTmpRect.top;
        config.windowConfiguration.setAppBounds(leftInset, topInset, leftInset + displayInfo.appWidth, topInset + displayInfo.appHeight);
        boolean rotated = displayInfo.rotation == 1 || displayInfo.rotation == 3;
        config.screenLayout = config.screenLayout & 0xFFFFFCFF | ((displayInfo.flags & 0x10) != 0 ? 512 : 256);
        config.compatScreenWidthDp = (int)((float)config.screenWidthDp / this.mCompatibleScreenScale);
        config.compatScreenHeightDp = (int)((float)config.screenHeightDp / this.mCompatibleScreenScale);
        config.compatSmallestScreenWidthDp = this.computeCompatSmallestWidth(rotated, config.uiMode, dw, dh, displayInfo.displayCutout);
        config.densityDpi = displayInfo.logicalDensityDpi;
        config.colorMode = (displayInfo.isHdr() && this.mWmService.hasHdrSupport() ? 8 : 4) | (displayInfo.isWideColorGamut() && this.mWmService.hasWideColorGamutSupport() ? 2 : 1);
        config.touchscreen = 1;
        config.keyboard = 1;
        config.navigation = 1;
        int keyboardPresence = 0;
        int navigationPresence = 0;
        InputDevice[] devices = this.mWmService.mInputManager.getInputDevices();
        int len = devices != null ? devices.length : 0;
        for (int i = 0; i < len; ++i) {
            int presenceFlag;
            InputDevice device = devices[i];
            if (device.isVirtual() || !this.mWmService.mInputManager.canDispatchToDisplay(device.getId(), displayInfo.type == 5 ? 0 : this.mDisplayId)) continue;
            int sources = device.getSources();
            int n = presenceFlag = device.isExternal() ? 2 : 1;
            if (this.mWmService.mIsTouchDevice) {
                if ((sources & 0x1002) == 4098) {
                    config.touchscreen = 3;
                }
            } else {
                config.touchscreen = 1;
            }
            if ((sources & 0x10004) == 65540) {
                config.navigation = 3;
                navigationPresence |= presenceFlag;
            } else if ((sources & 0x201) == 513 && config.navigation == 1) {
                config.navigation = 2;
                navigationPresence |= presenceFlag;
            }
            if (device.getKeyboardType() != 2) continue;
            config.keyboard = 2;
            keyboardPresence |= presenceFlag;
        }
        if (config.navigation == 1 && this.mWmService.mHasPermanentDpad) {
            config.navigation = 2;
            navigationPresence |= 1;
        }
        boolean bl = hardKeyboardAvailable = config.keyboard != 1;
        if (hardKeyboardAvailable != this.mWmService.mHardKeyboardAvailable) {
            this.mWmService.mHardKeyboardAvailable = hardKeyboardAvailable;
            this.mWmService.mH.removeMessages(22);
            this.mWmService.mH.sendEmptyMessage(22);
        }
        this.mDisplayPolicy.updateConfigurationAndScreenSizeDependentBehaviors();
        config.keyboardHidden = 1;
        config.hardKeyboardHidden = 1;
        config.navigationHidden = 1;
        this.mWmService.mPolicy.adjustConfigurationLw(config, keyboardPresence, navigationPresence);
    }

    private int computeCompatSmallestWidth(boolean rotated, int uiMode, int dw, int dh, DisplayCutout displayCutout) {
        int unrotDh;
        int unrotDw;
        this.mTmpDisplayMetrics.setTo(this.mDisplayMetrics);
        DisplayMetrics tmpDm = this.mTmpDisplayMetrics;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        int sw = this.reduceCompatConfigWidthSize(0, 0, uiMode, tmpDm, unrotDw, unrotDh, displayCutout);
        sw = this.reduceCompatConfigWidthSize(sw, 1, uiMode, tmpDm, unrotDh, unrotDw, displayCutout);
        sw = this.reduceCompatConfigWidthSize(sw, 2, uiMode, tmpDm, unrotDw, unrotDh, displayCutout);
        sw = this.reduceCompatConfigWidthSize(sw, 3, uiMode, tmpDm, unrotDh, unrotDw, displayCutout);
        return sw;
    }

    private int reduceCompatConfigWidthSize(int curSize, int rotation, int uiMode, DisplayMetrics dm, int dw, int dh, DisplayCutout displayCutout) {
        dm.noncompatWidthPixels = this.mDisplayPolicy.getNonDecorDisplayWidth(dw, dh, rotation, uiMode, displayCutout);
        dm.noncompatHeightPixels = this.mDisplayPolicy.getNonDecorDisplayHeight(dw, dh, rotation, uiMode, displayCutout);
        float scale = CompatibilityInfo.computeCompatibleScaling(dm, null);
        int size = (int)((float)dm.noncompatWidthPixels / scale / dm.density + 0.5f);
        if (curSize == 0 || size < curSize) {
            curSize = size;
        }
        return curSize;
    }

    private void computeSizeRangesAndScreenLayout(DisplayInfo displayInfo, boolean rotated, int uiMode, int dw, int dh, float density, Configuration outConfig) {
        int unrotDh;
        int unrotDw;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        displayInfo.smallestNominalAppWidth = 0x40000000;
        displayInfo.smallestNominalAppHeight = 0x40000000;
        displayInfo.largestNominalAppWidth = 0;
        displayInfo.largestNominalAppHeight = 0;
        this.adjustDisplaySizeRanges(displayInfo, 0, uiMode, unrotDw, unrotDh);
        this.adjustDisplaySizeRanges(displayInfo, 1, uiMode, unrotDh, unrotDw);
        this.adjustDisplaySizeRanges(displayInfo, 2, uiMode, unrotDw, unrotDh);
        this.adjustDisplaySizeRanges(displayInfo, 3, uiMode, unrotDh, unrotDw);
        if (outConfig == null) {
            return;
        }
        int sl = Configuration.resetScreenLayout(outConfig.screenLayout);
        sl = this.reduceConfigLayout(sl, 0, density, unrotDw, unrotDh, uiMode, displayInfo.displayCutout);
        sl = this.reduceConfigLayout(sl, 1, density, unrotDh, unrotDw, uiMode, displayInfo.displayCutout);
        sl = this.reduceConfigLayout(sl, 2, density, unrotDw, unrotDh, uiMode, displayInfo.displayCutout);
        sl = this.reduceConfigLayout(sl, 3, density, unrotDh, unrotDw, uiMode, displayInfo.displayCutout);
        outConfig.smallestScreenWidthDp = (int)((float)displayInfo.smallestNominalAppWidth / density);
        outConfig.screenLayout = sl;
    }

    private int reduceConfigLayout(int curLayout, int rotation, float density, int dw, int dh, int uiMode, DisplayCutout displayCutout) {
        int h;
        int shortSize;
        int w = this.mDisplayPolicy.getNonDecorDisplayWidth(dw, dh, rotation, uiMode, displayCutout);
        int longSize = w;
        if (longSize < (shortSize = (h = this.mDisplayPolicy.getNonDecorDisplayHeight(dw, dh, rotation, uiMode, displayCutout)))) {
            int tmp = longSize;
            longSize = shortSize;
            shortSize = tmp;
        }
        longSize = (int)((float)longSize / density);
        shortSize = (int)((float)shortSize / density);
        return Configuration.reduceScreenLayout(curLayout, longSize, shortSize);
    }

    private void adjustDisplaySizeRanges(DisplayInfo displayInfo, int rotation, int uiMode, int dw, int dh) {
        int height;
        DisplayCutout displayCutout = this.calculateDisplayCutoutForRotation(rotation).getDisplayCutout();
        int width = this.mDisplayPolicy.getConfigDisplayWidth(dw, dh, rotation, uiMode, displayCutout);
        if (width < displayInfo.smallestNominalAppWidth) {
            displayInfo.smallestNominalAppWidth = width;
        }
        if (width > displayInfo.largestNominalAppWidth) {
            displayInfo.largestNominalAppWidth = width;
        }
        if ((height = this.mDisplayPolicy.getConfigDisplayHeight(dw, dh, rotation, uiMode, displayCutout)) < displayInfo.smallestNominalAppHeight) {
            displayInfo.smallestNominalAppHeight = height;
        }
        if (height > displayInfo.largestNominalAppHeight) {
            displayInfo.largestNominalAppHeight = height;
        }
    }

    int getPreferredOptionsPanelGravity() {
        int rotation = this.getRotation();
        if (this.mInitialDisplayWidth < this.mInitialDisplayHeight) {
            switch (rotation) {
                default: {
                    return 81;
                }
                case 1: {
                    return 85;
                }
                case 2: {
                    return 81;
                }
                case 3: 
            }
            return 8388691;
        }
        switch (rotation) {
            default: {
                return 85;
            }
            case 1: {
                return 81;
            }
            case 2: {
                return 8388691;
            }
            case 3: 
        }
        return 81;
    }

    DockedStackDividerController getDockedDividerController() {
        return this.mDividerControllerLocked;
    }

    PinnedStackController getPinnedStackController() {
        return this.mPinnedStackControllerLocked;
    }

    boolean hasAccess(int uid) {
        return this.mDisplay.hasAccess(uid);
    }

    boolean isPrivate() {
        return (this.mDisplay.getFlags() & 4) != 0;
    }

    TaskStack getHomeStack() {
        return this.mTaskStackContainers.getHomeStack();
    }

    TaskStack getSplitScreenPrimaryStack() {
        TaskStack stack = this.mTaskStackContainers.getSplitScreenPrimaryStack();
        return stack != null && stack.isVisible() ? stack : null;
    }

    boolean hasSplitScreenPrimaryStack() {
        return this.getSplitScreenPrimaryStack() != null;
    }

    TaskStack getSplitScreenPrimaryStackIgnoringVisibility() {
        return this.mTaskStackContainers.getSplitScreenPrimaryStack();
    }

    TaskStack getPinnedStack() {
        return this.mTaskStackContainers.getPinnedStack();
    }

    private boolean hasPinnedStack() {
        return this.mTaskStackContainers.getPinnedStack() != null;
    }

    TaskStack getTopStackInWindowingMode(int windowingMode) {
        return this.getStack(windowingMode, 0);
    }

    TaskStack getStack(int windowingMode, int activityType) {
        return this.mTaskStackContainers.getStack(windowingMode, activityType);
    }

    @VisibleForTesting
    WindowList<TaskStack> getStacks() {
        return this.mTaskStackContainers.mChildren;
    }

    @VisibleForTesting
    TaskStack getTopStack() {
        return this.mTaskStackContainers.getTopStack();
    }

    ArrayList<Task> getVisibleTasks() {
        return this.mTaskStackContainers.getVisibleTasks();
    }

    void onStackWindowingModeChanged(TaskStack stack) {
        this.mTaskStackContainers.onStackWindowingModeChanged(stack);
    }

    @Override
    public void onConfigurationChanged(Configuration newParentConfig) {
        int lastOrientation = this.getConfiguration().orientation;
        super.onConfigurationChanged(newParentConfig);
        if (this.mDisplayPolicy != null) {
            this.mDisplayPolicy.onConfigurationChanged();
        }
        if (lastOrientation != this.getConfiguration().orientation) {
            this.getMetricsLogger().write(new LogMaker(1659).setSubtype(this.getConfiguration().orientation).addTaggedData(1660, this.getDisplayId()));
        }
        if (this.mPinnedStackControllerLocked != null && !this.hasPinnedStack()) {
            this.mPinnedStackControllerLocked.onDisplayInfoChanged(this.getDisplayInfo());
        }
    }

    void preOnConfigurationChanged() {
        PinnedStackController pinnedStackController;
        DockedStackDividerController dividerController = this.getDockedDividerController();
        if (dividerController != null) {
            this.getDockedDividerController().onConfigurationChanged();
        }
        if ((pinnedStackController = this.getPinnedStackController()) != null) {
            this.getPinnedStackController().onConfigurationChanged();
        }
    }

    @Override
    boolean fillsParent() {
        return true;
    }

    @Override
    boolean isVisible() {
        return true;
    }

    @Override
    void onAppTransitionDone() {
        super.onAppTransitionDone();
        this.mWmService.mWindowsChanged = true;
    }

    @Override
    public void setWindowingMode(int windowingMode) {
        super.setWindowingMode(windowingMode);
        super.setDisplayWindowingMode(windowingMode);
    }

    @Override
    void setDisplayWindowingMode(int windowingMode) {
        this.setWindowingMode(windowingMode);
    }

    private boolean skipTraverseChild(WindowContainer child) {
        return child == this.mImeWindowsContainers && this.mInputMethodTarget != null && !this.hasSplitScreenPrimaryStack();
    }

    @Override
    boolean forAllWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        if (traverseTopToBottom) {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                DisplayChildWindowContainer child = (DisplayChildWindowContainer)this.mChildren.get(i);
                if (this.skipTraverseChild(child) || !child.forAllWindows(callback, traverseTopToBottom)) continue;
                return true;
            }
        } else {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                DisplayChildWindowContainer child = (DisplayChildWindowContainer)this.mChildren.get(i);
                if (this.skipTraverseChild(child) || !child.forAllWindows(callback, traverseTopToBottom)) continue;
                return true;
            }
        }
        return false;
    }

    boolean forAllImeWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        return this.mImeWindowsContainers.forAllWindows(callback, traverseTopToBottom);
    }

    @Override
    int getOrientation() {
        WindowManagerPolicy policy = this.mWmService.mPolicy;
        if (this.mIgnoreRotationForApps) {
            return 2;
        }
        if (this.mWmService.mDisplayFrozen) {
            if (this.mLastWindowForcedOrientation != -1) {
                return this.mLastWindowForcedOrientation;
            }
            if (policy.isKeyguardLocked()) {
                return this.mLastOrientation;
            }
        } else {
            int orientation = this.mAboveAppWindowsContainers.getOrientation();
            if (orientation != -2) {
                return orientation;
            }
        }
        return this.mTaskStackContainers.getOrientation();
    }

    void updateDisplayInfo() {
        this.updateBaseDisplayMetricsIfNeeded();
        this.mDisplay.getDisplayInfo(this.mDisplayInfo);
        this.mDisplay.getMetrics(this.mDisplayMetrics);
        this.onDisplayChanged(this);
    }

    @Override
    void onDisplayChanged(DisplayContent dc) {
        super.onDisplayChanged(dc);
        this.updateSystemGestureExclusionLimit();
    }

    void updateSystemGestureExclusionLimit() {
        this.mSystemGestureExclusionLimit = this.mWmService.mSystemGestureExclusionLimitDp * this.mDisplayMetrics.densityDpi / 160;
        this.updateSystemGestureExclusion();
    }

    void initializeDisplayBaseInfo() {
        DisplayInfo newDisplayInfo;
        DisplayManagerInternal displayManagerInternal = this.mWmService.mDisplayManagerInternal;
        if (displayManagerInternal != null && (newDisplayInfo = displayManagerInternal.getDisplayInfo(this.mDisplayId)) != null) {
            this.mDisplayInfo.copyFrom(newDisplayInfo);
        }
        this.updateBaseDisplayMetrics(this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight, this.mDisplayInfo.logicalDensityDpi);
        this.mInitialDisplayWidth = this.mDisplayInfo.logicalWidth;
        this.mInitialDisplayHeight = this.mDisplayInfo.logicalHeight;
        this.mInitialDisplayDensity = this.mDisplayInfo.logicalDensityDpi;
        this.mInitialDisplayCutout = this.mDisplayInfo.displayCutout;
    }

    private void updateBaseDisplayMetricsIfNeeded() {
        boolean displayMetricsChanged;
        this.mWmService.mDisplayManagerInternal.getNonOverrideDisplayInfo(this.mDisplayId, this.mDisplayInfo);
        int orientation = this.mDisplayInfo.rotation;
        boolean rotated = orientation == 1 || orientation == 3;
        int newWidth = rotated ? this.mDisplayInfo.logicalHeight : this.mDisplayInfo.logicalWidth;
        int newHeight = rotated ? this.mDisplayInfo.logicalWidth : this.mDisplayInfo.logicalHeight;
        int newDensity = this.mDisplayInfo.logicalDensityDpi;
        DisplayCutout newCutout = this.mDisplayInfo.displayCutout;
        boolean bl = displayMetricsChanged = this.mInitialDisplayWidth != newWidth || this.mInitialDisplayHeight != newHeight || this.mInitialDisplayDensity != this.mDisplayInfo.logicalDensityDpi || !Objects.equals(this.mInitialDisplayCutout, newCutout);
        if (displayMetricsChanged) {
            boolean isDisplaySizeForced = this.mBaseDisplayWidth != this.mInitialDisplayWidth || this.mBaseDisplayHeight != this.mInitialDisplayHeight;
            boolean isDisplayDensityForced = this.mBaseDisplayDensity != this.mInitialDisplayDensity;
            this.updateBaseDisplayMetrics(isDisplaySizeForced ? this.mBaseDisplayWidth : newWidth, isDisplaySizeForced ? this.mBaseDisplayHeight : newHeight, isDisplayDensityForced ? this.mBaseDisplayDensity : newDensity);
            this.mInitialDisplayWidth = newWidth;
            this.mInitialDisplayHeight = newHeight;
            this.mInitialDisplayDensity = newDensity;
            this.mInitialDisplayCutout = newCutout;
            this.mWmService.reconfigureDisplayLocked(this);
        }
    }

    void setMaxUiWidth(int width) {
        this.mMaxUiWidth = width;
        this.updateBaseDisplayMetrics(this.mBaseDisplayWidth, this.mBaseDisplayHeight, this.mBaseDisplayDensity);
    }

    void updateBaseDisplayMetrics(int baseWidth, int baseHeight, int baseDensity) {
        this.mBaseDisplayWidth = baseWidth;
        this.mBaseDisplayHeight = baseHeight;
        this.mBaseDisplayDensity = baseDensity;
        if (this.mMaxUiWidth > 0 && this.mBaseDisplayWidth > this.mMaxUiWidth) {
            this.mBaseDisplayHeight = this.mMaxUiWidth * this.mBaseDisplayHeight / this.mBaseDisplayWidth;
            this.mBaseDisplayDensity = this.mMaxUiWidth * this.mBaseDisplayDensity / this.mBaseDisplayWidth;
            this.mBaseDisplayWidth = this.mMaxUiWidth;
        }
        this.mBaseDisplayRect.set(0, 0, this.mBaseDisplayWidth, this.mBaseDisplayHeight);
        this.updateBounds();
    }

    void setForcedDensity(int density, int userId) {
        boolean updateCurrent;
        boolean clear = density == this.mInitialDisplayDensity;
        boolean bl = updateCurrent = userId == -2;
        if (this.mWmService.mCurrentUserId == userId || updateCurrent) {
            this.mBaseDisplayDensity = density;
            this.mWmService.reconfigureDisplayLocked(this);
        }
        if (updateCurrent) {
            return;
        }
        if (density == this.mInitialDisplayDensity) {
            density = 0;
        }
        this.mWmService.mDisplayWindowSettings.setForcedDensity(this, density, userId);
    }

    void setForcedScalingMode(int mode) {
        if (mode != 1) {
            mode = 0;
        }
        this.mDisplayScalingDisabled = mode != 0;
        Slog.i(TAG, "Using display scaling mode: " + (this.mDisplayScalingDisabled ? "off" : "auto"));
        this.mWmService.reconfigureDisplayLocked(this);
        this.mWmService.mDisplayWindowSettings.setForcedScalingMode(this, mode);
    }

    void setForcedSize(int width, int height) {
        boolean clear;
        boolean bl = clear = this.mInitialDisplayWidth == width && this.mInitialDisplayHeight == height;
        if (!clear) {
            int minSize = 200;
            int maxScale = 2;
            width = Math.min(Math.max(width, 200), this.mInitialDisplayWidth * 2);
            height = Math.min(Math.max(height, 200), this.mInitialDisplayHeight * 2);
        }
        Slog.i(TAG, "Using new display size: " + width + "x" + height);
        this.updateBaseDisplayMetrics(width, height, this.mBaseDisplayDensity);
        this.mWmService.reconfigureDisplayLocked(this);
        if (clear) {
            height = 0;
            width = 0;
        }
        this.mWmService.mDisplayWindowSettings.setForcedSize(this, width, height);
    }

    void getStableRect(Rect out) {
        out.set(this.mDisplayFrames.mStable);
    }

    void setStackOnDisplay(int stackId, boolean onTop, TaskStack stack) {
        this.mTaskStackContainers.addStackToDisplay(stack, onTop);
    }

    void moveStackToDisplay(TaskStack stack, boolean onTop) {
        DisplayContent prevDc = stack.getDisplayContent();
        if (prevDc == null) {
            throw new IllegalStateException("Trying to move stackId=" + stack.mStackId + " which is not currently attached to any display");
        }
        if (prevDc.getDisplayId() == this.mDisplayId) {
            throw new IllegalArgumentException("Trying to move stackId=" + stack.mStackId + " to its current displayId=" + this.mDisplayId);
        }
        prevDc.mTaskStackContainers.removeChild(stack);
        this.mTaskStackContainers.addStackToDisplay(stack, onTop);
    }

    @Override
    protected void addChild(DisplayChildWindowContainer child, Comparator<DisplayChildWindowContainer> comparator) {
        throw new UnsupportedOperationException("See DisplayChildWindowContainer");
    }

    @Override
    protected void addChild(DisplayChildWindowContainer child, int index) {
        throw new UnsupportedOperationException("See DisplayChildWindowContainer");
    }

    @Override
    protected void removeChild(DisplayChildWindowContainer child) {
        if (this.mRemovingDisplay) {
            super.removeChild(child);
            return;
        }
        throw new UnsupportedOperationException("See DisplayChildWindowContainer");
    }

    @Override
    void positionChildAt(int position, DisplayChildWindowContainer child, boolean includingParents) {
        this.getParent().positionChildAt(position, this, includingParents);
    }

    void positionStackAt(int position, TaskStack child, boolean includingParents) {
        this.mTaskStackContainers.positionChildAt(position, child, includingParents);
        this.layoutAndAssignWindowLayersIfNeeded();
    }

    boolean pointWithinAppWindow(int x, int y) {
        int[] targetWindowType = new int[]{-1};
        PooledConsumer<WindowState> fn = PooledLambda.obtainConsumer((w, nonArg) -> {
            if (targetWindowType[0] != -1) {
                return;
            }
            if (w.isOnScreen() && w.isVisibleLw() && w.getFrameLw().contains(x, y)) {
                targetWindowType[0] = w.mAttrs.type;
                return;
            }
        }, PooledLambda.__(WindowState.class), this.mTmpRect);
        this.forAllWindows(fn, true);
        fn.recycle();
        return 1 <= targetWindowType[0] && targetWindowType[0] <= 99;
    }

    Task findTaskForResizePoint(int x, int y) {
        int delta = WindowManagerService.dipToPixel(30, this.mDisplayMetrics);
        this.mTmpTaskForResizePointSearchResult.reset();
        for (int stackNdx = this.mTaskStackContainers.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(stackNdx);
            if (!stack.getWindowConfiguration().canResizeTask()) {
                return null;
            }
            stack.findTaskForResizePoint(x, y, delta, this.mTmpTaskForResizePointSearchResult);
            if (!this.mTmpTaskForResizePointSearchResult.searchDone) continue;
            return this.mTmpTaskForResizePointSearchResult.taskForResize;
        }
        return null;
    }

    void updateTouchExcludeRegion() {
        Task focusedTask;
        Task task = focusedTask = this.mFocusedApp != null ? this.mFocusedApp.getTask() : null;
        if (focusedTask == null) {
            this.mTouchExcludeRegion.setEmpty();
        } else {
            this.mTouchExcludeRegion.set(this.mBaseDisplayRect);
            int delta = WindowManagerService.dipToPixel(30, this.mDisplayMetrics);
            this.mTmpRect2.setEmpty();
            for (int stackNdx = this.mTaskStackContainers.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(stackNdx);
                stack.setTouchExcludeRegion(focusedTask, delta, this.mTouchExcludeRegion, this.mDisplayFrames.mContent, this.mTmpRect2);
            }
            if (!this.mTmpRect2.isEmpty()) {
                this.mTouchExcludeRegion.op(this.mTmpRect2, Region.Op.UNION);
            }
        }
        if (this.mInputMethodWindow != null && this.mInputMethodWindow.isVisibleLw()) {
            this.mInputMethodWindow.getTouchableRegion(this.mTmpRegion);
            this.mTouchExcludeRegion.op(this.mTmpRegion, Region.Op.UNION);
        }
        for (int i = this.mTapExcludedWindows.size() - 1; i >= 0; --i) {
            WindowState win = this.mTapExcludedWindows.get(i);
            win.getTouchableRegion(this.mTmpRegion);
            this.mTouchExcludeRegion.op(this.mTmpRegion, Region.Op.UNION);
        }
        this.amendWindowTapExcludeRegion(this.mTouchExcludeRegion);
        if (this.mDisplayId == 0 && this.getSplitScreenPrimaryStack() != null) {
            this.mDividerControllerLocked.getTouchRegion(this.mTmpRect);
            this.mTmpRegion.set(this.mTmpRect);
            this.mTouchExcludeRegion.op(this.mTmpRegion, Region.Op.UNION);
        }
        this.mTapDetector.setTouchExcludeRegion(this.mTouchExcludeRegion);
    }

    void amendWindowTapExcludeRegion(Region inOutRegion) {
        for (int i = this.mTapExcludeProvidingWindows.size() - 1; i >= 0; --i) {
            WindowState win = this.mTapExcludeProvidingWindows.valueAt(i);
            win.amendTapExcludeRegion(inOutRegion);
        }
    }

    @Override
    void switchUser() {
        super.switchUser();
        this.mWmService.mWindowsChanged = true;
        this.mDisplayPolicy.switchUser();
    }

    private void resetAnimationBackgroundAnimator() {
        for (int stackNdx = this.mTaskStackContainers.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
            ((TaskStack)this.mTaskStackContainers.getChildAt(stackNdx)).resetAnimationBackgroundAnimator();
        }
    }

    @Override
    void removeIfPossible() {
        if (this.isAnimating()) {
            this.mDeferredRemoval = true;
            return;
        }
        this.removeImmediately();
    }

    @Override
    void removeImmediately() {
        this.mRemovingDisplay = true;
        try {
            this.mOpeningApps.clear();
            this.mClosingApps.clear();
            this.mChangingApps.clear();
            this.mUnknownAppVisibilityController.clear();
            this.mAppTransition.removeAppTransitionTimeoutCallbacks();
            this.handleAnimatingStoppedAndTransition();
            this.mWmService.stopFreezingDisplayLocked();
            super.removeImmediately();
            this.mPointerEventDispatcher.dispose();
            this.mWmService.mAnimator.removeDisplayLocked(this.mDisplayId);
            this.mWindowingLayer.release();
            this.mOverlayLayer.release();
            this.mInputMonitor.onDisplayRemoved();
        }
        finally {
            this.mDisplayReady = false;
            this.mRemovingDisplay = false;
        }
        this.mWmService.mWindowPlacerLocked.requestTraversal();
    }

    @Override
    boolean checkCompleteDeferredRemoval() {
        boolean stillDeferringRemoval = super.checkCompleteDeferredRemoval();
        if (!stillDeferringRemoval && this.mDeferredRemoval) {
            this.removeImmediately();
            return false;
        }
        return true;
    }

    boolean isRemovalDeferred() {
        return this.mDeferredRemoval;
    }

    boolean animateForIme(float interpolatedValue, float animationTarget, float dividerAnimationTarget) {
        boolean updated = false;
        for (int i = this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(i);
            if (stack == null || !stack.isAdjustedForIme()) continue;
            if (interpolatedValue >= 1.0f && animationTarget == 0.0f && dividerAnimationTarget == 0.0f) {
                stack.resetAdjustedForIme(true);
                updated = true;
            } else {
                this.mDividerControllerLocked.mLastAnimationProgress = this.mDividerControllerLocked.getInterpolatedAnimationValue(interpolatedValue);
                this.mDividerControllerLocked.mLastDividerProgress = this.mDividerControllerLocked.getInterpolatedDividerValue(interpolatedValue);
                updated |= stack.updateAdjustForIme(this.mDividerControllerLocked.mLastAnimationProgress, this.mDividerControllerLocked.mLastDividerProgress, false);
            }
            if (!(interpolatedValue >= 1.0f)) continue;
            stack.endImeAdjustAnimation();
        }
        return updated;
    }

    boolean clearImeAdjustAnimation() {
        boolean changed = false;
        for (int i = this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(i);
            if (stack == null || !stack.isAdjustedForIme()) continue;
            stack.resetAdjustedForIme(true);
            changed = true;
        }
        return changed;
    }

    void beginImeAdjustAnimation() {
        for (int i = this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(i);
            if (!stack.isVisible() || !stack.isAdjustedForIme()) continue;
            stack.beginImeAdjustAnimation();
        }
    }

    void adjustForImeIfNeeded() {
        boolean dockMinimized;
        WindowState imeWin = this.mInputMethodWindow;
        boolean imeVisible = imeWin != null && imeWin.isVisibleLw() && imeWin.isDisplayedLw() && !this.mDividerControllerLocked.isImeHideRequested();
        TaskStack dockedStack = this.getSplitScreenPrimaryStack();
        boolean dockVisible = dockedStack != null;
        Task topDockedTask = dockVisible ? (Task)dockedStack.getTopChild() : null;
        TaskStack imeTargetStack = this.mWmService.getImeFocusStackLocked();
        int imeDockSide = dockVisible && imeTargetStack != null ? imeTargetStack.getDockSide() : -1;
        boolean imeOnTop = imeDockSide == 2;
        boolean imeOnBottom = imeDockSide == 4;
        int imeHeight = this.mDisplayFrames.getInputMethodWindowVisibleHeight();
        boolean imeHeightChanged = imeVisible && imeHeight != this.mDividerControllerLocked.getImeHeightAdjustedFor();
        boolean bl = dockMinimized = this.mDividerControllerLocked.isMinimizedDock() || topDockedTask != null && imeOnBottom && !dockedStack.isAdjustedForIme() && dockedStack.getBounds().height() < topDockedTask.getBounds().height();
        if (imeVisible && dockVisible && (imeOnTop || imeOnBottom) && !dockMinimized) {
            for (int i = this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
                boolean isDockedOnBottom;
                TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(i);
                boolean bl2 = isDockedOnBottom = stack.getDockSide() == 4;
                if (stack.isVisible() && (imeOnBottom || isDockedOnBottom) && stack.inSplitScreenWindowingMode()) {
                    stack.setAdjustedForIme(imeWin, imeOnBottom && imeHeightChanged);
                    continue;
                }
                stack.resetAdjustedForIme(false);
            }
            this.mDividerControllerLocked.setAdjustedForIme(imeOnBottom, true, true, imeWin, imeHeight);
        } else {
            for (int i = this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
                TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(i);
                stack.resetAdjustedForIme(!dockVisible);
            }
            this.mDividerControllerLocked.setAdjustedForIme(false, false, dockVisible, imeWin, imeHeight);
        }
        this.mPinnedStackControllerLocked.setAdjustedForIme(imeVisible, imeHeight);
    }

    void prepareFreezingTaskBounds() {
        for (int stackNdx = this.mTaskStackContainers.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(stackNdx);
            stack.prepareFreezingTaskBounds();
        }
    }

    void rotateBounds(int oldRotation, int newRotation, Rect bounds) {
        this.getBounds(this.mTmpRect, newRotation);
        this.rotateBounds(this.mTmpRect, oldRotation, newRotation, bounds);
    }

    void rotateBounds(Rect parentBounds, int oldRotation, int newRotation, Rect bounds) {
        int deltaRotation = DisplayContent.deltaRotation(newRotation, oldRotation);
        DisplayContent.createRotationMatrix(deltaRotation, parentBounds.width(), parentBounds.height(), this.mTmpMatrix);
        this.mTmpRectF.set(bounds);
        this.mTmpMatrix.mapRect(this.mTmpRectF);
        this.mTmpRectF.round(bounds);
    }

    static int deltaRotation(int oldRotation, int newRotation) {
        int delta = newRotation - oldRotation;
        if (delta < 0) {
            delta += 4;
        }
        return delta;
    }

    private static void createRotationMatrix(int rotation, float displayWidth, float displayHeight, Matrix outMatrix) {
        DisplayContent.createRotationMatrix(rotation, 0.0f, 0.0f, displayWidth, displayHeight, outMatrix);
    }

    static void createRotationMatrix(int rotation, float rectLeft, float rectTop, float displayWidth, float displayHeight, Matrix outMatrix) {
        switch (rotation) {
            case 0: {
                outMatrix.reset();
                break;
            }
            case 3: {
                outMatrix.setRotate(270.0f, 0.0f, 0.0f);
                outMatrix.postTranslate(0.0f, displayHeight);
                outMatrix.postTranslate(rectTop, 0.0f);
                break;
            }
            case 2: {
                outMatrix.reset();
                break;
            }
            case 1: {
                outMatrix.setRotate(90.0f, 0.0f, 0.0f);
                outMatrix.postTranslate(displayWidth, 0.0f);
                outMatrix.postTranslate(-rectTop, rectLeft);
            }
        }
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, int logLevel) {
        int i;
        WindowToken windowToken;
        int i2;
        if (logLevel == 2 && !this.isVisible()) {
            return;
        }
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, logLevel);
        proto.write(1120986464258L, this.mDisplayId);
        for (int stackNdx = this.mTaskStackContainers.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(stackNdx);
            stack.writeToProto(proto, 2246267895811L, logLevel);
        }
        this.mDividerControllerLocked.writeToProto(proto, 1146756268036L);
        this.mPinnedStackControllerLocked.writeToProto(proto, 1146756268037L);
        for (i2 = this.mAboveAppWindowsContainers.getChildCount() - 1; i2 >= 0; --i2) {
            windowToken = (WindowToken)this.mAboveAppWindowsContainers.getChildAt(i2);
            windowToken.writeToProto(proto, 2246267895814L, logLevel);
        }
        for (i2 = this.mBelowAppWindowsContainers.getChildCount() - 1; i2 >= 0; --i2) {
            windowToken = (WindowToken)this.mBelowAppWindowsContainers.getChildAt(i2);
            windowToken.writeToProto(proto, 2246267895815L, logLevel);
        }
        for (i2 = this.mImeWindowsContainers.getChildCount() - 1; i2 >= 0; --i2) {
            windowToken = (WindowToken)this.mImeWindowsContainers.getChildAt(i2);
            windowToken.writeToProto(proto, 2246267895816L, logLevel);
        }
        proto.write(1120986464265L, this.mBaseDisplayDensity);
        this.mDisplayInfo.writeToProto(proto, 1146756268042L);
        proto.write(1120986464267L, this.mRotation);
        ScreenRotationAnimation screenRotationAnimation = this.mWmService.mAnimator.getScreenRotationAnimationLocked(this.mDisplayId);
        if (screenRotationAnimation != null) {
            screenRotationAnimation.writeToProto(proto, 1146756268044L);
        }
        this.mDisplayFrames.writeToProto(proto, 1146756268045L);
        this.mAppTransition.writeToProto(proto, 0x10B00000010L);
        if (this.mFocusedApp != null) {
            this.mFocusedApp.writeNameToProto(proto, 1138166333455L);
        }
        for (i = this.mOpeningApps.size() - 1; i >= 0; --i) {
            this.mOpeningApps.valueAt((int)i).mActivityRecord.writeIdentifierToProto(proto, 2246267895825L);
        }
        for (i = this.mClosingApps.size() - 1; i >= 0; --i) {
            this.mClosingApps.valueAt((int)i).mActivityRecord.writeIdentifierToProto(proto, 2246267895826L);
        }
        for (i = this.mChangingApps.size() - 1; i >= 0; --i) {
            this.mChangingApps.valueAt((int)i).mActivityRecord.writeIdentifierToProto(proto, 2246267895827L);
        }
        proto.end(token);
    }

    @Override
    public void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        TaskStack splitScreenPrimaryStack;
        TaskStack pinnedStack;
        int i;
        super.dump(pw, prefix, dumpAll);
        pw.print(prefix);
        pw.print("Display: mDisplayId=");
        pw.println(this.mDisplayId);
        String subPrefix = "  " + prefix;
        pw.print(subPrefix);
        pw.print("init=");
        pw.print(this.mInitialDisplayWidth);
        pw.print("x");
        pw.print(this.mInitialDisplayHeight);
        pw.print(" ");
        pw.print(this.mInitialDisplayDensity);
        pw.print("dpi");
        if (this.mInitialDisplayWidth != this.mBaseDisplayWidth || this.mInitialDisplayHeight != this.mBaseDisplayHeight || this.mInitialDisplayDensity != this.mBaseDisplayDensity) {
            pw.print(" base=");
            pw.print(this.mBaseDisplayWidth);
            pw.print("x");
            pw.print(this.mBaseDisplayHeight);
            pw.print(" ");
            pw.print(this.mBaseDisplayDensity);
            pw.print("dpi");
        }
        if (this.mDisplayScalingDisabled) {
            pw.println(" noscale");
        }
        pw.print(" cur=");
        pw.print(this.mDisplayInfo.logicalWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.logicalHeight);
        pw.print(" app=");
        pw.print(this.mDisplayInfo.appWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.appHeight);
        pw.print(" rng=");
        pw.print(this.mDisplayInfo.smallestNominalAppWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.smallestNominalAppHeight);
        pw.print("-");
        pw.print(this.mDisplayInfo.largestNominalAppWidth);
        pw.print("x");
        pw.println(this.mDisplayInfo.largestNominalAppHeight);
        pw.print(subPrefix + "deferred=" + this.mDeferredRemoval + " mLayoutNeeded=" + this.mLayoutNeeded);
        pw.println(" mTouchExcludeRegion=" + this.mTouchExcludeRegion);
        pw.println();
        pw.print(prefix);
        pw.print("mLayoutSeq=");
        pw.println(this.mLayoutSeq);
        pw.print(prefix);
        pw.print("mDeferredRotationPauseCount=");
        pw.println(this.mDeferredRotationPauseCount);
        pw.print("  mCurrentFocus=");
        pw.println(this.mCurrentFocus);
        if (this.mLastFocus != this.mCurrentFocus) {
            pw.print("  mLastFocus=");
            pw.println(this.mLastFocus);
        }
        if (this.mLosingFocus.size() > 0) {
            pw.println();
            pw.println("  Windows losing focus:");
            for (i = this.mLosingFocus.size() - 1; i >= 0; --i) {
                WindowState w = this.mLosingFocus.get(i);
                pw.print("  Losing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        pw.print("  mFocusedApp=");
        pw.println(this.mFocusedApp);
        if (this.mLastStatusBarVisibility != 0) {
            pw.print("  mLastStatusBarVisibility=0x");
            pw.println(Integer.toHexString(this.mLastStatusBarVisibility));
        }
        pw.println();
        this.mWallpaperController.dump(pw, "  ");
        pw.println();
        pw.print("mSystemGestureExclusion=");
        if (this.mSystemGestureExclusionListeners.getRegisteredCallbackCount() > 0) {
            pw.println(this.mSystemGestureExclusion);
        } else {
            pw.println("<no lstnrs>");
        }
        pw.println();
        pw.println(prefix + "Application tokens in top down Z order:");
        for (int stackNdx = this.mTaskStackContainers.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(stackNdx);
            stack.dump(pw, prefix + "  ", dumpAll);
        }
        pw.println();
        if (!this.mExitingTokens.isEmpty()) {
            pw.println();
            pw.println("  Exiting tokens:");
            for (i = this.mExitingTokens.size() - 1; i >= 0; --i) {
                WindowToken token = this.mExitingTokens.get(i);
                pw.print("  Exiting #");
                pw.print(i);
                pw.print(' ');
                pw.print(token);
                pw.println(':');
                token.dump(pw, "    ", dumpAll);
            }
        }
        pw.println();
        TaskStack homeStack = this.getHomeStack();
        if (homeStack != null) {
            pw.println(prefix + "homeStack=" + homeStack.getName());
        }
        if ((pinnedStack = this.getPinnedStack()) != null) {
            pw.println(prefix + "pinnedStack=" + pinnedStack.getName());
        }
        if ((splitScreenPrimaryStack = this.getSplitScreenPrimaryStack()) != null) {
            pw.println(prefix + "splitScreenPrimaryStack=" + splitScreenPrimaryStack.getName());
        }
        pw.println();
        this.mDividerControllerLocked.dump(prefix, pw);
        pw.println();
        this.mPinnedStackControllerLocked.dump(prefix, pw);
        pw.println();
        this.mDisplayFrames.dump(prefix, pw);
        pw.println();
        this.mDisplayPolicy.dump(prefix, pw);
        pw.println();
        this.mDisplayRotation.dump(prefix, pw);
        pw.println();
        this.mInputMonitor.dump(pw, "  ");
        pw.println();
        this.mInsetsStateController.dump(prefix, pw);
    }

    public String toString() {
        return "Display " + this.mDisplayId + " info=" + this.mDisplayInfo + " stacks=" + this.mChildren;
    }

    @Override
    String getName() {
        return "Display " + this.mDisplayId + " name=\"" + this.mDisplayInfo.name + "\"";
    }

    boolean isStackVisible(int windowingMode) {
        TaskStack stack = this.getTopStackInWindowingMode(windowingMode);
        return stack != null && stack.isVisible();
    }

    WindowState getTouchableWinAtPointLocked(float xf, float yf) {
        int x = (int)xf;
        int y = (int)yf;
        WindowState touchedWin = this.getWindow(w -> {
            int flags = w.mAttrs.flags;
            if (!w.isVisibleLw()) {
                return false;
            }
            if ((flags & 0x10) != 0) {
                return false;
            }
            w.getVisibleBounds(this.mTmpRect);
            if (!this.mTmpRect.contains(x, y)) {
                return false;
            }
            w.getTouchableRegion(this.mTmpRegion);
            int touchFlags = flags & 0x28;
            return this.mTmpRegion.contains(x, y) || touchFlags == 0;
        });
        return touchedWin;
    }

    boolean canAddToastWindowForUid(int uid) {
        WindowState focusedWindowForUid = this.getWindow(w -> w.mOwnerUid == uid && w.isFocused());
        if (focusedWindowForUid != null) {
            return true;
        }
        WindowState win = this.getWindow(w -> w.mAttrs.type == 2005 && w.mOwnerUid == uid && !w.mPermanentlyHidden && !w.mWindowRemovalAllowed);
        return win == null;
    }

    void scheduleToastWindowsTimeoutIfNeededLocked(WindowState oldFocus, WindowState newFocus) {
        if (oldFocus == null || newFocus != null && newFocus.mOwnerUid == oldFocus.mOwnerUid) {
            return;
        }
        this.mTmpWindow = oldFocus;
        this.forAllWindows(this.mScheduleToastTimeout, false);
    }

    WindowState findFocusedWindowIfNeeded(int topFocusedDisplayId) {
        return this.mWmService.mPerDisplayFocusEnabled || topFocusedDisplayId == -1 ? this.findFocusedWindow() : null;
    }

    WindowState findFocusedWindow() {
        this.mTmpWindow = null;
        this.forAllWindows(this.mFindFocusedWindow, true);
        if (this.mTmpWindow == null) {
            return null;
        }
        return this.mTmpWindow;
    }

    boolean updateFocusedWindowLocked(int mode, boolean updateInputWindows, int topFocusedDisplayId) {
        WindowState newFocus = this.findFocusedWindowIfNeeded(topFocusedDisplayId);
        if (this.mCurrentFocus == newFocus) {
            return false;
        }
        boolean imWindowChanged = false;
        WindowState imWindow = this.mInputMethodWindow;
        if (imWindow != null) {
            WindowState prevTarget = this.mInputMethodTarget;
            WindowState newTarget = this.computeImeTarget(true);
            boolean bl = imWindowChanged = prevTarget != newTarget;
            if (mode != 1 && mode != 3) {
                this.assignWindowLayers(false);
            }
        }
        if (imWindowChanged) {
            this.mWmService.mWindowsChanged = true;
            this.setLayoutNeeded();
            newFocus = this.findFocusedWindowIfNeeded(topFocusedDisplayId);
        }
        if (this.mCurrentFocus != newFocus) {
            this.mWmService.mH.obtainMessage(2, this).sendToTarget();
        }
        WindowState oldFocus = this.mCurrentFocus;
        this.mCurrentFocus = newFocus;
        this.mLosingFocus.remove(newFocus);
        if (newFocus != null) {
            this.mWinAddedSinceNullFocus.clear();
            this.mWinRemovedSinceNullFocus.clear();
            if (newFocus.canReceiveKeys()) {
                newFocus.mToken.paused = false;
            }
        }
        int focusChanged = this.getDisplayPolicy().focusChangedLw(oldFocus, newFocus);
        if (imWindowChanged && oldFocus != this.mInputMethodWindow) {
            if (mode == 2) {
                this.performLayout(true, updateInputWindows);
                focusChanged &= 0xFFFFFFFE;
            } else if (mode == 3) {
                this.assignWindowLayers(false);
            }
        }
        if ((focusChanged & 1) != 0) {
            this.setLayoutNeeded();
            if (mode == 2) {
                this.performLayout(true, updateInputWindows);
            } else if (mode == 4) {
                this.mWmService.mRoot.performSurfacePlacement(false);
            }
        }
        if (mode != 1) {
            this.getInputMonitor().setInputFocusLw(newFocus, updateInputWindows);
        }
        this.adjustForImeIfNeeded();
        this.scheduleToastWindowsTimeoutIfNeededLocked(oldFocus, newFocus);
        if (mode == 2) {
            this.pendingLayoutChanges |= 8;
        }
        return true;
    }

    boolean setFocusedApp(AppWindowToken newFocus) {
        DisplayContent appDisplay;
        if (newFocus != null && (appDisplay = newFocus.getDisplayContent()) != this) {
            throw new IllegalStateException(newFocus + " is not on " + this.getName() + " but " + (appDisplay != null ? appDisplay.getName() : "none"));
        }
        if (this.mFocusedApp == newFocus) {
            return false;
        }
        this.mFocusedApp = newFocus;
        this.getInputMonitor().setFocusedAppLw(newFocus);
        this.updateTouchExcludeRegion();
        return true;
    }

    void assignWindowLayers(boolean setLayoutNeeded) {
        Trace.traceBegin(32L, "assignWindowLayers");
        this.assignChildLayers(this.getPendingTransaction());
        if (setLayoutNeeded) {
            this.setLayoutNeeded();
        }
        this.scheduleAnimation();
        Trace.traceEnd(32L);
    }

    void layoutAndAssignWindowLayersIfNeeded() {
        this.mWmService.mWindowsChanged = true;
        this.setLayoutNeeded();
        if (!this.mWmService.updateFocusedWindowLocked(3, false)) {
            this.assignWindowLayers(false);
        }
        this.mInputMonitor.setUpdateInputWindowsNeededLw();
        this.mWmService.mWindowPlacerLocked.performSurfacePlacement();
        this.mInputMonitor.updateInputWindowsLw(false);
    }

    boolean destroyLeakedSurfaces() {
        this.mTmpWindow = null;
        this.forAllWindows((WindowState w) -> {
            WindowStateAnimator wsa = w.mWinAnimator;
            if (wsa.mSurfaceController == null) {
                return;
            }
            if (!this.mWmService.mSessions.contains(wsa.mSession)) {
                Slog.w(TAG, "LEAKED SURFACE (session doesn't exist): " + w + " surface=" + wsa.mSurfaceController + " token=" + w.mToken + " pid=" + w.mSession.mPid + " uid=" + w.mSession.mUid);
                wsa.destroySurface();
                this.mWmService.mForceRemoves.add((WindowState)w);
                this.mTmpWindow = w;
            } else if (w.mAppToken != null && w.mAppToken.isClientHidden()) {
                Slog.w(TAG, "LEAKED SURFACE (app token hidden): " + w + " surface=" + wsa.mSurfaceController + " token=" + w.mAppToken);
                wsa.destroySurface();
                this.mTmpWindow = w;
            }
        }, false);
        return this.mTmpWindow != null;
    }

    void setInputMethodWindowLocked(WindowState win) {
        this.mInputMethodWindow = win;
        if (this.mInputMethodWindow != null) {
            int imePid = this.mInputMethodWindow.mSession.mPid;
            this.mWmService.mAtmInternal.onImeWindowSetOnDisplay(imePid, this.mInputMethodWindow.getDisplayId());
        }
        this.computeImeTarget(true);
        this.mInsetsStateController.getSourceProvider(10).setWindow(win, null);
    }

    WindowState computeImeTarget(boolean updateImeTarget) {
        WindowState betterTarget;
        AppWindowToken token;
        if (this.mInputMethodWindow == null) {
            if (updateImeTarget) {
                this.setInputMethodTarget(null, this.mInputMethodTargetWaitingAnim);
            }
            return null;
        }
        WindowState curTarget = this.mInputMethodTarget;
        if (!this.canUpdateImeTarget()) {
            return curTarget;
        }
        this.mUpdateImeTarget = updateImeTarget;
        WindowState target = this.getWindow(this.mComputeImeTargetPredicate);
        if (target != null && target.mAttrs.type == 3 && (token = target.mAppToken) != null && (betterTarget = token.getImeTargetBelowWindow(target)) != null) {
            target = betterTarget;
        }
        if (curTarget != null && !curTarget.mRemoved && curTarget.isDisplayedLw() && curTarget.isClosing()) {
            return curTarget;
        }
        if (target == null) {
            if (updateImeTarget) {
                this.setInputMethodTarget(null, this.mInputMethodTargetWaitingAnim);
            }
            return null;
        }
        if (updateImeTarget) {
            AppWindowToken appWindowToken = token = curTarget == null ? null : curTarget.mAppToken;
            if (token != null) {
                WindowState highestTarget = null;
                if (token.isSelfAnimating()) {
                    highestTarget = token.getHighestAnimLayerWindow(curTarget);
                }
                if (highestTarget != null && this.mAppTransition.isTransitionSet()) {
                    this.setInputMethodTarget(highestTarget, true);
                    return highestTarget;
                }
            }
            this.setInputMethodTarget(target, false);
        }
        return target;
    }

    void computeImeTargetIfNeeded(AppWindowToken candidate) {
        if (this.mInputMethodTarget != null && this.mInputMethodTarget.mAppToken == candidate) {
            this.computeImeTarget(true);
        }
    }

    private void setInputMethodTarget(WindowState target, boolean targetWaitingAnim) {
        if (target == this.mInputMethodTarget && this.mInputMethodTargetWaitingAnim == targetWaitingAnim) {
            return;
        }
        this.mInputMethodTarget = target;
        this.mInputMethodTargetWaitingAnim = targetWaitingAnim;
        this.assignWindowLayers(false);
        this.mInsetsStateController.onImeTargetChanged(target);
        this.updateImeParent();
    }

    private void updateImeParent() {
        SurfaceControl newParent;
        boolean shouldAttachToDisplay = this.mMagnificationSpec != null;
        SurfaceControl surfaceControl = newParent = shouldAttachToDisplay ? this.mWindowingLayer : this.computeImeParent();
        if (newParent != null) {
            this.getPendingTransaction().reparent(this.mImeWindowsContainers.mSurfaceControl, newParent);
            this.scheduleAnimation();
        }
    }

    @VisibleForTesting
    SurfaceControl computeImeParent() {
        if (this.mInputMethodTarget != null && this.mInputMethodTarget.mAppToken != null && this.mInputMethodTarget.getWindowingMode() == 1 && this.mInputMethodTarget.mAppToken.matchParentBounds()) {
            return this.mInputMethodTarget.mAppToken.getSurfaceControl();
        }
        return this.mWindowingLayer;
    }

    boolean getNeedsMenu(WindowState top, WindowManagerPolicy.WindowState bottom) {
        if (top.mAttrs.needsMenuKey != 0) {
            return top.mAttrs.needsMenuKey == 1;
        }
        this.mTmpWindow = null;
        WindowState candidate = this.getWindow(w -> {
            if (w == top) {
                this.mTmpWindow = w;
            }
            if (this.mTmpWindow == null) {
                return false;
            }
            if (w.mAttrs.needsMenuKey != 0) {
                return true;
            }
            return w == bottom;
        });
        return candidate != null && candidate.mAttrs.needsMenuKey == 1;
    }

    void setLayoutNeeded() {
        this.mLayoutNeeded = true;
    }

    private void clearLayoutNeeded() {
        this.mLayoutNeeded = false;
    }

    boolean isLayoutNeeded() {
        return this.mLayoutNeeded;
    }

    void dumpTokens(PrintWriter pw, boolean dumpAll) {
        if (this.mTokenMap.isEmpty()) {
            return;
        }
        pw.println("  Display #" + this.mDisplayId);
        for (WindowToken token : this.mTokenMap.values()) {
            pw.print("  ");
            pw.print(token);
            if (dumpAll) {
                pw.println(':');
                token.dump(pw, "    ", dumpAll);
                continue;
            }
            pw.println();
        }
        if (!(this.mOpeningApps.isEmpty() && this.mClosingApps.isEmpty() && this.mChangingApps.isEmpty())) {
            pw.println();
            if (this.mOpeningApps.size() > 0) {
                pw.print("  mOpeningApps=");
                pw.println(this.mOpeningApps);
            }
            if (this.mClosingApps.size() > 0) {
                pw.print("  mClosingApps=");
                pw.println(this.mClosingApps);
            }
            if (this.mChangingApps.size() > 0) {
                pw.print("  mChangingApps=");
                pw.println(this.mChangingApps);
            }
        }
        this.mUnknownAppVisibilityController.dump(pw, "  ");
    }

    void dumpWindowAnimators(PrintWriter pw, String subPrefix) {
        int[] index = new int[1];
        this.forAllWindows((WindowState w) -> {
            WindowStateAnimator wAnim = w.mWinAnimator;
            pw.println(subPrefix + "Window #" + index[0] + ": " + wAnim);
            index[0] = index[0] + 1;
        }, false);
    }

    void startKeyguardExitOnNonAppWindows(boolean onWallpaper, boolean goingToShade) {
        WindowManagerPolicy policy = this.mWmService.mPolicy;
        this.forAllWindows((WindowState w) -> {
            if (w.mAppToken == null && policy.canBeHiddenByKeyguardLw((WindowManagerPolicy.WindowState)w) && w.wouldBeVisibleIfPolicyIgnored() && !w.isVisible()) {
                w.startAnimation(policy.createHiddenByKeyguardExit(onWallpaper, goingToShade));
            }
        }, true);
    }

    boolean checkWaitingForWindows() {
        boolean wallpaperEnabled;
        this.mHaveBootMsg = false;
        this.mHaveApp = false;
        this.mHaveWallpaper = false;
        this.mHaveKeyguard = true;
        WindowState visibleWindow = this.getWindow(w -> {
            if (w.isVisibleLw() && !w.mObscured && !w.isDrawnLw()) {
                return true;
            }
            if (w.isDrawnLw()) {
                if (w.mAttrs.type == 2021) {
                    this.mHaveBootMsg = true;
                } else if (w.mAttrs.type == 2 || w.mAttrs.type == 4) {
                    this.mHaveApp = true;
                } else if (w.mAttrs.type == 2013) {
                    this.mHaveWallpaper = true;
                } else if (w.mAttrs.type == 2000) {
                    this.mHaveKeyguard = this.mWmService.mPolicy.isKeyguardDrawnLw();
                }
            }
            return false;
        });
        if (visibleWindow != null) {
            return true;
        }
        boolean bl = wallpaperEnabled = this.mWmService.mContext.getResources().getBoolean(17891450) && this.mWmService.mContext.getResources().getBoolean(0x1110041) && !this.mWmService.mOnlyCore;
        if (!this.mWmService.mSystemBooted && !this.mHaveBootMsg) {
            return true;
        }
        return this.mWmService.mSystemBooted && (!this.mHaveApp && !this.mHaveKeyguard || wallpaperEnabled && !this.mHaveWallpaper);
    }

    void updateWindowsForAnimator() {
        this.forAllWindows(this.mUpdateWindowsForAnimator, true);
    }

    void updateBackgroundForAnimator() {
        this.resetAnimationBackgroundAnimator();
        this.forAllWindows(this.mUpdateWallpaperForAnimator, true);
    }

    boolean isInputMethodClientFocus(int uid, int pid) {
        WindowState imFocus = this.computeImeTarget(false);
        if (imFocus == null) {
            return false;
        }
        return imFocus.mSession.mUid == uid && imFocus.mSession.mPid == pid;
    }

    boolean hasSecureWindowOnScreen() {
        WindowState win = this.getWindow(w -> w.isOnScreen() && (w.mAttrs.flags & 0x2000) != 0);
        return win != null;
    }

    void statusBarVisibilityChanged(int visibility) {
        this.mLastStatusBarVisibility = visibility;
        visibility = this.getDisplayPolicy().adjustSystemUiVisibilityLw(visibility);
        this.updateStatusBarVisibilityLocked(visibility);
    }

    private boolean updateStatusBarVisibilityLocked(int visibility) {
        if (this.mLastDispatchedSystemUiVisibility == visibility) {
            return false;
        }
        int globalDiff = (visibility ^ this.mLastDispatchedSystemUiVisibility) & 7 & ~visibility;
        this.mLastDispatchedSystemUiVisibility = visibility;
        if (this.isDefaultDisplay) {
            this.mWmService.mInputManager.setSystemUiVisibility(visibility);
        }
        this.updateSystemUiVisibility(visibility, globalDiff);
        return true;
    }

    void updateSystemUiVisibility(int visibility, int globalDiff) {
        this.forAllWindows((WindowState w) -> {
            try {
                int curValue = w.mSystemUiVisibility;
                int diff = (curValue ^ visibility) & globalDiff;
                int newValue = curValue & ~diff | visibility & diff;
                if (newValue != curValue) {
                    ++w.mSeq;
                    w.mSystemUiVisibility = newValue;
                }
                if (newValue != curValue || w.mAttrs.hasSystemUiListeners) {
                    w.mClient.dispatchSystemUiVisibilityChanged(w.mSeq, visibility, newValue, diff);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }, true);
    }

    void reevaluateStatusBarVisibility() {
        int visibility = this.getDisplayPolicy().adjustSystemUiVisibilityLw(this.mLastStatusBarVisibility);
        if (this.updateStatusBarVisibilityLocked(visibility)) {
            this.mWmService.mWindowPlacerLocked.requestTraversal();
        }
    }

    void onWindowFreezeTimeout() {
        Slog.w(TAG, "Window freeze timeout expired.");
        this.mWmService.mWindowsFreezingScreen = 2;
        this.forAllWindows((WindowState w) -> {
            if (!w.getOrientationChanging()) {
                return;
            }
            w.orientationChangeTimedOut();
            w.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mWmService.mDisplayFreezeTime);
            Slog.w(TAG, "Force clearing orientation change: " + w);
        }, true);
        this.mWmService.mWindowPlacerLocked.performSurfacePlacement();
    }

    void waitForAllWindowsDrawn() {
        WindowManagerPolicy policy = this.mWmService.mPolicy;
        this.forAllWindows((WindowState w) -> {
            boolean keyguard = policy.isKeyguardHostWindow(w.mAttrs);
            if (w.isVisibleLw() && (w.mAppToken != null || keyguard)) {
                w.mWinAnimator.mDrawState = 1;
                w.resetLastContentInsets();
                this.mWmService.mWaitingForDrawn.add((WindowState)w);
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applySurfaceChangesTransaction(boolean recoveringMemory) {
        WindowSurfacePlacer surfacePlacer = this.mWmService.mWindowPlacerLocked;
        this.mTmpUpdateAllDrawn.clear();
        int repeats = 0;
        do {
            if (++repeats > 6) {
                Slog.w(TAG, "Animation repeat aborted after too many iterations");
                this.clearLayoutNeeded();
                break;
            }
            if ((this.pendingLayoutChanges & 4) != 0) {
                this.mWallpaperController.adjustWallpaperWindows();
            }
            if ((this.pendingLayoutChanges & 2) != 0 && this.updateOrientationFromAppTokens()) {
                this.setLayoutNeeded();
                this.sendNewConfiguration();
            }
            if ((this.pendingLayoutChanges & 1) != 0) {
                this.setLayoutNeeded();
            }
            if (repeats < 4) {
                this.performLayout(repeats == 1, false);
            } else {
                Slog.w(TAG, "Layout repeat skipped after too many iterations");
            }
            this.pendingLayoutChanges = 0;
            Trace.traceBegin(32L, "applyPostLayoutPolicy");
            try {
                this.mDisplayPolicy.beginPostLayoutPolicyLw();
                this.forAllWindows(this.mApplyPostLayoutPolicy, true);
                this.pendingLayoutChanges |= this.mDisplayPolicy.finishPostLayoutPolicyLw();
            }
            finally {
                Trace.traceEnd(32L);
            }
            this.mInsetsStateController.onPostLayout();
        } while (this.pendingLayoutChanges != 0);
        this.mTmpApplySurfaceChangesTransactionState.reset();
        this.mTmpRecoveringMemory = recoveringMemory;
        Trace.traceBegin(32L, "applyWindowSurfaceChanges");
        try {
            this.forAllWindows(this.mApplySurfaceChangesTransaction, true);
        }
        finally {
            Trace.traceEnd(32L);
        }
        this.prepareSurfaces();
        this.mLastHasContent = this.mTmpApplySurfaceChangesTransactionState.displayHasContent;
        this.mWmService.mDisplayManagerInternal.setDisplayProperties(this.mDisplayId, this.mLastHasContent, this.mTmpApplySurfaceChangesTransactionState.preferredRefreshRate, this.mTmpApplySurfaceChangesTransactionState.preferredModeId, true);
        boolean wallpaperVisible = this.mWallpaperController.isWallpaperVisible();
        if (wallpaperVisible != this.mLastWallpaperVisible) {
            this.mLastWallpaperVisible = wallpaperVisible;
            this.mWmService.mWallpaperVisibilityListeners.notifyWallpaperVisibilityChanged(this);
        }
        while (!this.mTmpUpdateAllDrawn.isEmpty()) {
            AppWindowToken atoken = this.mTmpUpdateAllDrawn.removeLast();
            atoken.updateAllDrawn();
        }
    }

    private void updateBounds() {
        this.calculateBounds(this.mDisplayInfo, this.mTmpBounds);
        this.setBounds(this.mTmpBounds);
        if (this.mPortalWindowHandle != null && this.mParentSurfaceControl != null) {
            this.mPortalWindowHandle.touchableRegion.getBounds(this.mTmpRect);
            if (!this.mTmpBounds.equals(this.mTmpRect)) {
                this.mPortalWindowHandle.touchableRegion.set(this.mTmpBounds);
                this.getPendingTransaction().setInputWindowInfo(this.mParentSurfaceControl, this.mPortalWindowHandle);
            }
        }
    }

    private void calculateBounds(DisplayInfo displayInfo, Rect out) {
        int rotation = displayInfo.rotation;
        boolean rotated = rotation == 1 || rotation == 3;
        int physWidth = rotated ? this.mBaseDisplayHeight : this.mBaseDisplayWidth;
        int physHeight = rotated ? this.mBaseDisplayWidth : this.mBaseDisplayHeight;
        int width = displayInfo.logicalWidth;
        int left = (physWidth - width) / 2;
        int height = displayInfo.logicalHeight;
        int top = (physHeight - height) / 2;
        out.set(left, top, left + width, top + height);
    }

    private void getBounds(Rect out, int orientation) {
        this.getBounds(out);
        int currentRotation = this.mDisplayInfo.rotation;
        int rotationDelta = DisplayContent.deltaRotation(currentRotation, orientation);
        if (rotationDelta == 1 || rotationDelta == 3) {
            DisplayContent.createRotationMatrix(rotationDelta, this.mBaseDisplayWidth, this.mBaseDisplayHeight, this.mTmpMatrix);
            this.mTmpRectF.set(out);
            this.mTmpMatrix.mapRect(this.mTmpRectF);
            this.mTmpRectF.round(out);
        }
    }

    int getNaturalOrientation() {
        return this.mBaseDisplayWidth < this.mBaseDisplayHeight ? 1 : 2;
    }

    void performLayout(boolean initial, boolean updateInputWindows) {
        Trace.traceBegin(32L, "performLayout");
        try {
            this.performLayoutNoTrace(initial, updateInputWindows);
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    private void performLayoutNoTrace(boolean initial, boolean updateInputWindows) {
        if (!this.isLayoutNeeded()) {
            return;
        }
        this.clearLayoutNeeded();
        int dw = this.mDisplayInfo.logicalWidth;
        int dh = this.mDisplayInfo.logicalHeight;
        this.mDisplayFrames.onDisplayInfoUpdated(this.mDisplayInfo, this.calculateDisplayCutoutForRotation(this.mDisplayInfo.rotation));
        this.mDisplayFrames.mRotation = this.mRotation;
        this.mDisplayPolicy.beginLayoutLw(this.mDisplayFrames, this.getConfiguration().uiMode);
        int seq = this.mLayoutSeq + 1;
        if (seq < 0) {
            seq = 0;
        }
        this.mLayoutSeq = seq;
        this.mTmpWindow = null;
        this.mTmpInitial = initial;
        this.forAllWindows(this.mPerformLayout, true);
        this.mTmpWindow2 = this.mTmpWindow;
        this.mTmpWindow = null;
        this.forAllWindows(this.mPerformLayoutAttached, true);
        this.mInputMonitor.layoutInputConsumers(dw, dh);
        this.mInputMonitor.setUpdateInputWindowsNeededLw();
        if (updateInputWindows) {
            this.mInputMonitor.updateInputWindowsLw(false);
        }
        this.mWmService.mH.sendEmptyMessage(41);
    }

    Bitmap screenshotDisplayLocked(Bitmap.Config config) {
        if (!this.mWmService.mPolicy.isScreenOn()) {
            return null;
        }
        int dw = this.mDisplayInfo.logicalWidth;
        int dh = this.mDisplayInfo.logicalHeight;
        if (dw <= 0 || dh <= 0) {
            return null;
        }
        Rect frame = new Rect(0, 0, dw, dh);
        int rot = this.mDisplay.getRotation();
        if (rot == 1 || rot == 3) {
            rot = rot == 1 ? 3 : 1;
        }
        DisplayContent.convertCropForSurfaceFlinger(frame, rot, dw, dh);
        ScreenRotationAnimation screenRotationAnimation = this.mWmService.mAnimator.getScreenRotationAnimationLocked(0);
        boolean inRotation = screenRotationAnimation != null && screenRotationAnimation.isAnimating();
        Bitmap bitmap = SurfaceControl.screenshot(frame, dw, dh, inRotation, rot);
        if (bitmap == null) {
            Slog.w(TAG, "Failed to take screenshot");
            return null;
        }
        Bitmap ret = bitmap.createAshmemBitmap(config);
        bitmap.recycle();
        return ret;
    }

    private static void convertCropForSurfaceFlinger(Rect crop, int rot, int dw, int dh) {
        if (rot == 1) {
            int tmp = crop.top;
            crop.top = dw - crop.right;
            crop.right = crop.bottom;
            crop.bottom = dw - crop.left;
            crop.left = tmp;
        } else if (rot == 2) {
            int tmp = crop.top;
            crop.top = dh - crop.bottom;
            crop.bottom = dh - tmp;
            tmp = crop.right;
            crop.right = dw - crop.left;
            crop.left = dw - tmp;
        } else if (rot == 3) {
            int tmp = crop.top;
            crop.top = crop.left;
            crop.left = dh - crop.bottom;
            crop.bottom = crop.right;
            crop.right = dh - tmp;
        }
    }

    void onSeamlessRotationTimeout() {
        this.mTmpWindow = null;
        this.forAllWindows((WindowState w) -> {
            if (!w.mSeamlesslyRotated) {
                return;
            }
            this.mTmpWindow = w;
            w.setDisplayLayoutNeeded();
            w.finishSeamlessRotation(true);
            this.mWmService.markForSeamlessRotation((WindowState)w, false);
        }, true);
        if (this.mTmpWindow != null) {
            this.mWmService.mWindowPlacerLocked.performSurfacePlacement();
        }
    }

    void setExitingTokensHasVisible(boolean hasVisible) {
        for (int i = this.mExitingTokens.size() - 1; i >= 0; --i) {
            this.mExitingTokens.get((int)i).hasVisible = hasVisible;
        }
        this.mTaskStackContainers.setExitingTokensHasVisible(hasVisible);
    }

    void removeExistingTokensIfPossible() {
        for (int i = this.mExitingTokens.size() - 1; i >= 0; --i) {
            WindowToken token = this.mExitingTokens.get(i);
            if (token.hasVisible) continue;
            this.mExitingTokens.remove(i);
        }
        this.mTaskStackContainers.removeExistingAppTokensIfPossible();
    }

    @Override
    void onDescendantOverrideConfigurationChanged() {
        this.setLayoutNeeded();
        this.mWmService.requestTraversal();
    }

    boolean okToDisplay() {
        if (this.mDisplayId == 0) {
            return !this.mWmService.mDisplayFrozen && this.mWmService.mDisplayEnabled && this.mWmService.mPolicy.isScreenOn();
        }
        return this.mDisplayInfo.state == 2;
    }

    boolean okToAnimate() {
        return this.okToDisplay() && (this.mDisplayId != 0 || this.mWmService.mPolicy.okToAnimate());
    }

    SurfaceControl.Builder makeSurface(SurfaceSession s) {
        return this.mWmService.makeSurfaceBuilder(s).setParent(this.mWindowingLayer);
    }

    @Override
    SurfaceSession getSession() {
        return this.mSession;
    }

    @Override
    SurfaceControl.Builder makeChildSurface(WindowContainer child) {
        SurfaceSession s = child != null ? child.getSession() : this.getSession();
        SurfaceControl.Builder b = this.mWmService.makeSurfaceBuilder(s).setContainerLayer();
        if (child == null) {
            return b;
        }
        return b.setName(child.getName()).setParent(this.mWindowingLayer);
    }

    SurfaceControl.Builder makeOverlay() {
        return this.mWmService.makeSurfaceBuilder(this.mSession).setParent(this.mOverlayLayer);
    }

    void reparentToOverlay(SurfaceControl.Transaction transaction, SurfaceControl surface) {
        transaction.reparent(surface, this.mOverlayLayer);
    }

    void applyMagnificationSpec(MagnificationSpec spec) {
        this.mMagnificationSpec = (double)spec.scale != 1.0 ? spec : null;
        this.updateImeParent();
        this.applyMagnificationSpec(this.getPendingTransaction(), spec);
        this.getPendingTransaction().apply();
    }

    void reapplyMagnificationSpec() {
        if (this.mMagnificationSpec != null) {
            this.applyMagnificationSpec(this.getPendingTransaction(), this.mMagnificationSpec);
        }
    }

    @Override
    void onParentChanged() {
    }

    @Override
    void assignChildLayers(SurfaceControl.Transaction t) {
        this.mBelowAppWindowsContainers.assignLayer(t, 0);
        this.mTaskStackContainers.assignLayer(t, 1);
        this.mAboveAppWindowsContainers.assignLayer(t, 2);
        WindowState imeTarget = this.mInputMethodTarget;
        boolean needAssignIme = true;
        if (imeTarget != null && !imeTarget.inSplitScreenWindowingMode() && !imeTarget.mToken.isAppAnimating() && imeTarget.getSurfaceControl() != null) {
            this.mImeWindowsContainers.assignRelativeLayer(t, imeTarget.getSurfaceControl(), 1);
            needAssignIme = false;
        }
        this.mBelowAppWindowsContainers.assignChildLayers(t);
        this.mTaskStackContainers.assignChildLayers(t);
        this.mAboveAppWindowsContainers.assignChildLayers(t, needAssignIme ? this.mImeWindowsContainers : null);
        this.mImeWindowsContainers.assignChildLayers(t);
    }

    void assignRelativeLayerForImeTargetChild(SurfaceControl.Transaction t, WindowContainer child) {
        child.assignRelativeLayer(t, this.mImeWindowsContainers.getSurfaceControl(), 1);
    }

    @Override
    void prepareSurfaces() {
        Trace.traceBegin(32L, "prepareSurfaces");
        try {
            ScreenRotationAnimation screenRotationAnimation = this.mWmService.mAnimator.getScreenRotationAnimationLocked(this.mDisplayId);
            SurfaceControl.Transaction transaction = this.getPendingTransaction();
            if (screenRotationAnimation != null && screenRotationAnimation.isAnimating()) {
                screenRotationAnimation.getEnterTransformation().getMatrix().getValues(this.mTmpFloats);
                transaction.setMatrix(this.mWindowingLayer, this.mTmpFloats[0], this.mTmpFloats[3], this.mTmpFloats[1], this.mTmpFloats[4]);
                transaction.setPosition(this.mWindowingLayer, this.mTmpFloats[2], this.mTmpFloats[5]);
                transaction.setAlpha(this.mWindowingLayer, screenRotationAnimation.getEnterTransformation().getAlpha());
            }
            super.prepareSurfaces();
            SurfaceControl.mergeToGlobalTransaction(transaction);
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    void assignStackOrdering() {
        this.mTaskStackContainers.assignStackOrdering(this.getPendingTransaction());
    }

    void deferUpdateImeTarget() {
        ++this.mDeferUpdateImeTargetCount;
    }

    void continueUpdateImeTarget() {
        if (this.mDeferUpdateImeTargetCount == 0) {
            return;
        }
        --this.mDeferUpdateImeTargetCount;
        if (this.mDeferUpdateImeTargetCount == 0) {
            this.computeImeTarget(true);
        }
    }

    private boolean canUpdateImeTarget() {
        return this.mDeferUpdateImeTargetCount == 0;
    }

    InputMonitor getInputMonitor() {
        return this.mInputMonitor;
    }

    boolean getLastHasContent() {
        return this.mLastHasContent;
    }

    void registerPointerEventListener(WindowManagerPolicyConstants.PointerEventListener listener) {
        this.mPointerEventDispatcher.registerInputEventListener(listener);
    }

    void unregisterPointerEventListener(WindowManagerPolicyConstants.PointerEventListener listener) {
        this.mPointerEventDispatcher.unregisterInputEventListener(listener);
    }

    void prepareAppTransition(int transit, boolean alwaysKeepCurrent) {
        this.prepareAppTransition(transit, alwaysKeepCurrent, 0, false);
    }

    void prepareAppTransition(int transit, boolean alwaysKeepCurrent, int flags, boolean forceOverride) {
        boolean prepared = this.mAppTransition.prepareAppTransitionLocked(transit, alwaysKeepCurrent, flags, forceOverride);
        if (prepared && this.okToAnimate()) {
            this.mSkipAppTransitionAnimation = false;
        }
    }

    void executeAppTransition() {
        if (this.mAppTransition.isTransitionSet()) {
            this.mAppTransition.setReady();
            this.mWmService.mWindowPlacerLocked.requestTraversal();
        }
    }

    void handleAnimatingStoppedAndTransition() {
        int changes = 0;
        this.mAppTransition.setIdle();
        for (int i = this.mNoAnimationNotifyOnTransitionFinished.size() - 1; i >= 0; --i) {
            IBinder token = this.mNoAnimationNotifyOnTransitionFinished.get(i);
            this.mAppTransition.notifyAppTransitionFinishedLocked(token);
        }
        this.mNoAnimationNotifyOnTransitionFinished.clear();
        this.mWallpaperController.hideDeferredWallpapersIfNeeded();
        this.onAppTransitionDone();
        this.computeImeTarget(true);
        this.mWallpaperMayChange = true;
        this.mWmService.mFocusMayChange = true;
        this.pendingLayoutChanges |= (changes |= 1);
    }

    boolean isNextTransitionForward() {
        int transit = this.mAppTransition.getAppTransition();
        return transit == 6 || transit == 8 || transit == 10;
    }

    boolean supportsSystemDecorations() {
        return (this.mWmService.mDisplayWindowSettings.shouldShowSystemDecorsLocked(this) || (this.mDisplay.getFlags() & 0x40) != 0 || this.mWmService.mForceDesktopModeOnExternalDisplays && !this.isUntrustedVirtualDisplay()) && this.mDisplayId != this.mWmService.mVr2dDisplayId;
    }

    boolean isUntrustedVirtualDisplay() {
        return this.mDisplay.getType() == 5 && this.mDisplay.getOwnerUid() != 1000;
    }

    void reparentDisplayContent(WindowState win, SurfaceControl sc) {
        this.mParentWindow = win;
        this.mParentSurfaceControl = sc;
        if (this.mPortalWindowHandle == null) {
            this.mPortalWindowHandle = this.createPortalWindowHandle(sc.toString());
        }
        this.getPendingTransaction().setInputWindowInfo(sc, this.mPortalWindowHandle).reparent(this.mWindowingLayer, sc).reparent(this.mOverlayLayer, sc);
    }

    WindowState getParentWindow() {
        return this.mParentWindow;
    }

    void updateLocation(WindowState win, int x, int y) {
        if (this.mParentWindow != win) {
            throw new IllegalArgumentException("The given window is not the parent window of this display.");
        }
        if (this.mLocationInParentWindow.x != x || this.mLocationInParentWindow.y != y) {
            this.mLocationInParentWindow.x = x;
            this.mLocationInParentWindow.y = y;
            if (this.mWmService.mAccessibilityController != null) {
                this.mWmService.mAccessibilityController.onSomeWindowResizedOrMovedLocked();
            }
        }
    }

    Point getLocationInParentWindow() {
        return this.mLocationInParentWindow;
    }

    @VisibleForTesting
    SurfaceControl getWindowingLayer() {
        return this.mWindowingLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateSystemGestureExclusion() {
        if (this.mSystemGestureExclusionListeners.getRegisteredCallbackCount() == 0) {
            return false;
        }
        Region systemGestureExclusion = this.calculateSystemGestureExclusion();
        try {
            if (this.mSystemGestureExclusion.equals(systemGestureExclusion)) {
                boolean bl = false;
                return bl;
            }
            this.mSystemGestureExclusion.set(systemGestureExclusion);
            for (int i = this.mSystemGestureExclusionListeners.beginBroadcast() - 1; i >= 0; --i) {
                try {
                    this.mSystemGestureExclusionListeners.getBroadcastItem(i).onSystemGestureExclusionChanged(this.mDisplayId, systemGestureExclusion);
                    continue;
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Failed to notify SystemGestureExclusionListener", e);
                }
            }
            this.mSystemGestureExclusionListeners.finishBroadcast();
            boolean bl = true;
            return bl;
        }
        finally {
            systemGestureExclusion.recycle();
        }
    }

    @VisibleForTesting
    Region calculateSystemGestureExclusion() {
        Region unhandled = Region.obtain();
        unhandled.set(0, 0, this.mDisplayFrames.mDisplayWidth, this.mDisplayFrames.mDisplayHeight);
        Rect leftEdge = this.mInsetsStateController.getSourceProvider(6).getSource().getFrame();
        Rect rightEdge = this.mInsetsStateController.getSourceProvider(7).getSource().getFrame();
        Region global = Region.obtain();
        Region touchableRegion = Region.obtain();
        Region local = Region.obtain();
        int[] remainingLeftRight = new int[]{this.mSystemGestureExclusionLimit, this.mSystemGestureExclusionLimit};
        this.forAllWindows((WindowState w) -> {
            if (w.cantReceiveTouchInput() || !w.isVisible() || (w.getAttrs().flags & 0x10) != 0 || unhandled.isEmpty()) {
                return;
            }
            w.getEffectiveTouchableRegion(touchableRegion);
            touchableRegion.op(unhandled, Region.Op.INTERSECT);
            if (w.isImplicitlyExcludingAllSystemGestures()) {
                local.set(touchableRegion);
            } else {
                RegionUtils.rectListToRegion(w.getSystemGestureExclusion(), local);
                local.scale(w.mGlobalScale);
                Rect frame = w.getWindowFrames().mFrame;
                local.translate(frame.left, frame.top);
                local.op(touchableRegion, Region.Op.INTERSECT);
            }
            if (DisplayContent.needsGestureExclusionRestrictions(w, this.mLastDispatchedSystemUiVisibility)) {
                remainingLeftRight[0] = DisplayContent.addToGlobalAndConsumeLimit(local, global, leftEdge, remainingLeftRight[0]);
                remainingLeftRight[1] = DisplayContent.addToGlobalAndConsumeLimit(local, global, rightEdge, remainingLeftRight[1]);
                Region middle = Region.obtain(local);
                middle.op(leftEdge, Region.Op.DIFFERENCE);
                middle.op(rightEdge, Region.Op.DIFFERENCE);
                global.op(middle, Region.Op.UNION);
                middle.recycle();
            } else {
                global.op(local, Region.Op.UNION);
            }
            unhandled.op(touchableRegion, Region.Op.DIFFERENCE);
        }, true);
        local.recycle();
        touchableRegion.recycle();
        unhandled.recycle();
        return global;
    }

    private static boolean needsGestureExclusionRestrictions(WindowState win, int sysUiVisibility) {
        int type = win.mAttrs.type;
        int stickyHideNavFlags = 4098;
        boolean stickyHideNav = (sysUiVisibility & 0x1002) == 4098;
        return !stickyHideNav && type != 2011 && type != 2000 && win.getActivityType() != 2;
    }

    private static int addToGlobalAndConsumeLimit(Region local, Region global, Rect edge, int limit) {
        Region r = Region.obtain(local);
        r.op(edge, Region.Op.INTERSECT);
        int[] remaining = new int[]{limit};
        RegionUtils.forEachRectReverse(r, rect -> {
            if (remaining[0] <= 0) {
                return;
            }
            int height = rect.height();
            if (height > remaining[0]) {
                rect.top = rect.bottom - remaining[0];
            }
            remaining[0] = remaining[0] - height;
            global.op((Rect)rect, Region.Op.UNION);
        });
        r.recycle();
        return remaining[0];
    }

    void registerSystemGestureExclusionListener(ISystemGestureExclusionListener listener) {
        this.mSystemGestureExclusionListeners.register(listener);
        boolean changed = this.mSystemGestureExclusionListeners.getRegisteredCallbackCount() == 1 ? this.updateSystemGestureExclusion() : false;
        if (!changed) {
            try {
                listener.onSystemGestureExclusionChanged(this.mDisplayId, this.mSystemGestureExclusion);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to notify SystemGestureExclusionListener during register", e);
            }
        }
    }

    void unregisterSystemGestureExclusionListener(ISystemGestureExclusionListener listener) {
        this.mSystemGestureExclusionListeners.unregister(listener);
    }

    private InputWindowHandle createPortalWindowHandle(String name) {
        InputWindowHandle portalWindowHandle = new InputWindowHandle(null, null, -1);
        portalWindowHandle.name = name;
        portalWindowHandle.token = new Binder();
        portalWindowHandle.layoutParamsFlags = 0x800028;
        this.getBounds(this.mTmpBounds);
        portalWindowHandle.touchableRegion.set(this.mTmpBounds);
        portalWindowHandle.scaleFactor = 1.0f;
        portalWindowHandle.ownerPid = Process.myPid();
        portalWindowHandle.ownerUid = Process.myUid();
        portalWindowHandle.portalToDisplayId = this.mDisplayId;
        return portalWindowHandle;
    }

    public void setForwardedInsets(Insets insets) {
        if (insets == null) {
            insets = Insets.NONE;
        }
        if (this.mDisplayPolicy.getForwardedInsets().equals(insets)) {
            return;
        }
        this.mDisplayPolicy.setForwardedInsets(insets);
        this.setLayoutNeeded();
        this.mWmService.mWindowPlacerLocked.requestTraversal();
    }

    protected MetricsLogger getMetricsLogger() {
        if (this.mMetricsLogger == null) {
            this.mMetricsLogger = new MetricsLogger();
        }
        return this.mMetricsLogger;
    }

    private class NonAppWindowContainers
    extends DisplayChildWindowContainer<WindowToken> {
        private final Comparator<WindowToken> mWindowComparator;
        private final Predicate<WindowState> mGetOrientingWindow;
        private final String mName;
        private final Dimmer mDimmer;
        private final Rect mTmpDimBoundsRect;

        NonAppWindowContainers(String name, WindowManagerService service) {
            super(service);
            this.mWindowComparator = (token1, token2) -> this.mWmService.mPolicy.getWindowLayerFromTypeLw(token1.windowType, token1.mOwnerCanManageAppTokens) < this.mWmService.mPolicy.getWindowLayerFromTypeLw(token2.windowType, token2.mOwnerCanManageAppTokens) ? -1 : 1;
            this.mGetOrientingWindow = w -> {
                if (!w.isVisibleLw() || !w.mLegacyPolicyVisibilityAfterAnim) {
                    return false;
                }
                int req = w.mAttrs.screenOrientation;
                return req != -1 && req != 3 && req != -2;
            };
            this.mDimmer = new Dimmer(this);
            this.mTmpDimBoundsRect = new Rect();
            this.mName = name;
        }

        void addChild(WindowToken token) {
            this.addChild(token, this.mWindowComparator);
        }

        @Override
        int getOrientation() {
            boolean isUnoccluding;
            WindowManagerPolicy policy = this.mWmService.mPolicy;
            WindowState win = this.getWindow(this.mGetOrientingWindow);
            if (win != null) {
                int req = win.mAttrs.screenOrientation;
                if (policy.isKeyguardHostWindow(win.mAttrs)) {
                    DisplayContent.this.mLastKeyguardForcedOrientation = req;
                    if (this.mWmService.mKeyguardGoingAway) {
                        DisplayContent.this.mLastWindowForcedOrientation = -1;
                        return -2;
                    }
                }
                return DisplayContent.this.mLastWindowForcedOrientation = req;
            }
            DisplayContent.this.mLastWindowForcedOrientation = -1;
            boolean bl = isUnoccluding = DisplayContent.this.mAppTransition.getAppTransition() == 23 && DisplayContent.this.mUnknownAppVisibilityController.allResolved();
            if (policy.isKeyguardShowingAndNotOccluded() || isUnoccluding) {
                return DisplayContent.this.mLastKeyguardForcedOrientation;
            }
            return -2;
        }

        @Override
        String getName() {
            return this.mName;
        }

        @Override
        Dimmer getDimmer() {
            return this.mDimmer;
        }

        @Override
        void prepareSurfaces() {
            this.mDimmer.resetDimStates();
            super.prepareSurfaces();
            this.getBounds(this.mTmpDimBoundsRect);
            if (this.mDimmer.updateDims(this.getPendingTransaction(), this.mTmpDimBoundsRect)) {
                this.scheduleAnimation();
            }
        }
    }

    private final class AboveAppWindowContainers
    extends NonAppWindowContainers {
        AboveAppWindowContainers(String name, WindowManagerService service) {
            super(name, service);
        }

        @Override
        SurfaceControl.Builder makeChildSurface(WindowContainer child) {
            SurfaceControl.Builder builder = super.makeChildSurface(child);
            if (child instanceof WindowToken && ((WindowToken)child).mRoundedCornerOverlay) {
                builder.setParent(null);
            }
            return builder;
        }

        @Override
        void assignChildLayers(SurfaceControl.Transaction t) {
            this.assignChildLayers(t, null);
        }

        void assignChildLayers(SurfaceControl.Transaction t, WindowContainer imeContainer) {
            boolean needAssignIme = imeContainer != null && imeContainer.getSurfaceControl() != null;
            for (int j = 0; j < this.mChildren.size(); ++j) {
                WindowToken wt = (WindowToken)this.mChildren.get(j);
                if (wt.windowType == 2034) {
                    wt.assignRelativeLayer(t, DisplayContent.this.mTaskStackContainers.getSplitScreenDividerAnchor(), 1);
                    continue;
                }
                if (wt.mRoundedCornerOverlay) {
                    wt.assignLayer(t, 0x40000002);
                    continue;
                }
                wt.assignLayer(t, j);
                wt.assignChildLayers(t);
                int layer = this.mWmService.mPolicy.getWindowLayerFromTypeLw(wt.windowType, wt.mOwnerCanManageAppTokens);
                if (!needAssignIme || layer < this.mWmService.mPolicy.getWindowLayerFromTypeLw(2012, true)) continue;
                imeContainer.assignRelativeLayer(t, wt.getSurfaceControl(), -1);
                needAssignIme = false;
            }
            if (needAssignIme) {
                imeContainer.assignRelativeLayer(t, this.getSurfaceControl(), Integer.MAX_VALUE);
            }
        }
    }

    private final class TaskStackContainers
    extends DisplayChildWindowContainer<TaskStack> {
        SurfaceControl mAppAnimationLayer;
        SurfaceControl mBoostedAppAnimationLayer;
        SurfaceControl mHomeAppAnimationLayer;
        SurfaceControl mSplitScreenDividerAnchor;
        private TaskStack mHomeStack;
        private TaskStack mPinnedStack;
        private TaskStack mSplitScreenPrimaryStack;

        TaskStackContainers(WindowManagerService service) {
            super(service);
            this.mAppAnimationLayer = null;
            this.mBoostedAppAnimationLayer = null;
            this.mHomeAppAnimationLayer = null;
            this.mSplitScreenDividerAnchor = null;
            this.mHomeStack = null;
            this.mPinnedStack = null;
            this.mSplitScreenPrimaryStack = null;
        }

        TaskStack getStack(int windowingMode, int activityType) {
            if (activityType == 2) {
                return this.mHomeStack;
            }
            if (windowingMode == 2) {
                return this.mPinnedStack;
            }
            if (windowingMode == 3) {
                return this.mSplitScreenPrimaryStack;
            }
            for (int i = DisplayContent.this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
                TaskStack stack = (TaskStack)DisplayContent.this.mTaskStackContainers.getChildAt(i);
                if (activityType == 0 && windowingMode == stack.getWindowingMode()) {
                    return stack;
                }
                if (!stack.isCompatible(windowingMode, activityType)) continue;
                return stack;
            }
            return null;
        }

        @VisibleForTesting
        TaskStack getTopStack() {
            return DisplayContent.this.mTaskStackContainers.getChildCount() > 0 ? (TaskStack)DisplayContent.this.mTaskStackContainers.getChildAt(DisplayContent.this.mTaskStackContainers.getChildCount() - 1) : null;
        }

        TaskStack getHomeStack() {
            if (this.mHomeStack == null && DisplayContent.this.mDisplayId == 0) {
                Slog.e(DisplayContent.TAG, "getHomeStack: Returning null from this=" + this);
            }
            return this.mHomeStack;
        }

        TaskStack getPinnedStack() {
            return this.mPinnedStack;
        }

        TaskStack getSplitScreenPrimaryStack() {
            return this.mSplitScreenPrimaryStack;
        }

        ArrayList<Task> getVisibleTasks() {
            ArrayList<Task> visibleTasks = new ArrayList<Task>();
            this.forAllTasks(task -> {
                if (task.isVisible()) {
                    visibleTasks.add((Task)task);
                }
            });
            return visibleTasks;
        }

        void addStackToDisplay(TaskStack stack, boolean onTop) {
            this.addStackReferenceIfNeeded(stack);
            this.addChild(stack, onTop);
            stack.onDisplayChanged(DisplayContent.this);
        }

        void onStackWindowingModeChanged(TaskStack stack) {
            this.removeStackReferenceIfNeeded(stack);
            this.addStackReferenceIfNeeded(stack);
            if (stack == this.mPinnedStack && this.getTopStack() != stack) {
                this.positionChildAt(Integer.MAX_VALUE, stack, false);
            }
        }

        private void addStackReferenceIfNeeded(TaskStack stack) {
            int windowingMode;
            if (stack.isActivityTypeHome()) {
                if (this.mHomeStack != null) {
                    throw new IllegalArgumentException("addStackReferenceIfNeeded: home stack=" + this.mHomeStack + " already exist on display=" + this + " stack=" + stack);
                }
                this.mHomeStack = stack;
            }
            if ((windowingMode = stack.getWindowingMode()) == 2) {
                if (this.mPinnedStack != null) {
                    throw new IllegalArgumentException("addStackReferenceIfNeeded: pinned stack=" + this.mPinnedStack + " already exist on display=" + this + " stack=" + stack);
                }
                this.mPinnedStack = stack;
            } else if (windowingMode == 3) {
                if (this.mSplitScreenPrimaryStack != null) {
                    throw new IllegalArgumentException("addStackReferenceIfNeeded: split-screen-primary stack=" + this.mSplitScreenPrimaryStack + " already exist on display=" + this + " stack=" + stack);
                }
                this.mSplitScreenPrimaryStack = stack;
                DisplayContent.this.mDividerControllerLocked.notifyDockedStackExistsChanged(true);
            }
        }

        private void removeStackReferenceIfNeeded(TaskStack stack) {
            if (stack == this.mHomeStack) {
                this.mHomeStack = null;
            } else if (stack == this.mPinnedStack) {
                this.mPinnedStack = null;
            } else if (stack == this.mSplitScreenPrimaryStack) {
                this.mSplitScreenPrimaryStack = null;
                this.mWmService.setDockedStackCreateStateLocked(0, null);
                DisplayContent.this.mDividerControllerLocked.notifyDockedStackExistsChanged(false);
            }
        }

        private void addChild(TaskStack stack, boolean toTop) {
            int addIndex = this.findPositionForStack(toTop ? this.mChildren.size() : 0, stack, true);
            this.addChild(stack, addIndex);
            DisplayContent.this.setLayoutNeeded();
        }

        @Override
        protected void removeChild(TaskStack stack) {
            super.removeChild(stack);
            this.removeStackReferenceIfNeeded(stack);
        }

        @Override
        boolean isOnTop() {
            return true;
        }

        @Override
        void positionChildAt(int position, TaskStack child, boolean includingParents) {
            int topChildPosition;
            if (child.getWindowConfiguration().isAlwaysOnTop() && position != Integer.MAX_VALUE) {
                Slog.w(DisplayContent.TAG, "Ignoring move of always-on-top stack=" + this + " to bottom");
                int currentPosition = this.mChildren.indexOf(child);
                super.positionChildAt(currentPosition, child, false);
                return;
            }
            int targetPosition = this.findPositionForStack(position, child, false);
            super.positionChildAt(targetPosition, child, includingParents);
            if (includingParents && targetPosition < (topChildPosition = this.getChildCount() - 1) && position >= topChildPosition) {
                this.getParent().positionChildAt(Integer.MAX_VALUE, this, true);
            }
            DisplayContent.this.setLayoutNeeded();
        }

        private int findPositionForStack(int requestedPosition, TaskStack stack, boolean adding) {
            if (stack.inPinnedWindowingMode()) {
                return Integer.MAX_VALUE;
            }
            int topChildPosition = this.mChildren.size() - 1;
            int belowAlwaysOnTopPosition = Integer.MIN_VALUE;
            for (int i = topChildPosition; i >= 0; --i) {
                if (DisplayContent.this.getStacks().get(i) == stack || ((TaskStack)DisplayContent.this.getStacks().get(i)).isAlwaysOnTop()) continue;
                belowAlwaysOnTopPosition = i;
                break;
            }
            int maxPosition = Integer.MAX_VALUE;
            int minPosition = Integer.MIN_VALUE;
            if (stack.isAlwaysOnTop()) {
                if (DisplayContent.this.hasPinnedStack()) {
                    maxPosition = DisplayContent.this.getStacks().indexOf(this.mPinnedStack) - 1;
                }
                minPosition = belowAlwaysOnTopPosition != Integer.MIN_VALUE ? belowAlwaysOnTopPosition : topChildPosition;
            } else {
                maxPosition = belowAlwaysOnTopPosition != Integer.MIN_VALUE ? belowAlwaysOnTopPosition : 0;
            }
            int targetPosition = requestedPosition;
            targetPosition = Math.min(targetPosition, maxPosition);
            targetPosition = Math.max(targetPosition, minPosition);
            int prevPosition = DisplayContent.this.getStacks().indexOf(stack);
            if (targetPosition != requestedPosition && (adding || targetPosition < prevPosition)) {
                ++targetPosition;
            }
            return targetPosition;
        }

        @Override
        boolean forAllWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
            if (traverseTopToBottom) {
                if (super.forAllWindows(callback, traverseTopToBottom)) {
                    return true;
                }
                if (this.forAllExitingAppTokenWindows(callback, traverseTopToBottom)) {
                    return true;
                }
            } else {
                if (this.forAllExitingAppTokenWindows(callback, traverseTopToBottom)) {
                    return true;
                }
                if (super.forAllWindows(callback, traverseTopToBottom)) {
                    return true;
                }
            }
            return false;
        }

        private boolean forAllExitingAppTokenWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
            if (traverseTopToBottom) {
                for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                    AppTokenList appTokens = ((TaskStack)this.mChildren.get((int)i)).mExitingAppTokens;
                    for (int j = appTokens.size() - 1; j >= 0; --j) {
                        if (!((AppWindowToken)appTokens.get(j)).forAllWindowsUnchecked(callback, traverseTopToBottom)) continue;
                        return true;
                    }
                }
            } else {
                int count = this.mChildren.size();
                for (int i = 0; i < count; ++i) {
                    AppTokenList appTokens = ((TaskStack)this.mChildren.get((int)i)).mExitingAppTokens;
                    int appTokensCount = appTokens.size();
                    for (int j = 0; j < appTokensCount; ++j) {
                        if (!((AppWindowToken)appTokens.get(j)).forAllWindowsUnchecked(callback, traverseTopToBottom)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        void setExitingTokensHasVisible(boolean hasVisible) {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                AppTokenList appTokens = ((TaskStack)this.mChildren.get((int)i)).mExitingAppTokens;
                for (int j = appTokens.size() - 1; j >= 0; --j) {
                    ((AppWindowToken)appTokens.get((int)j)).hasVisible = hasVisible;
                }
            }
        }

        void removeExistingAppTokensIfPossible() {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                AppTokenList appTokens = ((TaskStack)this.mChildren.get((int)i)).mExitingAppTokens;
                for (int j = appTokens.size() - 1; j >= 0; --j) {
                    AppWindowToken token = (AppWindowToken)appTokens.get(j);
                    if (token.hasVisible || DisplayContent.this.mClosingApps.contains(token) || token.mIsExiting && !token.isEmpty()) continue;
                    this.cancelAnimation();
                    token.removeIfPossible();
                }
            }
        }

        @Override
        int getOrientation() {
            if (DisplayContent.this.isStackVisible(3) || DisplayContent.this.isStackVisible(5)) {
                int orientation;
                if (this.mHomeStack != null && this.mHomeStack.isVisible() && DisplayContent.this.mDividerControllerLocked.isMinimizedDock() && (!DisplayContent.this.mDividerControllerLocked.isHomeStackResizable() || !this.mHomeStack.matchParentBounds()) && (orientation = this.mHomeStack.getOrientation()) != -2) {
                    return orientation;
                }
                return -1;
            }
            int orientation = super.getOrientation();
            boolean isCar = this.mWmService.mContext.getPackageManager().hasSystemFeature("android.hardware.type.automotive");
            if (isCar) {
                return -1;
            }
            if (orientation != -2 && orientation != 3) {
                return orientation;
            }
            return DisplayContent.this.mLastOrientation;
        }

        @Override
        void assignChildLayers(SurfaceControl.Transaction t) {
            this.assignStackOrdering(t);
            for (int i = 0; i < this.mChildren.size(); ++i) {
                TaskStack s = (TaskStack)this.mChildren.get(i);
                s.assignChildLayers(t);
            }
        }

        void assignStackOrdering(SurfaceControl.Transaction t) {
            boolean HOME_STACK_STATE = false;
            boolean NORMAL_STACK_STATE = true;
            int ALWAYS_ON_TOP_STATE = 2;
            int layer = 0;
            int layerForAnimationLayer = 0;
            int layerForBoostedAnimationLayer = 0;
            int layerForHomeAnimationLayer = 0;
            for (int state = 0; state <= 2; ++state) {
                for (int i = 0; i < this.mChildren.size(); ++i) {
                    TaskStack s = (TaskStack)this.mChildren.get(i);
                    if (state == 0 && !s.isActivityTypeHome() || state == 1 && (s.isActivityTypeHome() || s.isAlwaysOnTop()) || state == 2 && !s.isAlwaysOnTop()) continue;
                    s.assignLayer(t, layer++);
                    if (s.inSplitScreenWindowingMode() && this.mSplitScreenDividerAnchor != null) {
                        t.setLayer(this.mSplitScreenDividerAnchor, layer++);
                    }
                    if ((s.isTaskAnimating() || s.isAppAnimating()) && state != 2) {
                        layerForAnimationLayer = layer++;
                    }
                    if (state == 2) continue;
                    layerForBoostedAnimationLayer = layer++;
                }
                if (state != 0) continue;
                layerForHomeAnimationLayer = layer++;
            }
            if (this.mAppAnimationLayer != null) {
                t.setLayer(this.mAppAnimationLayer, layerForAnimationLayer);
            }
            if (this.mBoostedAppAnimationLayer != null) {
                t.setLayer(this.mBoostedAppAnimationLayer, layerForBoostedAnimationLayer);
            }
            if (this.mHomeAppAnimationLayer != null) {
                t.setLayer(this.mHomeAppAnimationLayer, layerForHomeAnimationLayer);
            }
        }

        @Override
        SurfaceControl getAppAnimationLayer(@WindowContainer.AnimationLayer int animationLayer) {
            switch (animationLayer) {
                case 1: {
                    return this.mBoostedAppAnimationLayer;
                }
                case 2: {
                    return this.mHomeAppAnimationLayer;
                }
            }
            return this.mAppAnimationLayer;
        }

        SurfaceControl getSplitScreenDividerAnchor() {
            return this.mSplitScreenDividerAnchor;
        }

        @Override
        void onParentChanged() {
            super.onParentChanged();
            if (this.getParent() != null) {
                this.mAppAnimationLayer = this.makeChildSurface(null).setName("animationLayer").build();
                this.mBoostedAppAnimationLayer = this.makeChildSurface(null).setName("boostedAnimationLayer").build();
                this.mHomeAppAnimationLayer = this.makeChildSurface(null).setName("homeAnimationLayer").build();
                this.mSplitScreenDividerAnchor = this.makeChildSurface(null).setName("splitScreenDividerAnchor").build();
                this.getPendingTransaction().show(this.mAppAnimationLayer).show(this.mBoostedAppAnimationLayer).show(this.mHomeAppAnimationLayer).show(this.mSplitScreenDividerAnchor);
                this.scheduleAnimation();
            } else {
                this.mAppAnimationLayer.remove();
                this.mAppAnimationLayer = null;
                this.mBoostedAppAnimationLayer.remove();
                this.mBoostedAppAnimationLayer = null;
                this.mHomeAppAnimationLayer.remove();
                this.mHomeAppAnimationLayer = null;
                this.mSplitScreenDividerAnchor.remove();
                this.mSplitScreenDividerAnchor = null;
            }
        }
    }

    static class DisplayChildWindowContainer<E extends WindowContainer>
    extends WindowContainer<E> {
        DisplayChildWindowContainer(WindowManagerService service) {
            super(service);
        }

        @Override
        boolean fillsParent() {
            return true;
        }

        @Override
        boolean isVisible() {
            return true;
        }
    }

    private static final class ScreenshotApplicationState {
        WindowState appWin;
        int maxLayer;
        int minLayer;
        boolean screenshotReady;

        private ScreenshotApplicationState() {
        }

        void reset(boolean screenshotReady) {
            this.appWin = null;
            this.maxLayer = 0;
            this.minLayer = 0;
            this.screenshotReady = screenshotReady;
            this.minLayer = screenshotReady ? 0 : Integer.MAX_VALUE;
        }
    }

    private static final class ApplySurfaceChangesTransactionState {
        boolean displayHasContent;
        boolean obscured;
        boolean syswin;
        float preferredRefreshRate;
        int preferredModeId;

        private ApplySurfaceChangesTransactionState() {
        }

        void reset() {
            this.displayHasContent = false;
            this.obscured = false;
            this.syswin = false;
            this.preferredRefreshRate = 0.0f;
            this.preferredModeId = 0;
        }
    }

    static final class TaskForResizePointSearchResult {
        boolean searchDone;
        Task taskForResize;

        TaskForResizePointSearchResult() {
        }

        void reset() {
            this.searchDone = false;
            this.taskForResize = null;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ForceScalingMode {
    }
}

