/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.ContextImpl;
import android.app.LoadedApk;
import android.app.ResourcesManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Insets;
import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.input.InputManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Pair;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.view.DisplayCutout;
import android.view.IApplicationToken;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.MotionEvent;
import android.view.ViewRootImpl;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.policy.ScreenDecorationsUtils;
import com.android.internal.util.ScreenShapeHelper;
import com.android.internal.util.ScreenshotHelper;
import com.android.internal.util.function.TriConsumer;
import com.android.internal.widget.PointerLocationView;
import com.android.server.LocalServices;
import com.android.server.UiThread;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.policy.WindowOrientationListener;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.wallpaper.WallpaperManagerInternal;
import com.android.server.wm.ActivityTaskManagerInternal;
import com.android.server.wm.BarController;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplayFrames;
import com.android.server.wm.DisplayRotation;
import com.android.server.wm.ImmersiveModeConfirmation;
import com.android.server.wm.PolicyControl;
import com.android.server.wm.RefreshRatePolicy;
import com.android.server.wm.StatusBarController;
import com.android.server.wm.SystemGesturesPointerEventListener;
import com.android.server.wm.WindowFrames;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.utils.InsetUtils;
import java.io.PrintWriter;

public class DisplayPolicy {
    private static final String TAG = "WindowManager";
    private static final boolean DEBUG = false;
    private static final boolean ALTERNATE_CAR_MODE_NAV_SIZE = false;
    private static final long PANIC_GESTURE_EXPIRATION = 30000L;
    private static final int NAV_BAR_OPAQUE_WHEN_FREEFORM_OR_DOCKED = 0;
    private static final int NAV_BAR_TRANSLUCENT_WHEN_FREEFORM_OPAQUE_OTHERWISE = 1;
    private static final int NAV_BAR_FORCE_TRANSPARENT = 2;
    private static final int SYSTEM_UI_CHANGING_LAYOUT = -1073709042;
    private final WindowManagerService mService;
    private final Context mContext;
    private final DisplayContent mDisplayContent;
    private final Object mLock;
    private final Handler mHandler;
    private Resources mCurrentUserResources;
    private final boolean mCarDockEnablesAccelerometer;
    private final boolean mDeskDockEnablesAccelerometer;
    private final AccessibilityManager mAccessibilityManager;
    private final ImmersiveModeConfirmation mImmersiveModeConfirmation;
    private final ScreenshotHelper mScreenshotHelper;
    private final Object mServiceAcquireLock = new Object();
    private StatusBarManagerInternal mStatusBarManagerInternal;
    private int mBottomGestureAdditionalInset;
    private int mSideGestureInset;
    private final SystemGesturesPointerEventListener mSystemGestures;
    private volatile int mLidState = -1;
    private volatile int mDockMode = 0;
    private volatile boolean mHdmiPlugged;
    private volatile boolean mHasStatusBar;
    private volatile boolean mHasNavigationBar;
    private volatile boolean mNavigationBarCanMove;
    private volatile boolean mNavigationBarLetsThroughTaps;
    private volatile boolean mNavigationBarAlwaysShowOnSideGesture;
    private volatile boolean mAllowSeamlessRotationDespiteNavBarMoving;
    private volatile boolean mPersistentVrModeEnabled;
    private volatile boolean mAwake;
    private volatile boolean mScreenOnEarly;
    private volatile boolean mScreenOnFully;
    private volatile WindowManagerPolicy.ScreenOnListener mScreenOnListener;
    private volatile boolean mKeyguardDrawComplete;
    private volatile boolean mWindowManagerDrawComplete;
    private final ArraySet<WindowState> mScreenDecorWindows = new ArraySet();
    private WindowState mStatusBar = null;
    private final int[] mStatusBarHeightForRotation = new int[4];
    private WindowState mNavigationBar = null;
    private int mNavigationBarPosition = 4;
    private int[] mNavigationBarHeightForRotationDefault = new int[4];
    private int[] mNavigationBarWidthForRotationDefault = new int[4];
    private int[] mNavigationBarHeightForRotationInCarMode = new int[4];
    private int[] mNavigationBarWidthForRotationInCarMode = new int[4];
    private int[] mNavigationBarFrameHeightForRotationDefault = new int[4];
    private int mWindowOutsetBottom;
    private final StatusBarController mStatusBarController;
    private final BarController mNavigationBarController;
    private final BarController.OnBarVisibilityChangedListener mNavBarVisibilityListener = new BarController.OnBarVisibilityChangedListener(){

        @Override
        public void onBarVisibilityChanged(boolean visible) {
            if (DisplayPolicy.this.mAccessibilityManager == null) {
                return;
            }
            DisplayPolicy.this.mAccessibilityManager.notifyAccessibilityButtonVisibilityChanged(visible);
        }
    };
    @GuardedBy(value={"mHandler"})
    private ActivityTaskManagerInternal.SleepToken mDreamingSleepToken;
    @GuardedBy(value={"mHandler"})
    private ActivityTaskManagerInternal.SleepToken mWindowSleepToken;
    private final Runnable mAcquireSleepTokenRunnable;
    private final Runnable mReleaseSleepTokenRunnable;
    private WindowState mFocusedWindow;
    private WindowState mLastFocusedWindow;
    IApplicationToken mFocusedApp;
    int mLastSystemUiFlags;
    private int mResettingSystemUiFlags = 0;
    private int mForceClearedSystemUiFlags = 0;
    private int mLastFullscreenStackSysUiFlags;
    private int mLastDockedStackSysUiFlags;
    private final Rect mNonDockedStackBounds = new Rect();
    private final Rect mDockedStackBounds = new Rect();
    private final Rect mLastNonDockedStackBounds = new Rect();
    private final Rect mLastDockedStackBounds = new Rect();
    private boolean mLastFocusNeedsMenu = false;
    private long mPendingPanicGestureUptime;
    private static final Rect sTmpDisplayCutoutSafeExceptMaybeBarsRect = new Rect();
    private static final Rect sTmpRect = new Rect();
    private static final Rect sTmpDockedFrame = new Rect();
    private static final Rect sTmpNavFrame = new Rect();
    private static final Rect sTmpLastParentFrame = new Rect();
    private WindowState mTopFullscreenOpaqueWindowState;
    private WindowState mTopFullscreenOpaqueOrDimmingWindowState;
    private WindowState mTopDockedOpaqueWindowState;
    private WindowState mTopDockedOpaqueOrDimmingWindowState;
    private boolean mTopIsFullscreen;
    private boolean mForceStatusBar;
    private boolean mForceStatusBarFromKeyguard;
    private boolean mForceStatusBarTransparent;
    private int mNavBarOpacityMode = 0;
    private boolean mForcingShowNavBar;
    private int mForcingShowNavBarLayer;
    private boolean mForceShowSystemBars;
    private boolean mForceShowSystemBarsFromExternal;
    private boolean mShowingDream;
    private boolean mLastShowingDream;
    private boolean mDreamingLockscreen;
    private boolean mDreamingSleepTokenNeeded;
    private boolean mWindowSleepTokenNeeded;
    private boolean mLastWindowSleepTokenNeeded;
    private boolean mAllowLockscreenWhenOn;
    private WindowManagerPolicy.InputConsumer mInputConsumer = null;
    private PointerLocationView mPointerLocationView;
    private Insets mForwardedInsets = Insets.NONE;
    private RefreshRatePolicy mRefreshRatePolicy;
    private static final int MSG_UPDATE_DREAMING_SLEEP_TOKEN = 1;
    private static final int MSG_REQUEST_TRANSIENT_BARS = 2;
    private static final int MSG_DISPOSE_INPUT_CONSUMER = 3;
    private static final int MSG_ENABLE_POINTER_LOCATION = 4;
    private static final int MSG_DISABLE_POINTER_LOCATION = 5;
    private static final int MSG_REQUEST_TRANSIENT_BARS_ARG_STATUS = 0;
    private static final int MSG_REQUEST_TRANSIENT_BARS_ARG_NAVIGATION = 1;
    private final Runnable mClearHideNavigationFlag = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DisplayPolicy.this.mLock;
            synchronized (object) {
                DisplayPolicy.this.mForceClearedSystemUiFlags &= -3;
                DisplayPolicy.this.mDisplayContent.reevaluateStatusBarVisibility();
            }
        }
    };
    private final Runnable mHiddenNavPanic = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DisplayPolicy.this.mLock;
            synchronized (object) {
                if (!((DisplayPolicy)DisplayPolicy.this).mService.mPolicy.isUserSetupComplete()) {
                    return;
                }
                DisplayPolicy.this.mPendingPanicGestureUptime = SystemClock.uptimeMillis();
                if (!DisplayPolicy.isNavBarEmpty(DisplayPolicy.this.mLastSystemUiFlags)) {
                    DisplayPolicy.this.mNavigationBarController.showTransient();
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatusBarManagerInternal getStatusBarManagerInternal() {
        Object object = this.mServiceAcquireLock;
        synchronized (object) {
            if (this.mStatusBarManagerInternal == null) {
                this.mStatusBarManagerInternal = LocalServices.getService(StatusBarManagerInternal.class);
            }
            return this.mStatusBarManagerInternal;
        }
    }

    DisplayPolicy(WindowManagerService service, DisplayContent displayContent) {
        this.mService = service;
        this.mContext = displayContent.isDefaultDisplay ? service.mContext : service.mContext.createDisplayContext(displayContent.getDisplay());
        this.mDisplayContent = displayContent;
        this.mLock = service.getWindowManagerLock();
        int displayId = displayContent.getDisplayId();
        this.mStatusBarController = new StatusBarController(displayId);
        this.mNavigationBarController = new BarController("NavigationBar", displayId, 0x8000000, 0x20000000, Integer.MIN_VALUE, 2, 0x8000000, 32768);
        Resources r = this.mContext.getResources();
        this.mCarDockEnablesAccelerometer = r.getBoolean(17891386);
        this.mDeskDockEnablesAccelerometer = r.getBoolean(17891401);
        this.mForceShowSystemBarsFromExternal = r.getBoolean(0x1110081);
        this.mAccessibilityManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
        if (!displayContent.isDefaultDisplay) {
            this.mAwake = true;
            this.mScreenOnEarly = true;
            this.mScreenOnFully = true;
        }
        Looper looper = UiThread.getHandler().getLooper();
        this.mHandler = new PolicyHandler(looper);
        this.mSystemGestures = new SystemGesturesPointerEventListener(this.mContext, this.mHandler, new SystemGesturesPointerEventListener.Callbacks(){

            @Override
            public void onSwipeFromTop() {
                if (DisplayPolicy.this.mStatusBar != null) {
                    DisplayPolicy.this.requestTransientBars(DisplayPolicy.this.mStatusBar);
                }
            }

            @Override
            public void onSwipeFromBottom() {
                if (DisplayPolicy.this.mNavigationBar != null && DisplayPolicy.this.mNavigationBarPosition == 4) {
                    DisplayPolicy.this.requestTransientBars(DisplayPolicy.this.mNavigationBar);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSwipeFromRight() {
                boolean sideAllowed;
                Region excludedRegion;
                Object object = DisplayPolicy.this.mLock;
                synchronized (object) {
                    excludedRegion = DisplayPolicy.this.mDisplayContent.calculateSystemGestureExclusion();
                }
                boolean bl = sideAllowed = DisplayPolicy.this.mNavigationBarAlwaysShowOnSideGesture || DisplayPolicy.this.mNavigationBarPosition == 2;
                if (DisplayPolicy.this.mNavigationBar != null && sideAllowed && !DisplayPolicy.this.mSystemGestures.currentGestureStartedInRegion(excludedRegion)) {
                    DisplayPolicy.this.requestTransientBars(DisplayPolicy.this.mNavigationBar);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSwipeFromLeft() {
                boolean sideAllowed;
                Region excludedRegion;
                Object object = DisplayPolicy.this.mLock;
                synchronized (object) {
                    excludedRegion = DisplayPolicy.this.mDisplayContent.calculateSystemGestureExclusion();
                }
                boolean bl = sideAllowed = DisplayPolicy.this.mNavigationBarAlwaysShowOnSideGesture || DisplayPolicy.this.mNavigationBarPosition == 1;
                if (DisplayPolicy.this.mNavigationBar != null && sideAllowed && !DisplayPolicy.this.mSystemGestures.currentGestureStartedInRegion(excludedRegion)) {
                    DisplayPolicy.this.requestTransientBars(DisplayPolicy.this.mNavigationBar);
                }
            }

            @Override
            public void onFling(int duration) {
                if (((DisplayPolicy)DisplayPolicy.this).mService.mPowerManagerInternal != null) {
                    ((DisplayPolicy)DisplayPolicy.this).mService.mPowerManagerInternal.powerHint(2, duration);
                }
            }

            @Override
            public void onDebug() {
            }

            private WindowOrientationListener getOrientationListener() {
                DisplayRotation rotation = DisplayPolicy.this.mDisplayContent.getDisplayRotation();
                return rotation != null ? rotation.getOrientationListener() : null;
            }

            @Override
            public void onDown() {
                WindowOrientationListener listener = this.getOrientationListener();
                if (listener != null) {
                    listener.onTouchStart();
                }
            }

            @Override
            public void onUpOrCancel() {
                WindowOrientationListener listener = this.getOrientationListener();
                if (listener != null) {
                    listener.onTouchEnd();
                }
            }

            @Override
            public void onMouseHoverAtTop() {
                DisplayPolicy.this.mHandler.removeMessages(2);
                Message msg = DisplayPolicy.this.mHandler.obtainMessage(2);
                msg.arg1 = 0;
                DisplayPolicy.this.mHandler.sendMessageDelayed(msg, 500L);
            }

            @Override
            public void onMouseHoverAtBottom() {
                DisplayPolicy.this.mHandler.removeMessages(2);
                Message msg = DisplayPolicy.this.mHandler.obtainMessage(2);
                msg.arg1 = 1;
                DisplayPolicy.this.mHandler.sendMessageDelayed(msg, 500L);
            }

            @Override
            public void onMouseLeaveFromEdge() {
                DisplayPolicy.this.mHandler.removeMessages(2);
            }
        });
        displayContent.registerPointerEventListener(this.mSystemGestures);
        displayContent.mAppTransition.registerListenerLocked(this.mStatusBarController.getAppTransitionListener());
        this.mImmersiveModeConfirmation = new ImmersiveModeConfirmation(this.mContext, looper, this.mService.mVrModeEnabled);
        this.mAcquireSleepTokenRunnable = () -> {
            if (this.mWindowSleepToken != null) {
                return;
            }
            this.mWindowSleepToken = service.mAtmInternal.acquireSleepToken("WindowSleepTokenOnDisplay" + displayId, displayId);
        };
        this.mReleaseSleepTokenRunnable = () -> {
            if (this.mWindowSleepToken == null) {
                return;
            }
            this.mWindowSleepToken.release();
            this.mWindowSleepToken = null;
        };
        ScreenshotHelper screenshotHelper = this.mScreenshotHelper = displayContent.isDefaultDisplay ? new ScreenshotHelper(this.mContext) : null;
        if (this.mDisplayContent.isDefaultDisplay) {
            this.mHasStatusBar = true;
            this.mHasNavigationBar = this.mContext.getResources().getBoolean(17891513);
            String navBarOverride = SystemProperties.get("qemu.hw.mainkeys");
            if ("1".equals(navBarOverride)) {
                this.mHasNavigationBar = false;
            } else if ("0".equals(navBarOverride)) {
                this.mHasNavigationBar = true;
            }
        } else {
            this.mHasStatusBar = false;
            this.mHasNavigationBar = this.mDisplayContent.supportsSystemDecorations();
        }
        this.mRefreshRatePolicy = new RefreshRatePolicy(this.mService, this.mDisplayContent.getDisplayInfo(), this.mService.mHighRefreshRateBlacklist);
    }

    void systemReady() {
        this.mSystemGestures.systemReady();
        if (this.mService.mPointerLocationEnabled) {
            this.setPointerLocationEnabled(true);
        }
    }

    private int getDisplayId() {
        return this.mDisplayContent.getDisplayId();
    }

    public void setHdmiPlugged(boolean plugged) {
        this.setHdmiPlugged(plugged, false);
    }

    public void setHdmiPlugged(boolean plugged, boolean force) {
        if (force || this.mHdmiPlugged != plugged) {
            this.mHdmiPlugged = plugged;
            this.mService.updateRotation(true, true);
            Intent intent = new Intent("android.intent.action.HDMI_PLUGGED");
            intent.addFlags(0x4000000);
            intent.putExtra("state", plugged);
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
    }

    boolean isHdmiPlugged() {
        return this.mHdmiPlugged;
    }

    boolean isCarDockEnablesAccelerometer() {
        return this.mCarDockEnablesAccelerometer;
    }

    boolean isDeskDockEnablesAccelerometer() {
        return this.mDeskDockEnablesAccelerometer;
    }

    public void setPersistentVrModeEnabled(boolean persistentVrModeEnabled) {
        this.mPersistentVrModeEnabled = persistentVrModeEnabled;
    }

    public boolean isPersistentVrModeEnabled() {
        return this.mPersistentVrModeEnabled;
    }

    public void setDockMode(int dockMode) {
        this.mDockMode = dockMode;
    }

    public int getDockMode() {
        return this.mDockMode;
    }

    void setForceShowSystemBars(boolean forceShowSystemBars) {
        this.mForceShowSystemBarsFromExternal = forceShowSystemBars;
    }

    public boolean hasNavigationBar() {
        return this.mHasNavigationBar;
    }

    public boolean hasStatusBar() {
        return this.mHasStatusBar;
    }

    public boolean navigationBarCanMove() {
        return this.mNavigationBarCanMove;
    }

    public void setLidState(int lidState) {
        this.mLidState = lidState;
    }

    public int getLidState() {
        return this.mLidState;
    }

    public void setAwake(boolean awake) {
        this.mAwake = awake;
    }

    public boolean isAwake() {
        return this.mAwake;
    }

    public boolean isScreenOnEarly() {
        return this.mScreenOnEarly;
    }

    public boolean isScreenOnFully() {
        return this.mScreenOnFully;
    }

    public boolean isKeyguardDrawComplete() {
        return this.mKeyguardDrawComplete;
    }

    public boolean isWindowManagerDrawComplete() {
        return this.mWindowManagerDrawComplete;
    }

    public WindowManagerPolicy.ScreenOnListener getScreenOnListener() {
        return this.mScreenOnListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void screenTurnedOn(WindowManagerPolicy.ScreenOnListener screenOnListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mScreenOnEarly = true;
            this.mScreenOnFully = false;
            this.mKeyguardDrawComplete = false;
            this.mWindowManagerDrawComplete = false;
            this.mScreenOnListener = screenOnListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void screenTurnedOff() {
        Object object = this.mLock;
        synchronized (object) {
            this.mScreenOnEarly = false;
            this.mScreenOnFully = false;
            this.mKeyguardDrawComplete = false;
            this.mWindowManagerDrawComplete = false;
            this.mScreenOnListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishKeyguardDrawn() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mScreenOnEarly || this.mKeyguardDrawComplete) {
                return false;
            }
            this.mKeyguardDrawComplete = true;
            this.mWindowManagerDrawComplete = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishWindowsDrawn() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mScreenOnEarly || this.mWindowManagerDrawComplete) {
                return false;
            }
            this.mWindowManagerDrawComplete = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishScreenTurningOn() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mScreenOnFully || !this.mScreenOnEarly || !this.mWindowManagerDrawComplete || this.mAwake && !this.mKeyguardDrawComplete) {
                return false;
            }
            this.mScreenOnListener = null;
            this.mScreenOnFully = true;
        }
        return true;
    }

    private boolean hasStatusBarServicePermission(int pid, int uid) {
        return this.mContext.checkPermission("android.permission.STATUS_BAR_SERVICE", pid, uid) == 0;
    }

    public void adjustWindowParamsLw(WindowState win, WindowManager.LayoutParams attrs, int callingPid, int callingUid) {
        boolean isScreenDecor;
        boolean bl = isScreenDecor = (attrs.privateFlags & 0x400000) != 0;
        if (this.mScreenDecorWindows.contains(win)) {
            if (!isScreenDecor) {
                this.mScreenDecorWindows.remove(win);
            }
        } else if (isScreenDecor && this.hasStatusBarServicePermission(callingPid, callingUid)) {
            this.mScreenDecorWindows.add(win);
        }
        switch (attrs.type) {
            case 2006: 
            case 2015: {
                attrs.flags |= 0x18;
                attrs.flags &= 0xFFFBFFFF;
                break;
            }
            case 2013: 
            case 2023: {
                attrs.layoutInDisplayCutoutMode = 1;
                break;
            }
            case 2000: {
                if (!this.mService.mPolicy.isKeyguardOccluded()) break;
                attrs.flags &= 0xFFEFFFFF;
                attrs.privateFlags &= 0xFFFFFBFF;
                break;
            }
            case 2036: {
                attrs.flags |= 8;
                break;
            }
            case 2005: {
                if (attrs.hideTimeoutMilliseconds < 0L || attrs.hideTimeoutMilliseconds > 3500L) {
                    attrs.hideTimeoutMilliseconds = 3500L;
                }
                attrs.hideTimeoutMilliseconds = this.mAccessibilityManager.getRecommendedTimeoutMillis((int)attrs.hideTimeoutMilliseconds, 2);
                attrs.windowAnimations = 16973828;
                if (!this.canToastShowWhenLocked(callingPid)) break;
                attrs.flags |= 0x80000;
            }
        }
        if (attrs.type != 2000) {
            attrs.privateFlags &= 0xFFFFFBFF;
        }
    }

    boolean canToastShowWhenLocked(int callingPid) {
        return this.mDisplayContent.forAllWindows(w -> callingPid == w.mSession.mPid && w.isVisible() && w.canShowWhenLocked(), true);
    }

    public int prepareAddWindowLw(WindowState win, WindowManager.LayoutParams attrs) {
        if ((attrs.privateFlags & 0x400000) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "DisplayPolicy");
            this.mScreenDecorWindows.add(win);
        }
        switch (attrs.type) {
            case 2000: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "DisplayPolicy");
                if (this.mStatusBar != null && this.mStatusBar.isAlive()) {
                    return -7;
                }
                this.mStatusBar = win;
                this.mStatusBarController.setWindow(win);
                if (this.mDisplayContent.isDefaultDisplay) {
                    this.mService.mPolicy.setKeyguardCandidateLw(win);
                }
                TriConsumer<DisplayFrames, WindowState, Rect> frameProvider = (displayFrames, windowState, rect) -> {
                    rect.top = 0;
                    rect.bottom = this.getStatusBarHeight((DisplayFrames)displayFrames);
                };
                this.mDisplayContent.setInsetProvider(0, win, frameProvider);
                this.mDisplayContent.setInsetProvider(4, win, frameProvider);
                this.mDisplayContent.setInsetProvider(8, win, frameProvider);
                break;
            }
            case 2019: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "DisplayPolicy");
                if (this.mNavigationBar != null && this.mNavigationBar.isAlive()) {
                    return -7;
                }
                this.mNavigationBar = win;
                this.mNavigationBarController.setWindow(win);
                this.mNavigationBarController.setOnBarVisibilityChangedListener(this.mNavBarVisibilityListener, true);
                this.mDisplayContent.setInsetProvider(1, win, null);
                this.mDisplayContent.setInsetProvider(5, win, (displayFrames, windowState, inOutFrame) -> inOutFrame.top -= this.mBottomGestureAdditionalInset);
                this.mDisplayContent.setInsetProvider(6, win, (displayFrames, windowState, inOutFrame) -> {
                    inOutFrame.left = 0;
                    inOutFrame.top = 0;
                    inOutFrame.bottom = displayFrames.mDisplayHeight;
                    inOutFrame.right = displayFrames.mUnrestricted.left + this.mSideGestureInset;
                });
                this.mDisplayContent.setInsetProvider(7, win, (displayFrames, windowState, inOutFrame) -> {
                    inOutFrame.left = displayFrames.mUnrestricted.right - this.mSideGestureInset;
                    inOutFrame.top = 0;
                    inOutFrame.bottom = displayFrames.mDisplayHeight;
                    inOutFrame.right = displayFrames.mDisplayWidth;
                });
                this.mDisplayContent.setInsetProvider(9, win, (displayFrames, windowState, inOutFrame) -> {
                    if ((windowState.getAttrs().flags & 0x10) != 0 || this.mNavigationBarLetsThroughTaps) {
                        inOutFrame.setEmpty();
                    }
                });
                break;
            }
            case 2014: 
            case 2017: 
            case 2024: 
            case 2033: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "DisplayPolicy");
            }
        }
        return 0;
    }

    public void removeWindowLw(WindowState win) {
        if (this.mStatusBar == win) {
            this.mStatusBar = null;
            this.mStatusBarController.setWindow(null);
            if (this.mDisplayContent.isDefaultDisplay) {
                this.mService.mPolicy.setKeyguardCandidateLw(null);
            }
            this.mDisplayContent.setInsetProvider(0, null, null);
        } else if (this.mNavigationBar == win) {
            this.mNavigationBar = null;
            this.mNavigationBarController.setWindow(null);
            this.mDisplayContent.setInsetProvider(1, null, null);
        }
        if (this.mLastFocusedWindow == win) {
            this.mLastFocusedWindow = null;
        }
        this.mScreenDecorWindows.remove(win);
    }

    private int getStatusBarHeight(DisplayFrames displayFrames) {
        return Math.max(this.mStatusBarHeightForRotation[displayFrames.mRotation], displayFrames.mDisplayCutoutSafe.top);
    }

    public int selectAnimationLw(WindowState win, int transit) {
        if (win == this.mStatusBar) {
            boolean expanded;
            boolean isKeyguard = (win.getAttrs().privateFlags & 0x400) != 0;
            boolean bl = expanded = win.getAttrs().height == -1 && win.getAttrs().width == -1;
            if (isKeyguard || expanded) {
                return -1;
            }
            if (transit == 2 || transit == 4) {
                return 17432757;
            }
            if (transit == 1 || transit == 3) {
                return 17432756;
            }
        } else if (win == this.mNavigationBar) {
            if (win.getAttrs().windowAnimations != 0) {
                return 0;
            }
            if (this.mNavigationBarPosition == 4) {
                if (transit == 2 || transit == 4) {
                    if (this.mService.mPolicy.isKeyguardShowingAndNotOccluded()) {
                        return 17432751;
                    }
                    return 17432750;
                }
                if (transit == 1 || transit == 3) {
                    return 17432749;
                }
            } else if (this.mNavigationBarPosition == 2) {
                if (transit == 2 || transit == 4) {
                    return 17432755;
                }
                if (transit == 1 || transit == 3) {
                    return 17432754;
                }
            } else if (this.mNavigationBarPosition == 1) {
                if (transit == 2 || transit == 4) {
                    return 17432753;
                }
                if (transit == 1 || transit == 3) {
                    return 17432752;
                }
            }
        } else if (win.getAttrs().type == 2034) {
            return this.selectDockedDividerAnimationLw(win, transit);
        }
        if (transit == 5) {
            if (win.hasAppShownWindows()) {
                return 17432730;
            }
        } else if (win.getAttrs().type == 2023 && this.mDreamingLockscreen && transit == 1) {
            return -1;
        }
        return 0;
    }

    private int selectDockedDividerAnimationLw(WindowState win, int transit) {
        boolean offscreen;
        int insets = this.mDisplayContent.getDockedDividerController().getContentInsets();
        Rect frame = win.getFrameLw();
        boolean behindNavBar = this.mNavigationBar != null && (this.mNavigationBarPosition == 4 && frame.top + insets >= this.mNavigationBar.getFrameLw().top || this.mNavigationBarPosition == 2 && frame.left + insets >= this.mNavigationBar.getFrameLw().left || this.mNavigationBarPosition == 1 && frame.right - insets <= this.mNavigationBar.getFrameLw().right);
        boolean landscape = frame.height() > frame.width();
        boolean offscreenLandscape = landscape && (frame.right - insets <= 0 || frame.left + insets >= win.getDisplayFrameLw().right);
        boolean offscreenPortrait = !landscape && (frame.top - insets <= 0 || frame.bottom + insets >= win.getDisplayFrameLw().bottom);
        boolean bl = offscreen = offscreenLandscape || offscreenPortrait;
        if (behindNavBar || offscreen) {
            return 0;
        }
        if (transit == 1 || transit == 3) {
            return 0x10A0000;
        }
        if (transit == 2) {
            return 0x10A0001;
        }
        return 0;
    }

    public void selectRotationAnimationLw(int[] anim2) {
        boolean forceJumpcut;
        boolean bl = forceJumpcut = !this.mScreenOnFully || !this.mService.mPolicy.okToAnimate();
        if (forceJumpcut) {
            anim2[0] = 17432847;
            anim2[1] = 17432846;
            return;
        }
        if (this.mTopFullscreenOpaqueWindowState != null) {
            int animationHint = this.mTopFullscreenOpaqueWindowState.getRotationAnimationHint();
            if (animationHint < 0 && this.mTopIsFullscreen) {
                animationHint = this.mTopFullscreenOpaqueWindowState.getAttrs().rotationAnimation;
            }
            switch (animationHint) {
                case 1: 
                case 3: {
                    anim2[0] = 0x10A0110;
                    anim2[1] = 17432846;
                    break;
                }
                case 2: {
                    anim2[0] = 17432847;
                    anim2[1] = 17432846;
                    break;
                }
                default: {
                    anim2[1] = 0;
                    anim2[0] = 0;
                    break;
                }
            }
        } else {
            anim2[1] = 0;
            anim2[0] = 0;
        }
    }

    public boolean validateRotationAnimationLw(int exitAnimId, int enterAnimId, boolean forceDefault) {
        switch (exitAnimId) {
            case 17432847: 
            case 0x10A0110: {
                if (forceDefault) {
                    return false;
                }
                int[] anim2 = new int[2];
                this.selectRotationAnimationLw(anim2);
                return exitAnimId == anim2[0] && enterAnimId == anim2[1];
            }
        }
        return true;
    }

    public int adjustSystemUiVisibilityLw(int visibility) {
        this.mStatusBarController.adjustSystemUiVisibilityLw(this.mLastSystemUiFlags, visibility);
        this.mNavigationBarController.adjustSystemUiVisibilityLw(this.mLastSystemUiFlags, visibility);
        this.mResettingSystemUiFlags &= visibility;
        return visibility & ~this.mResettingSystemUiFlags & ~this.mForceClearedSystemUiFlags;
    }

    public boolean areSystemBarsForcedShownLw(WindowState windowState) {
        return this.mForceShowSystemBars;
    }

    public boolean getLayoutHintLw(WindowManager.LayoutParams attrs, Rect taskBounds, DisplayFrames displayFrames, boolean floatingStack, Rect outFrame, Rect outContentInsets, Rect outStableInsets, Rect outOutsets, DisplayCutout.ParcelableWrapper outDisplayCutout) {
        boolean screenDecor;
        int outset;
        boolean useOutsets;
        int fl = PolicyControl.getWindowFlags(null, attrs);
        int pfl = attrs.privateFlags;
        int requestedSysUiVis = PolicyControl.getSystemUiVisibility(null, attrs);
        int sysUiVis = requestedSysUiVis | DisplayPolicy.getImpliedSysUiFlagsForLayout(attrs);
        int displayRotation = displayFrames.mRotation;
        boolean bl = useOutsets = outOutsets != null && DisplayPolicy.shouldUseOutsets(attrs, fl);
        if (useOutsets && (outset = this.mWindowOutsetBottom) > 0) {
            if (displayRotation == 0) {
                outOutsets.bottom += outset;
            } else if (displayRotation == 1) {
                outOutsets.right += outset;
            } else if (displayRotation == 2) {
                outOutsets.top += outset;
            } else if (displayRotation == 3) {
                outOutsets.left += outset;
            }
        }
        boolean layoutInScreen = (fl & 0x100) != 0;
        boolean layoutInScreenAndInsetDecor = layoutInScreen && (fl & 0x10000) != 0;
        boolean bl2 = screenDecor = (pfl & 0x400000) != 0;
        if (layoutInScreenAndInsetDecor && !screenDecor) {
            if ((sysUiVis & 0x200) != 0) {
                outFrame.set(displayFrames.mUnrestricted);
            } else {
                outFrame.set(displayFrames.mRestricted);
            }
            Rect sf = floatingStack ? null : displayFrames.mStable;
            Rect cf = floatingStack ? null : ((sysUiVis & 0x100) != 0 ? ((fl & 0x400) != 0 ? displayFrames.mStableFullscreen : displayFrames.mStable) : ((fl & 0x400) != 0 || (fl & 0x2000000) != 0 ? displayFrames.mOverscan : displayFrames.mCurrent));
            if (taskBounds != null) {
                outFrame.intersect(taskBounds);
            }
            InsetUtils.insetsBetweenFrames(outFrame, cf, outContentInsets);
            InsetUtils.insetsBetweenFrames(outFrame, sf, outStableInsets);
            outDisplayCutout.set(displayFrames.mDisplayCutout.calculateRelativeTo(outFrame).getDisplayCutout());
            return this.mForceShowSystemBars;
        }
        if (layoutInScreen) {
            outFrame.set(displayFrames.mUnrestricted);
        } else {
            outFrame.set(displayFrames.mStable);
        }
        if (taskBounds != null) {
            outFrame.intersect(taskBounds);
        }
        outContentInsets.setEmpty();
        outStableInsets.setEmpty();
        outDisplayCutout.set(DisplayCutout.NO_CUTOUT);
        return this.mForceShowSystemBars;
    }

    private static int getImpliedSysUiFlagsForLayout(WindowManager.LayoutParams attrs) {
        boolean forceWindowDrawsBarBackgrounds;
        int impliedFlags = 0;
        boolean bl = forceWindowDrawsBarBackgrounds = (attrs.privateFlags & 0x20000) != 0 && attrs.height == -1 && attrs.width == -1;
        if ((attrs.flags & Integer.MIN_VALUE) != 0 || forceWindowDrawsBarBackgrounds) {
            impliedFlags |= 0x200;
            impliedFlags |= 0x400;
        }
        return impliedFlags;
    }

    private static boolean shouldUseOutsets(WindowManager.LayoutParams attrs, int fl) {
        return attrs.type == 2013 || (fl & 0x2000400) != 0;
    }

    public void beginLayoutLw(DisplayFrames displayFrames, int uiMode) {
        boolean statusBarForcesShowingNavigation;
        displayFrames.onBeginLayout();
        this.mSystemGestures.screenWidth = displayFrames.mUnrestricted.width();
        this.mSystemGestures.screenHeight = displayFrames.mUnrestricted.height();
        int sysui = this.mLastSystemUiFlags;
        boolean navVisible = (sysui & 2) == 0;
        boolean navTranslucent = (sysui & 0x80008000) != 0;
        boolean immersive = (sysui & 0x800) != 0;
        boolean immersiveSticky = (sysui & 0x1000) != 0;
        boolean navAllowedHidden = immersive || immersiveSticky;
        navTranslucent &= !immersiveSticky;
        boolean isKeyguardShowing = this.isStatusBarKeyguard() && !this.mService.mPolicy.isKeyguardOccluded();
        boolean bl = statusBarForcesShowingNavigation = !isKeyguardShowing && this.mStatusBar != null && (this.mStatusBar.getAttrs().privateFlags & 0x800000) != 0;
        if (navVisible || navAllowedHidden) {
            if (this.mInputConsumer != null) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.mInputConsumer));
                this.mInputConsumer = null;
            }
        } else if (this.mInputConsumer == null && this.mStatusBar != null && this.canHideNavigationBar()) {
            this.mInputConsumer = this.mService.createInputConsumer(this.mHandler.getLooper(), "nav_input_consumer", (x$0, x$1) -> new HideNavInputEventReceiver(x$0, x$1), displayFrames.mDisplayId);
            InputManager.getInstance().setPointerIconType(0);
        }
        boolean updateSysUiVisibility = this.layoutNavigationBar(displayFrames, uiMode, navVisible |= !this.canHideNavigationBar(), navTranslucent, navAllowedHidden, statusBarForcesShowingNavigation);
        if (updateSysUiVisibility |= this.layoutStatusBar(displayFrames, sysui, isKeyguardShowing)) {
            this.updateSystemUiVisibilityLw();
        }
        this.layoutScreenDecorWindows(displayFrames);
        if (displayFrames.mDisplayCutoutSafe.top > displayFrames.mUnrestricted.top) {
            displayFrames.mDisplayCutoutSafe.top = Math.max(displayFrames.mDisplayCutoutSafe.top, displayFrames.mStable.top);
        }
        displayFrames.mCurrent.inset(this.mForwardedInsets);
        displayFrames.mContent.inset(this.mForwardedInsets);
    }

    private void layoutScreenDecorWindows(DisplayFrames displayFrames) {
        if (this.mScreenDecorWindows.isEmpty()) {
            return;
        }
        sTmpRect.setEmpty();
        int displayId = displayFrames.mDisplayId;
        Rect dockFrame = displayFrames.mDock;
        int displayHeight = displayFrames.mDisplayHeight;
        int displayWidth = displayFrames.mDisplayWidth;
        for (int i = this.mScreenDecorWindows.size() - 1; i >= 0; --i) {
            WindowState w = this.mScreenDecorWindows.valueAt(i);
            if (w.getDisplayId() != displayId || !w.isVisibleLw()) continue;
            w.getWindowFrames().setFrames(displayFrames.mUnrestricted, displayFrames.mUnrestricted, displayFrames.mUnrestricted, displayFrames.mUnrestricted, displayFrames.mUnrestricted, sTmpRect, displayFrames.mUnrestricted, displayFrames.mUnrestricted);
            w.getWindowFrames().setDisplayCutout(displayFrames.mDisplayCutout);
            w.computeFrameLw();
            Rect frame = w.getFrameLw();
            if (frame.left <= 0 && frame.top <= 0) {
                if (frame.bottom >= displayHeight) {
                    dockFrame.left = Math.max(frame.right, dockFrame.left);
                    continue;
                }
                if (frame.right >= displayWidth) {
                    dockFrame.top = Math.max(frame.bottom, dockFrame.top);
                    continue;
                }
                Slog.w(TAG, "layoutScreenDecorWindows: Ignoring decor win=" + w + " not docked on left or top of display. frame=" + frame + " displayWidth=" + displayWidth + " displayHeight=" + displayHeight);
                continue;
            }
            if (frame.right >= displayWidth && frame.bottom >= displayHeight) {
                if (frame.top <= 0) {
                    dockFrame.right = Math.min(frame.left, dockFrame.right);
                    continue;
                }
                if (frame.left <= 0) {
                    dockFrame.bottom = Math.min(frame.top, dockFrame.bottom);
                    continue;
                }
                Slog.w(TAG, "layoutScreenDecorWindows: Ignoring decor win=" + w + " not docked on right or bottom of display. frame=" + frame + " displayWidth=" + displayWidth + " displayHeight=" + displayHeight);
                continue;
            }
            Slog.w(TAG, "layoutScreenDecorWindows: Ignoring decor win=" + w + " not docked on one of the sides of the display. frame=" + frame + " displayWidth=" + displayWidth + " displayHeight=" + displayHeight);
        }
        displayFrames.mRestricted.set(dockFrame);
        displayFrames.mCurrent.set(dockFrame);
        displayFrames.mVoiceContent.set(dockFrame);
        displayFrames.mSystem.set(dockFrame);
        displayFrames.mContent.set(dockFrame);
        displayFrames.mRestrictedOverscan.set(dockFrame);
    }

    private boolean layoutStatusBar(DisplayFrames displayFrames, int sysui, boolean isKeyguardShowing) {
        boolean statusBarTranslucent;
        if (this.mStatusBar == null) {
            return false;
        }
        sTmpRect.setEmpty();
        WindowFrames windowFrames = this.mStatusBar.getWindowFrames();
        windowFrames.setFrames(displayFrames.mUnrestricted, displayFrames.mUnrestricted, displayFrames.mStable, displayFrames.mStable, displayFrames.mStable, sTmpRect, displayFrames.mStable, displayFrames.mStable);
        windowFrames.setDisplayCutout(displayFrames.mDisplayCutout);
        this.mStatusBar.computeFrameLw();
        displayFrames.mStable.top = displayFrames.mUnrestricted.top + this.mStatusBarHeightForRotation[displayFrames.mRotation];
        displayFrames.mStable.top = Math.max(displayFrames.mStable.top, displayFrames.mDisplayCutoutSafe.top);
        sTmpRect.set(this.mStatusBar.getContentFrameLw());
        sTmpRect.intersect(displayFrames.mDisplayCutoutSafe);
        DisplayPolicy.sTmpRect.top = this.mStatusBar.getContentFrameLw().top;
        DisplayPolicy.sTmpRect.bottom = displayFrames.mStable.top;
        this.mStatusBarController.setContentFrame(sTmpRect);
        boolean statusBarTransient = (sysui & 0x4000000) != 0;
        boolean bl = statusBarTranslucent = (sysui & 0x40000008) != 0;
        if (this.mStatusBar.isVisibleLw() && !statusBarTransient) {
            Rect dockFrame = displayFrames.mDock;
            dockFrame.top = displayFrames.mStable.top;
            displayFrames.mContent.set(dockFrame);
            displayFrames.mVoiceContent.set(dockFrame);
            displayFrames.mCurrent.set(dockFrame);
            if (!(statusBarTranslucent || this.mStatusBarController.wasRecentlyTranslucent() || this.mStatusBar.isAnimatingLw())) {
                displayFrames.mSystem.top = displayFrames.mStable.top;
            }
        }
        return this.mStatusBarController.checkHiddenLw();
    }

    private boolean layoutNavigationBar(DisplayFrames displayFrames, int uiMode, boolean navVisible, boolean navTranslucent, boolean navAllowedHidden, boolean statusBarForcesShowingNavigation) {
        if (this.mNavigationBar == null) {
            return false;
        }
        Rect navigationFrame = sTmpNavFrame;
        boolean transientNavBarShowing = this.mNavigationBarController.isTransientShowing();
        int rotation = displayFrames.mRotation;
        int displayHeight = displayFrames.mDisplayHeight;
        int displayWidth = displayFrames.mDisplayWidth;
        Rect dockFrame = displayFrames.mDock;
        this.mNavigationBarPosition = this.navigationBarPosition(displayWidth, displayHeight, rotation);
        Rect cutoutSafeUnrestricted = sTmpRect;
        cutoutSafeUnrestricted.set(displayFrames.mUnrestricted);
        cutoutSafeUnrestricted.intersectUnchecked(displayFrames.mDisplayCutoutSafe);
        if (this.mNavigationBarPosition == 4) {
            int top = cutoutSafeUnrestricted.bottom - this.getNavigationBarHeight(rotation, uiMode);
            int topNavBar = cutoutSafeUnrestricted.bottom - this.getNavigationBarFrameHeight(rotation, uiMode);
            navigationFrame.set(0, topNavBar, displayWidth, displayFrames.mUnrestricted.bottom);
            displayFrames.mStable.bottom = displayFrames.mStableFullscreen.bottom = top;
            if (transientNavBarShowing) {
                this.mNavigationBarController.setBarShowingLw(true);
            } else if (navVisible) {
                this.mNavigationBarController.setBarShowingLw(true);
                displayFrames.mRestricted.bottom = displayFrames.mRestrictedOverscan.bottom = top;
                dockFrame.bottom = displayFrames.mRestrictedOverscan.bottom;
            } else {
                this.mNavigationBarController.setBarShowingLw(statusBarForcesShowingNavigation);
            }
            if (!(!navVisible || navTranslucent || navAllowedHidden || this.mNavigationBar.isAnimatingLw() || this.mNavigationBarController.wasRecentlyTranslucent())) {
                displayFrames.mSystem.bottom = top;
            }
        } else if (this.mNavigationBarPosition == 2) {
            int left = cutoutSafeUnrestricted.right - this.getNavigationBarWidth(rotation, uiMode);
            navigationFrame.set(left, 0, displayFrames.mUnrestricted.right, displayHeight);
            displayFrames.mStable.right = displayFrames.mStableFullscreen.right = left;
            if (transientNavBarShowing) {
                this.mNavigationBarController.setBarShowingLw(true);
            } else if (navVisible) {
                this.mNavigationBarController.setBarShowingLw(true);
                displayFrames.mRestricted.right = displayFrames.mRestrictedOverscan.right = left;
                dockFrame.right = displayFrames.mRestrictedOverscan.right;
            } else {
                this.mNavigationBarController.setBarShowingLw(statusBarForcesShowingNavigation);
            }
            if (!(!navVisible || navTranslucent || navAllowedHidden || this.mNavigationBar.isAnimatingLw() || this.mNavigationBarController.wasRecentlyTranslucent())) {
                displayFrames.mSystem.right = left;
            }
        } else if (this.mNavigationBarPosition == 1) {
            int right = cutoutSafeUnrestricted.left + this.getNavigationBarWidth(rotation, uiMode);
            navigationFrame.set(displayFrames.mUnrestricted.left, 0, right, displayHeight);
            displayFrames.mStable.left = displayFrames.mStableFullscreen.left = right;
            if (transientNavBarShowing) {
                this.mNavigationBarController.setBarShowingLw(true);
            } else if (navVisible) {
                this.mNavigationBarController.setBarShowingLw(true);
                displayFrames.mRestricted.left = displayFrames.mRestrictedOverscan.left = right;
                dockFrame.left = displayFrames.mRestrictedOverscan.left;
            } else {
                this.mNavigationBarController.setBarShowingLw(statusBarForcesShowingNavigation);
            }
            if (!(!navVisible || navTranslucent || navAllowedHidden || this.mNavigationBar.isAnimatingLw() || this.mNavigationBarController.wasRecentlyTranslucent())) {
                displayFrames.mSystem.left = right;
            }
        }
        displayFrames.mCurrent.set(dockFrame);
        displayFrames.mVoiceContent.set(dockFrame);
        displayFrames.mContent.set(dockFrame);
        sTmpRect.setEmpty();
        this.mNavigationBar.getWindowFrames().setFrames(navigationFrame, navigationFrame, navigationFrame, displayFrames.mDisplayCutoutSafe, navigationFrame, sTmpRect, navigationFrame, displayFrames.mDisplayCutoutSafe);
        this.mNavigationBar.getWindowFrames().setDisplayCutout(displayFrames.mDisplayCutout);
        this.mNavigationBar.computeFrameLw();
        this.mNavigationBarController.setContentFrame(this.mNavigationBar.getContentFrameLw());
        return this.mNavigationBarController.checkHiddenLw();
    }

    private void setAttachedWindowFrames(WindowState win, int fl, int adjust, WindowState attached, boolean insetDecors, Rect pf, Rect df, Rect of, Rect cf, Rect vf, DisplayFrames displayFrames) {
        if (!win.isInputMethodTarget() && attached.isInputMethodTarget()) {
            vf.set(displayFrames.mDock);
            cf.set(displayFrames.mDock);
            of.set(displayFrames.mDock);
            df.set(displayFrames.mDock);
        } else {
            Rect parentDisplayFrame = attached.getDisplayFrameLw();
            Rect parentOverscan = attached.getOverscanFrameLw();
            WindowManager.LayoutParams attachedAttrs = attached.mAttrs;
            if ((attachedAttrs.privateFlags & 0x20000) != 0 && (attachedAttrs.flags & Integer.MIN_VALUE) == 0 && (attachedAttrs.systemUiVisibility & 0x200) == 0) {
                parentOverscan = new Rect(parentOverscan);
                parentOverscan.intersect(displayFrames.mRestrictedOverscan);
                parentDisplayFrame = new Rect(parentDisplayFrame);
                parentDisplayFrame.intersect(displayFrames.mRestrictedOverscan);
            }
            if (adjust != 16) {
                cf.set((fl & 0x40000000) != 0 ? attached.getContentFrameLw() : parentOverscan);
            } else {
                cf.set(attached.getContentFrameLw());
                if (attached.isVoiceInteraction()) {
                    cf.intersectUnchecked(displayFrames.mVoiceContent);
                } else if (win.isInputMethodTarget() || attached.isInputMethodTarget()) {
                    cf.intersectUnchecked(displayFrames.mContent);
                }
            }
            df.set(insetDecors ? parentDisplayFrame : cf);
            of.set(insetDecors ? parentOverscan : cf);
            vf.set(attached.getVisibleFrameLw());
        }
        pf.set((fl & 0x100) == 0 ? attached.getFrameLw() : df);
    }

    private void applyStableConstraints(int sysui, int fl, Rect r, DisplayFrames displayFrames) {
        if ((sysui & 0x100) == 0) {
            return;
        }
        if ((fl & 0x400) != 0) {
            r.intersectUnchecked(displayFrames.mStableFullscreen);
        } else {
            r.intersectUnchecked(displayFrames.mStable);
        }
    }

    private boolean canReceiveInput(WindowState win) {
        boolean notFocusable = (win.getAttrs().flags & 8) != 0;
        boolean altFocusableIm = (win.getAttrs().flags & 0x20000) != 0;
        boolean notFocusableForIm = notFocusable ^ altFocusableIm;
        return !notFocusableForIm;
    }

    public void layoutWindowLw(WindowState win, WindowState attached, DisplayFrames displayFrames) {
        boolean floatingInScreenWindow;
        if (win == this.mStatusBar && !this.canReceiveInput(win) || win == this.mNavigationBar || this.mScreenDecorWindows.contains(win)) {
            return;
        }
        WindowManager.LayoutParams attrs = win.getAttrs();
        boolean isDefaultDisplay = win.isDefaultDisplay();
        int type = attrs.type;
        int fl = PolicyControl.getWindowFlags(win, attrs);
        int pfl = attrs.privateFlags;
        int sim = attrs.softInputMode;
        int requestedSysUiFl = PolicyControl.getSystemUiVisibility(null, attrs);
        int sysUiFl = requestedSysUiFl | DisplayPolicy.getImpliedSysUiFlagsForLayout(attrs);
        WindowFrames windowFrames = win.getWindowFrames();
        windowFrames.setHasOutsets(false);
        sTmpLastParentFrame.set(windowFrames.mParentFrame);
        Rect pf = windowFrames.mParentFrame;
        Rect df = windowFrames.mDisplayFrame;
        Rect of = windowFrames.mOverscanFrame;
        Rect cf = windowFrames.mContentFrame;
        Rect vf = windowFrames.mVisibleFrame;
        Rect dcf = windowFrames.mDecorFrame;
        Rect sf = windowFrames.mStableFrame;
        dcf.setEmpty();
        windowFrames.setParentFrameWasClippedByDisplayCutout(false);
        windowFrames.setDisplayCutout(displayFrames.mDisplayCutout);
        boolean hasNavBar = this.hasNavigationBar() && this.mNavigationBar != null && this.mNavigationBar.isVisibleLw();
        int adjust = sim & 0xF0;
        boolean requestedFullscreen = (fl & 0x400) != 0 || (requestedSysUiFl & 4) != 0;
        boolean layoutInScreen = (fl & 0x100) == 256;
        boolean layoutInsetDecor = (fl & 0x10000) == 65536;
        sf.set(displayFrames.mStable);
        if (type == 2011) {
            int uimode;
            int rotation;
            int navHeightOffset;
            vf.set(displayFrames.mDock);
            cf.set(displayFrames.mDock);
            of.set(displayFrames.mDock);
            df.set(displayFrames.mDock);
            windowFrames.mParentFrame.set(displayFrames.mDock);
            df.bottom = of.bottom = displayFrames.mUnrestricted.bottom;
            pf.bottom = of.bottom;
            cf.bottom = vf.bottom = displayFrames.mStable.bottom;
            if (this.mStatusBar != null && this.mFocusedWindow == this.mStatusBar && this.canReceiveInput(this.mStatusBar)) {
                if (this.mNavigationBarPosition == 2) {
                    cf.right = vf.right = displayFrames.mStable.right;
                    of.right = vf.right;
                    df.right = vf.right;
                    pf.right = vf.right;
                } else if (this.mNavigationBarPosition == 1) {
                    cf.left = vf.left = displayFrames.mStable.left;
                    of.left = vf.left;
                    df.left = vf.left;
                    pf.left = vf.left;
                }
            }
            if (this.mNavigationBarPosition == 4 && (navHeightOffset = this.getNavigationBarFrameHeight(rotation = displayFrames.mRotation, uimode = this.mService.mPolicy.getUiMode()) - this.getNavigationBarHeight(rotation, uimode)) > 0) {
                cf.bottom -= navHeightOffset;
                sf.bottom -= navHeightOffset;
                vf.bottom -= navHeightOffset;
                dcf.bottom -= navHeightOffset;
            }
            attrs.gravity = 80;
        } else if (type == 2031) {
            of.set(displayFrames.mUnrestricted);
            df.set(displayFrames.mUnrestricted);
            pf.set(displayFrames.mUnrestricted);
            if (adjust != 16) {
                cf.set(displayFrames.mDock);
            } else {
                cf.set(displayFrames.mContent);
            }
            if (adjust != 48) {
                vf.set(displayFrames.mCurrent);
            } else {
                vf.set(cf);
            }
        } else if (type == 2013) {
            this.layoutWallpaper(displayFrames, pf, df, of, cf);
        } else if (win == this.mStatusBar) {
            of.set(displayFrames.mUnrestricted);
            df.set(displayFrames.mUnrestricted);
            pf.set(displayFrames.mUnrestricted);
            cf.set(displayFrames.mStable);
            vf.set(displayFrames.mStable);
            if (adjust == 16) {
                cf.bottom = displayFrames.mContent.bottom;
            } else {
                cf.bottom = displayFrames.mDock.bottom;
                vf.bottom = displayFrames.mContent.bottom;
            }
        } else {
            boolean topAtRest;
            dcf.set(displayFrames.mSystem);
            boolean inheritTranslucentDecor = (attrs.privateFlags & 0x200) != 0;
            boolean isAppWindow = type >= 1 && type <= 99;
            boolean bl = topAtRest = win == this.mTopFullscreenOpaqueWindowState && !win.isAnimatingLw();
            if (isAppWindow && !inheritTranslucentDecor && !topAtRest) {
                if ((sysUiFl & 4) == 0 && (fl & 0x400) == 0 && (fl & 0x4000000) == 0 && (fl & Integer.MIN_VALUE) == 0 && (pfl & 0x20000) == 0) {
                    dcf.top = displayFrames.mStable.top;
                }
                if ((fl & 0x8000000) == 0 && (sysUiFl & 2) == 0 && (fl & Integer.MIN_VALUE) == 0 && (pfl & 0x20000) == 0) {
                    dcf.bottom = displayFrames.mStable.bottom;
                    dcf.right = displayFrames.mStable.right;
                }
            }
            if (layoutInScreen && layoutInsetDecor) {
                if (attached != null) {
                    this.setAttachedWindowFrames(win, fl, adjust, attached, true, pf, df, of, cf, vf, displayFrames);
                } else {
                    if (type == 2014 || type == 2017) {
                        of.left = hasNavBar ? displayFrames.mDock.left : displayFrames.mUnrestricted.left;
                        df.left = of.left;
                        pf.left = of.left;
                        df.top = of.top = displayFrames.mUnrestricted.top;
                        pf.top = of.top;
                        of.right = hasNavBar ? displayFrames.mRestricted.right : displayFrames.mUnrestricted.right;
                        df.right = of.right;
                        pf.right = of.right;
                        of.bottom = hasNavBar ? displayFrames.mRestricted.bottom : displayFrames.mUnrestricted.bottom;
                        df.bottom = of.bottom;
                        pf.bottom = of.bottom;
                    } else if ((fl & 0x2000000) != 0 && type >= 1 && type <= 1999) {
                        of.set(displayFrames.mOverscan);
                        df.set(displayFrames.mOverscan);
                        pf.set(displayFrames.mOverscan);
                    } else if ((sysUiFl & 0x200) != 0 && (type >= 1 && type <= 1999 || type == 2020 || type == 2009)) {
                        df.set(displayFrames.mOverscan);
                        pf.set(displayFrames.mOverscan);
                        of.set(displayFrames.mUnrestricted);
                    } else {
                        df.set(displayFrames.mRestrictedOverscan);
                        pf.set(displayFrames.mRestrictedOverscan);
                        of.set(displayFrames.mUnrestricted);
                    }
                    if ((fl & 0x400) == 0) {
                        if (win.isVoiceInteraction()) {
                            cf.set(displayFrames.mVoiceContent);
                        } else if (ViewRootImpl.sNewInsetsMode != 0 || adjust != 16) {
                            cf.set(displayFrames.mDock);
                        } else {
                            cf.set(displayFrames.mContent);
                        }
                    } else {
                        cf.set(displayFrames.mRestricted);
                    }
                    this.applyStableConstraints(sysUiFl, fl, cf, displayFrames);
                    if (adjust != 48) {
                        vf.set(displayFrames.mCurrent);
                    } else {
                        vf.set(cf);
                    }
                }
            } else if (layoutInScreen || (sysUiFl & 0x600) != 0) {
                if (type == 2014 || type == 2017) {
                    cf.set(displayFrames.mUnrestricted);
                    of.set(displayFrames.mUnrestricted);
                    df.set(displayFrames.mUnrestricted);
                    pf.set(displayFrames.mUnrestricted);
                    if (hasNavBar) {
                        of.left = cf.left = displayFrames.mDock.left;
                        df.left = cf.left;
                        pf.left = cf.left;
                        of.right = cf.right = displayFrames.mRestricted.right;
                        df.right = cf.right;
                        pf.right = cf.right;
                        of.bottom = cf.bottom = displayFrames.mRestricted.bottom;
                        df.bottom = cf.bottom;
                        pf.bottom = cf.bottom;
                    }
                } else if (type == 2019 || type == 2024) {
                    of.set(displayFrames.mUnrestricted);
                    df.set(displayFrames.mUnrestricted);
                    pf.set(displayFrames.mUnrestricted);
                } else if ((type == 2015 || type == 2036) && (fl & 0x400) != 0) {
                    cf.set(displayFrames.mOverscan);
                    of.set(displayFrames.mOverscan);
                    df.set(displayFrames.mOverscan);
                    pf.set(displayFrames.mOverscan);
                } else if (type == 2021) {
                    cf.set(displayFrames.mOverscan);
                    of.set(displayFrames.mOverscan);
                    df.set(displayFrames.mOverscan);
                    pf.set(displayFrames.mOverscan);
                } else if ((fl & 0x2000000) != 0 && type >= 1 && type <= 1999) {
                    cf.set(displayFrames.mOverscan);
                    of.set(displayFrames.mOverscan);
                    df.set(displayFrames.mOverscan);
                    pf.set(displayFrames.mOverscan);
                } else if ((sysUiFl & 0x200) != 0 && (type == 2000 || type == 2005 || type == 2034 || type == 2033 || type >= 1 && type <= 1999)) {
                    cf.set(displayFrames.mUnrestricted);
                    of.set(displayFrames.mUnrestricted);
                    df.set(displayFrames.mUnrestricted);
                    pf.set(displayFrames.mUnrestricted);
                } else if ((sysUiFl & 0x400) != 0) {
                    of.set(displayFrames.mRestricted);
                    df.set(displayFrames.mRestricted);
                    pf.set(displayFrames.mRestricted);
                    if (ViewRootImpl.sNewInsetsMode != 0 || adjust != 16) {
                        cf.set(displayFrames.mDock);
                    } else {
                        cf.set(displayFrames.mContent);
                    }
                } else {
                    cf.set(displayFrames.mRestricted);
                    of.set(displayFrames.mRestricted);
                    df.set(displayFrames.mRestricted);
                    pf.set(displayFrames.mRestricted);
                }
                this.applyStableConstraints(sysUiFl, fl, cf, displayFrames);
                if (adjust != 48) {
                    vf.set(displayFrames.mCurrent);
                } else {
                    vf.set(cf);
                }
            } else if (attached != null) {
                this.setAttachedWindowFrames(win, fl, adjust, attached, false, pf, df, of, cf, vf, displayFrames);
            } else if (type == 2014) {
                cf.set(displayFrames.mRestricted);
                of.set(displayFrames.mRestricted);
                df.set(displayFrames.mRestricted);
                pf.set(displayFrames.mRestricted);
            } else if (type == 2005 || type == 2003) {
                cf.set(displayFrames.mStable);
                of.set(displayFrames.mStable);
                df.set(displayFrames.mStable);
                pf.set(displayFrames.mStable);
            } else {
                pf.set(displayFrames.mContent);
                if (win.isVoiceInteraction()) {
                    cf.set(displayFrames.mVoiceContent);
                    of.set(displayFrames.mVoiceContent);
                    df.set(displayFrames.mVoiceContent);
                } else if (adjust != 16) {
                    cf.set(displayFrames.mDock);
                    of.set(displayFrames.mDock);
                    df.set(displayFrames.mDock);
                } else {
                    cf.set(displayFrames.mContent);
                    of.set(displayFrames.mContent);
                    df.set(displayFrames.mContent);
                }
                if (adjust != 48) {
                    vf.set(displayFrames.mCurrent);
                } else {
                    vf.set(cf);
                }
            }
        }
        int cutoutMode = attrs.layoutInDisplayCutoutMode;
        boolean attachedInParent = attached != null && !layoutInScreen;
        boolean requestedHideNavigation = (requestedSysUiFl & 2) != 0;
        boolean bl = floatingInScreenWindow = !attrs.isFullscreen() && layoutInScreen && type != 1;
        if (cutoutMode != 1) {
            Rect displayCutoutSafeExceptMaybeBars = sTmpDisplayCutoutSafeExceptMaybeBarsRect;
            displayCutoutSafeExceptMaybeBars.set(displayFrames.mDisplayCutoutSafe);
            if (layoutInScreen && layoutInsetDecor && !requestedFullscreen && cutoutMode == 0) {
                displayCutoutSafeExceptMaybeBars.top = Integer.MIN_VALUE;
            }
            if (layoutInScreen && layoutInsetDecor && !requestedHideNavigation && cutoutMode == 0) {
                switch (this.mNavigationBarPosition) {
                    case 4: {
                        displayCutoutSafeExceptMaybeBars.bottom = Integer.MAX_VALUE;
                        break;
                    }
                    case 2: {
                        displayCutoutSafeExceptMaybeBars.right = Integer.MAX_VALUE;
                        break;
                    }
                    case 1: {
                        displayCutoutSafeExceptMaybeBars.left = Integer.MIN_VALUE;
                    }
                }
            }
            if (type == 2011 && this.mNavigationBarPosition == 4) {
                displayCutoutSafeExceptMaybeBars.bottom = Integer.MAX_VALUE;
            }
            if (!attachedInParent && !floatingInScreenWindow) {
                sTmpRect.set(pf);
                pf.intersectUnchecked(displayCutoutSafeExceptMaybeBars);
                windowFrames.setParentFrameWasClippedByDisplayCutout(!sTmpRect.equals(pf));
            }
            df.intersectUnchecked(displayCutoutSafeExceptMaybeBars);
        }
        cf.intersectUnchecked(displayFrames.mDisplayCutoutSafe);
        if ((fl & 0x200) != 0 && type != 2010 && !win.inMultiWindowMode()) {
            df.top = -10000;
            df.left = -10000;
            df.bottom = 10000;
            df.right = 10000;
            if (type != 2013) {
                vf.top = -10000;
                vf.left = -10000;
                cf.top = -10000;
                cf.left = -10000;
                of.top = -10000;
                of.left = -10000;
                vf.bottom = 10000;
                vf.right = 10000;
                cf.bottom = 10000;
                cf.right = 10000;
                of.bottom = 10000;
                of.right = 10000;
            }
        }
        boolean useOutsets = DisplayPolicy.shouldUseOutsets(attrs, fl);
        if (isDefaultDisplay && useOutsets) {
            Rect osf = windowFrames.mOutsetFrame;
            osf.set(cf.left, cf.top, cf.right, cf.bottom);
            windowFrames.setHasOutsets(true);
            int outset = this.mWindowOutsetBottom;
            if (outset > 0) {
                int rotation = displayFrames.mRotation;
                if (rotation == 0) {
                    osf.bottom += outset;
                } else if (rotation == 1) {
                    osf.right += outset;
                } else if (rotation == 2) {
                    osf.top -= outset;
                } else if (rotation == 3) {
                    osf.left -= outset;
                }
            }
        }
        if (!sTmpLastParentFrame.equals(pf)) {
            windowFrames.setContentChanged(true);
        }
        win.computeFrameLw();
        if (type == 2011 && win.isVisibleLw() && !win.getGivenInsetsPendingLw()) {
            this.offsetInputMethodWindowLw(win, displayFrames);
        }
        if (type == 2031 && win.isVisibleLw() && !win.getGivenInsetsPendingLw()) {
            this.offsetVoiceInputWindowLw(win, displayFrames);
        }
    }

    private void layoutWallpaper(DisplayFrames displayFrames, Rect pf, Rect df, Rect of, Rect cf) {
        df.set(displayFrames.mOverscan);
        pf.set(displayFrames.mOverscan);
        cf.set(displayFrames.mUnrestricted);
        of.set(displayFrames.mUnrestricted);
    }

    private void offsetInputMethodWindowLw(WindowState win, DisplayFrames displayFrames) {
        int top = Math.max(win.getDisplayFrameLw().top, win.getContentFrameLw().top);
        displayFrames.mContent.bottom = Math.min(displayFrames.mContent.bottom, top += win.getGivenContentInsetsLw().top);
        displayFrames.mVoiceContent.bottom = Math.min(displayFrames.mVoiceContent.bottom, top);
        top = win.getVisibleFrameLw().top;
        displayFrames.mCurrent.bottom = Math.min(displayFrames.mCurrent.bottom, top += win.getGivenVisibleInsetsLw().top);
    }

    private void offsetVoiceInputWindowLw(WindowState win, DisplayFrames displayFrames) {
        int top = Math.max(win.getDisplayFrameLw().top, win.getContentFrameLw().top);
        displayFrames.mVoiceContent.bottom = Math.min(displayFrames.mVoiceContent.bottom, top += win.getGivenContentInsetsLw().top);
    }

    public void beginPostLayoutPolicyLw() {
        this.mTopFullscreenOpaqueWindowState = null;
        this.mTopFullscreenOpaqueOrDimmingWindowState = null;
        this.mTopDockedOpaqueWindowState = null;
        this.mTopDockedOpaqueOrDimmingWindowState = null;
        this.mForceStatusBar = false;
        this.mForceStatusBarFromKeyguard = false;
        this.mForceStatusBarTransparent = false;
        this.mForcingShowNavBar = false;
        this.mForcingShowNavBarLayer = -1;
        this.mAllowLockscreenWhenOn = false;
        this.mShowingDream = false;
        this.mWindowSleepTokenNeeded = false;
    }

    public void applyPostLayoutPolicyLw(WindowState win, WindowManager.LayoutParams attrs, WindowState attached, WindowState imeTarget) {
        boolean inFullScreenOrSplitScreenSecondaryWindowingMode;
        boolean affectsSystemUi = win.canAffectSystemUiFlags();
        this.mService.mPolicy.applyKeyguardPolicyLw(win, imeTarget);
        int fl = PolicyControl.getWindowFlags(win, attrs);
        if (this.mTopFullscreenOpaqueWindowState == null && affectsSystemUi && attrs.type == 2011) {
            this.mForcingShowNavBar = true;
            this.mForcingShowNavBarLayer = win.getSurfaceLayer();
        }
        if (attrs.type == 2000) {
            if ((attrs.privateFlags & 0x400) != 0) {
                this.mForceStatusBarFromKeyguard = true;
            }
            if ((attrs.privateFlags & 0x1000) != 0) {
                this.mForceStatusBarTransparent = true;
            }
        }
        boolean appWindow = attrs.type >= 1 && attrs.type < 2000;
        int windowingMode = win.getWindowingMode();
        boolean bl = inFullScreenOrSplitScreenSecondaryWindowingMode = windowingMode == 1 || windowingMode == 4;
        if (this.mTopFullscreenOpaqueWindowState == null && affectsSystemUi) {
            if ((fl & 0x800) != 0) {
                this.mForceStatusBar = true;
            }
            if (attrs.type == 2023 && (!this.mDreamingLockscreen || win.isVisibleLw() && win.hasDrawnLw())) {
                this.mShowingDream = true;
                appWindow = true;
            }
            if (appWindow && attached == null && attrs.isFullscreen() && inFullScreenOrSplitScreenSecondaryWindowingMode) {
                this.mTopFullscreenOpaqueWindowState = win;
                if (this.mTopFullscreenOpaqueOrDimmingWindowState == null) {
                    this.mTopFullscreenOpaqueOrDimmingWindowState = win;
                }
                if ((fl & 1) != 0) {
                    this.mAllowLockscreenWhenOn = true;
                }
            }
        }
        if (affectsSystemUi && attrs.type == 2031) {
            if (this.mTopFullscreenOpaqueWindowState == null) {
                this.mTopFullscreenOpaqueWindowState = win;
                if (this.mTopFullscreenOpaqueOrDimmingWindowState == null) {
                    this.mTopFullscreenOpaqueOrDimmingWindowState = win;
                }
            }
            if (this.mTopDockedOpaqueWindowState == null) {
                this.mTopDockedOpaqueWindowState = win;
                if (this.mTopDockedOpaqueOrDimmingWindowState == null) {
                    this.mTopDockedOpaqueOrDimmingWindowState = win;
                }
            }
        }
        if (this.mTopFullscreenOpaqueOrDimmingWindowState == null && affectsSystemUi && win.isDimming() && inFullScreenOrSplitScreenSecondaryWindowingMode) {
            this.mTopFullscreenOpaqueOrDimmingWindowState = win;
        }
        if (this.mTopDockedOpaqueWindowState == null && affectsSystemUi && appWindow && attached == null && attrs.isFullscreen() && windowingMode == 3) {
            this.mTopDockedOpaqueWindowState = win;
            if (this.mTopDockedOpaqueOrDimmingWindowState == null) {
                this.mTopDockedOpaqueOrDimmingWindowState = win;
            }
        }
        if (this.mTopDockedOpaqueOrDimmingWindowState == null && affectsSystemUi && win.isDimming() && windowingMode == 3) {
            this.mTopDockedOpaqueOrDimmingWindowState = win;
        }
    }

    public int finishPostLayoutPolicyLw() {
        int changes = 0;
        boolean topIsFullscreen = false;
        if (!this.mShowingDream) {
            this.mDreamingLockscreen = this.mService.mPolicy.isKeyguardShowingAndNotOccluded();
            if (this.mDreamingSleepTokenNeeded) {
                this.mDreamingSleepTokenNeeded = false;
                this.mHandler.obtainMessage(1, 0, 1).sendToTarget();
            }
        } else if (!this.mDreamingSleepTokenNeeded) {
            this.mDreamingSleepTokenNeeded = true;
            this.mHandler.obtainMessage(1, 1, 1).sendToTarget();
        }
        if (this.mStatusBar != null) {
            boolean shouldBeTransparent;
            boolean bl = shouldBeTransparent = this.mForceStatusBarTransparent && !this.mForceStatusBar && !this.mForceStatusBarFromKeyguard;
            if (!shouldBeTransparent) {
                this.mStatusBarController.setShowTransparent(false);
            } else if (!this.mStatusBar.isVisibleLw()) {
                this.mStatusBarController.setShowTransparent(true);
            }
            boolean statusBarForcesShowingNavigation = (this.mStatusBar.getAttrs().privateFlags & 0x800000) != 0;
            boolean topAppHidesStatusBar = this.topAppHidesStatusBar();
            if (this.mForceStatusBar || this.mForceStatusBarFromKeyguard || this.mForceStatusBarTransparent || statusBarForcesShowingNavigation) {
                if (this.mStatusBarController.setBarShowingLw(true)) {
                    changes |= 1;
                }
                boolean bl2 = topIsFullscreen = this.mTopIsFullscreen && this.mStatusBar.isAnimatingLw();
                if ((this.mForceStatusBarFromKeyguard || statusBarForcesShowingNavigation) && this.mStatusBarController.isTransientShowing()) {
                    this.mStatusBarController.updateVisibilityLw(false, this.mLastSystemUiFlags, this.mLastSystemUiFlags);
                }
            } else if (this.mTopFullscreenOpaqueWindowState != null) {
                topIsFullscreen = topAppHidesStatusBar;
                if (this.mStatusBarController.isTransientShowing()) {
                    if (this.mStatusBarController.setBarShowingLw(true)) {
                        changes |= 1;
                    }
                } else if (topIsFullscreen && !this.mDisplayContent.isStackVisible(5) && !this.mDisplayContent.isStackVisible(3)) {
                    if (this.mStatusBarController.setBarShowingLw(false)) {
                        changes |= 1;
                    }
                } else {
                    if (this.mStatusBarController.setBarShowingLw(true)) {
                        changes |= 1;
                    }
                    topAppHidesStatusBar = false;
                }
            }
            this.mStatusBarController.setTopAppHidesStatusBar(topAppHidesStatusBar);
        }
        if (this.mTopIsFullscreen != topIsFullscreen) {
            if (!topIsFullscreen) {
                changes |= 1;
            }
            this.mTopIsFullscreen = topIsFullscreen;
        }
        if ((this.updateSystemUiVisibilityLw() & 0xC000800E) != 0) {
            changes |= 1;
        }
        if (this.mShowingDream != this.mLastShowingDream) {
            this.mLastShowingDream = this.mShowingDream;
            this.mService.notifyShowingDreamChanged();
        }
        this.updateWindowSleepToken();
        this.mService.mPolicy.setAllowLockscreenWhenOn(this.getDisplayId(), this.mAllowLockscreenWhenOn);
        return changes;
    }

    private void updateWindowSleepToken() {
        if (this.mWindowSleepTokenNeeded && !this.mLastWindowSleepTokenNeeded) {
            this.mHandler.removeCallbacks(this.mReleaseSleepTokenRunnable);
            this.mHandler.post(this.mAcquireSleepTokenRunnable);
        } else if (!this.mWindowSleepTokenNeeded && this.mLastWindowSleepTokenNeeded) {
            this.mHandler.removeCallbacks(this.mAcquireSleepTokenRunnable);
            this.mHandler.post(this.mReleaseSleepTokenRunnable);
        }
        this.mLastWindowSleepTokenNeeded = this.mWindowSleepTokenNeeded;
    }

    private boolean topAppHidesStatusBar() {
        if (this.mTopFullscreenOpaqueWindowState == null) {
            return false;
        }
        int fl = PolicyControl.getWindowFlags(null, this.mTopFullscreenOpaqueWindowState.getAttrs());
        return (fl & 0x400) != 0 || (this.mLastSystemUiFlags & 4) != 0;
    }

    public void switchUser() {
        this.updateCurrentUserResources();
    }

    public void onOverlayChangedLw() {
        this.updateCurrentUserResources();
        this.onConfigurationChanged();
        this.mSystemGestures.onConfigurationChanged();
    }

    public void onConfigurationChanged() {
        DisplayRotation displayRotation = this.mDisplayContent.getDisplayRotation();
        Resources res = this.getCurrentUserResources();
        int portraitRotation = displayRotation.getPortraitRotation();
        int upsideDownRotation = displayRotation.getUpsideDownRotation();
        int landscapeRotation = displayRotation.getLandscapeRotation();
        int seascapeRotation = displayRotation.getSeascapeRotation();
        int uiMode = this.mService.mPolicy.getUiMode();
        if (this.hasStatusBar()) {
            this.mStatusBarHeightForRotation[portraitRotation] = this.mStatusBarHeightForRotation[upsideDownRotation] = res.getDimensionPixelSize(17105424);
            this.mStatusBarHeightForRotation[landscapeRotation] = this.mStatusBarHeightForRotation[seascapeRotation] = res.getDimensionPixelSize(17105423);
        } else {
            this.mStatusBarHeightForRotation[seascapeRotation] = 0;
            this.mStatusBarHeightForRotation[landscapeRotation] = 0;
            this.mStatusBarHeightForRotation[upsideDownRotation] = 0;
            this.mStatusBarHeightForRotation[portraitRotation] = 0;
        }
        this.mNavigationBarHeightForRotationDefault[portraitRotation] = this.mNavigationBarHeightForRotationDefault[upsideDownRotation] = res.getDimensionPixelSize(17105288);
        this.mNavigationBarHeightForRotationDefault[landscapeRotation] = this.mNavigationBarHeightForRotationDefault[seascapeRotation] = res.getDimensionPixelSize(17105290);
        this.mNavigationBarFrameHeightForRotationDefault[portraitRotation] = this.mNavigationBarFrameHeightForRotationDefault[upsideDownRotation] = res.getDimensionPixelSize(17105285);
        this.mNavigationBarFrameHeightForRotationDefault[landscapeRotation] = this.mNavigationBarFrameHeightForRotationDefault[seascapeRotation] = res.getDimensionPixelSize(17105286);
        this.mNavigationBarWidthForRotationDefault[landscapeRotation] = this.mNavigationBarWidthForRotationDefault[seascapeRotation] = res.getDimensionPixelSize(17105293);
        this.mNavigationBarWidthForRotationDefault[upsideDownRotation] = this.mNavigationBarWidthForRotationDefault[seascapeRotation];
        this.mNavigationBarWidthForRotationDefault[portraitRotation] = this.mNavigationBarWidthForRotationDefault[seascapeRotation];
        this.mNavBarOpacityMode = res.getInteger(17694848);
        this.mSideGestureInset = res.getDimensionPixelSize(17105049);
        this.mNavigationBarLetsThroughTaps = res.getBoolean(17891484);
        this.mNavigationBarAlwaysShowOnSideGesture = res.getBoolean(0x1110099);
        this.mBottomGestureAdditionalInset = res.getDimensionPixelSize(17105287) - this.getNavigationBarFrameHeight(portraitRotation, uiMode);
        this.updateConfigurationAndScreenSizeDependentBehaviors();
        this.mWindowOutsetBottom = ScreenShapeHelper.getWindowOutsetBottomPx(this.mContext.getResources());
    }

    void updateConfigurationAndScreenSizeDependentBehaviors() {
        Resources res = this.getCurrentUserResources();
        this.mNavigationBarCanMove = this.mDisplayContent.mBaseDisplayWidth != this.mDisplayContent.mBaseDisplayHeight && res.getBoolean(17891482);
        this.mAllowSeamlessRotationDespiteNavBarMoving = res.getBoolean(0x1110012);
    }

    private void updateCurrentUserResources() {
        int userId = this.mService.mAmInternal.getCurrentUserId();
        Context uiContext = this.getSystemUiContext();
        if (userId == 0) {
            this.mCurrentUserResources = uiContext.getResources();
            return;
        }
        LoadedApk pi = ActivityThread.currentActivityThread().getPackageInfo(uiContext.getPackageName(), null, 0, userId);
        this.mCurrentUserResources = ResourcesManager.getInstance().getResources(null, pi.getResDir(), null, pi.getOverlayDirs(), pi.getApplicationInfo().sharedLibraryFiles, this.mDisplayContent.getDisplayId(), null, uiContext.getResources().getCompatibilityInfo(), null);
    }

    @VisibleForTesting
    Resources getCurrentUserResources() {
        if (this.mCurrentUserResources == null) {
            this.updateCurrentUserResources();
        }
        return this.mCurrentUserResources;
    }

    @VisibleForTesting
    Context getContext() {
        return this.mContext;
    }

    private Context getSystemUiContext() {
        ContextImpl uiContext = ActivityThread.currentActivityThread().getSystemUiContext();
        return this.mDisplayContent.isDefaultDisplay ? uiContext : ((Context)uiContext).createDisplayContext(this.mDisplayContent.getDisplay());
    }

    private int getNavigationBarWidth(int rotation, int uiMode) {
        return this.mNavigationBarWidthForRotationDefault[rotation];
    }

    void notifyDisplayReady() {
        this.mHandler.post(() -> {
            int displayId = this.getDisplayId();
            this.getStatusBarManagerInternal().onDisplayReady(displayId);
            LocalServices.getService(WallpaperManagerInternal.class).onDisplayReady(displayId);
        });
    }

    public int getNonDecorDisplayWidth(int fullWidth, int fullHeight, int rotation, int uiMode, DisplayCutout displayCutout) {
        int navBarPosition;
        int width = fullWidth;
        if (this.hasNavigationBar() && ((navBarPosition = this.navigationBarPosition(fullWidth, fullHeight, rotation)) == 1 || navBarPosition == 2)) {
            width -= this.getNavigationBarWidth(rotation, uiMode);
        }
        if (displayCutout != null) {
            width -= displayCutout.getSafeInsetLeft() + displayCutout.getSafeInsetRight();
        }
        return width;
    }

    private int getNavigationBarHeight(int rotation, int uiMode) {
        return this.mNavigationBarHeightForRotationDefault[rotation];
    }

    private int getNavigationBarFrameHeight(int rotation, int uiMode) {
        return this.mNavigationBarFrameHeightForRotationDefault[rotation];
    }

    public int getNonDecorDisplayHeight(int fullWidth, int fullHeight, int rotation, int uiMode, DisplayCutout displayCutout) {
        int navBarPosition;
        int height = fullHeight;
        if (this.hasNavigationBar() && (navBarPosition = this.navigationBarPosition(fullWidth, fullHeight, rotation)) == 4) {
            height -= this.getNavigationBarHeight(rotation, uiMode);
        }
        if (displayCutout != null) {
            height -= displayCutout.getSafeInsetTop() + displayCutout.getSafeInsetBottom();
        }
        return height;
    }

    public int getConfigDisplayWidth(int fullWidth, int fullHeight, int rotation, int uiMode, DisplayCutout displayCutout) {
        return this.getNonDecorDisplayWidth(fullWidth, fullHeight, rotation, uiMode, displayCutout);
    }

    public int getConfigDisplayHeight(int fullWidth, int fullHeight, int rotation, int uiMode, DisplayCutout displayCutout) {
        int statusBarHeight = this.mStatusBarHeightForRotation[rotation];
        if (displayCutout != null) {
            statusBarHeight = Math.max(0, statusBarHeight - displayCutout.getSafeInsetTop());
        }
        return this.getNonDecorDisplayHeight(fullWidth, fullHeight, rotation, uiMode, displayCutout) - statusBarHeight;
    }

    float getWindowCornerRadius() {
        return this.mDisplayContent.getDisplay().getType() == 1 ? ScreenDecorationsUtils.getWindowCornerRadius(this.mContext.getResources()) : 0.0f;
    }

    boolean isShowingDreamLw() {
        return this.mShowingDream;
    }

    void convertNonDecorInsetsToStableInsets(Rect inOutInsets, int rotation) {
        inOutInsets.top = Math.max(inOutInsets.top, this.mStatusBarHeightForRotation[rotation]);
    }

    public void getStableInsetsLw(int displayRotation, int displayWidth, int displayHeight, DisplayCutout displayCutout, Rect outInsets) {
        outInsets.setEmpty();
        this.getNonDecorInsetsLw(displayRotation, displayWidth, displayHeight, displayCutout, outInsets);
        this.convertNonDecorInsetsToStableInsets(outInsets, displayRotation);
    }

    public void getNonDecorInsetsLw(int displayRotation, int displayWidth, int displayHeight, DisplayCutout displayCutout, Rect outInsets) {
        outInsets.setEmpty();
        if (this.hasNavigationBar()) {
            int uiMode = this.mService.mPolicy.getUiMode();
            int position = this.navigationBarPosition(displayWidth, displayHeight, displayRotation);
            if (position == 4) {
                outInsets.bottom = this.getNavigationBarHeight(displayRotation, uiMode);
            } else if (position == 2) {
                outInsets.right = this.getNavigationBarWidth(displayRotation, uiMode);
            } else if (position == 1) {
                outInsets.left = this.getNavigationBarWidth(displayRotation, uiMode);
            }
        }
        if (displayCutout != null) {
            outInsets.left += displayCutout.getSafeInsetLeft();
            outInsets.top += displayCutout.getSafeInsetTop();
            outInsets.right += displayCutout.getSafeInsetRight();
            outInsets.bottom += displayCutout.getSafeInsetBottom();
        }
    }

    public void setForwardedInsets(Insets forwardedInsets) {
        this.mForwardedInsets = forwardedInsets;
    }

    public Insets getForwardedInsets() {
        return this.mForwardedInsets;
    }

    int navigationBarPosition(int displayWidth, int displayHeight, int displayRotation) {
        if (this.navigationBarCanMove() && displayWidth > displayHeight) {
            if (displayRotation == 3) {
                return 1;
            }
            if (displayRotation == 1) {
                return 2;
            }
        }
        return 4;
    }

    public int getNavBarPosition() {
        return this.mNavigationBarPosition;
    }

    public int focusChangedLw(WindowState lastFocus, WindowState newFocus) {
        this.mFocusedWindow = newFocus;
        this.mLastFocusedWindow = lastFocus;
        if (this.mDisplayContent.isDefaultDisplay) {
            this.mService.mPolicy.onDefaultDisplayFocusChangedLw(newFocus);
        }
        if ((this.updateSystemUiVisibilityLw() & 0xC000800E) != 0) {
            return 1;
        }
        return 0;
    }

    public boolean allowAppAnimationsLw() {
        return !this.mShowingDream;
    }

    private void updateDreamingSleepToken(boolean acquire) {
        if (acquire) {
            int displayId = this.getDisplayId();
            if (this.mDreamingSleepToken == null) {
                this.mDreamingSleepToken = this.mService.mAtmInternal.acquireSleepToken("DreamOnDisplay" + displayId, displayId);
            }
        } else if (this.mDreamingSleepToken != null) {
            this.mDreamingSleepToken.release();
            this.mDreamingSleepToken = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestTransientBars(WindowState swipeTarget) {
        Object object = this.mLock;
        synchronized (object) {
            boolean nb;
            if (!this.mService.mPolicy.isUserSetupComplete()) {
                return;
            }
            boolean sb = this.mStatusBarController.checkShowTransientBarLw();
            boolean bl = nb = this.mNavigationBarController.checkShowTransientBarLw() && !DisplayPolicy.isNavBarEmpty(this.mLastSystemUiFlags);
            if (sb || nb) {
                if (!nb && swipeTarget == this.mNavigationBar) {
                    return;
                }
                if (sb) {
                    this.mStatusBarController.showTransient();
                }
                if (nb) {
                    this.mNavigationBarController.showTransient();
                }
                this.mImmersiveModeConfirmation.confirmCurrentPrompt();
                this.updateSystemUiVisibilityLw();
            }
        }
    }

    private void disposeInputConsumer(WindowManagerPolicy.InputConsumer inputConsumer) {
        if (inputConsumer != null) {
            inputConsumer.dismiss();
        }
    }

    private boolean isStatusBarKeyguard() {
        return this.mStatusBar != null && (this.mStatusBar.getAttrs().privateFlags & 0x400) != 0;
    }

    private boolean isKeyguardOccluded() {
        return this.mService.mPolicy.isKeyguardOccluded();
    }

    void resetSystemUiVisibilityLw() {
        this.mLastSystemUiFlags = 0;
        this.updateSystemUiVisibilityLw();
    }

    private int updateSystemUiVisibilityLw() {
        WindowState winCandidate;
        WindowState windowState = winCandidate = this.mFocusedWindow != null ? this.mFocusedWindow : this.mTopFullscreenOpaqueWindowState;
        if (winCandidate == null) {
            return 0;
        }
        if (winCandidate.getAttrs().token == this.mImmersiveModeConfirmation.getWindowToken()) {
            boolean lastFocusCanReceiveKeys;
            boolean bl = lastFocusCanReceiveKeys = this.mLastFocusedWindow != null && this.mLastFocusedWindow.canReceiveKeys();
            WindowState windowState2 = this.isStatusBarKeyguard() ? this.mStatusBar : (winCandidate = lastFocusCanReceiveKeys ? this.mLastFocusedWindow : this.mTopFullscreenOpaqueWindowState);
            if (winCandidate == null) {
                return 0;
            }
        }
        WindowState win = winCandidate;
        if ((win.getAttrs().privateFlags & 0x400) != 0 && this.isKeyguardOccluded()) {
            return 0;
        }
        this.mDisplayContent.getInsetsStateController().onBarControllingWindowChanged(this.mTopFullscreenOpaqueWindowState);
        int tmpVisibility = PolicyControl.getSystemUiVisibility(win, null) & ~this.mResettingSystemUiFlags & ~this.mForceClearedSystemUiFlags;
        if (this.mForcingShowNavBar && win.getSurfaceLayer() < this.mForcingShowNavBarLayer) {
            tmpVisibility &= ~PolicyControl.adjustClearableFlags(win, 7);
        }
        int fullscreenVisibility = this.updateLightStatusBarLw(0, this.mTopFullscreenOpaqueWindowState, this.mTopFullscreenOpaqueOrDimmingWindowState);
        int dockedVisibility = this.updateLightStatusBarLw(0, this.mTopDockedOpaqueWindowState, this.mTopDockedOpaqueOrDimmingWindowState);
        this.mService.getStackBounds(0, 2, this.mNonDockedStackBounds);
        this.mService.getStackBounds(3, 1, this.mDockedStackBounds);
        Pair<Integer, Boolean> result = this.updateSystemBarsLw(win, this.mLastSystemUiFlags, tmpVisibility);
        int visibility = (Integer)result.first;
        int diff = visibility ^ this.mLastSystemUiFlags;
        int fullscreenDiff = fullscreenVisibility ^ this.mLastFullscreenStackSysUiFlags;
        int dockedDiff = dockedVisibility ^ this.mLastDockedStackSysUiFlags;
        boolean needsMenu = win.getNeedsMenuLw(this.mTopFullscreenOpaqueWindowState);
        if (diff == 0 && fullscreenDiff == 0 && dockedDiff == 0 && this.mLastFocusNeedsMenu == needsMenu && this.mFocusedApp == win.getAppToken() && this.mLastNonDockedStackBounds.equals(this.mNonDockedStackBounds) && this.mLastDockedStackBounds.equals(this.mDockedStackBounds)) {
            return 0;
        }
        this.mLastSystemUiFlags = visibility;
        this.mLastFullscreenStackSysUiFlags = fullscreenVisibility;
        this.mLastDockedStackSysUiFlags = dockedVisibility;
        this.mLastFocusNeedsMenu = needsMenu;
        this.mFocusedApp = win.getAppToken();
        this.mLastNonDockedStackBounds.set(this.mNonDockedStackBounds);
        this.mLastDockedStackBounds.set(this.mDockedStackBounds);
        Rect fullscreenStackBounds = new Rect(this.mNonDockedStackBounds);
        Rect dockedStackBounds = new Rect(this.mDockedStackBounds);
        boolean isNavbarColorManagedByIme = (Boolean)result.second;
        this.mHandler.post(() -> {
            StatusBarManagerInternal statusBar = this.getStatusBarManagerInternal();
            if (statusBar != null) {
                int displayId = this.getDisplayId();
                statusBar.setSystemUiVisibility(displayId, visibility, fullscreenVisibility, dockedVisibility, -1, fullscreenStackBounds, dockedStackBounds, isNavbarColorManagedByIme, win.toString());
                statusBar.topAppWindowChanged(displayId, needsMenu);
            }
        });
        return diff;
    }

    private int updateLightStatusBarLw(int vis, WindowState opaque, WindowState opaqueOrDimming) {
        WindowState statusColorWin;
        boolean onKeyguard = this.isStatusBarKeyguard() && !this.isKeyguardOccluded();
        WindowState windowState = statusColorWin = onKeyguard ? this.mStatusBar : opaqueOrDimming;
        if (statusColorWin != null && (statusColorWin == opaque || onKeyguard)) {
            vis &= 0xFFFFDFFF;
            vis |= PolicyControl.getSystemUiVisibility(statusColorWin, null) & 0x2000;
        } else if (statusColorWin != null && statusColorWin.isDimming()) {
            vis &= 0xFFFFDFFF;
        }
        return vis;
    }

    @VisibleForTesting
    static WindowState chooseNavigationColorWindowLw(WindowState opaque, WindowState opaqueOrDimming, WindowState imeWindow, int navBarPosition) {
        boolean imeWindowCanNavColorWindow;
        boolean bl = imeWindowCanNavColorWindow = imeWindow != null && imeWindow.isVisibleLw() && navBarPosition == 4 && (PolicyControl.getWindowFlags(imeWindow, null) & Integer.MIN_VALUE) != 0;
        if (opaque != null && opaqueOrDimming == opaque) {
            return imeWindowCanNavColorWindow ? imeWindow : opaque;
        }
        if (opaqueOrDimming == null || !opaqueOrDimming.isDimming()) {
            return imeWindowCanNavColorWindow ? imeWindow : null;
        }
        if (!imeWindowCanNavColorWindow) {
            return opaqueOrDimming;
        }
        if (WindowManager.LayoutParams.mayUseInputMethod(PolicyControl.getWindowFlags(opaqueOrDimming, null))) {
            return imeWindow;
        }
        return opaqueOrDimming;
    }

    @VisibleForTesting
    static int updateLightNavigationBarLw(int vis, WindowState opaque, WindowState opaqueOrDimming, WindowState imeWindow, WindowState navColorWin) {
        if (navColorWin != null) {
            if (navColorWin == imeWindow || navColorWin == opaque) {
                vis &= 0xFFFFFFEF;
                vis |= PolicyControl.getSystemUiVisibility(navColorWin, null) & 0x10;
            } else if (navColorWin == opaqueOrDimming && navColorWin.isDimming()) {
                vis &= 0xFFFFFFEF;
            }
        }
        return vis;
    }

    private Pair<Integer, Boolean> updateSystemBarsLw(WindowState win, int oldVis, int vis) {
        boolean newImmersiveMode;
        boolean navAllowedHidden;
        boolean denyTransientNav;
        boolean statusBarHasFocus;
        boolean dockedStackVisible = this.mDisplayContent.isStackVisible(3);
        boolean freeformStackVisible = this.mDisplayContent.isStackVisible(5);
        boolean resizing = this.mDisplayContent.getDockedDividerController().isResizing();
        this.mForceShowSystemBars = dockedStackVisible || freeformStackVisible || resizing || this.mForceShowSystemBarsFromExternal;
        boolean forceOpaqueStatusBar = this.mForceShowSystemBars && !this.mForceStatusBarFromKeyguard;
        WindowState fullscreenTransWin = this.isStatusBarKeyguard() && !this.isKeyguardOccluded() ? this.mStatusBar : this.mTopFullscreenOpaqueWindowState;
        vis = this.mStatusBarController.applyTranslucentFlagLw(fullscreenTransWin, vis, oldVis);
        vis = this.mNavigationBarController.applyTranslucentFlagLw(fullscreenTransWin, vis, oldVis);
        int dockedVis = this.mStatusBarController.applyTranslucentFlagLw(this.mTopDockedOpaqueWindowState, 0, 0);
        dockedVis = this.mNavigationBarController.applyTranslucentFlagLw(this.mTopDockedOpaqueWindowState, dockedVis, 0);
        boolean fullscreenDrawsStatusBarBackground = this.drawsStatusBarBackground(vis, this.mTopFullscreenOpaqueWindowState);
        boolean dockedDrawsStatusBarBackground = this.drawsStatusBarBackground(dockedVis, this.mTopDockedOpaqueWindowState);
        boolean fullscreenDrawsNavBarBackground = this.drawsNavigationBarBackground(vis, this.mTopFullscreenOpaqueWindowState);
        boolean dockedDrawsNavigationBarBackground = this.drawsNavigationBarBackground(dockedVis, this.mTopDockedOpaqueWindowState);
        int type = win.getAttrs().type;
        boolean bl = statusBarHasFocus = type == 2000;
        if (statusBarHasFocus && !this.isStatusBarKeyguard()) {
            int flags = 14342;
            if (this.isKeyguardOccluded()) {
                flags |= 0xC0000000;
            }
            vis = vis & ~flags | oldVis & flags;
        }
        if (fullscreenDrawsStatusBarBackground && dockedDrawsStatusBarBackground) {
            vis |= 8;
            vis &= 0xBFFFFFFF;
        } else if (forceOpaqueStatusBar) {
            vis &= 0xBFFFFFF7;
        }
        vis = this.configureNavBarOpacity(vis, dockedStackVisible, freeformStackVisible, resizing, fullscreenDrawsNavBarBackground, dockedDrawsNavigationBarBackground);
        boolean immersiveSticky = (vis & 0x1000) != 0;
        boolean hideStatusBarWM = this.mTopFullscreenOpaqueWindowState != null && (PolicyControl.getWindowFlags(this.mTopFullscreenOpaqueWindowState, null) & 0x400) != 0;
        boolean hideStatusBarSysui = (vis & 4) != 0;
        boolean hideNavBarSysui = (vis & 2) != 0;
        boolean transientStatusBarAllowed = this.mStatusBar != null && (statusBarHasFocus || !this.mForceShowSystemBars && (hideStatusBarWM || hideStatusBarSysui && immersiveSticky));
        boolean transientNavBarAllowed = this.mNavigationBar != null && !this.mForceShowSystemBars && hideNavBarSysui && immersiveSticky;
        long now = SystemClock.uptimeMillis();
        boolean pendingPanic = this.mPendingPanicGestureUptime != 0L && now - this.mPendingPanicGestureUptime <= 30000L;
        DisplayPolicy defaultDisplayPolicy = this.mService.getDefaultDisplayContentLocked().getDisplayPolicy();
        if (pendingPanic && hideNavBarSysui && !this.isStatusBarKeyguard() && defaultDisplayPolicy.isKeyguardDrawComplete()) {
            this.mPendingPanicGestureUptime = 0L;
            this.mStatusBarController.showTransient();
            if (!DisplayPolicy.isNavBarEmpty(vis)) {
                this.mNavigationBarController.showTransient();
            }
        }
        boolean denyTransientStatus = this.mStatusBarController.isTransientShowRequested() && !transientStatusBarAllowed && hideStatusBarSysui;
        boolean bl2 = denyTransientNav = this.mNavigationBarController.isTransientShowRequested() && !transientNavBarAllowed;
        if (denyTransientStatus || denyTransientNav || this.mForceShowSystemBars) {
            this.clearClearableFlagsLw();
            vis &= 0xFFFFFFF8;
        }
        boolean immersive = (vis & 0x800) != 0;
        immersiveSticky = (vis & 0x1000) != 0;
        boolean bl3 = navAllowedHidden = immersive || immersiveSticky;
        if (hideNavBarSysui && !navAllowedHidden && this.mService.mPolicy.getWindowLayerLw(win) > this.mService.mPolicy.getWindowLayerFromTypeLw(2022)) {
            vis &= 0xFFFFFFFD;
        }
        vis = this.mStatusBarController.updateVisibilityLw(transientStatusBarAllowed, oldVis, vis);
        boolean oldImmersiveMode = this.isImmersiveMode(oldVis);
        if (oldImmersiveMode != (newImmersiveMode = this.isImmersiveMode(vis))) {
            String pkg = win.getOwningPackage();
            this.mImmersiveModeConfirmation.immersiveModeChangedLw(pkg, newImmersiveMode, this.mService.mPolicy.isUserSetupComplete(), DisplayPolicy.isNavBarEmpty(win.getSystemUiVisibility()));
        }
        vis = this.mNavigationBarController.updateVisibilityLw(transientNavBarAllowed, oldVis, vis);
        WindowState navColorWin = DisplayPolicy.chooseNavigationColorWindowLw(this.mTopFullscreenOpaqueWindowState, this.mTopFullscreenOpaqueOrDimmingWindowState, this.mDisplayContent.mInputMethodWindow, this.mNavigationBarPosition);
        vis = DisplayPolicy.updateLightNavigationBarLw(vis, this.mTopFullscreenOpaqueWindowState, this.mTopFullscreenOpaqueOrDimmingWindowState, this.mDisplayContent.mInputMethodWindow, navColorWin);
        boolean isManagedByIme = navColorWin != null && navColorWin == this.mDisplayContent.mInputMethodWindow;
        return Pair.create(vis, isManagedByIme);
    }

    private boolean drawsBarBackground(int vis, WindowState win, BarController controller, int translucentFlag) {
        if (!controller.isTransparentAllowed(win)) {
            return false;
        }
        if (win == null) {
            return true;
        }
        boolean drawsSystemBars = (win.getAttrs().flags & Integer.MIN_VALUE) != 0;
        boolean forceDrawsSystemBars = (win.getAttrs().privateFlags & 0x20000) != 0;
        return forceDrawsSystemBars || drawsSystemBars && (vis & translucentFlag) == 0;
    }

    private boolean drawsStatusBarBackground(int vis, WindowState win) {
        return this.drawsBarBackground(vis, win, this.mStatusBarController, 0x4000000);
    }

    private boolean drawsNavigationBarBackground(int vis, WindowState win) {
        return this.drawsBarBackground(vis, win, this.mNavigationBarController, 0x8000000);
    }

    private int configureNavBarOpacity(int visibility, boolean dockedStackVisible, boolean freeformStackVisible, boolean isDockedDividerResizing, boolean fullscreenDrawsBackground, boolean dockedDrawsNavigationBarBackground) {
        if (this.mNavBarOpacityMode == 2) {
            if (fullscreenDrawsBackground && dockedDrawsNavigationBarBackground) {
                visibility = this.setNavBarTransparentFlag(visibility);
            } else if (dockedStackVisible) {
                visibility = this.setNavBarOpaqueFlag(visibility);
            }
        } else if (this.mNavBarOpacityMode == 0) {
            if (dockedStackVisible || freeformStackVisible || isDockedDividerResizing) {
                visibility = this.setNavBarOpaqueFlag(visibility);
            } else if (fullscreenDrawsBackground) {
                visibility = this.setNavBarTransparentFlag(visibility);
            }
        } else if (this.mNavBarOpacityMode == 1) {
            visibility = isDockedDividerResizing ? this.setNavBarOpaqueFlag(visibility) : (freeformStackVisible ? this.setNavBarTranslucentFlag(visibility) : this.setNavBarOpaqueFlag(visibility));
        }
        return visibility;
    }

    private int setNavBarOpaqueFlag(int visibility) {
        return visibility & 0x7FFF7FFF;
    }

    private int setNavBarTranslucentFlag(int visibility) {
        return (visibility &= 0xFFFF7FFF) | Integer.MIN_VALUE;
    }

    private int setNavBarTransparentFlag(int visibility) {
        return (visibility &= Integer.MAX_VALUE) | 0x8000;
    }

    private void clearClearableFlagsLw() {
        int newVal = this.mResettingSystemUiFlags | 7;
        if (newVal != this.mResettingSystemUiFlags) {
            this.mResettingSystemUiFlags = newVal;
            this.mDisplayContent.reevaluateStatusBarVisibility();
        }
    }

    private boolean isImmersiveMode(int vis) {
        int flags = 6144;
        return this.mNavigationBar != null && (vis & 2) != 0 && (vis & 0x1800) != 0 && this.canHideNavigationBar();
    }

    private boolean canHideNavigationBar() {
        return this.hasNavigationBar();
    }

    private static boolean isNavBarEmpty(int systemUiFlags) {
        int disableNavigationBar = 0x1600000;
        return (systemUiFlags & 0x1600000) == 0x1600000;
    }

    boolean shouldRotateSeamlessly(DisplayRotation displayRotation, int oldRotation, int newRotation) {
        if (oldRotation == displayRotation.getUpsideDownRotation() || newRotation == displayRotation.getUpsideDownRotation()) {
            return false;
        }
        if (!this.navigationBarCanMove() && !this.mAllowSeamlessRotationDespiteNavBarMoving) {
            return false;
        }
        WindowState w = this.mTopFullscreenOpaqueWindowState;
        if (w == null || w != this.mFocusedWindow) {
            return false;
        }
        if (w.mAppToken != null && !w.mAppToken.matchParentBounds()) {
            return false;
        }
        return !w.isAnimatingLw() && w.getAttrs().rotationAnimation == 3;
    }

    void onPowerKeyDown(boolean isScreenOn) {
        boolean panic = this.mImmersiveModeConfirmation.onPowerKeyDown(isScreenOn, SystemClock.elapsedRealtime(), this.isImmersiveMode(this.mLastSystemUiFlags), DisplayPolicy.isNavBarEmpty(this.mLastSystemUiFlags));
        if (panic) {
            this.mHandler.post(this.mHiddenNavPanic);
        }
    }

    void onVrStateChangedLw(boolean enabled) {
        this.mImmersiveModeConfirmation.onVrStateChangedLw(enabled);
    }

    public void onLockTaskStateChangedLw(int lockTaskState) {
        this.mImmersiveModeConfirmation.onLockTaskModeChangedLw(lockTaskState);
    }

    public void takeScreenshot(int screenshotType) {
        if (this.mScreenshotHelper != null) {
            this.mScreenshotHelper.takeScreenshot(screenshotType, this.mStatusBar != null && this.mStatusBar.isVisibleLw(), this.mNavigationBar != null && this.mNavigationBar.isVisibleLw(), this.mHandler);
        }
    }

    RefreshRatePolicy getRefreshRatePolicy() {
        return this.mRefreshRatePolicy;
    }

    void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("DisplayPolicy");
        prefix = prefix + "  ";
        pw.print(prefix);
        pw.print("mCarDockEnablesAccelerometer=");
        pw.print(this.mCarDockEnablesAccelerometer);
        pw.print(" mDeskDockEnablesAccelerometer=");
        pw.println(this.mDeskDockEnablesAccelerometer);
        pw.print(prefix);
        pw.print("mDockMode=");
        pw.print(Intent.dockStateToString(this.mDockMode));
        pw.print(" mLidState=");
        pw.println(WindowManagerPolicy.WindowManagerFuncs.lidStateToString(this.mLidState));
        pw.print(prefix);
        pw.print("mAwake=");
        pw.print(this.mAwake);
        pw.print(" mScreenOnEarly=");
        pw.print(this.mScreenOnEarly);
        pw.print(" mScreenOnFully=");
        pw.println(this.mScreenOnFully);
        pw.print(prefix);
        pw.print("mKeyguardDrawComplete=");
        pw.print(this.mKeyguardDrawComplete);
        pw.print(" mWindowManagerDrawComplete=");
        pw.println(this.mWindowManagerDrawComplete);
        pw.print(prefix);
        pw.print("mHdmiPlugged=");
        pw.println(this.mHdmiPlugged);
        if (this.mLastSystemUiFlags != 0 || this.mResettingSystemUiFlags != 0 || this.mForceClearedSystemUiFlags != 0) {
            pw.print(prefix);
            pw.print("mLastSystemUiFlags=0x");
            pw.print(Integer.toHexString(this.mLastSystemUiFlags));
            pw.print(" mResettingSystemUiFlags=0x");
            pw.print(Integer.toHexString(this.mResettingSystemUiFlags));
            pw.print(" mForceClearedSystemUiFlags=0x");
            pw.println(Integer.toHexString(this.mForceClearedSystemUiFlags));
        }
        if (this.mLastFocusNeedsMenu) {
            pw.print(prefix);
            pw.print("mLastFocusNeedsMenu=");
            pw.println(this.mLastFocusNeedsMenu);
        }
        pw.print(prefix);
        pw.print("mShowingDream=");
        pw.print(this.mShowingDream);
        pw.print(" mDreamingLockscreen=");
        pw.print(this.mDreamingLockscreen);
        pw.print(" mDreamingSleepToken=");
        pw.println(this.mDreamingSleepToken);
        if (this.mStatusBar != null) {
            pw.print(prefix);
            pw.print("mStatusBar=");
            pw.print(this.mStatusBar);
            pw.print(" isStatusBarKeyguard=");
            pw.println(this.isStatusBarKeyguard());
        }
        if (this.mNavigationBar != null) {
            pw.print(prefix);
            pw.print("mNavigationBar=");
            pw.println(this.mNavigationBar);
            pw.print(prefix);
            pw.print("mNavBarOpacityMode=");
            pw.println(this.mNavBarOpacityMode);
            pw.print(prefix);
            pw.print("mNavigationBarCanMove=");
            pw.println(this.mNavigationBarCanMove);
            pw.print(prefix);
            pw.print("mNavigationBarPosition=");
            pw.println(this.mNavigationBarPosition);
        }
        if (this.mFocusedWindow != null) {
            pw.print(prefix);
            pw.print("mFocusedWindow=");
            pw.println(this.mFocusedWindow);
        }
        if (this.mFocusedApp != null) {
            pw.print(prefix);
            pw.print("mFocusedApp=");
            pw.println(this.mFocusedApp);
        }
        if (this.mTopFullscreenOpaqueWindowState != null) {
            pw.print(prefix);
            pw.print("mTopFullscreenOpaqueWindowState=");
            pw.println(this.mTopFullscreenOpaqueWindowState);
        }
        if (this.mTopFullscreenOpaqueOrDimmingWindowState != null) {
            pw.print(prefix);
            pw.print("mTopFullscreenOpaqueOrDimmingWindowState=");
            pw.println(this.mTopFullscreenOpaqueOrDimmingWindowState);
        }
        if (this.mForcingShowNavBar) {
            pw.print(prefix);
            pw.print("mForcingShowNavBar=");
            pw.println(this.mForcingShowNavBar);
            pw.print(prefix);
            pw.print("mForcingShowNavBarLayer=");
            pw.println(this.mForcingShowNavBarLayer);
        }
        pw.print(prefix);
        pw.print("mTopIsFullscreen=");
        pw.print(this.mTopIsFullscreen);
        pw.print(prefix);
        pw.print("mForceStatusBar=");
        pw.print(this.mForceStatusBar);
        pw.print(" mForceStatusBarFromKeyguard=");
        pw.println(this.mForceStatusBarFromKeyguard);
        pw.print(" mForceShowSystemBarsFromExternal=");
        pw.println(this.mForceShowSystemBarsFromExternal);
        pw.print(prefix);
        pw.print("mAllowLockscreenWhenOn=");
        pw.println(this.mAllowLockscreenWhenOn);
        this.mStatusBarController.dump(pw, prefix);
        this.mNavigationBarController.dump(pw, prefix);
        pw.print(prefix);
        pw.println("Looper state:");
        this.mHandler.getLooper().dump(new PrintWriterPrinter(pw), prefix + "  ");
    }

    private boolean supportsPointerLocation() {
        return this.mDisplayContent.isDefaultDisplay || !this.mDisplayContent.isPrivate();
    }

    void setPointerLocationEnabled(boolean pointerLocationEnabled) {
        if (!this.supportsPointerLocation()) {
            return;
        }
        this.mHandler.sendEmptyMessage(pointerLocationEnabled ? 4 : 5);
    }

    private void enablePointerLocation() {
        if (this.mPointerLocationView != null) {
            return;
        }
        this.mPointerLocationView = new PointerLocationView(this.mContext);
        this.mPointerLocationView.setPrintCoords(false);
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(-1, -1);
        lp.type = 2015;
        lp.flags = 1304;
        lp.layoutInDisplayCutoutMode = 1;
        if (ActivityManager.isHighEndGfx()) {
            lp.flags |= 0x1000000;
            lp.privateFlags |= 2;
        }
        lp.format = -3;
        lp.setTitle("PointerLocation - display " + this.getDisplayId());
        lp.inputFeatures |= 2;
        WindowManager wm = this.mContext.getSystemService(WindowManager.class);
        wm.addView(this.mPointerLocationView, lp);
        this.mDisplayContent.registerPointerEventListener(this.mPointerLocationView);
    }

    private void disablePointerLocation() {
        if (this.mPointerLocationView == null) {
            return;
        }
        this.mDisplayContent.unregisterPointerEventListener(this.mPointerLocationView);
        WindowManager wm = this.mContext.getSystemService(WindowManager.class);
        wm.removeView(this.mPointerLocationView);
        this.mPointerLocationView = null;
    }

    private final class HideNavInputEventReceiver
    extends InputEventReceiver {
        HideNavInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInputEvent(InputEvent event) {
            block11: {
                try {
                    MotionEvent motionEvent;
                    if (!(event instanceof MotionEvent) || (event.getSource() & 2) == 0 || (motionEvent = (MotionEvent)event).getAction() != 0) break block11;
                    boolean changed = false;
                    Object object = DisplayPolicy.this.mLock;
                    synchronized (object) {
                        block12: {
                            if (DisplayPolicy.this.mInputConsumer != null) break block12;
                            return;
                        }
                        int newVal = DisplayPolicy.this.mResettingSystemUiFlags | 2 | 1 | 4;
                        if (DisplayPolicy.this.mResettingSystemUiFlags != newVal) {
                            DisplayPolicy.this.mResettingSystemUiFlags = newVal;
                            changed = true;
                        }
                        newVal = DisplayPolicy.this.mForceClearedSystemUiFlags | 2;
                        if (DisplayPolicy.this.mForceClearedSystemUiFlags != newVal) {
                            DisplayPolicy.this.mForceClearedSystemUiFlags = newVal;
                            changed = true;
                            DisplayPolicy.this.mHandler.postDelayed(DisplayPolicy.this.mClearHideNavigationFlag, 1000L);
                        }
                        if (changed) {
                            DisplayPolicy.this.mDisplayContent.reevaluateStatusBarVisibility();
                        }
                    }
                }
                finally {
                    this.finishInputEvent(event, false);
                }
            }
        }
    }

    private class PolicyHandler
    extends Handler {
        PolicyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    DisplayPolicy.this.updateDreamingSleepToken(msg.arg1 != 0);
                    break;
                }
                case 2: {
                    WindowState targetBar;
                    WindowState windowState = targetBar = msg.arg1 == 0 ? DisplayPolicy.this.mStatusBar : DisplayPolicy.this.mNavigationBar;
                    if (targetBar == null) break;
                    DisplayPolicy.this.requestTransientBars(targetBar);
                    break;
                }
                case 3: {
                    DisplayPolicy.this.disposeInputConsumer((WindowManagerPolicy.InputConsumer)msg.obj);
                    break;
                }
                case 4: {
                    DisplayPolicy.this.enablePointerLocation();
                    break;
                }
                case 5: {
                    DisplayPolicy.this.disablePointerLocation();
                }
            }
        }
    }
}

