/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Surface;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.LocalServices;
import com.android.server.UiThread;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.policy.WindowOrientationListener;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplayPolicy;
import com.android.server.wm.DisplayWindowSettings;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class DisplayRotation {
    private static final String TAG = "WindowManager";
    private final WindowManagerService mService;
    private final DisplayContent mDisplayContent;
    private final DisplayPolicy mDisplayPolicy;
    private final DisplayWindowSettings mDisplayWindowSettings;
    private final Context mContext;
    private final Object mLock;
    public final boolean isDefaultDisplay;
    private final boolean mSupportAutoRotation;
    private final int mLidOpenRotation;
    private final int mCarDockRotation;
    private final int mDeskDockRotation;
    private final int mUndockedHdmiRotation;
    private OrientationListener mOrientationListener;
    private StatusBarManagerInternal mStatusBarManagerInternal;
    private SettingsObserver mSettingsObserver;
    private int mCurrentAppOrientation = -1;
    @VisibleForTesting
    int mLandscapeRotation;
    @VisibleForTesting
    int mSeascapeRotation;
    @VisibleForTesting
    int mPortraitRotation;
    @VisibleForTesting
    int mUpsideDownRotation;
    private int mShowRotationSuggestions;
    private int mAllowAllRotations = -1;
    private int mUserRotationMode = 0;
    private int mUserRotation = 0;
    private boolean mDefaultFixedToUserRotation;
    static final int FIXED_TO_USER_ROTATION_DEFAULT = 0;
    static final int FIXED_TO_USER_ROTATION_DISABLED = 1;
    static final int FIXED_TO_USER_ROTATION_ENABLED = 2;
    private int mFixedToUserRotation = 0;
    private int mDemoHdmiRotation;
    private int mDemoRotation;
    private boolean mDemoHdmiRotationLock;
    private boolean mDemoRotationLock;

    DisplayRotation(WindowManagerService service, DisplayContent displayContent) {
        this(service, displayContent, displayContent.getDisplayPolicy(), service.mDisplayWindowSettings, service.mContext, service.getWindowManagerLock());
    }

    @VisibleForTesting
    DisplayRotation(WindowManagerService service, DisplayContent displayContent, DisplayPolicy displayPolicy, DisplayWindowSettings displayWindowSettings, Context context, Object lock) {
        this.mService = service;
        this.mDisplayContent = displayContent;
        this.mDisplayPolicy = displayPolicy;
        this.mDisplayWindowSettings = displayWindowSettings;
        this.mContext = context;
        this.mLock = lock;
        this.isDefaultDisplay = displayContent.isDefaultDisplay;
        this.mSupportAutoRotation = this.mContext.getResources().getBoolean(17891529);
        this.mLidOpenRotation = this.readRotation(17694819);
        this.mCarDockRotation = this.readRotation(17694761);
        this.mDeskDockRotation = this.readRotation(17694785);
        this.mUndockedHdmiRotation = this.readRotation(17694902);
        if (this.isDefaultDisplay) {
            Handler uiHandler = UiThread.getHandler();
            this.mOrientationListener = new OrientationListener(this.mContext, uiHandler);
            this.mOrientationListener.setCurrentRotation(displayContent.getRotation());
            this.mSettingsObserver = new SettingsObserver(uiHandler);
            this.mSettingsObserver.observe();
        }
    }

    private int readRotation(int resID) {
        try {
            int rotation = this.mContext.getResources().getInteger(resID);
            switch (rotation) {
                case 0: {
                    return 0;
                }
                case 90: {
                    return 1;
                }
                case 180: {
                    return 2;
                }
                case 270: {
                    return 3;
                }
            }
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        return -1;
    }

    void configure(int width, int height, int shortSizeDp, int longSizeDp) {
        Resources res = this.mContext.getResources();
        if (width > height) {
            this.mLandscapeRotation = 0;
            this.mSeascapeRotation = 2;
            if (res.getBoolean(17891502)) {
                this.mPortraitRotation = 1;
                this.mUpsideDownRotation = 3;
            } else {
                this.mPortraitRotation = 3;
                this.mUpsideDownRotation = 1;
            }
        } else {
            this.mPortraitRotation = 0;
            this.mUpsideDownRotation = 2;
            if (res.getBoolean(17891502)) {
                this.mLandscapeRotation = 3;
                this.mSeascapeRotation = 1;
            } else {
                this.mLandscapeRotation = 1;
                this.mSeascapeRotation = 3;
            }
        }
        this.mDemoHdmiRotation = "portrait".equals(SystemProperties.get("persist.demo.hdmirotation")) ? this.mPortraitRotation : this.mLandscapeRotation;
        this.mDemoHdmiRotationLock = SystemProperties.getBoolean("persist.demo.hdmirotationlock", false);
        this.mDemoRotation = "portrait".equals(SystemProperties.get("persist.demo.remoterotation")) ? this.mPortraitRotation : this.mLandscapeRotation;
        this.mDemoRotationLock = SystemProperties.getBoolean("persist.demo.rotationlock", false);
        boolean isCar = this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.automotive");
        boolean isTv = this.mContext.getPackageManager().hasSystemFeature("android.software.leanback");
        boolean forceDesktopMode = this.mService.mForceDesktopModeOnExternalDisplays && !this.isDefaultDisplay;
        this.mDefaultFixedToUserRotation = (isCar || isTv || this.mService.mIsPc || forceDesktopMode) && !"true".equals(SystemProperties.get("config.override_forced_orient"));
    }

    void setRotation(int rotation) {
        if (this.mOrientationListener != null) {
            this.mOrientationListener.setCurrentRotation(rotation);
        }
    }

    void setCurrentOrientation(int newOrientation) {
        if (newOrientation != this.mCurrentAppOrientation) {
            this.mCurrentAppOrientation = newOrientation;
            if (this.isDefaultDisplay) {
                this.updateOrientationListenerLw();
            }
        }
    }

    void restoreSettings(int userRotationMode, int userRotation, int fixedToUserRotation) {
        this.mFixedToUserRotation = fixedToUserRotation;
        if (this.isDefaultDisplay) {
            return;
        }
        if (userRotationMode != 0 && userRotationMode != 1) {
            Slog.w(TAG, "Trying to restore an invalid user rotation mode " + userRotationMode + " for " + this.mDisplayContent);
            userRotationMode = 0;
        }
        if (userRotation < 0 || userRotation > 3) {
            Slog.w(TAG, "Trying to restore an invalid user rotation " + userRotation + " for " + this.mDisplayContent);
            userRotation = 0;
        }
        this.mUserRotationMode = userRotationMode;
        this.mUserRotation = userRotation;
    }

    void setFixedToUserRotation(int fixedToUserRotation) {
        if (this.mFixedToUserRotation == fixedToUserRotation) {
            return;
        }
        this.mFixedToUserRotation = fixedToUserRotation;
        this.mDisplayWindowSettings.setFixedToUserRotation(this.mDisplayContent, fixedToUserRotation);
        this.mService.updateRotation(true, false);
    }

    private void setUserRotation(int userRotationMode, int userRotation) {
        if (this.isDefaultDisplay) {
            ContentResolver res = this.mContext.getContentResolver();
            int accelerometerRotation = userRotationMode == 1 ? 0 : 1;
            Settings.System.putIntForUser(res, "accelerometer_rotation", accelerometerRotation, -2);
            Settings.System.putIntForUser(res, "user_rotation", userRotation, -2);
            return;
        }
        boolean changed = false;
        if (this.mUserRotationMode != userRotationMode) {
            this.mUserRotationMode = userRotationMode;
            changed = true;
        }
        if (this.mUserRotation != userRotation) {
            this.mUserRotation = userRotation;
            changed = true;
        }
        this.mDisplayWindowSettings.setUserRotation(this.mDisplayContent, userRotationMode, userRotation);
        if (changed) {
            this.mService.updateRotation(true, false);
        }
    }

    void freezeRotation(int rotation) {
        rotation = rotation == -1 ? this.mDisplayContent.getRotation() : rotation;
        this.setUserRotation(1, rotation);
    }

    void thawRotation() {
        this.setUserRotation(0, this.mUserRotation);
    }

    boolean isRotationFrozen() {
        if (!this.isDefaultDisplay) {
            return this.mUserRotationMode == 1;
        }
        return Settings.System.getIntForUser(this.mContext.getContentResolver(), "accelerometer_rotation", 0, -2) == 0;
    }

    boolean isFixedToUserRotation() {
        switch (this.mFixedToUserRotation) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return this.mDefaultFixedToUserRotation;
    }

    boolean respectAppRequestedOrientation() {
        return !this.isFixedToUserRotation();
    }

    public int getLandscapeRotation() {
        return this.mLandscapeRotation;
    }

    public int getSeascapeRotation() {
        return this.mSeascapeRotation;
    }

    public int getPortraitRotation() {
        return this.mPortraitRotation;
    }

    public int getUpsideDownRotation() {
        return this.mUpsideDownRotation;
    }

    public int getCurrentAppOrientation() {
        return this.mCurrentAppOrientation;
    }

    public DisplayPolicy getDisplayPolicy() {
        return this.mDisplayPolicy;
    }

    public WindowOrientationListener getOrientationListener() {
        return this.mOrientationListener;
    }

    public int getUserRotation() {
        return this.mUserRotation;
    }

    public int getUserRotationMode() {
        return this.mUserRotationMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrientationListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateOrientationListenerLw();
        }
    }

    private void updateOrientationListenerLw() {
        if (this.mOrientationListener == null || !this.mOrientationListener.canDetectOrientation()) {
            return;
        }
        boolean screenOnEarly = this.mDisplayPolicy.isScreenOnEarly();
        boolean awake = this.mDisplayPolicy.isAwake();
        boolean keyguardDrawComplete = this.mDisplayPolicy.isKeyguardDrawComplete();
        boolean windowManagerDrawComplete = this.mDisplayPolicy.isWindowManagerDrawComplete();
        boolean disable = true;
        if (screenOnEarly && awake && keyguardDrawComplete && windowManagerDrawComplete && this.needSensorRunning()) {
            disable = false;
            if (!this.mOrientationListener.mEnabled) {
                this.mOrientationListener.enable(true);
            }
        }
        if (disable && this.mOrientationListener.mEnabled) {
            this.mOrientationListener.disable();
        }
    }

    private boolean needSensorRunning() {
        if (this.isFixedToUserRotation()) {
            return false;
        }
        if (this.mSupportAutoRotation && (this.mCurrentAppOrientation == 4 || this.mCurrentAppOrientation == 10 || this.mCurrentAppOrientation == 7 || this.mCurrentAppOrientation == 6)) {
            return true;
        }
        int dockMode = this.mDisplayPolicy.getDockMode();
        if (this.mDisplayPolicy.isCarDockEnablesAccelerometer() && dockMode == 2 || this.mDisplayPolicy.isDeskDockEnablesAccelerometer() && (dockMode == 1 || dockMode == 3 || dockMode == 4)) {
            return true;
        }
        if (this.mUserRotationMode == 1) {
            return this.mSupportAutoRotation && this.mShowRotationSuggestions == 1;
        }
        return this.mSupportAutoRotation;
    }

    int rotationForOrientation(int orientation, int lastRotation) {
        int preferredRotation;
        int sensorRotation;
        if (this.isFixedToUserRotation()) {
            return this.mUserRotation;
        }
        int n = sensorRotation = this.mOrientationListener != null ? this.mOrientationListener.getProposedRotation() : -1;
        if (sensorRotation < 0) {
            sensorRotation = lastRotation;
        }
        int lidState = this.mDisplayPolicy.getLidState();
        int dockMode = this.mDisplayPolicy.getDockMode();
        boolean hdmiPlugged = this.mDisplayPolicy.isHdmiPlugged();
        boolean carDockEnablesAccelerometer = this.mDisplayPolicy.isCarDockEnablesAccelerometer();
        boolean deskDockEnablesAccelerometer = this.mDisplayPolicy.isDeskDockEnablesAccelerometer();
        if (!this.isDefaultDisplay) {
            preferredRotation = this.mUserRotation;
        } else if (lidState == 1 && this.mLidOpenRotation >= 0) {
            preferredRotation = this.mLidOpenRotation;
        } else if (dockMode == 2 && (carDockEnablesAccelerometer || this.mCarDockRotation >= 0)) {
            preferredRotation = carDockEnablesAccelerometer ? sensorRotation : this.mCarDockRotation;
        } else if (!(dockMode != 1 && dockMode != 3 && dockMode != 4 || !deskDockEnablesAccelerometer && this.mDeskDockRotation < 0)) {
            preferredRotation = deskDockEnablesAccelerometer ? sensorRotation : this.mDeskDockRotation;
        } else if (hdmiPlugged && this.mDemoHdmiRotationLock) {
            preferredRotation = this.mDemoHdmiRotation;
        } else if (hdmiPlugged && dockMode == 0 && this.mUndockedHdmiRotation >= 0) {
            preferredRotation = this.mUndockedHdmiRotation;
        } else if (this.mDemoRotationLock) {
            preferredRotation = this.mDemoRotation;
        } else if (this.mDisplayPolicy.isPersistentVrModeEnabled()) {
            preferredRotation = this.mPortraitRotation;
        } else if (orientation == 14) {
            preferredRotation = lastRotation;
        } else if (!this.mSupportAutoRotation) {
            preferredRotation = -1;
        } else if (this.mUserRotationMode == 0 && (orientation == 2 || orientation == -1 || orientation == 11 || orientation == 12 || orientation == 13) || orientation == 4 || orientation == 10 || orientation == 6 || orientation == 7) {
            if (this.mAllowAllRotations < 0) {
                int n2 = this.mAllowAllRotations = this.mContext.getResources().getBoolean(0x111000C) ? 1 : 0;
            }
            preferredRotation = sensorRotation != 2 || this.mAllowAllRotations == 1 || orientation == 10 || orientation == 13 ? sensorRotation : lastRotation;
        } else {
            preferredRotation = this.mUserRotationMode == 1 && orientation != 5 ? this.mUserRotation : -1;
        }
        switch (orientation) {
            case 1: {
                if (this.isAnyPortrait(preferredRotation)) {
                    return preferredRotation;
                }
                return this.mPortraitRotation;
            }
            case 0: {
                if (this.isLandscapeOrSeascape(preferredRotation)) {
                    return preferredRotation;
                }
                return this.mLandscapeRotation;
            }
            case 9: {
                if (this.isAnyPortrait(preferredRotation)) {
                    return preferredRotation;
                }
                return this.mUpsideDownRotation;
            }
            case 8: {
                if (this.isLandscapeOrSeascape(preferredRotation)) {
                    return preferredRotation;
                }
                return this.mSeascapeRotation;
            }
            case 6: 
            case 11: {
                if (this.isLandscapeOrSeascape(preferredRotation)) {
                    return preferredRotation;
                }
                if (this.isLandscapeOrSeascape(lastRotation)) {
                    return lastRotation;
                }
                return this.mLandscapeRotation;
            }
            case 7: 
            case 12: {
                if (this.isAnyPortrait(preferredRotation)) {
                    return preferredRotation;
                }
                if (this.isAnyPortrait(lastRotation)) {
                    return lastRotation;
                }
                return this.mPortraitRotation;
            }
        }
        if (preferredRotation >= 0) {
            return preferredRotation;
        }
        return 0;
    }

    private boolean isLandscapeOrSeascape(int rotation) {
        return rotation == this.mLandscapeRotation || rotation == this.mSeascapeRotation;
    }

    private boolean isAnyPortrait(int rotation) {
        return rotation == this.mPortraitRotation || rotation == this.mUpsideDownRotation;
    }

    private boolean isValidRotationChoice(int preferredRotation) {
        switch (this.mCurrentAppOrientation) {
            case 13: {
                return preferredRotation >= 0;
            }
            case 12: {
                return preferredRotation == this.mPortraitRotation;
            }
            case 11: {
                return this.isLandscapeOrSeascape(preferredRotation);
            }
            case -1: 
            case 2: {
                return preferredRotation >= 0 && preferredRotation != this.mUpsideDownRotation;
            }
        }
        return false;
    }

    private boolean isRotationChoicePossible(int orientation) {
        if (this.mUserRotationMode != 1) {
            return false;
        }
        if (this.isFixedToUserRotation()) {
            return false;
        }
        int lidState = this.mDisplayPolicy.getLidState();
        if (lidState == 1 && this.mLidOpenRotation >= 0) {
            return false;
        }
        int dockMode = this.mDisplayPolicy.getDockMode();
        boolean carDockEnablesAccelerometer = false;
        if (dockMode == 2) {
            return false;
        }
        boolean deskDockEnablesAccelerometer = this.mDisplayPolicy.isDeskDockEnablesAccelerometer();
        if (!(dockMode != 1 && dockMode != 3 && dockMode != 4 || deskDockEnablesAccelerometer)) {
            return false;
        }
        boolean hdmiPlugged = this.mDisplayPolicy.isHdmiPlugged();
        if (hdmiPlugged && this.mDemoHdmiRotationLock) {
            return false;
        }
        if (hdmiPlugged && dockMode == 0 && this.mUndockedHdmiRotation >= 0) {
            return false;
        }
        if (this.mDemoRotationLock) {
            return false;
        }
        if (this.mDisplayPolicy.isPersistentVrModeEnabled()) {
            return false;
        }
        if (!this.mSupportAutoRotation) {
            return false;
        }
        switch (orientation) {
            case -1: 
            case 2: 
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private void sendProposedRotationChangeToStatusBarInternal(int rotation, boolean isValid) {
        if (this.mStatusBarManagerInternal == null) {
            this.mStatusBarManagerInternal = LocalServices.getService(StatusBarManagerInternal.class);
        }
        if (this.mStatusBarManagerInternal != null) {
            this.mStatusBarManagerInternal.onProposedRotationChanged(rotation, isValid);
        }
    }

    private static String allowAllRotationsToString(int allowAll) {
        switch (allowAll) {
            case -1: {
                return "unknown";
            }
            case 0: {
                return "false";
            }
            case 1: {
                return "true";
            }
        }
        return Integer.toString(allowAll);
    }

    public void onUserSwitch() {
        if (this.mSettingsObserver != null) {
            this.mSettingsObserver.onChange(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSettings() {
        ContentResolver resolver = this.mContext.getContentResolver();
        boolean shouldUpdateRotation = false;
        Object object = this.mLock;
        synchronized (object) {
            int userRotationMode;
            int userRotation;
            int showRotationSuggestions;
            boolean shouldUpdateOrientationListener = false;
            int n = showRotationSuggestions = ActivityManager.isLowRamDeviceStatic() ? 0 : Settings.Secure.getIntForUser(resolver, "show_rotation_suggestions", 1, -2);
            if (this.mShowRotationSuggestions != showRotationSuggestions) {
                this.mShowRotationSuggestions = showRotationSuggestions;
                shouldUpdateOrientationListener = true;
            }
            if (this.mUserRotation != (userRotation = Settings.System.getIntForUser(resolver, "user_rotation", 0, -2))) {
                this.mUserRotation = userRotation;
                shouldUpdateRotation = true;
            }
            int n2 = userRotationMode = Settings.System.getIntForUser(resolver, "accelerometer_rotation", 0, -2) != 0 ? 0 : 1;
            if (this.mUserRotationMode != userRotationMode) {
                this.mUserRotationMode = userRotationMode;
                shouldUpdateOrientationListener = true;
                shouldUpdateRotation = true;
            }
            if (shouldUpdateOrientationListener) {
                this.updateOrientationListenerLw();
            }
        }
        return shouldUpdateRotation;
    }

    void dump(String prefix, PrintWriter pw) {
        pw.println(prefix + "DisplayRotation");
        pw.println(prefix + "  mCurrentAppOrientation=" + ActivityInfo.screenOrientationToString(this.mCurrentAppOrientation));
        pw.print(prefix + "  mLandscapeRotation=" + Surface.rotationToString(this.mLandscapeRotation));
        pw.println(" mSeascapeRotation=" + Surface.rotationToString(this.mSeascapeRotation));
        pw.print(prefix + "  mPortraitRotation=" + Surface.rotationToString(this.mPortraitRotation));
        pw.println(" mUpsideDownRotation=" + Surface.rotationToString(this.mUpsideDownRotation));
        pw.println(prefix + "  mSupportAutoRotation=" + this.mSupportAutoRotation);
        if (this.mOrientationListener != null) {
            this.mOrientationListener.dump(pw, prefix + "  ");
        }
        pw.println();
        pw.print(prefix + "  mCarDockRotation=" + Surface.rotationToString(this.mCarDockRotation));
        pw.println(" mDeskDockRotation=" + Surface.rotationToString(this.mDeskDockRotation));
        pw.print(prefix + "  mUserRotationMode=" + WindowManagerPolicy.userRotationModeToString(this.mUserRotationMode));
        pw.print(" mUserRotation=" + Surface.rotationToString(this.mUserRotation));
        pw.println(" mAllowAllRotations=" + DisplayRotation.allowAllRotationsToString(this.mAllowAllRotations));
        pw.print(prefix + "  mDemoHdmiRotation=" + Surface.rotationToString(this.mDemoHdmiRotation));
        pw.print(" mDemoHdmiRotationLock=" + this.mDemoHdmiRotationLock);
        pw.println(" mUndockedHdmiRotation=" + Surface.rotationToString(this.mUndockedHdmiRotation));
        pw.println(prefix + "  mLidOpenRotation=" + Surface.rotationToString(this.mLidOpenRotation));
        pw.println(prefix + "  mFixedToUserRotation=" + this.isFixedToUserRotation());
    }

    @VisibleForTesting
    static interface ContentObserverRegister {
        public void registerContentObserver(Uri var1, boolean var2, ContentObserver var3, int var4);
    }

    private class SettingsObserver
    extends ContentObserver {
        SettingsObserver(Handler handler) {
            super(handler);
        }

        void observe() {
            ContentResolver resolver = DisplayRotation.this.mContext.getContentResolver();
            resolver.registerContentObserver(Settings.Secure.getUriFor("show_rotation_suggestions"), false, this, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("accelerometer_rotation"), false, this, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("user_rotation"), false, this, -1);
            DisplayRotation.this.updateSettings();
        }

        @Override
        public void onChange(boolean selfChange) {
            if (DisplayRotation.this.updateSettings()) {
                DisplayRotation.this.mService.updateRotation(true, false);
            }
        }
    }

    private class OrientationListener
    extends WindowOrientationListener {
        final SparseArray<Runnable> mRunnableCache;
        boolean mEnabled;

        OrientationListener(Context context, Handler handler) {
            super(context, handler);
            this.mRunnableCache = new SparseArray(5);
        }

        @Override
        public void onProposedRotationChanged(int rotation) {
            Runnable r = this.mRunnableCache.get(rotation, null);
            if (r == null) {
                r = new UpdateRunnable(rotation);
                this.mRunnableCache.put(rotation, r);
            }
            this.getHandler().post(r);
        }

        @Override
        public void enable(boolean clearCurrentRotation) {
            super.enable(clearCurrentRotation);
            this.mEnabled = true;
        }

        @Override
        public void disable() {
            super.disable();
            this.mEnabled = false;
        }

        private class UpdateRunnable
        implements Runnable {
            final int mRotation;

            UpdateRunnable(int rotation) {
                this.mRotation = rotation;
            }

            @Override
            public void run() {
                ((DisplayRotation)DisplayRotation.this).mService.mPowerManagerInternal.powerHint(2, 0);
                if (DisplayRotation.this.isRotationChoicePossible(DisplayRotation.this.mCurrentAppOrientation)) {
                    boolean isValid = DisplayRotation.this.isValidRotationChoice(this.mRotation);
                    DisplayRotation.this.sendProposedRotationChangeToStatusBarInternal(this.mRotation, isValid);
                } else {
                    DisplayRotation.this.mService.updateRotation(false, false);
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface FixedToUserRotation {
    }
}

