/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.Environment;
import android.provider.Settings;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import android.view.DisplayAddress;
import android.view.DisplayInfo;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.WindowManagerService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class DisplayWindowSettings {
    private static final String TAG = "WindowManager";
    private static final int IDENTIFIER_UNIQUE_ID = 0;
    private static final int IDENTIFIER_PORT = 1;
    private final WindowManagerService mService;
    private final HashMap<String, Entry> mEntries = new HashMap();
    private final SettingPersister mStorage;
    @DisplayIdentifierType
    private int mIdentifier = 0;

    DisplayWindowSettings(WindowManagerService service) {
        this(service, new AtomicFileStorage());
    }

    @VisibleForTesting
    DisplayWindowSettings(WindowManagerService service, SettingPersister storageImpl) {
        this.mService = service;
        this.mStorage = storageImpl;
        this.readSettings();
    }

    private Entry getEntry(DisplayInfo displayInfo) {
        String identifier = this.getIdentifier(displayInfo);
        Entry entry = this.mEntries.get(identifier);
        if (entry != null) {
            return entry;
        }
        entry = this.mEntries.get(displayInfo.name);
        if (entry != null) {
            return this.updateIdentifierForEntry(entry, displayInfo);
        }
        return null;
    }

    private Entry getOrCreateEntry(DisplayInfo displayInfo) {
        Entry entry = this.getEntry(displayInfo);
        return entry != null ? entry : new Entry(this.getIdentifier(displayInfo));
    }

    private Entry updateIdentifierForEntry(Entry entry, DisplayInfo displayInfo) {
        Entry newEntry = new Entry(this.getIdentifier(displayInfo), entry);
        this.removeEntry(displayInfo);
        this.mEntries.put(newEntry.mName, newEntry);
        return newEntry;
    }

    void setOverscanLocked(DisplayInfo displayInfo, int left, int top, int right, int bottom) {
        Entry entry = this.getOrCreateEntry(displayInfo);
        entry.mOverscanLeft = left;
        entry.mOverscanTop = top;
        entry.mOverscanRight = right;
        entry.mOverscanBottom = bottom;
        this.writeSettingsIfNeeded(entry, displayInfo);
    }

    void setUserRotation(DisplayContent displayContent, int rotationMode, int rotation) {
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        Entry entry = this.getOrCreateEntry(displayInfo);
        entry.mUserRotationMode = rotationMode;
        entry.mUserRotation = rotation;
        this.writeSettingsIfNeeded(entry, displayInfo);
    }

    void setForcedSize(DisplayContent displayContent, int width, int height) {
        if (displayContent.isDefaultDisplay) {
            String sizeString = width == 0 || height == 0 ? "" : width + "," + height;
            Settings.Global.putString(this.mService.mContext.getContentResolver(), "display_size_forced", sizeString);
            return;
        }
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        Entry entry = this.getOrCreateEntry(displayInfo);
        entry.mForcedWidth = width;
        entry.mForcedHeight = height;
        this.writeSettingsIfNeeded(entry, displayInfo);
    }

    void setForcedDensity(DisplayContent displayContent, int density, int userId) {
        if (displayContent.isDefaultDisplay) {
            String densityString = density == 0 ? "" : Integer.toString(density);
            Settings.Secure.putStringForUser(this.mService.mContext.getContentResolver(), "display_density_forced", densityString, userId);
            return;
        }
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        Entry entry = this.getOrCreateEntry(displayInfo);
        entry.mForcedDensity = density;
        this.writeSettingsIfNeeded(entry, displayInfo);
    }

    void setForcedScalingMode(DisplayContent displayContent, int mode) {
        if (displayContent.isDefaultDisplay) {
            Settings.Global.putInt(this.mService.mContext.getContentResolver(), "display_scaling_force", mode);
            return;
        }
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        Entry entry = this.getOrCreateEntry(displayInfo);
        entry.mForcedScalingMode = mode;
        this.writeSettingsIfNeeded(entry, displayInfo);
    }

    void setFixedToUserRotation(DisplayContent displayContent, int fixedToUserRotation) {
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        Entry entry = this.getOrCreateEntry(displayInfo);
        entry.mFixedToUserRotation = fixedToUserRotation;
        this.writeSettingsIfNeeded(entry, displayInfo);
    }

    private int getWindowingModeLocked(Entry entry, int displayId) {
        int windowingMode;
        int n = windowingMode = entry != null ? entry.mWindowingMode : 0;
        if (windowingMode == 5 && !this.mService.mSupportsFreeformWindowManagement) {
            return 1;
        }
        if (windowingMode == 0) {
            boolean forceDesktopMode = this.mService.mForceDesktopModeOnExternalDisplays && displayId != 0;
            windowingMode = this.mService.mSupportsFreeformWindowManagement && (this.mService.mIsPc || forceDesktopMode) ? 5 : 1;
        }
        return windowingMode;
    }

    int getWindowingModeLocked(DisplayContent dc) {
        DisplayInfo displayInfo = dc.getDisplayInfo();
        Entry entry = this.getEntry(displayInfo);
        return this.getWindowingModeLocked(entry, dc.getDisplayId());
    }

    void setWindowingModeLocked(DisplayContent dc, int mode) {
        DisplayInfo displayInfo = dc.getDisplayInfo();
        Entry entry = this.getOrCreateEntry(displayInfo);
        entry.mWindowingMode = mode;
        dc.setWindowingMode(mode);
        this.writeSettingsIfNeeded(entry, displayInfo);
    }

    int getRemoveContentModeLocked(DisplayContent dc) {
        DisplayInfo displayInfo = dc.getDisplayInfo();
        Entry entry = this.getEntry(displayInfo);
        if (entry == null || entry.mRemoveContentMode == 0) {
            if (dc.isPrivate()) {
                return 2;
            }
            return 1;
        }
        return entry.mRemoveContentMode;
    }

    void setRemoveContentModeLocked(DisplayContent dc, int mode) {
        DisplayInfo displayInfo = dc.getDisplayInfo();
        Entry entry = this.getOrCreateEntry(displayInfo);
        entry.mRemoveContentMode = mode;
        this.writeSettingsIfNeeded(entry, displayInfo);
    }

    boolean shouldShowWithInsecureKeyguardLocked(DisplayContent dc) {
        DisplayInfo displayInfo = dc.getDisplayInfo();
        Entry entry = this.getEntry(displayInfo);
        if (entry == null) {
            return false;
        }
        return entry.mShouldShowWithInsecureKeyguard;
    }

    void setShouldShowWithInsecureKeyguardLocked(DisplayContent dc, boolean shouldShow) {
        if (!dc.isPrivate() && shouldShow) {
            Slog.e(TAG, "Public display can't be allowed to show content when locked");
            return;
        }
        DisplayInfo displayInfo = dc.getDisplayInfo();
        Entry entry = this.getOrCreateEntry(displayInfo);
        entry.mShouldShowWithInsecureKeyguard = shouldShow;
        this.writeSettingsIfNeeded(entry, displayInfo);
    }

    boolean shouldShowSystemDecorsLocked(DisplayContent dc) {
        if (dc.getDisplayId() == 0) {
            return true;
        }
        DisplayInfo displayInfo = dc.getDisplayInfo();
        Entry entry = this.getEntry(displayInfo);
        if (entry == null) {
            return false;
        }
        return entry.mShouldShowSystemDecors;
    }

    void setShouldShowSystemDecorsLocked(DisplayContent dc, boolean shouldShow) {
        if (dc.getDisplayId() == 0 && !shouldShow) {
            Slog.e(TAG, "Default display should show system decors");
            return;
        }
        DisplayInfo displayInfo = dc.getDisplayInfo();
        Entry entry = this.getOrCreateEntry(displayInfo);
        entry.mShouldShowSystemDecors = shouldShow;
        this.writeSettingsIfNeeded(entry, displayInfo);
    }

    boolean shouldShowImeLocked(DisplayContent dc) {
        if (dc.getDisplayId() == 0) {
            return true;
        }
        DisplayInfo displayInfo = dc.getDisplayInfo();
        Entry entry = this.getEntry(displayInfo);
        if (entry == null) {
            return false;
        }
        return entry.mShouldShowIme;
    }

    void setShouldShowImeLocked(DisplayContent dc, boolean shouldShow) {
        if (dc.getDisplayId() == 0 && !shouldShow) {
            Slog.e(TAG, "Default display should show IME");
            return;
        }
        DisplayInfo displayInfo = dc.getDisplayInfo();
        Entry entry = this.getOrCreateEntry(displayInfo);
        entry.mShouldShowIme = shouldShow;
        this.writeSettingsIfNeeded(entry, displayInfo);
    }

    void applySettingsToDisplayLocked(DisplayContent dc) {
        DisplayInfo displayInfo = dc.getDisplayInfo();
        Entry entry = this.getOrCreateEntry(displayInfo);
        dc.setWindowingMode(this.getWindowingModeLocked(entry, dc.getDisplayId()));
        displayInfo.overscanLeft = entry.mOverscanLeft;
        displayInfo.overscanTop = entry.mOverscanTop;
        displayInfo.overscanRight = entry.mOverscanRight;
        displayInfo.overscanBottom = entry.mOverscanBottom;
        dc.getDisplayRotation().restoreSettings(entry.mUserRotationMode, entry.mUserRotation, entry.mFixedToUserRotation);
        if (entry.mForcedDensity != 0) {
            dc.mBaseDisplayDensity = entry.mForcedDensity;
        }
        if (entry.mForcedWidth != 0 && entry.mForcedHeight != 0) {
            dc.updateBaseDisplayMetrics(entry.mForcedWidth, entry.mForcedHeight, dc.mBaseDisplayDensity);
        }
        dc.mDisplayScalingDisabled = entry.mForcedScalingMode == 1;
    }

    boolean updateSettingsForDisplay(DisplayContent dc) {
        if (dc.getWindowingMode() != this.getWindowingModeLocked(dc)) {
            dc.setWindowingMode(this.getWindowingModeLocked(dc));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSettings() {
        InputStream stream;
        try {
            stream = this.mStorage.openRead();
        }
        catch (IOException e) {
            Slog.i(TAG, "No existing display settings, starting empty");
            return;
        }
        boolean success = false;
        try {
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new IllegalStateException("no start tag found");
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("display")) {
                    this.readDisplay(parser);
                    continue;
                }
                if (tagName.equals("config")) {
                    this.readConfig(parser);
                    continue;
                }
                Slog.w(TAG, "Unknown element under <display-settings>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
            success = true;
        }
        catch (IllegalStateException e) {
            Slog.w(TAG, "Failed parsing " + e);
        }
        catch (NullPointerException e) {
            Slog.w(TAG, "Failed parsing " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "Failed parsing " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "Failed parsing " + e);
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed parsing " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(TAG, "Failed parsing " + e);
        }
        finally {
            if (!success) {
                this.mEntries.clear();
            }
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    private int getIntAttribute(XmlPullParser parser, String name) {
        return this.getIntAttribute(parser, name, 0);
    }

    private int getIntAttribute(XmlPullParser parser, String name, int defaultValue) {
        try {
            String str = parser.getAttributeValue(null, name);
            return str != null ? Integer.parseInt(str) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private boolean getBooleanAttribute(XmlPullParser parser, String name) {
        return this.getBooleanAttribute(parser, name, false);
    }

    private boolean getBooleanAttribute(XmlPullParser parser, String name, boolean defaultValue) {
        try {
            String str = parser.getAttributeValue(null, name);
            return str != null ? Boolean.parseBoolean(str) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private void readDisplay(XmlPullParser parser) throws NumberFormatException, XmlPullParserException, IOException {
        String name = parser.getAttributeValue(null, "name");
        if (name != null) {
            Entry entry = new Entry(name);
            entry.mOverscanLeft = this.getIntAttribute(parser, "overscanLeft");
            entry.mOverscanTop = this.getIntAttribute(parser, "overscanTop");
            entry.mOverscanRight = this.getIntAttribute(parser, "overscanRight");
            entry.mOverscanBottom = this.getIntAttribute(parser, "overscanBottom");
            entry.mWindowingMode = this.getIntAttribute(parser, "windowingMode", 0);
            entry.mUserRotationMode = this.getIntAttribute(parser, "userRotationMode", 0);
            entry.mUserRotation = this.getIntAttribute(parser, "userRotation", 0);
            entry.mForcedWidth = this.getIntAttribute(parser, "forcedWidth");
            entry.mForcedHeight = this.getIntAttribute(parser, "forcedHeight");
            entry.mForcedDensity = this.getIntAttribute(parser, "forcedDensity");
            entry.mForcedScalingMode = this.getIntAttribute(parser, "forcedScalingMode", 0);
            entry.mRemoveContentMode = this.getIntAttribute(parser, "removeContentMode", 0);
            entry.mShouldShowWithInsecureKeyguard = this.getBooleanAttribute(parser, "shouldShowWithInsecureKeyguard");
            entry.mShouldShowSystemDecors = this.getBooleanAttribute(parser, "shouldShowSystemDecors");
            entry.mShouldShowIme = this.getBooleanAttribute(parser, "shouldShowIme");
            entry.mFixedToUserRotation = this.getIntAttribute(parser, "fixedToUserRotation");
            this.mEntries.put(name, entry);
        }
        XmlUtils.skipCurrentTag(parser);
    }

    private void readConfig(XmlPullParser parser) throws NumberFormatException, XmlPullParserException, IOException {
        this.mIdentifier = this.getIntAttribute(parser, "identifier");
        XmlUtils.skipCurrentTag(parser);
    }

    private void writeSettingsIfNeeded(Entry changedEntry, DisplayInfo displayInfo) {
        if (changedEntry.isEmpty() && !this.removeEntry(displayInfo)) {
            return;
        }
        this.mEntries.put(this.getIdentifier(displayInfo), changedEntry);
        this.writeSettings();
    }

    private void writeSettings() {
        OutputStream stream;
        try {
            stream = this.mStorage.startWrite();
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to write display settings: " + e);
            return;
        }
        try {
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(stream, StandardCharsets.UTF_8.name());
            out.startDocument(null, true);
            out.startTag(null, "display-settings");
            out.startTag(null, "config");
            out.attribute(null, "identifier", Integer.toString(this.mIdentifier));
            out.endTag(null, "config");
            for (Entry entry : this.mEntries.values()) {
                out.startTag(null, "display");
                out.attribute(null, "name", entry.mName);
                if (entry.mOverscanLeft != 0) {
                    out.attribute(null, "overscanLeft", Integer.toString(entry.mOverscanLeft));
                }
                if (entry.mOverscanTop != 0) {
                    out.attribute(null, "overscanTop", Integer.toString(entry.mOverscanTop));
                }
                if (entry.mOverscanRight != 0) {
                    out.attribute(null, "overscanRight", Integer.toString(entry.mOverscanRight));
                }
                if (entry.mOverscanBottom != 0) {
                    out.attribute(null, "overscanBottom", Integer.toString(entry.mOverscanBottom));
                }
                if (entry.mWindowingMode != 0) {
                    out.attribute(null, "windowingMode", Integer.toString(entry.mWindowingMode));
                }
                if (entry.mUserRotationMode != 0) {
                    out.attribute(null, "userRotationMode", Integer.toString(entry.mUserRotationMode));
                }
                if (entry.mUserRotation != 0) {
                    out.attribute(null, "userRotation", Integer.toString(entry.mUserRotation));
                }
                if (entry.mForcedWidth != 0 && entry.mForcedHeight != 0) {
                    out.attribute(null, "forcedWidth", Integer.toString(entry.mForcedWidth));
                    out.attribute(null, "forcedHeight", Integer.toString(entry.mForcedHeight));
                }
                if (entry.mForcedDensity != 0) {
                    out.attribute(null, "forcedDensity", Integer.toString(entry.mForcedDensity));
                }
                if (entry.mForcedScalingMode != 0) {
                    out.attribute(null, "forcedScalingMode", Integer.toString(entry.mForcedScalingMode));
                }
                if (entry.mRemoveContentMode != 0) {
                    out.attribute(null, "removeContentMode", Integer.toString(entry.mRemoveContentMode));
                }
                if (entry.mShouldShowWithInsecureKeyguard) {
                    out.attribute(null, "shouldShowWithInsecureKeyguard", Boolean.toString(entry.mShouldShowWithInsecureKeyguard));
                }
                if (entry.mShouldShowSystemDecors) {
                    out.attribute(null, "shouldShowSystemDecors", Boolean.toString(entry.mShouldShowSystemDecors));
                }
                if (entry.mShouldShowIme) {
                    out.attribute(null, "shouldShowIme", Boolean.toString(entry.mShouldShowIme));
                }
                if (entry.mFixedToUserRotation != 0) {
                    out.attribute(null, "fixedToUserRotation", Integer.toString(entry.mFixedToUserRotation));
                }
                out.endTag(null, "display");
            }
            out.endTag(null, "display-settings");
            out.endDocument();
            this.mStorage.finishWrite(stream, true);
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to write display window settings.", e);
            this.mStorage.finishWrite(stream, false);
        }
    }

    private boolean removeEntry(DisplayInfo displayInfo) {
        boolean removed = this.mEntries.remove(this.getIdentifier(displayInfo)) != null;
        removed |= this.mEntries.remove(displayInfo.uniqueId) != null;
        return removed |= this.mEntries.remove(displayInfo.name) != null;
    }

    private String getIdentifier(DisplayInfo displayInfo) {
        if (this.mIdentifier == 1 && displayInfo.address != null && displayInfo.address instanceof DisplayAddress.Physical) {
            return "port:" + ((DisplayAddress.Physical)displayInfo.address).getPort();
        }
        return displayInfo.uniqueId;
    }

    private static class AtomicFileStorage
    implements SettingPersister {
        private final AtomicFile mAtomicFile;

        AtomicFileStorage() {
            File folder = new File(Environment.getDataDirectory(), "system");
            this.mAtomicFile = new AtomicFile(new File(folder, "display_settings.xml"), "wm-displays");
        }

        @Override
        public InputStream openRead() throws FileNotFoundException {
            return this.mAtomicFile.openRead();
        }

        @Override
        public OutputStream startWrite() throws IOException {
            return this.mAtomicFile.startWrite();
        }

        @Override
        public void finishWrite(OutputStream os, boolean success) {
            if (!(os instanceof FileOutputStream)) {
                throw new IllegalArgumentException("Unexpected OutputStream as argument: " + os);
            }
            FileOutputStream fos = (FileOutputStream)os;
            if (success) {
                this.mAtomicFile.finishWrite(fos);
            } else {
                this.mAtomicFile.failWrite(fos);
            }
        }
    }

    private static class Entry {
        private final String mName;
        private int mOverscanLeft;
        private int mOverscanTop;
        private int mOverscanRight;
        private int mOverscanBottom;
        private int mWindowingMode = 0;
        private int mUserRotationMode = 0;
        private int mUserRotation = 0;
        private int mForcedWidth;
        private int mForcedHeight;
        private int mForcedDensity;
        private int mForcedScalingMode = 0;
        private int mRemoveContentMode = 0;
        private boolean mShouldShowWithInsecureKeyguard = false;
        private boolean mShouldShowSystemDecors = false;
        private boolean mShouldShowIme = false;
        private int mFixedToUserRotation = 0;

        private Entry(String name) {
            this.mName = name;
        }

        private Entry(String name, Entry copyFrom) {
            this(name);
            this.mOverscanLeft = copyFrom.mOverscanLeft;
            this.mOverscanTop = copyFrom.mOverscanTop;
            this.mOverscanRight = copyFrom.mOverscanRight;
            this.mOverscanBottom = copyFrom.mOverscanBottom;
            this.mWindowingMode = copyFrom.mWindowingMode;
            this.mUserRotationMode = copyFrom.mUserRotationMode;
            this.mUserRotation = copyFrom.mUserRotation;
            this.mForcedWidth = copyFrom.mForcedWidth;
            this.mForcedHeight = copyFrom.mForcedHeight;
            this.mForcedDensity = copyFrom.mForcedDensity;
            this.mForcedScalingMode = copyFrom.mForcedScalingMode;
            this.mRemoveContentMode = copyFrom.mRemoveContentMode;
            this.mShouldShowWithInsecureKeyguard = copyFrom.mShouldShowWithInsecureKeyguard;
            this.mShouldShowSystemDecors = copyFrom.mShouldShowSystemDecors;
            this.mShouldShowIme = copyFrom.mShouldShowIme;
            this.mFixedToUserRotation = copyFrom.mFixedToUserRotation;
        }

        private boolean isEmpty() {
            return this.mOverscanLeft == 0 && this.mOverscanTop == 0 && this.mOverscanRight == 0 && this.mOverscanBottom == 0 && this.mWindowingMode == 0 && this.mUserRotationMode == 0 && this.mUserRotation == 0 && this.mForcedWidth == 0 && this.mForcedHeight == 0 && this.mForcedDensity == 0 && this.mForcedScalingMode == 0 && this.mRemoveContentMode == 0 && !this.mShouldShowWithInsecureKeyguard && !this.mShouldShowSystemDecors && !this.mShouldShowIme && this.mFixedToUserRotation == 0;
        }
    }

    static interface SettingPersister {
        public InputStream openRead() throws IOException;

        public OutputStream startWrite() throws IOException;

        public void finishWrite(OutputStream var1, boolean var2);
    }

    static @interface DisplayIdentifierType {
    }
}

