/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.ClipData;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Slog;
import android.view.IWindow;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import com.android.internal.util.Preconditions;
import com.android.server.wm.DragState;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerInternal;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.util.concurrent.atomic.AtomicReference;

class DragDropController {
    private static final float DRAG_SHADOW_ALPHA_TRANSPARENT = 0.7071f;
    private static final long DRAG_TIMEOUT_MS = 5000L;
    static final int MSG_DRAG_END_TIMEOUT = 0;
    static final int MSG_TEAR_DOWN_DRAG_AND_DROP_INPUT = 1;
    static final int MSG_ANIMATION_END = 2;
    private DragState mDragState;
    private WindowManagerService mService;
    private final Handler mHandler;
    private AtomicReference<WindowManagerInternal.IDragDropCallback> mCallback = new AtomicReference<1>(new WindowManagerInternal.IDragDropCallback(){});

    boolean dragDropActiveLocked() {
        return this.mDragState != null && !this.mDragState.isClosing();
    }

    void registerCallback(WindowManagerInternal.IDragDropCallback callback) {
        Preconditions.checkNotNull(callback);
        this.mCallback.set(callback);
    }

    DragDropController(WindowManagerService service, Looper looper) {
        this.mService = service;
        this.mHandler = new DragHandler(service, looper);
    }

    void sendDragStartedIfNeededLocked(WindowState window) {
        this.mDragState.sendDragStartedIfNeededLocked(window);
    }

    /*
     * Exception decompiling
     */
    IBinder performDrag(SurfaceSession session, int callerPid, int callerUid, IWindow window, int flags, SurfaceControl surface, int touchSource, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void reportDropResult(IWindow window, boolean consumed) {
        block11: {
            IBinder token;
            block10: {
                token = window.asBinder();
                this.mCallback.get().preReportDropResult(window, consumed);
                WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
                // MONITORENTER : windowManagerGlobalLock
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (this.mDragState != null) break block10;
                    Slog.w("WindowManager", "Drop result given but no drag in progress");
                    // MONITOREXIT : windowManagerGlobalLock
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowManagerGlobalLock
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                this.mCallback.get().postReportDropResult();
                return;
            }
            if (this.mDragState.mToken != token) {
                Slog.w("WindowManager", "Invalid drop-result claim by " + window);
                throw new IllegalStateException("reportDropResult() by non-recipient");
            }
            this.mHandler.removeMessages(0, window.asBinder());
            WindowState callingWin = this.mService.windowForClientLocked(null, window, false);
            if (callingWin != null) break block11;
            Slog.w("WindowManager", "Bad result-reporting window " + window);
            // MONITOREXIT : windowManagerGlobalLock
            WindowManagerService.resetPriorityAfterLockedSection();
            this.mCallback.get().postReportDropResult();
            return;
        }
        this.mDragState.mDragResult = consumed;
        this.mDragState.endDragLocked();
        // MONITOREXIT : windowManagerGlobalLock
        WindowManagerService.resetPriorityAfterLockedSection();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void cancelDragAndDrop(IBinder dragToken, boolean skipAnimation) {
        this.mCallback.get().preCancelDragAndDrop(dragToken);
        try {
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            synchronized (windowManagerGlobalLock) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (this.mDragState == null) {
                        Slog.w("WindowManager", "cancelDragAndDrop() without prepareDrag()");
                        throw new IllegalStateException("cancelDragAndDrop() without prepareDrag()");
                    }
                    if (this.mDragState.mToken != dragToken) {
                        Slog.w("WindowManager", "cancelDragAndDrop() does not match prepareDrag()");
                        throw new IllegalStateException("cancelDragAndDrop() does not match prepareDrag()");
                    }
                    this.mDragState.mDragResult = false;
                    this.mDragState.cancelDragLocked(skipAnimation);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl20 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        finally {
            this.mCallback.get().postCancelDragAndDrop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void handleMotionEvent(boolean keepHandling, float newX, float newY) {
        block6: {
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            // MONITORENTER : windowManagerGlobalLock
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.dragDropActiveLocked()) break block6;
                // MONITOREXIT : windowManagerGlobalLock
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        if (keepHandling) {
            this.mDragState.notifyMoveLocked(newX, newY);
        } else {
            this.mDragState.notifyDropLocked(newX, newY);
        }
        // MONITOREXIT : windowManagerGlobalLock
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void dragRecipientEntered(IWindow window) {
    }

    void dragRecipientExited(IWindow window) {
    }

    void sendHandlerMessage(int what, Object arg) {
        this.mHandler.obtainMessage(what, arg).sendToTarget();
    }

    void sendTimeoutMessage(int what, Object arg) {
        this.mHandler.removeMessages(what, arg);
        Message msg = this.mHandler.obtainMessage(what, arg);
        this.mHandler.sendMessageDelayed(msg, 5000L);
    }

    void onDragStateClosedLocked(DragState dragState) {
        if (this.mDragState != dragState) {
            Slog.wtf("WindowManager", "Unknown drag state is closed");
            return;
        }
        this.mDragState = null;
    }

    static /* synthetic */ DragState access$000(DragDropController x0) {
        return x0.mDragState;
    }

    private class DragHandler
    extends Handler {
        private final WindowManagerService mService;

        DragHandler(WindowManagerService service, Looper looper) {
            super(looper);
            this.mService = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    win = (IBinder)msg.obj;
                    var3_5 = this.mService.mGlobalLock;
                    synchronized (var3_5) {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (DragDropController.access$000(DragDropController.this) != null) {
                            DragDropController.access$000((DragDropController)DragDropController.this).mDragResult = false;
                            DragDropController.access$000(DragDropController.this).endDragLocked();
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var4_7) {
                            // MONITOREXIT @DISABLED, blocks:[5, 7, 8, 12] lbl15 : MonitorExitStatement: MONITOREXIT : var3_5
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var4_7;
                        }
                    }
                }
                case 1: {
                    interceptor = (DragState.InputInterceptor)msg.obj;
                    if (interceptor == null) {
                        return;
                    }
                    var3_6 = this.mService.mGlobalLock;
                    synchronized (var3_6) {
                        WindowManagerService.boostPriorityForLockedSection();
                        interceptor.tearDown();
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var5_8) {
                            // MONITOREXIT @DISABLED, blocks:[6, 7, 9, 13] lbl31 : MonitorExitStatement: MONITOREXIT : var3_6
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var5_8;
                        }
                    }
                }
                case 2: {
                    var2_4 = this.mService.mGlobalLock;
                    synchronized (var2_4) {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (DragDropController.access$000(DragDropController.this) != null) ** GOTO lbl-1000
                        Slog.wtf("WindowManager", "mDragState unexpectedly became null while plyaing animation");
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        DragDropController.access$000(DragDropController.this).closeLocked();
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    break;
                    {
                        catch (Throwable var6_9) {
                            // MONITOREXIT @DISABLED, blocks:[4, 7, 10, 14] lbl51 : MonitorExitStatement: MONITOREXIT : var2_4
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw var6_9;
                        }
                    }
                }
            }
        }
    }
}

