/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.animation.Animator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.content.ClipData;
import android.content.ClipDescription;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.input.InputManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManagerInternal;
import android.util.Slog;
import android.view.Display;
import android.view.DragEvent;
import android.view.InputApplicationHandle;
import android.view.InputChannel;
import android.view.InputWindowHandle;
import android.view.SurfaceControl;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.android.internal.view.IDragAndDropPermissions;
import com.android.server.LocalServices;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DragAndDropPermissionsHandler;
import com.android.server.wm.DragDropController;
import com.android.server.wm.DragInputEventReceiver;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.util.ArrayList;

class DragState {
    private static final long MIN_ANIMATION_DURATION_MS = 195L;
    private static final long MAX_ANIMATION_DURATION_MS = 375L;
    private static final int DRAG_FLAGS_URI_ACCESS = 3;
    private static final int DRAG_FLAGS_URI_PERMISSIONS = 195;
    private static final String ANIMATED_PROPERTY_X = "x";
    private static final String ANIMATED_PROPERTY_Y = "y";
    private static final String ANIMATED_PROPERTY_ALPHA = "alpha";
    private static final String ANIMATED_PROPERTY_SCALE = "scale";
    final WindowManagerService mService;
    final DragDropController mDragDropController;
    IBinder mToken;
    SurfaceControl mSurfaceControl;
    int mFlags;
    IBinder mLocalWin;
    int mPid;
    int mUid;
    int mSourceUserId;
    boolean mCrossProfileCopyAllowed;
    ClipData mData;
    ClipDescription mDataDescription;
    int mTouchSource;
    boolean mDragResult;
    float mOriginalAlpha;
    float mOriginalX;
    float mOriginalY;
    float mCurrentX;
    float mCurrentY;
    float mThumbOffsetX;
    float mThumbOffsetY;
    InputInterceptor mInputInterceptor;
    WindowState mTargetWindow;
    ArrayList<WindowState> mNotifiedWindows;
    boolean mDragInProgress;
    volatile boolean mAnimationCompleted = false;
    DisplayContent mDisplayContent;
    private ValueAnimator mAnimator;
    private final Interpolator mCubicEaseOutInterpolator = new DecelerateInterpolator(1.5f);
    private Point mDisplaySize = new Point();
    SurfaceControl mInputSurface;
    private final SurfaceControl.Transaction mTransaction;
    private final Rect mTmpClipRect = new Rect();
    private boolean mIsClosing;
    IBinder mTransferTouchFromToken;

    DragState(WindowManagerService service, DragDropController controller, IBinder token, SurfaceControl surface, int flags, IBinder localWin) {
        this.mService = service;
        this.mDragDropController = controller;
        this.mToken = token;
        this.mSurfaceControl = surface;
        this.mFlags = flags;
        this.mLocalWin = localWin;
        this.mNotifiedWindows = new ArrayList();
        this.mTransaction = service.mTransactionFactory.make();
    }

    boolean isClosing() {
        return this.mIsClosing;
    }

    private void hideInputSurface() {
        if (this.mInputSurface != null) {
            this.mTransaction.hide(this.mInputSurface).apply();
        }
    }

    private void showInputSurface() {
        InputWindowHandle h;
        if (this.mInputSurface == null) {
            this.mInputSurface = this.mService.makeSurfaceBuilder(this.mService.mRoot.getDisplayContent(this.mDisplayContent.getDisplayId()).getSession()).setContainerLayer().setName("Drag and Drop Input Consumer").build();
        }
        if ((h = this.getInputWindowHandle()) == null) {
            Slog.w("WindowManager", "Drag is in progress but there is no drag window handle.");
            return;
        }
        this.mTransaction.show(this.mInputSurface);
        this.mTransaction.setInputWindowInfo(this.mInputSurface, h);
        this.mTransaction.setLayer(this.mInputSurface, Integer.MAX_VALUE);
        this.mTmpClipRect.set(0, 0, this.mDisplaySize.x, this.mDisplaySize.y);
        this.mTransaction.setWindowCrop(this.mInputSurface, this.mTmpClipRect);
        this.mTransaction.transferTouchFocus(this.mTransferTouchFromToken, h.token);
        this.mTransferTouchFromToken = null;
        this.mTransaction.syncInputWindows();
        this.mTransaction.apply();
    }

    void closeLocked() {
        this.mIsClosing = true;
        if (this.mInputInterceptor != null) {
            this.mDragDropController.sendHandlerMessage(1, this.mInputInterceptor);
            this.mInputInterceptor = null;
        }
        this.hideInputSurface();
        if (this.mDragInProgress) {
            int myPid = Process.myPid();
            for (WindowState ws : this.mNotifiedWindows) {
                float x = 0.0f;
                float y = 0.0f;
                if (!this.mDragResult && ws.mSession.mPid == this.mPid) {
                    x = this.mCurrentX;
                    y = this.mCurrentY;
                }
                DragEvent evt = DragEvent.obtain(4, x, y, null, null, null, null, this.mDragResult);
                try {
                    ws.mClient.dispatchDragEvent(evt);
                }
                catch (RemoteException e) {
                    Slog.w("WindowManager", "Unable to drag-end window " + ws);
                }
                if (myPid == ws.mSession.mPid) continue;
                evt.recycle();
            }
            this.mNotifiedWindows.clear();
            this.mDragInProgress = false;
        }
        if (this.isFromSource(8194)) {
            this.mService.restorePointerIconLocked(this.mDisplayContent, this.mCurrentX, this.mCurrentY);
            this.mTouchSource = 0;
        }
        if (this.mSurfaceControl != null) {
            this.mTransaction.reparent(this.mSurfaceControl, null).apply();
            this.mSurfaceControl = null;
        }
        if (this.mAnimator != null && !this.mAnimationCompleted) {
            Slog.wtf("WindowManager", "Unexpectedly destroying mSurfaceControl while animation is running");
        }
        this.mFlags = 0;
        this.mLocalWin = null;
        this.mToken = null;
        this.mData = null;
        this.mThumbOffsetY = 0.0f;
        this.mThumbOffsetX = 0.0f;
        this.mNotifiedWindows = null;
        this.mDragDropController.onDragStateClosedLocked(this);
    }

    InputChannel getInputChannel() {
        return this.mInputInterceptor == null ? null : this.mInputInterceptor.mServerChannel;
    }

    InputWindowHandle getInputWindowHandle() {
        return this.mInputInterceptor == null ? null : this.mInputInterceptor.mDragWindowHandle;
    }

    void register(Display display) {
        display.getRealSize(this.mDisplaySize);
        if (this.mInputInterceptor != null) {
            Slog.e("WindowManager", "Duplicate register of drag input channel");
        } else {
            this.mInputInterceptor = new InputInterceptor(display);
            this.showInputSurface();
        }
    }

    int getDragLayerLocked() {
        return this.mService.mPolicy.getWindowLayerFromTypeLw(2016) * 10000 + 1000;
    }

    void broadcastDragStartedLocked(float touchX, float touchY) {
        this.mOriginalX = this.mCurrentX = touchX;
        this.mOriginalY = this.mCurrentY = touchY;
        this.mDataDescription = this.mData != null ? this.mData.getDescription() : null;
        this.mNotifiedWindows.clear();
        this.mDragInProgress = true;
        this.mSourceUserId = UserHandle.getUserId(this.mUid);
        UserManagerInternal userManager = LocalServices.getService(UserManagerInternal.class);
        this.mCrossProfileCopyAllowed = !userManager.getUserRestriction(this.mSourceUserId, "no_cross_profile_copy_paste");
        this.mDisplayContent.forAllWindows(w -> this.sendDragStartedLocked((WindowState)w, touchX, touchY, this.mDataDescription), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDragStartedLocked(WindowState newWin, float touchX, float touchY, ClipDescription desc) {
        if (this.mDragInProgress && this.isValidDropTarget(newWin)) {
            DragEvent event = DragState.obtainDragEvent(newWin, 1, touchX, touchY, null, desc, null, null, false);
            try {
                newWin.mClient.dispatchDragEvent(event);
                this.mNotifiedWindows.add(newWin);
            }
            catch (RemoteException e) {
                Slog.w("WindowManager", "Unable to drag-start window " + newWin);
            }
            finally {
                if (Process.myPid() != newWin.mSession.mPid) {
                    event.recycle();
                }
            }
        }
    }

    private boolean isValidDropTarget(WindowState targetWin) {
        if (targetWin == null) {
            return false;
        }
        if (!targetWin.isPotentialDragTarget()) {
            return false;
        }
        if (!((this.mFlags & 0x100) != 0 && this.targetWindowSupportsGlobalDrag(targetWin) || this.mLocalWin == targetWin.mClient.asBinder())) {
            return false;
        }
        return this.mCrossProfileCopyAllowed || this.mSourceUserId == UserHandle.getUserId(targetWin.getOwningUid());
    }

    private boolean targetWindowSupportsGlobalDrag(WindowState targetWin) {
        return targetWin.mAppToken == null || targetWin.mAppToken.mTargetSdk >= 24;
    }

    void sendDragStartedIfNeededLocked(WindowState newWin) {
        if (this.mDragInProgress) {
            if (this.isWindowNotified(newWin)) {
                return;
            }
            this.sendDragStartedLocked(newWin, this.mCurrentX, this.mCurrentY, this.mDataDescription);
        }
    }

    private boolean isWindowNotified(WindowState newWin) {
        for (WindowState ws : this.mNotifiedWindows) {
            if (ws != newWin) continue;
            return true;
        }
        return false;
    }

    void endDragLocked() {
        if (this.mAnimator != null) {
            return;
        }
        if (!this.mDragResult) {
            this.mAnimator = this.createReturnAnimationLocked();
            return;
        }
        this.closeLocked();
    }

    void cancelDragLocked(boolean skipAnimation) {
        if (this.mAnimator != null) {
            return;
        }
        if (!this.mDragInProgress || skipAnimation) {
            this.closeLocked();
            return;
        }
        this.mAnimator = this.createCancelAnimationLocked();
    }

    void notifyMoveLocked(float x, float y) {
        if (this.mAnimator != null) {
            return;
        }
        this.mCurrentX = x;
        this.mCurrentY = y;
        this.mTransaction.setPosition(this.mSurfaceControl, x - this.mThumbOffsetX, y - this.mThumbOffsetY).apply();
        this.notifyLocationLocked(x, y);
    }

    void notifyLocationLocked(float x, float y) {
        WindowState touchedWin = this.mDisplayContent.getTouchableWinAtPointLocked(x, y);
        if (touchedWin != null && !this.isWindowNotified(touchedWin)) {
            touchedWin = null;
        }
        try {
            DragEvent evt;
            int myPid = Process.myPid();
            if (touchedWin != this.mTargetWindow && this.mTargetWindow != null) {
                evt = DragState.obtainDragEvent(this.mTargetWindow, 6, 0.0f, 0.0f, null, null, null, null, false);
                this.mTargetWindow.mClient.dispatchDragEvent(evt);
                if (myPid != this.mTargetWindow.mSession.mPid) {
                    evt.recycle();
                }
            }
            if (touchedWin != null) {
                evt = DragState.obtainDragEvent(touchedWin, 2, x, y, null, null, null, null, false);
                touchedWin.mClient.dispatchDragEvent(evt);
                if (myPid != touchedWin.mSession.mPid) {
                    evt.recycle();
                }
            }
        }
        catch (RemoteException e) {
            Slog.w("WindowManager", "can't send drag notification to windows");
        }
        this.mTargetWindow = touchedWin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDropLocked(float x, float y) {
        if (this.mAnimator != null) {
            return;
        }
        this.mCurrentX = x;
        this.mCurrentY = y;
        WindowState touchedWin = this.mDisplayContent.getTouchableWinAtPointLocked(x, y);
        if (!this.isWindowNotified(touchedWin)) {
            this.mDragResult = false;
            this.endDragLocked();
            return;
        }
        int targetUserId = UserHandle.getUserId(touchedWin.getOwningUid());
        DragAndDropPermissionsHandler dragAndDropPermissions = (this.mFlags & 0x100) != 0 && (this.mFlags & 3) != 0 && this.mData != null ? new DragAndDropPermissionsHandler(this.mData, this.mUid, touchedWin.getOwningPackage(), this.mFlags & 0xC3, this.mSourceUserId, targetUserId) : null;
        if (this.mSourceUserId != targetUserId && this.mData != null) {
            this.mData.fixUris(this.mSourceUserId);
        }
        int myPid = Process.myPid();
        IBinder token = touchedWin.mClient.asBinder();
        DragEvent evt = DragState.obtainDragEvent(touchedWin, 3, x, y, null, null, this.mData, dragAndDropPermissions, false);
        try {
            touchedWin.mClient.dispatchDragEvent(evt);
            this.mDragDropController.sendTimeoutMessage(0, token);
        }
        catch (RemoteException e) {
            Slog.w("WindowManager", "can't send drop notification to win " + touchedWin);
            this.endDragLocked();
        }
        finally {
            if (myPid != touchedWin.mSession.mPid) {
                evt.recycle();
            }
        }
        this.mToken = token;
    }

    boolean isInProgress() {
        return this.mDragInProgress;
    }

    private static DragEvent obtainDragEvent(WindowState win, int action, float x, float y, Object localState, ClipDescription description, ClipData data, IDragAndDropPermissions dragAndDropPermissions, boolean result) {
        float winX = win.translateToWindowX(x);
        float winY = win.translateToWindowY(y);
        return DragEvent.obtain(action, winX, winY, localState, description, data, dragAndDropPermissions, result);
    }

    private ValueAnimator createReturnAnimationLocked() {
        ValueAnimator animator2 = ValueAnimator.ofPropertyValuesHolder(PropertyValuesHolder.ofFloat(ANIMATED_PROPERTY_X, this.mCurrentX - this.mThumbOffsetX, this.mOriginalX - this.mThumbOffsetX), PropertyValuesHolder.ofFloat(ANIMATED_PROPERTY_Y, this.mCurrentY - this.mThumbOffsetY, this.mOriginalY - this.mThumbOffsetY), PropertyValuesHolder.ofFloat(ANIMATED_PROPERTY_SCALE, 1.0f, 1.0f), PropertyValuesHolder.ofFloat(ANIMATED_PROPERTY_ALPHA, this.mOriginalAlpha, this.mOriginalAlpha / 2.0f));
        float translateX = this.mOriginalX - this.mCurrentX;
        float translateY = this.mOriginalY - this.mCurrentY;
        double travelDistance = Math.sqrt(translateX * translateX + translateY * translateY);
        double displayDiagonal = Math.sqrt(this.mDisplaySize.x * this.mDisplaySize.x + this.mDisplaySize.y * this.mDisplaySize.y);
        long duration = 195L + (long)(travelDistance / displayDiagonal * 180.0);
        AnimationListener listener = new AnimationListener();
        animator2.setDuration(duration);
        animator2.setInterpolator(this.mCubicEaseOutInterpolator);
        animator2.addListener(listener);
        animator2.addUpdateListener(listener);
        this.mService.mAnimationHandler.post(() -> animator2.start());
        return animator2;
    }

    private ValueAnimator createCancelAnimationLocked() {
        ValueAnimator animator2 = ValueAnimator.ofPropertyValuesHolder(PropertyValuesHolder.ofFloat(ANIMATED_PROPERTY_X, this.mCurrentX - this.mThumbOffsetX, this.mCurrentX), PropertyValuesHolder.ofFloat(ANIMATED_PROPERTY_Y, this.mCurrentY - this.mThumbOffsetY, this.mCurrentY), PropertyValuesHolder.ofFloat(ANIMATED_PROPERTY_SCALE, 1.0f, 0.0f), PropertyValuesHolder.ofFloat(ANIMATED_PROPERTY_ALPHA, this.mOriginalAlpha, 0.0f));
        AnimationListener listener = new AnimationListener();
        animator2.setDuration(195L);
        animator2.setInterpolator(this.mCubicEaseOutInterpolator);
        animator2.addListener(listener);
        animator2.addUpdateListener(listener);
        this.mService.mAnimationHandler.post(() -> animator2.start());
        return animator2;
    }

    private boolean isFromSource(int source) {
        return (this.mTouchSource & source) == source;
    }

    void overridePointerIconLocked(int touchSource) {
        this.mTouchSource = touchSource;
        if (this.isFromSource(8194)) {
            InputManager.getInstance().setPointerIconType(1021);
        }
    }

    private class AnimationListener
    implements ValueAnimator.AnimatorUpdateListener,
    Animator.AnimatorListener {
        private AnimationListener() {
        }

        @Override
        public void onAnimationUpdate(ValueAnimator animation) {
            try (SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();){
                transaction.setPosition(DragState.this.mSurfaceControl, ((Float)animation.getAnimatedValue(DragState.ANIMATED_PROPERTY_X)).floatValue(), ((Float)animation.getAnimatedValue(DragState.ANIMATED_PROPERTY_Y)).floatValue());
                transaction.setAlpha(DragState.this.mSurfaceControl, ((Float)animation.getAnimatedValue(DragState.ANIMATED_PROPERTY_ALPHA)).floatValue());
                transaction.setMatrix(DragState.this.mSurfaceControl, ((Float)animation.getAnimatedValue(DragState.ANIMATED_PROPERTY_SCALE)).floatValue(), 0.0f, 0.0f, ((Float)animation.getAnimatedValue(DragState.ANIMATED_PROPERTY_SCALE)).floatValue());
                transaction.apply();
            }
        }

        @Override
        public void onAnimationStart(Animator animator2) {
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            DragState.this.mAnimationCompleted = true;
            DragState.this.mDragDropController.sendHandlerMessage(2, null);
        }
    }

    class InputInterceptor {
        InputChannel mServerChannel;
        InputChannel mClientChannel;
        DragInputEventReceiver mInputEventReceiver;
        InputApplicationHandle mDragApplicationHandle;
        InputWindowHandle mDragWindowHandle;

        InputInterceptor(Display display) {
            InputChannel[] channels = InputChannel.openInputChannelPair("drag");
            this.mServerChannel = channels[0];
            this.mClientChannel = channels[1];
            DragState.this.mService.mInputManager.registerInputChannel(this.mServerChannel, null);
            this.mInputEventReceiver = new DragInputEventReceiver(this.mClientChannel, DragState.this.mService.mH.getLooper(), DragState.this.mDragDropController);
            this.mDragApplicationHandle = new InputApplicationHandle(new Binder());
            this.mDragApplicationHandle.name = "drag";
            this.mDragApplicationHandle.dispatchingTimeoutNanos = 5000000000L;
            this.mDragWindowHandle = new InputWindowHandle(this.mDragApplicationHandle, null, display.getDisplayId());
            this.mDragWindowHandle.name = "drag";
            this.mDragWindowHandle.token = this.mServerChannel.getToken();
            this.mDragWindowHandle.layer = DragState.this.getDragLayerLocked();
            this.mDragWindowHandle.layoutParamsFlags = 0;
            this.mDragWindowHandle.layoutParamsType = 2016;
            this.mDragWindowHandle.dispatchingTimeoutNanos = 5000000000L;
            this.mDragWindowHandle.visible = true;
            this.mDragWindowHandle.canReceiveKeys = false;
            this.mDragWindowHandle.hasFocus = true;
            this.mDragWindowHandle.hasWallpaper = false;
            this.mDragWindowHandle.paused = false;
            this.mDragWindowHandle.ownerPid = Process.myPid();
            this.mDragWindowHandle.ownerUid = Process.myUid();
            this.mDragWindowHandle.inputFeatures = 0;
            this.mDragWindowHandle.scaleFactor = 1.0f;
            this.mDragWindowHandle.touchableRegion.setEmpty();
            this.mDragWindowHandle.frameLeft = 0;
            this.mDragWindowHandle.frameTop = 0;
            this.mDragWindowHandle.frameRight = ((DragState)DragState.this).mDisplaySize.x;
            this.mDragWindowHandle.frameBottom = ((DragState)DragState.this).mDisplaySize.y;
            DragState.this.mDisplayContent.pauseRotationLocked();
        }

        void tearDown() {
            DragState.this.mService.mInputManager.unregisterInputChannel(this.mServerChannel);
            this.mInputEventReceiver.dispose();
            this.mInputEventReceiver = null;
            this.mClientChannel.dispose();
            this.mServerChannel.dispose();
            this.mClientChannel = null;
            this.mServerChannel = null;
            this.mDragWindowHandle = null;
            this.mDragApplicationHandle = null;
            DragState.this.mDisplayContent.resumeRotationLocked();
        }
    }
}

