/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.SystemProperties;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;

class HighRefreshRateBlacklist {
    private static final String SYSPROP_KEY = "ro.window_manager.high_refresh_rate_blacklist";
    private static final String SYSPROP_KEY_LENGTH_SUFFIX = "_length";
    private static final String SYSPROP_KEY_ENTRY_SUFFIX = "_entry";
    private static final int MAX_ENTRIES = 50;
    private ArraySet<String> mBlacklistedPackages = new ArraySet();

    static HighRefreshRateBlacklist create() {
        return new HighRefreshRateBlacklist(new SystemPropertyGetter(){

            @Override
            public int getInt(String key, int def) {
                return SystemProperties.getInt(key, def);
            }

            @Override
            public String get(String key) {
                return SystemProperties.get(key);
            }
        });
    }

    @VisibleForTesting
    HighRefreshRateBlacklist(SystemPropertyGetter propertyGetter) {
        int length = Math.min(propertyGetter.getInt("ro.window_manager.high_refresh_rate_blacklist_length", 0), 50);
        for (int i = 1; i <= length; ++i) {
            String packageName = propertyGetter.get("ro.window_manager.high_refresh_rate_blacklist_entry" + i);
            if (packageName.isEmpty()) continue;
            this.mBlacklistedPackages.add(packageName);
        }
    }

    boolean isBlacklisted(String packageName) {
        return this.mBlacklistedPackages.contains(packageName);
    }

    static interface SystemPropertyGetter {
        public int getInt(String var1, int var2);

        public String get(String var1);
    }
}

