/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.animation.ArgbEvaluator;
import android.animation.ValueAnimator;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.ContextImpl;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.ColorDrawable;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.UserManager;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.Button;
import android.widget.FrameLayout;
import com.android.server.wm.PolicyControl;

public class ImmersiveModeConfirmation {
    private static final String TAG = "ImmersiveModeConfirmation";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_SHOW_EVERY_TIME = false;
    private static final String CONFIRMED = "confirmed";
    private static boolean sConfirmed;
    private final Context mContext;
    private final H mHandler;
    private final long mShowDelayMs;
    private final long mPanicThresholdMs;
    private final IBinder mWindowToken = new Binder();
    private ClingWindowView mClingWindow;
    private long mPanicTime;
    private WindowManager mWindowManager;
    private boolean mVrModeEnabled;
    private int mLockTaskState = 0;
    private final Runnable mConfirm = new Runnable(){

        @Override
        public void run() {
            if (!sConfirmed) {
                sConfirmed = true;
                ImmersiveModeConfirmation.saveSetting(ImmersiveModeConfirmation.this.mContext);
            }
            ImmersiveModeConfirmation.this.handleHide();
        }
    };

    ImmersiveModeConfirmation(Context context, Looper looper, boolean vrModeEnabled) {
        Display display = context.getDisplay();
        ContextImpl uiContext = ActivityThread.currentActivityThread().getSystemUiContext();
        this.mContext = display.getDisplayId() == 0 ? uiContext : ((Context)uiContext).createDisplayContext(display);
        this.mHandler = new H(looper);
        this.mShowDelayMs = this.getNavBarExitDuration() * 3L;
        this.mPanicThresholdMs = context.getResources().getInteger(17694813);
        this.mVrModeEnabled = vrModeEnabled;
    }

    private long getNavBarExitDuration() {
        Animation exit = AnimationUtils.loadAnimation(this.mContext, 17432750);
        return exit != null ? exit.getDuration() : 0L;
    }

    static boolean loadSetting(int currentUserId, Context context) {
        boolean wasConfirmed = sConfirmed;
        sConfirmed = false;
        String value = null;
        try {
            value = Settings.Secure.getStringForUser(context.getContentResolver(), "immersive_mode_confirmations", -2);
            sConfirmed = CONFIRMED.equals(value);
        }
        catch (Throwable t) {
            Slog.w(TAG, "Error loading confirmations, value=" + value, t);
        }
        return sConfirmed != wasConfirmed;
    }

    private static void saveSetting(Context context) {
        try {
            String value = sConfirmed ? CONFIRMED : null;
            Settings.Secure.putStringForUser(context.getContentResolver(), "immersive_mode_confirmations", value, -2);
        }
        catch (Throwable t) {
            Slog.w(TAG, "Error saving confirmations, sConfirmed=" + sConfirmed, t);
        }
    }

    void immersiveModeChangedLw(String pkg, boolean isImmersiveMode, boolean userSetupComplete, boolean navBarEmpty) {
        this.mHandler.removeMessages(1);
        if (isImmersiveMode) {
            boolean disabled = PolicyControl.disableImmersiveConfirmation(pkg);
            if (!(disabled || sConfirmed || !userSetupComplete || this.mVrModeEnabled || navBarEmpty || UserManager.isDeviceInDemoMode(this.mContext) || this.mLockTaskState == 1)) {
                this.mHandler.sendEmptyMessageDelayed(1, this.mShowDelayMs);
            }
        } else {
            this.mHandler.sendEmptyMessage(2);
        }
    }

    boolean onPowerKeyDown(boolean isScreenOn, long time, boolean inImmersiveMode, boolean navBarEmpty) {
        if (!isScreenOn && time - this.mPanicTime < this.mPanicThresholdMs) {
            return this.mClingWindow == null;
        }
        this.mPanicTime = isScreenOn && inImmersiveMode && !navBarEmpty ? time : 0L;
        return false;
    }

    void confirmCurrentPrompt() {
        if (this.mClingWindow != null) {
            this.mHandler.post(this.mConfirm);
        }
    }

    private void handleHide() {
        if (this.mClingWindow != null) {
            this.getWindowManager().removeView(this.mClingWindow);
            this.mClingWindow = null;
        }
    }

    private WindowManager.LayoutParams getClingWindowLayoutParams() {
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(-1, -1, 2014, 0x1000120, -3);
        lp.privateFlags |= 0x10;
        lp.setTitle(TAG);
        lp.windowAnimations = 16974586;
        lp.token = this.getWindowToken();
        return lp;
    }

    private FrameLayout.LayoutParams getBubbleLayoutParams() {
        return new FrameLayout.LayoutParams(this.mContext.getResources().getDimensionPixelSize(17105194), -2, 49);
    }

    IBinder getWindowToken() {
        return this.mWindowToken;
    }

    private WindowManager getWindowManager() {
        if (this.mWindowManager == null) {
            this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        }
        return this.mWindowManager;
    }

    private void handleShow() {
        this.mClingWindow = new ClingWindowView(this.mContext, this.mConfirm);
        this.mClingWindow.setSystemUiVisibility(768);
        WindowManager.LayoutParams lp = this.getClingWindowLayoutParams();
        this.getWindowManager().addView(this.mClingWindow, lp);
    }

    void onVrStateChangedLw(boolean enabled) {
        this.mVrModeEnabled = enabled;
        if (this.mVrModeEnabled) {
            this.mHandler.removeMessages(1);
            this.mHandler.sendEmptyMessage(2);
        }
    }

    void onLockTaskModeChangedLw(int lockTaskState) {
        this.mLockTaskState = lockTaskState;
    }

    private final class H
    extends Handler {
        private static final int SHOW = 1;
        private static final int HIDE = 2;

        H(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ImmersiveModeConfirmation.this.handleShow();
                    break;
                }
                case 2: {
                    ImmersiveModeConfirmation.this.handleHide();
                }
            }
        }
    }

    private class ClingWindowView
    extends FrameLayout {
        private static final int BGCOLOR = Integer.MIN_VALUE;
        private static final int OFFSET_DP = 96;
        private static final int ANIMATION_DURATION = 250;
        private final Runnable mConfirm;
        private final ColorDrawable mColor;
        private final Interpolator mInterpolator;
        private ValueAnimator mColorAnim;
        private ViewGroup mClingLayout;
        private Runnable mUpdateLayoutRunnable;
        private ViewTreeObserver.OnComputeInternalInsetsListener mInsetsListener;
        private BroadcastReceiver mReceiver;

        ClingWindowView(Context context, Runnable confirm) {
            super(context);
            this.mColor = new ColorDrawable(0);
            this.mUpdateLayoutRunnable = new Runnable(){

                @Override
                public void run() {
                    if (ClingWindowView.this.mClingLayout != null && ClingWindowView.this.mClingLayout.getParent() != null) {
                        ClingWindowView.this.mClingLayout.setLayoutParams(ImmersiveModeConfirmation.this.getBubbleLayoutParams());
                    }
                }
            };
            this.mInsetsListener = new ViewTreeObserver.OnComputeInternalInsetsListener(){
                private final int[] mTmpInt2 = new int[2];

                @Override
                public void onComputeInternalInsets(ViewTreeObserver.InternalInsetsInfo inoutInfo) {
                    ClingWindowView.this.mClingLayout.getLocationInWindow(this.mTmpInt2);
                    inoutInfo.setTouchableInsets(3);
                    inoutInfo.touchableRegion.set(this.mTmpInt2[0], this.mTmpInt2[1], this.mTmpInt2[0] + ClingWindowView.this.mClingLayout.getWidth(), this.mTmpInt2[1] + ClingWindowView.this.mClingLayout.getHeight());
                }
            };
            this.mReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    if (intent.getAction().equals("android.intent.action.CONFIGURATION_CHANGED")) {
                        ClingWindowView.this.post(ClingWindowView.this.mUpdateLayoutRunnable);
                    }
                }
            };
            this.mConfirm = confirm;
            this.setBackground(this.mColor);
            this.setImportantForAccessibility(2);
            this.mInterpolator = AnimationUtils.loadInterpolator(this.mContext, 17563662);
        }

        @Override
        public void onAttachedToWindow() {
            super.onAttachedToWindow();
            DisplayMetrics metrics = new DisplayMetrics();
            ImmersiveModeConfirmation.this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
            float density = metrics.density;
            this.getViewTreeObserver().addOnComputeInternalInsetsListener(this.mInsetsListener);
            this.mClingLayout = (ViewGroup)View.inflate(this.getContext(), 17367165, null);
            Button ok = (Button)this.mClingLayout.findViewById(16909188);
            ok.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View v) {
                    ClingWindowView.this.mConfirm.run();
                }
            });
            this.addView((View)this.mClingLayout, ImmersiveModeConfirmation.this.getBubbleLayoutParams());
            if (ActivityManager.isHighEndGfx()) {
                final ViewGroup cling = this.mClingLayout;
                cling.setAlpha(0.0f);
                cling.setTranslationY(-96.0f * density);
                this.postOnAnimation(new Runnable(){

                    @Override
                    public void run() {
                        cling.animate().alpha(1.0f).translationY(0.0f).setDuration(250L).setInterpolator(ClingWindowView.this.mInterpolator).withLayer().start();
                        ClingWindowView.this.mColorAnim = ValueAnimator.ofObject(new ArgbEvaluator(), 0, Integer.MIN_VALUE);
                        ClingWindowView.this.mColorAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            @Override
                            public void onAnimationUpdate(ValueAnimator animation) {
                                int c = (Integer)animation.getAnimatedValue();
                                ClingWindowView.this.mColor.setColor(c);
                            }
                        });
                        ClingWindowView.this.mColorAnim.setDuration(250L);
                        ClingWindowView.this.mColorAnim.setInterpolator(ClingWindowView.this.mInterpolator);
                        ClingWindowView.this.mColorAnim.start();
                    }
                });
            } else {
                this.mColor.setColor(Integer.MIN_VALUE);
            }
            this.mContext.registerReceiver(this.mReceiver, new IntentFilter("android.intent.action.CONFIGURATION_CHANGED"));
        }

        @Override
        public void onDetachedFromWindow() {
            this.mContext.unregisterReceiver(this.mReceiver);
        }

        @Override
        public boolean onTouchEvent(MotionEvent motion) {
            return true;
        }
    }
}

