/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.view.InputApplicationHandle;
import android.view.InputChannel;
import android.view.InputWindowHandle;
import android.view.SurfaceControl;
import com.android.server.wm.InputMonitor;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;

class InputConsumerImpl
implements IBinder.DeathRecipient {
    final WindowManagerService mService;
    final InputChannel mServerChannel;
    final InputChannel mClientChannel;
    final InputApplicationHandle mApplicationHandle;
    final InputWindowHandle mWindowHandle;
    final IBinder mToken;
    final String mName;
    final int mClientPid;
    final UserHandle mClientUser;
    final SurfaceControl mInputSurface;
    Rect mTmpClipRect = new Rect();
    private final Rect mTmpRect = new Rect();
    private final Point mOldPosition = new Point();
    private final Rect mOldWindowCrop = new Rect();

    InputConsumerImpl(WindowManagerService service, IBinder token, String name, InputChannel inputChannel, int clientPid, UserHandle clientUser, int displayId) {
        this.mService = service;
        this.mToken = token;
        this.mName = name;
        this.mClientPid = clientPid;
        this.mClientUser = clientUser;
        InputChannel[] channels = InputChannel.openInputChannelPair(name);
        this.mServerChannel = channels[0];
        if (inputChannel != null) {
            channels[1].transferTo(inputChannel);
            channels[1].dispose();
            this.mClientChannel = inputChannel;
        } else {
            this.mClientChannel = channels[1];
        }
        this.mService.mInputManager.registerInputChannel(this.mServerChannel, null);
        this.mApplicationHandle = new InputApplicationHandle(new Binder());
        this.mApplicationHandle.name = name;
        this.mApplicationHandle.dispatchingTimeoutNanos = 5000000000L;
        this.mWindowHandle = new InputWindowHandle(this.mApplicationHandle, null, displayId);
        this.mWindowHandle.name = name;
        this.mWindowHandle.token = this.mServerChannel.getToken();
        this.mWindowHandle.layoutParamsType = 2022;
        this.mWindowHandle.layer = this.getLayerLw(this.mWindowHandle.layoutParamsType);
        this.mWindowHandle.layoutParamsFlags = 0;
        this.mWindowHandle.dispatchingTimeoutNanos = 5000000000L;
        this.mWindowHandle.visible = true;
        this.mWindowHandle.canReceiveKeys = false;
        this.mWindowHandle.hasFocus = false;
        this.mWindowHandle.hasWallpaper = false;
        this.mWindowHandle.paused = false;
        this.mWindowHandle.ownerPid = Process.myPid();
        this.mWindowHandle.ownerUid = Process.myUid();
        this.mWindowHandle.inputFeatures = 0;
        this.mWindowHandle.scaleFactor = 1.0f;
        this.mInputSurface = this.mService.makeSurfaceBuilder(this.mService.mRoot.getDisplayContent(displayId).getSession()).setContainerLayer().setName("Input Consumer " + name).build();
    }

    void linkToDeathRecipient() {
        if (this.mToken == null) {
            return;
        }
        try {
            this.mToken.linkToDeath(this, 0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void unlinkFromDeathRecipient() {
        if (this.mToken == null) {
            return;
        }
        this.mToken.unlinkToDeath(this, 0);
    }

    void layout(SurfaceControl.Transaction t, int dw, int dh) {
        this.mTmpRect.set(0, 0, dw, dh);
        this.layout(t, this.mTmpRect);
    }

    void layout(SurfaceControl.Transaction t, Rect r) {
        this.mTmpClipRect.set(0, 0, r.width(), r.height());
        if (this.mOldPosition.equals(r.left, r.top) && this.mOldWindowCrop.equals(this.mTmpClipRect)) {
            return;
        }
        t.setPosition(this.mInputSurface, r.left, r.top);
        t.setWindowCrop(this.mInputSurface, this.mTmpClipRect);
        this.mOldPosition.set(r.left, r.top);
        this.mOldWindowCrop.set(this.mTmpClipRect);
    }

    void hide(SurfaceControl.Transaction t) {
        t.hide(this.mInputSurface);
    }

    void show(SurfaceControl.Transaction t, WindowState w) {
        t.show(this.mInputSurface);
        t.setInputWindowInfo(this.mInputSurface, this.mWindowHandle);
        t.setRelativeLayer(this.mInputSurface, w.getSurfaceControl(), 1);
    }

    void show(SurfaceControl.Transaction t, int layer) {
        t.show(this.mInputSurface);
        t.setInputWindowInfo(this.mInputSurface, this.mWindowHandle);
        t.setLayer(this.mInputSurface, layer);
    }

    private int getLayerLw(int windowType) {
        return this.mService.mPolicy.getWindowLayerFromTypeLw(windowType) * 10000 + 1000;
    }

    void disposeChannelsLw() {
        this.mService.mInputManager.unregisterInputChannel(this.mServerChannel);
        this.mClientChannel.dispose();
        this.mServerChannel.dispose();
        this.unlinkFromDeathRecipient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binderDied() {
        Object object = this.mService.getWindowManagerLock();
        synchronized (object) {
            InputMonitor inputMonitor = this.mService.mRoot.getDisplayContent(this.mWindowHandle.displayId).getInputMonitor();
            inputMonitor.destroyInputConsumer(this.mName);
            this.unlinkFromDeathRecipient();
        }
    }

    void dump(PrintWriter pw, String name, String prefix) {
        pw.println(prefix + "  name=" + name + " pid=" + this.mClientPid + " user=" + this.mClientUser);
    }
}

