/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.Trace;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.view.InputApplicationHandle;
import android.view.InputChannel;
import android.view.InputEventReceiver;
import android.view.InputWindowHandle;
import android.view.SurfaceControl;
import com.android.server.AnimationThread;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.InputConsumerImpl;
import com.android.server.wm.RecentsAnimationController;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.Set;
import java.util.function.Consumer;

final class InputMonitor {
    private final WindowManagerService mService;
    private WindowState mInputFocus;
    private boolean mUpdateInputWindowsNeeded = true;
    private boolean mUpdateInputWindowsPending;
    private boolean mApplyImmediately;
    private InputWindowHandle mFocusedInputWindowHandle;
    private boolean mDisableWallpaperTouchEvents;
    private final Rect mTmpRect = new Rect();
    private final UpdateInputForAllWindowsConsumer mUpdateInputForAllWindowsConsumer;
    private final int mDisplayId;
    private final DisplayContent mDisplayContent;
    private boolean mDisplayRemoved;
    private final SurfaceControl.Transaction mInputTransaction;
    private final Handler mHandler;
    private final ArrayMap<String, InputConsumerImpl> mInputConsumers = new ArrayMap();
    private final Runnable mUpdateInputWindows = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            block6: {
                WindowManagerGlobalLock windowManagerGlobalLock = ((InputMonitor)InputMonitor.this).mService.mGlobalLock;
                // MONITORENTER : windowManagerGlobalLock
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    InputMonitor.this.mUpdateInputWindowsPending = false;
                    InputMonitor.this.mUpdateInputWindowsNeeded = false;
                    if (!InputMonitor.this.mDisplayRemoved) break block6;
                    // MONITOREXIT : windowManagerGlobalLock
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowManagerGlobalLock
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
            }
            boolean inDrag = ((InputMonitor)InputMonitor.this).mService.mDragDropController.dragDropActiveLocked();
            boolean inPositioning = ((InputMonitor)InputMonitor.this).mService.mTaskPositioningController.isPositioningLocked();
            if (inPositioning) {
                ((InputMonitor)InputMonitor.this).mService.mTaskPositioningController.showInputSurface(InputMonitor.this.mInputTransaction, InputMonitor.this.mDisplayId);
            } else {
                ((InputMonitor)InputMonitor.this).mService.mTaskPositioningController.hideInputSurface(InputMonitor.this.mInputTransaction, InputMonitor.this.mDisplayId);
            }
            InputMonitor.this.mUpdateInputForAllWindowsConsumer.updateInputWindows(inDrag);
            // MONITOREXIT : windowManagerGlobalLock
            WindowManagerService.resetPriorityAfterLockedSection();
        }
    };

    public InputMonitor(WindowManagerService service, int displayId) {
        this.mService = service;
        this.mDisplayContent = this.mService.mRoot.getDisplayContent(displayId);
        this.mDisplayId = displayId;
        this.mInputTransaction = this.mService.mTransactionFactory.make();
        this.mHandler = AnimationThread.getHandler();
        this.mUpdateInputForAllWindowsConsumer = new UpdateInputForAllWindowsConsumer();
    }

    void onDisplayRemoved() {
        this.mHandler.removeCallbacks(this.mUpdateInputWindows);
        this.mService.mInputManager.onDisplayRemoved(this.mDisplayId);
        this.mDisplayRemoved = true;
    }

    private void addInputConsumer(String name, InputConsumerImpl consumer) {
        this.mInputConsumers.put(name, consumer);
        consumer.linkToDeathRecipient();
        this.updateInputWindowsLw(true);
    }

    boolean destroyInputConsumer(String name) {
        if (this.disposeInputConsumer(this.mInputConsumers.remove(name))) {
            this.updateInputWindowsLw(true);
            return true;
        }
        return false;
    }

    private boolean disposeInputConsumer(InputConsumerImpl consumer) {
        if (consumer != null) {
            consumer.disposeChannelsLw();
            consumer.hide(this.mInputTransaction);
            return true;
        }
        return false;
    }

    InputConsumerImpl getInputConsumer(String name) {
        return this.mInputConsumers.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void layoutInputConsumers(int dw, int dh) {
        try {
            Trace.traceBegin(32L, "layoutInputConsumer");
            for (int i = this.mInputConsumers.size() - 1; i >= 0; --i) {
                this.mInputConsumers.valueAt(i).layout(this.mInputTransaction, dw, dh);
            }
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    void resetInputConsumers(SurfaceControl.Transaction t) {
        for (int i = this.mInputConsumers.size() - 1; i >= 0; --i) {
            this.mInputConsumers.valueAt(i).hide(t);
        }
    }

    WindowManagerPolicy.InputConsumer createInputConsumer(Looper looper, String name, InputEventReceiver.Factory inputEventReceiverFactory) {
        if (this.mInputConsumers.containsKey(name)) {
            throw new IllegalStateException("Existing input consumer found with name: " + name + ", display: " + this.mDisplayId);
        }
        EventReceiverInputConsumer consumer = new EventReceiverInputConsumer(this.mService, this, looper, name, inputEventReceiverFactory, Process.myPid(), UserHandle.SYSTEM, this.mDisplayId);
        this.addInputConsumer(name, consumer);
        return consumer;
    }

    void createInputConsumer(IBinder token, String name, InputChannel inputChannel, int clientPid, UserHandle clientUser) {
        if (this.mInputConsumers.containsKey(name)) {
            throw new IllegalStateException("Existing input consumer found with name: " + name + ", display: " + this.mDisplayId);
        }
        InputConsumerImpl consumer = new InputConsumerImpl(this.mService, token, name, inputChannel, clientPid, clientUser, this.mDisplayId);
        switch (name) {
            case "wallpaper_input_consumer": {
                consumer.mWindowHandle.hasWallpaper = true;
                break;
            }
            case "pip_input_consumer": {
                consumer.mWindowHandle.layoutParamsFlags |= 0x20;
            }
        }
        this.addInputConsumer(name, consumer);
    }

    void populateInputWindowHandle(InputWindowHandle inputWindowHandle, WindowState child, int flags, int type, boolean isVisible, boolean hasFocus, boolean hasWallpaper) {
        inputWindowHandle.name = child.toString();
        inputWindowHandle.layoutParamsFlags = flags = child.getSurfaceTouchableRegion(inputWindowHandle, flags);
        inputWindowHandle.layoutParamsType = type;
        inputWindowHandle.dispatchingTimeoutNanos = child.getInputDispatchingTimeoutNanos();
        inputWindowHandle.visible = isVisible;
        inputWindowHandle.canReceiveKeys = child.canReceiveKeys();
        inputWindowHandle.hasFocus = hasFocus;
        inputWindowHandle.hasWallpaper = hasWallpaper;
        inputWindowHandle.paused = child.mAppToken != null ? child.mAppToken.paused : false;
        inputWindowHandle.layer = child.mLayer;
        inputWindowHandle.ownerPid = child.mSession.mPid;
        inputWindowHandle.ownerUid = child.mSession.mUid;
        inputWindowHandle.inputFeatures = child.mAttrs.inputFeatures;
        inputWindowHandle.displayId = child.getDisplayId();
        Rect frame = child.getFrameLw();
        inputWindowHandle.frameLeft = frame.left;
        inputWindowHandle.frameTop = frame.top;
        inputWindowHandle.frameRight = frame.right;
        inputWindowHandle.frameBottom = frame.bottom;
        inputWindowHandle.surfaceInset = child.getAttrs().surfaceInsets.left;
        inputWindowHandle.scaleFactor = child.mGlobalScale != 1.0f ? 1.0f / child.mGlobalScale : 1.0f;
        if (hasFocus) {
            this.mFocusedInputWindowHandle = inputWindowHandle;
        }
    }

    void setUpdateInputWindowsNeededLw() {
        this.mUpdateInputWindowsNeeded = true;
    }

    void updateInputWindowsLw(boolean force) {
        if (!force && !this.mUpdateInputWindowsNeeded) {
            return;
        }
        this.scheduleUpdateInputWindows();
    }

    private void scheduleUpdateInputWindows() {
        if (this.mDisplayRemoved) {
            return;
        }
        if (!this.mUpdateInputWindowsPending) {
            this.mUpdateInputWindowsPending = true;
            this.mHandler.post(this.mUpdateInputWindows);
        }
    }

    void updateInputWindowsImmediately() {
        if (this.mUpdateInputWindowsPending) {
            this.mApplyImmediately = true;
            this.mUpdateInputWindows.run();
            this.mApplyImmediately = false;
        }
    }

    public void setInputFocusLw(WindowState newWindow, boolean updateInputWindows) {
        if (newWindow != this.mInputFocus) {
            if (newWindow != null && newWindow.canReceiveKeys()) {
                newWindow.mToken.paused = false;
            }
            this.mInputFocus = newWindow;
            this.setUpdateInputWindowsNeededLw();
            if (updateInputWindows) {
                this.updateInputWindowsLw(false);
            }
        }
    }

    public void setFocusedAppLw(AppWindowToken newApp) {
        if (newApp == null) {
            this.mService.mInputManager.setFocusedApplication(this.mDisplayId, null);
        } else {
            InputApplicationHandle handle = newApp.mInputApplicationHandle;
            handle.name = newApp.toString();
            handle.dispatchingTimeoutNanos = newApp.mInputDispatchingTimeoutNanos;
            this.mService.mInputManager.setFocusedApplication(this.mDisplayId, handle);
        }
    }

    public void pauseDispatchingLw(WindowToken window) {
        if (!window.paused) {
            window.paused = true;
            this.updateInputWindowsLw(true);
        }
    }

    public void resumeDispatchingLw(WindowToken window) {
        if (window.paused) {
            window.paused = false;
            this.updateInputWindowsLw(true);
        }
    }

    void dump(PrintWriter pw, String prefix) {
        Set<String> inputConsumerKeys = this.mInputConsumers.keySet();
        if (!inputConsumerKeys.isEmpty()) {
            pw.println(prefix + "InputConsumers:");
            for (String key : inputConsumerKeys) {
                this.mInputConsumers.get(key).dump(pw, key, prefix);
            }
        }
    }

    private final class UpdateInputForAllWindowsConsumer
    implements Consumer<WindowState> {
        InputConsumerImpl navInputConsumer;
        InputConsumerImpl pipInputConsumer;
        InputConsumerImpl wallpaperInputConsumer;
        InputConsumerImpl recentsAnimationInputConsumer;
        private boolean mAddInputConsumerHandle;
        private boolean mAddPipInputConsumerHandle;
        private boolean mAddWallpaperInputConsumerHandle;
        private boolean mAddRecentsAnimationInputConsumerHandle;
        boolean inDrag;
        WallpaperController wallpaperController;
        final InputWindowHandle mInvalidInputWindow;

        private UpdateInputForAllWindowsConsumer() {
            this.mInvalidInputWindow = new InputWindowHandle(null, null, InputMonitor.this.mDisplayId);
        }

        private void updateInputWindows(boolean inDrag) {
            Trace.traceBegin(32L, "updateInputWindows");
            this.navInputConsumer = InputMonitor.this.getInputConsumer("nav_input_consumer");
            this.pipInputConsumer = InputMonitor.this.getInputConsumer("pip_input_consumer");
            this.wallpaperInputConsumer = InputMonitor.this.getInputConsumer("wallpaper_input_consumer");
            this.recentsAnimationInputConsumer = InputMonitor.this.getInputConsumer("recents_animation_input_consumer");
            this.mAddInputConsumerHandle = this.navInputConsumer != null;
            this.mAddPipInputConsumerHandle = this.pipInputConsumer != null;
            this.mAddWallpaperInputConsumerHandle = this.wallpaperInputConsumer != null;
            this.mAddRecentsAnimationInputConsumerHandle = this.recentsAnimationInputConsumer != null;
            InputMonitor.this.mTmpRect.setEmpty();
            InputMonitor.this.mDisableWallpaperTouchEvents = false;
            this.inDrag = inDrag;
            this.wallpaperController = ((InputMonitor)InputMonitor.this).mDisplayContent.mWallpaperController;
            InputMonitor.this.resetInputConsumers(InputMonitor.this.mInputTransaction);
            InputMonitor.this.mDisplayContent.forAllWindows(this, true);
            if (this.mAddWallpaperInputConsumerHandle) {
                this.wallpaperInputConsumer.show(InputMonitor.this.mInputTransaction, 0);
            }
            if (InputMonitor.this.mApplyImmediately) {
                InputMonitor.this.mInputTransaction.apply();
            } else {
                InputMonitor.this.mDisplayContent.getPendingTransaction().merge(InputMonitor.this.mInputTransaction);
                InputMonitor.this.mDisplayContent.scheduleAnimation();
            }
            Trace.traceEnd(32L);
        }

        @Override
        public void accept(WindowState w) {
            boolean hasWallpaper;
            RecentsAnimationController recentsAnimationController;
            InputChannel inputChannel = w.mInputChannel;
            InputWindowHandle inputWindowHandle = w.mInputWindowHandle;
            if (inputChannel == null || inputWindowHandle == null || w.mRemoved || w.cantReceiveTouchInput()) {
                if (w.mWinAnimator.hasSurface()) {
                    InputMonitor.this.mInputTransaction.setInputWindowInfo(w.mWinAnimator.mSurfaceController.mSurfaceControl, this.mInvalidInputWindow);
                }
                return;
            }
            int flags = w.mAttrs.flags;
            int privateFlags = w.mAttrs.privateFlags;
            int type = w.mAttrs.type;
            boolean hasFocus = w.isFocused();
            boolean isVisible = w.isVisibleLw();
            if (this.mAddRecentsAnimationInputConsumerHandle && (recentsAnimationController = InputMonitor.this.mService.getRecentsAnimationController()) != null && recentsAnimationController.shouldApplyInputConsumer(w.mAppToken) && recentsAnimationController.updateInputConsumerForApp(this.recentsAnimationInputConsumer.mWindowHandle, hasFocus)) {
                this.recentsAnimationInputConsumer.show(InputMonitor.this.mInputTransaction, w);
                this.mAddRecentsAnimationInputConsumerHandle = false;
            }
            if (w.inPinnedWindowingMode() && this.mAddPipInputConsumerHandle) {
                w.getBounds(InputMonitor.this.mTmpRect);
                this.pipInputConsumer.layout(InputMonitor.this.mInputTransaction, InputMonitor.this.mTmpRect);
                InputMonitor.this.mTmpRect.offsetTo(0, 0);
                this.pipInputConsumer.mWindowHandle.touchableRegion.set(InputMonitor.this.mTmpRect);
                this.pipInputConsumer.show(InputMonitor.this.mInputTransaction, w);
                this.mAddPipInputConsumerHandle = false;
            }
            if (this.mAddInputConsumerHandle && inputWindowHandle.layer <= this.navInputConsumer.mWindowHandle.layer) {
                this.navInputConsumer.show(InputMonitor.this.mInputTransaction, w);
                this.mAddInputConsumerHandle = false;
            }
            if (this.mAddWallpaperInputConsumerHandle && w.mAttrs.type == 2013 && w.isVisibleLw()) {
                this.wallpaperInputConsumer.show(InputMonitor.this.mInputTransaction, w);
                this.mAddWallpaperInputConsumerHandle = false;
            }
            if ((privateFlags & 0x800) != 0) {
                InputMonitor.this.mDisableWallpaperTouchEvents = true;
            }
            boolean bl = hasWallpaper = this.wallpaperController.isWallpaperTarget(w) && (privateFlags & 0x400) == 0 && !InputMonitor.this.mDisableWallpaperTouchEvents;
            if (this.inDrag && isVisible && w.getDisplayContent().isDefaultDisplay) {
                ((InputMonitor)InputMonitor.this).mService.mDragDropController.sendDragStartedIfNeededLocked(w);
            }
            InputMonitor.this.populateInputWindowHandle(inputWindowHandle, w, flags, type, isVisible, hasFocus, hasWallpaper);
            if (w.mWinAnimator.hasSurface()) {
                InputMonitor.this.mInputTransaction.setInputWindowInfo(w.mWinAnimator.mSurfaceController.mSurfaceControl, inputWindowHandle);
            }
        }
    }

    private static final class EventReceiverInputConsumer
    extends InputConsumerImpl
    implements WindowManagerPolicy.InputConsumer {
        private InputMonitor mInputMonitor;
        private final InputEventReceiver mInputEventReceiver;

        EventReceiverInputConsumer(WindowManagerService service, InputMonitor monitor, Looper looper, String name, InputEventReceiver.Factory inputEventReceiverFactory, int clientPid, UserHandle clientUser, int displayId) {
            super(service, null, name, null, clientPid, clientUser, displayId);
            this.mInputMonitor = monitor;
            this.mInputEventReceiver = inputEventReceiverFactory.createInputEventReceiver(this.mClientChannel, looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dismiss() {
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            synchronized (windowManagerGlobalLock) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (this.mInputMonitor.destroyInputConsumer(this.mWindowHandle.name)) {
                        this.mInputEventReceiver.dispose();
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }
    }
}

