/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.proto.ProtoOutputStream;
import android.view.InsetsSource;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.ViewRootImpl;
import com.android.internal.util.function.TriConsumer;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplayFrames;
import com.android.server.wm.InsetsStateController;
import com.android.server.wm.SurfaceAnimator;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;

class InsetsSourceProvider {
    private final Rect mTmpRect = new Rect();
    private final InsetsSource mSource;
    private final DisplayContent mDisplayContent;
    private final InsetsStateController mStateController;
    private InsetsSourceControl mControl;
    private WindowState mControllingWin;
    private ControlAdapter mAdapter;
    private WindowState mWin;
    private TriConsumer<DisplayFrames, WindowState, Rect> mFrameProvider;
    private boolean mClientVisible;
    private boolean mServerVisible;
    private final boolean mControllable;

    InsetsSourceProvider(InsetsSource source, InsetsStateController stateController, DisplayContent displayContent) {
        this.mClientVisible = InsetsState.getDefaultVisibility(source.getType());
        this.mSource = source;
        this.mDisplayContent = displayContent;
        this.mStateController = stateController;
        int type = source.getType();
        this.mControllable = type == 0 || type == 1 ? ViewRootImpl.sNewInsetsMode == 2 : (type == 10 ? ViewRootImpl.sNewInsetsMode >= 1 : false);
    }

    InsetsSource getSource() {
        return this.mSource;
    }

    boolean isControllable() {
        return this.mControllable;
    }

    void setWindow(WindowState win, TriConsumer<DisplayFrames, WindowState, Rect> frameProvider) {
        if (this.mWin != null) {
            this.mWin.setInsetProvider(null);
        }
        this.mWin = win;
        this.mFrameProvider = frameProvider;
        if (win == null) {
            this.setServerVisible(false);
            this.mSource.setFrame(new Rect());
        } else {
            this.mWin.setInsetProvider(this);
            if (this.mControllingWin != null) {
                this.updateControlForTarget(this.mControllingWin, true);
            }
        }
    }

    void onPostLayout() {
        if (this.mWin == null) {
            return;
        }
        this.mTmpRect.set(this.mWin.getFrameLw());
        if (this.mFrameProvider != null) {
            this.mFrameProvider.accept(this.mWin.getDisplayContent().mDisplayFrames, this.mWin, this.mTmpRect);
        } else {
            this.mTmpRect.inset(this.mWin.mGivenContentInsets);
        }
        this.mSource.setFrame(this.mTmpRect);
        if (this.mControl != null) {
            Rect frame = this.mWin.getWindowFrames().mFrame;
            if (this.mControl.setSurfacePosition(frame.left, frame.top)) {
                this.mStateController.notifyControlChanged(this.mControllingWin);
            }
        }
        this.setServerVisible(this.mWin.wouldBeVisibleIfPolicyIgnored() && this.mWin.isVisibleByPolicy() && !this.mWin.mGivenInsetsPending);
    }

    void updateControlForTarget(WindowState target, boolean force) {
        if (this.mWin == null) {
            this.mControllingWin = target;
            return;
        }
        if (target == this.mControllingWin && !force) {
            return;
        }
        if (target == null) {
            this.mWin.cancelAnimation();
            return;
        }
        this.mAdapter = new ControlAdapter();
        this.setClientVisible(InsetsState.getDefaultVisibility(this.mSource.getType()));
        this.mWin.startAnimation(this.mDisplayContent.getPendingTransaction(), this.mAdapter, !this.mClientVisible);
        this.mControllingWin = target;
        this.mControl = new InsetsSourceControl(this.mSource.getType(), this.mAdapter.mCapturedLeash, new Point(this.mWin.getWindowFrames().mFrame.left, this.mWin.getWindowFrames().mFrame.top));
    }

    boolean onInsetsModified(WindowState caller, InsetsSource modifiedSource) {
        if (this.mControllingWin != caller || modifiedSource.isVisible() == this.mClientVisible) {
            return false;
        }
        this.setClientVisible(modifiedSource.isVisible());
        return true;
    }

    private void setClientVisible(boolean clientVisible) {
        if (this.mClientVisible == clientVisible) {
            return;
        }
        this.mClientVisible = clientVisible;
        this.mDisplayContent.mWmService.mH.sendMessage(PooledLambda.obtainMessage(DisplayContent::layoutAndAssignWindowLayersIfNeeded, this.mDisplayContent));
        this.updateVisibility();
    }

    private void setServerVisible(boolean serverVisible) {
        this.mServerVisible = serverVisible;
        this.updateVisibility();
    }

    private void updateVisibility() {
        this.mSource.setVisible(this.mServerVisible && this.mClientVisible);
    }

    InsetsSourceControl getControl() {
        return this.mControl;
    }

    boolean isClientVisible() {
        return ViewRootImpl.sNewInsetsMode == 0 || this.mClientVisible;
    }

    private class ControlAdapter
    implements AnimationAdapter {
        private SurfaceControl mCapturedLeash;

        private ControlAdapter() {
        }

        @Override
        public boolean getShowWallpaper() {
            return false;
        }

        @Override
        public int getBackgroundColor() {
            return 0;
        }

        @Override
        public void startAnimation(SurfaceControl animationLeash, SurfaceControl.Transaction t, SurfaceAnimator.OnAnimationFinishedCallback finishCallback) {
            this.mCapturedLeash = animationLeash;
            Rect frame = ((InsetsSourceProvider)InsetsSourceProvider.this).mWin.getWindowFrames().mFrame;
            t.setPosition(this.mCapturedLeash, frame.left, frame.top);
        }

        @Override
        public void onAnimationCancelled(SurfaceControl animationLeash) {
            if (InsetsSourceProvider.this.mAdapter == this) {
                InsetsSourceProvider.this.mStateController.notifyControlRevoked(InsetsSourceProvider.this.mControllingWin, InsetsSourceProvider.this);
                InsetsSourceProvider.this.setClientVisible(InsetsState.getDefaultVisibility(InsetsSourceProvider.this.mSource.getType()));
                InsetsSourceProvider.this.mControl = null;
                InsetsSourceProvider.this.mControllingWin = null;
                InsetsSourceProvider.this.mAdapter = null;
            }
        }

        @Override
        public long getDurationHint() {
            return 0L;
        }

        @Override
        public long getStatusBarTransitionsStartTime() {
            return 0L;
        }

        @Override
        public void dump(PrintWriter pw, String prefix) {
        }

        @Override
        public void writeToProto(ProtoOutputStream proto) {
        }
    }
}

