/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.SparseArray;
import android.view.InsetsSource;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.InsetsSourceProvider;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.function.Consumer;

class InsetsStateController {
    private final InsetsState mLastState = new InsetsState();
    private final InsetsState mState = new InsetsState();
    private final DisplayContent mDisplayContent;
    private final ArrayMap<Integer, InsetsSourceProvider> mControllers = new ArrayMap();
    private final ArrayMap<WindowState, ArrayList<Integer>> mWinControlTypeMap = new ArrayMap();
    private final SparseArray<WindowState> mTypeWinControlMap = new SparseArray();
    private final ArraySet<WindowState> mPendingControlChanged = new ArraySet();
    private final Consumer<WindowState> mDispatchInsetsChanged = w -> {
        if (w.isVisible()) {
            w.notifyInsetsChanged();
        }
    };

    InsetsStateController(DisplayContent displayContent) {
        this.mDisplayContent = displayContent;
    }

    InsetsState getInsetsForDispatch(WindowState target) {
        InsetsSourceProvider provider = target.getInsetProvider();
        if (provider == null) {
            return this.mState;
        }
        InsetsState state = new InsetsState();
        state.set(this.mState);
        int type = provider.getSource().getType();
        state.removeSource(type);
        if (type == 1) {
            state.removeSource(10);
            state.removeSource(0);
        }
        return state;
    }

    InsetsSourceControl[] getControlsForDispatch(WindowState target) {
        ArrayList<Integer> controlled = this.mWinControlTypeMap.get(target);
        if (controlled == null) {
            return null;
        }
        int size = controlled.size();
        InsetsSourceControl[] result = new InsetsSourceControl[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.mControllers.get(controlled.get(i)).getControl();
        }
        return result;
    }

    InsetsSourceProvider getSourceProvider(int type) {
        return this.mControllers.computeIfAbsent(type, key -> new InsetsSourceProvider(this.mState.getSource((int)key), this, this.mDisplayContent));
    }

    void onPostLayout() {
        this.mState.setDisplayFrame(this.mDisplayContent.getBounds());
        for (int i = this.mControllers.size() - 1; i >= 0; --i) {
            this.mControllers.valueAt(i).onPostLayout();
        }
        if (!this.mLastState.equals(this.mState)) {
            this.mLastState.set(this.mState, true);
            this.notifyInsetsChanged();
        }
    }

    void onInsetsModified(WindowState windowState, InsetsState state) {
        boolean changed = false;
        for (int i = state.getSourcesCount() - 1; i >= 0; --i) {
            InsetsSource source = state.sourceAt(i);
            InsetsSourceProvider provider = this.mControllers.get(source.getType());
            if (provider == null) continue;
            changed |= provider.onInsetsModified(windowState, source);
        }
        if (changed) {
            this.notifyInsetsChanged();
        }
    }

    void onImeTargetChanged(WindowState imeTarget) {
        this.onControlChanged(10, imeTarget);
        this.notifyPendingInsetsControlChanged();
    }

    void onBarControllingWindowChanged(WindowState controllingWindow) {
        this.onControlChanged(0, controllingWindow);
        this.onControlChanged(1, controllingWindow);
        this.notifyPendingInsetsControlChanged();
    }

    void notifyControlRevoked(WindowState previousControllingWin, InsetsSourceProvider provider) {
        this.removeFromControlMaps(previousControllingWin, provider.getSource().getType());
    }

    private void onControlChanged(int type, WindowState win) {
        WindowState previous = this.mTypeWinControlMap.get(type);
        if (win == previous) {
            return;
        }
        InsetsSourceProvider controller = this.getSourceProvider(type);
        if (controller == null) {
            return;
        }
        if (!controller.isControllable()) {
            return;
        }
        controller.updateControlForTarget(win, false);
        if (previous != null) {
            this.removeFromControlMaps(previous, type);
            this.mPendingControlChanged.add(previous);
        }
        if (win != null) {
            this.addToControlMaps(win, type);
            this.mPendingControlChanged.add(win);
        }
    }

    private void removeFromControlMaps(WindowState win, int type) {
        ArrayList<Integer> array2 = this.mWinControlTypeMap.get(win);
        if (array2 == null) {
            return;
        }
        array2.remove((Object)type);
        if (array2.isEmpty()) {
            this.mWinControlTypeMap.remove(win);
        }
        this.mTypeWinControlMap.remove(type);
    }

    private void addToControlMaps(WindowState win, int type) {
        ArrayList array2 = this.mWinControlTypeMap.computeIfAbsent(win, key -> new ArrayList());
        array2.add(type);
        this.mTypeWinControlMap.put(type, win);
    }

    void notifyControlChanged(WindowState target) {
        this.mPendingControlChanged.add(target);
        this.notifyPendingInsetsControlChanged();
    }

    private void notifyPendingInsetsControlChanged() {
        if (this.mPendingControlChanged.isEmpty()) {
            return;
        }
        this.mDisplayContent.mWmService.mAnimator.addAfterPrepareSurfacesRunnable(() -> {
            for (int i = this.mPendingControlChanged.size() - 1; i >= 0; --i) {
                WindowState controllingWin = this.mPendingControlChanged.valueAt(i);
                controllingWin.notifyInsetsControlChanged();
            }
            this.mPendingControlChanged.clear();
        });
    }

    private void notifyInsetsChanged() {
        this.mDisplayContent.forAllWindows(this.mDispatchInsetsChanged, true);
    }

    void dump(String prefix, PrintWriter pw) {
        pw.println(prefix + "WindowInsetsStateController");
        this.mState.dump(prefix + "  ", pw);
        pw.println(prefix + "  Control map:");
        for (int i = this.mTypeWinControlMap.size() - 1; i >= 0; --i) {
            pw.print(prefix + "  ");
            pw.println(InsetsState.typeToString(this.mTypeWinControlMap.keyAt(i)) + " -> " + this.mTypeWinControlMap.valueAt(i));
        }
    }
}

