/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.IBinder;
import android.os.RemoteException;
import android.os.Trace;
import android.util.Slog;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.server.wm.ActivityDisplay;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityStackSupervisor;
import com.android.server.wm.ActivityTaskManagerInternal;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.RootActivityContainer;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;

class KeyguardController {
    private static final String TAG = "ActivityTaskManager";
    private final ActivityStackSupervisor mStackSupervisor;
    private WindowManagerService mWindowManager;
    private boolean mKeyguardShowing;
    private boolean mAodShowing;
    private boolean mKeyguardGoingAway;
    private boolean mDismissalRequested;
    private int[] mSecondaryDisplayIdsShowing;
    private int mBeforeUnoccludeTransit;
    private int mVisibilityTransactionDepth;
    private final SparseArray<KeyguardDisplayState> mDisplayStates = new SparseArray();
    private final ActivityTaskManagerService mService;
    private RootActivityContainer mRootActivityContainer;

    KeyguardController(ActivityTaskManagerService service, ActivityStackSupervisor stackSupervisor) {
        this.mService = service;
        this.mStackSupervisor = stackSupervisor;
    }

    void setWindowManager(WindowManagerService windowManager) {
        this.mWindowManager = windowManager;
        this.mRootActivityContainer = this.mService.mRootActivityContainer;
    }

    boolean isKeyguardOrAodShowing(int displayId) {
        return (this.mKeyguardShowing || this.mAodShowing) && !this.mKeyguardGoingAway && !this.isDisplayOccluded(displayId);
    }

    boolean isKeyguardUnoccludedOrAodShowing(int displayId) {
        if (displayId == 0 && this.mAodShowing) {
            return true;
        }
        return this.isKeyguardOrAodShowing(displayId);
    }

    boolean isKeyguardShowing(int displayId) {
        return this.mKeyguardShowing && !this.mKeyguardGoingAway && !this.isDisplayOccluded(displayId);
    }

    boolean isKeyguardLocked() {
        return this.mKeyguardShowing && !this.mKeyguardGoingAway;
    }

    boolean isKeyguardGoingAway() {
        return this.mKeyguardGoingAway && this.mKeyguardShowing;
    }

    void setKeyguardShown(boolean keyguardShowing, boolean aodShowing) {
        boolean aodChanged;
        boolean keyguardChanged = keyguardShowing != this.mKeyguardShowing || this.mKeyguardGoingAway && keyguardShowing;
        boolean bl = aodChanged = aodShowing != this.mAodShowing;
        if (!keyguardChanged && !aodChanged) {
            return;
        }
        this.mKeyguardShowing = keyguardShowing;
        this.mAodShowing = aodShowing;
        this.mWindowManager.setAodShowing(aodShowing);
        if (keyguardChanged) {
            this.dismissDockedStackIfNeeded();
            this.setKeyguardGoingAway(false);
            if (keyguardShowing) {
                this.mDismissalRequested = false;
            }
        }
        this.mWindowManager.setKeyguardOrAodShowingOnDefaultDisplay(this.isKeyguardOrAodShowing(0));
        this.updateKeyguardSleepToken();
        this.mRootActivityContainer.ensureActivitiesVisible(null, 0, false);
    }

    void keyguardGoingAway(int flags) {
        if (!this.mKeyguardShowing) {
            return;
        }
        Trace.traceBegin(64L, "keyguardGoingAway");
        this.mWindowManager.deferSurfaceLayout();
        try {
            this.setKeyguardGoingAway(true);
            this.mRootActivityContainer.getDefaultDisplay().mDisplayContent.prepareAppTransition(20, false, this.convertTransitFlags(flags), false);
            this.updateKeyguardSleepToken();
            this.mRootActivityContainer.resumeFocusedStacksTopActivities();
            this.mRootActivityContainer.ensureActivitiesVisible(null, 0, false);
            this.mRootActivityContainer.addStartingWindowsForVisibleActivities(true);
            this.mWindowManager.executeAppTransition();
        }
        finally {
            Trace.traceBegin(64L, "keyguardGoingAway: surfaceLayout");
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
            Trace.traceEnd(64L);
        }
    }

    void dismissKeyguard(IBinder token, IKeyguardDismissCallback callback, CharSequence message) {
        ActivityRecord activityRecord = ActivityRecord.forTokenLocked(token);
        if (activityRecord == null || !activityRecord.visibleIgnoringKeyguard) {
            this.failCallback(callback);
            return;
        }
        Slog.i(TAG, "Activity requesting to dismiss Keyguard: " + activityRecord);
        if (activityRecord.getTurnScreenOnFlag() && activityRecord.isTopRunningActivity()) {
            this.mStackSupervisor.wakeUp("dismissKeyguard");
        }
        this.mWindowManager.dismissKeyguard(callback, message);
    }

    private void setKeyguardGoingAway(boolean keyguardGoingAway) {
        this.mKeyguardGoingAway = keyguardGoingAway;
        this.mWindowManager.setKeyguardGoingAway(keyguardGoingAway);
    }

    private void failCallback(IKeyguardDismissCallback callback) {
        try {
            callback.onDismissError();
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Failed to call callback", e);
        }
    }

    private int convertTransitFlags(int keyguardGoingAwayFlags) {
        int result = 0;
        if ((keyguardGoingAwayFlags & 1) != 0) {
            result |= 1;
        }
        if ((keyguardGoingAwayFlags & 2) != 0) {
            result |= 2;
        }
        if ((keyguardGoingAwayFlags & 4) != 0) {
            result |= 4;
        }
        return result;
    }

    void beginActivityVisibilityUpdate() {
        ++this.mVisibilityTransactionDepth;
    }

    void endActivityVisibilityUpdate() {
        --this.mVisibilityTransactionDepth;
        if (this.mVisibilityTransactionDepth == 0) {
            this.visibilitiesUpdated();
        }
    }

    boolean canShowActivityWhileKeyguardShowing(ActivityRecord r, boolean dismissKeyguard) {
        return dismissKeyguard && this.canDismissKeyguard() && !this.mAodShowing && (this.mDismissalRequested || r.canShowWhenLocked() && this.getDisplay(r.getDisplayId()).mDismissingKeyguardActivity != r);
    }

    boolean canShowWhileOccluded(boolean dismissKeyguard, boolean showWhenLocked) {
        return showWhenLocked || dismissKeyguard && !this.mWindowManager.isKeyguardSecure(this.mService.getCurrentUserId());
    }

    private void visibilitiesUpdated() {
        boolean requestDismissKeyguard = false;
        for (int displayNdx = this.mRootActivityContainer.getChildCount() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mRootActivityContainer.getChildAt(displayNdx);
            KeyguardDisplayState state = this.getDisplay(display.mDisplayId);
            state.visibilitiesUpdated(this, display);
            requestDismissKeyguard |= state.mRequestDismissKeyguard;
        }
        if (requestDismissKeyguard) {
            this.handleDismissKeyguard();
        }
    }

    private void handleOccludedChanged(int displayId) {
        if (displayId != 0) {
            this.updateKeyguardSleepToken(displayId);
            return;
        }
        this.mWindowManager.onKeyguardOccludedChanged(this.isDisplayOccluded(0));
        if (this.isKeyguardLocked()) {
            this.mWindowManager.deferSurfaceLayout();
            try {
                this.mRootActivityContainer.getDefaultDisplay().mDisplayContent.prepareAppTransition(this.resolveOccludeTransit(), false, 0, true);
                this.updateKeyguardSleepToken(0);
                this.mRootActivityContainer.ensureActivitiesVisible(null, 0, false);
                this.mWindowManager.executeAppTransition();
            }
            finally {
                this.mWindowManager.continueSurfaceLayout();
            }
        }
        this.dismissDockedStackIfNeeded();
    }

    private void handleDismissKeyguard() {
        if (!this.mWindowManager.isKeyguardSecure(this.mService.getCurrentUserId())) {
            return;
        }
        this.mWindowManager.dismissKeyguard(null, null);
        this.mDismissalRequested = true;
        DisplayContent dc = this.mRootActivityContainer.getDefaultDisplay().mDisplayContent;
        if (this.mKeyguardShowing && this.canDismissKeyguard() && dc.mAppTransition.getAppTransition() == 23) {
            dc.prepareAppTransition(this.mBeforeUnoccludeTransit, false, 0, true);
            this.mRootActivityContainer.ensureActivitiesVisible(null, 0, false);
            this.mWindowManager.executeAppTransition();
        }
    }

    private boolean isDisplayOccluded(int displayId) {
        return this.getDisplay(displayId).mOccluded;
    }

    boolean canDismissKeyguard() {
        return this.mWindowManager.isKeyguardTrusted() || !this.mWindowManager.isKeyguardSecure(this.mService.getCurrentUserId());
    }

    private int resolveOccludeTransit() {
        DisplayContent dc = this.mService.mRootActivityContainer.getDefaultDisplay().mDisplayContent;
        if (this.mBeforeUnoccludeTransit != -1 && dc.mAppTransition.getAppTransition() == 23 && this.isDisplayOccluded(0)) {
            return this.mBeforeUnoccludeTransit;
        }
        if (!this.isDisplayOccluded(0)) {
            this.mBeforeUnoccludeTransit = dc.mAppTransition.getAppTransition();
            return 23;
        }
        return 22;
    }

    private void dismissDockedStackIfNeeded() {
        if (this.mKeyguardShowing && this.isDisplayOccluded(0)) {
            ActivityStack stack = this.mRootActivityContainer.getDefaultDisplay().getSplitScreenPrimaryStack();
            if (stack == null) {
                return;
            }
            this.mStackSupervisor.moveTasksToFullscreenStackLocked(stack, stack.isFocusedStackOnDisplay());
        }
    }

    private void updateKeyguardSleepToken() {
        for (int displayNdx = this.mRootActivityContainer.getChildCount() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mRootActivityContainer.getChildAt(displayNdx);
            this.updateKeyguardSleepToken(display.mDisplayId);
        }
    }

    private void updateKeyguardSleepToken(int displayId) {
        KeyguardDisplayState state = this.getDisplay(displayId);
        if (this.isKeyguardUnoccludedOrAodShowing(displayId) && state.mSleepToken == null) {
            state.acquiredSleepToken();
        } else if (!this.isKeyguardUnoccludedOrAodShowing(displayId) && state.mSleepToken != null) {
            state.releaseSleepToken();
        }
    }

    private KeyguardDisplayState getDisplay(int displayId) {
        KeyguardDisplayState state = this.mDisplayStates.get(displayId);
        if (state == null) {
            state = new KeyguardDisplayState(this.mService, displayId);
            this.mDisplayStates.append(displayId, state);
        }
        return state;
    }

    void onDisplayRemoved(int displayId) {
        KeyguardDisplayState state = this.mDisplayStates.get(displayId);
        if (state != null) {
            state.onRemoved();
            this.mDisplayStates.remove(displayId);
        }
    }

    void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "KeyguardController:");
        pw.println(prefix + "  mKeyguardShowing=" + this.mKeyguardShowing);
        pw.println(prefix + "  mAodShowing=" + this.mAodShowing);
        pw.println(prefix + "  mKeyguardGoingAway=" + this.mKeyguardGoingAway);
        this.dumpDisplayStates(pw, prefix);
        pw.println(prefix + "  mDismissalRequested=" + this.mDismissalRequested);
        pw.println(prefix + "  mVisibilityTransactionDepth=" + this.mVisibilityTransactionDepth);
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(1133871366147L, this.mAodShowing);
        proto.write(0x10800000001L, this.mKeyguardShowing);
        this.writeDisplayStatesToProto(proto, 0x20B00000002L);
        proto.end(token);
    }

    private void dumpDisplayStates(PrintWriter pw, String prefix) {
        for (int i = 0; i < this.mDisplayStates.size(); ++i) {
            this.mDisplayStates.valueAt(i).dumpStatus(pw, prefix);
        }
    }

    private void writeDisplayStatesToProto(ProtoOutputStream proto, long fieldId) {
        for (int i = 0; i < this.mDisplayStates.size(); ++i) {
            this.mDisplayStates.valueAt(i).writeToProto(proto, fieldId);
        }
    }

    private static class KeyguardDisplayState {
        private final int mDisplayId;
        private boolean mOccluded;
        private ActivityRecord mDismissingKeyguardActivity;
        private boolean mRequestDismissKeyguard;
        private final ActivityTaskManagerService mService;
        private ActivityTaskManagerInternal.SleepToken mSleepToken;

        KeyguardDisplayState(ActivityTaskManagerService service, int displayId) {
            this.mService = service;
            this.mDisplayId = displayId;
        }

        void onRemoved() {
            this.mDismissingKeyguardActivity = null;
            this.releaseSleepToken();
        }

        void acquiredSleepToken() {
            if (this.mSleepToken == null) {
                this.mSleepToken = this.mService.acquireSleepToken("keyguard", this.mDisplayId);
            }
        }

        void releaseSleepToken() {
            if (this.mSleepToken != null) {
                this.mSleepToken.release();
                this.mSleepToken = null;
            }
        }

        void visibilitiesUpdated(KeyguardController controller, ActivityDisplay display) {
            boolean lastOccluded = this.mOccluded;
            ActivityRecord lastDismissActivity = this.mDismissingKeyguardActivity;
            this.mRequestDismissKeyguard = false;
            this.mOccluded = false;
            this.mDismissingKeyguardActivity = null;
            ActivityStack stack = this.getStackForControllingOccluding(display);
            if (stack != null) {
                ActivityRecord topDismissing = stack.getTopDismissingKeyguardActivity();
                boolean bl = this.mOccluded = stack.topActivityOccludesKeyguard() || topDismissing != null && stack.topRunningActivityLocked() == topDismissing && controller.canShowWhileOccluded(true, false);
                if (stack.getTopDismissingKeyguardActivity() != null) {
                    this.mDismissingKeyguardActivity = stack.getTopDismissingKeyguardActivity();
                }
                if (this.mDisplayId != 0) {
                    this.mOccluded |= stack.canShowWithInsecureKeyguard() && controller.canDismissKeyguard();
                }
            }
            if (this.mDisplayId == 0) {
                this.mOccluded |= controller.mWindowManager.isShowingDream();
            }
            if (lastOccluded != this.mOccluded) {
                controller.handleOccludedChanged(this.mDisplayId);
            }
            if (lastDismissActivity != this.mDismissingKeyguardActivity && !this.mOccluded && this.mDismissingKeyguardActivity != null && controller.mWindowManager.isKeyguardSecure(controller.mService.getCurrentUserId())) {
                this.mRequestDismissKeyguard = true;
            }
        }

        private ActivityStack getStackForControllingOccluding(ActivityDisplay display) {
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (stack == null || !stack.isFocusableAndVisible() || stack.inPinnedWindowingMode()) continue;
                return stack;
            }
            return null;
        }

        void dumpStatus(PrintWriter pw, String prefix) {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix);
            sb.append("  Occluded=").append(this.mOccluded).append(" DismissingKeyguardActivity=").append(this.mDismissingKeyguardActivity).append(" at display=").append(this.mDisplayId);
            pw.println(sb.toString());
        }

        void writeToProto(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10500000001L, this.mDisplayId);
            proto.write(1133871366146L, this.mOccluded);
            proto.end(token);
        }
    }
}

