/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.admin.DevicePolicyCache;
import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.UserManagerInternal;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.LocalServices;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.utils.UserTokenWatcher;
import com.android.server.wm.LockTaskController;

class KeyguardDisableHandler {
    private static final String TAG = "WindowManager";
    private final UserTokenWatcher mAppTokenWatcher;
    private final UserTokenWatcher mSystemTokenWatcher;
    private int mCurrentUser = 0;
    private Injector mInjector;
    private final UserTokenWatcher.Callback mCallback = new UserTokenWatcher.Callback(){

        @Override
        public void acquired(int userId) {
            KeyguardDisableHandler.this.updateKeyguardEnabled(userId);
        }

        @Override
        public void released(int userId) {
            KeyguardDisableHandler.this.updateKeyguardEnabled(userId);
        }
    };

    @VisibleForTesting
    KeyguardDisableHandler(Injector injector, Handler handler) {
        this.mInjector = injector;
        this.mAppTokenWatcher = new UserTokenWatcher(this.mCallback, handler, TAG);
        this.mSystemTokenWatcher = new UserTokenWatcher(this.mCallback, handler, TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentUser(int user) {
        KeyguardDisableHandler keyguardDisableHandler = this;
        synchronized (keyguardDisableHandler) {
            this.mCurrentUser = user;
            this.updateKeyguardEnabledLocked(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateKeyguardEnabled(int userId) {
        KeyguardDisableHandler keyguardDisableHandler = this;
        synchronized (keyguardDisableHandler) {
            this.updateKeyguardEnabledLocked(userId);
        }
    }

    private void updateKeyguardEnabledLocked(int userId) {
        if (this.mCurrentUser == userId || userId == -1) {
            this.mInjector.enableKeyguard(this.shouldKeyguardBeEnabled(this.mCurrentUser));
        }
    }

    void disableKeyguard(IBinder token, String tag, int callingUid, int userId) {
        UserTokenWatcher watcherForCaller = this.watcherForCallingUid(token, callingUid);
        watcherForCaller.acquire(token, tag, this.mInjector.getProfileParentId(userId));
    }

    void reenableKeyguard(IBinder token, int callingUid, int userId) {
        UserTokenWatcher watcherForCaller = this.watcherForCallingUid(token, callingUid);
        watcherForCaller.release(token, this.mInjector.getProfileParentId(userId));
    }

    private UserTokenWatcher watcherForCallingUid(IBinder token, int callingUid) {
        if (Process.isApplicationUid(callingUid)) {
            return this.mAppTokenWatcher;
        }
        if (callingUid == 1000 && token instanceof LockTaskController.LockTaskToken) {
            return this.mSystemTokenWatcher;
        }
        throw new UnsupportedOperationException("Only apps can use the KeyguardLock API");
    }

    private boolean shouldKeyguardBeEnabled(int userId) {
        boolean dpmRequiresPassword = this.mInjector.dpmRequiresPassword(this.mCurrentUser);
        boolean keyguardSecure = this.mInjector.isKeyguardSecure(this.mCurrentUser);
        boolean allowedFromApps = !dpmRequiresPassword && !keyguardSecure;
        boolean allowedFromSystem = !dpmRequiresPassword;
        boolean shouldBeDisabled = allowedFromApps && this.mAppTokenWatcher.isAcquired(userId) || allowedFromSystem && this.mSystemTokenWatcher.isAcquired(userId);
        return !shouldBeDisabled;
    }

    static KeyguardDisableHandler create(Context context, final WindowManagerPolicy policy, Handler handler) {
        final UserManagerInternal userManager = LocalServices.getService(UserManagerInternal.class);
        return new KeyguardDisableHandler(new Injector(){

            @Override
            public boolean dpmRequiresPassword(int userId) {
                return DevicePolicyCache.getInstance().getPasswordQuality(userId) != 0;
            }

            @Override
            public boolean isKeyguardSecure(int userId) {
                return policy.isKeyguardSecure(userId);
            }

            @Override
            public int getProfileParentId(int userId) {
                return userManager.getProfileParentId(userId);
            }

            @Override
            public void enableKeyguard(boolean enabled) {
                policy.enableKeyguard(enabled);
            }
        }, handler);
    }

    static interface Injector {
        public boolean dpmRequiresPassword(int var1);

        public boolean isKeyguardSecure(int var1);

        public int getProfileParentId(int var1);

        public void enableKeyguard(boolean var1);
    }
}

