/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.wm.ActivityMetricsLaunchObserver;
import com.android.server.wm.ActivityMetricsLaunchObserverRegistry;
import java.util.ArrayList;

class LaunchObserverRegistryImpl
implements ActivityMetricsLaunchObserverRegistry,
ActivityMetricsLaunchObserver {
    private final ArrayList<ActivityMetricsLaunchObserver> mList = new ArrayList();
    private final Handler mHandler;

    public LaunchObserverRegistryImpl(Looper looper) {
        this.mHandler = new Handler(looper);
    }

    @Override
    public void registerLaunchObserver(ActivityMetricsLaunchObserver launchObserver) {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(LaunchObserverRegistryImpl::handleRegisterLaunchObserver, this, launchObserver));
    }

    @Override
    public void unregisterLaunchObserver(ActivityMetricsLaunchObserver launchObserver) {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(LaunchObserverRegistryImpl::handleUnregisterLaunchObserver, this, launchObserver));
    }

    @Override
    public void onIntentStarted(Intent intent) {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(LaunchObserverRegistryImpl::handleOnIntentStarted, this, intent));
    }

    @Override
    public void onIntentFailed() {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(LaunchObserverRegistryImpl::handleOnIntentFailed, this));
    }

    @Override
    public void onActivityLaunched(byte[] activity, int temperature) {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(LaunchObserverRegistryImpl::handleOnActivityLaunched, this, activity, temperature));
    }

    @Override
    public void onActivityLaunchCancelled(byte[] activity) {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(LaunchObserverRegistryImpl::handleOnActivityLaunchCancelled, this, activity));
    }

    @Override
    public void onActivityLaunchFinished(byte[] activity) {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(LaunchObserverRegistryImpl::handleOnActivityLaunchFinished, this, activity));
    }

    private void handleRegisterLaunchObserver(ActivityMetricsLaunchObserver observer) {
        this.mList.add(observer);
    }

    private void handleUnregisterLaunchObserver(ActivityMetricsLaunchObserver observer) {
        this.mList.remove(observer);
    }

    private void handleOnIntentStarted(Intent intent) {
        for (int i = 0; i < this.mList.size(); ++i) {
            ActivityMetricsLaunchObserver o = this.mList.get(i);
            o.onIntentStarted(intent);
        }
    }

    private void handleOnIntentFailed() {
        for (int i = 0; i < this.mList.size(); ++i) {
            ActivityMetricsLaunchObserver o = this.mList.get(i);
            o.onIntentFailed();
        }
    }

    private void handleOnActivityLaunched(byte[] activity, int temperature) {
        for (int i = 0; i < this.mList.size(); ++i) {
            ActivityMetricsLaunchObserver o = this.mList.get(i);
            o.onActivityLaunched(activity, temperature);
        }
    }

    private void handleOnActivityLaunchCancelled(byte[] activity) {
        for (int i = 0; i < this.mList.size(); ++i) {
            ActivityMetricsLaunchObserver o = this.mList.get(i);
            o.onActivityLaunchCancelled(activity);
        }
    }

    private void handleOnActivityLaunchFinished(byte[] activity) {
        for (int i = 0; i < this.mList.size(); ++i) {
            ActivityMetricsLaunchObserver o = this.mList.get(i);
            o.onActivityLaunchFinished(activity);
        }
    }
}

