/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityOptions;
import android.content.pm.ActivityInfo;
import android.graphics.Rect;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityStackSupervisor;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.LaunchParamsPersister;
import com.android.server.wm.TaskLaunchParamsModifier;
import com.android.server.wm.TaskRecord;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

class LaunchParamsController {
    private final ActivityTaskManagerService mService;
    private final LaunchParamsPersister mPersister;
    private final List<LaunchParamsModifier> mModifiers = new ArrayList<LaunchParamsModifier>();
    private final LaunchParams mTmpParams = new LaunchParams();
    private final LaunchParams mTmpCurrent = new LaunchParams();
    private final LaunchParams mTmpResult = new LaunchParams();

    LaunchParamsController(ActivityTaskManagerService service, LaunchParamsPersister persister) {
        this.mService = service;
        this.mPersister = persister;
    }

    void registerDefaultModifiers(ActivityStackSupervisor supervisor) {
        this.registerModifier(new TaskLaunchParamsModifier(supervisor));
    }

    void calculate(TaskRecord task, ActivityInfo.WindowLayout layout2, ActivityRecord activity, ActivityRecord source, ActivityOptions options, int phase, LaunchParams result) {
        result.reset();
        if (task != null || activity != null) {
            this.mPersister.getLaunchParams(task, activity, result);
        }
        block5: for (int i = this.mModifiers.size() - 1; i >= 0; --i) {
            this.mTmpCurrent.set(result);
            this.mTmpResult.reset();
            LaunchParamsModifier modifier = this.mModifiers.get(i);
            switch (modifier.onCalculate(task, layout2, activity, source, options, phase, this.mTmpCurrent, this.mTmpResult)) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    result.set(this.mTmpResult);
                    return;
                }
                case 2: {
                    result.set(this.mTmpResult);
                }
            }
        }
        if (activity != null && activity.requestedVrComponent != null) {
            result.mPreferredDisplayId = 0;
        } else if (this.mService.mVr2dDisplayId != -1) {
            result.mPreferredDisplayId = this.mService.mVr2dDisplayId;
        }
    }

    boolean layoutTask(TaskRecord task, ActivityInfo.WindowLayout layout2) {
        return this.layoutTask(task, layout2, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean layoutTask(TaskRecord task, ActivityInfo.WindowLayout layout2, ActivityRecord activity, ActivityRecord source, ActivityOptions options) {
        this.calculate(task, layout2, activity, source, options, 2, this.mTmpParams);
        if (this.mTmpParams.isEmpty()) {
            return false;
        }
        this.mService.mWindowManager.deferSurfaceLayout();
        try {
            if (this.mTmpParams.hasPreferredDisplay() && this.mTmpParams.mPreferredDisplayId != ((ActivityStack)task.getStack()).getDisplay().mDisplayId) {
                this.mService.moveStackToDisplay(task.getStackId(), this.mTmpParams.mPreferredDisplayId);
            }
            if (this.mTmpParams.hasWindowingMode() && this.mTmpParams.mWindowingMode != ((ConfigurationContainer)task.getStack()).getWindowingMode()) {
                ((ActivityStack)task.getStack()).setWindowingMode(this.mTmpParams.mWindowingMode);
            }
            if (this.mTmpParams.mBounds.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            if (((ConfigurationContainer)task.getStack()).inFreeformWindowingMode()) {
                task.updateOverrideConfiguration(this.mTmpParams.mBounds);
                boolean bl = true;
                return bl;
            }
            task.setLastNonFullscreenBounds(this.mTmpParams.mBounds);
            boolean bl = false;
            return bl;
        }
        finally {
            this.mService.mWindowManager.continueSurfaceLayout();
        }
    }

    void registerModifier(LaunchParamsModifier modifier) {
        if (this.mModifiers.contains(modifier)) {
            return;
        }
        this.mModifiers.add(modifier);
    }

    static interface LaunchParamsModifier {
        public static final int RESULT_SKIP = 0;
        public static final int RESULT_DONE = 1;
        public static final int RESULT_CONTINUE = 2;
        public static final int PHASE_DISPLAY = 0;
        public static final int PHASE_WINDOWING_MODE = 1;
        public static final int PHASE_BOUNDS = 2;

        public int onCalculate(TaskRecord var1, ActivityInfo.WindowLayout var2, ActivityRecord var3, ActivityRecord var4, ActivityOptions var5, int var6, LaunchParams var7, LaunchParams var8);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Phase {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Result {
        }
    }

    static class LaunchParams {
        final Rect mBounds = new Rect();
        int mPreferredDisplayId;
        int mWindowingMode;

        LaunchParams() {
        }

        void reset() {
            this.mBounds.setEmpty();
            this.mPreferredDisplayId = -1;
            this.mWindowingMode = 0;
        }

        void set(LaunchParams params) {
            this.mBounds.set(params.mBounds);
            this.mPreferredDisplayId = params.mPreferredDisplayId;
            this.mWindowingMode = params.mWindowingMode;
        }

        boolean isEmpty() {
            return this.mBounds.isEmpty() && this.mPreferredDisplayId == -1 && this.mWindowingMode == 0;
        }

        boolean hasWindowingMode() {
            return this.mWindowingMode != 0;
        }

        boolean hasPreferredDisplay() {
            return this.mPreferredDisplayId != -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LaunchParams that = (LaunchParams)o;
            if (this.mPreferredDisplayId != that.mPreferredDisplayId) {
                return false;
            }
            if (this.mWindowingMode != that.mWindowingMode) {
                return false;
            }
            return this.mBounds != null ? this.mBounds.equals(that.mBounds) : that.mBounds == null;
        }

        public int hashCode() {
            int result = this.mBounds != null ? this.mBounds.hashCode() : 0;
            result = 31 * result + this.mPreferredDisplayId;
            result = 31 * result + this.mWindowingMode;
            return result;
        }
    }
}

