/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.ComponentName;
import android.content.pm.PackageList;
import android.content.pm.PackageManagerInternal;
import android.graphics.Rect;
import android.os.Environment;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import android.view.DisplayInfo;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FastXmlSerializer;
import com.android.server.LocalServices;
import com.android.server.wm.ActivityDisplay;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityStackSupervisor;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.LaunchParamsController;
import com.android.server.wm.PersisterQueue;
import com.android.server.wm.TaskRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlSerializer;

class LaunchParamsPersister {
    private static final String TAG = "LaunchParamsPersister";
    private static final String LAUNCH_PARAMS_DIRNAME = "launch_params";
    private static final String LAUNCH_PARAMS_FILE_SUFFIX = ".xml";
    private static final char ORIGINAL_COMPONENT_SEPARATOR = '/';
    private static final char ESCAPED_COMPONENT_SEPARATOR = '_';
    private static final String TAG_LAUNCH_PARAMS = "launch_params";
    private final PersisterQueue mPersisterQueue;
    private final ActivityStackSupervisor mSupervisor;
    private final IntFunction<File> mUserFolderGetter;
    private PackageList mPackageList;
    private final SparseArray<ArrayMap<ComponentName, PersistableLaunchParams>> mMap = new SparseArray();

    LaunchParamsPersister(PersisterQueue persisterQueue, ActivityStackSupervisor supervisor) {
        this(persisterQueue, supervisor, Environment::getDataSystemCeDirectory);
    }

    @VisibleForTesting
    LaunchParamsPersister(PersisterQueue persisterQueue, ActivityStackSupervisor supervisor, IntFunction<File> userFolderGetter) {
        this.mPersisterQueue = persisterQueue;
        this.mSupervisor = supervisor;
        this.mUserFolderGetter = userFolderGetter;
    }

    void onSystemReady() {
        PackageManagerInternal pmi = LocalServices.getService(PackageManagerInternal.class);
        this.mPackageList = pmi.getPackageList(new PackageListObserver());
    }

    void onUnlockUser(int userId) {
        this.loadLaunchParams(userId);
    }

    void onCleanupUser(int userId) {
        this.mMap.remove(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLaunchParams(int userId) {
        ArrayList<File> filesToDelete = new ArrayList<File>();
        File launchParamsFolder = this.getLaunchParamFolder(userId);
        if (!launchParamsFolder.isDirectory()) {
            Slog.i(TAG, "Didn't find launch param folder for user " + userId);
            return;
        }
        ArraySet<String> packages = new ArraySet<String>(this.mPackageList.getPackageNames());
        File[] paramsFiles = launchParamsFolder.listFiles();
        ArrayMap<ComponentName, PersistableLaunchParams> map = new ArrayMap<ComponentName, PersistableLaunchParams>(paramsFiles.length);
        this.mMap.put(userId, map);
        for (File paramsFile : paramsFiles) {
            if (!paramsFile.isFile()) {
                Slog.w(TAG, paramsFile.getAbsolutePath() + " is not a file.");
                continue;
            }
            if (!paramsFile.getName().endsWith(LAUNCH_PARAMS_FILE_SUFFIX)) {
                Slog.w(TAG, "Unexpected params file name: " + paramsFile.getName());
                filesToDelete.add(paramsFile);
                continue;
            }
            String paramsFileName = paramsFile.getName();
            String componentNameString = paramsFileName.substring(0, paramsFileName.length() - LAUNCH_PARAMS_FILE_SUFFIX.length()).replace('_', '/');
            ComponentName name = ComponentName.unflattenFromString(componentNameString);
            if (name == null) {
                Slog.w(TAG, "Unexpected file name: " + paramsFileName);
                filesToDelete.add(paramsFile);
                continue;
            }
            if (!packages.contains(name.getPackageName())) {
                filesToDelete.add(paramsFile);
                continue;
            }
            BufferedReader reader = null;
            try {
                int event;
                reader = new BufferedReader(new FileReader(paramsFile));
                PersistableLaunchParams params = new PersistableLaunchParams();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(reader);
                while ((event = parser.next()) != 1 && event != 3) {
                    if (event != 2) continue;
                    String tagName = parser.getName();
                    if (!"launch_params".equals(tagName)) {
                        Slog.w(TAG, "Unexpected tag name: " + tagName);
                        continue;
                    }
                    params.restoreFromXml(parser);
                }
                map.put(name, params);
            }
            catch (Exception e) {
                try {
                    Slog.w(TAG, "Failed to restore launch params for " + name, e);
                    filesToDelete.add(paramsFile);
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(reader);
                    throw throwable;
                }
                IoUtils.closeQuietly(reader);
                continue;
            }
            IoUtils.closeQuietly(reader);
        }
        if (!filesToDelete.isEmpty()) {
            this.mPersisterQueue.addItem(new CleanUpComponentQueueItem(filesToDelete), true);
        }
    }

    void saveTask(TaskRecord task) {
        boolean changed;
        PersistableLaunchParams params;
        ComponentName name = task.realActivity;
        int userId = task.userId;
        ArrayMap<ComponentName, PersistableLaunchParams> map = this.mMap.get(userId);
        if (map == null) {
            map = new ArrayMap();
            this.mMap.put(userId, map);
        }
        if ((params = map.get(name)) == null) {
            params = new PersistableLaunchParams();
            map.put(name, params);
        }
        if (changed = this.saveTaskToLaunchParam(task, params)) {
            this.mPersisterQueue.updateLastOrAddItem(new LaunchParamsWriteQueueItem(userId, name, params), false);
        }
    }

    private boolean saveTaskToLaunchParam(TaskRecord task, PersistableLaunchParams params) {
        Object stack = task.getStack();
        int displayId = ((ActivityStack)stack).mDisplayId;
        ActivityDisplay display = this.mSupervisor.mRootActivityContainer.getActivityDisplay(displayId);
        DisplayInfo info = new DisplayInfo();
        display.mDisplay.getDisplayInfo(info);
        boolean changed = !Objects.equals(params.mDisplayUniqueId, info.uniqueId);
        params.mDisplayUniqueId = info.uniqueId;
        changed |= params.mWindowingMode != ((ConfigurationContainer)stack).getWindowingMode();
        params.mWindowingMode = ((ConfigurationContainer)stack).getWindowingMode();
        if (task.mLastNonFullscreenBounds != null) {
            changed |= !Objects.equals(params.mBounds, task.mLastNonFullscreenBounds);
            params.mBounds.set(task.mLastNonFullscreenBounds);
        } else {
            changed |= !params.mBounds.isEmpty();
            params.mBounds.setEmpty();
        }
        return changed;
    }

    void getLaunchParams(TaskRecord task, ActivityRecord activity, LaunchParamsController.LaunchParams outParams) {
        ComponentName name = task != null ? task.realActivity : activity.mActivityComponent;
        int userId = task != null ? task.userId : activity.mUserId;
        outParams.reset();
        Map map = this.mMap.get(userId);
        if (map == null) {
            return;
        }
        PersistableLaunchParams persistableParams = (PersistableLaunchParams)map.get(name);
        if (persistableParams == null) {
            return;
        }
        ActivityDisplay display = this.mSupervisor.mRootActivityContainer.getActivityDisplay(persistableParams.mDisplayUniqueId);
        if (display != null) {
            outParams.mPreferredDisplayId = display.mDisplayId;
        }
        outParams.mWindowingMode = persistableParams.mWindowingMode;
        outParams.mBounds.set(persistableParams.mBounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRecordForPackage(String packageName) {
        ArrayList<File> fileToDelete = new ArrayList<File>();
        for (int i = 0; i < this.mMap.size(); ++i) {
            int userId = this.mMap.keyAt(i);
            File launchParamsFolder = this.getLaunchParamFolder(userId);
            ArrayMap<ComponentName, PersistableLaunchParams> map = this.mMap.valueAt(i);
            for (int j = map.size() - 1; j >= 0; --j) {
                ComponentName name = map.keyAt(j);
                if (!name.getPackageName().equals(packageName)) continue;
                map.removeAt(j);
                fileToDelete.add(this.getParamFile(launchParamsFolder, name));
            }
        }
        PersisterQueue persisterQueue = this.mPersisterQueue;
        synchronized (persisterQueue) {
            this.mPersisterQueue.removeItems(item -> ((LaunchParamsWriteQueueItem)item).mComponentName.getPackageName().equals(packageName), LaunchParamsWriteQueueItem.class);
            this.mPersisterQueue.addItem(new CleanUpComponentQueueItem(fileToDelete), true);
        }
    }

    private File getParamFile(File launchParamFolder, ComponentName name) {
        String componentNameString = name.flattenToShortString().replace('/', '_');
        return new File(launchParamFolder, componentNameString + LAUNCH_PARAMS_FILE_SUFFIX);
    }

    private File getLaunchParamFolder(int userId) {
        File userFolder = this.mUserFolderGetter.apply(userId);
        return new File(userFolder, "launch_params");
    }

    private class PersistableLaunchParams {
        private static final String ATTR_WINDOWING_MODE = "windowing_mode";
        private static final String ATTR_DISPLAY_UNIQUE_ID = "display_unique_id";
        private static final String ATTR_BOUNDS = "bounds";
        final Rect mBounds = new Rect();
        String mDisplayUniqueId;
        int mWindowingMode;

        private PersistableLaunchParams() {
        }

        void saveToXml(XmlSerializer serializer) throws IOException {
            serializer.attribute(null, ATTR_DISPLAY_UNIQUE_ID, this.mDisplayUniqueId);
            serializer.attribute(null, ATTR_WINDOWING_MODE, Integer.toString(this.mWindowingMode));
            serializer.attribute(null, ATTR_BOUNDS, this.mBounds.flattenToString());
        }

        void restoreFromXml(XmlPullParser parser) {
            block10: for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String attrValue = parser.getAttributeValue(i);
                switch (parser.getAttributeName(i)) {
                    case "display_unique_id": {
                        this.mDisplayUniqueId = attrValue;
                        continue block10;
                    }
                    case "windowing_mode": {
                        this.mWindowingMode = Integer.parseInt(attrValue);
                        continue block10;
                    }
                    case "bounds": {
                        Rect bounds = Rect.unflattenFromString(attrValue);
                        if (bounds == null) continue block10;
                        this.mBounds.set(bounds);
                        continue block10;
                    }
                }
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PersistableLaunchParams{");
            builder.append("windowingMode=" + this.mWindowingMode);
            builder.append(" displayUniqueId=" + this.mDisplayUniqueId);
            builder.append(" bounds=" + this.mBounds);
            builder.append(" }");
            return builder.toString();
        }
    }

    private class CleanUpComponentQueueItem
    implements PersisterQueue.WriteQueueItem {
        private final List<File> mComponentFiles;

        private CleanUpComponentQueueItem(List<File> componentFiles) {
            this.mComponentFiles = componentFiles;
        }

        @Override
        public void process() {
            for (File file : this.mComponentFiles) {
                if (file.delete()) continue;
                Slog.w(LaunchParamsPersister.TAG, "Failed to delete " + file.getAbsolutePath());
            }
        }
    }

    private class LaunchParamsWriteQueueItem
    implements PersisterQueue.WriteQueueItem<LaunchParamsWriteQueueItem> {
        private final int mUserId;
        private final ComponentName mComponentName;
        private PersistableLaunchParams mLaunchParams;

        private LaunchParamsWriteQueueItem(int userId, ComponentName componentName, PersistableLaunchParams launchParams) {
            this.mUserId = userId;
            this.mComponentName = componentName;
            this.mLaunchParams = launchParams;
        }

        private StringWriter saveParamsToXml() {
            StringWriter writer = new StringWriter();
            FastXmlSerializer serializer = new FastXmlSerializer();
            try {
                serializer.setOutput(writer);
                serializer.startDocument(null, true);
                serializer.startTag(null, "launch_params");
                this.mLaunchParams.saveToXml(serializer);
                serializer.endTag(null, "launch_params");
                serializer.endDocument();
                serializer.flush();
                return writer;
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public void process() {
            StringWriter writer = this.saveParamsToXml();
            File launchParamFolder = LaunchParamsPersister.this.getLaunchParamFolder(this.mUserId);
            if (!launchParamFolder.isDirectory() && !launchParamFolder.mkdirs()) {
                Slog.w(LaunchParamsPersister.TAG, "Failed to create folder for " + this.mUserId);
                return;
            }
            File launchParamFile = LaunchParamsPersister.this.getParamFile(launchParamFolder, this.mComponentName);
            AtomicFile atomicFile = new AtomicFile(launchParamFile);
            FileOutputStream stream = null;
            try {
                stream = atomicFile.startWrite();
                stream.write(writer.toString().getBytes());
            }
            catch (Exception e) {
                Slog.e(LaunchParamsPersister.TAG, "Failed to write param file for " + this.mComponentName, e);
                if (stream != null) {
                    atomicFile.failWrite(stream);
                }
                return;
            }
            atomicFile.finishWrite(stream);
        }

        @Override
        public boolean matches(LaunchParamsWriteQueueItem item) {
            return this.mUserId == item.mUserId && this.mComponentName.equals(item.mComponentName);
        }

        @Override
        public void updateFrom(LaunchParamsWriteQueueItem item) {
            this.mLaunchParams = item.mLaunchParams;
        }
    }

    private class PackageListObserver
    implements PackageManagerInternal.PackageListObserver {
        private PackageListObserver() {
        }

        @Override
        public void onPackageAdded(String packageName, int uid) {
        }

        @Override
        public void onPackageRemoved(String packageName, int uid) {
            LaunchParamsPersister.this.removeRecordForPackage(packageName);
        }
    }
}

