/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Process;
import android.view.InputChannel;
import android.view.InputEventReceiver;
import android.view.InputWindowHandle;
import android.view.SurfaceControl;
import com.android.server.UiThread;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.util.function.Supplier;

public class Letterbox {
    private static final Rect EMPTY_RECT = new Rect();
    private static final Point ZERO_POINT = new Point(0, 0);
    private final Supplier<SurfaceControl.Builder> mFactory;
    private final Rect mOuter = new Rect();
    private final Rect mInner = new Rect();
    private final LetterboxSurface mTop = new LetterboxSurface("top");
    private final LetterboxSurface mLeft = new LetterboxSurface("left");
    private final LetterboxSurface mBottom = new LetterboxSurface("bottom");
    private final LetterboxSurface mRight = new LetterboxSurface("right");
    private final LetterboxSurface[] mSurfaces = new LetterboxSurface[]{this.mLeft, this.mTop, this.mRight, this.mBottom};

    public Letterbox(Supplier<SurfaceControl.Builder> surfaceControlFactory) {
        this.mFactory = surfaceControlFactory;
    }

    public void layout(Rect outer, Rect inner, Point surfaceOrigin) {
        this.mOuter.set(outer);
        this.mInner.set(inner);
        this.mTop.layout(outer.left, outer.top, inner.right, inner.top, surfaceOrigin);
        this.mLeft.layout(outer.left, inner.top, inner.left, outer.bottom, surfaceOrigin);
        this.mBottom.layout(inner.left, inner.bottom, outer.right, outer.bottom, surfaceOrigin);
        this.mRight.layout(inner.right, outer.top, outer.right, inner.bottom, surfaceOrigin);
    }

    public Rect getInsets() {
        return new Rect(this.mLeft.getWidth(), this.mTop.getHeight(), this.mRight.getWidth(), this.mBottom.getHeight());
    }

    Rect getInnerFrame() {
        return this.mInner;
    }

    public boolean isOverlappingWith(Rect rect) {
        for (LetterboxSurface surface : this.mSurfaces) {
            if (!surface.isOverlappingWith(rect)) continue;
            return true;
        }
        return false;
    }

    public void hide() {
        this.layout(EMPTY_RECT, EMPTY_RECT, ZERO_POINT);
    }

    public void destroy() {
        this.mOuter.setEmpty();
        this.mInner.setEmpty();
        for (LetterboxSurface surface : this.mSurfaces) {
            surface.remove();
        }
    }

    public boolean needsApplySurfaceChanges() {
        for (LetterboxSurface surface : this.mSurfaces) {
            if (!surface.needsApplySurfaceChanges()) continue;
            return true;
        }
        return false;
    }

    public void applySurfaceChanges(SurfaceControl.Transaction t) {
        for (LetterboxSurface surface : this.mSurfaces) {
            surface.applySurfaceChanges(t);
        }
    }

    void attachInput(WindowState win) {
        for (LetterboxSurface surface : this.mSurfaces) {
            surface.attachInput(win);
        }
    }

    void onMovedToDisplay(int displayId) {
        for (LetterboxSurface surface : this.mSurfaces) {
            if (surface.mInputInterceptor == null) continue;
            ((LetterboxSurface)surface).mInputInterceptor.mWindowHandle.displayId = displayId;
        }
    }

    private class LetterboxSurface {
        private final String mType;
        private SurfaceControl mSurface;
        private final Rect mSurfaceFrameRelative = new Rect();
        private final Rect mLayoutFrameGlobal = new Rect();
        private final Rect mLayoutFrameRelative = new Rect();
        private InputInterceptor mInputInterceptor;

        public LetterboxSurface(String type) {
            this.mType = type;
        }

        public void layout(int left, int top, int right, int bottom, Point surfaceOrigin) {
            this.mLayoutFrameGlobal.set(left, top, right, bottom);
            this.mLayoutFrameRelative.set(this.mLayoutFrameGlobal);
            this.mLayoutFrameRelative.offset(-surfaceOrigin.x, -surfaceOrigin.y);
        }

        private void createSurface() {
            this.mSurface = ((SurfaceControl.Builder)Letterbox.this.mFactory.get()).setName("Letterbox - " + this.mType).setFlags(4).setColorLayer().build();
            this.mSurface.setLayer(-1);
            this.mSurface.setColor(new float[]{0.0f, 0.0f, 0.0f});
            this.mSurface.setColorSpaceAgnostic(true);
        }

        void attachInput(WindowState win) {
            if (this.mInputInterceptor != null) {
                this.mInputInterceptor.dispose();
            }
            this.mInputInterceptor = new InputInterceptor("Letterbox_" + this.mType + "_", win);
        }

        public void remove() {
            if (this.mSurface != null) {
                this.mSurface.remove();
                this.mSurface = null;
            }
            if (this.mInputInterceptor != null) {
                this.mInputInterceptor.dispose();
                this.mInputInterceptor = null;
            }
        }

        public int getWidth() {
            return Math.max(0, this.mLayoutFrameGlobal.width());
        }

        public int getHeight() {
            return Math.max(0, this.mLayoutFrameGlobal.height());
        }

        public boolean isOverlappingWith(Rect rect) {
            if (this.mLayoutFrameGlobal.isEmpty()) {
                return false;
            }
            return Rect.intersects(rect, this.mLayoutFrameGlobal);
        }

        public void applySurfaceChanges(SurfaceControl.Transaction t) {
            if (this.mSurfaceFrameRelative.equals(this.mLayoutFrameRelative)) {
                return;
            }
            this.mSurfaceFrameRelative.set(this.mLayoutFrameRelative);
            if (!this.mSurfaceFrameRelative.isEmpty()) {
                if (this.mSurface == null) {
                    this.createSurface();
                }
                t.setPosition(this.mSurface, this.mSurfaceFrameRelative.left, this.mSurfaceFrameRelative.top);
                t.setWindowCrop(this.mSurface, this.mSurfaceFrameRelative.width(), this.mSurfaceFrameRelative.height());
                t.show(this.mSurface);
            } else if (this.mSurface != null) {
                t.hide(this.mSurface);
            }
            if (this.mSurface != null && this.mInputInterceptor != null) {
                this.mInputInterceptor.updateTouchableRegion(this.mSurfaceFrameRelative);
                t.setInputWindowInfo(this.mSurface, this.mInputInterceptor.mWindowHandle);
            }
        }

        public boolean needsApplySurfaceChanges() {
            return !this.mSurfaceFrameRelative.equals(this.mLayoutFrameRelative);
        }
    }

    private static class InputInterceptor {
        final InputChannel mServerChannel;
        final InputChannel mClientChannel;
        final InputWindowHandle mWindowHandle;
        final InputEventReceiver mInputEventReceiver;
        final WindowManagerService mWmService;
        final Binder mToken = new Binder();

        InputInterceptor(String namePrefix, WindowState win) {
            this.mWmService = win.mWmService;
            String name = namePrefix + (win.mAppToken != null ? win.mAppToken : win);
            InputChannel[] channels = InputChannel.openInputChannelPair(name);
            this.mServerChannel = channels[0];
            this.mClientChannel = channels[1];
            this.mInputEventReceiver = new SimpleInputReceiver(this.mClientChannel);
            this.mWmService.mInputManager.registerInputChannel(this.mServerChannel, this.mToken);
            this.mWindowHandle = new InputWindowHandle(null, null, win.getDisplayId());
            this.mWindowHandle.name = name;
            this.mWindowHandle.token = this.mToken;
            this.mWindowHandle.layoutParamsFlags = 0x20800028;
            this.mWindowHandle.layoutParamsType = 2022;
            this.mWindowHandle.dispatchingTimeoutNanos = 5000000000L;
            this.mWindowHandle.visible = true;
            this.mWindowHandle.ownerPid = Process.myPid();
            this.mWindowHandle.ownerUid = Process.myUid();
            this.mWindowHandle.scaleFactor = 1.0f;
        }

        void updateTouchableRegion(Rect frame) {
            if (frame.isEmpty()) {
                this.mWindowHandle.token = null;
                return;
            }
            this.mWindowHandle.token = this.mToken;
            this.mWindowHandle.touchableRegion.set(frame);
            this.mWindowHandle.touchableRegion.translate(-frame.left, -frame.top);
        }

        void dispose() {
            this.mWmService.mInputManager.unregisterInputChannel(this.mServerChannel);
            this.mInputEventReceiver.dispose();
            this.mServerChannel.dispose();
            this.mClientChannel.dispose();
        }

        private static class SimpleInputReceiver
        extends InputEventReceiver {
            SimpleInputReceiver(InputChannel inputChannel) {
                super(inputChannel, UiThread.getHandler().getLooper());
            }
        }
    }
}

