/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.Process;
import android.os.SystemClock;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.function.Predicate;

class PersisterQueue {
    private static final String TAG = "PersisterQueue";
    private static final boolean DEBUG = false;
    private static final long INTER_WRITE_DELAY_MS = 500L;
    private static final long PRE_TASK_DELAY_MS = 3000L;
    private static final int MAX_WRITE_QUEUE_LENGTH = 6;
    private static final long FLUSH_QUEUE = -1L;
    static final WriteQueueItem EMPTY_ITEM = () -> {};
    private final long mInterWriteDelayMs;
    private final long mPreTaskDelayMs;
    private final LazyTaskWriterThread mLazyTaskWriterThread;
    private final ArrayList<WriteQueueItem> mWriteQueue = new ArrayList();
    private final ArrayList<Listener> mListeners = new ArrayList();
    private long mNextWriteTime = 0L;

    PersisterQueue() {
        this(500L, 3000L);
    }

    @VisibleForTesting
    PersisterQueue(long interWriteDelayMs, long preTaskDelayMs) {
        if (interWriteDelayMs < 0L || preTaskDelayMs < 0L) {
            throw new IllegalArgumentException("Both inter-write delay and pre-task delay need tobe non-negative. inter-write delay: " + interWriteDelayMs + "ms pre-task delay: " + preTaskDelayMs);
        }
        this.mInterWriteDelayMs = interWriteDelayMs;
        this.mPreTaskDelayMs = preTaskDelayMs;
        this.mLazyTaskWriterThread = new LazyTaskWriterThread("LazyTaskWriterThread");
    }

    synchronized void startPersisting() {
        if (!this.mLazyTaskWriterThread.isAlive()) {
            this.mLazyTaskWriterThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void stopPersisting() throws InterruptedException {
        if (!this.mLazyTaskWriterThread.isAlive()) {
            return;
        }
        PersisterQueue persisterQueue = this;
        synchronized (persisterQueue) {
            this.mLazyTaskWriterThread.interrupt();
        }
        this.mLazyTaskWriterThread.join();
    }

    synchronized void addItem(WriteQueueItem item, boolean flush) {
        this.mWriteQueue.add(item);
        if (flush || this.mWriteQueue.size() > 6) {
            this.mNextWriteTime = -1L;
        } else if (this.mNextWriteTime == 0L) {
            this.mNextWriteTime = SystemClock.uptimeMillis() + this.mPreTaskDelayMs;
        }
        this.notify();
    }

    synchronized <T extends WriteQueueItem> T findLastItem(Predicate<T> predicate, Class<T> clazz) {
        for (int i = this.mWriteQueue.size() - 1; i >= 0; --i) {
            WriteQueueItem item;
            WriteQueueItem writeQueueItem = this.mWriteQueue.get(i);
            if (!clazz.isInstance(writeQueueItem) || !predicate.test(item = (WriteQueueItem)clazz.cast(writeQueueItem))) continue;
            return (T)item;
        }
        return null;
    }

    synchronized <T extends WriteQueueItem> void updateLastOrAddItem(T item, boolean flush) {
        WriteQueueItem itemToUpdate = this.findLastItem(item::matches, item.getClass());
        if (itemToUpdate == null) {
            this.addItem(item, flush);
        } else {
            itemToUpdate.updateFrom(item);
        }
        this.yieldIfQueueTooDeep();
    }

    synchronized <T extends WriteQueueItem> void removeItems(Predicate<T> predicate, Class<T> clazz) {
        for (int i = this.mWriteQueue.size() - 1; i >= 0; --i) {
            WriteQueueItem item;
            WriteQueueItem writeQueueItem = this.mWriteQueue.get(i);
            if (!clazz.isInstance(writeQueueItem) || !predicate.test(item = (WriteQueueItem)clazz.cast(writeQueueItem))) continue;
            this.mWriteQueue.remove(i);
        }
    }

    synchronized void flush() {
        this.mNextWriteTime = -1L;
        this.notifyAll();
        do {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.mNextWriteTime == -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void yieldIfQueueTooDeep() {
        boolean stall = false;
        PersisterQueue persisterQueue = this;
        synchronized (persisterQueue) {
            if (this.mNextWriteTime == -1L) {
                stall = true;
            }
        }
        if (stall) {
            Thread.yield();
        }
    }

    void addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    @VisibleForTesting
    boolean removeListener(Listener listener) {
        return this.mListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextItem() throws InterruptedException {
        WriteQueueItem item;
        PersisterQueue persisterQueue = this;
        synchronized (persisterQueue) {
            if (this.mNextWriteTime != -1L) {
                this.mNextWriteTime = SystemClock.uptimeMillis() + this.mInterWriteDelayMs;
            }
            while (this.mWriteQueue.isEmpty()) {
                if (this.mNextWriteTime != 0L) {
                    this.mNextWriteTime = 0L;
                    this.notify();
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                this.wait();
            }
            item = this.mWriteQueue.remove(0);
            long now = SystemClock.uptimeMillis();
            while (now < this.mNextWriteTime) {
                this.wait(this.mNextWriteTime - now);
                now = SystemClock.uptimeMillis();
            }
        }
        item.process();
    }

    private class LazyTaskWriterThread
    extends Thread {
        private LazyTaskWriterThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Process.setThreadPriority(10);
            try {
                while (true) {
                    boolean probablyDone;
                    PersisterQueue persisterQueue = PersisterQueue.this;
                    synchronized (persisterQueue) {
                        probablyDone = PersisterQueue.this.mWriteQueue.isEmpty();
                    }
                    for (int i = PersisterQueue.this.mListeners.size() - 1; i >= 0; --i) {
                        ((Listener)PersisterQueue.this.mListeners.get(i)).onPreProcessItem(probablyDone);
                    }
                    PersisterQueue.this.processNextItem();
                }
            }
            catch (InterruptedException e) {
                Slog.e(PersisterQueue.TAG, "Persister thread is exiting. Should never happen in prod, butit's OK in tests.");
                return;
            }
        }
    }

    static interface Listener {
        public void onPreProcessItem(boolean var1);
    }

    static interface WriteQueueItem<T extends WriteQueueItem<T>> {
        public void process();

        default public void updateFrom(T item) {
        }

        default public boolean matches(T item) {
            return false;
        }
    }
}

