/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.RemoteAction;
import android.content.pm.ParceledListSlice;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Size;
import android.util.Slog;
import android.util.TypedValue;
import android.util.proto.ProtoOutputStream;
import android.view.DisplayInfo;
import android.view.Gravity;
import android.view.IPinnedStackController;
import android.view.IPinnedStackListener;
import com.android.internal.policy.PipSnapAlgorithm;
import com.android.internal.util.Preconditions;
import com.android.server.UiThread;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

class PinnedStackController {
    private static final String TAG = "WindowManager";
    public static final float INVALID_SNAP_FRACTION = -1.0f;
    private final WindowManagerService mService;
    private final DisplayContent mDisplayContent;
    private final Handler mHandler = UiThread.getHandler();
    private IPinnedStackListener mPinnedStackListener;
    private final PinnedStackListenerDeathHandler mPinnedStackListenerDeathHandler = new PinnedStackListenerDeathHandler();
    private final PinnedStackControllerCallback mCallbacks = new PinnedStackControllerCallback();
    private final PipSnapAlgorithm mSnapAlgorithm;
    private boolean mIsMinimized;
    private boolean mIsImeShowing;
    private int mImeHeight;
    private boolean mIsShelfShowing;
    private int mShelfHeight;
    private ArrayList<RemoteAction> mActions = new ArrayList();
    private float mAspectRatio = -1.0f;
    private final DisplayInfo mDisplayInfo = new DisplayInfo();
    private final Rect mStableInsets = new Rect();
    private int mDefaultMinSize;
    private int mDefaultStackGravity;
    private float mDefaultAspectRatio;
    private Point mScreenEdgeInsets;
    private int mCurrentMinSize;
    private float mReentrySnapFraction = -1.0f;
    private WeakReference<AppWindowToken> mLastPipActivity = null;
    private float mMinAspectRatio;
    private float mMaxAspectRatio;
    private final DisplayMetrics mTmpMetrics = new DisplayMetrics();
    private final Rect mTmpInsets = new Rect();
    private final Rect mTmpRect = new Rect();
    private final Rect mTmpAnimatingBoundsRect = new Rect();
    private final Point mTmpDisplaySize = new Point();

    PinnedStackController(WindowManagerService service, DisplayContent displayContent) {
        this.mService = service;
        this.mDisplayContent = displayContent;
        this.mSnapAlgorithm = new PipSnapAlgorithm(service.mContext);
        this.mDisplayInfo.copyFrom(this.mDisplayContent.getDisplayInfo());
        this.reloadResources();
        this.mAspectRatio = this.mDefaultAspectRatio;
    }

    void onConfigurationChanged() {
        this.reloadResources();
    }

    private void reloadResources() {
        Resources res = this.mService.mContext.getResources();
        this.mCurrentMinSize = this.mDefaultMinSize = res.getDimensionPixelSize(17105122);
        this.mDefaultAspectRatio = res.getFloat(17105066);
        String screenEdgeInsetsDpString = res.getString(17039708);
        Size screenEdgeInsetsDp = !screenEdgeInsetsDpString.isEmpty() ? Size.parseSize(screenEdgeInsetsDpString) : null;
        this.mDefaultStackGravity = res.getInteger(17694780);
        this.mDisplayContent.getDisplay().getRealMetrics(this.mTmpMetrics);
        this.mScreenEdgeInsets = screenEdgeInsetsDp == null ? new Point() : new Point(this.dpToPx(screenEdgeInsetsDp.getWidth(), this.mTmpMetrics), this.dpToPx(screenEdgeInsetsDp.getHeight(), this.mTmpMetrics));
        this.mMinAspectRatio = res.getFloat(17105069);
        this.mMaxAspectRatio = res.getFloat(17105068);
    }

    void registerPinnedStackListener(IPinnedStackListener listener) {
        try {
            listener.asBinder().linkToDeath(this.mPinnedStackListenerDeathHandler, 0);
            listener.onListenerRegistered(this.mCallbacks);
            this.mPinnedStackListener = listener;
            this.notifyImeVisibilityChanged(this.mIsImeShowing, this.mImeHeight);
            this.notifyShelfVisibilityChanged(this.mIsShelfShowing, this.mShelfHeight);
            this.notifyMovementBoundsChanged(false, false);
            this.notifyActionsChanged(this.mActions);
            this.notifyMinimizeChanged(this.mIsMinimized);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to register pinned stack listener", e);
        }
    }

    public boolean isValidPictureInPictureAspectRatio(float aspectRatio) {
        return Float.compare(this.mMinAspectRatio, aspectRatio) <= 0 && Float.compare(aspectRatio, this.mMaxAspectRatio) <= 0;
    }

    Rect transformBoundsToAspectRatio(Rect stackBounds, float aspectRatio, boolean useCurrentMinEdgeSize) {
        float snapFraction = this.mSnapAlgorithm.getSnapFraction(stackBounds, this.getMovementBounds(stackBounds));
        int minEdgeSize = useCurrentMinEdgeSize ? this.mCurrentMinSize : this.mDefaultMinSize;
        Size size = this.mSnapAlgorithm.getSizeForAspectRatio(aspectRatio, minEdgeSize, this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
        int left = (int)((float)stackBounds.centerX() - (float)size.getWidth() / 2.0f);
        int top = (int)((float)stackBounds.centerY() - (float)size.getHeight() / 2.0f);
        stackBounds.set(left, top, left + size.getWidth(), top + size.getHeight());
        this.mSnapAlgorithm.applySnapFraction(stackBounds, this.getMovementBounds(stackBounds), snapFraction);
        if (this.mIsMinimized) {
            this.applyMinimizedOffset(stackBounds, this.getMovementBounds(stackBounds));
        }
        return stackBounds;
    }

    void saveReentrySnapFraction(AppWindowToken token, Rect stackBounds) {
        this.mReentrySnapFraction = this.getSnapFraction(stackBounds);
        this.mLastPipActivity = new WeakReference<AppWindowToken>(token);
    }

    void resetReentrySnapFraction(AppWindowToken token) {
        if (this.mLastPipActivity != null && this.mLastPipActivity.get() == token) {
            this.mReentrySnapFraction = -1.0f;
            this.mLastPipActivity = null;
        }
    }

    Rect getDefaultOrLastSavedBounds() {
        return this.getDefaultBounds(this.mReentrySnapFraction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Rect getDefaultBounds(float snapFraction) {
        Rect rect;
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                Rect insetBounds = new Rect();
                this.getInsetBounds(insetBounds);
                Rect defaultBounds = new Rect();
                Size size = this.mSnapAlgorithm.getSizeForAspectRatio(this.mDefaultAspectRatio, this.mDefaultMinSize, this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
                if (snapFraction != -1.0f) {
                    defaultBounds.set(0, 0, size.getWidth(), size.getHeight());
                    Rect movementBounds = this.getMovementBounds(defaultBounds);
                    this.mSnapAlgorithm.applySnapFraction(defaultBounds, movementBounds, snapFraction);
                } else {
                    Gravity.apply(this.mDefaultStackGravity, size.getWidth(), size.getHeight(), insetBounds, 0, Math.max(this.mIsImeShowing ? this.mImeHeight : 0, this.mIsShelfShowing ? this.mShelfHeight : 0), defaultBounds);
                }
                rect = defaultBounds;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl19 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return rect;
    }

    synchronized void onDisplayInfoChanged(DisplayInfo displayInfo) {
        this.mDisplayInfo.copyFrom(displayInfo);
        this.notifyMovementBoundsChanged(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean onTaskStackBoundsChanged(Rect targetBounds, Rect outBounds) {
        DisplayInfo displayInfo;
        block7: {
            block6: {
                boolean bl;
                WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
                // MONITORENTER : windowManagerGlobalLock
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    displayInfo = this.mDisplayContent.getDisplayInfo();
                    if (!this.isSameDimensionAndRotation(this.mDisplayInfo, displayInfo)) break block6;
                    outBounds.setEmpty();
                    bl = false;
                    // MONITOREXIT : windowManagerGlobalLock
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowManagerGlobalLock
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return bl;
            }
            if (!targetBounds.isEmpty()) break block7;
            this.mDisplayInfo.copyFrom(displayInfo);
            outBounds.setEmpty();
            boolean bl = false;
            // MONITOREXIT : windowManagerGlobalLock
            WindowManagerService.resetPriorityAfterLockedSection();
            return bl;
        }
        this.mTmpRect.set(targetBounds);
        Rect postChangeStackBounds = this.mTmpRect;
        float snapFraction = this.getSnapFraction(postChangeStackBounds);
        this.mDisplayInfo.copyFrom(displayInfo);
        Rect postChangeMovementBounds = this.getMovementBounds(postChangeStackBounds, false, false);
        this.mSnapAlgorithm.applySnapFraction(postChangeStackBounds, postChangeMovementBounds, snapFraction);
        if (this.mIsMinimized) {
            this.applyMinimizedOffset(postChangeStackBounds, postChangeMovementBounds);
        }
        this.notifyMovementBoundsChanged(false, false);
        outBounds.set(postChangeStackBounds);
        boolean bl = true;
        // MONITOREXIT : windowManagerGlobalLock
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    void setAdjustedForIme(boolean adjustedForIme, int imeHeight) {
        boolean imeShowing = adjustedForIme && imeHeight > 0;
        int n = imeHeight = imeShowing ? imeHeight : 0;
        if (imeShowing == this.mIsImeShowing && imeHeight == this.mImeHeight) {
            return;
        }
        this.mIsImeShowing = imeShowing;
        this.mImeHeight = imeHeight;
        this.notifyImeVisibilityChanged(imeShowing, imeHeight);
        this.notifyMovementBoundsChanged(true, false);
    }

    void setAdjustedForShelf(boolean adjustedForShelf, int shelfHeight) {
        boolean shelfShowing;
        boolean bl = shelfShowing = adjustedForShelf && shelfHeight > 0;
        if (shelfShowing == this.mIsShelfShowing && shelfHeight == this.mShelfHeight) {
            return;
        }
        this.mIsShelfShowing = shelfShowing;
        this.mShelfHeight = shelfHeight;
        this.notifyShelfVisibilityChanged(shelfShowing, shelfHeight);
        this.notifyMovementBoundsChanged(false, true);
    }

    void setAspectRatio(float aspectRatio) {
        if (Float.compare(this.mAspectRatio, aspectRatio) != 0) {
            this.mAspectRatio = aspectRatio;
            this.notifyMovementBoundsChanged(false, false);
        }
    }

    float getAspectRatio() {
        return this.mAspectRatio;
    }

    void setActions(List<RemoteAction> actions) {
        this.mActions.clear();
        if (actions != null) {
            this.mActions.addAll(actions);
        }
        this.notifyActionsChanged(this.mActions);
    }

    private boolean isSameDimensionAndRotation(DisplayInfo display1, DisplayInfo display2) {
        Preconditions.checkNotNull(display1);
        Preconditions.checkNotNull(display2);
        return display1.rotation == display2.rotation && display1.logicalWidth == display2.logicalWidth && display1.logicalHeight == display2.logicalHeight;
    }

    private void notifyImeVisibilityChanged(boolean imeVisible, int imeHeight) {
        if (this.mPinnedStackListener != null) {
            try {
                this.mPinnedStackListener.onImeVisibilityChanged(imeVisible, imeHeight);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering bounds changed event.", e);
            }
        }
    }

    private void notifyShelfVisibilityChanged(boolean shelfVisible, int shelfHeight) {
        if (this.mPinnedStackListener != null) {
            try {
                this.mPinnedStackListener.onShelfVisibilityChanged(shelfVisible, shelfHeight);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering bounds changed event.", e);
            }
        }
    }

    private void notifyMinimizeChanged(boolean isMinimized) {
        if (this.mPinnedStackListener != null) {
            try {
                this.mPinnedStackListener.onMinimizedStateChanged(isMinimized);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering minimize changed event.", e);
            }
        }
    }

    private void notifyActionsChanged(List<RemoteAction> actions) {
        if (this.mPinnedStackListener != null) {
            try {
                this.mPinnedStackListener.onActionsChanged(new ParceledListSlice<RemoteAction>(actions));
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering actions changed event.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void notifyMovementBoundsChanged(boolean fromImeAdjustment, boolean fromShelfAdjustment) {
        block9: {
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            // MONITORENTER : windowManagerGlobalLock
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mPinnedStackListener != null) break block9;
                // MONITOREXIT : windowManagerGlobalLock
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        try {
            Rect insetBounds = new Rect();
            this.getInsetBounds(insetBounds);
            Rect normalBounds = this.getDefaultBounds(-1.0f);
            if (this.isValidPictureInPictureAspectRatio(this.mAspectRatio)) {
                this.transformBoundsToAspectRatio(normalBounds, this.mAspectRatio, false);
            }
            Rect animatingBounds = this.mTmpAnimatingBoundsRect;
            TaskStack pinnedStack = this.mDisplayContent.getPinnedStack();
            if (pinnedStack != null) {
                pinnedStack.getAnimationOrCurrentBounds(animatingBounds);
            } else {
                animatingBounds.set(normalBounds);
            }
            this.mPinnedStackListener.onMovementBoundsChanged(insetBounds, normalBounds, animatingBounds, fromImeAdjustment, fromShelfAdjustment, this.mDisplayInfo.rotation);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Error delivering actions changed event.", e);
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInsetBounds(Rect outRect) {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mDisplayContent.getDisplayPolicy().getStableInsetsLw(this.mDisplayInfo.rotation, this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight, this.mDisplayInfo.displayCutout, this.mTmpInsets);
                outRect.set(this.mTmpInsets.left + this.mScreenEdgeInsets.x, this.mTmpInsets.top + this.mScreenEdgeInsets.y, this.mDisplayInfo.logicalWidth - this.mTmpInsets.right - this.mScreenEdgeInsets.x, this.mDisplayInfo.logicalHeight - this.mTmpInsets.bottom - this.mScreenEdgeInsets.y);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Rect getMovementBounds(Rect stackBounds) {
        Rect rect;
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                rect = this.getMovementBounds(stackBounds, true, true);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Rect getMovementBounds(Rect stackBounds, boolean adjustForIme, boolean adjustForShelf) {
        Rect rect;
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                Rect movementBounds = new Rect();
                this.getInsetBounds(movementBounds);
                this.mSnapAlgorithm.getMovementBounds(stackBounds, movementBounds, movementBounds, Math.max(adjustForIme && this.mIsImeShowing ? this.mImeHeight : 0, adjustForShelf && this.mIsShelfShowing ? this.mShelfHeight : 0));
                rect = movementBounds;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMinimizedOffset(Rect stackBounds, Rect movementBounds) {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mTmpDisplaySize.set(this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
                this.mService.getStableInsetsLocked(this.mDisplayContent.getDisplayId(), this.mStableInsets);
                this.mSnapAlgorithm.applyMinimizedOffset(stackBounds, movementBounds, this.mTmpDisplaySize, this.mStableInsets);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    private float getSnapFraction(Rect stackBounds) {
        return this.mSnapAlgorithm.getSnapFraction(stackBounds, this.getMovementBounds(stackBounds));
    }

    private int dpToPx(float dpValue, DisplayMetrics dm) {
        return (int)TypedValue.applyDimension(1, dpValue, dm);
    }

    void dump(String prefix, PrintWriter pw) {
        pw.println(prefix + "PinnedStackController");
        pw.print(prefix + "  defaultBounds=");
        this.getDefaultBounds(-1.0f).printShortString(pw);
        pw.println();
        pw.println(prefix + "  mDefaultMinSize=" + this.mDefaultMinSize);
        pw.println(prefix + "  mDefaultStackGravity=" + this.mDefaultStackGravity);
        pw.println(prefix + "  mDefaultAspectRatio=" + this.mDefaultAspectRatio);
        this.mService.getStackBounds(2, 1, this.mTmpRect);
        pw.print(prefix + "  movementBounds=");
        this.getMovementBounds(this.mTmpRect).printShortString(pw);
        pw.println();
        pw.println(prefix + "  mIsImeShowing=" + this.mIsImeShowing);
        pw.println(prefix + "  mImeHeight=" + this.mImeHeight);
        pw.println(prefix + "  mIsShelfShowing=" + this.mIsShelfShowing);
        pw.println(prefix + "  mShelfHeight=" + this.mShelfHeight);
        pw.println(prefix + "  mReentrySnapFraction=" + this.mReentrySnapFraction);
        pw.println(prefix + "  mIsMinimized=" + this.mIsMinimized);
        pw.println(prefix + "  mAspectRatio=" + this.mAspectRatio);
        pw.println(prefix + "  mMinAspectRatio=" + this.mMinAspectRatio);
        pw.println(prefix + "  mMaxAspectRatio=" + this.mMaxAspectRatio);
        if (this.mActions.isEmpty()) {
            pw.println(prefix + "  mActions=[]");
        } else {
            pw.println(prefix + "  mActions=[");
            for (int i = 0; i < this.mActions.size(); ++i) {
                RemoteAction action = this.mActions.get(i);
                pw.print(prefix + "    Action[" + i + "]: ");
                action.dump("", pw);
            }
            pw.println(prefix + "  ]");
        }
        pw.println(prefix + "  mDisplayInfo=" + this.mDisplayInfo);
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        this.getDefaultBounds(-1.0f).writeToProto(proto, 0x10B00000001L);
        this.mService.getStackBounds(2, 1, this.mTmpRect);
        this.getMovementBounds(this.mTmpRect).writeToProto(proto, 1146756268034L);
        proto.end(token);
    }

    private class PinnedStackListenerDeathHandler
    implements IBinder.DeathRecipient {
        private PinnedStackListenerDeathHandler() {
        }

        @Override
        public void binderDied() {
            if (PinnedStackController.this.mPinnedStackListener != null) {
                PinnedStackController.this.mPinnedStackListener.asBinder().unlinkToDeath(PinnedStackController.this.mPinnedStackListenerDeathHandler, 0);
            }
            PinnedStackController.this.mPinnedStackListener = null;
        }
    }

    private class PinnedStackControllerCallback
    extends IPinnedStackController.Stub {
        private PinnedStackControllerCallback() {
        }

        @Override
        public void setIsMinimized(boolean isMinimized) {
            PinnedStackController.this.mHandler.post(() -> {
                PinnedStackController.this.mIsMinimized = isMinimized;
                PinnedStackController.this.mSnapAlgorithm.setMinimized(isMinimized);
            });
        }

        @Override
        public void setMinEdgeSize(int minEdgeSize) {
            PinnedStackController.this.mHandler.post(() -> PinnedStackController.this.mCurrentMinSize = Math.max(PinnedStackController.this.mDefaultMinSize, minEdgeSize));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int getDisplayRotation() {
            int n;
            WindowManagerGlobalLock windowManagerGlobalLock = ((PinnedStackController)PinnedStackController.this).mService.mGlobalLock;
            synchronized (windowManagerGlobalLock) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    n = ((PinnedStackController)PinnedStackController.this).mDisplayInfo.rotation;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return n;
        }
    }
}

