/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityOptions;
import android.app.IAssistDataReceiver;
import android.content.ComponentName;
import android.content.Intent;
import android.os.RemoteException;
import android.os.Trace;
import android.util.Slog;
import android.view.IRecentsAnimationRunner;
import com.android.server.wm.ActivityDisplay;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityStackSupervisor;
import com.android.server.wm.ActivityStartController;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.RecentsAnimationController;
import com.android.server.wm.SafeActivityOptions;
import com.android.server.wm.Task;
import com.android.server.wm.TaskRecord;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;

class RecentsAnimation
implements RecentsAnimationController.RecentsAnimationCallbacks,
ActivityDisplay.OnStackOrderChangedListener {
    private static final String TAG = RecentsAnimation.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final ActivityTaskManagerService mService;
    private final ActivityStackSupervisor mStackSupervisor;
    private final ActivityStartController mActivityStartController;
    private final WindowManagerService mWindowManager;
    private final ActivityDisplay mDefaultDisplay;
    private final int mCallingPid;
    private ActivityRecord mLaunchedTargetActivity;
    private int mTargetActivityType;
    private ActivityStack mRestoreTargetBehindStack;

    RecentsAnimation(ActivityTaskManagerService atm, ActivityStackSupervisor stackSupervisor, ActivityStartController activityStartController, WindowManagerService wm, int callingPid) {
        this.mService = atm;
        this.mStackSupervisor = stackSupervisor;
        this.mDefaultDisplay = this.mService.mRootActivityContainer.getDefaultDisplay();
        this.mActivityStartController = activityStartController;
        this.mWindowManager = wm;
        this.mCallingPid = callingPid;
    }

    void startRecentsActivity(Intent intent, IRecentsAnimationRunner recentsAnimationRunner, ComponentName recentsComponent, int recentsUid, @Deprecated IAssistDataReceiver assistDataReceiver) {
        boolean hasExistingActivity;
        Trace.traceBegin(64L, "RecentsAnimation#startRecentsActivity");
        DisplayContent dc = this.mService.mRootActivityContainer.getDefaultDisplay().mDisplayContent;
        if (!this.mWindowManager.canStartRecentsAnimation()) {
            this.notifyAnimationCancelBeforeStart(recentsAnimationRunner);
            return;
        }
        int userId = this.mService.getCurrentUserId();
        this.mTargetActivityType = intent.getComponent() != null && recentsComponent.equals(intent.getComponent()) ? 3 : 2;
        Object targetStack = this.mDefaultDisplay.getStack(0, this.mTargetActivityType);
        ActivityRecord targetActivity = this.getTargetActivity((ActivityStack)targetStack, intent.getComponent(), userId);
        boolean bl = hasExistingActivity = targetActivity != null;
        if (hasExistingActivity) {
            ActivityDisplay display = targetActivity.getDisplay();
            this.mRestoreTargetBehindStack = display.getStackAbove((ActivityStack)targetStack);
            if (this.mRestoreTargetBehindStack == null) {
                this.notifyAnimationCancelBeforeStart(recentsAnimationRunner);
                return;
            }
        }
        if (targetActivity == null || !targetActivity.visible) {
            this.mService.mRootActivityContainer.sendPowerHintForLaunchStartIfNeeded(true, targetActivity);
        }
        this.mStackSupervisor.getActivityMetricsLogger().notifyActivityLaunching(intent);
        this.mService.mH.post(() -> this.mService.mAmInternal.setRunningRemoteAnimation(this.mCallingPid, true));
        this.mWindowManager.deferSurfaceLayout();
        try {
            if (hasExistingActivity) {
                this.mDefaultDisplay.moveStackBehindBottomMostVisibleStack((ActivityStack)targetStack);
                if (((ActivityStack)targetStack).topTask() != targetActivity.getTaskRecord()) {
                    ((ActivityStack)targetStack).addTask(targetActivity.getTaskRecord(), true, "startRecentsActivity");
                }
            } else {
                ActivityOptions options = ActivityOptions.makeBasic();
                options.setLaunchActivityType(this.mTargetActivityType);
                options.setAvoidMoveToFront();
                intent.addFlags(0x10010000);
                this.mActivityStartController.obtainStarter(intent, "startRecentsActivity_noTargetActivity").setCallingUid(recentsUid).setCallingPackage(recentsComponent.getPackageName()).setActivityOptions(SafeActivityOptions.fromBundle(options.toBundle())).setMayWait(userId).execute();
                targetStack = this.mDefaultDisplay.getStack(0, this.mTargetActivityType);
                targetActivity = this.getTargetActivity((ActivityStack)targetStack, intent.getComponent(), userId);
                this.mDefaultDisplay.moveStackBehindBottomMostVisibleStack((ActivityStack)targetStack);
                this.mWindowManager.prepareAppTransition(0, false);
                this.mWindowManager.executeAppTransition();
            }
            targetActivity.mLaunchTaskBehind = true;
            this.mLaunchedTargetActivity = targetActivity;
            this.mWindowManager.cancelRecentsAnimationSynchronously(2, "startRecentsActivity");
            this.mWindowManager.initializeRecentsAnimation(this.mTargetActivityType, recentsAnimationRunner, this, this.mDefaultDisplay.mDisplayId, this.mStackSupervisor.mRecentTasks.getRecentTaskIds());
            this.mService.mRootActivityContainer.ensureActivitiesVisible(null, 0, true);
            this.mStackSupervisor.getActivityMetricsLogger().notifyActivityLaunched(2, targetActivity);
            this.mDefaultDisplay.registerStackOrderChangedListener(this);
        }
        catch (Exception e) {
            Slog.e(TAG, "Failed to start recents activity", e);
            throw e;
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void finishAnimation(@RecentsAnimationController.ReorderMode int reorderMode, boolean sendUserLeaveHint) {
        RecentsAnimationController controller;
        block6: {
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            // MONITORENTER : windowManagerGlobalLock
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mDefaultDisplay.unregisterStackOrderChangedListener(this);
                controller = this.mWindowManager.getRecentsAnimationController();
                if (controller != null) break block6;
                // MONITOREXIT : windowManagerGlobalLock
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        if (reorderMode != 0) {
            this.mService.mRootActivityContainer.sendPowerHintForLaunchEndIfNeeded();
        }
        if (reorderMode == 1) {
            this.mService.stopAppSwitches();
        }
        this.mService.mH.post(() -> this.mService.mAmInternal.setRunningRemoteAnimation(this.mCallingPid, false));
        this.mWindowManager.inSurfaceTransaction(() -> {
            Trace.traceBegin(64L, "RecentsAnimation#onAnimationFinished_inSurfaceTransaction");
            this.mWindowManager.deferSurfaceLayout();
            try {
                ActivityRecord targetActivity;
                this.mWindowManager.cleanupRecentsAnimation(reorderMode);
                Object targetStack = this.mDefaultDisplay.getStack(0, this.mTargetActivityType);
                ActivityRecord activityRecord = targetActivity = targetStack != null ? ((ActivityStack)targetStack).isInStackLocked(this.mLaunchedTargetActivity) : null;
                if (targetActivity == null) {
                    return;
                }
                targetActivity.mLaunchTaskBehind = false;
                if (reorderMode == 1) {
                    this.mStackSupervisor.mNoAnimActivities.add(targetActivity);
                    if (sendUserLeaveHint) {
                        this.mStackSupervisor.mUserLeaving = true;
                        ((ActivityStack)targetStack).moveTaskToFrontLocked(targetActivity.getTaskRecord(), true, null, targetActivity.appTimeTracker, "RecentsAnimation.onAnimationFinished()");
                    } else {
                        ((ActivityStack)targetStack).moveToFront("RecentsAnimation.onAnimationFinished()");
                    }
                } else if (reorderMode == 2) {
                    ActivityDisplay display = targetActivity.getDisplay();
                    display.moveStackBehindStack((ActivityStack)targetStack, this.mRestoreTargetBehindStack);
                } else {
                    if (!controller.shouldCancelWithDeferredScreenshot() && !((ActivityStack)targetStack).isFocusedStackOnDisplay()) {
                        ((ActivityStack)targetStack).ensureActivitiesVisibleLocked(null, 0, false);
                    }
                    return;
                }
                this.mWindowManager.prepareAppTransition(0, false);
                this.mService.mRootActivityContainer.ensureActivitiesVisible(null, 0, false);
                this.mService.mRootActivityContainer.resumeFocusedStacksTopActivities();
                this.mWindowManager.executeAppTransition();
                this.mWindowManager.checkSplitScreenMinimizedChanged(true);
            }
            catch (Exception e) {
                Slog.e(TAG, "Failed to clean up recents activity", e);
                throw e;
            }
            finally {
                this.mWindowManager.continueSurfaceLayout();
                Trace.traceEnd(64L);
            }
        });
        // MONITOREXIT : windowManagerGlobalLock
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void onAnimationFinished(@RecentsAnimationController.ReorderMode int reorderMode, boolean runSychronously, boolean sendUserLeaveHint) {
        if (runSychronously) {
            this.finishAnimation(reorderMode, sendUserLeaveHint);
        } else {
            this.mService.mH.post(() -> this.finishAnimation(reorderMode, sendUserLeaveHint));
        }
    }

    @Override
    public void onStackOrderChanged(ActivityStack stack) {
        if (this.mDefaultDisplay.getIndexOf(stack) == -1 || !stack.shouldBeVisible(null)) {
            return;
        }
        RecentsAnimationController controller = this.mWindowManager.getRecentsAnimationController();
        if (controller == null) {
            return;
        }
        DisplayContent dc = this.mService.mRootActivityContainer.getDefaultDisplay().mDisplayContent;
        dc.mBoundsAnimationController.setAnimationType(controller.shouldCancelWithDeferredScreenshot() ? 1 : 0);
        if ((!controller.isAnimatingTask((Task)stack.getTaskStack().getTopChild()) || controller.isTargetApp(stack.getTopActivity().mAppWindowToken)) && controller.shouldCancelWithDeferredScreenshot()) {
            controller.cancelOnNextTransitionStart();
        } else {
            this.mWindowManager.cancelRecentsAnimationSynchronously(0, "stackOrderChanged");
        }
    }

    private void notifyAnimationCancelBeforeStart(IRecentsAnimationRunner recentsAnimationRunner) {
        try {
            recentsAnimationRunner.onAnimationCanceled(false);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to cancel recents animation before start", e);
        }
    }

    private ActivityStack getTopNonAlwaysOnTopStack() {
        for (int i = this.mDefaultDisplay.getChildCount() - 1; i >= 0; --i) {
            ActivityStack s = this.mDefaultDisplay.getChildAt(i);
            if (s.getWindowConfiguration().isAlwaysOnTop()) continue;
            return s;
        }
        return null;
    }

    private ActivityRecord getTargetActivity(ActivityStack targetStack, ComponentName component, int userId) {
        if (targetStack == null) {
            return null;
        }
        for (int i = targetStack.getChildCount() - 1; i >= 0; --i) {
            TaskRecord task = targetStack.getChildAt(i);
            if (task.userId != userId || !task.getBaseIntent().getComponent().equals(component)) continue;
            return task.getTopActivity();
        }
        return null;
    }
}

