/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.IRemoteAnimationFinishedCallback;
import android.view.RemoteAnimationAdapter;
import android.view.RemoteAnimationTarget;
import android.view.SurfaceControl;
import com.android.internal.util.FastPrintWriter;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.SurfaceAnimator;
import com.android.server.wm.Task;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.utils.InsetUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

class RemoteAnimationController
implements IBinder.DeathRecipient {
    private static final String TAG = "WindowManager";
    private static final long TIMEOUT_MS = 2000L;
    private final WindowManagerService mService;
    private final RemoteAnimationAdapter mRemoteAnimationAdapter;
    private final ArrayList<RemoteAnimationRecord> mPendingAnimations = new ArrayList();
    private final Rect mTmpRect = new Rect();
    private final Handler mHandler;
    private final Runnable mTimeoutRunnable = () -> this.cancelAnimation("timeoutRunnable");
    private FinishedCallback mFinishedCallback;
    private boolean mCanceled;
    private boolean mLinkedToDeathOfRunner;

    RemoteAnimationController(WindowManagerService service, RemoteAnimationAdapter remoteAnimationAdapter, Handler handler) {
        this.mService = service;
        this.mRemoteAnimationAdapter = remoteAnimationAdapter;
        this.mHandler = handler;
    }

    RemoteAnimationRecord createRemoteAnimationRecord(AppWindowToken appWindowToken, Point position, Rect stackBounds, Rect startBounds) {
        RemoteAnimationRecord adapters = new RemoteAnimationRecord(appWindowToken, position, stackBounds, startBounds);
        this.mPendingAnimations.add(adapters);
        return adapters;
    }

    void goodToGo() {
        if (this.mPendingAnimations.isEmpty() || this.mCanceled) {
            this.onAnimationFinished();
            return;
        }
        this.mHandler.postDelayed(this.mTimeoutRunnable, (long)(2000.0f * this.mService.getCurrentAnimatorScale()));
        this.mFinishedCallback = new FinishedCallback(this);
        RemoteAnimationTarget[] animations = this.createAnimations();
        if (animations.length == 0) {
            this.onAnimationFinished();
            return;
        }
        this.mService.mAnimator.addAfterPrepareSurfacesRunnable(() -> {
            try {
                this.linkToDeathOfRunner();
                this.mRemoteAnimationAdapter.getRunner().onAnimationStart(animations, this.mFinishedCallback);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to start remote animation", e);
                this.onAnimationFinished();
            }
        });
        this.sendRunningRemoteAnimation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAnimation(String reason) {
        Object object = this.mService.getWindowManagerLock();
        synchronized (object) {
            if (this.mCanceled) {
                return;
            }
            this.mCanceled = true;
        }
        this.onAnimationFinished();
        this.invokeAnimationCancelled();
    }

    private void writeStartDebugStatement() {
        Slog.i(TAG, "Starting remote animation");
        StringWriter sw = new StringWriter();
        FastPrintWriter pw = new FastPrintWriter(sw);
        for (int i = this.mPendingAnimations.size() - 1; i >= 0; --i) {
            this.mPendingAnimations.get((int)i).mAdapter.dump(pw, "");
        }
        pw.close();
        Slog.i(TAG, sw.toString());
    }

    private RemoteAnimationTarget[] createAnimations() {
        ArrayList<RemoteAnimationTarget> targets = new ArrayList<RemoteAnimationTarget>();
        for (int i = this.mPendingAnimations.size() - 1; i >= 0; --i) {
            RemoteAnimationRecord wrappers = this.mPendingAnimations.get(i);
            RemoteAnimationTarget target = wrappers.createRemoteAnimationTarget();
            if (target != null) {
                targets.add(target);
                continue;
            }
            if (wrappers.mAdapter != null && wrappers.mAdapter.mCapturedFinishCallback != null) {
                wrappers.mAdapter.mCapturedFinishCallback.onAnimationFinished(wrappers.mAdapter);
            }
            if (wrappers.mThumbnailAdapter != null && wrappers.mThumbnailAdapter.mCapturedFinishCallback != null) {
                wrappers.mThumbnailAdapter.mCapturedFinishCallback.onAnimationFinished(wrappers.mThumbnailAdapter);
            }
            this.mPendingAnimations.remove(i);
        }
        return targets.toArray(new RemoteAnimationTarget[targets.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAnimationFinished() {
        this.mHandler.removeCallbacks(this.mTimeoutRunnable);
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.unlinkToDeathOfRunner();
                this.releaseFinishedCallback();
                this.mService.openSurfaceTransaction();
                try {
                    for (int i = this.mPendingAnimations.size() - 1; i >= 0; --i) {
                        RemoteAnimationRecord adapters = this.mPendingAnimations.get(i);
                        if (adapters.mAdapter != null) {
                            adapters.mAdapter.mCapturedFinishCallback.onAnimationFinished(adapters.mAdapter);
                        }
                        if (adapters.mThumbnailAdapter == null) continue;
                        adapters.mThumbnailAdapter.mCapturedFinishCallback.onAnimationFinished(adapters.mThumbnailAdapter);
                    }
                }
                catch (Exception e) {
                    Slog.e(TAG, "Failed to finish remote animation", e);
                    throw e;
                }
                finally {
                    this.mService.closeSurfaceTransaction("RemoteAnimationController#finished");
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[3, 6] lbl28 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        this.sendRunningRemoteAnimation(false);
    }

    private void invokeAnimationCancelled() {
        try {
            this.mRemoteAnimationAdapter.getRunner().onAnimationCancelled();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to notify cancel", e);
        }
    }

    private void releaseFinishedCallback() {
        if (this.mFinishedCallback != null) {
            this.mFinishedCallback.release();
            this.mFinishedCallback = null;
        }
    }

    private void sendRunningRemoteAnimation(boolean running) {
        int pid = this.mRemoteAnimationAdapter.getCallingPid();
        if (pid == 0) {
            throw new RuntimeException("Calling pid of remote animation was null");
        }
        this.mService.sendSetRunningRemoteAnimation(pid, running);
    }

    private void linkToDeathOfRunner() throws RemoteException {
        if (!this.mLinkedToDeathOfRunner) {
            this.mRemoteAnimationAdapter.getRunner().asBinder().linkToDeath(this, 0);
            this.mLinkedToDeathOfRunner = true;
        }
    }

    private void unlinkToDeathOfRunner() {
        if (this.mLinkedToDeathOfRunner) {
            this.mRemoteAnimationAdapter.getRunner().asBinder().unlinkToDeath(this, 0);
            this.mLinkedToDeathOfRunner = false;
        }
    }

    @Override
    public void binderDied() {
        this.cancelAnimation("binderDied");
    }

    private class RemoteAnimationAdapterWrapper
    implements AnimationAdapter {
        private final RemoteAnimationRecord mRecord;
        SurfaceControl mCapturedLeash;
        private SurfaceAnimator.OnAnimationFinishedCallback mCapturedFinishCallback;
        private final Point mPosition = new Point();
        private final Rect mStackBounds = new Rect();

        RemoteAnimationAdapterWrapper(RemoteAnimationRecord record, Point position, Rect stackBounds) {
            this.mRecord = record;
            this.mPosition.set(position.x, position.y);
            this.mStackBounds.set(stackBounds);
        }

        @Override
        public boolean getShowWallpaper() {
            return false;
        }

        @Override
        public int getBackgroundColor() {
            return 0;
        }

        @Override
        public void startAnimation(SurfaceControl animationLeash, SurfaceControl.Transaction t, SurfaceAnimator.OnAnimationFinishedCallback finishCallback) {
            t.setLayer(animationLeash, this.mRecord.mAppWindowToken.getPrefixOrderIndex());
            t.setPosition(animationLeash, this.mPosition.x, this.mPosition.y);
            RemoteAnimationController.this.mTmpRect.set(this.mStackBounds);
            RemoteAnimationController.this.mTmpRect.offsetTo(0, 0);
            t.setWindowCrop(animationLeash, RemoteAnimationController.this.mTmpRect);
            this.mCapturedLeash = animationLeash;
            this.mCapturedFinishCallback = finishCallback;
        }

        @Override
        public void onAnimationCancelled(SurfaceControl animationLeash) {
            if (this.mRecord.mAdapter == this) {
                this.mRecord.mAdapter = null;
            } else {
                this.mRecord.mThumbnailAdapter = null;
            }
            if (this.mRecord.mAdapter == null && this.mRecord.mThumbnailAdapter == null) {
                RemoteAnimationController.this.mPendingAnimations.remove(this.mRecord);
            }
            if (RemoteAnimationController.this.mPendingAnimations.isEmpty()) {
                RemoteAnimationController.this.mHandler.removeCallbacks(RemoteAnimationController.this.mTimeoutRunnable);
                RemoteAnimationController.this.releaseFinishedCallback();
                RemoteAnimationController.this.invokeAnimationCancelled();
                RemoteAnimationController.this.sendRunningRemoteAnimation(false);
            }
        }

        @Override
        public long getDurationHint() {
            return RemoteAnimationController.this.mRemoteAnimationAdapter.getDuration();
        }

        @Override
        public long getStatusBarTransitionsStartTime() {
            return SystemClock.uptimeMillis() + RemoteAnimationController.this.mRemoteAnimationAdapter.getStatusBarTransitionDelay();
        }

        @Override
        public void dump(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.print("token=");
            pw.println(this.mRecord.mAppWindowToken);
            if (this.mRecord.mTarget != null) {
                pw.print(prefix);
                pw.println("Target:");
                this.mRecord.mTarget.dump(pw, prefix + "  ");
            } else {
                pw.print(prefix);
                pw.println("Target: null");
            }
        }

        @Override
        public void writeToProto(ProtoOutputStream proto) {
            long token = proto.start(1146756268034L);
            if (this.mRecord.mTarget != null) {
                this.mRecord.mTarget.writeToProto(proto, 0x10B00000001L);
            }
            proto.end(token);
        }
    }

    public class RemoteAnimationRecord {
        RemoteAnimationAdapterWrapper mAdapter;
        RemoteAnimationAdapterWrapper mThumbnailAdapter = null;
        RemoteAnimationTarget mTarget;
        final AppWindowToken mAppWindowToken;
        final Rect mStartBounds;

        RemoteAnimationRecord(AppWindowToken appWindowToken, Point endPos, Rect endBounds, Rect startBounds) {
            this.mAppWindowToken = appWindowToken;
            this.mAdapter = new RemoteAnimationAdapterWrapper(this, endPos, endBounds);
            if (startBounds != null) {
                this.mStartBounds = new Rect(startBounds);
                RemoteAnimationController.this.mTmpRect.set(startBounds);
                RemoteAnimationController.this.mTmpRect.offsetTo(0, 0);
                if (RemoteAnimationController.this.mRemoteAnimationAdapter.getChangeNeedsSnapshot()) {
                    this.mThumbnailAdapter = new RemoteAnimationAdapterWrapper(this, new Point(0, 0), RemoteAnimationController.this.mTmpRect);
                }
            } else {
                this.mStartBounds = null;
            }
        }

        RemoteAnimationTarget createRemoteAnimationTarget() {
            Task task = this.mAppWindowToken.getTask();
            WindowState mainWindow = this.mAppWindowToken.findMainWindow();
            if (task == null || mainWindow == null || this.mAdapter == null || this.mAdapter.mCapturedFinishCallback == null || this.mAdapter.mCapturedLeash == null) {
                return null;
            }
            Rect insets = new Rect();
            mainWindow.getContentInsets(insets);
            InsetUtils.addInsets(insets, this.mAppWindowToken.getLetterboxInsets());
            this.mTarget = new RemoteAnimationTarget(task.mTaskId, this.getMode(), this.mAdapter.mCapturedLeash, !this.mAppWindowToken.fillsParent(), mainWindow.mWinAnimator.mLastClipRect, insets, this.mAppWindowToken.getPrefixOrderIndex(), this.mAdapter.mPosition, this.mAdapter.mStackBounds, task.getWindowConfiguration(), false, this.mThumbnailAdapter != null ? this.mThumbnailAdapter.mCapturedLeash : null, this.mStartBounds);
            return this.mTarget;
        }

        private int getMode() {
            DisplayContent dc = this.mAppWindowToken.getDisplayContent();
            if (dc.mOpeningApps.contains(this.mAppWindowToken)) {
                return 0;
            }
            if (dc.mChangingApps.contains(this.mAppWindowToken)) {
                return 2;
            }
            return 1;
        }
    }

    private static final class FinishedCallback
    extends IRemoteAnimationFinishedCallback.Stub {
        RemoteAnimationController mOuter;

        FinishedCallback(RemoteAnimationController outer) {
            this.mOuter = outer;
        }

        @Override
        public void onAnimationFinished() throws RemoteException {
            long token = Binder.clearCallingIdentity();
            try {
                if (this.mOuter != null) {
                    this.mOuter.onAnimationFinished();
                    this.mOuter = null;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        void release() {
            this.mOuter = null;
        }
    }
}

