/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AppGlobals;
import android.app.WindowConfiguration;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayManagerInternal;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.service.voice.IVoiceInteractionSession;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.IntArray;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.ResolverActivity;
import com.android.server.LocalServices;
import com.android.server.am.AppTimeTracker;
import com.android.server.am.UserState;
import com.android.server.wm.ActivityDisplay;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityStackSupervisor;
import com.android.server.wm.ActivityTaskManagerInternal;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.LaunchParamsController;
import com.android.server.wm.RootWindowContainer;
import com.android.server.wm.TaskRecord;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowProcessController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class RootActivityContainer
extends ConfigurationContainer
implements DisplayManager.DisplayListener {
    private static final String TAG = "ActivityTaskManager";
    static final String TAG_TASKS = "ActivityTaskManager";
    private static final String TAG_RELEASE = "ActivityTaskManager";
    static final String TAG_STATES = "ActivityTaskManager";
    private static final String TAG_RECENTS = "ActivityTaskManager";
    static final int MATCH_TASK_IN_STACKS_ONLY = 0;
    static final int MATCH_TASK_IN_STACKS_OR_RECENT_TASKS = 1;
    static final int MATCH_TASK_IN_STACKS_OR_RECENT_TASKS_AND_RESTORE = 2;
    ActivityTaskManagerService mService;
    ActivityStackSupervisor mStackSupervisor;
    WindowManagerService mWindowManager;
    DisplayManager mDisplayManager;
    private DisplayManagerInternal mDisplayManagerInternal;
    private RootWindowContainer mRootWindowContainer;
    private final ArrayList<ActivityDisplay> mActivityDisplays = new ArrayList();
    private ActivityDisplay mDefaultDisplay;
    private final SparseArray<IntArray> mDisplayAccessUIDs = new SparseArray();
    int mCurrentUser;
    SparseIntArray mUserStackInFront = new SparseIntArray(2);
    final ArrayList<ActivityTaskManagerInternal.SleepToken> mSleepTokens = new ArrayList();
    boolean mIsDockMinimized;
    private boolean mPowerHintSent;
    int mDefaultMinSizeOfResizeableTaskDp = -1;
    private boolean mTaskLayersChanged = true;
    private final ArrayList<ActivityRecord> mTmpActivityList = new ArrayList();
    private final FindTaskResult mTmpFindTaskResult = new FindTaskResult();

    RootActivityContainer(ActivityTaskManagerService service) {
        this.mService = service;
        this.mStackSupervisor = service.mStackSupervisor;
        this.mStackSupervisor.mRootActivityContainer = this;
    }

    @VisibleForTesting
    void setWindowContainer(RootWindowContainer container) {
        this.mRootWindowContainer = container;
        this.mRootWindowContainer.setRootActivityContainer(this);
    }

    void setWindowManager(WindowManagerService wm) {
        this.mWindowManager = wm;
        this.setWindowContainer(this.mWindowManager.mRoot);
        this.mDisplayManager = this.mService.mContext.getSystemService(DisplayManager.class);
        this.mDisplayManager.registerDisplayListener(this, this.mService.mUiHandler);
        this.mDisplayManagerInternal = LocalServices.getService(DisplayManagerInternal.class);
        Display[] displays = this.mDisplayManager.getDisplays();
        for (int displayNdx = 0; displayNdx < displays.length; ++displayNdx) {
            Display display = displays[displayNdx];
            ActivityDisplay activityDisplay = new ActivityDisplay(this, display);
            if (activityDisplay.mDisplayId == 0) {
                this.mDefaultDisplay = activityDisplay;
            }
            this.addChild(activityDisplay, Integer.MAX_VALUE);
        }
        this.calculateDefaultMinimalSizeOfResizeableTasks();
        ActivityDisplay defaultDisplay = this.getDefaultDisplay();
        defaultDisplay.getOrCreateStack(1, 2, true);
        this.positionChildAt(defaultDisplay, Integer.MAX_VALUE);
    }

    ActivityDisplay getDefaultDisplay() {
        return this.mDefaultDisplay;
    }

    ActivityDisplay getActivityDisplay(String uniqueId) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityDisplay display = this.mActivityDisplays.get(i);
            boolean isValid = display.mDisplay.isValid();
            if (!isValid || !display.mDisplay.getUniqueId().equals(uniqueId)) continue;
            return display;
        }
        return null;
    }

    ActivityDisplay getActivityDisplay(int displayId) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.get(i);
            if (activityDisplay.mDisplayId != displayId) continue;
            return activityDisplay;
        }
        return null;
    }

    ActivityDisplay getActivityDisplayOrCreate(int displayId) {
        ActivityDisplay activityDisplay = this.getActivityDisplay(displayId);
        if (activityDisplay != null) {
            return activityDisplay;
        }
        if (this.mDisplayManager == null) {
            return null;
        }
        Display display = this.mDisplayManager.getDisplay(displayId);
        if (display == null) {
            return null;
        }
        activityDisplay = new ActivityDisplay(this, display);
        this.addChild(activityDisplay, Integer.MIN_VALUE);
        return activityDisplay;
    }

    boolean isDisplayAdded(int displayId) {
        return this.getActivityDisplayOrCreate(displayId) != null;
    }

    ActivityRecord getDefaultDisplayHomeActivity() {
        return this.getDefaultDisplayHomeActivityForUser(this.mCurrentUser);
    }

    ActivityRecord getDefaultDisplayHomeActivityForUser(int userId) {
        return this.getActivityDisplay(0).getHomeActivityForUser(userId);
    }

    boolean startHomeOnAllDisplays(int userId, String reason) {
        boolean homeStarted = false;
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            int displayId = this.mActivityDisplays.get((int)i).mDisplayId;
            homeStarted |= this.startHomeOnDisplay(userId, reason, displayId);
        }
        return homeStarted;
    }

    void startHomeOnEmptyDisplays(String reason) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityDisplay display = this.mActivityDisplays.get(i);
            if (display.topRunningActivity() != null) continue;
            this.startHomeOnDisplay(this.mCurrentUser, reason, display.mDisplayId);
        }
    }

    boolean startHomeOnDisplay(int userId, String reason, int displayId) {
        return this.startHomeOnDisplay(userId, reason, displayId, false, false);
    }

    boolean startHomeOnDisplay(int userId, String reason, int displayId, boolean allowInstrumenting, boolean fromHomeKey) {
        if (displayId == -1) {
            displayId = this.getTopDisplayFocusedStack().mDisplayId;
        }
        Intent homeIntent = null;
        ActivityInfo aInfo = null;
        if (displayId == 0) {
            homeIntent = this.mService.getHomeIntent();
            aInfo = this.resolveHomeActivity(userId, homeIntent);
        } else if (this.shouldPlaceSecondaryHomeOnDisplay(displayId)) {
            Pair<ActivityInfo, Intent> info = this.resolveSecondaryHomeActivity(userId, displayId);
            aInfo = (ActivityInfo)info.first;
            homeIntent = (Intent)info.second;
        }
        if (aInfo == null || homeIntent == null) {
            return false;
        }
        if (!this.canStartHomeOnDisplay(aInfo, displayId, allowInstrumenting)) {
            return false;
        }
        homeIntent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
        homeIntent.setFlags(homeIntent.getFlags() | 0x10000000);
        if (fromHomeKey) {
            homeIntent.putExtra("android.intent.extra.FROM_HOME_KEY", true);
        }
        String myReason = reason + ":" + userId + ":" + UserHandle.getUserId(aInfo.applicationInfo.uid) + ":" + displayId;
        this.mService.getActivityStartController().startHomeActivity(homeIntent, aInfo, myReason, displayId);
        return true;
    }

    @VisibleForTesting
    ActivityInfo resolveHomeActivity(int userId, Intent homeIntent) {
        int flags = 1024;
        ComponentName comp = homeIntent.getComponent();
        ActivityInfo aInfo = null;
        try {
            if (comp != null) {
                aInfo = AppGlobals.getPackageManager().getActivityInfo(comp, 1024, userId);
            } else {
                String resolvedType = homeIntent.resolveTypeIfNeeded(this.mService.mContext.getContentResolver());
                ResolveInfo info = AppGlobals.getPackageManager().resolveIntent(homeIntent, resolvedType, 1024, userId);
                if (info != null) {
                    aInfo = info.activityInfo;
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (aInfo == null) {
            Slog.wtf("ActivityTaskManager", "No home screen found for " + homeIntent, new Throwable());
            return null;
        }
        aInfo = new ActivityInfo(aInfo);
        aInfo.applicationInfo = this.mService.getAppInfoForUser(aInfo.applicationInfo, userId);
        return aInfo;
    }

    @VisibleForTesting
    Pair<ActivityInfo, Intent> resolveSecondaryHomeActivity(int userId, int displayId) {
        if (displayId == 0) {
            throw new IllegalArgumentException("resolveSecondaryHomeActivity: Should not be DEFAULT_DISPLAY");
        }
        Intent homeIntent = this.mService.getHomeIntent();
        ActivityInfo aInfo = this.resolveHomeActivity(userId, homeIntent);
        if (aInfo != null) {
            if (ResolverActivity.class.getName().equals(aInfo.name)) {
                aInfo = null;
            } else {
                homeIntent = this.mService.getSecondaryHomeIntent(aInfo.applicationInfo.packageName);
                List<ResolveInfo> resolutions = this.resolveActivities(userId, homeIntent);
                int size = resolutions.size();
                String targetName = aInfo.name;
                aInfo = null;
                for (int i = 0; i < size; ++i) {
                    ResolveInfo resolveInfo = resolutions.get(i);
                    if (!resolveInfo.activityInfo.name.equals(targetName)) continue;
                    aInfo = resolveInfo.activityInfo;
                    break;
                }
                if (aInfo == null && size > 0) {
                    aInfo = resolutions.get((int)0).activityInfo;
                }
            }
        }
        if (aInfo != null && !this.canStartHomeOnDisplay(aInfo, displayId, false)) {
            aInfo = null;
        }
        if (aInfo == null) {
            homeIntent = this.mService.getSecondaryHomeIntent(null);
            aInfo = this.resolveHomeActivity(userId, homeIntent);
        }
        return Pair.create(aInfo, homeIntent);
    }

    @VisibleForTesting
    List<ResolveInfo> resolveActivities(int userId, Intent homeIntent) {
        List<ResolveInfo> resolutions;
        try {
            String resolvedType = homeIntent.resolveTypeIfNeeded(this.mService.mContext.getContentResolver());
            resolutions = AppGlobals.getPackageManager().queryIntentActivities(homeIntent, resolvedType, 1024, userId).getList();
        }
        catch (RemoteException e) {
            resolutions = new ArrayList<ResolveInfo>();
        }
        return resolutions;
    }

    boolean resumeHomeActivity(ActivityRecord prev, String reason, int displayId) {
        if (!this.mService.isBooting() && !this.mService.isBooted()) {
            return false;
        }
        if (displayId == -1) {
            displayId = 0;
        }
        ActivityRecord r = this.getActivityDisplay(displayId).getHomeActivity();
        String myReason = reason + " resumeHomeActivity";
        if (r != null && !r.finishing) {
            r.moveFocusableActivityToTop(myReason);
            return this.resumeFocusedStacksTopActivities((ActivityStack)r.getActivityStack(), prev, null);
        }
        return this.startHomeOnDisplay(this.mCurrentUser, myReason, displayId);
    }

    boolean shouldPlaceSecondaryHomeOnDisplay(int displayId) {
        boolean deviceProvisioned;
        if (displayId == 0) {
            throw new IllegalArgumentException("shouldPlaceSecondaryHomeOnDisplay: Should not be DEFAULT_DISPLAY");
        }
        if (displayId == -1) {
            return false;
        }
        if (!this.mService.mSupportsMultiDisplay) {
            return false;
        }
        boolean bl = deviceProvisioned = Settings.Global.getInt(this.mService.mContext.getContentResolver(), "device_provisioned", 0) != 0;
        if (!deviceProvisioned) {
            return false;
        }
        if (!StorageManager.isUserKeyUnlocked(this.mCurrentUser)) {
            return false;
        }
        ActivityDisplay display = this.getActivityDisplay(displayId);
        return display != null && !display.isRemoved() && display.supportsSystemDecorations();
    }

    boolean canStartHomeOnDisplay(ActivityInfo homeInfo, int displayId, boolean allowInstrumenting) {
        boolean supportMultipleInstance;
        if (this.mService.mFactoryTest == 1 && this.mService.mTopAction == null) {
            return false;
        }
        WindowProcessController app = this.mService.getProcessController(homeInfo.processName, homeInfo.applicationInfo.uid);
        if (!allowInstrumenting && app != null && app.isInstrumenting()) {
            return false;
        }
        if (displayId == 0 || displayId != -1 && displayId == this.mService.mVr2dDisplayId) {
            return true;
        }
        if (!this.shouldPlaceSecondaryHomeOnDisplay(displayId)) {
            return false;
        }
        boolean bl = supportMultipleInstance = homeInfo.launchMode != 2 && homeInfo.launchMode != 3;
        return supportMultipleInstance;
    }

    boolean ensureVisibilityAndConfig(ActivityRecord starting, int displayId, boolean markFrozenIfConfigChanged, boolean deferResume) {
        this.ensureActivitiesVisible(null, 0, false, false);
        if (displayId == -1) {
            return true;
        }
        DisplayContent displayContent = this.mRootWindowContainer.getDisplayContent(displayId);
        Configuration config = null;
        if (displayContent != null) {
            config = displayContent.updateOrientationFromAppTokens(this.getDisplayOverrideConfiguration(displayId), starting != null && starting.mayFreezeScreenLocked(starting.app) ? starting.appToken : null, true);
        }
        if (starting != null && markFrozenIfConfigChanged && config != null) {
            starting.frozenBeforeDestroy = true;
        }
        return this.mService.updateDisplayOverrideConfigurationLocked(config, starting, deferResume, displayId);
    }

    List<IBinder> getTopVisibleActivities() {
        ArrayList<IBinder> topActivityTokens = new ArrayList<IBinder>();
        ActivityStack topFocusedStack = this.getTopDisplayFocusedStack();
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityDisplay display = this.mActivityDisplays.get(i);
            for (int j = display.getChildCount() - 1; j >= 0; --j) {
                ActivityRecord top;
                ActivityStack stack = display.getChildAt(j);
                if (!stack.shouldBeVisible(null) || (top = stack.getTopActivity()) == null) continue;
                if (stack == topFocusedStack) {
                    topActivityTokens.add(0, top.appToken);
                    continue;
                }
                topActivityTokens.add(top.appToken);
            }
        }
        return topActivityTokens;
    }

    ActivityStack getTopDisplayFocusedStack() {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityStack focusedStack = this.mActivityDisplays.get(i).getFocusedStack();
            if (focusedStack == null) continue;
            return focusedStack;
        }
        return null;
    }

    ActivityRecord getTopResumedActivity() {
        ActivityStack focusedStack = this.getTopDisplayFocusedStack();
        if (focusedStack == null) {
            return null;
        }
        ActivityRecord resumedActivity = focusedStack.getResumedActivity();
        if (resumedActivity != null && resumedActivity.app != null) {
            return resumedActivity;
        }
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityDisplay display = this.mActivityDisplays.get(i);
            ActivityRecord resumedActivityOnDisplay = display.getResumedActivity();
            if (resumedActivityOnDisplay == null) continue;
            return resumedActivityOnDisplay;
        }
        return null;
    }

    boolean isFocusable(ConfigurationContainer container, boolean alwaysFocusable) {
        if (container.inSplitScreenPrimaryWindowingMode() && this.mIsDockMinimized) {
            return false;
        }
        return container.getWindowConfiguration().canReceiveKeys() || alwaysFocusable;
    }

    boolean isTopDisplayFocusedStack(ActivityStack stack) {
        return stack != null && stack == this.getTopDisplayFocusedStack();
    }

    void updatePreviousProcess(ActivityRecord r) {
        WindowProcessController fgApp = null;
        block0: for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (!this.isTopDisplayFocusedStack(stack)) continue;
                ActivityRecord resumedActivity = stack.getResumedActivity();
                if (resumedActivity != null) {
                    fgApp = resumedActivity.app;
                    continue block0;
                }
                if (stack.mPausingActivity == null) continue block0;
                fgApp = stack.mPausingActivity.app;
                continue block0;
            }
        }
        if (r.hasProcess() && fgApp != null && r.app != fgApp && r.lastVisibleTime > this.mService.mPreviousProcessVisibleTime && r.app != this.mService.mHomeProcess) {
            this.mService.mPreviousProcess = r.app;
            this.mService.mPreviousProcessVisibleTime = r.lastVisibleTime;
        }
    }

    boolean attachApplication(WindowProcessController app) throws RemoteException {
        String processName = app.mName;
        boolean didSomething = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            ActivityStack stack = display.getFocusedStack();
            if (stack == null) continue;
            stack.getAllRunningVisibleActivitiesLocked(this.mTmpActivityList);
            ActivityRecord top = stack.topRunningActivityLocked();
            int size = this.mTmpActivityList.size();
            for (int i = 0; i < size; ++i) {
                ActivityRecord activity = this.mTmpActivityList.get(i);
                if (activity.app != null || app.mUid != activity.info.applicationInfo.uid || !processName.equals(activity.processName)) continue;
                try {
                    if (!this.mStackSupervisor.realStartActivityLocked(activity, app, top == activity, true)) continue;
                    didSomething = true;
                    continue;
                }
                catch (RemoteException e) {
                    Slog.w("ActivityTaskManager", "Exception in new application when starting activity " + top.intent.getComponent().flattenToShortString(), e);
                    throw e;
                }
            }
        }
        if (!didSomething) {
            this.ensureActivitiesVisible(null, 0, false);
        }
        return didSomething;
    }

    void ensureActivitiesVisible(ActivityRecord starting, int configChanges, boolean preserveWindows) {
        this.ensureActivitiesVisible(starting, configChanges, preserveWindows, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureActivitiesVisible(ActivityRecord starting, int configChanges, boolean preserveWindows, boolean notifyClients) {
        this.mStackSupervisor.getKeyguardController().beginActivityVisibilityUpdate();
        try {
            for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
                ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
                display.ensureActivitiesVisible(starting, configChanges, preserveWindows, notifyClients);
            }
        }
        finally {
            this.mStackSupervisor.getKeyguardController().endActivityVisibilityUpdate();
        }
    }

    boolean switchUser(int userId, UserState uss) {
        int focusStackId = this.getTopDisplayFocusedStack().getStackId();
        ActivityStack dockedStack = this.getDefaultDisplay().getSplitScreenPrimaryStack();
        if (dockedStack != null) {
            this.mStackSupervisor.moveTasksToFullscreenStackLocked(dockedStack, dockedStack.isFocusedStackOnDisplay());
        }
        this.removeStacksInWindowingModes(2);
        this.mUserStackInFront.put(this.mCurrentUser, focusStackId);
        int restoreStackId = this.mUserStackInFront.get(userId, this.getDefaultDisplay().getHomeStack().mStackId);
        this.mCurrentUser = userId;
        this.mStackSupervisor.mStartingUsers.add(uss);
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.switchUserLocked(userId);
                TaskRecord task = stack.topTask();
                if (task == null) continue;
                stack.positionChildWindowContainerAtTop(task);
            }
        }
        Object stack = this.getStack(restoreStackId);
        if (stack == null) {
            stack = this.getDefaultDisplay().getHomeStack();
        }
        boolean homeInFront = ((ConfigurationContainer)stack).isActivityTypeHome();
        if (((ActivityStack)stack).isOnHomeDisplay()) {
            ((ActivityStack)stack).moveToFront("switchUserOnHomeDisplay");
        } else {
            this.resumeHomeActivity(null, "switchUserOnOtherDisplay", 0);
        }
        return homeInFront;
    }

    void removeUser(int userId) {
        this.mUserStackInFront.delete(userId);
    }

    void updateUserStack(int userId, ActivityStack stack) {
        if (userId != this.mCurrentUser) {
            this.mUserStackInFront.put(userId, stack != null ? stack.getStackId() : this.getDefaultDisplay().getHomeStack().mStackId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resizeStack(ActivityStack stack, Rect bounds, Rect tempTaskBounds, Rect tempTaskInsetBounds, boolean preserveWindows, boolean allowResizeInDockedMode, boolean deferResume) {
        if (stack.inSplitScreenPrimaryWindowingMode()) {
            this.mStackSupervisor.resizeDockedStackLocked(bounds, tempTaskBounds, tempTaskInsetBounds, null, null, preserveWindows, deferResume);
            return;
        }
        boolean splitScreenActive = this.getDefaultDisplay().hasSplitScreenPrimaryStack();
        if (!allowResizeInDockedMode && !stack.getWindowConfiguration().tasksAreFloating() && splitScreenActive) {
            return;
        }
        Trace.traceBegin(64L, "am.resizeStack_" + stack.mStackId);
        this.mWindowManager.deferSurfaceLayout();
        try {
            if (stack.affectedBySplitScreenResize()) {
                if (bounds == null && stack.inSplitScreenWindowingMode()) {
                    stack.setWindowingMode(1);
                } else if (splitScreenActive) {
                    stack.setWindowingMode(4);
                }
            }
            stack.resize(bounds, tempTaskBounds, tempTaskInsetBounds);
            if (!deferResume) {
                stack.ensureVisibleActivitiesConfigurationLocked(stack.topRunningActivityLocked(), preserveWindows);
            }
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
        }
    }

    void moveStackToDisplay(int stackId, int displayId, boolean onTop) {
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreate(displayId);
        if (activityDisplay == null) {
            throw new IllegalArgumentException("moveStackToDisplay: Unknown displayId=" + displayId);
        }
        Object stack = this.getStack(stackId);
        if (stack == null) {
            throw new IllegalArgumentException("moveStackToDisplay: Unknown stackId=" + stackId);
        }
        ActivityDisplay currentDisplay = ((ActivityStack)stack).getDisplay();
        if (currentDisplay == null) {
            throw new IllegalStateException("moveStackToDisplay: Stack with stack=" + stack + " is not attached to any display.");
        }
        if (currentDisplay.mDisplayId == displayId) {
            throw new IllegalArgumentException("Trying to move stack=" + stack + " to its current displayId=" + displayId);
        }
        if (activityDisplay.isSingleTaskInstance() && activityDisplay.getChildCount() > 0) {
            Slog.e("ActivityTaskManager", "Can not move stack=" + stack + " to single task instance display=" + activityDisplay);
            return;
        }
        ((ActivityStack)stack).reparent(activityDisplay, onTop, false);
    }

    boolean moveTopStackActivityToPinnedStack(int stackId) {
        Object stack = this.getStack(stackId);
        if (stack == null) {
            throw new IllegalArgumentException("moveTopStackActivityToPinnedStack: Unknown stackId=" + stackId);
        }
        ActivityRecord r = ((ActivityStack)stack).topRunningActivityLocked();
        if (r == null) {
            Slog.w("ActivityTaskManager", "moveTopStackActivityToPinnedStack: No top running activity in stack=" + stack);
            return false;
        }
        if (!this.mService.mForceResizableActivities && !r.supportsPictureInPicture()) {
            Slog.w("ActivityTaskManager", "moveTopStackActivityToPinnedStack: Picture-In-Picture not supported for  r=" + r);
            return false;
        }
        this.moveActivityToPinnedStack(r, null, 0.0f, "moveTopActivityToPinnedStack");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveActivityToPinnedStack(ActivityRecord r, Rect sourceHintBounds, float aspectRatio, String reason) {
        this.mWindowManager.deferSurfaceLayout();
        ActivityDisplay display = ((ActivityStack)r.getActivityStack()).getDisplay();
        ActivityStack stack = display.getPinnedStack();
        if (stack != null) {
            this.mStackSupervisor.moveTasksToFullscreenStackLocked(stack, false);
        }
        stack = display.getOrCreateStack(2, r.getActivityType(), true);
        Rect destBounds = stack.getDefaultPictureInPictureBounds(aspectRatio);
        try {
            TaskRecord task = r.getTaskRecord();
            this.resizeStack(stack, task.getRequestedOverrideBounds(), null, null, false, true, false);
            if (task.mActivities.size() == 1) {
                task.reparent(stack, true, 0, false, true, false, reason);
            } else {
                TaskRecord newTask = ((ActivityStack)task.getStack()).createTaskRecord(this.mStackSupervisor.getNextTaskIdForUserLocked(r.mUserId), r.info, r.intent, null, null, true);
                r.reparent(newTask, Integer.MAX_VALUE, "moveActivityToStack");
                newTask.reparent(stack, true, 0, false, true, false, reason);
            }
            r.supportsEnterPipOnTaskSwitch = false;
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
        }
        stack.animateResizePinnedStack(sourceHintBounds, destBounds, -1, true);
        this.ensureActivitiesVisible(null, 0, false);
        this.resumeFocusedStacksTopActivities();
        this.mService.getTaskChangeNotificationController().notifyActivityPinned(r);
    }

    void executeAppTransitionForAllDisplay() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            display.mDisplayContent.executeAppTransition();
        }
    }

    void setDockedStackMinimized(boolean minimized) {
        ActivityStack current = this.getTopDisplayFocusedStack();
        this.mIsDockMinimized = minimized;
        if (this.mIsDockMinimized && current.inSplitScreenPrimaryWindowingMode()) {
            current.adjustFocusToNextFocusableStack("setDockedStackMinimized");
        }
    }

    ActivityRecord findTask(ActivityRecord r, int preferredDisplayId) {
        this.mTmpFindTaskResult.clear();
        ActivityDisplay preferredDisplay = this.getActivityDisplay(preferredDisplayId);
        if (preferredDisplay != null) {
            preferredDisplay.findTaskLocked(r, true, this.mTmpFindTaskResult);
            if (this.mTmpFindTaskResult.mIdealMatch) {
                return this.mTmpFindTaskResult.mRecord;
            }
        }
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            if (display.mDisplayId == preferredDisplayId) continue;
            display.findTaskLocked(r, false, this.mTmpFindTaskResult);
            if (!this.mTmpFindTaskResult.mIdealMatch) continue;
            return this.mTmpFindTaskResult.mRecord;
        }
        return this.mTmpFindTaskResult.mRecord;
    }

    int finishTopCrashedActivities(WindowProcessController app, String reason) {
        TaskRecord finishedTask = null;
        ActivityStack focusedStack = this.getTopDisplayFocusedStack();
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = 0; stackNdx < display.getChildCount(); ++stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                TaskRecord t = stack.finishTopCrashedActivityLocked(app, reason);
                if (stack != focusedStack && finishedTask != null) continue;
                finishedTask = t;
            }
        }
        return finishedTask != null ? finishedTask.taskId : -1;
    }

    boolean resumeFocusedStacksTopActivities() {
        return this.resumeFocusedStacksTopActivities(null, null, null);
    }

    boolean resumeFocusedStacksTopActivities(ActivityStack targetStack, ActivityRecord target, ActivityOptions targetOptions) {
        if (!this.mStackSupervisor.readyToResume()) {
            return false;
        }
        boolean result = false;
        if (targetStack != null && (targetStack.isTopStackOnDisplay() || this.getTopDisplayFocusedStack() == targetStack)) {
            result = targetStack.resumeTopActivityUncheckedLocked(target, targetOptions);
        }
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityStack focusedStack;
            boolean resumedOnDisplay = false;
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                ActivityRecord topRunningActivity = stack.topRunningActivityLocked();
                if (!stack.isFocusableAndVisible() || topRunningActivity == null) continue;
                if (stack == targetStack) {
                    resumedOnDisplay |= result;
                    continue;
                }
                if (display.isTopStack(stack) && topRunningActivity.isState(ActivityStack.ActivityState.RESUMED)) {
                    stack.executeAppTransition(targetOptions);
                    continue;
                }
                resumedOnDisplay |= topRunningActivity.makeActiveIfNeeded(target);
            }
            if (resumedOnDisplay || (focusedStack = display.getFocusedStack()) == null) continue;
            focusedStack.resumeTopActivityUncheckedLocked(target, targetOptions);
        }
        return result;
    }

    void applySleepTokens(boolean applyToStacks) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            boolean displayShouldSleep = display.shouldSleep();
            if (displayShouldSleep == display.isSleeping()) continue;
            display.setIsSleeping(displayShouldSleep);
            if (!applyToStacks) continue;
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (displayShouldSleep) {
                    stack.goToSleepIfPossible(false);
                    continue;
                }
                stack.awakeFromSleepingLocked();
                if (!stack.isFocusedStackOnDisplay() || this.mStackSupervisor.getKeyguardController().isKeyguardOrAodShowing(display.mDisplayId)) continue;
                this.resumeFocusedStacksTopActivities();
            }
            if (displayShouldSleep || this.mStackSupervisor.mGoingToSleepActivities.isEmpty()) continue;
            Iterator<ActivityRecord> it = this.mStackSupervisor.mGoingToSleepActivities.iterator();
            while (it.hasNext()) {
                ActivityRecord r = it.next();
                if (r.getDisplayId() != display.mDisplayId) continue;
                it.remove();
            }
        }
    }

    protected <T extends ActivityStack> T getStack(int stackId) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            Object stack = this.mActivityDisplays.get(i).getStack(stackId);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    private <T extends ActivityStack> T getStack(int windowingMode, int activityType) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            Object stack = this.mActivityDisplays.get(i).getStack(windowingMode, activityType);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    private ActivityManager.StackInfo getStackInfo(ActivityStack stack) {
        int displayId = stack.mDisplayId;
        ActivityDisplay display = this.getActivityDisplay(displayId);
        ActivityManager.StackInfo info = new ActivityManager.StackInfo();
        stack.getWindowContainerBounds(info.bounds);
        info.displayId = displayId;
        info.stackId = stack.mStackId;
        info.userId = stack.mCurrentUser;
        info.visible = stack.shouldBeVisible(null);
        info.position = display != null ? display.getIndexOf(stack) : 0;
        info.configuration.setTo(stack.getConfiguration());
        ArrayList<TaskRecord> tasks = stack.getAllTasks();
        int numTasks = tasks.size();
        int[] taskIds = new int[numTasks];
        String[] taskNames = new String[numTasks];
        Rect[] taskBounds = new Rect[numTasks];
        int[] taskUserIds = new int[numTasks];
        for (int i = 0; i < numTasks; ++i) {
            TaskRecord task = tasks.get(i);
            taskIds[i] = task.taskId;
            taskNames[i] = task.origActivity != null ? task.origActivity.flattenToString() : (task.realActivity != null ? task.realActivity.flattenToString() : (task.getTopActivity() != null ? task.getTopActivity().packageName : "unknown"));
            taskBounds[i] = new Rect();
            task.getWindowContainerBounds(taskBounds[i]);
            taskUserIds[i] = task.userId;
        }
        info.taskIds = taskIds;
        info.taskNames = taskNames;
        info.taskBounds = taskBounds;
        info.taskUserIds = taskUserIds;
        ActivityRecord top = stack.topRunningActivityLocked();
        info.topActivity = top != null ? top.intent.getComponent() : null;
        return info;
    }

    ActivityManager.StackInfo getStackInfo(int stackId) {
        Object stack = this.getStack(stackId);
        if (stack != null) {
            return this.getStackInfo((ActivityStack)stack);
        }
        return null;
    }

    ActivityManager.StackInfo getStackInfo(int windowingMode, int activityType) {
        Object stack = this.getStack(windowingMode, activityType);
        return stack != null ? this.getStackInfo((ActivityStack)stack) : null;
    }

    ArrayList<ActivityManager.StackInfo> getAllStackInfos() {
        ArrayList<ActivityManager.StackInfo> list = new ArrayList<ActivityManager.StackInfo>();
        for (int displayNdx = 0; displayNdx < this.mActivityDisplays.size(); ++displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                list.add(this.getStackInfo(stack));
            }
        }
        return list;
    }

    void deferUpdateBounds(int activityType) {
        Object stack = this.getStack(0, activityType);
        if (stack != null) {
            ((ActivityStack)stack).deferUpdateBounds();
        }
    }

    void continueUpdateBounds(int activityType) {
        Object stack = this.getStack(0, activityType);
        if (stack != null) {
            ((ActivityStack)stack).continueUpdateBounds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onDisplayAdded(int displayId) {
        ActivityDisplay display;
        block5: {
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            // MONITORENTER : windowManagerGlobalLock
            try {
                WindowManagerService.boostPriorityForLockedSection();
                display = this.getActivityDisplayOrCreate(displayId);
                if (display != null) break block5;
                // MONITOREXIT : windowManagerGlobalLock
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        if (this.mService.isBooted() || this.mService.isBooting()) {
            this.startSystemDecorations(display.mDisplayContent);
        }
        // MONITOREXIT : windowManagerGlobalLock
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    private void startSystemDecorations(DisplayContent displayContent) {
        this.startHomeOnDisplay(this.mCurrentUser, "displayAdded", displayContent.getDisplayId());
        displayContent.getDisplayPolicy().notifyDisplayReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onDisplayRemoved(int displayId) {
        ActivityDisplay activityDisplay;
        block5: {
            if (displayId == 0) {
                throw new IllegalArgumentException("Can't remove the primary display.");
            }
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            // MONITORENTER : windowManagerGlobalLock
            try {
                WindowManagerService.boostPriorityForLockedSection();
                activityDisplay = this.getActivityDisplay(displayId);
                if (activityDisplay != null) break block5;
                // MONITOREXIT : windowManagerGlobalLock
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        activityDisplay.remove();
        // MONITOREXIT : windowManagerGlobalLock
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisplayChanged(int displayId) {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                ActivityDisplay activityDisplay = this.getActivityDisplay(displayId);
                if (activityDisplay != null) {
                    activityDisplay.onDisplayChanged();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void updateUIDsPresentOnDisplay() {
        this.mDisplayAccessUIDs.clear();
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.get(displayNdx);
            if (!activityDisplay.isPrivate()) continue;
            this.mDisplayAccessUIDs.append(activityDisplay.mDisplayId, activityDisplay.getPresentUIDs());
        }
        this.mDisplayManagerInternal.setDisplayAccessUIDs(this.mDisplayAccessUIDs);
    }

    ActivityStack findStackBehind(ActivityStack stack) {
        ActivityDisplay display = this.getActivityDisplay(stack.mDisplayId);
        if (display != null) {
            for (int i = display.getChildCount() - 1; i >= 0; --i) {
                if (display.getChildAt(i) != stack || i <= 0) continue;
                return display.getChildAt(i - 1);
            }
        }
        throw new IllegalStateException("Failed to find a stack behind stack=" + stack + " in=" + display);
    }

    @Override
    protected int getChildCount() {
        return this.mActivityDisplays.size();
    }

    protected ActivityDisplay getChildAt(int index) {
        return this.mActivityDisplays.get(index);
    }

    @Override
    protected ConfigurationContainer getParent() {
        return null;
    }

    void onChildPositionChanged(ActivityDisplay display, int position) {
        if (display != null) {
            this.positionChildAt(display, position);
        }
    }

    private void positionChildAt(ActivityDisplay display, int position) {
        if (position >= this.mActivityDisplays.size()) {
            position = this.mActivityDisplays.size() - 1;
        } else if (position < 0) {
            position = 0;
        }
        if (this.mActivityDisplays.isEmpty()) {
            this.mActivityDisplays.add(display);
        } else if (this.mActivityDisplays.get(position) != display) {
            this.mActivityDisplays.remove(display);
            this.mActivityDisplays.add(position, display);
        }
        this.mStackSupervisor.updateTopResumedActivityIfNeeded();
    }

    @VisibleForTesting
    void addChild(ActivityDisplay activityDisplay, int position) {
        this.positionChildAt(activityDisplay, position);
        this.mRootWindowContainer.positionChildAt(position, activityDisplay.mDisplayContent);
    }

    void removeChild(ActivityDisplay activityDisplay) {
        this.mActivityDisplays.remove(activityDisplay);
    }

    Configuration getDisplayOverrideConfiguration(int displayId) {
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreate(displayId);
        if (activityDisplay == null) {
            throw new IllegalArgumentException("No display found with id: " + displayId);
        }
        return activityDisplay.getRequestedOverrideConfiguration();
    }

    void setDisplayOverrideConfiguration(Configuration overrideConfiguration, int displayId) {
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreate(displayId);
        if (activityDisplay == null) {
            throw new IllegalArgumentException("No display found with id: " + displayId);
        }
        activityDisplay.onRequestedOverrideConfigurationChanged(overrideConfiguration);
    }

    void prepareForShutdown() {
        for (int i = 0; i < this.mActivityDisplays.size(); ++i) {
            this.createSleepToken("shutdown", this.mActivityDisplays.get((int)i).mDisplayId);
        }
    }

    ActivityTaskManagerInternal.SleepToken createSleepToken(String tag, int displayId) {
        ActivityDisplay display = this.getActivityDisplay(displayId);
        if (display == null) {
            throw new IllegalArgumentException("Invalid display: " + displayId);
        }
        SleepTokenImpl token = new SleepTokenImpl(tag, displayId);
        this.mSleepTokens.add(token);
        display.mAllSleepTokens.add(token);
        return token;
    }

    private void removeSleepToken(SleepTokenImpl token) {
        this.mSleepTokens.remove(token);
        ActivityDisplay display = this.getActivityDisplay(token.mDisplayId);
        if (display != null) {
            display.mAllSleepTokens.remove(token);
            if (display.mAllSleepTokens.isEmpty()) {
                this.mService.updateSleepIfNeededLocked();
            }
        }
    }

    void addStartingWindowsForVisibleActivities(boolean taskSwitch) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.addStartingWindowsForVisibleActivities(taskSwitch);
            }
        }
    }

    void invalidateTaskLayers() {
        this.mTaskLayersChanged = true;
    }

    void rankTaskLayersIfNeeded() {
        if (!this.mTaskLayersChanged) {
            return;
        }
        this.mTaskLayersChanged = false;
        for (int displayNdx = 0; displayNdx < this.mActivityDisplays.size(); ++displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            int baseLayer = 0;
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                baseLayer += stack.rankTaskLayers(baseLayer);
            }
        }
    }

    void clearOtherAppTimeTrackers(AppTimeTracker except) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.clearOtherAppTimeTrackers(except);
            }
        }
    }

    void scheduleDestroyAllActivities(WindowProcessController app, String reason) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.scheduleDestroyActivities(app, reason);
            }
        }
    }

    void releaseSomeActivitiesLocked(WindowProcessController app, String reason) {
        ArraySet<TaskRecord> tasks = app.getReleaseSomeActivitiesTasks();
        if (tasks == null) {
            return;
        }
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            int stackCount = display.getChildCount();
            for (int stackNdx = 0; stackNdx < stackCount; ++stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (stack.releaseSomeActivitiesLocked(app, tasks, reason) <= 0) continue;
                return;
            }
        }
    }

    boolean putStacksToSleep(boolean allowDelay, boolean shuttingDown) {
        boolean allSleep = true;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                if (stackNdx >= display.getChildCount()) continue;
                ActivityStack stack = display.getChildAt(stackNdx);
                if (allowDelay) {
                    allSleep &= stack.goToSleepIfPossible(shuttingDown);
                    continue;
                }
                stack.goToSleep();
            }
        }
        return allSleep;
    }

    void handleAppCrash(WindowProcessController app) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.handleAppCrash(app);
            }
        }
    }

    ActivityRecord findActivity(Intent intent, ActivityInfo info, boolean compareIntentFilters) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                ActivityRecord ar = stack.findActivityLocked(intent, info, compareIntentFilters);
                if (ar == null) continue;
                return ar;
            }
        }
        return null;
    }

    boolean hasAwakeDisplay() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            if (display.shouldSleep()) continue;
            return true;
        }
        return false;
    }

    <T extends ActivityStack> T getLaunchStack(ActivityRecord r, ActivityOptions options, TaskRecord candidateTask, boolean onTop) {
        return this.getLaunchStack(r, options, candidateTask, onTop, null);
    }

    <T extends ActivityStack> T getLaunchStack(ActivityRecord r, ActivityOptions options, TaskRecord candidateTask, boolean onTop, LaunchParamsController.LaunchParams launchParams) {
        ActivityDisplay display;
        ActivityStack stack;
        int taskId = -1;
        int displayId = -1;
        if (options != null) {
            taskId = options.getLaunchTaskId();
            displayId = options.getLaunchDisplayId();
        }
        if (taskId != -1) {
            options.setLaunchTaskId(-1);
            TaskRecord task = this.anyTaskForId(taskId, 2, options, onTop);
            options.setLaunchTaskId(taskId);
            if (task != null) {
                return task.getStack();
            }
        }
        int activityType = this.resolveActivityType(r, options, candidateTask);
        if (launchParams != null && launchParams.mPreferredDisplayId != -1) {
            displayId = launchParams.mPreferredDisplayId;
        }
        if (displayId != -1 && this.canLaunchOnDisplay(r, displayId)) {
            if (r != null && (stack = this.getValidLaunchStackOnDisplay(displayId, r, candidateTask, options, launchParams)) != null) {
                return (T)stack;
            }
            display = this.getActivityDisplayOrCreate(displayId);
            if (display != null && (stack = display.getOrCreateStack(r, options, candidateTask, activityType, onTop)) != null) {
                return (T)stack;
            }
        }
        stack = null;
        display = null;
        if (candidateTask != null) {
            stack = (ActivityStack)candidateTask.getStack();
        }
        if (stack == null && r != null) {
            stack = r.getActivityStack();
        }
        if (stack != null && (display = stack.getDisplay()) != null && this.canLaunchOnDisplay(r, display.mDisplayId)) {
            int windowingMode;
            int n = windowingMode = launchParams != null ? launchParams.mWindowingMode : 0;
            if (windowingMode == 0) {
                windowingMode = display.resolveWindowingMode(r, options, candidateTask, activityType);
            }
            if (stack.isCompatible(windowingMode, activityType)) {
                return (T)stack;
            }
            if (windowingMode == 4 && display.getSplitScreenPrimaryStack() == stack && candidateTask == stack.topTask()) {
                return (T)stack;
            }
        }
        if (display == null || !this.canLaunchOnDisplay(r, display.mDisplayId)) {
            display = this.getDefaultDisplay();
        }
        return display.getOrCreateStack(r, options, candidateTask, activityType, onTop);
    }

    private boolean canLaunchOnDisplay(ActivityRecord r, int displayId) {
        if (r == null) {
            return true;
        }
        return r.canBeLaunchedOnDisplay(displayId);
    }

    private ActivityStack getValidLaunchStackOnDisplay(int displayId, ActivityRecord r, TaskRecord candidateTask, ActivityOptions options, LaunchParamsController.LaunchParams launchParams) {
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreate(displayId);
        if (activityDisplay == null) {
            throw new IllegalArgumentException("Display with displayId=" + displayId + " not found.");
        }
        if (!r.canBeLaunchedOnDisplay(displayId)) {
            return null;
        }
        if (r.getDisplayId() == displayId && r.getTaskRecord() == candidateTask) {
            return candidateTask.getStack();
        }
        int windowingMode = launchParams != null ? launchParams.mWindowingMode : (options != null ? options.getLaunchWindowingMode() : r.getWindowingMode());
        windowingMode = activityDisplay.validateWindowingMode(windowingMode, r, candidateTask, r.getActivityType());
        for (int i = activityDisplay.getChildCount() - 1; i >= 0; --i) {
            ActivityStack stack = activityDisplay.getChildAt(i);
            if (!this.isValidLaunchStack(stack, r, windowingMode)) continue;
            return stack;
        }
        if (displayId != 0) {
            int activityType = options != null && options.getLaunchActivityType() != 0 ? options.getLaunchActivityType() : r.getActivityType();
            return activityDisplay.createStack(windowingMode, activityType, true);
        }
        return null;
    }

    ActivityStack getValidLaunchStackOnDisplay(int displayId, ActivityRecord r, ActivityOptions options, LaunchParamsController.LaunchParams launchParams) {
        return this.getValidLaunchStackOnDisplay(displayId, r, null, options, launchParams);
    }

    private boolean isValidLaunchStack(ActivityStack stack, ActivityRecord r, int windowingMode) {
        switch (stack.getActivityType()) {
            case 2: {
                return r.isActivityTypeHome();
            }
            case 3: {
                return r.isActivityTypeRecents();
            }
            case 4: {
                return r.isActivityTypeAssistant();
            }
        }
        return stack.getWindowingMode() == 3 && r.supportsSplitScreenWindowingMode() && (windowingMode == 3 || windowingMode == 0);
    }

    int resolveActivityType(ActivityRecord r, ActivityOptions options, TaskRecord task) {
        int activityType;
        int n = activityType = r != null ? r.getActivityType() : 0;
        if (activityType == 0 && task != null) {
            activityType = task.getActivityType();
        }
        if (activityType != 0) {
            return activityType;
        }
        if (options != null) {
            activityType = options.getLaunchActivityType();
        }
        return activityType != 0 ? activityType : 1;
    }

    ActivityStack getNextFocusableStack(ActivityStack currentFocus, boolean ignoreCurrent) {
        ActivityDisplay preferredDisplay = currentFocus.getDisplay();
        ActivityStack preferredFocusableStack = preferredDisplay.getNextFocusableStack(currentFocus, ignoreCurrent);
        if (preferredFocusableStack != null) {
            return preferredFocusableStack;
        }
        if (preferredDisplay.supportsSystemDecorations()) {
            return null;
        }
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityStack nextFocusableStack;
            ActivityDisplay display = this.mActivityDisplays.get(i);
            if (display == preferredDisplay || (nextFocusableStack = display.getNextFocusableStack(currentFocus, ignoreCurrent)) == null) continue;
            return nextFocusableStack;
        }
        return null;
    }

    ActivityStack getNextValidLaunchStack(ActivityRecord r, int currentFocus) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityStack stack;
            ActivityDisplay display = this.mActivityDisplays.get(i);
            if (display.mDisplayId == currentFocus || (stack = this.getValidLaunchStackOnDisplay(display.mDisplayId, r, null, null)) == null) continue;
            return stack;
        }
        return null;
    }

    boolean handleAppDied(WindowProcessController app) {
        boolean hasVisibleActivities = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                hasVisibleActivities |= stack.handleAppDiedLocked(app);
            }
        }
        return hasVisibleActivities;
    }

    void closeSystemDialogs() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.closeSystemDialogsLocked();
            }
        }
    }

    boolean finishDisabledPackageActivities(String packageName, Set<String> filterByClasses, boolean doit, boolean evenPersistent, int userId) {
        boolean didSomething = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (!stack.finishDisabledPackageActivitiesLocked(packageName, filterByClasses, doit, evenPersistent, userId)) continue;
                didSomething = true;
            }
        }
        return didSomething;
    }

    void updateActivityApplicationInfo(ApplicationInfo aInfo) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.updateActivityApplicationInfoLocked(aInfo);
            }
        }
    }

    void finishVoiceTask(IVoiceInteractionSession session) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            int numStacks = display.getChildCount();
            for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.finishVoiceTask(session);
            }
        }
    }

    void removeStacksInWindowingModes(int ... windowingModes) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            this.mActivityDisplays.get(i).removeStacksInWindowingModes(windowingModes);
        }
    }

    void removeStacksWithActivityTypes(int ... activityTypes) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            this.mActivityDisplays.get(i).removeStacksWithActivityTypes(activityTypes);
        }
    }

    ActivityRecord topRunningActivity() {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityRecord topActivity = this.mActivityDisplays.get(i).topRunningActivity();
            if (topActivity == null) continue;
            return topActivity;
        }
        return null;
    }

    boolean allResumedActivitiesIdle() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityRecord resumedActivity;
            ActivityStack stack;
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            if (display.isSleeping() || (stack = display.getFocusedStack()) == null || stack.numActivities() == 0 || (resumedActivity = stack.getResumedActivity()) != null && resumedActivity.idle) continue;
            return false;
        }
        this.sendPowerHintForLaunchEndIfNeeded();
        return true;
    }

    boolean allResumedActivitiesVisible() {
        boolean foundResumed = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                ActivityRecord r = stack.getResumedActivity();
                if (r == null) continue;
                if (!r.nowVisible) {
                    return false;
                }
                foundResumed = true;
            }
        }
        return foundResumed;
    }

    boolean allPausedActivitiesComplete() {
        boolean pausing = true;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                ActivityRecord r = stack.mPausingActivity;
                if (r == null || r.isState(ActivityStack.ActivityState.PAUSED, ActivityStack.ActivityState.STOPPED, ActivityStack.ActivityState.STOPPING)) continue;
                return false;
            }
        }
        return pausing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockAllProfileTasks(int userId) {
        this.mWindowManager.deferSurfaceLayout();
        try {
            for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
                ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
                for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                    ActivityStack stack = display.getChildAt(stackNdx);
                    ArrayList<TaskRecord> tasks = stack.getAllTasks();
                    for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                        TaskRecord task = (TaskRecord)tasks.get(taskNdx);
                        if (!this.taskTopActivityIsUser(task, userId)) continue;
                        this.mService.getTaskChangeNotificationController().notifyTaskProfileLocked(task.taskId, userId);
                    }
                }
            }
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
        }
    }

    private boolean taskTopActivityIsUser(TaskRecord task, int userId) {
        ActivityRecord activityRecord = task.getTopActivity();
        ActivityRecord resultTo = activityRecord != null ? activityRecord.resultTo : null;
        return activityRecord != null && activityRecord.mUserId == userId || resultTo != null && resultTo.mUserId == userId;
    }

    void cancelInitializingActivities() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.cancelInitializingActivities();
            }
        }
    }

    TaskRecord anyTaskForId(int id2) {
        return this.anyTaskForId(id2, 2);
    }

    TaskRecord anyTaskForId(int id2, int matchMode) {
        return this.anyTaskForId(id2, matchMode, null, false);
    }

    TaskRecord anyTaskForId(int id2, int matchMode, ActivityOptions aOptions, boolean onTop) {
        if (matchMode != 2 && aOptions != null) {
            throw new IllegalArgumentException("Should not specify activity options for non-restore lookup");
        }
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                Object launchStack;
                ActivityStack stack = display.getChildAt(stackNdx);
                TaskRecord task = stack.taskForIdLocked(id2);
                if (task == null) continue;
                if (aOptions != null && (launchStack = this.getLaunchStack(null, aOptions, task, onTop)) != null && stack != launchStack) {
                    int reparentMode = onTop ? 0 : 2;
                    task.reparent((ActivityStack)launchStack, onTop, reparentMode, true, true, "anyTaskForId");
                }
                return task;
            }
        }
        if (matchMode == 0) {
            return null;
        }
        TaskRecord task = this.mStackSupervisor.mRecentTasks.getTask(id2);
        if (task == null) {
            return null;
        }
        if (matchMode == 1) {
            return task;
        }
        if (!this.mStackSupervisor.restoreRecentTaskLocked(task, aOptions, onTop)) {
            return null;
        }
        return task;
    }

    ActivityRecord isInAnyStack(IBinder token) {
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                ActivityRecord r = stack.isInStackLocked(token);
                if (r == null) continue;
                return r;
            }
        }
        return null;
    }

    @VisibleForTesting
    void getRunningTasks(int maxNum, List<ActivityManager.RunningTaskInfo> list, @WindowConfiguration.ActivityType int ignoreActivityType, @WindowConfiguration.WindowingMode int ignoreWindowingMode, int callingUid, boolean allowed) {
        this.mStackSupervisor.mRunningTasks.getTasks(maxNum, list, ignoreActivityType, ignoreWindowingMode, this.mActivityDisplays, callingUid, allowed);
    }

    void sendPowerHintForLaunchStartIfNeeded(boolean forceSend, ActivityRecord targetActivity) {
        boolean sendHint = forceSend;
        if (!sendHint) {
            boolean bl = sendHint = targetActivity == null || targetActivity.app == null;
        }
        if (!sendHint) {
            boolean noResumedActivities = true;
            boolean allFocusedProcessesDiffer = true;
            for (int displayNdx = 0; displayNdx < this.mActivityDisplays.size(); ++displayNdx) {
                ActivityDisplay activityDisplay = this.mActivityDisplays.get(displayNdx);
                ActivityRecord resumedActivity = activityDisplay.getResumedActivity();
                WindowProcessController resumedActivityProcess = resumedActivity == null ? null : resumedActivity.app;
                noResumedActivities &= resumedActivityProcess == null;
                if (resumedActivityProcess == null) continue;
                allFocusedProcessesDiffer &= !resumedActivityProcess.equals(targetActivity.app);
            }
            boolean bl = sendHint = noResumedActivities || allFocusedProcessesDiffer;
        }
        if (sendHint && this.mService.mPowerManagerInternal != null) {
            this.mService.mPowerManagerInternal.powerHint(8, 1);
            this.mPowerHintSent = true;
        }
    }

    void sendPowerHintForLaunchEndIfNeeded() {
        if (this.mPowerHintSent && this.mService.mPowerManagerInternal != null) {
            this.mService.mPowerManagerInternal.powerHint(8, 0);
            this.mPowerHintSent = false;
        }
    }

    private void calculateDefaultMinimalSizeOfResizeableTasks() {
        Resources res = this.mService.mContext.getResources();
        float minimalSize = res.getDimension(17105123);
        DisplayMetrics dm = res.getDisplayMetrics();
        this.mDefaultMinSizeOfResizeableTaskDp = (int)(minimalSize / dm.density);
    }

    ArrayList<ActivityRecord> getDumpActivities(String name, boolean dumpVisibleStacksOnly, boolean dumpFocusedStackOnly) {
        if (dumpFocusedStackOnly) {
            return this.getTopDisplayFocusedStack().getDumpActivitiesLocked(name);
        }
        ArrayList<ActivityRecord> activities = new ArrayList<ActivityRecord>();
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (dumpVisibleStacksOnly && !stack.shouldBeVisible(null)) continue;
                activities.addAll(stack.getDumpActivitiesLocked(name));
            }
        }
        return activities;
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println("topDisplayFocusedStack=" + this.getTopDisplayFocusedStack());
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityDisplay display = this.mActivityDisplays.get(i);
            display.dump(pw, prefix);
        }
    }

    void dumpDisplayConfigs(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println("Display override configurations:");
        int displayCount = this.mActivityDisplays.size();
        for (int i = 0; i < displayCount; ++i) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.get(i);
            pw.print(prefix);
            pw.print("  ");
            pw.print(activityDisplay.mDisplayId);
            pw.print(": ");
            pw.println(activityDisplay.getRequestedOverrideConfiguration());
        }
    }

    public void dumpDisplays(PrintWriter pw) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityDisplay display = this.mActivityDisplays.get(i);
            pw.print("[id:" + display.mDisplayId + " stacks:");
            display.dumpStacks(pw);
            pw.print("]");
        }
    }

    boolean dumpActivities(FileDescriptor fd, PrintWriter pw, boolean dumpAll, boolean dumpClient, String dumpPackage) {
        boolean printed = false;
        boolean needSep = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.get(displayNdx);
            pw.print("Display #");
            pw.print(activityDisplay.mDisplayId);
            pw.println(" (activities from top to bottom):");
            ActivityDisplay display = this.mActivityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                pw.println();
                needSep = printed = stack.dump(fd, pw, dumpAll, dumpClient, dumpPackage, needSep);
            }
            ActivityStackSupervisor.printThisActivity(pw, activityDisplay.getResumedActivity(), dumpPackage, needSep, " ResumedActivity:");
        }
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mStackSupervisor.mFinishingActivities, "  ", "Fin", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to finish:", null);
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mStackSupervisor.mStoppingActivities, "  ", "Stop", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to stop:", null);
        return printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mStackSupervisor.mGoingToSleepActivities, "  ", "Sleep", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to sleep:", null);
    }

    @Override
    protected void writeToProto(ProtoOutputStream proto, long fieldId, int logLevel) {
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, logLevel);
        for (int displayNdx = 0; displayNdx < this.mActivityDisplays.size(); ++displayNdx) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.get(displayNdx);
            activityDisplay.writeToProto(proto, 0x20B00000002L, logLevel);
        }
        this.mStackSupervisor.getKeyguardController().writeToProto(proto, 1146756268035L);
        ActivityStack focusedStack = this.getTopDisplayFocusedStack();
        if (focusedStack != null) {
            proto.write(1120986464260L, focusedStack.mStackId);
            ActivityRecord focusedActivity = focusedStack.getDisplay().getResumedActivity();
            if (focusedActivity != null) {
                focusedActivity.writeIdentifierToProto(proto, 1146756268037L);
            }
        } else {
            proto.write(1120986464260L, -1);
        }
        proto.write(1133871366150L, this.mStackSupervisor.mRecentTasks.isRecentsComponentHomeActivity(this.mCurrentUser));
        this.mService.getActivityStartController().writeToProto(proto, 2246267895815L);
        proto.end(token);
    }

    private final class SleepTokenImpl
    extends ActivityTaskManagerInternal.SleepToken {
        private final String mTag;
        private final long mAcquireTime;
        private final int mDisplayId;

        public SleepTokenImpl(String tag, int displayId) {
            this.mTag = tag;
            this.mDisplayId = displayId;
            this.mAcquireTime = SystemClock.uptimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            WindowManagerGlobalLock windowManagerGlobalLock = RootActivityContainer.this.mService.mGlobalLock;
            synchronized (windowManagerGlobalLock) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    RootActivityContainer.this.removeSleepToken(this);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }

        public String toString() {
            return "{\"" + this.mTag + "\", display " + this.mDisplayId + ", acquire at " + TimeUtils.formatUptime(this.mAcquireTime) + "}";
        }
    }

    static class FindTaskResult {
        ActivityRecord mRecord;
        boolean mIdealMatch;

        FindTaskResult() {
        }

        void clear() {
            this.mRecord = null;
            this.mIdealMatch = false;
        }

        void setTo(FindTaskResult result) {
            this.mRecord = result.mRecord;
            this.mIdealMatch = result.mIdealMatch;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnyTaskForIdMatchTaskMode {
    }
}

