/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.res.Configuration;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.Trace;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.SurfaceControl;
import android.view.WindowManager;
import com.android.server.wm.ActivityDisplay;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.ConfigurationContainerListener;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplayPolicy;
import com.android.server.wm.RecentsAnimationController;
import com.android.server.wm.RootActivityContainer;
import com.android.server.wm.Session;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowAnimator;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowSurfaceController;
import com.android.server.wm.WindowSurfacePlacer;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;

class RootWindowContainer
extends WindowContainer<DisplayContent>
implements ConfigurationContainerListener {
    private static final String TAG = "WindowManager";
    private static final int SET_SCREEN_BRIGHTNESS_OVERRIDE = 1;
    private static final int SET_USER_ACTIVITY_TIMEOUT = 2;
    private RootActivityContainer mRootActivityContainer;
    private Object mLastWindowFreezeSource = null;
    private Session mHoldScreen = null;
    private float mScreenBrightness = -1.0f;
    private long mUserActivityTimeout = -1L;
    private boolean mUpdateRotation = false;
    WindowState mHoldScreenWindow = null;
    WindowState mObscuringWindow = null;
    private boolean mObscureApplicationContentOnSecondaryDisplays = false;
    private boolean mSustainedPerformanceModeEnabled = false;
    private boolean mSustainedPerformanceModeCurrent = false;
    boolean mOrientationChangeComplete = true;
    boolean mWallpaperActionPending = false;
    private final Handler mHandler;
    private String mCloseSystemDialogsReason;
    private int mTopFocusedDisplayId = -1;
    final HashMap<Integer, AppWindowToken> mTopFocusedAppByProcess = new HashMap();
    private final SurfaceControl.Transaction mDisplayTransaction = new SurfaceControl.Transaction();
    private final Consumer<WindowState> mCloseSystemDialogsConsumer = w -> {
        if (w.mHasSurface) {
            try {
                w.mClient.closeSystemDialogs(this.mCloseSystemDialogsReason);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    };
    private static final Consumer<WindowState> sRemoveReplacedWindowsConsumer = w -> {
        AppWindowToken aToken = w.mAppToken;
        if (aToken != null) {
            aToken.removeReplacedWindowIfNeeded((WindowState)w);
        }
    };

    RootWindowContainer(WindowManagerService service) {
        super(service);
        this.mHandler = new MyHandler(service.mH.getLooper());
    }

    void setRootActivityContainer(RootActivityContainer container) {
        this.mRootActivityContainer = container;
        if (container != null) {
            container.registerConfigurationChangeListener(this);
        }
    }

    boolean updateFocusedWindowLocked(int mode, boolean updateInputWindows) {
        this.mTopFocusedAppByProcess.clear();
        boolean changed = false;
        int topFocusedDisplayId = -1;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(i);
            changed |= dc.updateFocusedWindowLocked(mode, updateInputWindows, topFocusedDisplayId);
            WindowState newFocus = dc.mCurrentFocus;
            if (newFocus != null) {
                int pidOfNewFocus = newFocus.mSession.mPid;
                if (this.mTopFocusedAppByProcess.get(pidOfNewFocus) == null) {
                    this.mTopFocusedAppByProcess.put(pidOfNewFocus, newFocus.mAppToken);
                }
                if (topFocusedDisplayId != -1) continue;
                topFocusedDisplayId = dc.getDisplayId();
                continue;
            }
            if (topFocusedDisplayId != -1 || dc.mFocusedApp == null) continue;
            topFocusedDisplayId = dc.getDisplayId();
        }
        if (topFocusedDisplayId == -1) {
            topFocusedDisplayId = 0;
        }
        if (this.mTopFocusedDisplayId != topFocusedDisplayId) {
            this.mTopFocusedDisplayId = topFocusedDisplayId;
            this.mWmService.mInputManager.setFocusedDisplay(topFocusedDisplayId);
            this.mWmService.mPolicy.setTopFocusedDisplay(topFocusedDisplayId);
        }
        return changed;
    }

    DisplayContent getTopFocusedDisplayContent() {
        DisplayContent dc = this.getDisplayContent(this.mTopFocusedDisplayId);
        return dc != null ? dc : this.getDisplayContent(0);
    }

    @Override
    void onChildPositionChanged() {
        this.mWmService.updateFocusedWindowLocked(0, !this.mWmService.mPerDisplayFocusEnabled);
    }

    DisplayContent getDisplayContent(int displayId) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent current = (DisplayContent)this.mChildren.get(i);
            if (current.getDisplayId() != displayId) continue;
            return current;
        }
        return null;
    }

    DisplayContent createDisplayContent(Display display, ActivityDisplay activityDisplay) {
        int displayId = display.getDisplayId();
        DisplayContent existing = this.getDisplayContent(displayId);
        if (existing != null) {
            existing.mAcitvityDisplay = activityDisplay;
            existing.initializeDisplayOverrideConfiguration();
            return existing;
        }
        DisplayContent dc = new DisplayContent(display, this.mWmService, activityDisplay);
        this.mWmService.mDisplayWindowSettings.applySettingsToDisplayLocked(dc);
        dc.initializeDisplayOverrideConfiguration();
        if (this.mWmService.mDisplayManagerInternal != null) {
            this.mWmService.mDisplayManagerInternal.setDisplayInfoOverrideFromWindowManager(displayId, dc.getDisplayInfo());
            dc.configureDisplayPolicy();
        }
        this.mWmService.reconfigureDisplayLocked(dc);
        return dc;
    }

    void onSettingsRetrieved() {
        int numDisplays = this.mChildren.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = (DisplayContent)this.mChildren.get(displayNdx);
            boolean changed = this.mWmService.mDisplayWindowSettings.updateSettingsForDisplay(displayContent);
            if (!changed) continue;
            displayContent.initializeDisplayOverrideConfiguration();
            this.mWmService.reconfigureDisplayLocked(displayContent);
            if (!displayContent.isDefaultDisplay) continue;
            Configuration newConfig = this.mWmService.computeNewConfiguration(displayContent.getDisplayId());
            this.mWmService.mAtmService.updateConfigurationLocked(newConfig, null, false);
        }
    }

    boolean isLayoutNeeded() {
        int numDisplays = this.mChildren.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = (DisplayContent)this.mChildren.get(displayNdx);
            if (!displayContent.isLayoutNeeded()) continue;
            return true;
        }
        return false;
    }

    void getWindowsByName(ArrayList<WindowState> output, String name) {
        int objectId = 0;
        try {
            objectId = Integer.parseInt(name, 16);
            name = null;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.getWindowsByName(output, name, objectId);
    }

    private void getWindowsByName(ArrayList<WindowState> output, String name, int objectId) {
        this.forAllWindows((WindowState w) -> {
            if (name != null) {
                if (w.mAttrs.getTitle().toString().contains(name)) {
                    output.add((WindowState)w);
                }
            } else if (System.identityHashCode(w) == objectId) {
                output.add((WindowState)w);
            }
        }, true);
    }

    boolean isAnyNonToastWindowVisibleForUid(int callingUid) {
        return this.forAllWindows((WindowState w) -> w.getOwningUid() == callingUid && w.mAttrs.type != 2005 && w.mAttrs.type != 3 && w.isVisibleNow(), true);
    }

    AppWindowToken getAppWindowToken(IBinder binder) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(i);
            AppWindowToken atoken = dc.getAppWindowToken(binder);
            if (atoken == null) continue;
            return atoken;
        }
        return null;
    }

    WindowToken getWindowToken(IBinder binder) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(i);
            WindowToken wtoken = dc.getWindowToken(binder);
            if (wtoken == null) continue;
            return wtoken;
        }
        return null;
    }

    DisplayContent getWindowTokenDisplay(WindowToken token) {
        if (token == null) {
            return null;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(i);
            WindowToken current = dc.getWindowToken(token.token);
            if (current != token) continue;
            return dc;
        }
        return null;
    }

    void setDisplayOverrideConfigurationIfNeeded(Configuration newConfiguration, DisplayContent displayContent) {
        boolean configChanged;
        Configuration currentConfig = displayContent.getRequestedOverrideConfiguration();
        boolean bl = configChanged = currentConfig.diff(newConfiguration) != 0;
        if (!configChanged) {
            return;
        }
        displayContent.onRequestedOverrideConfigurationChanged(newConfiguration);
        if (displayContent.getDisplayId() == 0) {
            this.setGlobalConfigurationIfNeeded(newConfiguration);
        }
    }

    private void setGlobalConfigurationIfNeeded(Configuration newConfiguration) {
        boolean configChanged;
        boolean bl = configChanged = this.getConfiguration().diff(newConfiguration) != 0;
        if (!configChanged) {
            return;
        }
        this.onConfigurationChanged(newConfiguration);
    }

    @Override
    public void onConfigurationChanged(Configuration newParentConfig) {
        this.prepareFreezingTaskBounds();
        super.onConfigurationChanged(newParentConfig);
    }

    private void prepareFreezingTaskBounds() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((DisplayContent)this.mChildren.get(i)).prepareFreezingTaskBounds();
        }
    }

    TaskStack getStack(int windowingMode, int activityType) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(i);
            TaskStack stack = dc.getStack(windowingMode, activityType);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    void setSecureSurfaceState(int userId, boolean disabled) {
        this.forAllWindows((WindowState w) -> {
            if (w.mHasSurface && userId == UserHandle.getUserId(w.mOwnerUid)) {
                w.mWinAnimator.setSecureLocked(disabled);
            }
        }, true);
    }

    void updateHiddenWhileSuspendedState(ArraySet<String> packages, boolean suspended) {
        this.forAllWindows((WindowState w) -> {
            if (packages.contains(w.getOwningPackage())) {
                w.setHiddenWhileSuspended(suspended);
            }
        }, false);
    }

    void updateAppOpsState() {
        this.forAllWindows((WindowState w) -> w.updateAppOpsState(), false);
    }

    boolean canShowStrictModeViolation(int pid) {
        WindowState win = this.getWindow(w -> w.mSession.mPid == pid && w.isVisibleLw());
        return win != null;
    }

    void closeSystemDialogs(String reason) {
        this.mCloseSystemDialogsReason = reason;
        this.forAllWindows(this.mCloseSystemDialogsConsumer, false);
    }

    void removeReplacedWindows() {
        this.mWmService.openSurfaceTransaction();
        try {
            this.forAllWindows(sRemoveReplacedWindowsConsumer, true);
        }
        finally {
            this.mWmService.closeSurfaceTransaction("removeReplacedWindows");
        }
    }

    boolean hasPendingLayoutChanges(WindowAnimator animator2) {
        boolean hasChanges = false;
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(i);
            int pendingChanges = animator2.getPendingLayoutChanges(dc.getDisplayId());
            if ((pendingChanges & 4) != 0) {
                animator2.mBulkUpdateParams |= 8;
            }
            if (pendingChanges == 0) continue;
            hasChanges = true;
        }
        return hasChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reclaimSomeSurfaceMemory(WindowStateAnimator winAnimator, String operation, boolean secure) {
        WindowSurfaceController surfaceController = winAnimator.mSurfaceController;
        boolean leakedSurface = false;
        boolean killedApps = false;
        EventLog.writeEvent(31000, winAnimator.mWin.toString(), winAnimator.mSession.mPid, operation);
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            Slog.i(TAG, "Out of memory for surface!  Looking for leaks...");
            int numDisplays = this.mChildren.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                leakedSurface |= ((DisplayContent)this.mChildren.get(displayNdx)).destroyLeakedSurfaces();
            }
            if (!leakedSurface) {
                Slog.w(TAG, "No leaked surfaces; killing applications!");
                SparseIntArray pidCandidates = new SparseIntArray();
                for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    ((DisplayContent)this.mChildren.get(displayNdx)).forAllWindows((WindowState w) -> {
                        if (this.mWmService.mForceRemoves.contains(w)) {
                            return;
                        }
                        WindowStateAnimator wsa = w.mWinAnimator;
                        if (wsa.mSurfaceController != null) {
                            pidCandidates.append(wsa.mSession.mPid, wsa.mSession.mPid);
                        }
                    }, false);
                    if (pidCandidates.size() <= 0) continue;
                    int[] pids = new int[pidCandidates.size()];
                    for (int i = 0; i < pids.length; ++i) {
                        pids[i] = pidCandidates.keyAt(i);
                    }
                    try {
                        if (!this.mWmService.mActivityManager.killPids(pids, "Free memory", secure)) continue;
                        killedApps = true;
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            if (leakedSurface || killedApps) {
                Slog.w(TAG, "Looks like we have reclaimed some memory, clearing surface for retry.");
                if (surfaceController != null) {
                    winAnimator.destroySurface();
                    if (winAnimator.mWin.mAppToken != null) {
                        winAnimator.mWin.mAppToken.removeStartingWindow();
                    }
                }
                try {
                    winAnimator.mWin.mClient.dispatchGetNewSurface();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
        return leakedSurface || killedApps;
    }

    void performSurfacePlacement(boolean recoveringMemory) {
        Trace.traceBegin(32L, "performSurfacePlacement");
        try {
            this.performSurfacePlacementNoTrace(recoveringMemory);
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performSurfacePlacementNoTrace(boolean recoveringMemory) {
        int N;
        int displayNdx;
        int i;
        DisplayContent displayContent;
        if (this.mWmService.mFocusMayChange) {
            this.mWmService.mFocusMayChange = false;
            this.mWmService.updateFocusedWindowLocked(3, false);
        }
        int numDisplays = this.mChildren.size();
        for (int displayNdx2 = 0; displayNdx2 < numDisplays; ++displayNdx2) {
            DisplayContent displayContent2 = (DisplayContent)this.mChildren.get(displayNdx2);
            displayContent2.setExitingTokensHasVisible(false);
        }
        this.mHoldScreen = null;
        this.mScreenBrightness = -1.0f;
        this.mUserActivityTimeout = -1L;
        this.mObscureApplicationContentOnSecondaryDisplays = false;
        this.mSustainedPerformanceModeCurrent = false;
        ++this.mWmService.mTransactionSequence;
        DisplayContent defaultDisplay = this.mWmService.getDefaultDisplayContentLocked();
        WindowSurfacePlacer surfacePlacer = this.mWmService.mWindowPlacerLocked;
        Trace.traceBegin(32L, "applySurfaceChanges");
        this.mWmService.openSurfaceTransaction();
        try {
            this.applySurfaceChangesTransaction(recoveringMemory);
        }
        catch (RuntimeException e) {
            Slog.wtf(TAG, "Unhandled exception in Window Manager", e);
        }
        finally {
            this.mWmService.closeSurfaceTransaction("performLayoutAndPlaceSurfaces");
            Trace.traceEnd(32L);
        }
        this.mWmService.mAnimator.executeAfterPrepareSurfacesRunnables();
        this.checkAppTransitionReady(surfacePlacer);
        RecentsAnimationController recentsAnimationController = this.mWmService.getRecentsAnimationController();
        if (recentsAnimationController != null) {
            recentsAnimationController.checkAnimationReady(defaultDisplay.mWallpaperController);
        }
        for (int displayNdx3 = 0; displayNdx3 < numDisplays; ++displayNdx3) {
            displayContent = (DisplayContent)this.mChildren.get(displayNdx3);
            if (!displayContent.mWallpaperMayChange) continue;
            displayContent.pendingLayoutChanges |= 4;
        }
        if (this.mWmService.mFocusMayChange) {
            this.mWmService.mFocusMayChange = false;
            this.mWmService.updateFocusedWindowLocked(2, false);
        }
        if (this.isLayoutNeeded()) {
            defaultDisplay.pendingLayoutChanges |= 1;
        }
        this.handleResizingWindows();
        if (this.mOrientationChangeComplete) {
            if (this.mWmService.mWindowsFreezingScreen != 0) {
                this.mWmService.mWindowsFreezingScreen = 0;
                this.mWmService.mLastFinishedFreezeSource = this.mLastWindowFreezeSource;
                this.mWmService.mH.removeMessages(11);
            }
            this.mWmService.stopFreezingDisplayLocked();
        }
        if ((i = this.mWmService.mDestroySurface.size()) > 0) {
            do {
                WindowState win = this.mWmService.mDestroySurface.get(--i);
                win.mDestroying = false;
                displayContent = win.getDisplayContent();
                if (displayContent.mInputMethodWindow == win) {
                    displayContent.setInputMethodWindowLocked(null);
                }
                if (displayContent.mWallpaperController.isWallpaperTarget(win)) {
                    displayContent.pendingLayoutChanges |= 4;
                }
                win.destroySurfaceUnchecked();
                win.mWinAnimator.destroyPreservedSurfaceLocked();
            } while (i > 0);
            this.mWmService.mDestroySurface.clear();
        }
        for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            displayContent = (DisplayContent)this.mChildren.get(displayNdx);
            displayContent.removeExistingTokensIfPossible();
        }
        for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            displayContent = (DisplayContent)this.mChildren.get(displayNdx);
            if (displayContent.pendingLayoutChanges == 0) continue;
            displayContent.setLayoutNeeded();
        }
        this.mWmService.setHoldScreenLocked(this.mHoldScreen);
        if (!this.mWmService.mDisplayFrozen) {
            int brightness = this.mScreenBrightness < 0.0f || this.mScreenBrightness > 1.0f ? -1 : RootWindowContainer.toBrightnessOverride(this.mScreenBrightness);
            this.mHandler.obtainMessage(1, brightness, 0).sendToTarget();
            this.mHandler.obtainMessage(2, this.mUserActivityTimeout).sendToTarget();
        }
        if (this.mSustainedPerformanceModeCurrent != this.mSustainedPerformanceModeEnabled) {
            this.mSustainedPerformanceModeEnabled = this.mSustainedPerformanceModeCurrent;
            this.mWmService.mPowerManagerInternal.powerHint(6, this.mSustainedPerformanceModeEnabled ? 1 : 0);
        }
        if (this.mUpdateRotation) {
            this.mUpdateRotation = this.updateRotationUnchecked();
        }
        if (this.mWmService.mWaitingForDrawnCallback != null || this.mOrientationChangeComplete && !this.isLayoutNeeded() && !this.mUpdateRotation) {
            this.mWmService.checkDrawnWindowsLocked();
        }
        if ((N = this.mWmService.mPendingRemove.size()) > 0) {
            if (this.mWmService.mPendingRemoveTmp.length < N) {
                this.mWmService.mPendingRemoveTmp = new WindowState[N + 10];
            }
            this.mWmService.mPendingRemove.toArray(this.mWmService.mPendingRemoveTmp);
            this.mWmService.mPendingRemove.clear();
            ArrayList<DisplayContent> displayList = new ArrayList<DisplayContent>();
            for (i = 0; i < N; ++i) {
                WindowState w = this.mWmService.mPendingRemoveTmp[i];
                w.removeImmediately();
                DisplayContent displayContent3 = w.getDisplayContent();
                if (displayContent3 == null || displayList.contains(displayContent3)) continue;
                displayList.add(displayContent3);
            }
            for (int j = displayList.size() - 1; j >= 0; --j) {
                DisplayContent dc2 = (DisplayContent)displayList.get(j);
                dc2.assignWindowLayers(true);
            }
        }
        for (int displayNdx4 = this.mChildren.size() - 1; displayNdx4 >= 0; --displayNdx4) {
            ((DisplayContent)this.mChildren.get(displayNdx4)).checkCompleteDeferredRemoval();
        }
        this.forAllDisplays(dc -> {
            dc.getInputMonitor().updateInputWindowsLw(true);
            dc.updateSystemGestureExclusion();
            dc.updateTouchExcludeRegion();
        });
        this.mWmService.enableScreenIfNeededLocked();
        this.mWmService.scheduleAnimationLocked();
    }

    private void checkAppTransitionReady(WindowSurfacePlacer surfacePlacer) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent curDisplay = (DisplayContent)this.mChildren.get(i);
            if (curDisplay.mAppTransition.isReady()) {
                curDisplay.mAppTransitionController.handleAppTransitionReady();
            }
            if (!curDisplay.mAppTransition.isRunning() || curDisplay.isAppAnimating()) continue;
            curDisplay.handleAnimatingStoppedAndTransition();
        }
    }

    private void applySurfaceChangesTransaction(boolean recoveringMemory) {
        this.mHoldScreenWindow = null;
        this.mObscuringWindow = null;
        DisplayContent defaultDc = this.mWmService.getDefaultDisplayContentLocked();
        DisplayInfo defaultInfo = defaultDc.getDisplayInfo();
        int defaultDw = defaultInfo.logicalWidth;
        int defaultDh = defaultInfo.logicalHeight;
        if (this.mWmService.mWatermark != null) {
            this.mWmService.mWatermark.positionSurface(defaultDw, defaultDh);
        }
        if (this.mWmService.mStrictModeFlash != null) {
            this.mWmService.mStrictModeFlash.positionSurface(defaultDw, defaultDh);
        }
        if (this.mWmService.mCircularDisplayMask != null) {
            this.mWmService.mCircularDisplayMask.positionSurface(defaultDw, defaultDh, this.mWmService.getDefaultDisplayRotation());
        }
        if (this.mWmService.mEmulatorDisplayOverlay != null) {
            this.mWmService.mEmulatorDisplayOverlay.positionSurface(defaultDw, defaultDh, this.mWmService.getDefaultDisplayRotation());
        }
        int count = this.mChildren.size();
        for (int j = 0; j < count; ++j) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(j);
            dc.applySurfaceChangesTransaction(recoveringMemory);
        }
        this.mWmService.mDisplayManagerInternal.performTraversal(this.mDisplayTransaction);
        SurfaceControl.mergeToGlobalTransaction(this.mDisplayTransaction);
    }

    private void handleResizingWindows() {
        for (int i = this.mWmService.mResizingWindows.size() - 1; i >= 0; --i) {
            WindowState win = this.mWmService.mResizingWindows.get(i);
            if (win.mAppFreezing || win.getDisplayContent().mWaitingForConfig) continue;
            win.reportResized();
            this.mWmService.mResizingWindows.remove(i);
        }
    }

    boolean handleNotObscuredLocked(WindowState w, boolean obscured, boolean syswin) {
        WindowManager.LayoutParams attrs = w.mAttrs;
        int attrFlags = attrs.flags;
        boolean onScreen = w.isOnScreen();
        boolean canBeSeen = w.isDisplayedLw();
        int privateflags = attrs.privateFlags;
        boolean displayHasContent = false;
        if (w.mHasSurface && onScreen && !syswin && w.mAttrs.userActivityTimeout >= 0L && this.mUserActivityTimeout < 0L) {
            this.mUserActivityTimeout = w.mAttrs.userActivityTimeout;
        }
        if (w.mHasSurface && canBeSeen) {
            if ((attrFlags & 0x80) != 0) {
                this.mHoldScreen = w.mSession;
                this.mHoldScreenWindow = w;
            }
            if (!syswin && w.mAttrs.screenBrightness >= 0.0f && this.mScreenBrightness < 0.0f) {
                this.mScreenBrightness = w.mAttrs.screenBrightness;
            }
            int type = attrs.type;
            DisplayContent displayContent = w.getDisplayContent();
            if (displayContent != null && displayContent.isDefaultDisplay) {
                if (type == 2023 || (attrs.privateFlags & 0x400) != 0) {
                    this.mObscureApplicationContentOnSecondaryDisplays = true;
                }
                displayHasContent = true;
            } else if (displayContent != null && (!this.mObscureApplicationContentOnSecondaryDisplays || obscured && type == 2009)) {
                displayHasContent = true;
            }
            if ((privateflags & 0x40000) != 0) {
                this.mSustainedPerformanceModeCurrent = true;
            }
        }
        return displayHasContent;
    }

    boolean updateRotationUnchecked() {
        boolean changed = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent displayContent = (DisplayContent)this.mChildren.get(i);
            if (!displayContent.updateRotationAndSendNewConfigIfNeeded()) continue;
            changed = true;
        }
        return changed;
    }

    boolean copyAnimToLayoutParams() {
        boolean doRequest = false;
        int bulkUpdateParams = this.mWmService.mAnimator.mBulkUpdateParams;
        if ((bulkUpdateParams & 1) != 0) {
            this.mUpdateRotation = true;
            doRequest = true;
        }
        if ((bulkUpdateParams & 4) == 0) {
            this.mOrientationChangeComplete = false;
        } else {
            this.mOrientationChangeComplete = true;
            this.mLastWindowFreezeSource = this.mWmService.mAnimator.mLastWindowFreezeSource;
            if (this.mWmService.mWindowsFreezingScreen != 0) {
                doRequest = true;
            }
        }
        if ((bulkUpdateParams & 8) != 0) {
            this.mWallpaperActionPending = true;
        }
        return doRequest;
    }

    private static int toBrightnessOverride(float value) {
        return (int)(value * 255.0f);
    }

    void dumpDisplayContents(PrintWriter pw) {
        pw.println("WINDOW MANAGER DISPLAY CONTENTS (dumpsys window displays)");
        if (this.mWmService.mDisplayReady) {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                DisplayContent displayContent = (DisplayContent)this.mChildren.get(i);
                displayContent.dump(pw, "  ", true);
            }
        } else {
            pw.println("  NO DISPLAY");
        }
    }

    void dumpTopFocusedDisplayId(PrintWriter pw) {
        pw.print("  mTopFocusedDisplayId=");
        pw.println(this.mTopFocusedDisplayId);
    }

    void dumpLayoutNeededDisplayIds(PrintWriter pw) {
        if (!this.isLayoutNeeded()) {
            return;
        }
        pw.print("  mLayoutNeeded on displays=");
        int count = this.mChildren.size();
        for (int displayNdx = 0; displayNdx < count; ++displayNdx) {
            DisplayContent displayContent = (DisplayContent)this.mChildren.get(displayNdx);
            if (!displayContent.isLayoutNeeded()) continue;
            pw.print(displayContent.getDisplayId());
        }
        pw.println();
    }

    void dumpWindowsNoHeader(PrintWriter pw, boolean dumpAll, ArrayList<WindowState> windows) {
        int[] index = new int[1];
        this.forAllWindows((WindowState w) -> {
            if (windows == null || windows.contains(w)) {
                pw.println("  Window #" + index[0] + " " + w + ":");
                w.dump(pw, "    ", dumpAll || windows != null);
                index[0] = index[0] + 1;
            }
        }, true);
    }

    void dumpTokens(PrintWriter pw, boolean dumpAll) {
        pw.println("  All tokens:");
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((DisplayContent)this.mChildren.get(i)).dumpTokens(pw, dumpAll);
        }
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, int logLevel) {
        if (logLevel == 2 && !this.isVisible()) {
            return;
        }
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, logLevel);
        if (this.mWmService.mDisplayReady) {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                DisplayContent displayContent = (DisplayContent)this.mChildren.get(i);
                displayContent.writeToProto(proto, 0x20B00000002L, logLevel);
            }
        }
        if (logLevel == 0) {
            this.forAllWindows((WindowState w) -> w.writeIdentifierToProto(proto, 2246267895811L), true);
        }
        proto.end(token);
    }

    @Override
    String getName() {
        return "ROOT";
    }

    @Override
    void positionChildAt(int position, DisplayContent child, boolean includingParents) {
        super.positionChildAt(position, child, includingParents);
        if (this.mRootActivityContainer != null) {
            this.mRootActivityContainer.onChildPositionChanged(child.mAcitvityDisplay, position);
        }
    }

    void positionChildAt(int position, DisplayContent child) {
        super.positionChildAt(position, child, false);
    }

    @Override
    void scheduleAnimation() {
        this.mWmService.scheduleAnimationLocked();
    }

    @Override
    protected void removeChild(DisplayContent dc) {
        super.removeChild(dc);
        if (this.mTopFocusedDisplayId == dc.getDisplayId()) {
            this.mWmService.updateFocusedWindowLocked(0, true);
        }
    }

    void forAllDisplays(Consumer<DisplayContent> callback) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            callback.accept((DisplayContent)this.mChildren.get(i));
        }
    }

    void forAllDisplayPolicies(Consumer<DisplayPolicy> callback) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            callback.accept(((DisplayContent)this.mChildren.get(i)).getDisplayPolicy());
        }
    }

    WindowState getCurrentInputMethodWindow() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent displayContent = (DisplayContent)this.mChildren.get(i);
            if (displayContent.mInputMethodWindow == null) continue;
            return displayContent.mInputMethodWindow;
        }
        return null;
    }

    private final class MyHandler
    extends Handler {
        public MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    RootWindowContainer.this.mWmService.mPowerManagerInternal.setScreenBrightnessOverrideFromWindowManager(msg.arg1);
                    break;
                }
                case 2: {
                    RootWindowContainer.this.mWmService.mPowerManagerInternal.setUserActivityTimeoutOverrideFromWindowManager((Long)msg.obj);
                    break;
                }
            }
        }
    }
}

