/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.WindowConfiguration;
import com.android.server.wm.ActivityDisplay;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.TaskRecord;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

class RunningTasks {
    private static final Comparator<TaskRecord> LAST_ACTIVE_TIME_COMPARATOR = (o1, o2) -> Long.signum(o2.lastActiveTime - o1.lastActiveTime);
    private final TreeSet<TaskRecord> mTmpSortedSet = new TreeSet<TaskRecord>(LAST_ACTIVE_TIME_COMPARATOR);
    private final ArrayList<TaskRecord> mTmpStackTasks = new ArrayList();

    RunningTasks() {
    }

    void getTasks(int maxNum, List<ActivityManager.RunningTaskInfo> list, @WindowConfiguration.ActivityType int ignoreActivityType, @WindowConfiguration.WindowingMode int ignoreWindowingMode, ArrayList<ActivityDisplay> activityDisplays, int callingUid, boolean allowed) {
        if (maxNum <= 0) {
            return;
        }
        this.mTmpSortedSet.clear();
        int numDisplays = activityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ActivityDisplay display = activityDisplays.get(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                this.mTmpStackTasks.clear();
                stack.getRunningTasks(this.mTmpStackTasks, ignoreActivityType, ignoreWindowingMode, callingUid, allowed);
                this.mTmpSortedSet.addAll(this.mTmpStackTasks);
            }
        }
        Iterator<TaskRecord> iter = this.mTmpSortedSet.iterator();
        while (iter.hasNext() && maxNum != 0) {
            TaskRecord task = iter.next();
            list.add(this.createRunningTaskInfo(task));
            --maxNum;
        }
    }

    private ActivityManager.RunningTaskInfo createRunningTaskInfo(TaskRecord task) {
        ActivityManager.RunningTaskInfo rti = new ActivityManager.RunningTaskInfo();
        task.fillTaskInfo(rti);
        rti.id = rti.taskId;
        return rti;
    }
}

