/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityOptions;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Process;
import android.os.UserHandle;
import android.util.Slog;
import android.view.RemoteAnimationAdapter;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStackSupervisor;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.WindowProcessController;

public class SafeActivityOptions {
    private static final String TAG = "ActivityTaskManager";
    private final int mOriginalCallingPid = Binder.getCallingPid();
    private final int mOriginalCallingUid = Binder.getCallingUid();
    private int mRealCallingPid;
    private int mRealCallingUid;
    private final ActivityOptions mOriginalOptions;
    private ActivityOptions mCallerOptions;

    public static SafeActivityOptions fromBundle(Bundle bOptions) {
        return bOptions != null ? new SafeActivityOptions(ActivityOptions.fromBundle(bOptions)) : null;
    }

    public SafeActivityOptions(ActivityOptions options) {
        this.mOriginalOptions = options;
    }

    public void setCallerOptions(ActivityOptions options) {
        this.mRealCallingPid = Binder.getCallingPid();
        this.mRealCallingUid = Binder.getCallingUid();
        this.mCallerOptions = options;
    }

    ActivityOptions getOptions(ActivityRecord r) throws SecurityException {
        return this.getOptions(r.intent, r.info, r.app, r.mStackSupervisor);
    }

    ActivityOptions getOptions(ActivityStackSupervisor supervisor) throws SecurityException {
        return this.getOptions(null, null, null, supervisor);
    }

    ActivityOptions getOptions(Intent intent, ActivityInfo aInfo, WindowProcessController callerApp, ActivityStackSupervisor supervisor) throws SecurityException {
        if (this.mOriginalOptions != null) {
            this.checkPermissions(intent, aInfo, callerApp, supervisor, this.mOriginalOptions, this.mOriginalCallingPid, this.mOriginalCallingUid);
            this.setCallingPidForRemoteAnimationAdapter(this.mOriginalOptions, this.mOriginalCallingPid);
        }
        if (this.mCallerOptions != null) {
            this.checkPermissions(intent, aInfo, callerApp, supervisor, this.mCallerOptions, this.mRealCallingPid, this.mRealCallingUid);
            this.setCallingPidForRemoteAnimationAdapter(this.mCallerOptions, this.mRealCallingPid);
        }
        return this.mergeActivityOptions(this.mOriginalOptions, this.mCallerOptions);
    }

    private void setCallingPidForRemoteAnimationAdapter(ActivityOptions options, int callingPid) {
        RemoteAnimationAdapter adapter = options.getRemoteAnimationAdapter();
        if (adapter == null) {
            return;
        }
        if (callingPid == Process.myPid()) {
            Slog.wtf(TAG, "Safe activity options constructed after clearing calling id");
            return;
        }
        adapter.setCallingPid(callingPid);
    }

    Bundle popAppVerificationBundle() {
        return this.mOriginalOptions != null ? this.mOriginalOptions.popAppVerificationBundle() : null;
    }

    private void abort() {
        if (this.mOriginalOptions != null) {
            ActivityOptions.abort(this.mOriginalOptions);
        }
        if (this.mCallerOptions != null) {
            ActivityOptions.abort(this.mCallerOptions);
        }
    }

    static void abort(SafeActivityOptions options) {
        if (options != null) {
            options.abort();
        }
    }

    @VisibleForTesting
    ActivityOptions mergeActivityOptions(ActivityOptions options1, ActivityOptions options2) {
        if (options1 == null) {
            return options2;
        }
        if (options2 == null) {
            return options1;
        }
        Bundle b1 = options1.toBundle();
        Bundle b2 = options2.toBundle();
        b1.putAll(b2);
        return ActivityOptions.fromBundle(b1);
    }

    private void checkPermissions(Intent intent, ActivityInfo aInfo, WindowProcessController callerApp, ActivityStackSupervisor supervisor, ActivityOptions options, int callingPid, int callingUid) {
        int startInTaskPerm;
        if (options.getLaunchTaskId() != -1 && !supervisor.mRecentTasks.isCallerRecents(callingUid) && (startInTaskPerm = ActivityTaskManagerService.checkPermission("android.permission.START_TASKS_FROM_RECENTS", callingPid, callingUid)) == -1) {
            String msg = "Permission Denial: starting " + this.getIntentString(intent) + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") with launchTaskId=" + options.getLaunchTaskId();
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        int launchDisplayId = options.getLaunchDisplayId();
        if (aInfo != null && launchDisplayId != -1 && !supervisor.isCallerAllowedToLaunchOnDisplay(callingPid, callingUid, launchDisplayId, aInfo)) {
            String msg = "Permission Denial: starting " + this.getIntentString(intent) + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") with launchDisplayId=" + launchDisplayId;
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        boolean lockTaskMode = options.getLockTaskMode();
        if (aInfo != null && lockTaskMode && !supervisor.mService.getLockTaskController().isPackageWhitelisted(UserHandle.getUserId(callingUid), aInfo.packageName)) {
            String msg = "Permission Denial: starting " + this.getIntentString(intent) + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") with lockTaskMode=true";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        RemoteAnimationAdapter adapter = options.getRemoteAnimationAdapter();
        if (adapter != null) {
            ActivityTaskManagerService cfr_ignored_0 = supervisor.mService;
            if (ActivityTaskManagerService.checkPermission("android.permission.CONTROL_REMOTE_APP_TRANSITION_ANIMATIONS", callingPid, callingUid) != 0) {
                String msg = "Permission Denial: starting " + this.getIntentString(intent) + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") with remoteAnimationAdapter";
                Slog.w(TAG, msg);
                throw new SecurityException(msg);
            }
        }
    }

    private String getIntentString(Intent intent) {
        return intent != null ? intent.toString() : "(no intent)";
    }
}

