/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.IBinder;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.wm.BarController;
import com.android.server.wm.WindowManagerInternal;

public class StatusBarController
extends BarController {
    private final WindowManagerInternal.AppTransitionListener mAppTransitionListener = new WindowManagerInternal.AppTransitionListener(){
        private Runnable mAppTransitionPending = () -> {
            StatusBarManagerInternal statusBar = StatusBarController.this.getStatusBarInternal();
            if (statusBar != null) {
                statusBar.appTransitionPending(StatusBarController.this.mDisplayId);
            }
        };
        private Runnable mAppTransitionCancelled = () -> {
            StatusBarManagerInternal statusBar = StatusBarController.this.getStatusBarInternal();
            if (statusBar != null) {
                statusBar.appTransitionCancelled(StatusBarController.this.mDisplayId);
            }
        };
        private Runnable mAppTransitionFinished = () -> {
            StatusBarManagerInternal statusBar = StatusBarController.this.getStatusBarInternal();
            if (statusBar != null) {
                statusBar.appTransitionFinished(StatusBarController.this.mDisplayId);
            }
        };

        @Override
        public void onAppTransitionPendingLocked() {
            StatusBarController.this.mHandler.post(this.mAppTransitionPending);
        }

        @Override
        public int onAppTransitionStartingLocked(int transit, long duration, long statusBarAnimationStartTime, long statusBarAnimationDuration) {
            StatusBarController.this.mHandler.post(() -> {
                StatusBarManagerInternal statusBar = StatusBarController.this.getStatusBarInternal();
                if (statusBar != null) {
                    statusBar.appTransitionStarting(StatusBarController.this.mDisplayId, statusBarAnimationStartTime, statusBarAnimationDuration);
                }
            });
            return 0;
        }

        @Override
        public void onAppTransitionCancelledLocked(int transit) {
            StatusBarController.this.mHandler.post(this.mAppTransitionCancelled);
        }

        @Override
        public void onAppTransitionFinishedLocked(IBinder token) {
            StatusBarController.this.mHandler.post(this.mAppTransitionFinished);
        }
    };

    StatusBarController(int displayId) {
        super("StatusBar", displayId, 0x4000000, 0x10000000, 0x40000000, 1, 0x4000000, 8);
    }

    void setTopAppHidesStatusBar(boolean hidesStatusBar) {
        StatusBarManagerInternal statusBar = this.getStatusBarInternal();
        if (statusBar != null) {
            statusBar.setTopAppHidesStatusBar(hidesStatusBar);
        }
    }

    @Override
    protected boolean skipAnimation() {
        return this.mWin.getAttrs().height == -1;
    }

    WindowManagerInternal.AppTransitionListener getAppTransitionListener() {
        return this.mAppTransitionListener;
    }
}

