/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.SurfaceControl;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;

class SurfaceAnimator {
    private static final String TAG = "WindowManager";
    private final WindowManagerService mService;
    private AnimationAdapter mAnimation;
    @VisibleForTesting
    SurfaceControl mLeash;
    @VisibleForTesting
    final Animatable mAnimatable;
    private final OnAnimationFinishedCallback mInnerAnimationFinishedCallback;
    @VisibleForTesting
    final Runnable mAnimationFinishedCallback;
    private boolean mAnimationStartDelayed;

    SurfaceAnimator(Animatable animatable, Runnable animationFinishedCallback, WindowManagerService service) {
        this.mAnimatable = animatable;
        this.mService = service;
        this.mAnimationFinishedCallback = animationFinishedCallback;
        this.mInnerAnimationFinishedCallback = this.getFinishedCallback(animationFinishedCallback);
    }

    private OnAnimationFinishedCallback getFinishedCallback(Runnable animationFinishedCallback) {
        return anim2 -> {
            block7: {
                block6: {
                    WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
                    // MONITORENTER : windowManagerGlobalLock
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        SurfaceAnimator target = this.mService.mAnimationTransferMap.remove(anim2);
                        if (target == null) break block6;
                        target.mInnerAnimationFinishedCallback.onAnimationFinished(anim2);
                        // MONITOREXIT : windowManagerGlobalLock
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : windowManagerGlobalLock
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                if (anim2 == this.mAnimation) break block7;
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
            }
            Runnable resetAndInvokeFinish = () -> {
                if (anim2 != this.mAnimation) {
                    return;
                }
                this.reset(this.mAnimatable.getPendingTransaction(), true);
                if (animationFinishedCallback != null) {
                    animationFinishedCallback.run();
                }
            };
            if (!this.mAnimatable.shouldDeferAnimationFinish(resetAndInvokeFinish)) {
                resetAndInvokeFinish.run();
            }
            // MONITOREXIT : windowManagerGlobalLock
            WindowManagerService.resetPriorityAfterLockedSection();
        };
    }

    void startAnimation(SurfaceControl.Transaction t, AnimationAdapter anim2, boolean hidden) {
        this.cancelAnimation(t, true, true);
        this.mAnimation = anim2;
        SurfaceControl surface = this.mAnimatable.getSurfaceControl();
        if (surface == null) {
            Slog.w(TAG, "Unable to start animation, surface is null or no children.");
            this.cancelAnimation();
            return;
        }
        this.mLeash = this.createAnimationLeash(surface, t, this.mAnimatable.getSurfaceWidth(), this.mAnimatable.getSurfaceHeight(), hidden);
        this.mAnimatable.onAnimationLeashCreated(t, this.mLeash);
        if (this.mAnimationStartDelayed) {
            return;
        }
        this.mAnimation.startAnimation(this.mLeash, t, this.mInnerAnimationFinishedCallback);
    }

    void startDelayingAnimationStart() {
        if (!this.isAnimating()) {
            this.mAnimationStartDelayed = true;
        }
    }

    void endDelayingAnimationStart() {
        boolean delayed = this.mAnimationStartDelayed;
        this.mAnimationStartDelayed = false;
        if (delayed && this.mAnimation != null) {
            this.mAnimation.startAnimation(this.mLeash, this.mAnimatable.getPendingTransaction(), this.mInnerAnimationFinishedCallback);
            this.mAnimatable.commitPendingTransaction();
        }
    }

    boolean isAnimating() {
        return this.mAnimation != null;
    }

    AnimationAdapter getAnimation() {
        return this.mAnimation;
    }

    void cancelAnimation() {
        this.cancelAnimation(this.mAnimatable.getPendingTransaction(), false, true);
        this.mAnimatable.commitPendingTransaction();
    }

    void setLayer(SurfaceControl.Transaction t, int layer) {
        t.setLayer(this.mLeash != null ? this.mLeash : this.mAnimatable.getSurfaceControl(), layer);
    }

    void setRelativeLayer(SurfaceControl.Transaction t, SurfaceControl relativeTo, int layer) {
        t.setRelativeLayer(this.mLeash != null ? this.mLeash : this.mAnimatable.getSurfaceControl(), relativeTo, layer);
    }

    void reparent(SurfaceControl.Transaction t, SurfaceControl newParent) {
        t.reparent(this.mLeash != null ? this.mLeash : this.mAnimatable.getSurfaceControl(), newParent);
    }

    boolean hasLeash() {
        return this.mLeash != null;
    }

    void transferAnimation(SurfaceAnimator from) {
        if (from.mLeash == null) {
            return;
        }
        SurfaceControl surface = this.mAnimatable.getSurfaceControl();
        SurfaceControl parent = this.mAnimatable.getAnimationLeashParent();
        if (surface == null || parent == null) {
            Slog.w(TAG, "Unable to transfer animation, surface or parent is null");
            this.cancelAnimation();
            return;
        }
        this.endDelayingAnimationStart();
        SurfaceControl.Transaction t = this.mAnimatable.getPendingTransaction();
        this.cancelAnimation(t, true, true);
        this.mLeash = from.mLeash;
        this.mAnimation = from.mAnimation;
        from.cancelAnimation(t, false, false);
        t.reparent(surface, this.mLeash);
        t.reparent(this.mLeash, parent);
        this.mAnimatable.onAnimationLeashCreated(t, this.mLeash);
        this.mService.mAnimationTransferMap.put(this.mAnimation, this);
    }

    boolean isAnimationStartDelayed() {
        return this.mAnimationStartDelayed;
    }

    private void cancelAnimation(SurfaceControl.Transaction t, boolean restarting, boolean forwardCancel) {
        SurfaceControl leash = this.mLeash;
        AnimationAdapter animation = this.mAnimation;
        this.reset(t, false);
        if (animation != null) {
            if (!this.mAnimationStartDelayed && forwardCancel) {
                animation.onAnimationCancelled(leash);
            }
            if (!restarting) {
                this.mAnimationFinishedCallback.run();
            }
        }
        if (forwardCancel && leash != null) {
            t.remove(leash);
            this.mService.scheduleAnimationLocked();
        }
        if (!restarting) {
            this.mAnimationStartDelayed = false;
        }
    }

    private void reset(SurfaceControl.Transaction t, boolean destroyLeash) {
        boolean reparent;
        SurfaceControl surface = this.mAnimatable.getSurfaceControl();
        SurfaceControl parent = this.mAnimatable.getParentSurfaceControl();
        boolean scheduleAnim = false;
        boolean bl = reparent = this.mLeash != null && surface != null;
        if (reparent && surface.isValid() && parent != null && parent.isValid()) {
            t.reparent(surface, parent);
            scheduleAnim = true;
        }
        this.mService.mAnimationTransferMap.remove(this.mAnimation);
        if (this.mLeash != null && destroyLeash) {
            t.remove(this.mLeash);
            scheduleAnim = true;
        }
        this.mLeash = null;
        this.mAnimation = null;
        if (reparent) {
            this.mAnimatable.onAnimationLeashLost(t);
            scheduleAnim = true;
        }
        if (scheduleAnim) {
            this.mService.scheduleAnimationLocked();
        }
    }

    private SurfaceControl createAnimationLeash(SurfaceControl surface, SurfaceControl.Transaction t, int width, int height, boolean hidden) {
        SurfaceControl.Builder builder = this.mAnimatable.makeAnimationLeash().setParent(this.mAnimatable.getAnimationLeashParent()).setName(surface + " - animation-leash");
        SurfaceControl leash = builder.build();
        t.setWindowCrop(leash, width, height);
        if (!hidden) {
            t.show(leash);
        }
        t.reparent(surface, leash);
        return leash;
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        if (this.mAnimation != null) {
            this.mAnimation.writeToProto(proto, 1146756268035L);
        }
        if (this.mLeash != null) {
            this.mLeash.writeToProto(proto, 0x10B00000001L);
        }
        proto.write(1133871366146L, this.mAnimationStartDelayed);
        proto.end(token);
    }

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mLeash=");
        pw.print(this.mLeash);
        if (this.mAnimationStartDelayed) {
            pw.print(" mAnimationStartDelayed=");
            pw.println(this.mAnimationStartDelayed);
        } else {
            pw.println();
        }
        pw.print(prefix);
        pw.println("Animation:");
        if (this.mAnimation != null) {
            this.mAnimation.dump(pw, prefix + "  ");
        } else {
            pw.print(prefix);
            pw.println("null");
        }
    }

    static interface Animatable {
        public SurfaceControl.Transaction getPendingTransaction();

        public void commitPendingTransaction();

        public void onAnimationLeashCreated(SurfaceControl.Transaction var1, SurfaceControl var2);

        public void onAnimationLeashLost(SurfaceControl.Transaction var1);

        public SurfaceControl.Builder makeAnimationLeash();

        public SurfaceControl getAnimationLeashParent();

        public SurfaceControl getSurfaceControl();

        public SurfaceControl getParentSurfaceControl();

        public int getSurfaceWidth();

        public int getSurfaceHeight();

        default public boolean shouldDeferAnimationFinish(Runnable endDeferFinishCallback) {
            return false;
        }
    }

    static interface OnAnimationFinishedCallback {
        public void onAnimationFinished(AnimationAdapter var1);
    }
}

