/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.IBinder;
import android.util.EventLog;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.SurfaceControl;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.ConfigurationContainerListener;
import com.android.server.wm.Dimmer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DragResizeMode;
import com.android.server.wm.RecentsAnimationController;
import com.android.server.wm.TaskRecord;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;
import java.util.function.Consumer;

class Task
extends WindowContainer<AppWindowToken>
implements ConfigurationContainerListener {
    static final String TAG = "WindowManager";
    TaskStack mStack;
    final int mTaskId;
    final int mUserId;
    private boolean mDeferRemoval = false;
    final Rect mPreparedFrozenBounds = new Rect();
    final Configuration mPreparedFrozenMergedConfig = new Configuration();
    private final Rect mOverrideDisplayedBounds = new Rect();
    private int mLastRotationDisplayId = -1;
    private int mRotation;
    private Rect mTmpRect = new Rect();
    private Rect mTmpRect2 = new Rect();
    private Rect mTmpRect3 = new Rect();
    private int mResizeMode;
    private boolean mSupportsPictureInPicture;
    private boolean mDragResizing;
    private int mDragResizeMode;
    private ActivityManager.TaskDescription mTaskDescription;
    private boolean mPreserveNonFloatingState = false;
    private Dimmer mDimmer = new Dimmer(this);
    private final Rect mTmpDimBoundsRect = new Rect();
    private boolean mCanAffectSystemUiFlags = true;
    TaskRecord mTaskRecord;

    Task(int taskId, TaskStack stack, int userId, WindowManagerService service, int resizeMode, boolean supportsPictureInPicture, ActivityManager.TaskDescription taskDescription, TaskRecord taskRecord) {
        super(service);
        this.mTaskId = taskId;
        this.mStack = stack;
        this.mUserId = userId;
        this.mResizeMode = resizeMode;
        this.mSupportsPictureInPicture = supportsPictureInPicture;
        this.mTaskRecord = taskRecord;
        if (this.mTaskRecord != null) {
            this.mTaskRecord.registerConfigurationChangeListener(this);
        }
        this.setBounds(this.getRequestedOverrideBounds());
        this.mTaskDescription = taskDescription;
        this.setOrientation(-2);
    }

    @Override
    DisplayContent getDisplayContent() {
        return this.mStack != null ? this.mStack.getDisplayContent() : null;
    }

    private int getAdjustedAddPosition(int suggestedPosition) {
        int size = this.mChildren.size();
        if (suggestedPosition >= size) {
            return Math.min(size, suggestedPosition);
        }
        for (int pos = 0; pos < size && pos < suggestedPosition; ++pos) {
            if (!((AppWindowToken)this.mChildren.get((int)pos)).removed) continue;
            ++suggestedPosition;
        }
        return Math.min(size, suggestedPosition);
    }

    @Override
    void addChild(AppWindowToken wtoken, int position) {
        position = this.getAdjustedAddPosition(position);
        super.addChild(wtoken, position);
        this.mDeferRemoval = false;
    }

    @Override
    void positionChildAt(int position, AppWindowToken child, boolean includingParents) {
        position = this.getAdjustedAddPosition(position);
        super.positionChildAt(position, child, includingParents);
        this.mDeferRemoval = false;
    }

    private boolean hasWindowsAlive() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if (!((AppWindowToken)this.mChildren.get(i)).hasWindowsAlive()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean shouldDeferRemoval() {
        return this.hasWindowsAlive() && this.mStack.isSelfOrChildAnimating();
    }

    @Override
    void removeIfPossible() {
        if (this.shouldDeferRemoval()) {
            this.mDeferRemoval = true;
            return;
        }
        this.removeImmediately();
    }

    @Override
    void removeImmediately() {
        EventLog.writeEvent(31003, this.mTaskId, "removeTask");
        this.mDeferRemoval = false;
        if (this.mTaskRecord != null) {
            this.mTaskRecord.unregisterConfigurationChangeListener(this);
        }
        super.removeImmediately();
    }

    void reparent(TaskStack stack, int position, boolean moveParents) {
        if (stack == this.mStack) {
            throw new IllegalArgumentException("task=" + this + " already child of stack=" + this.mStack);
        }
        if (stack == null) {
            throw new IllegalArgumentException("reparent: could not find stack.");
        }
        EventLog.writeEvent(31003, this.mTaskId, "reParentTask");
        DisplayContent prevDisplayContent = this.getDisplayContent();
        this.mPreserveNonFloatingState = stack.inPinnedWindowingMode();
        this.getParent().removeChild(this);
        stack.addTask(this, position, this.showForAllUsers(), moveParents);
        DisplayContent displayContent = stack.getDisplayContent();
        displayContent.setLayoutNeeded();
        if (prevDisplayContent != displayContent) {
            this.onDisplayChanged(displayContent);
            prevDisplayContent.setLayoutNeeded();
        }
        this.getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
    }

    void positionAt(int position) {
        this.mStack.positionChildAt(position, this, false);
    }

    @Override
    void onParentChanged() {
        super.onParentChanged();
        this.adjustBoundsForDisplayChangeIfNeeded(this.getDisplayContent());
        if (this.getWindowConfiguration().windowsAreScaleable()) {
            this.forceWindowsScaleable(true);
        } else {
            this.forceWindowsScaleable(false);
        }
    }

    @Override
    void removeChild(AppWindowToken token) {
        if (!this.mChildren.contains(token)) {
            Slog.e(TAG, "removeChild: token=" + this + " not found.");
            return;
        }
        super.removeChild(token);
        if (this.mChildren.isEmpty()) {
            EventLog.writeEvent(31003, this.mTaskId, "removeAppToken: last token");
            if (this.mDeferRemoval) {
                this.removeIfPossible();
            }
        }
    }

    void setSendingToBottom(boolean toBottom) {
        for (int appTokenNdx = 0; appTokenNdx < this.mChildren.size(); ++appTokenNdx) {
            ((AppWindowToken)this.mChildren.get((int)appTokenNdx)).sendingToBottom = toBottom;
        }
    }

    public int setBounds(Rect bounds, boolean forceResize) {
        int boundsChanged = this.setBounds(bounds);
        if (forceResize && (boundsChanged & 2) != 2) {
            this.onResize();
            return 2 | boundsChanged;
        }
        return boundsChanged;
    }

    @Override
    public int setBounds(Rect bounds) {
        int rotation = 0;
        DisplayContent displayContent = this.mStack.getDisplayContent();
        if (displayContent != null) {
            rotation = displayContent.getDisplayInfo().rotation;
        } else if (bounds == null) {
            return super.setBounds(bounds);
        }
        int boundsChange = super.setBounds(bounds);
        this.mRotation = rotation;
        this.updateSurfacePosition();
        return boundsChange;
    }

    @Override
    public boolean onDescendantOrientationChanged(IBinder freezeDisplayToken, ConfigurationContainer requestingContainer) {
        if (super.onDescendantOrientationChanged(freezeDisplayToken, requestingContainer)) {
            return true;
        }
        if (this.mTaskRecord != null && this.mTaskRecord.getParent() != null) {
            this.mTaskRecord.onConfigurationChanged(this.mTaskRecord.getParent().getConfiguration());
            return true;
        }
        return false;
    }

    void resize(boolean relayout, boolean forced) {
        if (this.setBounds(this.getRequestedOverrideBounds(), forced) != 0 && relayout) {
            this.getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
        }
    }

    @Override
    void onDisplayChanged(DisplayContent dc) {
        this.adjustBoundsForDisplayChangeIfNeeded(dc);
        super.onDisplayChanged(dc);
        int displayId = dc != null ? dc.getDisplayId() : -1;
        this.mWmService.mAtmService.getTaskChangeNotificationController().notifyTaskDisplayChanged(this.mTaskId, displayId);
    }

    void setOverrideDisplayedBounds(Rect overrideDisplayedBounds) {
        if (overrideDisplayedBounds != null) {
            this.mOverrideDisplayedBounds.set(overrideDisplayedBounds);
        } else {
            this.mOverrideDisplayedBounds.setEmpty();
        }
        this.updateSurfacePosition();
    }

    Rect getOverrideDisplayedBounds() {
        return this.mOverrideDisplayedBounds;
    }

    void setResizeable(int resizeMode) {
        this.mResizeMode = resizeMode;
    }

    boolean isResizeable() {
        return ActivityInfo.isResizeableMode(this.mResizeMode) || this.mSupportsPictureInPicture || this.mWmService.mForceResizableTasks;
    }

    boolean preserveOrientationOnResize() {
        return this.mResizeMode == 6 || this.mResizeMode == 5 || this.mResizeMode == 7;
    }

    boolean cropWindowsToStackBounds() {
        return this.isResizeable();
    }

    void prepareFreezingBounds() {
        this.mPreparedFrozenBounds.set(this.getBounds());
        this.mPreparedFrozenMergedConfig.setTo(this.getConfiguration());
    }

    void alignToAdjustedBounds(Rect adjustedBounds, Rect tempInsetBounds, boolean alignBottom) {
        if (!this.isResizeable() || Configuration.EMPTY.equals(this.getRequestedOverrideConfiguration())) {
            return;
        }
        this.getBounds(this.mTmpRect2);
        if (alignBottom) {
            int offsetY = adjustedBounds.bottom - this.mTmpRect2.bottom;
            this.mTmpRect2.offset(0, offsetY);
        } else {
            this.mTmpRect2.offsetTo(adjustedBounds.left, adjustedBounds.top);
        }
        if (tempInsetBounds == null || tempInsetBounds.isEmpty()) {
            this.setOverrideDisplayedBounds(null);
            this.setBounds(this.mTmpRect2);
        } else {
            this.setOverrideDisplayedBounds(this.mTmpRect2);
            this.setBounds(tempInsetBounds);
        }
    }

    @Override
    public Rect getDisplayedBounds() {
        if (this.mOverrideDisplayedBounds.isEmpty()) {
            return super.getDisplayedBounds();
        }
        return this.mOverrideDisplayedBounds;
    }

    private boolean getMaxVisibleBounds(Rect out) {
        boolean foundTop = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win;
            AppWindowToken token = (AppWindowToken)this.mChildren.get(i);
            if (token.mIsExiting || token.isClientHidden() || token.hiddenRequested || (win = token.findMainWindow()) == null) continue;
            if (!foundTop) {
                foundTop = true;
                out.setEmpty();
            }
            win.getMaxVisibleBounds(out);
        }
        return foundTop;
    }

    public void getDimBounds(Rect out) {
        boolean dockedResizing;
        DisplayContent displayContent = this.mStack.getDisplayContent();
        boolean bl = dockedResizing = displayContent != null && displayContent.mDividerControllerLocked.isResizing();
        if (this.inFreeformWindowingMode() && this.getMaxVisibleBounds(out)) {
            return;
        }
        if (!this.matchParentBounds()) {
            if (dockedResizing) {
                this.mStack.getBounds(out);
            } else {
                this.mStack.getBounds(this.mTmpRect);
                this.mTmpRect.intersect(this.getBounds());
                out.set(this.mTmpRect);
            }
        } else {
            out.set(this.getBounds());
        }
    }

    void setDragResizing(boolean dragResizing, int dragResizeMode) {
        if (this.mDragResizing != dragResizing) {
            if (dragResizing && !DragResizeMode.isModeAllowedForStack(this.mStack, dragResizeMode)) {
                throw new IllegalArgumentException("Drag resize mode not allow for stack stackId=" + this.mStack.mStackId + " dragResizeMode=" + dragResizeMode);
            }
            this.mDragResizing = dragResizing;
            this.mDragResizeMode = dragResizeMode;
            this.resetDragResizingChangeReported();
        }
    }

    boolean isDragResizing() {
        return this.mDragResizing;
    }

    int getDragResizeMode() {
        return this.mDragResizeMode;
    }

    public void setTaskDockedResizing(boolean resizing) {
        this.setDragResizing(resizing, 1);
    }

    private void adjustBoundsForDisplayChangeIfNeeded(DisplayContent displayContent) {
        if (displayContent == null) {
            return;
        }
        if (this.matchParentBounds()) {
            this.setBounds(null);
            return;
        }
        int displayId = displayContent.getDisplayId();
        int newRotation = displayContent.getDisplayInfo().rotation;
        if (displayId != this.mLastRotationDisplayId) {
            this.mLastRotationDisplayId = displayId;
            this.mRotation = newRotation;
            return;
        }
        if (this.mRotation == newRotation) {
            return;
        }
        this.mTmpRect2.set(this.getBounds());
        if (!this.getWindowConfiguration().canResizeTask()) {
            this.setBounds(this.mTmpRect2);
            return;
        }
        displayContent.rotateBounds(this.mRotation, newRotation, this.mTmpRect2);
        if (this.setBounds(this.mTmpRect2) != 0 && this.mTaskRecord != null) {
            this.mTaskRecord.requestResize(this.getBounds(), 1);
        }
    }

    void cancelTaskWindowTransition() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((AppWindowToken)this.mChildren.get(i)).cancelAnimation();
        }
    }

    boolean showForAllUsers() {
        int tokensCount = this.mChildren.size();
        return tokensCount != 0 && ((AppWindowToken)this.mChildren.get((int)(tokensCount - 1))).mShowForAllUsers;
    }

    boolean isFloating() {
        return this.getWindowConfiguration().tasksAreFloating() && !this.mStack.isAnimatingBoundsToFullscreen() && !this.mPreserveNonFloatingState;
    }

    @Override
    public SurfaceControl getAnimationLeashParent() {
        return this.getAppAnimationLayer(2);
    }

    @Override
    SurfaceControl.Builder makeSurface() {
        return super.makeSurface().setMetadata(3, this.mTaskId);
    }

    boolean isTaskAnimating() {
        RecentsAnimationController recentsAnim = this.mWmService.getRecentsAnimationController();
        return recentsAnim != null && recentsAnim.isAnimatingTask(this);
    }

    WindowState getTopVisibleAppMainWindow() {
        AppWindowToken token = this.getTopVisibleAppToken();
        return token != null ? token.findMainWindow() : null;
    }

    AppWindowToken getTopFullscreenAppToken() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            AppWindowToken token = (AppWindowToken)this.mChildren.get(i);
            WindowState win = token.findMainWindow();
            if (win == null || !win.mAttrs.isFullscreen()) continue;
            return token;
        }
        return null;
    }

    AppWindowToken getTopVisibleAppToken() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            AppWindowToken token = (AppWindowToken)this.mChildren.get(i);
            if (token.mIsExiting || token.isClientHidden() || token.hiddenRequested) continue;
            return token;
        }
        return null;
    }

    void positionChildAtTop(AppWindowToken aToken) {
        this.positionChildAt(aToken, Integer.MAX_VALUE);
    }

    void positionChildAt(AppWindowToken aToken, int position) {
        if (aToken == null) {
            Slog.w(TAG, "Attempted to position of non-existing app");
            return;
        }
        this.positionChildAt(position, aToken, false);
    }

    void forceWindowsScaleable(boolean force) {
        this.mWmService.openSurfaceTransaction();
        try {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                ((AppWindowToken)this.mChildren.get(i)).forceWindowsScaleableInTransaction(force);
            }
        }
        finally {
            this.mWmService.closeSurfaceTransaction("forceWindowsScaleable");
        }
    }

    void setTaskDescription(ActivityManager.TaskDescription taskDescription) {
        this.mTaskDescription = taskDescription;
    }

    void onSnapshotChanged(ActivityManager.TaskSnapshot snapshot) {
        this.mTaskRecord.onSnapshotChanged(snapshot);
    }

    ActivityManager.TaskDescription getTaskDescription() {
        return this.mTaskDescription;
    }

    @Override
    boolean fillsParent() {
        return this.matchParentBounds() || !this.getWindowConfiguration().canResizeTask();
    }

    @Override
    void forAllTasks(Consumer<Task> callback) {
        callback.accept(this);
    }

    void setCanAffectSystemUiFlags(boolean canAffectSystemUiFlags) {
        this.mCanAffectSystemUiFlags = canAffectSystemUiFlags;
    }

    boolean canAffectSystemUiFlags() {
        return this.mCanAffectSystemUiFlags;
    }

    void dontAnimateDimExit() {
        this.mDimmer.dontAnimateExit();
    }

    public String toString() {
        return "{taskId=" + this.mTaskId + " appTokens=" + this.mChildren + " mdr=" + this.mDeferRemoval + "}";
    }

    @Override
    String getName() {
        return this.toShortString();
    }

    void clearPreserveNonFloatingState() {
        this.mPreserveNonFloatingState = false;
    }

    @Override
    Dimmer getDimmer() {
        return this.mDimmer;
    }

    @Override
    void prepareSurfaces() {
        this.mDimmer.resetDimStates();
        super.prepareSurfaces();
        this.getDimBounds(this.mTmpDimBoundsRect);
        this.mTmpDimBoundsRect.offsetTo(0, 0);
        if (this.mDimmer.updateDims(this.getPendingTransaction(), this.mTmpDimBoundsRect)) {
            this.scheduleAnimation();
        }
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, int logLevel) {
        if (logLevel == 2 && !this.isVisible()) {
            return;
        }
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, logLevel);
        proto.write(1120986464258L, this.mTaskId);
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            AppWindowToken appWindowToken = (AppWindowToken)this.mChildren.get(i);
            appWindowToken.writeToProto(proto, 2246267895811L, logLevel);
        }
        proto.write(1133871366148L, this.matchParentBounds());
        this.getBounds().writeToProto(proto, 1146756268037L);
        this.mOverrideDisplayedBounds.writeToProto(proto, 1146756268038L);
        proto.write(1133871366151L, this.mDeferRemoval);
        proto.write(1120986464264L, this.mSurfaceControl.getWidth());
        proto.write(1120986464265L, this.mSurfaceControl.getHeight());
        proto.end(token);
    }

    @Override
    public void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        super.dump(pw, prefix, dumpAll);
        String doublePrefix = prefix + "  ";
        pw.println(prefix + "taskId=" + this.mTaskId);
        pw.println(doublePrefix + "mBounds=" + this.getBounds().toShortString());
        pw.println(doublePrefix + "mdr=" + this.mDeferRemoval);
        pw.println(doublePrefix + "appTokens=" + this.mChildren);
        pw.println(doublePrefix + "mDisplayedBounds=" + this.mOverrideDisplayedBounds.toShortString());
        String triplePrefix = doublePrefix + "  ";
        String quadruplePrefix = triplePrefix + "  ";
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            AppWindowToken wtoken = (AppWindowToken)this.mChildren.get(i);
            pw.println(triplePrefix + "Activity #" + i + " " + wtoken);
            wtoken.dump(pw, quadruplePrefix, dumpAll);
        }
    }

    String toShortString() {
        return "Task=" + this.mTaskId;
    }
}

