/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.ITaskStackListener;
import android.app.TaskInfo;
import android.content.ComponentName;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStackSupervisor;
import java.util.ArrayList;

class TaskChangeNotificationController {
    private static final int LOG_STACK_STATE_MSG = 1;
    private static final int NOTIFY_TASK_STACK_CHANGE_LISTENERS_MSG = 2;
    private static final int NOTIFY_ACTIVITY_PINNED_LISTENERS_MSG = 3;
    private static final int NOTIFY_PINNED_ACTIVITY_RESTART_ATTEMPT_LISTENERS_MSG = 4;
    private static final int NOTIFY_PINNED_STACK_ANIMATION_ENDED_LISTENERS_MSG = 5;
    private static final int NOTIFY_FORCED_RESIZABLE_MSG = 6;
    private static final int NOTIFY_ACTIVITY_DISMISSING_DOCKED_STACK_MSG = 7;
    private static final int NOTIFY_TASK_ADDED_LISTENERS_MSG = 8;
    private static final int NOTIFY_TASK_REMOVED_LISTENERS_MSG = 9;
    private static final int NOTIFY_TASK_MOVED_TO_FRONT_LISTENERS_MSG = 10;
    private static final int NOTIFY_TASK_DESCRIPTION_CHANGED_LISTENERS_MSG = 11;
    private static final int NOTIFY_ACTIVITY_REQUESTED_ORIENTATION_CHANGED_LISTENERS = 12;
    private static final int NOTIFY_TASK_REMOVAL_STARTED_LISTENERS = 13;
    private static final int NOTIFY_TASK_PROFILE_LOCKED_LISTENERS_MSG = 14;
    private static final int NOTIFY_TASK_SNAPSHOT_CHANGED_LISTENERS_MSG = 15;
    private static final int NOTIFY_PINNED_STACK_ANIMATION_STARTED_LISTENERS_MSG = 16;
    private static final int NOTIFY_ACTIVITY_UNPINNED_LISTENERS_MSG = 17;
    private static final int NOTIFY_ACTIVITY_LAUNCH_ON_SECONDARY_DISPLAY_FAILED_MSG = 18;
    private static final int NOTIFY_ACTIVITY_LAUNCH_ON_SECONDARY_DISPLAY_REROUTED_MSG = 19;
    private static final int NOTIFY_SIZE_COMPAT_MODE_ACTIVITY_CHANGED_MSG = 20;
    private static final int NOTIFY_BACK_PRESSED_ON_TASK_ROOT = 21;
    private static final int NOTIFY_TASK_DISPLAY_CHANGED_LISTENERS_MSG = 22;
    private static final int NOTIFY_TASK_STACK_CHANGE_LISTENERS_DELAY = 100;
    private final Object mServiceLock;
    private final ActivityStackSupervisor mStackSupervisor;
    private final Handler mHandler;
    private final RemoteCallbackList<ITaskStackListener> mRemoteTaskStackListeners = new RemoteCallbackList();
    private final ArrayList<ITaskStackListener> mLocalTaskStackListeners = new ArrayList();
    private final TaskStackConsumer mNotifyTaskStackChanged = (l, m) -> l.onTaskStackChanged();
    private final TaskStackConsumer mNotifyTaskCreated = (l, m) -> l.onTaskCreated(m.arg1, (ComponentName)m.obj);
    private final TaskStackConsumer mNotifyTaskRemoved = (l, m) -> l.onTaskRemoved(m.arg1);
    private final TaskStackConsumer mNotifyTaskMovedToFront = (l, m) -> l.onTaskMovedToFront((ActivityManager.RunningTaskInfo)m.obj);
    private final TaskStackConsumer mNotifyTaskDescriptionChanged = (l, m) -> l.onTaskDescriptionChanged((ActivityManager.RunningTaskInfo)m.obj);
    private final TaskStackConsumer mNotifyBackPressedOnTaskRoot = (l, m) -> l.onBackPressedOnTaskRoot((ActivityManager.RunningTaskInfo)m.obj);
    private final TaskStackConsumer mNotifyActivityRequestedOrientationChanged = (l, m) -> l.onActivityRequestedOrientationChanged(m.arg1, m.arg2);
    private final TaskStackConsumer mNotifyTaskRemovalStarted = (l, m) -> l.onTaskRemovalStarted((ActivityManager.RunningTaskInfo)m.obj);
    private final TaskStackConsumer mNotifyActivityPinned = (l, m) -> l.onActivityPinned((String)m.obj, m.sendingUid, m.arg1, m.arg2);
    private final TaskStackConsumer mNotifyActivityUnpinned = (l, m) -> l.onActivityUnpinned();
    private final TaskStackConsumer mNotifyPinnedActivityRestartAttempt = (l, m) -> l.onPinnedActivityRestartAttempt(m.arg1 != 0);
    private final TaskStackConsumer mNotifyPinnedStackAnimationStarted = (l, m) -> l.onPinnedStackAnimationStarted();
    private final TaskStackConsumer mNotifyPinnedStackAnimationEnded = (l, m) -> l.onPinnedStackAnimationEnded();
    private final TaskStackConsumer mNotifyActivityForcedResizable = (l, m) -> l.onActivityForcedResizable((String)m.obj, m.arg1, m.arg2);
    private final TaskStackConsumer mNotifyActivityDismissingDockedStack = (l, m) -> l.onActivityDismissingDockedStack();
    private final TaskStackConsumer mNotifyActivityLaunchOnSecondaryDisplayFailed = (l, m) -> l.onActivityLaunchOnSecondaryDisplayFailed((ActivityManager.RunningTaskInfo)m.obj, m.arg1);
    private final TaskStackConsumer mNotifyActivityLaunchOnSecondaryDisplayRerouted = (l, m) -> l.onActivityLaunchOnSecondaryDisplayRerouted((ActivityManager.RunningTaskInfo)m.obj, m.arg1);
    private final TaskStackConsumer mNotifyTaskProfileLocked = (l, m) -> l.onTaskProfileLocked(m.arg1, m.arg2);
    private final TaskStackConsumer mNotifyTaskSnapshotChanged = (l, m) -> l.onTaskSnapshotChanged(m.arg1, (ActivityManager.TaskSnapshot)m.obj);
    private final TaskStackConsumer mOnSizeCompatModeActivityChanged = (l, m) -> l.onSizeCompatModeActivityChanged(m.arg1, (IBinder)m.obj);
    private final TaskStackConsumer mNotifyTaskDisplayChanged = (l, m) -> l.onTaskDisplayChanged(m.arg1, m.arg2);

    public TaskChangeNotificationController(Object serviceLock, ActivityStackSupervisor stackSupervisor, Handler handler) {
        this.mServiceLock = serviceLock;
        this.mStackSupervisor = stackSupervisor;
        this.mHandler = new MainHandler(handler.getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTaskStackListener(ITaskStackListener listener) {
        Object object = this.mServiceLock;
        synchronized (object) {
            if (listener != null) {
                if (Binder.getCallingPid() == Process.myPid()) {
                    if (!this.mLocalTaskStackListeners.contains(listener)) {
                        this.mLocalTaskStackListeners.add(listener);
                    }
                } else {
                    this.mRemoteTaskStackListeners.register(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTaskStackListener(ITaskStackListener listener) {
        Object object = this.mServiceLock;
        synchronized (object) {
            if (listener != null) {
                if (Binder.getCallingPid() == Process.myPid()) {
                    this.mLocalTaskStackListeners.remove(listener);
                } else {
                    this.mRemoteTaskStackListeners.unregister(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forAllRemoteListeners(TaskStackConsumer callback, Message message) {
        Object object = this.mServiceLock;
        synchronized (object) {
            for (int i = this.mRemoteTaskStackListeners.beginBroadcast() - 1; i >= 0; --i) {
                try {
                    callback.accept(this.mRemoteTaskStackListeners.getBroadcastItem(i), message);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mRemoteTaskStackListeners.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forAllLocalListeners(TaskStackConsumer callback, Message message) {
        Object object = this.mServiceLock;
        synchronized (object) {
            for (int i = this.mLocalTaskStackListeners.size() - 1; i >= 0; --i) {
                try {
                    callback.accept(this.mLocalTaskStackListeners.get(i), message);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    void notifyTaskStackChanged() {
        this.mHandler.sendEmptyMessage(1);
        this.mHandler.removeMessages(2);
        Message msg = this.mHandler.obtainMessage(2);
        this.forAllLocalListeners(this.mNotifyTaskStackChanged, msg);
        this.mHandler.sendMessageDelayed(msg, 100L);
    }

    void notifyActivityPinned(ActivityRecord r) {
        this.mHandler.removeMessages(3);
        Message msg = this.mHandler.obtainMessage(3, r.getTaskRecord().taskId, r.getStackId(), r.packageName);
        msg.sendingUid = r.mUserId;
        this.forAllLocalListeners(this.mNotifyActivityPinned, msg);
        msg.sendToTarget();
    }

    void notifyActivityUnpinned() {
        this.mHandler.removeMessages(17);
        Message msg = this.mHandler.obtainMessage(17);
        this.forAllLocalListeners(this.mNotifyActivityUnpinned, msg);
        msg.sendToTarget();
    }

    void notifyPinnedActivityRestartAttempt(boolean clearedTask) {
        this.mHandler.removeMessages(4);
        Message msg = this.mHandler.obtainMessage(4, clearedTask ? 1 : 0, 0);
        this.forAllLocalListeners(this.mNotifyPinnedActivityRestartAttempt, msg);
        msg.sendToTarget();
    }

    void notifyPinnedStackAnimationStarted() {
        this.mHandler.removeMessages(16);
        Message msg = this.mHandler.obtainMessage(16);
        this.forAllLocalListeners(this.mNotifyPinnedStackAnimationStarted, msg);
        msg.sendToTarget();
    }

    void notifyPinnedStackAnimationEnded() {
        this.mHandler.removeMessages(5);
        Message msg = this.mHandler.obtainMessage(5);
        this.forAllLocalListeners(this.mNotifyPinnedStackAnimationEnded, msg);
        msg.sendToTarget();
    }

    void notifyActivityDismissingDockedStack() {
        this.mHandler.removeMessages(7);
        Message msg = this.mHandler.obtainMessage(7);
        this.forAllLocalListeners(this.mNotifyActivityDismissingDockedStack, msg);
        msg.sendToTarget();
    }

    void notifyActivityForcedResizable(int taskId, int reason, String packageName) {
        this.mHandler.removeMessages(6);
        Message msg = this.mHandler.obtainMessage(6, taskId, reason, packageName);
        this.forAllLocalListeners(this.mNotifyActivityForcedResizable, msg);
        msg.sendToTarget();
    }

    void notifyActivityLaunchOnSecondaryDisplayFailed(TaskInfo ti, int requestedDisplayId) {
        this.mHandler.removeMessages(18);
        Message msg = this.mHandler.obtainMessage(18, requestedDisplayId, 0, ti);
        this.forAllLocalListeners(this.mNotifyActivityLaunchOnSecondaryDisplayFailed, msg);
        msg.sendToTarget();
    }

    void notifyActivityLaunchOnSecondaryDisplayRerouted(TaskInfo ti, int requestedDisplayId) {
        this.mHandler.removeMessages(19);
        Message msg = this.mHandler.obtainMessage(19, requestedDisplayId, 0, ti);
        this.forAllLocalListeners(this.mNotifyActivityLaunchOnSecondaryDisplayRerouted, msg);
        msg.sendToTarget();
    }

    void notifyTaskCreated(int taskId, ComponentName componentName) {
        Message msg = this.mHandler.obtainMessage(8, taskId, 0, componentName);
        this.forAllLocalListeners(this.mNotifyTaskCreated, msg);
        msg.sendToTarget();
    }

    void notifyTaskRemoved(int taskId) {
        Message msg = this.mHandler.obtainMessage(9, taskId, 0);
        this.forAllLocalListeners(this.mNotifyTaskRemoved, msg);
        msg.sendToTarget();
    }

    void notifyTaskMovedToFront(TaskInfo ti) {
        Message msg = this.mHandler.obtainMessage(10, ti);
        this.forAllLocalListeners(this.mNotifyTaskMovedToFront, msg);
        msg.sendToTarget();
    }

    void notifyTaskDescriptionChanged(TaskInfo taskInfo) {
        Message msg = this.mHandler.obtainMessage(11, taskInfo);
        this.forAllLocalListeners(this.mNotifyTaskDescriptionChanged, msg);
        msg.sendToTarget();
    }

    void notifyActivityRequestedOrientationChanged(int taskId, int orientation) {
        Message msg = this.mHandler.obtainMessage(12, taskId, orientation);
        this.forAllLocalListeners(this.mNotifyActivityRequestedOrientationChanged, msg);
        msg.sendToTarget();
    }

    void notifyTaskRemovalStarted(ActivityManager.RunningTaskInfo taskInfo) {
        Message msg = this.mHandler.obtainMessage(13, taskInfo);
        this.forAllLocalListeners(this.mNotifyTaskRemovalStarted, msg);
        msg.sendToTarget();
    }

    void notifyTaskProfileLocked(int taskId, int userId) {
        Message msg = this.mHandler.obtainMessage(14, taskId, userId);
        this.forAllLocalListeners(this.mNotifyTaskProfileLocked, msg);
        msg.sendToTarget();
    }

    void notifyTaskSnapshotChanged(int taskId, ActivityManager.TaskSnapshot snapshot) {
        Message msg = this.mHandler.obtainMessage(15, taskId, 0, snapshot);
        this.forAllLocalListeners(this.mNotifyTaskSnapshotChanged, msg);
        msg.sendToTarget();
    }

    void notifySizeCompatModeActivityChanged(int displayId, IBinder activityToken) {
        Message msg = this.mHandler.obtainMessage(20, displayId, 0, activityToken);
        this.forAllLocalListeners(this.mOnSizeCompatModeActivityChanged, msg);
        msg.sendToTarget();
    }

    void notifyBackPressedOnTaskRoot(TaskInfo taskInfo) {
        Message msg = this.mHandler.obtainMessage(21, taskInfo);
        this.forAllLocalListeners(this.mNotifyBackPressedOnTaskRoot, msg);
        msg.sendToTarget();
    }

    void notifyTaskDisplayChanged(int taskId, int newDisplayId) {
        Message msg = this.mHandler.obtainMessage(22, taskId, newDisplayId);
        this.forAllLocalListeners(this.mNotifyTaskStackChanged, msg);
        msg.sendToTarget();
    }

    private class MainHandler
    extends Handler {
        public MainHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Object object = TaskChangeNotificationController.this.mServiceLock;
                    synchronized (object) {
                        TaskChangeNotificationController.this.mStackSupervisor.logStackState();
                        break;
                    }
                }
                case 2: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskStackChanged, msg);
                    break;
                }
                case 8: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskCreated, msg);
                    break;
                }
                case 9: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskRemoved, msg);
                    break;
                }
                case 10: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskMovedToFront, msg);
                    break;
                }
                case 11: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskDescriptionChanged, msg);
                    break;
                }
                case 12: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityRequestedOrientationChanged, msg);
                    break;
                }
                case 13: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskRemovalStarted, msg);
                    break;
                }
                case 3: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityPinned, msg);
                    break;
                }
                case 17: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityUnpinned, msg);
                    break;
                }
                case 4: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyPinnedActivityRestartAttempt, msg);
                    break;
                }
                case 16: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyPinnedStackAnimationStarted, msg);
                    break;
                }
                case 5: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyPinnedStackAnimationEnded, msg);
                    break;
                }
                case 6: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityForcedResizable, msg);
                    break;
                }
                case 7: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityDismissingDockedStack, msg);
                    break;
                }
                case 18: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityLaunchOnSecondaryDisplayFailed, msg);
                    break;
                }
                case 19: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityLaunchOnSecondaryDisplayRerouted, msg);
                    break;
                }
                case 14: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskProfileLocked, msg);
                    break;
                }
                case 15: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskSnapshotChanged, msg);
                    break;
                }
                case 20: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mOnSizeCompatModeActivityChanged, msg);
                    break;
                }
                case 21: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyBackPressedOnTaskRoot, msg);
                    break;
                }
                case 22: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskDisplayChanged, msg);
                }
            }
        }
    }

    @FunctionalInterface
    public static interface TaskStackConsumer {
        public void accept(ITaskStackListener var1, Message var2) throws RemoteException;
    }
}

