/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityOptions;
import android.content.pm.ActivityInfo;
import android.graphics.Rect;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.ActivityDisplay;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityStackSupervisor;
import com.android.server.wm.LaunchParamsController;
import com.android.server.wm.TaskRecord;
import java.util.ArrayList;
import java.util.List;

class TaskLaunchParamsModifier
implements LaunchParamsController.LaunchParamsModifier {
    private static final String TAG = "ActivityTaskManager";
    private static final boolean DEBUG = false;
    private static final int SUPPORTS_SCREEN_RESIZEABLE_MASK = 539136;
    private static final int DEFAULT_PORTRAIT_PHONE_WIDTH_DP = 412;
    private static final int DEFAULT_PORTRAIT_PHONE_HEIGHT_DP = 732;
    private static final int EPSILON = 2;
    private static final int CASCADING_OFFSET_DP = 75;
    private static final int BOUNDS_CONFLICT_THRESHOLD = 4;
    private static final int STEP_DENOMINATOR = 16;
    private static final int MINIMAL_STEP = 1;
    private final ActivityStackSupervisor mSupervisor;
    private final Rect mTmpBounds = new Rect();
    private final int[] mTmpDirections = new int[2];
    private StringBuilder mLogBuilder;

    TaskLaunchParamsModifier(ActivityStackSupervisor supervisor) {
        this.mSupervisor = supervisor;
    }

    @VisibleForTesting
    int onCalculate(TaskRecord task, ActivityInfo.WindowLayout layout2, ActivityRecord activity, ActivityRecord source, ActivityOptions options, LaunchParamsController.LaunchParams currentParams, LaunchParamsController.LaunchParams outParams) {
        return this.onCalculate(task, layout2, activity, source, options, 2, currentParams, outParams);
    }

    @Override
    public int onCalculate(TaskRecord task, ActivityInfo.WindowLayout layout2, ActivityRecord activity, ActivityRecord source, ActivityOptions options, int phase, LaunchParamsController.LaunchParams currentParams, LaunchParamsController.LaunchParams outParams) {
        this.initLogBuilder(task, activity);
        int result = this.calculate(task, layout2, activity, source, options, phase, currentParams, outParams);
        this.outputLog();
        return result;
    }

    private int calculate(TaskRecord task, ActivityInfo.WindowLayout layout2, ActivityRecord activity, ActivityRecord source, ActivityOptions options, int phase, LaunchParamsController.LaunchParams currentParams, LaunchParamsController.LaunchParams outParams) {
        int resolvedMode;
        int displayId;
        ActivityRecord root = task != null ? (task.getRootActivity() == null ? activity : task.getRootActivity()) : activity;
        if (root == null) {
            return 0;
        }
        outParams.mPreferredDisplayId = displayId = this.getPreferredLaunchDisplay(task, options, source, currentParams);
        ActivityDisplay display = this.mSupervisor.mRootActivityContainer.getActivityDisplay(displayId);
        if (phase == 0) {
            return 2;
        }
        int launchMode = options != null ? options.getLaunchWindowingMode() : 0;
        boolean hasInitialBounds = false;
        boolean canApplyFreeformPolicy = this.canApplyFreeformWindowPolicy(display, launchMode);
        if (this.mSupervisor.canUseActivityOptionsLaunchBounds(options) && (canApplyFreeformPolicy || this.canApplyPipWindowPolicy(launchMode))) {
            hasInitialBounds = true;
            launchMode = launchMode == 0 ? 5 : launchMode;
            outParams.mBounds.set(options.getLaunchBounds());
        } else if (launchMode != 2 && launchMode != 1 && layout2 != null && canApplyFreeformPolicy) {
            this.getLayoutBounds(display, root, layout2, this.mTmpBounds);
            if (!this.mTmpBounds.isEmpty()) {
                launchMode = 5;
                outParams.mBounds.set(this.mTmpBounds);
                hasInitialBounds = true;
            }
        }
        boolean fullyResolvedCurrentParam = false;
        if (!(currentParams.isEmpty() || hasInitialBounds || currentParams.hasPreferredDisplay() && displayId != currentParams.mPreferredDisplayId)) {
            if (currentParams.hasWindowingMode()) {
                launchMode = currentParams.mWindowingMode;
                boolean bl = fullyResolvedCurrentParam = launchMode != 5;
            }
            if (!currentParams.mBounds.isEmpty()) {
                outParams.mBounds.set(currentParams.mBounds);
                if (launchMode == 5) {
                    fullyResolvedCurrentParam = true;
                }
            }
        }
        if (display.inFreeformWindowingMode() && launchMode != 2 && this.isTaskForcedMaximized(root)) {
            launchMode = 1;
            outParams.mBounds.setEmpty();
        }
        int n = outParams.mWindowingMode = launchMode == display.getWindowingMode() ? 0 : launchMode;
        if (phase == 1) {
            return 2;
        }
        int n2 = resolvedMode = launchMode != 0 ? launchMode : display.getWindowingMode();
        if (fullyResolvedCurrentParam) {
            if (resolvedMode == 5) {
                if (currentParams.mPreferredDisplayId != displayId) {
                    this.adjustBoundsToFitInDisplay(display, outParams.mBounds);
                }
                this.adjustBoundsToAvoidConflictInDisplay(display, outParams.mBounds);
            }
        } else {
            if (source != null && source.inFreeformWindowingMode() && resolvedMode == 5 && outParams.mBounds.isEmpty() && source.getDisplayId() == display.mDisplayId) {
                this.cascadeBounds(source.getBounds(), display, outParams.mBounds);
            }
            this.getTaskBounds(root, display, layout2, resolvedMode, hasInitialBounds, outParams.mBounds);
        }
        return 2;
    }

    private int getPreferredLaunchDisplay(TaskRecord task, ActivityOptions options, ActivityRecord source, LaunchParamsController.LaunchParams currentParams) {
        Object stack;
        int optionLaunchId;
        int displayId = -1;
        int n = optionLaunchId = options != null ? options.getLaunchDisplayId() : -1;
        if (optionLaunchId != -1) {
            displayId = optionLaunchId;
        }
        if (displayId == -1 && source != null && source.noDisplay) {
            displayId = source.mHandoverLaunchDisplayId;
        }
        Object v1 = stack = displayId == -1 && task != null ? task.getStack() : null;
        if (stack != null) {
            displayId = stack.mDisplayId;
        }
        if (displayId == -1 && source != null) {
            int sourceDisplayId;
            displayId = sourceDisplayId = source.getDisplayId();
        }
        if (displayId != -1 && this.mSupervisor.mRootActivityContainer.getActivityDisplay(displayId) == null) {
            displayId = currentParams.mPreferredDisplayId;
        }
        displayId = displayId == -1 ? currentParams.mPreferredDisplayId : displayId;
        return displayId != -1 && this.mSupervisor.mRootActivityContainer.getActivityDisplay(displayId) != null ? displayId : 0;
    }

    private boolean canApplyFreeformWindowPolicy(ActivityDisplay display, int launchMode) {
        return this.mSupervisor.mService.mSupportsFreeformWindowManagement && (display.inFreeformWindowingMode() || launchMode == 5);
    }

    private boolean canApplyPipWindowPolicy(int launchMode) {
        return this.mSupervisor.mService.mSupportsPictureInPicture && launchMode == 2;
    }

    private void getLayoutBounds(ActivityDisplay display, ActivityRecord root, ActivityInfo.WindowLayout windowLayout, Rect outBounds) {
        float fractionOfVerticalOffset;
        float fractionOfHorizontalOffset;
        int height;
        int width;
        int verticalGravity = windowLayout.gravity & 0x70;
        int horizontalGravity = windowLayout.gravity & 7;
        if (!windowLayout.hasSpecifiedSize() && verticalGravity == 0 && horizontalGravity == 0) {
            outBounds.setEmpty();
            return;
        }
        Rect bounds = display.getBounds();
        int defaultWidth = bounds.width();
        int defaultHeight = bounds.height();
        if (!windowLayout.hasSpecifiedSize()) {
            outBounds.setEmpty();
            this.getTaskBounds(root, display, windowLayout, 5, false, outBounds);
            width = outBounds.width();
            height = outBounds.height();
        } else {
            width = defaultWidth;
            if (windowLayout.width > 0 && windowLayout.width < defaultWidth) {
                width = windowLayout.width;
            } else if (windowLayout.widthFraction > 0.0f && windowLayout.widthFraction < 1.0f) {
                width = (int)((float)width * windowLayout.widthFraction);
            }
            height = defaultHeight;
            if (windowLayout.height > 0 && windowLayout.height < defaultHeight) {
                height = windowLayout.height;
            } else if (windowLayout.heightFraction > 0.0f && windowLayout.heightFraction < 1.0f) {
                height = (int)((float)height * windowLayout.heightFraction);
            }
        }
        switch (horizontalGravity) {
            case 3: {
                fractionOfHorizontalOffset = 0.0f;
                break;
            }
            case 5: {
                fractionOfHorizontalOffset = 1.0f;
                break;
            }
            default: {
                fractionOfHorizontalOffset = 0.5f;
            }
        }
        switch (verticalGravity) {
            case 48: {
                fractionOfVerticalOffset = 0.0f;
                break;
            }
            case 80: {
                fractionOfVerticalOffset = 1.0f;
                break;
            }
            default: {
                fractionOfVerticalOffset = 0.5f;
            }
        }
        outBounds.set(0, 0, width, height);
        int xOffset = (int)(fractionOfHorizontalOffset * (float)(defaultWidth - width));
        int yOffset = (int)(fractionOfVerticalOffset * (float)(defaultHeight - height));
        outBounds.offset(xOffset, yOffset);
    }

    private boolean isTaskForcedMaximized(ActivityRecord root) {
        if (root.appInfo.targetSdkVersion < 4 || (root.appInfo.flags & 0x83A00) == 0) {
            return true;
        }
        return !root.isResizeable();
    }

    private int resolveOrientation(ActivityRecord activity) {
        int orientation = activity.info.screenOrientation;
        switch (orientation) {
            case 5: 
            case 14: {
                orientation = 14;
                break;
            }
            case 0: 
            case 6: 
            case 8: 
            case 11: {
                orientation = 0;
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: {
                orientation = 1;
                break;
            }
            default: {
                orientation = -1;
            }
        }
        return orientation;
    }

    private void cascadeBounds(Rect srcBounds, ActivityDisplay display, Rect outBounds) {
        outBounds.set(srcBounds);
        float density = (float)display.getConfiguration().densityDpi / 160.0f;
        int defaultOffset = (int)(75.0f * density + 0.5f);
        display.getBounds(this.mTmpBounds);
        int dx = Math.min(defaultOffset, Math.max(0, this.mTmpBounds.right - srcBounds.right));
        int dy = Math.min(defaultOffset, Math.max(0, this.mTmpBounds.bottom - srcBounds.bottom));
        outBounds.offset(dx, dy);
    }

    private void getTaskBounds(ActivityRecord root, ActivityDisplay display, ActivityInfo.WindowLayout layout2, int resolvedMode, boolean hasInitialBounds, Rect inOutBounds) {
        if (resolvedMode == 1) {
            inOutBounds.setEmpty();
            return;
        }
        if (resolvedMode != 5) {
            return;
        }
        int orientation = this.resolveOrientation(root, display, inOutBounds);
        if (orientation != 1 && orientation != 0) {
            throw new IllegalStateException("Orientation must be one of portrait or landscape, but it's " + ActivityInfo.screenOrientationToString(orientation));
        }
        this.getDefaultFreeformSize(display, layout2, orientation, this.mTmpBounds);
        if (hasInitialBounds || TaskLaunchParamsModifier.sizeMatches(inOutBounds, this.mTmpBounds)) {
            if (orientation != TaskLaunchParamsModifier.orientationFromBounds(inOutBounds)) {
                this.centerBounds(display, inOutBounds.height(), inOutBounds.width(), inOutBounds);
            }
        } else {
            this.centerBounds(display, this.mTmpBounds.width(), this.mTmpBounds.height(), inOutBounds);
            this.adjustBoundsToFitInDisplay(display, inOutBounds);
        }
        this.adjustBoundsToAvoidConflictInDisplay(display, inOutBounds);
    }

    private int convertOrientationToScreenOrientation(int orientation) {
        switch (orientation) {
            case 2: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    private int resolveOrientation(ActivityRecord root, ActivityDisplay display, Rect bounds) {
        int orientation = this.resolveOrientation(root);
        if (orientation == 14) {
            int n = orientation = bounds.isEmpty() ? this.convertOrientationToScreenOrientation(display.getConfiguration().orientation) : TaskLaunchParamsModifier.orientationFromBounds(bounds);
        }
        if (orientation == -1) {
            orientation = bounds.isEmpty() ? 1 : TaskLaunchParamsModifier.orientationFromBounds(bounds);
        }
        return orientation;
    }

    private void getDefaultFreeformSize(ActivityDisplay display, ActivityInfo.WindowLayout layout2, int orientation, Rect bounds) {
        Rect displayBounds = display.getBounds();
        int portraitHeight = Math.min(displayBounds.width(), displayBounds.height());
        int otherDimension = Math.max(displayBounds.width(), displayBounds.height());
        int portraitWidth = portraitHeight * portraitHeight / otherDimension;
        int defaultWidth = orientation == 0 ? portraitHeight : portraitWidth;
        int defaultHeight = orientation == 0 ? portraitWidth : portraitHeight;
        float density = (float)display.getConfiguration().densityDpi / 160.0f;
        int phonePortraitWidth = (int)(412.0f * density + 0.5f);
        int phonePortraitHeight = (int)(732.0f * density + 0.5f);
        int phoneWidth = orientation == 0 ? phonePortraitHeight : phonePortraitWidth;
        int phoneHeight = orientation == 0 ? phonePortraitWidth : phonePortraitHeight;
        int layoutMinWidth = layout2 == null ? -1 : layout2.minWidth;
        int layoutMinHeight = layout2 == null ? -1 : layout2.minHeight;
        int width = Math.min(defaultWidth, Math.max(phoneWidth, layoutMinWidth));
        int height = Math.min(defaultHeight, Math.max(phoneHeight, layoutMinHeight));
        bounds.set(0, 0, width, height);
    }

    private void centerBounds(ActivityDisplay display, int width, int height, Rect inOutBounds) {
        if (inOutBounds.isEmpty()) {
            display.getBounds(inOutBounds);
        }
        int left = inOutBounds.centerX() - width / 2;
        int top = inOutBounds.centerY() - height / 2;
        inOutBounds.set(left, top, left + width, top + height);
    }

    private void adjustBoundsToFitInDisplay(ActivityDisplay display, Rect inOutBounds) {
        Rect displayBounds = display.getBounds();
        if (displayBounds.width() < inOutBounds.width() || displayBounds.height() < inOutBounds.height()) {
            int layoutDirection = this.mSupervisor.mRootActivityContainer.getConfiguration().getLayoutDirection();
            int left = layoutDirection == 1 ? displayBounds.width() - inOutBounds.width() : 0;
            inOutBounds.offsetTo(left, 0);
            return;
        }
        int dx = inOutBounds.right > displayBounds.right ? displayBounds.right - inOutBounds.right : (inOutBounds.left < displayBounds.left ? displayBounds.left - inOutBounds.left : 0);
        int dy = inOutBounds.top < displayBounds.top ? displayBounds.top - inOutBounds.top : (inOutBounds.bottom > displayBounds.bottom ? displayBounds.bottom - inOutBounds.bottom : 0);
        inOutBounds.offset(dx, dy);
    }

    private void adjustBoundsToAvoidConflictInDisplay(ActivityDisplay display, Rect inOutBounds) {
        ArrayList<Rect> taskBoundsToCheck = new ArrayList<Rect>();
        for (int i = 0; i < display.getChildCount(); ++i) {
            ActivityStack stack = display.getChildAt(i);
            if (!stack.inFreeformWindowingMode()) continue;
            for (int j = 0; j < stack.getChildCount(); ++j) {
                taskBoundsToCheck.add(stack.getChildAt(j).getBounds());
            }
        }
        this.adjustBoundsToAvoidConflict(display.getBounds(), taskBoundsToCheck, inOutBounds);
    }

    @VisibleForTesting
    void adjustBoundsToAvoidConflict(Rect displayBounds, List<Rect> taskBoundsToCheck, Rect inOutBounds) {
        if (!displayBounds.contains(inOutBounds)) {
            return;
        }
        if (!this.boundsConflict(taskBoundsToCheck, inOutBounds)) {
            return;
        }
        this.calculateCandidateShiftDirections(displayBounds, inOutBounds);
        for (int direction : this.mTmpDirections) {
            if (direction == 0) break;
            this.mTmpBounds.set(inOutBounds);
            while (this.boundsConflict(taskBoundsToCheck, this.mTmpBounds) && displayBounds.contains(this.mTmpBounds)) {
                this.shiftBounds(direction, displayBounds, this.mTmpBounds);
            }
            if (this.boundsConflict(taskBoundsToCheck, this.mTmpBounds) || !displayBounds.contains(this.mTmpBounds)) continue;
            inOutBounds.set(this.mTmpBounds);
            return;
        }
    }

    private void calculateCandidateShiftDirections(Rect availableBounds, Rect initialBounds) {
        for (int i = 0; i < this.mTmpDirections.length; ++i) {
            this.mTmpDirections[i] = 0;
        }
        int oneThirdWidth = (2 * availableBounds.left + availableBounds.right) / 3;
        int twoThirdWidth = (availableBounds.left + 2 * availableBounds.right) / 3;
        int centerX = initialBounds.centerX();
        if (centerX < oneThirdWidth) {
            this.mTmpDirections[0] = 5;
            return;
        }
        if (centerX > twoThirdWidth) {
            this.mTmpDirections[0] = 3;
            return;
        }
        int oneThirdHeight = (2 * availableBounds.top + availableBounds.bottom) / 3;
        int twoThirdHeight = (availableBounds.top + 2 * availableBounds.bottom) / 3;
        int centerY = initialBounds.centerY();
        if (centerY < oneThirdHeight || centerY > twoThirdHeight) {
            this.mTmpDirections[0] = 5;
            this.mTmpDirections[1] = 3;
            return;
        }
        this.mTmpDirections[0] = 85;
        this.mTmpDirections[1] = 51;
    }

    private boolean boundsConflict(List<Rect> taskBoundsToCheck, Rect candidateBounds) {
        for (Rect taskBounds : taskBoundsToCheck) {
            boolean bottomClose;
            boolean leftClose = Math.abs(taskBounds.left - candidateBounds.left) < 4;
            boolean topClose = Math.abs(taskBounds.top - candidateBounds.top) < 4;
            boolean rightClose = Math.abs(taskBounds.right - candidateBounds.right) < 4;
            boolean bl = bottomClose = Math.abs(taskBounds.bottom - candidateBounds.bottom) < 4;
            if (!(leftClose && topClose || leftClose && bottomClose || rightClose && topClose) && (!rightClose || !bottomClose)) continue;
            return true;
        }
        return false;
    }

    private void shiftBounds(int direction, Rect availableRect, Rect inOutBounds) {
        int verticalOffset;
        int horizontalOffset;
        switch (direction & 7) {
            case 3: {
                horizontalOffset = -Math.max(1, availableRect.width() / 16);
                break;
            }
            case 5: {
                horizontalOffset = Math.max(1, availableRect.width() / 16);
                break;
            }
            default: {
                horizontalOffset = 0;
            }
        }
        switch (direction & 0x70) {
            case 48: {
                verticalOffset = -Math.max(1, availableRect.height() / 16);
                break;
            }
            case 80: {
                verticalOffset = Math.max(1, availableRect.height() / 16);
                break;
            }
            default: {
                verticalOffset = 0;
            }
        }
        inOutBounds.offset(horizontalOffset, verticalOffset);
    }

    private void initLogBuilder(TaskRecord task, ActivityRecord activity) {
    }

    private void appendLog(String log) {
    }

    private void outputLog() {
    }

    private static int orientationFromBounds(Rect bounds) {
        return bounds.width() > bounds.height() ? 0 : 1;
    }

    private static boolean sizeMatches(Rect left, Rect right) {
        return Math.abs(right.width() - left.width()) < 2 && Math.abs(right.height() - left.height()) < 2;
    }
}

