/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.os.FileUtils;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.wm.ActivityStackSupervisor;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.PersisterQueue;
import com.android.server.wm.RecentTasks;
import com.android.server.wm.TaskRecord;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TaskPersister
implements PersisterQueue.Listener {
    static final String TAG = "TaskPersister";
    static final boolean DEBUG = false;
    static final String IMAGE_EXTENSION = ".png";
    private static final String TASKS_DIRNAME = "recent_tasks";
    private static final String TASK_FILENAME_SUFFIX = "_task.xml";
    private static final String IMAGES_DIRNAME = "recent_images";
    private static final String PERSISTED_TASK_IDS_FILENAME = "persisted_taskIds.txt";
    private static final String TAG_TASK = "task";
    private final ActivityTaskManagerService mService;
    private final ActivityStackSupervisor mStackSupervisor;
    private final RecentTasks mRecentTasks;
    private final SparseArray<SparseBooleanArray> mTaskIdsInFile = new SparseArray();
    private final File mTaskIdsDir;
    private final Object mIoLock = new Object();
    private final PersisterQueue mPersisterQueue;
    private final ArraySet<Integer> mTmpTaskIds = new ArraySet();

    TaskPersister(File systemDir, ActivityStackSupervisor stackSupervisor, ActivityTaskManagerService service, RecentTasks recentTasks, PersisterQueue persisterQueue) {
        File legacyTasksDir;
        File legacyImagesDir = new File(systemDir, IMAGES_DIRNAME);
        if (!(!legacyImagesDir.exists() || FileUtils.deleteContents(legacyImagesDir) && legacyImagesDir.delete())) {
            Slog.i(TAG, "Failure deleting legacy images directory: " + legacyImagesDir);
        }
        if (!(!(legacyTasksDir = new File(systemDir, TASKS_DIRNAME)).exists() || FileUtils.deleteContents(legacyTasksDir) && legacyTasksDir.delete())) {
            Slog.i(TAG, "Failure deleting legacy tasks directory: " + legacyTasksDir);
        }
        this.mTaskIdsDir = new File(Environment.getDataDirectory(), "system_de");
        this.mStackSupervisor = stackSupervisor;
        this.mService = service;
        this.mRecentTasks = recentTasks;
        this.mPersisterQueue = persisterQueue;
        this.mPersisterQueue.addListener(this);
    }

    @VisibleForTesting
    TaskPersister(File workingDir) {
        this.mTaskIdsDir = workingDir;
        this.mStackSupervisor = null;
        this.mService = null;
        this.mRecentTasks = null;
        this.mPersisterQueue = new PersisterQueue();
        this.mPersisterQueue.addListener(this);
    }

    private void removeThumbnails(TaskRecord task) {
        this.mPersisterQueue.removeItems(item -> {
            File file = new File(item.mFilePath);
            return file.getName().startsWith(Integer.toString(task.taskId));
        }, ImageWriteQueueItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    SparseBooleanArray loadPersistedTaskIdsForUser(int userId) {
        if (this.mTaskIdsInFile.get(userId) != null) {
            return this.mTaskIdsInFile.get(userId).clone();
        }
        SparseBooleanArray persistedTaskIds = new SparseBooleanArray();
        Object object = this.mIoLock;
        synchronized (object) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(this.getUserPersistedTaskIdsFile(userId)));
                while ((line = reader.readLine()) != null) {
                    for (String taskIdString : line.split("\\s+")) {
                        int id2 = Integer.parseInt(taskIdString);
                        persistedTaskIds.put(id2, true);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                IoUtils.closeQuietly(reader);
            }
            catch (Exception e) {
                Slog.e(TAG, "Error while reading taskIds file for user " + userId, e);
                {
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(reader);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly(reader);
            }
            IoUtils.closeQuietly(reader);
        }
        this.mTaskIdsInFile.put(userId, persistedTaskIds);
        return persistedTaskIds.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void writePersistedTaskIdsForUser(SparseBooleanArray taskIds, int userId) {
        if (userId < 0) {
            return;
        }
        File persistedTaskIdsFile = this.getUserPersistedTaskIdsFile(userId);
        Object object = this.mIoLock;
        synchronized (object) {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(persistedTaskIdsFile));
                for (int i = 0; i < taskIds.size(); ++i) {
                    if (!taskIds.valueAt(i)) continue;
                    writer.write(String.valueOf(taskIds.keyAt(i)));
                    writer.newLine();
                }
            }
            catch (Exception e) {
                try {
                    Slog.e(TAG, "Error while writing taskIds file for user " + userId, e);
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(writer);
                    throw throwable;
                }
                IoUtils.closeQuietly(writer);
            }
            IoUtils.closeQuietly(writer);
        }
    }

    void unloadUserDataFromMemory(int userId) {
        this.mTaskIdsInFile.delete(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeup(TaskRecord task, boolean flush) {
        PersisterQueue persisterQueue = this.mPersisterQueue;
        synchronized (persisterQueue) {
            if (task != null) {
                TaskWriteQueueItem item = this.mPersisterQueue.findLastItem(queueItem -> task == ((TaskWriteQueueItem)queueItem).mTask, TaskWriteQueueItem.class);
                if (item != null && !task.inRecents) {
                    this.removeThumbnails(task);
                }
                if (item == null && task.isPersistable) {
                    this.mPersisterQueue.addItem(new TaskWriteQueueItem(task, this.mService), flush);
                }
            } else {
                this.mPersisterQueue.addItem(PersisterQueue.EMPTY_ITEM, flush);
            }
        }
        this.mPersisterQueue.yieldIfQueueTooDeep();
    }

    void flush() {
        this.mPersisterQueue.flush();
    }

    void saveImage(Bitmap image, String filePath) {
        this.mPersisterQueue.updateLastOrAddItem(new ImageWriteQueueItem(filePath, image), false);
    }

    Bitmap getTaskDescriptionIcon(String filePath) {
        Bitmap icon = this.getImageFromWriteQueue(filePath);
        if (icon != null) {
            return icon;
        }
        return TaskPersister.restoreImage(filePath);
    }

    private Bitmap getImageFromWriteQueue(String filePath) {
        ImageWriteQueueItem item = this.mPersisterQueue.findLastItem(queueItem -> queueItem.mFilePath.equals(filePath), ImageWriteQueueItem.class);
        return item != null ? item.mImage : null;
    }

    private String fileToString(File file) {
        String newline = System.lineSeparator();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuffer sb = new StringBuffer((int)file.length() * 2);
            while ((line = reader.readLine()) != null) {
                sb.append(line + newline);
            }
            reader.close();
            return sb.toString();
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Couldn't read file " + file.getName());
            return null;
        }
    }

    private TaskRecord taskIdToTask(int taskId, ArrayList<TaskRecord> tasks) {
        if (taskId < 0) {
            return null;
        }
        for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = tasks.get(taskNdx);
            if (task.taskId != taskId) continue;
            return task;
        }
        Slog.e(TAG, "Restore affiliation error looking for taskId=" + taskId);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TaskRecord> restoreTasksForUserLocked(int userId, SparseBooleanArray preaddedTasks) {
        int taskNdx;
        ArrayList<TaskRecord> tasks = new ArrayList<TaskRecord>();
        ArraySet<Integer> recoveredTaskIds = new ArraySet<Integer>();
        File userTasksDir = TaskPersister.getUserTasksDir(userId);
        File[] recentFiles = userTasksDir.listFiles();
        if (recentFiles == null) {
            Slog.e(TAG, "restoreTasksForUserLocked: Unable to list files from " + userTasksDir);
            return tasks;
        }
        for (taskNdx = 0; taskNdx < recentFiles.length; ++taskNdx) {
            File taskFile;
            block21: {
                taskFile = recentFiles[taskNdx];
                if (!taskFile.getName().endsWith(TASK_FILENAME_SUFFIX)) continue;
                try {
                    int taskId = Integer.parseInt(taskFile.getName().substring(0, taskFile.getName().length() - TASK_FILENAME_SUFFIX.length()));
                    if (preaddedTasks.get(taskId, false)) {
                        Slog.w(TAG, "Task #" + taskId + " has already been created so we don't restore again");
                    }
                    break block21;
                }
                catch (NumberFormatException e) {
                    Slog.w(TAG, "Unexpected task file name", e);
                }
                continue;
            }
            BufferedReader reader = null;
            boolean deleteFile = false;
            try {
                int event;
                reader = new BufferedReader(new FileReader(taskFile));
                XmlPullParser in = Xml.newPullParser();
                in.setInput(reader);
                while ((event = in.next()) != 1 && event != 3) {
                    String name = in.getName();
                    if (event == 2) {
                        if (TAG_TASK.equals(name)) {
                            TaskRecord task = TaskRecord.restoreFromXml(in, this.mStackSupervisor);
                            if (task != null) {
                                int taskId = task.taskId;
                                if (this.mService.mRootActivityContainer.anyTaskForId(taskId, 1) != null) {
                                    Slog.wtf(TAG, "Existing task with taskId " + taskId + "found");
                                } else if (userId != task.userId) {
                                    Slog.wtf(TAG, "Task with userId " + task.userId + " found in " + userTasksDir.getAbsolutePath());
                                } else {
                                    this.mStackSupervisor.setNextTaskIdForUserLocked(taskId, userId);
                                    task.isPersistable = true;
                                    tasks.add(task);
                                    recoveredTaskIds.add(taskId);
                                }
                            } else {
                                Slog.e(TAG, "restoreTasksForUserLocked: Unable to restore taskFile=" + taskFile + ": " + this.fileToString(taskFile));
                            }
                        } else {
                            Slog.wtf(TAG, "restoreTasksForUserLocked: Unknown xml event=" + event + " name=" + name);
                        }
                    }
                    XmlUtils.skipCurrentTag(in);
                }
            }
            catch (Exception e) {
                try {
                    Slog.wtf(TAG, "Unable to parse " + taskFile + ". Error ", e);
                    Slog.e(TAG, "Failing file: " + this.fileToString(taskFile));
                    deleteFile = true;
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(reader);
                    if (deleteFile) {
                        taskFile.delete();
                    }
                    throw throwable;
                }
                IoUtils.closeQuietly(reader);
                if (!deleteFile) continue;
                taskFile.delete();
                continue;
            }
            IoUtils.closeQuietly(reader);
            if (!deleteFile) continue;
            taskFile.delete();
            continue;
        }
        TaskPersister.removeObsoleteFiles(recoveredTaskIds, userTasksDir.listFiles());
        for (taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = tasks.get(taskNdx);
            task.setPrevAffiliate(this.taskIdToTask(task.mPrevAffiliateTaskId, tasks));
            task.setNextAffiliate(this.taskIdToTask(task.mNextAffiliateTaskId, tasks));
        }
        Collections.sort(tasks, new Comparator<TaskRecord>(){

            @Override
            public int compare(TaskRecord lhs, TaskRecord rhs) {
                long diff = rhs.mLastTimeMoved - lhs.mLastTimeMoved;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                return 0;
            }
        });
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPreProcessItem(boolean queueEmpty) {
        block3: {
            if (!queueEmpty) break block3;
            this.mTmpTaskIds.clear();
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            synchronized (windowManagerGlobalLock) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    this.mRecentTasks.getPersistableTaskIds(this.mTmpTaskIds);
                    this.mService.mWindowManager.removeObsoleteTaskFiles(this.mTmpTaskIds, this.mRecentTasks.usersWithRecentsLoadedLocked());
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            this.removeObsoleteFiles(this.mTmpTaskIds);
        }
        this.writeTaskIdsFiles();
    }

    private static void removeObsoleteFiles(ArraySet<Integer> persistentTaskIds, File[] files) {
        if (files == null) {
            Slog.e(TAG, "File error accessing recents directory (directory doesn't exist?).");
            return;
        }
        for (int fileNdx = 0; fileNdx < files.length; ++fileNdx) {
            int taskId;
            File file = files[fileNdx];
            String filename = file.getName();
            int taskIdEnd = filename.indexOf(95);
            if (taskIdEnd <= 0) continue;
            try {
                taskId = Integer.parseInt(filename.substring(0, taskIdEnd));
            }
            catch (Exception e) {
                Slog.wtf(TAG, "removeObsoleteFiles: Can't parse file=" + file.getName());
                file.delete();
                continue;
            }
            if (persistentTaskIds.contains(taskId)) continue;
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTaskIdsFiles() {
        SparseArray<SparseBooleanArray> changedTaskIdsPerUser = new SparseArray<SparseBooleanArray>();
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                for (int userId : this.mRecentTasks.usersWithRecentsLoadedLocked()) {
                    SparseBooleanArray taskIdsToSave = this.mRecentTasks.getTaskIdsForUser(userId);
                    SparseBooleanArray persistedIdsInFile = this.mTaskIdsInFile.get(userId);
                    if (persistedIdsInFile != null && persistedIdsInFile.equals(taskIdsToSave)) continue;
                    SparseBooleanArray taskIdsToSaveCopy = taskIdsToSave.clone();
                    this.mTaskIdsInFile.put(userId, taskIdsToSaveCopy);
                    changedTaskIdsPerUser.put(userId, taskIdsToSaveCopy);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl20 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        for (int i = 0; i < changedTaskIdsPerUser.size(); ++i) {
            this.writePersistedTaskIdsForUser((SparseBooleanArray)changedTaskIdsPerUser.valueAt(i), changedTaskIdsPerUser.keyAt(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeObsoleteFiles(ArraySet<Integer> persistentTaskIds) {
        int[] candidateUserIds;
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                candidateUserIds = this.mRecentTasks.usersWithRecentsLoadedLocked();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        for (Object userId : (WindowManagerGlobalLock)candidateUserIds) {
            TaskPersister.removeObsoleteFiles(persistentTaskIds, TaskPersister.getUserImagesDir((int)userId).listFiles());
            TaskPersister.removeObsoleteFiles(persistentTaskIds, TaskPersister.getUserTasksDir((int)userId).listFiles());
        }
    }

    static Bitmap restoreImage(String filename) {
        return BitmapFactory.decodeFile(filename);
    }

    private File getUserPersistedTaskIdsFile(int userId) {
        File userTaskIdsDir = new File(this.mTaskIdsDir, String.valueOf(userId));
        if (!userTaskIdsDir.exists() && !userTaskIdsDir.mkdirs()) {
            Slog.e(TAG, "Error while creating user directory: " + userTaskIdsDir);
        }
        return new File(userTaskIdsDir, PERSISTED_TASK_IDS_FILENAME);
    }

    private static File getUserTasksDir(int userId) {
        return new File(Environment.getDataSystemCeDirectory(userId), TASKS_DIRNAME);
    }

    static File getUserImagesDir(int userId) {
        return new File(Environment.getDataSystemCeDirectory(userId), IMAGES_DIRNAME);
    }

    private static boolean createParentDirectory(String filePath) {
        File parentDir = new File(filePath).getParentFile();
        return parentDir.exists() || parentDir.mkdirs();
    }

    private static class ImageWriteQueueItem
    implements PersisterQueue.WriteQueueItem<ImageWriteQueueItem> {
        final String mFilePath;
        Bitmap mImage;

        ImageWriteQueueItem(String filePath, Bitmap image) {
            this.mFilePath = filePath;
            this.mImage = image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process() {
            String filePath = this.mFilePath;
            if (!TaskPersister.createParentDirectory(filePath)) {
                Slog.e(TaskPersister.TAG, "Error while creating images directory for file: " + filePath);
                return;
            }
            Bitmap bitmap = this.mImage;
            FileOutputStream imageFile = null;
            try {
                imageFile = new FileOutputStream(new File(filePath));
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, imageFile);
            }
            catch (Exception e) {
                try {
                    Slog.e(TaskPersister.TAG, "saveImage: unable to save " + filePath, e);
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(imageFile);
                    throw throwable;
                }
                IoUtils.closeQuietly(imageFile);
            }
            IoUtils.closeQuietly(imageFile);
        }

        @Override
        public boolean matches(ImageWriteQueueItem item) {
            return this.mFilePath.equals(item.mFilePath);
        }

        @Override
        public void updateFrom(ImageWriteQueueItem item) {
            this.mImage = item.mImage;
        }

        public String toString() {
            return "ImageWriteQueueItem{path=" + this.mFilePath + ", image=(" + this.mImage.getWidth() + "x" + this.mImage.getHeight() + ")}";
        }
    }

    private static class TaskWriteQueueItem
    implements PersisterQueue.WriteQueueItem {
        private final ActivityTaskManagerService mService;
        private final TaskRecord mTask;

        TaskWriteQueueItem(TaskRecord task, ActivityTaskManagerService service) {
            this.mTask = task;
            this.mService = service;
        }

        private StringWriter saveToXml(TaskRecord task) throws IOException, XmlPullParserException {
            FastXmlSerializer xmlSerializer = new FastXmlSerializer();
            StringWriter stringWriter = new StringWriter();
            xmlSerializer.setOutput(stringWriter);
            xmlSerializer.startDocument(null, true);
            xmlSerializer.startTag(null, TaskPersister.TAG_TASK);
            task.saveToXml(xmlSerializer);
            xmlSerializer.endTag(null, TaskPersister.TAG_TASK);
            xmlSerializer.endDocument();
            xmlSerializer.flush();
            return stringWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process() {
            StringWriter stringWriter = null;
            TaskRecord task = this.mTask;
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            synchronized (windowManagerGlobalLock) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (task.inRecents) {
                        try {
                            stringWriter = this.saveToXml(task);
                        }
                        catch (IOException iOException) {
                        }
                        catch (XmlPullParserException xmlPullParserException) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[3, 6] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            if (stringWriter != null) {
                FileOutputStream file = null;
                AtomicFile atomicFile = null;
                try {
                    File userTasksDir = TaskPersister.getUserTasksDir(task.userId);
                    if (!userTasksDir.isDirectory() && !userTasksDir.mkdirs()) {
                        Slog.e(TaskPersister.TAG, "Failure creating tasks directory for user " + task.userId + ": " + userTasksDir + " Dropping persistence for task " + task);
                        return;
                    }
                    atomicFile = new AtomicFile(new File(userTasksDir, String.valueOf(task.taskId) + TaskPersister.TASK_FILENAME_SUFFIX));
                    file = atomicFile.startWrite();
                    file.write(stringWriter.toString().getBytes());
                    file.write(10);
                    atomicFile.finishWrite(file);
                }
                catch (IOException e) {
                    if (file != null) {
                        atomicFile.failWrite(file);
                    }
                    Slog.e(TaskPersister.TAG, "Unable to open " + atomicFile + " for persisting. " + e);
                }
            }
        }

        public String toString() {
            return "TaskWriteQueueItem{task=" + this.mTask + "}";
        }
    }
}

