/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.IActivityTaskManager;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Slog;
import android.view.Display;
import android.view.IWindow;
import android.view.InputWindowHandle;
import android.view.SurfaceControl;
import com.android.internal.annotations.GuardedBy;
import com.android.server.input.InputManagerService;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.Task;
import com.android.server.wm.TaskPositioner;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;

class TaskPositioningController {
    private final WindowManagerService mService;
    private final InputManagerService mInputManager;
    private final IActivityTaskManager mActivityManager;
    private final Handler mHandler;
    private SurfaceControl mInputSurface;
    private DisplayContent mPositioningDisplay;
    @GuardedBy(value={"WindowManagerSerivce.mWindowMap"})
    private TaskPositioner mTaskPositioner;
    private final Rect mTmpClipRect = new Rect();
    private IBinder mTransferTouchFromToken;

    boolean isPositioningLocked() {
        return this.mTaskPositioner != null;
    }

    InputWindowHandle getDragWindowHandleLocked() {
        return this.mTaskPositioner != null ? this.mTaskPositioner.mDragWindowHandle : null;
    }

    TaskPositioningController(WindowManagerService service, InputManagerService inputManager, IActivityTaskManager activityManager, Looper looper) {
        this.mService = service;
        this.mInputManager = inputManager;
        this.mActivityManager = activityManager;
        this.mHandler = new Handler(looper);
    }

    void hideInputSurface(SurfaceControl.Transaction t, int displayId) {
        if (this.mPositioningDisplay != null && this.mPositioningDisplay.getDisplayId() == displayId && this.mInputSurface != null) {
            t.hide(this.mInputSurface);
        }
    }

    void showInputSurface(SurfaceControl.Transaction t, int displayId) {
        InputWindowHandle h;
        if (this.mPositioningDisplay == null || this.mPositioningDisplay.getDisplayId() != displayId) {
            return;
        }
        DisplayContent dc = this.mService.mRoot.getDisplayContent(displayId);
        if (this.mInputSurface == null) {
            this.mInputSurface = this.mService.makeSurfaceBuilder(dc.getSession()).setContainerLayer().setName("Drag and Drop Input Consumer").build();
        }
        if ((h = this.getDragWindowHandleLocked()) == null) {
            Slog.w("WindowManager", "Drag is in progress but there is no drag window handle.");
            return;
        }
        t.show(this.mInputSurface);
        t.setInputWindowInfo(this.mInputSurface, h);
        t.setLayer(this.mInputSurface, Integer.MAX_VALUE);
        Display display = dc.getDisplay();
        Point p = new Point();
        display.getRealSize(p);
        this.mTmpClipRect.set(0, 0, p.x, p.y);
        t.setWindowCrop(this.mInputSurface, this.mTmpClipRect);
        t.transferTouchFocus(this.mTransferTouchFromToken, h.token);
        this.mTransferTouchFromToken = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean startMovingTask(IWindow window, float startX, float startY) {
        win = null;
        var5_5 = this.mService.mGlobalLock;
        synchronized (var5_5) {
            WindowManagerService.boostPriorityForLockedSection();
            win = this.mService.windowForClientLocked(null, window, false);
            if (this.startPositioningLocked(win, false, false, startX, startY)) ** break block6
            v0 = false;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v0;
        {
            try {}
            catch (Throwable var6_7) {
                // MONITOREXIT @DISABLED, blocks:[3, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var5_5
                WindowManagerService.resetPriorityAfterLockedSection();
                throw var6_7;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        try {
            this.mActivityManager.setFocusedTask(win.getTask().mTaskId);
        }
        catch (RemoteException var5_6) {
            // empty catch block
        }
        return true;
    }

    void handleTapOutsideTask(DisplayContent displayContent, int x, int y) {
        this.mHandler.post(() -> {
            block6: {
                Task task;
                block7: {
                    WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
                    // MONITORENTER : windowManagerGlobalLock
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        task = displayContent.findTaskForResizePoint(x, y);
                        if (task == null) break block6;
                        if (this.startPositioningLocked(task.getTopVisibleAppMainWindow(), true, task.preserveOrientationOnResize(), x, y)) break block7;
                        // MONITOREXIT : windowManagerGlobalLock
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : windowManagerGlobalLock
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                try {
                    this.mActivityManager.setFocusedTask(task.mTaskId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        });
    }

    private boolean startPositioningLocked(WindowState win, boolean resize, boolean preserveOrientation, float startX, float startY) {
        if (win == null || win.getAppToken() == null) {
            Slog.w("WindowManager", "startPositioningLocked: Bad window " + win);
            return false;
        }
        if (win.mInputChannel == null) {
            Slog.wtf("WindowManager", "startPositioningLocked: " + win + " has no input channel,  probably being removed");
            return false;
        }
        DisplayContent displayContent = win.getDisplayContent();
        if (displayContent == null) {
            Slog.w("WindowManager", "startPositioningLocked: Invalid display content " + win);
            return false;
        }
        this.mPositioningDisplay = displayContent;
        this.mTaskPositioner = TaskPositioner.create(this.mService);
        WindowState transferFocusFromWin = win;
        if (displayContent.mCurrentFocus != null && displayContent.mCurrentFocus != win && displayContent.mCurrentFocus.mAppToken == win.mAppToken) {
            transferFocusFromWin = displayContent.mCurrentFocus;
        }
        this.mTransferTouchFromToken = transferFocusFromWin.mInputChannel.getToken();
        this.mTaskPositioner.register(displayContent);
        this.mTaskPositioner.startDrag(win, resize, preserveOrientation, startX, startY);
        return true;
    }

    public void finishTaskPositioning(IWindow window) {
        if (this.mTaskPositioner != null && this.mTaskPositioner.mClientCallback == window.asBinder()) {
            this.finishTaskPositioning();
        }
    }

    void finishTaskPositioning() {
        this.mHandler.post(() -> {
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            synchronized (windowManagerGlobalLock) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    this.cleanUpTaskPositioner();
                    this.mPositioningDisplay = null;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        });
    }

    private void cleanUpTaskPositioner() {
        TaskPositioner positioner = this.mTaskPositioner;
        if (positioner == null) {
            return;
        }
        this.mTaskPositioner = null;
        positioner.unregister();
    }
}

