/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.ActivityTaskManager;
import android.app.AppGlobals;
import android.app.TaskInfo;
import android.app.WindowConfiguration;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.voice.IVoiceInteractionSession;
import android.util.EventLog;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.DisplayInfo;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.util.XmlUtils;
import com.android.server.wm.ActivityDisplay;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityStackSupervisor;
import com.android.server.wm.ActivityStarter;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplayPolicy;
import com.android.server.wm.LockTaskController;
import com.android.server.wm.RootActivityContainer;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowProcessController;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class TaskRecord
extends ConfigurationContainer {
    private static final String TAG = "ActivityTaskManager";
    private static final String TAG_ADD_REMOVE = "ActivityTaskManager";
    private static final String TAG_RECENTS = "ActivityTaskManager";
    private static final String TAG_LOCKTASK = "ActivityTaskManager";
    private static final String TAG_TASKS = "ActivityTaskManager";
    private static final String ATTR_TASKID = "task_id";
    private static final String TAG_INTENT = "intent";
    private static final String TAG_AFFINITYINTENT = "affinity_intent";
    private static final String ATTR_REALACTIVITY = "real_activity";
    private static final String ATTR_REALACTIVITY_SUSPENDED = "real_activity_suspended";
    private static final String ATTR_ORIGACTIVITY = "orig_activity";
    private static final String TAG_ACTIVITY = "activity";
    private static final String ATTR_AFFINITY = "affinity";
    private static final String ATTR_ROOT_AFFINITY = "root_affinity";
    private static final String ATTR_ROOTHASRESET = "root_has_reset";
    private static final String ATTR_AUTOREMOVERECENTS = "auto_remove_recents";
    private static final String ATTR_ASKEDCOMPATMODE = "asked_compat_mode";
    private static final String ATTR_USERID = "user_id";
    private static final String ATTR_USER_SETUP_COMPLETE = "user_setup_complete";
    private static final String ATTR_EFFECTIVE_UID = "effective_uid";
    @Deprecated
    private static final String ATTR_TASKTYPE = "task_type";
    private static final String ATTR_LASTDESCRIPTION = "last_description";
    private static final String ATTR_LASTTIMEMOVED = "last_time_moved";
    private static final String ATTR_NEVERRELINQUISH = "never_relinquish_identity";
    private static final String ATTR_TASK_AFFILIATION = "task_affiliation";
    private static final String ATTR_PREV_AFFILIATION = "prev_affiliation";
    private static final String ATTR_NEXT_AFFILIATION = "next_affiliation";
    private static final String ATTR_TASK_AFFILIATION_COLOR = "task_affiliation_color";
    private static final String ATTR_CALLING_UID = "calling_uid";
    private static final String ATTR_CALLING_PACKAGE = "calling_package";
    private static final String ATTR_SUPPORTS_PICTURE_IN_PICTURE = "supports_picture_in_picture";
    private static final String ATTR_RESIZE_MODE = "resize_mode";
    private static final String ATTR_NON_FULLSCREEN_BOUNDS = "non_fullscreen_bounds";
    private static final String ATTR_MIN_WIDTH = "min_width";
    private static final String ATTR_MIN_HEIGHT = "min_height";
    private static final String ATTR_PERSIST_TASK_VERSION = "persist_task_version";
    private static final int PERSIST_TASK_VERSION = 1;
    private static final int INVALID_MIN_SIZE = -1;
    static final int REPARENT_MOVE_STACK_TO_FRONT = 0;
    static final int REPARENT_KEEP_STACK_AT_FRONT = 1;
    static final int REPARENT_LEAVE_STACK_IN_PLACE = 2;
    private static TaskRecordFactory sTaskRecordFactory;
    final int taskId;
    String affinity;
    String rootAffinity;
    final IVoiceInteractionSession voiceSession;
    final IVoiceInteractor voiceInteractor;
    Intent intent;
    Intent affinityIntent;
    int effectiveUid;
    ComponentName origActivity;
    ComponentName realActivity;
    boolean realActivitySuspended;
    boolean inRecents;
    long lastActiveTime;
    boolean isAvailable;
    boolean rootWasReset;
    boolean autoRemoveRecents;
    boolean askedCompatMode;
    boolean hasBeenVisible;
    String stringName;
    int userId;
    boolean mUserSetupComplete;
    int numFullscreen;
    int mResizeMode;
    private boolean mSupportsPictureInPicture;
    static final int LOCK_TASK_AUTH_DONT_LOCK = 0;
    static final int LOCK_TASK_AUTH_PINNABLE = 1;
    static final int LOCK_TASK_AUTH_LAUNCHABLE = 2;
    static final int LOCK_TASK_AUTH_WHITELISTED = 3;
    static final int LOCK_TASK_AUTH_LAUNCHABLE_PRIV = 4;
    int mLockTaskAuth = 1;
    int mLockTaskUid = -1;
    ActivityManager.TaskDescription lastTaskDescription = new ActivityManager.TaskDescription();
    final ArrayList<ActivityRecord> mActivities;
    private ActivityStack mStack;
    private WindowProcessController mRootProcess;
    boolean isPersistable = false;
    int maxRecents;
    long mLastTimeMoved = System.currentTimeMillis();
    private boolean mNeverRelinquishIdentity = true;
    private boolean mReuseTask = false;
    CharSequence lastDescription;
    int mAffiliatedTaskId;
    int mAffiliatedTaskColor;
    TaskRecord mPrevAffiliate;
    int mPrevAffiliateTaskId = -1;
    TaskRecord mNextAffiliate;
    int mNextAffiliateTaskId = -1;
    int mCallingUid;
    String mCallingPackage;
    final ActivityTaskManagerService mService;
    private final Rect mTmpStableBounds = new Rect();
    private final Rect mTmpNonDecorBounds = new Rect();
    private final Rect mTmpBounds = new Rect();
    private final Rect mTmpInsets = new Rect();
    Rect mLastNonFullscreenBounds = null;
    int mMinWidth;
    int mMinHeight;
    int mLayerRank = -1;
    final Rect mDisplayedBounds = new Rect();
    private Configuration mTmpConfig = new Configuration();
    Task mTask;
    final TaskActivitiesReport mReuseActivitiesReport = new TaskActivitiesReport();

    TaskRecord(ActivityTaskManagerService service, int _taskId, ActivityInfo info, Intent _intent, IVoiceInteractionSession _voiceSession, IVoiceInteractor _voiceInteractor) {
        this.mService = service;
        this.userId = UserHandle.getUserId(info.applicationInfo.uid);
        this.taskId = _taskId;
        this.lastActiveTime = SystemClock.elapsedRealtime();
        this.mAffiliatedTaskId = _taskId;
        this.voiceSession = _voiceSession;
        this.voiceInteractor = _voiceInteractor;
        this.isAvailable = true;
        this.mActivities = new ArrayList();
        this.mCallingUid = info.applicationInfo.uid;
        this.mCallingPackage = info.packageName;
        this.setIntent(_intent, info);
        this.setMinDimensions(info);
        this.touchActiveTime();
        this.mService.getTaskChangeNotificationController().notifyTaskCreated(_taskId, this.realActivity);
    }

    TaskRecord(ActivityTaskManagerService service, int _taskId, ActivityInfo info, Intent _intent, ActivityManager.TaskDescription _taskDescription) {
        this.mService = service;
        this.userId = UserHandle.getUserId(info.applicationInfo.uid);
        this.taskId = _taskId;
        this.lastActiveTime = SystemClock.elapsedRealtime();
        this.mAffiliatedTaskId = _taskId;
        this.voiceSession = null;
        this.voiceInteractor = null;
        this.isAvailable = true;
        this.mActivities = new ArrayList();
        this.mCallingUid = info.applicationInfo.uid;
        this.mCallingPackage = info.packageName;
        this.setIntent(_intent, info);
        this.setMinDimensions(info);
        this.isPersistable = true;
        this.maxRecents = Math.min(Math.max(info.maxRecents, 1), ActivityTaskManager.getMaxAppRecentsLimitStatic());
        this.lastTaskDescription = _taskDescription;
        this.touchActiveTime();
        this.mService.getTaskChangeNotificationController().notifyTaskCreated(_taskId, this.realActivity);
    }

    TaskRecord(ActivityTaskManagerService service, int _taskId, Intent _intent, Intent _affinityIntent, String _affinity, String _rootAffinity, ComponentName _realActivity, ComponentName _origActivity, boolean _rootWasReset, boolean _autoRemoveRecents, boolean _askedCompatMode, int _userId, int _effectiveUid, String _lastDescription, ArrayList<ActivityRecord> activities, long lastTimeMoved, boolean neverRelinquishIdentity, ActivityManager.TaskDescription _lastTaskDescription, int taskAffiliation, int prevTaskId, int nextTaskId, int taskAffiliationColor, int callingUid, String callingPackage, int resizeMode, boolean supportsPictureInPicture, boolean _realActivitySuspended, boolean userSetupComplete, int minWidth, int minHeight) {
        this.mService = service;
        this.taskId = _taskId;
        this.intent = _intent;
        this.affinityIntent = _affinityIntent;
        this.affinity = _affinity;
        this.rootAffinity = _rootAffinity;
        this.voiceSession = null;
        this.voiceInteractor = null;
        this.realActivity = _realActivity;
        this.realActivitySuspended = _realActivitySuspended;
        this.origActivity = _origActivity;
        this.rootWasReset = _rootWasReset;
        this.isAvailable = true;
        this.autoRemoveRecents = _autoRemoveRecents;
        this.askedCompatMode = _askedCompatMode;
        this.userId = _userId;
        this.mUserSetupComplete = userSetupComplete;
        this.effectiveUid = _effectiveUid;
        this.lastActiveTime = SystemClock.elapsedRealtime();
        this.lastDescription = _lastDescription;
        this.mActivities = activities;
        this.mLastTimeMoved = lastTimeMoved;
        this.mNeverRelinquishIdentity = neverRelinquishIdentity;
        this.lastTaskDescription = _lastTaskDescription;
        this.mAffiliatedTaskId = taskAffiliation;
        this.mAffiliatedTaskColor = taskAffiliationColor;
        this.mPrevAffiliateTaskId = prevTaskId;
        this.mNextAffiliateTaskId = nextTaskId;
        this.mCallingUid = callingUid;
        this.mCallingPackage = callingPackage;
        this.mResizeMode = resizeMode;
        this.mSupportsPictureInPicture = supportsPictureInPicture;
        this.mMinWidth = minWidth;
        this.mMinHeight = minHeight;
        this.mService.getTaskChangeNotificationController().notifyTaskCreated(_taskId, this.realActivity);
    }

    Task getTask() {
        return this.mTask;
    }

    void createTask(boolean onTop, boolean showForAllUsers) {
        int position;
        if (this.mTask != null) {
            throw new IllegalArgumentException("mTask=" + this.mTask + " already created for task=" + this);
        }
        Rect bounds = this.updateOverrideConfigurationFromLaunchBounds();
        TaskStack stack = ((ActivityStack)this.getStack()).getTaskStack();
        if (stack == null) {
            throw new IllegalArgumentException("TaskRecord: invalid stack=" + this.mStack);
        }
        EventLog.writeEvent(31001, this.taskId, stack.mStackId);
        this.mTask = new Task(this.taskId, stack, this.userId, this.mService.mWindowManager, this.mResizeMode, this.mSupportsPictureInPicture, this.lastTaskDescription, this);
        int n = position = onTop ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        if (!this.mDisplayedBounds.isEmpty()) {
            this.mTask.setOverrideDisplayedBounds(this.mDisplayedBounds);
        }
        stack.addTask(this.mTask, position, showForAllUsers, onTop);
    }

    void setTask(Task task) {
        this.mTask = task;
    }

    void cleanUpResourcesForDestroy() {
        boolean isVoiceSession;
        if (!this.mActivities.isEmpty()) {
            return;
        }
        this.saveLaunchingStateIfNeeded();
        boolean bl = isVoiceSession = this.voiceSession != null;
        if (isVoiceSession) {
            try {
                this.voiceSession.taskFinished(this.intent, this.taskId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (this.autoRemoveFromRecents() || isVoiceSession) {
            this.mService.mStackSupervisor.mRecentTasks.remove(this);
        }
        this.removeWindowContainer();
    }

    @VisibleForTesting
    void removeWindowContainer() {
        this.mService.getLockTaskController().clearLockedTask(this);
        if (this.mTask == null) {
            return;
        }
        this.mTask.removeIfPossible();
        this.mTask = null;
        if (!this.getWindowConfiguration().persistTaskBounds()) {
            this.updateOverrideConfiguration(null);
        }
        this.mService.getTaskChangeNotificationController().notifyTaskRemoved(this.taskId);
    }

    public void onSnapshotChanged(ActivityManager.TaskSnapshot snapshot) {
        this.mService.getTaskChangeNotificationController().notifyTaskSnapshotChanged(this.taskId, snapshot);
    }

    void setResizeMode(int resizeMode) {
        if (this.mResizeMode == resizeMode) {
            return;
        }
        this.mResizeMode = resizeMode;
        this.mTask.setResizeable(resizeMode);
        this.mService.mRootActivityContainer.ensureActivitiesVisible(null, 0, false);
        this.mService.mRootActivityContainer.resumeFocusedStacksTopActivities();
    }

    void setTaskDockedResizing(boolean resizing) {
        if (this.mTask == null) {
            Slog.w("WindowManager", "setTaskDockedResizing: taskId " + this.taskId + " not found.");
            return;
        }
        this.mTask.setTaskDockedResizing(resizing);
    }

    public void requestResize(Rect bounds, int resizeMode) {
        this.mService.resizeTask(this.taskId, bounds, resizeMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resize(Rect bounds, int resizeMode, boolean preserveWindow, boolean deferResume) {
        this.mService.mWindowManager.deferSurfaceLayout();
        try {
            ActivityRecord r;
            boolean forced;
            if (!this.isResizeable()) {
                Slog.w("ActivityTaskManager", "resizeTask: task " + this + " not resizeable.");
                boolean bl = true;
                return bl;
            }
            boolean bl = forced = (resizeMode & 2) != 0;
            if (this.equivalentRequestedOverrideBounds(bounds) && !forced) {
                boolean bl2 = true;
                return bl2;
            }
            if (this.mTask == null) {
                this.updateOverrideConfiguration(bounds);
                if (!this.inFreeformWindowingMode()) {
                    this.mService.mStackSupervisor.restoreRecentTaskLocked(this, null, false);
                }
                boolean bl3 = true;
                return bl3;
            }
            if (!this.canResizeToBounds(bounds)) {
                throw new IllegalArgumentException("resizeTask: Can not resize task=" + this + " to bounds=" + bounds + " resizeMode=" + this.mResizeMode);
            }
            Trace.traceBegin(64L, "am.resizeTask_" + this.taskId);
            boolean updatedConfig = this.updateOverrideConfiguration(bounds);
            boolean kept = true;
            if (updatedConfig && (r = this.topRunningActivityLocked()) != null && !deferResume) {
                kept = r.ensureActivityConfiguration(0, preserveWindow);
                this.mService.mRootActivityContainer.ensureActivitiesVisible(r, 0, preserveWindow);
                if (!kept) {
                    this.mService.mRootActivityContainer.resumeFocusedStacksTopActivities();
                }
            }
            this.mTask.resize(kept, forced);
            this.saveLaunchingStateIfNeeded();
            Trace.traceEnd(64L);
            boolean bl4 = kept;
            return bl4;
        }
        finally {
            this.mService.mWindowManager.continueSurfaceLayout();
        }
    }

    void resizeWindowContainer() {
        this.mTask.resize(false, false);
    }

    void getWindowContainerBounds(Rect bounds) {
        if (this.mTask != null) {
            this.mTask.getBounds(bounds);
        } else {
            bounds.setEmpty();
        }
    }

    boolean reparent(ActivityStack preferredStack, boolean toTop, int moveStackMode, boolean animate, boolean deferResume, String reason) {
        return this.reparent(preferredStack, toTop ? Integer.MAX_VALUE : 0, moveStackMode, animate, deferResume, true, reason);
    }

    boolean reparent(ActivityStack preferredStack, boolean toTop, int moveStackMode, boolean animate, boolean deferResume, boolean schedulePictureInPictureModeChange, String reason) {
        return this.reparent(preferredStack, toTop ? Integer.MAX_VALUE : 0, moveStackMode, animate, deferResume, schedulePictureInPictureModeChange, reason);
    }

    boolean reparent(ActivityStack preferredStack, int position, int moveStackMode, boolean animate, boolean deferResume, String reason) {
        return this.reparent(preferredStack, position, moveStackMode, animate, deferResume, true, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reparent(ActivityStack preferredStack, int position, int moveStackMode, boolean animate, boolean deferResume, boolean schedulePictureInPictureModeChange, String reason) {
        boolean mightReplaceWindow;
        boolean toTopOfStack;
        ActivityStackSupervisor supervisor = this.mService.mStackSupervisor;
        RootActivityContainer root = this.mService.mRootActivityContainer;
        WindowManagerService windowManager = this.mService.mWindowManager;
        Object sourceStack = this.getStack();
        ActivityStack toStack = supervisor.getReparentTargetStack(this, preferredStack, position == Integer.MAX_VALUE);
        if (toStack == sourceStack) {
            return false;
        }
        if (!this.canBeLaunchedOnDisplay(toStack.mDisplayId)) {
            return false;
        }
        boolean bl = toTopOfStack = position == Integer.MAX_VALUE;
        if (toTopOfStack && toStack.getResumedActivity() != null && toStack.topRunningActivityLocked() != null) {
            toStack.startPausingLocked(false, false, null, false);
        }
        int toStackWindowingMode = toStack.getWindowingMode();
        ActivityRecord topActivity = this.getTopActivity();
        boolean bl2 = mightReplaceWindow = topActivity != null && TaskRecord.replaceWindowsOnTaskMove(this.getWindowingMode(), toStackWindowingMode);
        if (mightReplaceWindow) {
            windowManager.setWillReplaceWindow(topActivity.appToken, animate);
        }
        windowManager.deferSurfaceLayout();
        boolean kept = true;
        try {
            ActivityRecord r = this.topRunningActivityLocked();
            boolean wasFocused = r != null && root.isTopDisplayFocusedStack((ActivityStack)sourceStack) && this.topRunningActivityLocked() == r;
            boolean wasResumed = r != null && ((ActivityStack)sourceStack).getResumedActivity() == r;
            boolean wasPaused = r != null && ((ActivityStack)sourceStack).mPausingActivity == r;
            boolean wasFront = r != null && ((ActivityStack)sourceStack).isTopStackOnDisplay() && ((ActivityStack)sourceStack).topRunningActivityLocked() == r;
            position = toStack.getAdjustedPositionForTask(this, position, null);
            this.mTask.reparent(toStack.getTaskStack(), position, moveStackMode == 0);
            boolean moveStackToFront = moveStackMode == 0 || moveStackMode == 1 && (wasFocused || wasFront);
            ((ActivityStack)sourceStack).removeTask(this, reason, moveStackToFront ? 2 : 1);
            toStack.addTask(this, position, false, reason);
            if (schedulePictureInPictureModeChange) {
                supervisor.scheduleUpdatePictureInPictureModeIfNeeded(this, (ActivityStack)sourceStack);
            }
            if (this.voiceSession != null) {
                try {
                    this.voiceSession.taskStarted(this.intent, this.taskId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (r != null) {
                toStack.moveToFrontAndResumeStateIfNeeded(r, moveStackToFront, wasResumed, wasPaused, reason);
            }
            if (!animate) {
                this.mService.mStackSupervisor.mNoAnimActivities.add(topActivity);
            }
            toStack.prepareFreezingTaskBounds();
            boolean toStackSplitScreenPrimary = toStackWindowingMode == 3;
            Rect configBounds = this.getRequestedOverrideBounds();
            if (!(toStackWindowingMode != 1 && toStackWindowingMode != 4 || Objects.equals(configBounds, toStack.getRequestedOverrideBounds()))) {
                kept = this.resize(toStack.getRequestedOverrideBounds(), 0, !mightReplaceWindow, deferResume);
            } else if (toStackWindowingMode == 5) {
                Rect bounds = this.getLaunchBounds();
                if (bounds == null) {
                    this.mService.mStackSupervisor.getLaunchParamsController().layoutTask(this, null);
                    bounds = configBounds;
                }
                kept = this.resize(bounds, 2, !mightReplaceWindow, deferResume);
            } else if (toStackSplitScreenPrimary || toStackWindowingMode == 2) {
                if (toStackSplitScreenPrimary && moveStackMode == 1) {
                    this.mService.mStackSupervisor.moveRecentsStackToFront(reason);
                }
                kept = this.resize(toStack.getRequestedOverrideBounds(), 0, !mightReplaceWindow, deferResume);
            }
        }
        finally {
            windowManager.continueSurfaceLayout();
        }
        if (mightReplaceWindow) {
            windowManager.scheduleClearWillReplaceWindows(topActivity.appToken, !kept);
        }
        if (!deferResume) {
            root.ensureActivitiesVisible(null, 0, !mightReplaceWindow);
            root.resumeFocusedStacksTopActivities();
        }
        supervisor.handleNonResizableTaskIfNeeded(this, preferredStack.getWindowingMode(), 0, toStack);
        return preferredStack == toStack;
    }

    private static boolean replaceWindowsOnTaskMove(int sourceWindowingMode, int targetWindowingMode) {
        return sourceWindowingMode == 5 || targetWindowingMode == 5;
    }

    void cancelWindowTransition() {
        if (this.mTask == null) {
            Slog.w("WindowManager", "cancelWindowTransition: taskId " + this.taskId + " not found.");
            return;
        }
        this.mTask.cancelTaskWindowTransition();
    }

    ActivityManager.TaskSnapshot getSnapshot(boolean reducedResolution, boolean restoreFromDisk) {
        return this.mService.mWindowManager.getTaskSnapshot(this.taskId, this.userId, reducedResolution, restoreFromDisk);
    }

    void touchActiveTime() {
        this.lastActiveTime = SystemClock.elapsedRealtime();
    }

    long getInactiveDuration() {
        return SystemClock.elapsedRealtime() - this.lastActiveTime;
    }

    void setIntent(ActivityRecord r) {
        this.mCallingUid = r.launchedFromUid;
        this.mCallingPackage = r.launchedFromPackage;
        this.setIntent(r.intent, r.info);
        this.setLockTaskAuth(r);
    }

    private void setIntent(Intent _intent, ActivityInfo info) {
        int intentFlags;
        if (this.intent == null) {
            this.mNeverRelinquishIdentity = (info.flags & 0x1000) == 0;
        } else if (this.mNeverRelinquishIdentity) {
            return;
        }
        this.affinity = info.taskAffinity;
        if (this.intent == null) {
            this.rootAffinity = this.affinity;
        }
        this.effectiveUid = info.applicationInfo.uid;
        this.stringName = null;
        if (info.targetActivity == null) {
            if (_intent != null && (_intent.getSelector() != null || _intent.getSourceBounds() != null)) {
                _intent = new Intent(_intent);
                _intent.setSelector(null);
                _intent.setSourceBounds(null);
            }
            this.intent = _intent;
            this.realActivity = _intent != null ? _intent.getComponent() : null;
            this.origActivity = null;
        } else {
            ComponentName targetComponent = new ComponentName(info.packageName, info.targetActivity);
            if (_intent != null) {
                Intent targetIntent = new Intent(_intent);
                targetIntent.setSelector(null);
                targetIntent.setSourceBounds(null);
                this.intent = targetIntent;
                this.realActivity = targetComponent;
                this.origActivity = _intent.getComponent();
            } else {
                this.intent = null;
                this.realActivity = targetComponent;
                this.origActivity = new ComponentName(info.packageName, info.name);
            }
        }
        int n = intentFlags = this.intent == null ? 0 : this.intent.getFlags();
        if ((intentFlags & 0x200000) != 0) {
            this.rootWasReset = true;
        }
        this.userId = UserHandle.getUserId(info.applicationInfo.uid);
        boolean bl = this.mUserSetupComplete = Settings.Secure.getIntForUser(this.mService.mContext.getContentResolver(), ATTR_USER_SETUP_COMPLETE, 0, this.userId) != 0;
        this.autoRemoveRecents = (info.flags & 0x2000) != 0 ? true : ((intentFlags & 0x82000) == 524288 ? info.documentLaunchMode == 0 : false);
        this.mResizeMode = info.resizeMode;
        this.mSupportsPictureInPicture = info.supportsPictureInPicture();
    }

    private void setMinDimensions(ActivityInfo info) {
        if (info != null && info.windowLayout != null) {
            this.mMinWidth = info.windowLayout.minWidth;
            this.mMinHeight = info.windowLayout.minHeight;
        } else {
            this.mMinWidth = -1;
            this.mMinHeight = -1;
        }
    }

    boolean isSameIntentFilter(ActivityRecord r) {
        Intent intent = new Intent(r.intent);
        if (Objects.equals(this.realActivity, r.mActivityComponent) && this.intent != null) {
            intent.setComponent(this.intent.getComponent());
        }
        return intent.filterEquals(this.intent);
    }

    boolean returnsToHomeStack() {
        int returnHomeFlags = 0x10004000;
        return this.intent != null && (this.intent.getFlags() & 0x10004000) == 0x10004000;
    }

    void setPrevAffiliate(TaskRecord prevAffiliate) {
        this.mPrevAffiliate = prevAffiliate;
        this.mPrevAffiliateTaskId = prevAffiliate == null ? -1 : prevAffiliate.taskId;
    }

    void setNextAffiliate(TaskRecord nextAffiliate) {
        this.mNextAffiliate = nextAffiliate;
        this.mNextAffiliateTaskId = nextAffiliate == null ? -1 : nextAffiliate.taskId;
    }

    <T extends ActivityStack> T getStack() {
        return (T)this.mStack;
    }

    void setStack(ActivityStack stack) {
        if (stack != null && !stack.isInStackLocked(this)) {
            throw new IllegalStateException("Task must be added as a Stack child first.");
        }
        ActivityStack oldStack = this.mStack;
        this.mStack = stack;
        if (oldStack != this.mStack) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                ActivityRecord activity = this.getChildAt(i);
                if (oldStack != null) {
                    oldStack.onActivityRemovedFromStack(activity);
                }
                if (this.mStack == null) continue;
                stack.onActivityAddedToStack(activity);
            }
        }
        this.onParentChanged();
    }

    int getStackId() {
        return this.mStack != null ? this.mStack.mStackId : -1;
    }

    @Override
    protected int getChildCount() {
        return this.mActivities.size();
    }

    protected ActivityRecord getChildAt(int index) {
        return this.mActivities.get(index);
    }

    @Override
    protected ConfigurationContainer getParent() {
        return this.mStack;
    }

    @Override
    protected void onParentChanged() {
        super.onParentChanged();
        this.mService.mRootActivityContainer.updateUIDsPresentOnDisplay();
    }

    private void closeRecentsChain() {
        if (this.mPrevAffiliate != null) {
            this.mPrevAffiliate.setNextAffiliate(this.mNextAffiliate);
        }
        if (this.mNextAffiliate != null) {
            this.mNextAffiliate.setPrevAffiliate(this.mPrevAffiliate);
        }
        this.setPrevAffiliate(null);
        this.setNextAffiliate(null);
    }

    void removedFromRecents() {
        this.closeRecentsChain();
        if (this.inRecents) {
            this.inRecents = false;
            this.mService.notifyTaskPersisterLocked(this, false);
        }
        this.clearRootProcess();
        this.mService.mWindowManager.notifyTaskRemovedFromRecents(this.taskId, this.userId);
    }

    void setTaskToAffiliateWith(TaskRecord taskToAffiliateWith) {
        this.closeRecentsChain();
        this.mAffiliatedTaskId = taskToAffiliateWith.mAffiliatedTaskId;
        this.mAffiliatedTaskColor = taskToAffiliateWith.mAffiliatedTaskColor;
        while (taskToAffiliateWith.mNextAffiliate != null) {
            TaskRecord nextRecents = taskToAffiliateWith.mNextAffiliate;
            if (nextRecents.mAffiliatedTaskId != this.mAffiliatedTaskId) {
                Slog.e("ActivityTaskManager", "setTaskToAffiliateWith: nextRecents=" + nextRecents + " affilTaskId=" + nextRecents.mAffiliatedTaskId + " should be " + this.mAffiliatedTaskId);
                if (nextRecents.mPrevAffiliate == taskToAffiliateWith) {
                    nextRecents.setPrevAffiliate(null);
                }
                taskToAffiliateWith.setNextAffiliate(null);
                break;
            }
            taskToAffiliateWith = nextRecents;
        }
        taskToAffiliateWith.setNextAffiliate(this);
        this.setPrevAffiliate(taskToAffiliateWith);
        this.setNextAffiliate(null);
    }

    Intent getBaseIntent() {
        return this.intent != null ? this.intent : this.affinityIntent;
    }

    ActivityRecord getRootActivity() {
        for (int i = 0; i < this.mActivities.size(); ++i) {
            ActivityRecord r = this.mActivities.get(i);
            if (r.finishing) continue;
            return r;
        }
        return null;
    }

    ActivityRecord getTopActivity() {
        return this.getTopActivity(true);
    }

    ActivityRecord getTopActivity(boolean includeOverlays) {
        for (int i = this.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = this.mActivities.get(i);
            if (r.finishing || !includeOverlays && r.mTaskOverlay) continue;
            return r;
        }
        return null;
    }

    ActivityRecord topRunningActivityLocked() {
        if (this.mStack != null) {
            for (int activityNdx = this.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = this.mActivities.get(activityNdx);
                if (r.finishing || !r.okToShowLocked()) continue;
                return r;
            }
        }
        return null;
    }

    boolean isVisible() {
        for (int i = this.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = this.mActivities.get(i);
            if (!r.visible) continue;
            return true;
        }
        return false;
    }

    boolean containsAppUid(int uid) {
        for (int i = this.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = this.mActivities.get(i);
            if (r.getUid() != uid) continue;
            return true;
        }
        return false;
    }

    void getAllRunningVisibleActivitiesLocked(ArrayList<ActivityRecord> outActivities) {
        if (this.mStack != null) {
            for (int activityNdx = this.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = this.mActivities.get(activityNdx);
                if (r.finishing || !r.okToShowLocked() || !r.visibleIgnoringKeyguard) continue;
                outActivities.add(r);
            }
        }
    }

    ActivityRecord topRunningActivityWithStartingWindowLocked() {
        if (this.mStack != null) {
            for (int activityNdx = this.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = this.mActivities.get(activityNdx);
                if (r.mStartingWindowState != 1 || r.finishing || !r.okToShowLocked()) continue;
                return r;
            }
        }
        return null;
    }

    void getNumRunningActivities(TaskActivitiesReport reportOut) {
        reportOut.reset();
        for (int i = this.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = this.mActivities.get(i);
            if (r.finishing) continue;
            reportOut.base = r;
            ++reportOut.numActivities;
            if (reportOut.top == null || reportOut.top.isState(ActivityStack.ActivityState.INITIALIZING)) {
                reportOut.top = r;
                reportOut.numRunning = 0;
            }
            if (!r.attachedToProcess()) continue;
            ++reportOut.numRunning;
        }
    }

    boolean okToShowLocked() {
        return this.mService.mStackSupervisor.isCurrentProfileLocked(this.userId) || this.topRunningActivityLocked() != null;
    }

    final void setFrontOfTask() {
        boolean foundFront = false;
        int numActivities = this.mActivities.size();
        for (int activityNdx = 0; activityNdx < numActivities; ++activityNdx) {
            ActivityRecord r = this.mActivities.get(activityNdx);
            if (foundFront || r.finishing) {
                r.frontOfTask = false;
                continue;
            }
            r.frontOfTask = true;
            foundFront = true;
        }
        if (!foundFront && numActivities > 0) {
            this.mActivities.get((int)0).frontOfTask = true;
        }
    }

    final void moveActivityToFrontLocked(ActivityRecord newTop) {
        this.mActivities.remove(newTop);
        this.mActivities.add(newTop);
        this.mTask.positionChildAtTop(newTop.mAppWindowToken);
        this.updateEffectiveIntent();
        this.setFrontOfTask();
    }

    void addActivityToTop(ActivityRecord r) {
        this.addActivityAtIndex(this.mActivities.size(), r);
    }

    @Override
    public int getActivityType() {
        int applicationType = super.getActivityType();
        if (applicationType != 0 || this.mActivities.isEmpty()) {
            return applicationType;
        }
        return this.mActivities.get(0).getActivityType();
    }

    void addActivityAtIndex(int index, ActivityRecord r) {
        TaskRecord task = r.getTaskRecord();
        if (task != null && task != this) {
            throw new IllegalArgumentException("Can not add r= to task=" + this + " current parent=" + task);
        }
        r.setTask(this);
        if (!this.mActivities.remove(r) && r.fullscreen) {
            ++this.numFullscreen;
        }
        if (this.mActivities.isEmpty()) {
            if (r.getActivityType() == 0) {
                r.setActivityType(1);
            }
            this.setActivityType(r.getActivityType());
            this.isPersistable = r.isPersistable();
            this.mCallingUid = r.launchedFromUid;
            this.mCallingPackage = r.launchedFromPackage;
            this.maxRecents = Math.min(Math.max(r.info.maxRecents, 1), ActivityTaskManager.getMaxAppRecentsLimitStatic());
        } else {
            r.setActivityType(this.getActivityType());
        }
        int size = this.mActivities.size();
        if (index == size && size > 0) {
            ActivityRecord top = this.mActivities.get(size - 1);
            if (top.mTaskOverlay) {
                --index;
            }
        }
        index = Math.min(size, index);
        this.mActivities.add(index, r);
        this.updateEffectiveIntent();
        if (r.isPersistable()) {
            this.mService.notifyTaskPersisterLocked(this, false);
        }
        if (r.mAppWindowToken != null) {
            this.mTask.positionChildAt(r.mAppWindowToken, index);
        }
        this.mService.mRootActivityContainer.updateUIDsPresentOnDisplay();
    }

    boolean removeActivity(ActivityRecord r) {
        return this.removeActivity(r, false);
    }

    boolean removeActivity(ActivityRecord r, boolean reparenting) {
        if (r.getTaskRecord() != this) {
            throw new IllegalArgumentException("Activity=" + r + " does not belong to task=" + this);
        }
        r.setTask(null, reparenting);
        if (this.mActivities.remove(r) && r.fullscreen) {
            --this.numFullscreen;
        }
        if (r.isPersistable()) {
            this.mService.notifyTaskPersisterLocked(this, false);
        }
        if (this.inPinnedWindowingMode()) {
            this.mService.getTaskChangeNotificationController().notifyTaskStackChanged();
        }
        if (this.mActivities.isEmpty()) {
            return !this.mReuseTask;
        }
        this.updateEffectiveIntent();
        return false;
    }

    boolean onlyHasTaskOverlayActivities(boolean excludeFinishing) {
        int count = 0;
        for (int i = this.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = this.mActivities.get(i);
            if (excludeFinishing && r.finishing) continue;
            if (!r.mTaskOverlay) {
                return false;
            }
            ++count;
        }
        return count > 0;
    }

    boolean autoRemoveFromRecents() {
        return this.autoRemoveRecents || this.mActivities.isEmpty() && !this.hasBeenVisible;
    }

    final void performClearTaskAtIndexLocked(int activityNdx, boolean pauseImmediately, String reason) {
        int numActivities = this.mActivities.size();
        while (activityNdx < numActivities) {
            ActivityRecord r = this.mActivities.get(activityNdx);
            if (!r.finishing) {
                if (this.mStack == null) {
                    r.takeFromHistory();
                    this.mActivities.remove(activityNdx);
                    --activityNdx;
                    --numActivities;
                } else if (this.mStack.finishActivityLocked(r, 0, null, reason, false, pauseImmediately)) {
                    --activityNdx;
                    --numActivities;
                }
            }
            ++activityNdx;
        }
    }

    void performClearTaskLocked() {
        this.mReuseTask = true;
        this.performClearTaskAtIndexLocked(0, false, "clear-task-all");
        this.mReuseTask = false;
    }

    ActivityRecord performClearTaskForReuseLocked(ActivityRecord newR, int launchFlags) {
        this.mReuseTask = true;
        ActivityRecord result = this.performClearTaskLocked(newR, launchFlags);
        this.mReuseTask = false;
        return result;
    }

    final ActivityRecord performClearTaskLocked(ActivityRecord newR, int launchFlags) {
        int numActivities = this.mActivities.size();
        for (int activityNdx = numActivities - 1; activityNdx >= 0; --activityNdx) {
            ActivityRecord r = this.mActivities.get(activityNdx);
            if (r.finishing || !r.mActivityComponent.equals(newR.mActivityComponent)) continue;
            ActivityRecord ret = r;
            ++activityNdx;
            while (activityNdx < numActivities) {
                r = this.mActivities.get(activityNdx);
                if (!r.finishing) {
                    ActivityOptions opts = r.takeOptionsLocked(false);
                    if (opts != null) {
                        ret.updateOptionsLocked(opts);
                    }
                    if (this.mStack != null && this.mStack.finishActivityLocked(r, 0, null, "clear-task-stack", false)) {
                        --activityNdx;
                        --numActivities;
                    }
                }
                ++activityNdx;
            }
            if (ret.launchMode == 0 && (launchFlags & 0x20000000) == 0 && !ActivityStarter.isDocumentLaunchesIntoExisting(launchFlags) && !ret.finishing) {
                if (this.mStack != null) {
                    this.mStack.finishActivityLocked(ret, 0, null, "clear-task-top", false);
                }
                return null;
            }
            return ret;
        }
        return null;
    }

    void removeTaskActivitiesLocked(boolean pauseImmediately, String reason) {
        this.performClearTaskAtIndexLocked(0, pauseImmediately, reason);
    }

    String lockTaskAuthToString() {
        switch (this.mLockTaskAuth) {
            case 0: {
                return "LOCK_TASK_AUTH_DONT_LOCK";
            }
            case 1: {
                return "LOCK_TASK_AUTH_PINNABLE";
            }
            case 2: {
                return "LOCK_TASK_AUTH_LAUNCHABLE";
            }
            case 3: {
                return "LOCK_TASK_AUTH_WHITELISTED";
            }
            case 4: {
                return "LOCK_TASK_AUTH_LAUNCHABLE_PRIV";
            }
        }
        return "unknown=" + this.mLockTaskAuth;
    }

    void setLockTaskAuth() {
        this.setLockTaskAuth(this.getRootActivity());
    }

    private void setLockTaskAuth(ActivityRecord r) {
        if (r == null) {
            this.mLockTaskAuth = 1;
            return;
        }
        String pkg = this.realActivity != null ? this.realActivity.getPackageName() : null;
        LockTaskController lockTaskController = this.mService.getLockTaskController();
        switch (r.lockTaskLaunchMode) {
            case 0: {
                this.mLockTaskAuth = lockTaskController.isPackageWhitelisted(this.userId, pkg) ? 3 : 1;
                break;
            }
            case 1: {
                this.mLockTaskAuth = 0;
                break;
            }
            case 2: {
                this.mLockTaskAuth = 4;
                break;
            }
            case 3: {
                this.mLockTaskAuth = lockTaskController.isPackageWhitelisted(this.userId, pkg) ? 2 : 1;
            }
        }
    }

    private boolean isResizeable(boolean checkSupportsPip) {
        return this.mService.mForceResizableActivities || ActivityInfo.isResizeableMode(this.mResizeMode) || checkSupportsPip && this.mSupportsPictureInPicture;
    }

    boolean isResizeable() {
        return this.isResizeable(true);
    }

    @Override
    public boolean supportsSplitScreenWindowingMode() {
        return super.supportsSplitScreenWindowingMode() && this.mService.mSupportsSplitScreenMultiWindow && (this.mService.mForceResizableActivities || this.isResizeable(false) && !ActivityInfo.isPreserveOrientationMode(this.mResizeMode));
    }

    boolean canBeLaunchedOnDisplay(int displayId) {
        return this.mService.mStackSupervisor.canPlaceEntityOnDisplay(displayId, -1, -1, null);
    }

    private boolean canResizeToBounds(Rect bounds) {
        if (bounds == null || !this.inFreeformWindowingMode()) {
            return true;
        }
        boolean landscape = bounds.width() > bounds.height();
        Rect configBounds = this.getRequestedOverrideBounds();
        if (this.mResizeMode == 7) {
            return configBounds.isEmpty() || landscape == configBounds.width() > configBounds.height();
        }
        return !(this.mResizeMode == 6 && landscape || this.mResizeMode == 5 && !landscape);
    }

    boolean isClearingToReuseTask() {
        return this.mReuseTask;
    }

    final ActivityRecord findActivityInHistoryLocked(ActivityRecord r) {
        ComponentName realActivity = r.mActivityComponent;
        for (int activityNdx = this.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
            ActivityRecord candidate = this.mActivities.get(activityNdx);
            if (candidate.finishing || !candidate.mActivityComponent.equals(realActivity)) continue;
            return candidate;
        }
        return null;
    }

    void updateTaskDescription() {
        int activityNdx;
        int numActivities = this.mActivities.size();
        boolean relinquish = numActivities != 0 && (this.mActivities.get((int)0).info.flags & 0x1000) != 0;
        for (activityNdx = Math.min(numActivities, 1); activityNdx < numActivities; ++activityNdx) {
            ActivityRecord r = this.mActivities.get(activityNdx);
            if (relinquish && (r.info.flags & 0x1000) == 0) {
                ++activityNdx;
                break;
            }
            if (r.intent != null && (r.intent.getFlags() & 0x80000) != 0) break;
        }
        if (activityNdx > 0) {
            String label = null;
            String iconFilename = null;
            int iconResource = -1;
            int colorPrimary = 0;
            int colorBackground = 0;
            int statusBarColor = 0;
            int navigationBarColor = 0;
            boolean statusBarContrastWhenTransparent = false;
            boolean navigationBarContrastWhenTransparent = false;
            boolean topActivity = true;
            --activityNdx;
            while (activityNdx >= 0) {
                ActivityRecord r = this.mActivities.get(activityNdx);
                if (!r.mTaskOverlay) {
                    if (r.taskDescription != null) {
                        if (label == null) {
                            label = r.taskDescription.getLabel();
                        }
                        if (iconResource == -1) {
                            iconResource = r.taskDescription.getIconResource();
                        }
                        if (iconFilename == null) {
                            iconFilename = r.taskDescription.getIconFilename();
                        }
                        if (colorPrimary == 0) {
                            colorPrimary = r.taskDescription.getPrimaryColor();
                        }
                        if (topActivity) {
                            colorBackground = r.taskDescription.getBackgroundColor();
                            statusBarColor = r.taskDescription.getStatusBarColor();
                            navigationBarColor = r.taskDescription.getNavigationBarColor();
                            statusBarContrastWhenTransparent = r.taskDescription.getEnsureStatusBarContrastWhenTransparent();
                            navigationBarContrastWhenTransparent = r.taskDescription.getEnsureNavigationBarContrastWhenTransparent();
                        }
                    }
                    topActivity = false;
                }
                --activityNdx;
            }
            this.lastTaskDescription = new ActivityManager.TaskDescription(label, null, iconResource, iconFilename, colorPrimary, colorBackground, statusBarColor, navigationBarColor, statusBarContrastWhenTransparent, navigationBarContrastWhenTransparent);
            if (this.mTask != null) {
                this.mTask.setTaskDescription(this.lastTaskDescription);
            }
            if (this.taskId == this.mAffiliatedTaskId) {
                this.mAffiliatedTaskColor = this.lastTaskDescription.getPrimaryColor();
            }
        }
    }

    int findEffectiveRootIndex() {
        int effectiveNdx = 0;
        int topActivityNdx = this.mActivities.size() - 1;
        for (int activityNdx = 0; activityNdx <= topActivityNdx; ++activityNdx) {
            ActivityRecord r = this.mActivities.get(activityNdx);
            if (r.finishing) continue;
            effectiveNdx = activityNdx;
            if ((r.info.flags & 0x1000) == 0) break;
        }
        return effectiveNdx;
    }

    void updateEffectiveIntent() {
        int effectiveRootIndex = this.findEffectiveRootIndex();
        ActivityRecord r = this.mActivities.get(effectiveRootIndex);
        this.setIntent(r);
        this.updateTaskDescription();
    }

    void adjustForMinimalTaskDimensions(Rect bounds, Rect previousBounds) {
        boolean adjustHeight;
        if (bounds == null) {
            return;
        }
        int minWidth = this.mMinWidth;
        int minHeight = this.mMinHeight;
        if (!this.inPinnedWindowingMode() && this.mStack != null) {
            int defaultMinSizeDp = this.mService.mRootActivityContainer.mDefaultMinSizeOfResizeableTaskDp;
            ActivityDisplay display = this.mService.mRootActivityContainer.getActivityDisplay(this.mStack.mDisplayId);
            float density = (float)display.getConfiguration().densityDpi / 160.0f;
            int defaultMinSize = (int)((float)defaultMinSizeDp * density);
            if (minWidth == -1) {
                minWidth = defaultMinSize;
            }
            if (minHeight == -1) {
                minHeight = defaultMinSize;
            }
        }
        boolean adjustWidth = minWidth > bounds.width();
        boolean bl = adjustHeight = minHeight > bounds.height();
        if (!adjustWidth && !adjustHeight) {
            return;
        }
        if (adjustWidth) {
            if (!previousBounds.isEmpty() && bounds.right == previousBounds.right) {
                bounds.left = bounds.right - minWidth;
            } else {
                bounds.right = bounds.left + minWidth;
            }
        }
        if (adjustHeight) {
            if (!previousBounds.isEmpty() && bounds.bottom == previousBounds.bottom) {
                bounds.top = bounds.bottom - minHeight;
            } else {
                bounds.bottom = bounds.top + minHeight;
            }
        }
    }

    boolean updateOverrideConfiguration(Rect bounds) {
        return this.updateOverrideConfiguration(bounds, null);
    }

    void setLastNonFullscreenBounds(Rect bounds) {
        if (this.mLastNonFullscreenBounds == null) {
            this.mLastNonFullscreenBounds = new Rect(bounds);
        } else {
            this.mLastNonFullscreenBounds.set(bounds);
        }
    }

    boolean updateOverrideConfiguration(Rect bounds, Rect insetBounds) {
        Rect steadyBounds;
        boolean hasSetDisplayedBounds;
        boolean bl = hasSetDisplayedBounds = insetBounds != null && !insetBounds.isEmpty();
        if (hasSetDisplayedBounds) {
            this.setDisplayedBounds(bounds);
        } else {
            this.setDisplayedBounds(null);
        }
        Rect rect = steadyBounds = hasSetDisplayedBounds ? insetBounds : bounds;
        if (this.equivalentRequestedOverrideBounds(steadyBounds)) {
            return false;
        }
        this.mTmpConfig.setTo(this.getResolvedOverrideConfiguration());
        this.setBounds(steadyBounds);
        return !this.mTmpConfig.equals(this.getResolvedOverrideConfiguration());
    }

    void onActivityStateChanged(ActivityRecord record, ActivityStack.ActivityState state, String reason) {
        Object parent = this.getStack();
        if (parent != null) {
            ((ActivityStack)parent).onActivityStateChanged(record, state, reason);
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newParentConfig) {
        Rect currentBounds;
        boolean nextPersistTaskBounds;
        boolean prevPersistTaskBounds = this.getWindowConfiguration().persistTaskBounds();
        boolean bl = nextPersistTaskBounds = this.getRequestedOverrideConfiguration().windowConfiguration.persistTaskBounds() || newParentConfig.windowConfiguration.persistTaskBounds();
        if (!prevPersistTaskBounds && nextPersistTaskBounds && this.mLastNonFullscreenBounds != null && !this.mLastNonFullscreenBounds.isEmpty()) {
            this.getRequestedOverrideConfiguration().windowConfiguration.setBounds(this.mLastNonFullscreenBounds);
        }
        boolean wasInMultiWindowMode = this.inMultiWindowMode();
        super.onConfigurationChanged(newParentConfig);
        if (wasInMultiWindowMode != this.inMultiWindowMode()) {
            this.mService.mStackSupervisor.scheduleUpdateMultiWindowMode(this);
        }
        if (this.getWindowConfiguration().persistTaskBounds() && !(currentBounds = this.getRequestedOverrideBounds()).isEmpty()) {
            this.setLastNonFullscreenBounds(currentBounds);
        }
        this.saveLaunchingStateIfNeeded();
    }

    void saveLaunchingStateIfNeeded() {
        if (!this.hasBeenVisible) {
            return;
        }
        int windowingMode = this.getWindowingMode();
        if (windowingMode != 1 && windowingMode != 5) {
            return;
        }
        this.mService.mStackSupervisor.mLaunchParamsPersister.saveTask(this);
    }

    private static void fitWithinBounds(Rect bounds, Rect stackBounds, int overlapPxX, int overlapPxY) {
        if (stackBounds == null || stackBounds.isEmpty() || stackBounds.contains(bounds)) {
            return;
        }
        int horizontalDiff = 0;
        int overlapLR = Math.min(overlapPxX, bounds.width());
        if (bounds.right < stackBounds.left + overlapLR) {
            horizontalDiff = overlapLR - (bounds.right - stackBounds.left);
        } else if (bounds.left > stackBounds.right - overlapLR) {
            horizontalDiff = -(overlapLR - (stackBounds.right - bounds.left));
        }
        int verticalDiff = 0;
        int overlapTB = Math.min(overlapPxY, bounds.width());
        if (bounds.bottom < stackBounds.top + overlapTB) {
            verticalDiff = overlapTB - (bounds.bottom - stackBounds.top);
        } else if (bounds.top > stackBounds.bottom - overlapTB) {
            verticalDiff = -(overlapTB - (stackBounds.bottom - bounds.top));
        }
        bounds.offset(horizontalDiff, verticalDiff);
    }

    void setDisplayedBounds(Rect bounds) {
        if (bounds == null) {
            this.mDisplayedBounds.setEmpty();
        } else {
            this.mDisplayedBounds.set(bounds);
        }
        if (this.mTask != null) {
            this.mTask.setOverrideDisplayedBounds(this.mDisplayedBounds.isEmpty() ? null : this.mDisplayedBounds);
        }
    }

    Rect getDisplayedBounds() {
        return this.mDisplayedBounds;
    }

    boolean hasDisplayedBounds() {
        return !this.mDisplayedBounds.isEmpty();
    }

    static void intersectWithInsetsIfFits(Rect inOutBounds, Rect intersectBounds, Rect intersectInsets) {
        if (inOutBounds.right <= intersectBounds.right) {
            inOutBounds.right = Math.min(intersectBounds.right - intersectInsets.right, inOutBounds.right);
        }
        if (inOutBounds.bottom <= intersectBounds.bottom) {
            inOutBounds.bottom = Math.min(intersectBounds.bottom - intersectInsets.bottom, inOutBounds.bottom);
        }
        if (inOutBounds.left >= intersectBounds.left) {
            inOutBounds.left = Math.max(intersectBounds.left + intersectInsets.left, inOutBounds.left);
        }
        if (inOutBounds.top >= intersectBounds.top) {
            inOutBounds.top = Math.max(intersectBounds.top + intersectInsets.top, inOutBounds.top);
        }
    }

    private void calculateInsetFrames(Rect outNonDecorBounds, Rect outStableBounds, Rect bounds, DisplayInfo displayInfo) {
        outNonDecorBounds.set(bounds);
        outStableBounds.set(bounds);
        if (this.getStack() == null || ((ActivityStack)this.getStack()).getDisplay() == null) {
            return;
        }
        DisplayPolicy policy = ((ActivityStack)this.getStack()).getDisplay().mDisplayContent.getDisplayPolicy();
        if (policy == null) {
            return;
        }
        this.mTmpBounds.set(0, 0, displayInfo.logicalWidth, displayInfo.logicalHeight);
        policy.getNonDecorInsetsLw(displayInfo.rotation, displayInfo.logicalWidth, displayInfo.logicalHeight, displayInfo.displayCutout, this.mTmpInsets);
        TaskRecord.intersectWithInsetsIfFits(outNonDecorBounds, this.mTmpBounds, this.mTmpInsets);
        policy.convertNonDecorInsetsToStableInsets(this.mTmpInsets, displayInfo.rotation);
        TaskRecord.intersectWithInsetsIfFits(outStableBounds, this.mTmpBounds, this.mTmpInsets);
    }

    private int getSmallestScreenWidthDpForDockedBounds(Rect bounds) {
        DisplayContent dc = this.mStack.getDisplay().mDisplayContent;
        if (dc != null) {
            return dc.getDockedDividerController().getSmallestWidthDpForBounds(bounds);
        }
        return 0;
    }

    void computeConfigResourceOverrides(Configuration inOutConfig, Configuration parentConfig) {
        this.computeConfigResourceOverrides(inOutConfig, parentConfig, null);
    }

    void computeConfigResourceOverrides(Configuration inOutConfig, Configuration parentConfig, ActivityRecord.CompatDisplayInsets compatInsets) {
        Rect parentAppBounds;
        boolean insideParentBounds;
        float density;
        int windowingMode = inOutConfig.windowConfiguration.getWindowingMode();
        if (windowingMode == 0) {
            windowingMode = parentConfig.windowConfiguration.getWindowingMode();
        }
        if ((density = (float)inOutConfig.densityDpi) == 0.0f) {
            density = parentConfig.densityDpi;
        }
        density *= 0.00625f;
        Rect bounds = inOutConfig.windowConfiguration.getBounds();
        Rect outAppBounds = inOutConfig.windowConfiguration.getAppBounds();
        if (outAppBounds == null || outAppBounds.isEmpty()) {
            inOutConfig.windowConfiguration.setAppBounds(bounds);
            outAppBounds = inOutConfig.windowConfiguration.getAppBounds();
        }
        boolean bl = insideParentBounds = compatInsets == null;
        if (insideParentBounds && windowingMode != 5 && (parentAppBounds = parentConfig.windowConfiguration.getAppBounds()) != null && !parentAppBounds.isEmpty()) {
            outAppBounds.intersect(parentAppBounds);
        }
        if (inOutConfig.screenWidthDp == 0 || inOutConfig.screenHeightDp == 0) {
            if (insideParentBounds && this.mStack != null) {
                DisplayInfo di = new DisplayInfo();
                this.mStack.getDisplay().mDisplay.getDisplayInfo(di);
                this.calculateInsetFrames(this.mTmpNonDecorBounds, this.mTmpStableBounds, bounds, di);
            } else {
                int rotation = parentConfig.windowConfiguration.getRotation();
                if (rotation != -1 && compatInsets != null) {
                    this.mTmpNonDecorBounds.set(bounds);
                    this.mTmpStableBounds.set(bounds);
                    compatInsets.getDisplayBoundsByRotation(this.mTmpBounds, rotation);
                    TaskRecord.intersectWithInsetsIfFits(this.mTmpNonDecorBounds, this.mTmpBounds, compatInsets.mNonDecorInsets[rotation]);
                    TaskRecord.intersectWithInsetsIfFits(this.mTmpStableBounds, this.mTmpBounds, compatInsets.mStableInsets[rotation]);
                    outAppBounds.set(this.mTmpNonDecorBounds);
                } else {
                    this.mTmpNonDecorBounds.set(outAppBounds);
                    this.mTmpStableBounds.set(outAppBounds);
                }
            }
            if (inOutConfig.screenWidthDp == 0) {
                int overrideScreenWidthDp = (int)((float)this.mTmpStableBounds.width() / density);
                int n = inOutConfig.screenWidthDp = insideParentBounds ? Math.min(overrideScreenWidthDp, parentConfig.screenWidthDp) : overrideScreenWidthDp;
            }
            if (inOutConfig.screenHeightDp == 0) {
                int overrideScreenHeightDp = (int)((float)this.mTmpStableBounds.height() / density);
                int n = inOutConfig.screenHeightDp = insideParentBounds ? Math.min(overrideScreenHeightDp, parentConfig.screenHeightDp) : overrideScreenHeightDp;
            }
            if (inOutConfig.smallestScreenWidthDp == 0) {
                if (WindowConfiguration.isFloating(windowingMode)) {
                    inOutConfig.smallestScreenWidthDp = (int)((float)Math.min(bounds.width(), bounds.height()) / density);
                } else if (WindowConfiguration.isSplitScreenWindowingMode(windowingMode)) {
                    inOutConfig.smallestScreenWidthDp = this.getSmallestScreenWidthDpForDockedBounds(bounds);
                }
            }
        }
        if (inOutConfig.orientation == 0) {
            int n = inOutConfig.orientation = inOutConfig.screenWidthDp <= inOutConfig.screenHeightDp ? 1 : 2;
        }
        if (inOutConfig.screenLayout == 0) {
            int compatScreenWidthDp = (int)((float)this.mTmpNonDecorBounds.width() / density);
            int compatScreenHeightDp = (int)((float)this.mTmpNonDecorBounds.height() / density);
            int sl = parentConfig.screenLayout & 0x3F;
            int longSize = Math.max(compatScreenHeightDp, compatScreenWidthDp);
            int shortSize = Math.min(compatScreenHeightDp, compatScreenWidthDp);
            inOutConfig.screenLayout = Configuration.reduceScreenLayout(sl, longSize, shortSize);
        }
    }

    @Override
    void resolveOverrideConfiguration(Configuration newParentConfig) {
        this.mTmpBounds.set(this.getResolvedOverrideConfiguration().windowConfiguration.getBounds());
        super.resolveOverrideConfiguration(newParentConfig);
        int windowingMode = this.getRequestedOverrideConfiguration().windowConfiguration.getWindowingMode();
        if (windowingMode == 0) {
            windowingMode = newParentConfig.windowConfiguration.getWindowingMode();
        }
        Rect outOverrideBounds = this.getResolvedOverrideConfiguration().windowConfiguration.getBounds();
        if (windowingMode == 1) {
            this.computeFullscreenBounds(outOverrideBounds, null, newParentConfig.windowConfiguration.getBounds(), newParentConfig.orientation);
        }
        if (outOverrideBounds.isEmpty()) {
            return;
        }
        this.adjustForMinimalTaskDimensions(outOverrideBounds, this.mTmpBounds);
        if (windowingMode == 5) {
            float density = (float)newParentConfig.densityDpi / 160.0f;
            Rect parentBounds = new Rect(newParentConfig.windowConfiguration.getBounds());
            ActivityDisplay display = this.mStack.getDisplay();
            if (display != null && display.mDisplayContent != null) {
                Rect stableBounds = new Rect();
                display.mDisplayContent.getStableRect(stableBounds);
                parentBounds.intersect(stableBounds);
            }
            TaskRecord.fitWithinBounds(outOverrideBounds, parentBounds, (int)(density * 48.0f), (int)(density * 32.0f));
            int offsetTop = parentBounds.top - outOverrideBounds.top;
            if (offsetTop > 0) {
                outOverrideBounds.offset(0, offsetTop);
            }
        }
        this.computeConfigResourceOverrides(this.getResolvedOverrideConfiguration(), newParentConfig);
    }

    boolean handlesOrientationChangeFromDescendant() {
        return this.mTask != null && this.mTask.getParent() != null && this.mTask.getParent().handlesOrientationChangeFromDescendant();
    }

    void computeFullscreenBounds(Rect outBounds, ActivityRecord refActivity, Rect parentBounds, int parentOrientation) {
        int overrideOrientation;
        int forcedOrientation;
        outBounds.setEmpty();
        if (this.handlesOrientationChangeFromDescendant()) {
            return;
        }
        if (refActivity == null) {
            refActivity = this.getTopActivity(false);
        }
        int n = forcedOrientation = (overrideOrientation = this.getRequestedOverrideConfiguration().orientation) != 0 || refActivity == null ? overrideOrientation : refActivity.getRequestedConfigurationOrientation();
        if (forcedOrientation == 0 || forcedOrientation == parentOrientation) {
            return;
        }
        int parentWidth = parentBounds.width();
        int parentHeight = parentBounds.height();
        float aspect = (float)parentHeight / (float)parentWidth;
        if (forcedOrientation == 2) {
            int height = (int)((float)parentWidth / aspect);
            int top = parentBounds.centerY() - height / 2;
            outBounds.set(parentBounds.left, top, parentBounds.right, top + height);
        } else {
            int width = (int)((float)parentHeight * aspect);
            int left = parentBounds.centerX() - width / 2;
            outBounds.set(left, parentBounds.top, left + width, parentBounds.bottom);
        }
    }

    Rect updateOverrideConfigurationFromLaunchBounds() {
        Rect bounds = this.getLaunchBounds();
        this.updateOverrideConfiguration(bounds);
        if (bounds != null && !bounds.isEmpty()) {
            bounds.set(this.getRequestedOverrideBounds());
        }
        return bounds;
    }

    void updateOverrideConfigurationForStack(ActivityStack inStack) {
        if (this.mStack != null && this.mStack == inStack) {
            return;
        }
        if (inStack.inFreeformWindowingMode()) {
            if (!this.isResizeable()) {
                throw new IllegalArgumentException("Can not position non-resizeable task=" + this + " in stack=" + inStack);
            }
            if (!this.matchParentBounds()) {
                return;
            }
            if (this.mLastNonFullscreenBounds != null) {
                this.updateOverrideConfiguration(this.mLastNonFullscreenBounds);
            } else {
                this.mService.mStackSupervisor.getLaunchParamsController().layoutTask(this, null);
            }
        } else {
            this.updateOverrideConfiguration(inStack.getRequestedOverrideBounds());
        }
    }

    Rect getLaunchBounds() {
        if (this.mStack == null) {
            return null;
        }
        int windowingMode = this.getWindowingMode();
        if (!this.isActivityTypeStandardOrUndefined() || windowingMode == 1 || windowingMode == 3 && !this.isResizeable()) {
            return this.isResizeable() ? this.mStack.getRequestedOverrideBounds() : null;
        }
        if (!this.getWindowConfiguration().persistTaskBounds()) {
            return this.mStack.getRequestedOverrideBounds();
        }
        return this.mLastNonFullscreenBounds;
    }

    void addStartingWindowsForVisibleActivities(boolean taskSwitch) {
        for (int activityNdx = this.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
            ActivityRecord r = this.mActivities.get(activityNdx);
            if (!r.visible) continue;
            r.showStartingWindow(null, false, taskSwitch);
        }
    }

    void setRootProcess(WindowProcessController proc) {
        this.clearRootProcess();
        if (this.intent != null && (this.intent.getFlags() & 0x800000) == 0) {
            this.mRootProcess = proc;
            this.mRootProcess.addRecentTask(this);
        }
    }

    void clearRootProcess() {
        if (this.mRootProcess != null) {
            this.mRootProcess.removeRecentTask(this);
            this.mRootProcess = null;
        }
    }

    void clearAllPendingOptions() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.getChildAt(i).clearOptionsLocked(false);
        }
    }

    void fillTaskInfo(TaskInfo info) {
        this.getNumRunningActivities(this.mReuseActivitiesReport);
        info.userId = this.userId;
        info.stackId = this.getStackId();
        info.taskId = this.taskId;
        info.displayId = this.mStack == null ? -1 : this.mStack.mDisplayId;
        info.isRunning = this.getTopActivity() != null;
        info.baseIntent = new Intent(this.getBaseIntent());
        info.baseActivity = this.mReuseActivitiesReport.base != null ? this.mReuseActivitiesReport.base.intent.getComponent() : null;
        info.topActivity = this.mReuseActivitiesReport.top != null ? this.mReuseActivitiesReport.top.mActivityComponent : null;
        info.origActivity = this.origActivity;
        info.realActivity = this.realActivity;
        info.numActivities = this.mReuseActivitiesReport.numActivities;
        info.lastActiveTime = this.lastActiveTime;
        info.taskDescription = new ActivityManager.TaskDescription(this.lastTaskDescription);
        info.supportsSplitScreenMultiWindow = this.supportsSplitScreenWindowingMode();
        info.resizeMode = this.mResizeMode;
        info.configuration.setTo(this.getConfiguration());
    }

    ActivityManager.RunningTaskInfo getTaskInfo() {
        ActivityManager.RunningTaskInfo info = new ActivityManager.RunningTaskInfo();
        this.fillTaskInfo(info);
        return info;
    }

    void dump(PrintWriter pw, String prefix) {
        StringBuilder sb;
        pw.print(prefix);
        pw.print("userId=");
        pw.print(this.userId);
        pw.print(" effectiveUid=");
        UserHandle.formatUid(pw, this.effectiveUid);
        pw.print(" mCallingUid=");
        UserHandle.formatUid(pw, this.mCallingUid);
        pw.print(" mUserSetupComplete=");
        pw.print(this.mUserSetupComplete);
        pw.print(" mCallingPackage=");
        pw.println(this.mCallingPackage);
        if (this.affinity != null || this.rootAffinity != null) {
            pw.print(prefix);
            pw.print("affinity=");
            pw.print(this.affinity);
            if (this.affinity == null || !this.affinity.equals(this.rootAffinity)) {
                pw.print(" root=");
                pw.println(this.rootAffinity);
            } else {
                pw.println();
            }
        }
        if (this.voiceSession != null || this.voiceInteractor != null) {
            pw.print(prefix);
            pw.print("VOICE: session=0x");
            pw.print(Integer.toHexString(System.identityHashCode(this.voiceSession)));
            pw.print(" interactor=0x");
            pw.println(Integer.toHexString(System.identityHashCode(this.voiceInteractor)));
        }
        if (this.intent != null) {
            sb = new StringBuilder(128);
            sb.append(prefix);
            sb.append("intent={");
            this.intent.toShortString(sb, false, true, false, true);
            sb.append('}');
            pw.println(sb.toString());
        }
        if (this.affinityIntent != null) {
            sb = new StringBuilder(128);
            sb.append(prefix);
            sb.append("affinityIntent={");
            this.affinityIntent.toShortString(sb, false, true, false, true);
            sb.append('}');
            pw.println(sb.toString());
        }
        if (this.origActivity != null) {
            pw.print(prefix);
            pw.print("origActivity=");
            pw.println(this.origActivity.flattenToShortString());
        }
        if (this.realActivity != null) {
            pw.print(prefix);
            pw.print("mActivityComponent=");
            pw.println(this.realActivity.flattenToShortString());
        }
        if (this.autoRemoveRecents || this.isPersistable || !this.isActivityTypeStandard() || this.numFullscreen != 0) {
            pw.print(prefix);
            pw.print("autoRemoveRecents=");
            pw.print(this.autoRemoveRecents);
            pw.print(" isPersistable=");
            pw.print(this.isPersistable);
            pw.print(" numFullscreen=");
            pw.print(this.numFullscreen);
            pw.print(" activityType=");
            pw.println(this.getActivityType());
        }
        if (this.rootWasReset || this.mNeverRelinquishIdentity || this.mReuseTask || this.mLockTaskAuth != 1) {
            pw.print(prefix);
            pw.print("rootWasReset=");
            pw.print(this.rootWasReset);
            pw.print(" mNeverRelinquishIdentity=");
            pw.print(this.mNeverRelinquishIdentity);
            pw.print(" mReuseTask=");
            pw.print(this.mReuseTask);
            pw.print(" mLockTaskAuth=");
            pw.println(this.lockTaskAuthToString());
        }
        if (this.mAffiliatedTaskId != this.taskId || this.mPrevAffiliateTaskId != -1 || this.mPrevAffiliate != null || this.mNextAffiliateTaskId != -1 || this.mNextAffiliate != null) {
            pw.print(prefix);
            pw.print("affiliation=");
            pw.print(this.mAffiliatedTaskId);
            pw.print(" prevAffiliation=");
            pw.print(this.mPrevAffiliateTaskId);
            pw.print(" (");
            if (this.mPrevAffiliate == null) {
                pw.print("null");
            } else {
                pw.print(Integer.toHexString(System.identityHashCode(this.mPrevAffiliate)));
            }
            pw.print(") nextAffiliation=");
            pw.print(this.mNextAffiliateTaskId);
            pw.print(" (");
            if (this.mNextAffiliate == null) {
                pw.print("null");
            } else {
                pw.print(Integer.toHexString(System.identityHashCode(this.mNextAffiliate)));
            }
            pw.println(")");
        }
        pw.print(prefix);
        pw.print("Activities=");
        pw.println(this.mActivities);
        if (!(this.askedCompatMode && this.inRecents && this.isAvailable)) {
            pw.print(prefix);
            pw.print("askedCompatMode=");
            pw.print(this.askedCompatMode);
            pw.print(" inRecents=");
            pw.print(this.inRecents);
            pw.print(" isAvailable=");
            pw.println(this.isAvailable);
        }
        if (this.lastDescription != null) {
            pw.print(prefix);
            pw.print("lastDescription=");
            pw.println(this.lastDescription);
        }
        if (this.mRootProcess != null) {
            pw.print(prefix);
            pw.print("mRootProcess=");
            pw.println(this.mRootProcess);
        }
        pw.print(prefix);
        pw.print("stackId=");
        pw.println(this.getStackId());
        pw.print(prefix + "hasBeenVisible=" + this.hasBeenVisible);
        pw.print(" mResizeMode=" + ActivityInfo.resizeModeToString(this.mResizeMode));
        pw.print(" mSupportsPictureInPicture=" + this.mSupportsPictureInPicture);
        pw.print(" isResizeable=" + this.isResizeable());
        pw.print(" lastActiveTime=" + this.lastActiveTime);
        pw.println(" (inactive for " + this.getInactiveDuration() / 1000L + "s)");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        if (this.stringName != null) {
            sb.append(this.stringName);
            sb.append(" U=");
            sb.append(this.userId);
            sb.append(" StackId=");
            sb.append(this.getStackId());
            sb.append(" sz=");
            sb.append(this.mActivities.size());
            sb.append('}');
            return sb.toString();
        }
        sb.append("TaskRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" #");
        sb.append(this.taskId);
        if (this.affinity != null) {
            sb.append(" A=");
            sb.append(this.affinity);
        } else if (this.intent != null) {
            sb.append(" I=");
            sb.append(this.intent.getComponent().flattenToShortString());
        } else if (this.affinityIntent != null && this.affinityIntent.getComponent() != null) {
            sb.append(" aI=");
            sb.append(this.affinityIntent.getComponent().flattenToShortString());
        } else {
            sb.append(" ??");
        }
        this.stringName = sb.toString();
        return this.toString();
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, int logLevel) {
        if (logLevel == 2 && !this.isVisible()) {
            return;
        }
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, logLevel);
        proto.write(1120986464258L, this.taskId);
        for (int i = this.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord activity = this.mActivities.get(i);
            activity.writeToProto(proto, 2246267895811L);
        }
        proto.write(1120986464260L, this.mStack.mStackId);
        if (this.mLastNonFullscreenBounds != null) {
            this.mLastNonFullscreenBounds.writeToProto(proto, 1146756268037L);
        }
        if (this.realActivity != null) {
            proto.write(1138166333446L, this.realActivity.flattenToShortString());
        }
        if (this.origActivity != null) {
            proto.write(1138166333447L, this.origActivity.flattenToShortString());
        }
        proto.write(1120986464264L, this.getActivityType());
        proto.write(1120986464265L, this.mResizeMode);
        proto.write(1133871366154L, this.matchParentBounds());
        if (!this.matchParentBounds()) {
            Rect bounds = this.getRequestedOverrideBounds();
            bounds.writeToProto(proto, 0x10B0000000BL);
        }
        proto.write(1120986464268L, this.mMinWidth);
        proto.write(1120986464269L, this.mMinHeight);
        proto.end(token);
    }

    void saveToXml(XmlSerializer out) throws IOException, XmlPullParserException {
        out.attribute(null, ATTR_TASKID, String.valueOf(this.taskId));
        if (this.realActivity != null) {
            out.attribute(null, ATTR_REALACTIVITY, this.realActivity.flattenToShortString());
        }
        out.attribute(null, ATTR_REALACTIVITY_SUSPENDED, String.valueOf(this.realActivitySuspended));
        if (this.origActivity != null) {
            out.attribute(null, ATTR_ORIGACTIVITY, this.origActivity.flattenToShortString());
        }
        if (this.affinity != null) {
            out.attribute(null, ATTR_AFFINITY, this.affinity);
            if (!this.affinity.equals(this.rootAffinity)) {
                out.attribute(null, ATTR_ROOT_AFFINITY, this.rootAffinity != null ? this.rootAffinity : "@");
            }
        } else if (this.rootAffinity != null) {
            out.attribute(null, ATTR_ROOT_AFFINITY, this.rootAffinity != null ? this.rootAffinity : "@");
        }
        out.attribute(null, ATTR_ROOTHASRESET, String.valueOf(this.rootWasReset));
        out.attribute(null, ATTR_AUTOREMOVERECENTS, String.valueOf(this.autoRemoveRecents));
        out.attribute(null, ATTR_ASKEDCOMPATMODE, String.valueOf(this.askedCompatMode));
        out.attribute(null, ATTR_USERID, String.valueOf(this.userId));
        out.attribute(null, ATTR_USER_SETUP_COMPLETE, String.valueOf(this.mUserSetupComplete));
        out.attribute(null, ATTR_EFFECTIVE_UID, String.valueOf(this.effectiveUid));
        out.attribute(null, ATTR_LASTTIMEMOVED, String.valueOf(this.mLastTimeMoved));
        out.attribute(null, ATTR_NEVERRELINQUISH, String.valueOf(this.mNeverRelinquishIdentity));
        if (this.lastDescription != null) {
            out.attribute(null, ATTR_LASTDESCRIPTION, this.lastDescription.toString());
        }
        if (this.lastTaskDescription != null) {
            this.lastTaskDescription.saveToXml(out);
        }
        out.attribute(null, ATTR_TASK_AFFILIATION_COLOR, String.valueOf(this.mAffiliatedTaskColor));
        out.attribute(null, ATTR_TASK_AFFILIATION, String.valueOf(this.mAffiliatedTaskId));
        out.attribute(null, ATTR_PREV_AFFILIATION, String.valueOf(this.mPrevAffiliateTaskId));
        out.attribute(null, ATTR_NEXT_AFFILIATION, String.valueOf(this.mNextAffiliateTaskId));
        out.attribute(null, ATTR_CALLING_UID, String.valueOf(this.mCallingUid));
        out.attribute(null, ATTR_CALLING_PACKAGE, this.mCallingPackage == null ? "" : this.mCallingPackage);
        out.attribute(null, ATTR_RESIZE_MODE, String.valueOf(this.mResizeMode));
        out.attribute(null, ATTR_SUPPORTS_PICTURE_IN_PICTURE, String.valueOf(this.mSupportsPictureInPicture));
        if (this.mLastNonFullscreenBounds != null) {
            out.attribute(null, ATTR_NON_FULLSCREEN_BOUNDS, this.mLastNonFullscreenBounds.flattenToString());
        }
        out.attribute(null, ATTR_MIN_WIDTH, String.valueOf(this.mMinWidth));
        out.attribute(null, ATTR_MIN_HEIGHT, String.valueOf(this.mMinHeight));
        out.attribute(null, ATTR_PERSIST_TASK_VERSION, String.valueOf(1));
        if (this.affinityIntent != null) {
            out.startTag(null, TAG_AFFINITYINTENT);
            this.affinityIntent.saveToXml(out);
            out.endTag(null, TAG_AFFINITYINTENT);
        }
        if (this.intent != null) {
            out.startTag(null, TAG_INTENT);
            this.intent.saveToXml(out);
            out.endTag(null, TAG_INTENT);
        }
        ArrayList<ActivityRecord> activities = this.mActivities;
        int numActivities = activities.size();
        for (int activityNdx = 0; activityNdx < numActivities; ++activityNdx) {
            ActivityRecord r = activities.get(activityNdx);
            if (r.info.persistableMode == 0 || !r.isPersistable() || (r.intent.getFlags() & 0x80000 | 0x2000) == 524288 && activityNdx > 0) break;
            out.startTag(null, TAG_ACTIVITY);
            r.saveToXml(out);
            out.endTag(null, TAG_ACTIVITY);
        }
    }

    @VisibleForTesting
    static TaskRecordFactory getTaskRecordFactory() {
        if (sTaskRecordFactory == null) {
            TaskRecord.setTaskRecordFactory(new TaskRecordFactory());
        }
        return sTaskRecordFactory;
    }

    static void setTaskRecordFactory(TaskRecordFactory factory) {
        sTaskRecordFactory = factory;
    }

    static TaskRecord create(ActivityTaskManagerService service, int taskId, ActivityInfo info, Intent intent, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor) {
        return TaskRecord.getTaskRecordFactory().create(service, taskId, info, intent, voiceSession, voiceInteractor);
    }

    static TaskRecord create(ActivityTaskManagerService service, int taskId, ActivityInfo info, Intent intent, ActivityManager.TaskDescription taskDescription) {
        return TaskRecord.getTaskRecordFactory().create(service, taskId, info, intent, taskDescription);
    }

    static TaskRecord restoreFromXml(XmlPullParser in, ActivityStackSupervisor stackSupervisor) throws IOException, XmlPullParserException {
        return TaskRecord.getTaskRecordFactory().restoreFromXml(in, stackSupervisor);
    }

    static class TaskRecordFactory {
        TaskRecordFactory() {
        }

        TaskRecord create(ActivityTaskManagerService service, int taskId, ActivityInfo info, Intent intent, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor) {
            return new TaskRecord(service, taskId, info, intent, voiceSession, voiceInteractor);
        }

        TaskRecord create(ActivityTaskManagerService service, int taskId, ActivityInfo info, Intent intent, ActivityManager.TaskDescription taskDescription) {
            return new TaskRecord(service, taskId, info, intent, taskDescription);
        }

        TaskRecord create(ActivityTaskManagerService service, int taskId, Intent intent, Intent affinityIntent, String affinity, String rootAffinity, ComponentName realActivity, ComponentName origActivity, boolean rootWasReset, boolean autoRemoveRecents, boolean askedCompatMode, int userId, int effectiveUid, String lastDescription, ArrayList<ActivityRecord> activities, long lastTimeMoved, boolean neverRelinquishIdentity, ActivityManager.TaskDescription lastTaskDescription, int taskAffiliation, int prevTaskId, int nextTaskId, int taskAffiliationColor, int callingUid, String callingPackage, int resizeMode, boolean supportsPictureInPicture, boolean realActivitySuspended, boolean userSetupComplete, int minWidth, int minHeight) {
            return new TaskRecord(service, taskId, intent, affinityIntent, affinity, rootAffinity, realActivity, origActivity, rootWasReset, autoRemoveRecents, askedCompatMode, userId, effectiveUid, lastDescription, activities, lastTimeMoved, neverRelinquishIdentity, lastTaskDescription, taskAffiliation, prevTaskId, nextTaskId, taskAffiliationColor, callingUid, callingPackage, resizeMode, supportsPictureInPicture, realActivitySuspended, userSetupComplete, minWidth, minHeight);
        }

        TaskRecord restoreFromXml(XmlPullParser in, ActivityStackSupervisor stackSupervisor) throws IOException, XmlPullParserException {
            int event;
            Intent intent = null;
            Intent affinityIntent = null;
            ArrayList<ActivityRecord> activities = new ArrayList<ActivityRecord>();
            ComponentName realActivity = null;
            boolean realActivitySuspended = false;
            ComponentName origActivity = null;
            String affinity = null;
            String rootAffinity = null;
            boolean hasRootAffinity = false;
            boolean rootHasReset = false;
            boolean autoRemoveRecents = false;
            boolean askedCompatMode = false;
            int taskType = 0;
            int userId = 0;
            boolean userSetupComplete = true;
            int effectiveUid = -1;
            String lastDescription = null;
            long lastTimeOnTop = 0L;
            boolean neverRelinquishIdentity = true;
            int taskId = -1;
            int outerDepth = in.getDepth();
            ActivityManager.TaskDescription taskDescription = new ActivityManager.TaskDescription();
            int taskAffiliation = -1;
            int taskAffiliationColor = 0;
            int prevTaskId = -1;
            int nextTaskId = -1;
            int callingUid = -1;
            String callingPackage = "";
            int resizeMode = 4;
            boolean supportsPictureInPicture = false;
            Rect lastNonFullscreenBounds = null;
            int minWidth = -1;
            int minHeight = -1;
            int persistTaskVersion = 0;
            block62: for (int attrNdx = in.getAttributeCount() - 1; attrNdx >= 0; --attrNdx) {
                String attrName = in.getAttributeName(attrNdx);
                String attrValue = in.getAttributeValue(attrNdx);
                switch (attrName) {
                    case "task_id": {
                        if (taskId != -1) continue block62;
                        taskId = Integer.parseInt(attrValue);
                        continue block62;
                    }
                    case "real_activity": {
                        realActivity = ComponentName.unflattenFromString(attrValue);
                        continue block62;
                    }
                    case "real_activity_suspended": {
                        realActivitySuspended = Boolean.valueOf(attrValue);
                        continue block62;
                    }
                    case "orig_activity": {
                        origActivity = ComponentName.unflattenFromString(attrValue);
                        continue block62;
                    }
                    case "affinity": {
                        affinity = attrValue;
                        continue block62;
                    }
                    case "root_affinity": {
                        rootAffinity = attrValue;
                        hasRootAffinity = true;
                        continue block62;
                    }
                    case "root_has_reset": {
                        rootHasReset = Boolean.parseBoolean(attrValue);
                        continue block62;
                    }
                    case "auto_remove_recents": {
                        autoRemoveRecents = Boolean.parseBoolean(attrValue);
                        continue block62;
                    }
                    case "asked_compat_mode": {
                        askedCompatMode = Boolean.parseBoolean(attrValue);
                        continue block62;
                    }
                    case "user_id": {
                        userId = Integer.parseInt(attrValue);
                        continue block62;
                    }
                    case "user_setup_complete": {
                        userSetupComplete = Boolean.parseBoolean(attrValue);
                        continue block62;
                    }
                    case "effective_uid": {
                        effectiveUid = Integer.parseInt(attrValue);
                        continue block62;
                    }
                    case "task_type": {
                        taskType = Integer.parseInt(attrValue);
                        continue block62;
                    }
                    case "last_description": {
                        lastDescription = attrValue;
                        continue block62;
                    }
                    case "last_time_moved": {
                        lastTimeOnTop = Long.parseLong(attrValue);
                        continue block62;
                    }
                    case "never_relinquish_identity": {
                        neverRelinquishIdentity = Boolean.parseBoolean(attrValue);
                        continue block62;
                    }
                    case "task_affiliation": {
                        taskAffiliation = Integer.parseInt(attrValue);
                        continue block62;
                    }
                    case "prev_affiliation": {
                        prevTaskId = Integer.parseInt(attrValue);
                        continue block62;
                    }
                    case "next_affiliation": {
                        nextTaskId = Integer.parseInt(attrValue);
                        continue block62;
                    }
                    case "task_affiliation_color": {
                        taskAffiliationColor = Integer.parseInt(attrValue);
                        continue block62;
                    }
                    case "calling_uid": {
                        callingUid = Integer.parseInt(attrValue);
                        continue block62;
                    }
                    case "calling_package": {
                        callingPackage = attrValue;
                        continue block62;
                    }
                    case "resize_mode": {
                        resizeMode = Integer.parseInt(attrValue);
                        continue block62;
                    }
                    case "supports_picture_in_picture": {
                        supportsPictureInPicture = Boolean.parseBoolean(attrValue);
                        continue block62;
                    }
                    case "non_fullscreen_bounds": {
                        lastNonFullscreenBounds = Rect.unflattenFromString(attrValue);
                        continue block62;
                    }
                    case "min_width": {
                        minWidth = Integer.parseInt(attrValue);
                        continue block62;
                    }
                    case "min_height": {
                        minHeight = Integer.parseInt(attrValue);
                        continue block62;
                    }
                    case "persist_task_version": {
                        persistTaskVersion = Integer.parseInt(attrValue);
                        continue block62;
                    }
                    default: {
                        if (attrName.startsWith("task_description_")) {
                            taskDescription.restoreFromXml(attrName, attrValue);
                            continue block62;
                        }
                        Slog.w("ActivityTaskManager", "TaskRecord: Unknown attribute=" + attrName);
                    }
                }
            }
            while ((event = in.next()) != 1 && (event != 3 || in.getDepth() >= outerDepth)) {
                if (event != 2) continue;
                String name = in.getName();
                if (TaskRecord.TAG_AFFINITYINTENT.equals(name)) {
                    affinityIntent = Intent.restoreFromXml(in);
                    continue;
                }
                if (TaskRecord.TAG_INTENT.equals(name)) {
                    intent = Intent.restoreFromXml(in);
                    continue;
                }
                if (TaskRecord.TAG_ACTIVITY.equals(name)) {
                    ActivityRecord activity = ActivityRecord.restoreFromXml(in, stackSupervisor);
                    if (activity == null) continue;
                    activities.add(activity);
                    continue;
                }
                this.handleUnknownTag(name, in);
            }
            if (!hasRootAffinity) {
                rootAffinity = affinity;
            } else if ("@".equals(rootAffinity)) {
                rootAffinity = null;
            }
            if (effectiveUid <= 0) {
                Intent checkIntent = intent != null ? intent : affinityIntent;
                effectiveUid = 0;
                if (checkIntent != null) {
                    IPackageManager pm = AppGlobals.getPackageManager();
                    try {
                        ApplicationInfo ai = pm.getApplicationInfo(checkIntent.getComponent().getPackageName(), 8704, userId);
                        if (ai != null) {
                            effectiveUid = ai.uid;
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                Slog.w("ActivityTaskManager", "Updating task #" + taskId + " for " + checkIntent + ": effectiveUid=" + effectiveUid);
            }
            if (persistTaskVersion < 1) {
                if (taskType == 1 && resizeMode == 2) {
                    resizeMode = 1;
                }
            } else if (resizeMode == 3) {
                resizeMode = 2;
                supportsPictureInPicture = true;
            }
            TaskRecord task = this.create(stackSupervisor.mService, taskId, intent, affinityIntent, affinity, rootAffinity, realActivity, origActivity, rootHasReset, autoRemoveRecents, askedCompatMode, userId, effectiveUid, lastDescription, activities, lastTimeOnTop, neverRelinquishIdentity, taskDescription, taskAffiliation, prevTaskId, nextTaskId, taskAffiliationColor, callingUid, callingPackage, resizeMode, supportsPictureInPicture, realActivitySuspended, userSetupComplete, minWidth, minHeight);
            task.mLastNonFullscreenBounds = lastNonFullscreenBounds;
            task.setBounds(lastNonFullscreenBounds);
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                activities.get(activityNdx).setTask(task);
            }
            return task;
        }

        void handleUnknownTag(String name, XmlPullParser in) throws IOException, XmlPullParserException {
            Slog.e("ActivityTaskManager", "restoreTask: Unexpected name=" + name);
            XmlUtils.skipCurrentTag(in);
        }
    }

    static class TaskActivitiesReport {
        int numRunning;
        int numActivities;
        ActivityRecord top;
        ActivityRecord base;

        TaskActivitiesReport() {
        }

        void reset() {
            this.numActivities = 0;
            this.numRunning = 0;
            this.base = null;
            this.top = null;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ReparentMoveStackMode {
    }
}

