/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.GraphicBuffer;
import android.graphics.Rect;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import com.android.server.wm.SurfaceAnimator;
import com.android.server.wm.Task;

class TaskScreenshotAnimatable
implements SurfaceAnimator.Animatable {
    private static final String TAG = "TaskScreenshotAnim";
    private Task mTask;
    private SurfaceControl mSurfaceControl;
    private int mWidth;
    private int mHeight;

    public static TaskScreenshotAnimatable create(Task task) {
        return new TaskScreenshotAnimatable(task, TaskScreenshotAnimatable.getBufferFromTask(task));
    }

    private static SurfaceControl.ScreenshotGraphicBuffer getBufferFromTask(Task task) {
        if (task == null) {
            return null;
        }
        Rect tmpRect = task.getBounds();
        tmpRect.offset(0, 0);
        return SurfaceControl.captureLayers(task.getSurfaceControl().getHandle(), tmpRect, 1.0f);
    }

    private TaskScreenshotAnimatable(Task task, SurfaceControl.ScreenshotGraphicBuffer screenshotBuffer) {
        GraphicBuffer buffer = screenshotBuffer == null ? null : screenshotBuffer.getGraphicBuffer();
        this.mTask = task;
        this.mWidth = buffer != null ? buffer.getWidth() : 1;
        this.mHeight = buffer != null ? buffer.getHeight() : 1;
        this.mSurfaceControl = new SurfaceControl.Builder(new SurfaceSession()).setName("RecentTaskScreenshotSurface").setBufferSize(this.mWidth, this.mHeight).build();
        if (buffer != null) {
            Surface surface = new Surface();
            surface.copyFrom(this.mSurfaceControl);
            surface.attachAndQueueBuffer(buffer);
            surface.release();
        }
        this.getPendingTransaction().show(this.mSurfaceControl);
    }

    @Override
    public SurfaceControl.Transaction getPendingTransaction() {
        return this.mTask.getPendingTransaction();
    }

    @Override
    public void commitPendingTransaction() {
        this.mTask.commitPendingTransaction();
    }

    @Override
    public void onAnimationLeashCreated(SurfaceControl.Transaction t, SurfaceControl leash) {
        t.setLayer(leash, 1);
    }

    @Override
    public void onAnimationLeashLost(SurfaceControl.Transaction t) {
        if (this.mSurfaceControl != null) {
            t.remove(this.mSurfaceControl);
            this.mSurfaceControl = null;
        }
    }

    @Override
    public SurfaceControl.Builder makeAnimationLeash() {
        return this.mTask.makeAnimationLeash();
    }

    @Override
    public SurfaceControl getAnimationLeashParent() {
        return this.mTask.getAnimationLeashParent();
    }

    @Override
    public SurfaceControl getSurfaceControl() {
        return this.mSurfaceControl;
    }

    @Override
    public SurfaceControl getParentSurfaceControl() {
        return this.mTask.mSurfaceControl;
    }

    @Override
    public int getSurfaceWidth() {
        return this.mWidth;
    }

    @Override
    public int getSurfaceHeight() {
        return this.mHeight;
    }
}

