/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.RemoteAction;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.SurfaceControl;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.policy.DividerSnapAlgorithm;
import com.android.internal.policy.DockedDividerUtils;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.AnimatingAppWindowTokenRegistry;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.BoundsAnimationController;
import com.android.server.wm.BoundsAnimationTarget;
import com.android.server.wm.ConfigurationContainerListener;
import com.android.server.wm.Dimmer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DockedStackDividerController;
import com.android.server.wm.PinnedStackController;
import com.android.server.wm.Task;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Consumer;

public class TaskStack
extends WindowContainer<Task>
implements BoundsAnimationTarget,
ConfigurationContainerListener {
    private static final float ADJUSTED_STACK_FRACTION_MIN = 0.3f;
    private static final float IME_ADJUST_DIM_AMOUNT = 0.25f;
    final int mStackId;
    private Rect mTmpRect = new Rect();
    private Rect mTmpRect2 = new Rect();
    private Rect mTmpRect3 = new Rect();
    private Rect mTmpFromBounds = new Rect();
    private Rect mTmpToBounds = new Rect();
    private final Rect mAdjustedBounds = new Rect();
    private final Rect mFullyAdjustedImeBounds = new Rect();
    private SurfaceControl mAnimationBackgroundSurface;
    private boolean mAnimationBackgroundSurfaceIsShown = false;
    private WindowStateAnimator mAnimationBackgroundAnimator;
    final AppTokenList mExitingAppTokens = new AppTokenList();
    final AppTokenList mTmpAppTokens = new AppTokenList();
    boolean mDeferRemoval;
    private final Rect mTmpAdjustedBounds = new Rect();
    private boolean mAdjustedForIme;
    private boolean mImeGoingAway;
    private WindowState mImeWin;
    private float mMinimizeAmount;
    private float mAdjustImeAmount;
    private float mAdjustDividerAmount;
    private final int mDockedStackMinimizeThickness;
    private boolean mBoundsAnimating = false;
    private boolean mBoundsAnimatingRequested = false;
    private boolean mBoundsAnimatingToFullscreen = false;
    private boolean mCancelCurrentBoundsAnimation = false;
    private Rect mBoundsAnimationTarget = new Rect();
    private Rect mBoundsAnimationSourceHintBounds = new Rect();
    @BoundsAnimationController.AnimationType
    private int mAnimationType;
    Rect mPreAnimationBounds = new Rect();
    private Dimmer mDimmer = new Dimmer(this);
    ActivityStack mActivityStack;
    final Rect mTmpDimBoundsRect = new Rect();
    private final Point mLastSurfaceSize = new Point();
    private final AnimatingAppWindowTokenRegistry mAnimatingAppWindowTokenRegistry = new AnimatingAppWindowTokenRegistry();

    TaskStack(WindowManagerService service, int stackId, ActivityStack activityStack) {
        super(service);
        this.mStackId = stackId;
        this.mActivityStack = activityStack;
        activityStack.registerConfigurationChangeListener(this);
        this.mDockedStackMinimizeThickness = service.mContext.getResources().getDimensionPixelSize(17105143);
        EventLog.writeEvent(31004, stackId);
    }

    Task findHomeTask() {
        if (!this.isActivityTypeHome() || this.mChildren.isEmpty()) {
            return null;
        }
        return (Task)this.mChildren.get(this.mChildren.size() - 1);
    }

    void prepareFreezingTaskBounds() {
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = (Task)this.mChildren.get(taskNdx);
            task.prepareFreezingBounds();
        }
    }

    private void setAdjustedBounds(Rect bounds) {
        if (this.mAdjustedBounds.equals(bounds) && !this.isAnimatingForIme()) {
            return;
        }
        this.mAdjustedBounds.set(bounds);
        boolean adjusted = !this.mAdjustedBounds.isEmpty();
        Rect insetBounds = null;
        if (adjusted && this.isAdjustedForMinimizedDockedStack()) {
            insetBounds = this.getRawBounds();
        } else if (adjusted && this.mAdjustedForIme) {
            insetBounds = this.mImeGoingAway ? this.getRawBounds() : this.mFullyAdjustedImeBounds;
        }
        this.alignTasksToAdjustedBounds(adjusted ? this.mAdjustedBounds : this.getRawBounds(), insetBounds);
        this.mDisplayContent.setLayoutNeeded();
        this.updateSurfaceBounds();
    }

    private void alignTasksToAdjustedBounds(Rect adjustedBounds, Rect tempInsetBounds) {
        if (this.matchParentBounds()) {
            return;
        }
        boolean alignBottom = this.mAdjustedForIme && this.getDockSide() == 2;
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = (Task)this.mChildren.get(taskNdx);
            task.alignToAdjustedBounds(adjustedBounds, tempInsetBounds, alignBottom);
        }
    }

    private void updateAnimationBackgroundBounds() {
        if (this.mAnimationBackgroundSurface == null) {
            return;
        }
        this.getRawBounds(this.mTmpRect);
        Rect stackBounds = this.getBounds();
        this.getPendingTransaction().setWindowCrop(this.mAnimationBackgroundSurface, this.mTmpRect.width(), this.mTmpRect.height()).setPosition(this.mAnimationBackgroundSurface, this.mTmpRect.left - stackBounds.left, this.mTmpRect.top - stackBounds.top);
        this.scheduleAnimation();
    }

    private void hideAnimationSurface() {
        if (this.mAnimationBackgroundSurface == null) {
            return;
        }
        this.getPendingTransaction().hide(this.mAnimationBackgroundSurface);
        this.mAnimationBackgroundSurfaceIsShown = false;
        this.scheduleAnimation();
    }

    private void showAnimationSurface(float alpha) {
        if (this.mAnimationBackgroundSurface == null) {
            return;
        }
        this.getPendingTransaction().setLayer(this.mAnimationBackgroundSurface, Integer.MIN_VALUE).setAlpha(this.mAnimationBackgroundSurface, alpha).show(this.mAnimationBackgroundSurface);
        this.mAnimationBackgroundSurfaceIsShown = true;
        this.scheduleAnimation();
    }

    @Override
    public int setBounds(Rect bounds) {
        return this.setBounds(this.getRequestedOverrideBounds(), bounds);
    }

    private int setBounds(Rect existing, Rect bounds) {
        if (TaskStack.equivalentBounds(existing, bounds)) {
            return 0;
        }
        int result = super.setBounds(bounds);
        if (this.getParent() != null) {
            this.updateAnimationBackgroundBounds();
        }
        this.updateAdjustedBounds();
        this.updateSurfaceBounds();
        return result;
    }

    void getRawBounds(Rect out) {
        out.set(this.getRawBounds());
    }

    Rect getRawBounds() {
        return super.getBounds();
    }

    @Override
    public void getBounds(Rect bounds) {
        bounds.set(this.getBounds());
    }

    @Override
    public Rect getBounds() {
        if (!this.mAdjustedBounds.isEmpty()) {
            return this.mAdjustedBounds;
        }
        return super.getBounds();
    }

    private void setAnimationFinalBounds(Rect sourceHintBounds, Rect destBounds, boolean toFullscreen) {
        this.mBoundsAnimatingRequested = true;
        this.mBoundsAnimatingToFullscreen = toFullscreen;
        if (destBounds != null) {
            this.mBoundsAnimationTarget.set(destBounds);
        } else {
            this.mBoundsAnimationTarget.setEmpty();
        }
        if (sourceHintBounds != null) {
            this.mBoundsAnimationSourceHintBounds.set(sourceHintBounds);
        } else if (!this.mBoundsAnimating) {
            this.mBoundsAnimationSourceHintBounds.setEmpty();
        }
        this.mPreAnimationBounds.set(this.getRawBounds());
    }

    void getFinalAnimationBounds(Rect outBounds) {
        outBounds.set(this.mBoundsAnimationTarget);
    }

    void getFinalAnimationSourceHintBounds(Rect outBounds) {
        outBounds.set(this.mBoundsAnimationSourceHintBounds);
    }

    void getAnimationOrCurrentBounds(Rect outBounds) {
        if ((this.mBoundsAnimatingRequested || this.mBoundsAnimating) && !this.mBoundsAnimationTarget.isEmpty()) {
            this.getFinalAnimationBounds(outBounds);
            return;
        }
        this.getBounds(outBounds);
    }

    public void getDimBounds(Rect out) {
        this.getBounds(out);
    }

    boolean calculatePinnedBoundsForConfigChange(Rect inOutBounds) {
        boolean animating = false;
        if ((this.mBoundsAnimatingRequested || this.mBoundsAnimating) && !this.mBoundsAnimationTarget.isEmpty()) {
            animating = true;
            this.getFinalAnimationBounds(this.mTmpRect2);
        } else {
            this.mTmpRect2.set(inOutBounds);
        }
        boolean updated = this.mDisplayContent.mPinnedStackControllerLocked.onTaskStackBoundsChanged(this.mTmpRect2, this.mTmpRect3);
        if (updated) {
            inOutBounds.set(this.mTmpRect3);
            if (animating && !inOutBounds.equals(this.mBoundsAnimationTarget)) {
                DisplayContent displayContent = this.getDisplayContent();
                displayContent.mBoundsAnimationController.getHandler().post(() -> displayContent.mBoundsAnimationController.cancel(this));
            }
            this.mBoundsAnimationTarget.setEmpty();
            this.mBoundsAnimationSourceHintBounds.setEmpty();
            this.mCancelCurrentBoundsAnimation = true;
        }
        return updated;
    }

    void calculateDockedBoundsForConfigChange(Configuration parentConfig, Rect inOutBounds) {
        boolean primary = this.getRequestedOverrideWindowingMode() == 3;
        this.repositionSplitScreenStackAfterRotation(parentConfig, primary, inOutBounds);
        DisplayCutout cutout = this.mDisplayContent.getDisplayInfo().displayCutout;
        this.snapDockedStackAfterRotation(parentConfig, cutout, inOutBounds);
        if (primary) {
            int newDockSide = this.getDockSide(parentConfig, inOutBounds);
            this.mWmService.setDockedStackCreateStateLocked(newDockSide == 1 || newDockSide == 2 ? 0 : 1, null);
            this.mDisplayContent.getDockedDividerController().notifyDockSideChanged(newDockSide);
        }
    }

    void repositionSplitScreenStackAfterRotation(Configuration parentConfig, boolean primary, Rect inOutBounds) {
        int primaryDockSide;
        int dockSide = this.getDockSide(this.mDisplayContent, parentConfig, inOutBounds);
        int otherDockSide = DockedDividerUtils.invertDockSide(dockSide);
        int n = primaryDockSide = primary ? dockSide : otherDockSide;
        if (this.mDisplayContent.getDockedDividerController().canPrimaryStackDockTo(primaryDockSide, parentConfig.windowConfiguration.getBounds(), parentConfig.windowConfiguration.getRotation())) {
            return;
        }
        Rect parentBounds = parentConfig.windowConfiguration.getBounds();
        switch (otherDockSide) {
            case 1: {
                int movement = inOutBounds.left;
                inOutBounds.left -= movement;
                inOutBounds.right -= movement;
                break;
            }
            case 3: {
                int movement = parentBounds.right - inOutBounds.right;
                inOutBounds.left += movement;
                inOutBounds.right += movement;
                break;
            }
            case 2: {
                int movement = inOutBounds.top;
                inOutBounds.top -= movement;
                inOutBounds.bottom -= movement;
                break;
            }
            case 4: {
                int movement = parentBounds.bottom - inOutBounds.bottom;
                inOutBounds.top += movement;
                inOutBounds.bottom += movement;
            }
        }
    }

    void snapDockedStackAfterRotation(Configuration parentConfig, DisplayCutout displayCutout, Rect outBounds) {
        int dividerSize = this.mDisplayContent.getDockedDividerController().getContentWidth();
        int dockSide = this.getDockSide(parentConfig, outBounds);
        int dividerPosition = DockedDividerUtils.calculatePositionForBounds(outBounds, dockSide, dividerSize);
        int displayWidth = parentConfig.windowConfiguration.getBounds().width();
        int displayHeight = parentConfig.windowConfiguration.getBounds().height();
        int rotation = parentConfig.windowConfiguration.getRotation();
        int orientation = parentConfig.orientation;
        this.mDisplayContent.getDisplayPolicy().getStableInsetsLw(rotation, displayWidth, displayHeight, displayCutout, outBounds);
        DividerSnapAlgorithm algorithm = new DividerSnapAlgorithm(this.mWmService.mContext.getResources(), displayWidth, displayHeight, dividerSize, orientation == 1, outBounds, this.getDockSide(), this.isMinimizedDockAndHomeStackResizable());
        DividerSnapAlgorithm.SnapTarget target = algorithm.calculateNonDismissingSnapTarget(dividerPosition);
        DockedDividerUtils.calculateBoundsForPosition(target.position, dockSide, outBounds, displayWidth, displayHeight, dividerSize);
    }

    void addTask(Task task, int position) {
        this.addTask(task, position, task.showForAllUsers(), true);
    }

    void addTask(Task task, int position, boolean showForAllUsers, boolean moveParents) {
        TaskStack currentStack = task.mStack;
        if (currentStack != null && currentStack.mStackId != this.mStackId) {
            throw new IllegalStateException("Trying to add taskId=" + task.mTaskId + " to stackId=" + this.mStackId + ", but it is already attached to stackId=" + task.mStack.mStackId);
        }
        task.mStack = this;
        this.addChild(task, null);
        this.positionChildAt(position, task, moveParents, showForAllUsers);
    }

    void positionChildAt(Task child, int position) {
        if (child == null) {
            return;
        }
        child.positionAt(position);
        this.getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
    }

    void positionChildAtTop(Task child, boolean includingParents) {
        if (child == null) {
            return;
        }
        this.positionChildAt(Integer.MAX_VALUE, child, includingParents);
        DisplayContent displayContent = this.getDisplayContent();
        if (displayContent.mAppTransition.isTransitionSet()) {
            child.setSendingToBottom(false);
        }
        displayContent.layoutAndAssignWindowLayersIfNeeded();
    }

    void positionChildAtBottom(Task child, boolean includingParents) {
        if (child == null) {
            return;
        }
        this.positionChildAt(Integer.MIN_VALUE, child, includingParents);
        if (this.getDisplayContent().mAppTransition.isTransitionSet()) {
            child.setSendingToBottom(true);
        }
        this.getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
    }

    @Override
    void positionChildAt(int position, Task child, boolean includingParents) {
        this.positionChildAt(position, child, includingParents, child.showForAllUsers());
    }

    private void positionChildAt(int position, Task child, boolean includingParents, boolean showForAllUsers) {
        int targetPosition = this.findPositionForTask(child, position, showForAllUsers, false);
        super.positionChildAt(targetPosition, child, includingParents);
        int toTop = targetPosition == this.mChildren.size() - 1 ? 1 : 0;
        EventLog.writeEvent(31002, child.mTaskId, toTop, targetPosition);
    }

    void reparent(int displayId, Rect outStackBounds, boolean onTop) {
        DisplayContent targetDc = this.mWmService.mRoot.getDisplayContent(displayId);
        if (targetDc == null) {
            throw new IllegalArgumentException("Trying to move stackId=" + this.mStackId + " to unknown displayId=" + displayId);
        }
        targetDc.moveStackToDisplay(this, onTop);
        if (this.matchParentBounds()) {
            outStackBounds.setEmpty();
        } else {
            this.getRawBounds(outStackBounds);
        }
    }

    private int findPositionForTask(Task task, int targetPosition, boolean showForAllUsers, boolean addingNew) {
        int maxPosition;
        boolean canShowTask = showForAllUsers || this.mWmService.isCurrentProfileLocked(task.mUserId);
        int stackSize = this.mChildren.size();
        int minPosition = 0;
        int n = maxPosition = addingNew ? stackSize : stackSize - 1;
        if (canShowTask) {
            minPosition = this.computeMinPosition(minPosition, stackSize);
        } else {
            maxPosition = this.computeMaxPosition(maxPosition);
        }
        if (targetPosition == Integer.MIN_VALUE && minPosition == 0) {
            return Integer.MIN_VALUE;
        }
        if (targetPosition == Integer.MAX_VALUE && maxPosition == (addingNew ? stackSize : stackSize - 1)) {
            return Integer.MAX_VALUE;
        }
        return Math.min(Math.max(targetPosition, minPosition), maxPosition);
    }

    private int computeMinPosition(int minPosition, int size) {
        while (minPosition < size) {
            boolean canShowTmpTask;
            Task tmpTask = (Task)this.mChildren.get(minPosition);
            boolean bl = canShowTmpTask = tmpTask.showForAllUsers() || this.mWmService.isCurrentProfileLocked(tmpTask.mUserId);
            if (canShowTmpTask) break;
            ++minPosition;
        }
        return minPosition;
    }

    private int computeMaxPosition(int maxPosition) {
        while (maxPosition > 0) {
            boolean canShowTmpTask;
            Task tmpTask = (Task)this.mChildren.get(maxPosition);
            boolean bl = canShowTmpTask = tmpTask.showForAllUsers() || this.mWmService.isCurrentProfileLocked(tmpTask.mUserId);
            if (!canShowTmpTask) break;
            --maxPosition;
        }
        return maxPosition;
    }

    @Override
    void removeChild(Task task) {
        super.removeChild(task);
        task.mStack = null;
        if (this.mDisplayContent != null) {
            if (this.mChildren.isEmpty()) {
                this.getParent().positionChildAt(Integer.MIN_VALUE, this, false);
            }
            this.mDisplayContent.setLayoutNeeded();
        }
        for (int appNdx = this.mExitingAppTokens.size() - 1; appNdx >= 0; --appNdx) {
            AppWindowToken wtoken = (AppWindowToken)this.mExitingAppTokens.get(appNdx);
            if (wtoken.getTask() != task) continue;
            wtoken.mIsExiting = false;
            this.mExitingAppTokens.remove(appNdx);
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newParentConfig) {
        int prevWindowingMode = this.getWindowingMode();
        super.onConfigurationChanged(newParentConfig);
        this.updateSurfaceSize(this.getPendingTransaction());
        int windowingMode = this.getWindowingMode();
        boolean isAlwaysOnTop = this.isAlwaysOnTop();
        if (this.mDisplayContent == null) {
            return;
        }
        if (prevWindowingMode != windowingMode) {
            this.mDisplayContent.onStackWindowingModeChanged(this);
            if (this.inSplitScreenSecondaryWindowingMode()) {
                this.forAllWindows((WindowState w) -> w.mWinAnimator.setOffsetPositionForStackResize(true), true);
            }
        }
    }

    private void updateSurfaceBounds() {
        this.updateSurfaceSize(this.getPendingTransaction());
        this.updateSurfacePosition();
        this.scheduleAnimation();
    }

    int getStackOutset() {
        DisplayContent displayContent = this.getDisplayContent();
        if (this.inPinnedWindowingMode() && displayContent != null) {
            DisplayMetrics displayMetrics = displayContent.getDisplayMetrics();
            return (int)Math.ceil(WindowManagerService.dipToPixel(5, displayMetrics) * 2);
        }
        return 0;
    }

    @Override
    void getRelativeDisplayedPosition(Point outPos) {
        super.getRelativeDisplayedPosition(outPos);
        int outset = this.getStackOutset();
        outPos.x -= outset;
        outPos.y -= outset;
    }

    private void updateSurfaceSize(SurfaceControl.Transaction transaction) {
        if (this.mSurfaceControl == null) {
            return;
        }
        Rect stackBounds = this.getDisplayedBounds();
        int width = stackBounds.width();
        int height = stackBounds.height();
        int outset = this.getStackOutset();
        if ((width += 2 * outset) == this.mLastSurfaceSize.x && (height += 2 * outset) == this.mLastSurfaceSize.y) {
            return;
        }
        if (this.getWindowConfiguration().tasksAreFloating()) {
            transaction.setWindowCrop(this.mSurfaceControl, -1, -1);
        } else {
            transaction.setWindowCrop(this.mSurfaceControl, width, height);
        }
        this.mLastSurfaceSize.set(width, height);
    }

    @VisibleForTesting
    Point getLastSurfaceSize() {
        return this.mLastSurfaceSize;
    }

    @Override
    void onDisplayChanged(DisplayContent dc) {
        if (this.mDisplayContent != null && this.mDisplayContent != dc) {
            throw new IllegalStateException("onDisplayChanged: Already attached");
        }
        super.onDisplayChanged(dc);
        this.updateSurfaceBounds();
        if (this.mAnimationBackgroundSurface == null) {
            this.mAnimationBackgroundSurface = this.makeChildSurface(null).setColorLayer().setName("animation background stackId=" + this.mStackId).build();
        }
    }

    void getStackDockedModeBoundsLocked(Configuration parentConfig, Rect dockedBounds, Rect currentTempTaskBounds, Rect outStackBounds, Rect outTempTaskBounds) {
        outTempTaskBounds.setEmpty();
        if (dockedBounds == null || dockedBounds.isEmpty()) {
            boolean dockedOnTopOrLeft = this.mWmService.mDockedStackCreateMode == 0;
            this.getStackDockedModeBounds(parentConfig, true, outStackBounds, dockedBounds, this.mDisplayContent.mDividerControllerLocked.getContentWidth(), dockedOnTopOrLeft);
            return;
        }
        int dockedSide = this.getDockSide(parentConfig, dockedBounds);
        if (this.isActivityTypeHome()) {
            Task homeTask = this.findHomeTask();
            if (homeTask != null && homeTask.isResizeable()) {
                this.getDisplayContent().mDividerControllerLocked.getHomeStackBoundsInDockedMode(parentConfig, dockedSide, outStackBounds);
            } else {
                outStackBounds.setEmpty();
            }
            outTempTaskBounds.set(outStackBounds);
            return;
        }
        if (this.isMinimizedDockAndHomeStackResizable() && currentTempTaskBounds != null) {
            outStackBounds.set(currentTempTaskBounds);
            return;
        }
        if (dockedSide == -1) {
            Slog.e("WindowManager", "Failed to get valid docked side for docked stack");
            outStackBounds.set(this.getRawBounds());
            return;
        }
        boolean dockedOnTopOrLeft = dockedSide == 2 || dockedSide == 1;
        this.getStackDockedModeBounds(parentConfig, false, outStackBounds, dockedBounds, this.mDisplayContent.mDividerControllerLocked.getContentWidth(), dockedOnTopOrLeft);
    }

    private void getStackDockedModeBounds(Configuration parentConfig, boolean primary, Rect outBounds, Rect dockedBounds, int dockDividerWidth, boolean dockOnTopOrLeft) {
        Rect displayRect = parentConfig.windowConfiguration.getBounds();
        boolean splitHorizontally = displayRect.width() > displayRect.height();
        outBounds.set(displayRect);
        if (primary) {
            if (this.mWmService.mDockedStackCreateBounds != null) {
                outBounds.set(this.mWmService.mDockedStackCreateBounds);
                return;
            }
            DisplayCutout displayCutout = this.mDisplayContent.getDisplayInfo().displayCutout;
            this.mDisplayContent.getDisplayPolicy().getStableInsetsLw(parentConfig.windowConfiguration.getRotation(), displayRect.width(), displayRect.height(), displayCutout, this.mTmpRect2);
            int position = new DividerSnapAlgorithm((Resources)this.mWmService.mContext.getResources(), (int)displayRect.width(), (int)displayRect.height(), (int)dockDividerWidth, (boolean)(parentConfig.orientation == 1 ? true : false), (Rect)this.mTmpRect2).getMiddleTarget().position;
            if (dockOnTopOrLeft) {
                if (splitHorizontally) {
                    outBounds.right = position;
                } else {
                    outBounds.bottom = position;
                }
            } else if (splitHorizontally) {
                outBounds.left = position + dockDividerWidth;
            } else {
                outBounds.top = position + dockDividerWidth;
            }
            return;
        }
        if (!dockOnTopOrLeft) {
            if (splitHorizontally) {
                outBounds.right = dockedBounds.left - dockDividerWidth;
            } else {
                outBounds.bottom = dockedBounds.top - dockDividerWidth;
            }
        } else if (splitHorizontally) {
            outBounds.left = dockedBounds.right + dockDividerWidth;
        } else {
            outBounds.top = dockedBounds.bottom + dockDividerWidth;
        }
        DockedDividerUtils.sanitizeStackBounds(outBounds, !dockOnTopOrLeft);
    }

    void resetDockedStackToMiddle() {
        if (this.inSplitScreenPrimaryWindowingMode()) {
            throw new IllegalStateException("Not a docked stack=" + this);
        }
        this.mWmService.mDockedStackCreateBounds = null;
        Rect bounds = new Rect();
        Rect tempBounds = new Rect();
        TaskStack dockedStack = this.mDisplayContent.getSplitScreenPrimaryStackIgnoringVisibility();
        Rect dockedBounds = dockedStack == null || dockedStack == this ? null : dockedStack.getRawBounds();
        this.getStackDockedModeBoundsLocked(this.mDisplayContent.getConfiguration(), dockedBounds, null, bounds, tempBounds);
        this.mActivityStack.requestResize(bounds);
    }

    @Override
    void removeIfPossible() {
        if (this.isSelfOrChildAnimating()) {
            this.mDeferRemoval = true;
            return;
        }
        this.removeImmediately();
    }

    @Override
    void removeImmediately() {
        if (this.mActivityStack != null) {
            this.mActivityStack.unregisterConfigurationChangeListener(this);
        }
        super.removeImmediately();
    }

    @Override
    void onParentChanged() {
        super.onParentChanged();
        if (this.getParent() != null || this.mDisplayContent == null) {
            return;
        }
        EventLog.writeEvent(31006, this.mStackId);
        if (this.mAnimationBackgroundSurface != null) {
            this.mAnimationBackgroundSurface.remove();
            this.mAnimationBackgroundSurface = null;
        }
        this.mDisplayContent = null;
        this.mWmService.mWindowPlacerLocked.requestTraversal();
    }

    void resetAnimationBackgroundAnimator() {
        this.mAnimationBackgroundAnimator = null;
        this.hideAnimationSurface();
    }

    void setAnimationBackground(WindowStateAnimator winAnimator, int color2) {
        if (this.mAnimationBackgroundAnimator == null) {
            this.mAnimationBackgroundAnimator = winAnimator;
            this.showAnimationSurface((float)(color2 >> 24 & 0xFF) / 255.0f);
        }
    }

    @Override
    void switchUser() {
        super.switchUser();
        int top = this.mChildren.size();
        for (int taskNdx = 0; taskNdx < top; ++taskNdx) {
            Task task = (Task)this.mChildren.get(taskNdx);
            if (!this.mWmService.isCurrentProfileLocked(task.mUserId) && !task.showForAllUsers()) continue;
            this.mChildren.remove(taskNdx);
            this.mChildren.add(task);
            --top;
        }
    }

    void setAdjustedForIme(WindowState imeWin, boolean keepLastAmount) {
        this.mImeWin = imeWin;
        this.mImeGoingAway = false;
        if (!this.mAdjustedForIme || keepLastAmount) {
            this.mAdjustedForIme = true;
            DockedStackDividerController controller = this.getDisplayContent().mDividerControllerLocked;
            float adjustImeAmount = keepLastAmount ? controller.mLastAnimationProgress : 0.0f;
            float adjustDividerAmount = keepLastAmount ? controller.mLastDividerProgress : 0.0f;
            this.updateAdjustForIme(adjustImeAmount, adjustDividerAmount, true);
        }
    }

    boolean isAdjustedForIme() {
        return this.mAdjustedForIme;
    }

    boolean isAnimatingForIme() {
        return this.mImeWin != null && this.mImeWin.isAnimatingLw();
    }

    boolean updateAdjustForIme(float adjustAmount, float adjustDividerAmount, boolean force) {
        if (adjustAmount != this.mAdjustImeAmount || adjustDividerAmount != this.mAdjustDividerAmount || force) {
            this.mAdjustImeAmount = adjustAmount;
            this.mAdjustDividerAmount = adjustDividerAmount;
            this.updateAdjustedBounds();
            return this.isVisible();
        }
        return false;
    }

    void resetAdjustedForIme(boolean adjustBoundsNow) {
        if (adjustBoundsNow) {
            this.mImeWin = null;
            this.mImeGoingAway = false;
            this.mAdjustImeAmount = 0.0f;
            this.mAdjustDividerAmount = 0.0f;
            if (!this.mAdjustedForIme) {
                return;
            }
            this.mAdjustedForIme = false;
            this.updateAdjustedBounds();
            this.mWmService.setResizeDimLayer(false, this.getWindowingMode(), 1.0f);
        } else {
            this.mImeGoingAway |= this.mAdjustedForIme;
        }
    }

    boolean setAdjustedForMinimizedDock(float minimizeAmount) {
        if (minimizeAmount != this.mMinimizeAmount) {
            this.mMinimizeAmount = minimizeAmount;
            this.updateAdjustedBounds();
            return this.isVisible();
        }
        return false;
    }

    boolean shouldIgnoreInput() {
        return this.isAdjustedForMinimizedDockedStack() || this.inSplitScreenPrimaryWindowingMode() && this.isMinimizedDockAndHomeStackResizable();
    }

    void beginImeAdjustAnimation() {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            Task task = (Task)this.mChildren.get(j);
            if (!task.hasContentToDisplay()) continue;
            task.setDragResizing(true, 1);
            task.setWaitingForDrawnIfResizingChanged();
        }
    }

    void endImeAdjustAnimation() {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            ((Task)this.mChildren.get(j)).setDragResizing(false, 1);
        }
    }

    int getMinTopStackBottom(Rect displayContentRect, int originalStackBottom) {
        return displayContentRect.top + (int)((float)(originalStackBottom - displayContentRect.top) * 0.3f);
    }

    private boolean adjustForIME(WindowState imeWin) {
        boolean dockedTopOrBottom;
        if (this.getDisplayContent().mAppTransition.isRunning()) {
            return false;
        }
        int dockedSide = this.getDockSide();
        boolean bl = dockedTopOrBottom = dockedSide == 2 || dockedSide == 4;
        if (imeWin == null || !dockedTopOrBottom) {
            return false;
        }
        Rect displayStableRect = this.mTmpRect;
        Rect contentBounds = this.mTmpRect2;
        this.getDisplayContent().getStableRect(displayStableRect);
        contentBounds.set(displayStableRect);
        int imeTop = Math.max(imeWin.getFrameLw().top, contentBounds.top);
        if (contentBounds.bottom > (imeTop += imeWin.getGivenContentInsetsLw().top)) {
            contentBounds.bottom = imeTop;
        }
        int yOffset = displayStableRect.bottom - contentBounds.bottom;
        int dividerWidth = this.getDisplayContent().mDividerControllerLocked.getContentWidth();
        int dividerWidthInactive = this.getDisplayContent().mDividerControllerLocked.getContentWidthInactive();
        if (dockedSide == 2) {
            int minTopStackBottom = this.getMinTopStackBottom(displayStableRect, this.getRawBounds().bottom);
            int bottom = Math.max(this.getRawBounds().bottom - yOffset + dividerWidth - dividerWidthInactive, minTopStackBottom);
            this.mTmpAdjustedBounds.set(this.getRawBounds());
            this.mTmpAdjustedBounds.bottom = (int)(this.mAdjustImeAmount * (float)bottom + (1.0f - this.mAdjustImeAmount) * (float)this.getRawBounds().bottom);
            this.mFullyAdjustedImeBounds.set(this.getRawBounds());
        } else {
            int dividerWidthDelta = dividerWidthInactive - dividerWidth;
            int topBeforeImeAdjust = this.getRawBounds().top - dividerWidth + dividerWidthInactive;
            int minTopStackBottom = this.getMinTopStackBottom(displayStableRect, this.getRawBounds().top - dividerWidth);
            int top = Math.max(this.getRawBounds().top - yOffset, minTopStackBottom + dividerWidthInactive);
            this.mTmpAdjustedBounds.set(this.getRawBounds());
            this.mTmpAdjustedBounds.top = this.getRawBounds().top + (int)(this.mAdjustImeAmount * (float)(top - topBeforeImeAdjust) + this.mAdjustDividerAmount * (float)dividerWidthDelta);
            this.mFullyAdjustedImeBounds.set(this.getRawBounds());
            this.mFullyAdjustedImeBounds.top = top;
            this.mFullyAdjustedImeBounds.bottom = top + this.getRawBounds().height();
        }
        return true;
    }

    private boolean adjustForMinimizedDockedStack(float minimizeAmount) {
        int dockSide = this.getDockSide();
        if (dockSide == -1 && !this.mTmpAdjustedBounds.isEmpty()) {
            return false;
        }
        if (dockSide == 2) {
            this.mWmService.getStableInsetsLocked(0, this.mTmpRect);
            int topInset = this.mTmpRect.top;
            this.mTmpAdjustedBounds.set(this.getRawBounds());
            this.mTmpAdjustedBounds.bottom = (int)(minimizeAmount * (float)topInset + (1.0f - minimizeAmount) * (float)this.getRawBounds().bottom);
        } else if (dockSide == 1) {
            this.mTmpAdjustedBounds.set(this.getRawBounds());
            int width = this.getRawBounds().width();
            this.mTmpAdjustedBounds.right = (int)(minimizeAmount * (float)this.mDockedStackMinimizeThickness + (1.0f - minimizeAmount) * (float)this.getRawBounds().right);
            this.mTmpAdjustedBounds.left = this.mTmpAdjustedBounds.right - width;
        } else if (dockSide == 3) {
            this.mTmpAdjustedBounds.set(this.getRawBounds());
            this.mTmpAdjustedBounds.left = (int)(minimizeAmount * (float)(this.getRawBounds().right - this.mDockedStackMinimizeThickness) + (1.0f - minimizeAmount) * (float)this.getRawBounds().left);
        }
        return true;
    }

    private boolean isMinimizedDockAndHomeStackResizable() {
        return this.mDisplayContent.mDividerControllerLocked.isMinimizedDock() && this.mDisplayContent.mDividerControllerLocked.isHomeStackResizable();
    }

    int getMinimizeDistance() {
        int dockSide = this.getDockSide();
        if (dockSide == -1) {
            return 0;
        }
        if (dockSide == 2) {
            this.mWmService.getStableInsetsLocked(0, this.mTmpRect);
            int topInset = this.mTmpRect.top;
            return this.getRawBounds().bottom - topInset;
        }
        if (dockSide == 1 || dockSide == 3) {
            return this.getRawBounds().width() - this.mDockedStackMinimizeThickness;
        }
        return 0;
    }

    private void updateAdjustedBounds() {
        boolean isImeTarget;
        boolean adjust = false;
        if (this.mMinimizeAmount != 0.0f) {
            adjust = this.adjustForMinimizedDockedStack(this.mMinimizeAmount);
        } else if (this.mAdjustedForIme) {
            adjust = this.adjustForIME(this.mImeWin);
        }
        if (!adjust) {
            this.mTmpAdjustedBounds.setEmpty();
        }
        this.setAdjustedBounds(this.mTmpAdjustedBounds);
        boolean bl = isImeTarget = this.mWmService.getImeFocusStackLocked() == this;
        if (this.mAdjustedForIme && adjust && !isImeTarget) {
            float alpha = Math.max(this.mAdjustImeAmount, this.mAdjustDividerAmount) * 0.25f;
            this.mWmService.setResizeDimLayer(true, this.getWindowingMode(), alpha);
        }
    }

    void applyAdjustForImeIfNeeded(Task task) {
        if (this.mMinimizeAmount != 0.0f || !this.mAdjustedForIme || this.mAdjustedBounds.isEmpty()) {
            return;
        }
        Rect insetBounds = this.mImeGoingAway ? this.getRawBounds() : this.mFullyAdjustedImeBounds;
        task.alignToAdjustedBounds(this.mAdjustedBounds, insetBounds, this.getDockSide() == 2);
        this.mDisplayContent.setLayoutNeeded();
    }

    boolean isAdjustedForMinimizedDockedStack() {
        return this.mMinimizeAmount != 0.0f;
    }

    boolean isTaskAnimating() {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            Task task = (Task)this.mChildren.get(j);
            if (!task.isTaskAnimating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, int logLevel) {
        if (logLevel == 2 && !this.isVisible()) {
            return;
        }
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, logLevel);
        proto.write(1120986464258L, this.mStackId);
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            ((Task)this.mChildren.get(taskNdx)).writeToProto(proto, 2246267895811L, logLevel);
        }
        proto.write(1133871366148L, this.matchParentBounds());
        this.getRawBounds().writeToProto(proto, 1146756268037L);
        proto.write(1133871366150L, this.mAnimationBackgroundSurfaceIsShown);
        proto.write(1133871366151L, this.mDeferRemoval);
        proto.write(1108101562376L, this.mMinimizeAmount);
        proto.write(1133871366153L, this.mAdjustedForIme);
        proto.write(1108101562378L, this.mAdjustImeAmount);
        proto.write(1108101562379L, this.mAdjustDividerAmount);
        this.mAdjustedBounds.writeToProto(proto, 1146756268044L);
        proto.write(1133871366157L, this.mBoundsAnimating);
        proto.end(token);
    }

    @Override
    void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        pw.println(prefix + "mStackId=" + this.mStackId);
        pw.println(prefix + "mDeferRemoval=" + this.mDeferRemoval);
        pw.println(prefix + "mBounds=" + this.getRawBounds().toShortString());
        if (this.mMinimizeAmount != 0.0f) {
            pw.println(prefix + "mMinimizeAmount=" + this.mMinimizeAmount);
        }
        if (this.mAdjustedForIme) {
            pw.println(prefix + "mAdjustedForIme=true");
            pw.println(prefix + "mAdjustImeAmount=" + this.mAdjustImeAmount);
            pw.println(prefix + "mAdjustDividerAmount=" + this.mAdjustDividerAmount);
        }
        if (!this.mAdjustedBounds.isEmpty()) {
            pw.println(prefix + "mAdjustedBounds=" + this.mAdjustedBounds.toShortString());
        }
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            ((Task)this.mChildren.get(taskNdx)).dump(pw, prefix + "  ", dumpAll);
        }
        if (this.mAnimationBackgroundSurfaceIsShown) {
            pw.println(prefix + "mWindowAnimationBackgroundSurface is shown");
        }
        if (!this.mExitingAppTokens.isEmpty()) {
            pw.println();
            pw.println("  Exiting application tokens:");
            for (int i = this.mExitingAppTokens.size() - 1; i >= 0; --i) {
                WindowToken token = (WindowToken)this.mExitingAppTokens.get(i);
                pw.print("  Exiting App #");
                pw.print(i);
                pw.print(' ');
                pw.print(token);
                pw.println(':');
                token.dump(pw, "    ", dumpAll);
            }
        }
        this.mAnimatingAppWindowTokenRegistry.dump(pw, "AnimatingApps:", prefix);
    }

    @Override
    boolean fillsParent() {
        return this.matchParentBounds();
    }

    public String toString() {
        return "{stackId=" + this.mStackId + " tasks=" + this.mChildren + "}";
    }

    @Override
    String getName() {
        return this.toShortString();
    }

    public String toShortString() {
        return "Stack=" + this.mStackId;
    }

    int getDockSide() {
        return this.getDockSide(this.mDisplayContent.getConfiguration(), this.getRawBounds());
    }

    int getDockSideForDisplay(DisplayContent dc) {
        return this.getDockSide(dc, dc.getConfiguration(), this.getRawBounds());
    }

    int getDockSide(Configuration parentConfig, Rect bounds) {
        if (this.mDisplayContent == null) {
            return -1;
        }
        return this.getDockSide(this.mDisplayContent, parentConfig, bounds);
    }

    private int getDockSide(DisplayContent dc, Configuration parentConfig, Rect bounds) {
        return dc.getDockedDividerController().getDockSide(bounds, parentConfig.windowConfiguration.getBounds(), parentConfig.orientation, parentConfig.windowConfiguration.getRotation());
    }

    boolean hasTaskForUser(int userId) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            Task task = (Task)this.mChildren.get(i);
            if (task.mUserId != userId) continue;
            return true;
        }
        return false;
    }

    void findTaskForResizePoint(int x, int y, int delta, DisplayContent.TaskForResizePointSearchResult results) {
        if (!this.getWindowConfiguration().canResizeTask()) {
            results.searchDone = true;
            return;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            Task task = (Task)this.mChildren.get(i);
            if (task.getWindowingMode() == 1) {
                results.searchDone = true;
                return;
            }
            task.getDimBounds(this.mTmpRect);
            this.mTmpRect.inset(-delta, -delta);
            if (!this.mTmpRect.contains(x, y)) continue;
            this.mTmpRect.inset(delta, delta);
            results.searchDone = true;
            if (!this.mTmpRect.contains(x, y)) {
                results.taskForResize = task;
                return;
            }
            return;
        }
    }

    void setTouchExcludeRegion(Task focusedTask, int delta, Region touchExcludeRegion, Rect contentRect, Rect postExclude) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            Task task = (Task)this.mChildren.get(i);
            AppWindowToken token = task.getTopVisibleAppToken();
            if (token == null || !token.hasContentToDisplay()) continue;
            if (task.isActivityTypeHome() && this.isMinimizedDockAndHomeStackResizable()) {
                this.mDisplayContent.getBounds(this.mTmpRect);
            } else {
                task.getDimBounds(this.mTmpRect);
            }
            if (task == focusedTask) {
                postExclude.set(this.mTmpRect);
            }
            boolean isFreeformed = task.inFreeformWindowingMode();
            if (task == focusedTask && !isFreeformed) continue;
            if (isFreeformed) {
                this.mTmpRect.inset(-delta, -delta);
                this.mTmpRect.intersect(contentRect);
            }
            touchExcludeRegion.op(this.mTmpRect, Region.Op.DIFFERENCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean setPinnedStackSize(Rect stackBounds, Rect tempTaskBounds) {
        var3_3 = this.mWmService.mGlobalLock;
        synchronized (var3_3) {
            WindowManagerService.boostPriorityForLockedSection();
            if (!this.mCancelCurrentBoundsAnimation) ** break block6
            v0 = false;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v0;
        {
            try {}
            catch (Throwable var4_5) {
                // MONITOREXIT @DISABLED, blocks:[3, 4] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw var4_5;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        try {
            this.mWmService.mActivityTaskManager.resizePinnedStack(stackBounds, tempTaskBounds);
        }
        catch (RemoteException var3_4) {
            // empty catch block
        }
        return true;
    }

    void onAllWindowsDrawn() {
        if (!this.mBoundsAnimating && !this.mBoundsAnimatingRequested) {
            return;
        }
        this.getDisplayContent().mBoundsAnimationController.onAllWindowsDrawn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean onAnimationStart(boolean schedulePipModeChangedCallback, boolean forceUpdate, @BoundsAnimationController.AnimationType int animationType) {
        var4_4 = this.mWmService.mGlobalLock;
        synchronized (var4_4) {
            WindowManagerService.boostPriorityForLockedSection();
            if (this.isAttached()) ** break block9
            v0 = false;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v0;
        {
            try {
                this.mBoundsAnimatingRequested = false;
                this.mBoundsAnimating = true;
                this.mAnimationType = animationType;
                if (schedulePipModeChangedCallback) {
                    this.forAllWindows((Consumer<WindowState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$onAnimationStart$2(com.android.server.wm.WindowState ), (Lcom/android/server/wm/WindowState;)V)(), false);
                }
            }
            catch (Throwable var5_6) {
                // MONITOREXIT @DISABLED, blocks:[3, 4] lbl19 : MonitorExitStatement: MONITOREXIT : var4_4
                WindowManagerService.resetPriorityAfterLockedSection();
                throw var5_6;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        if (this.inPinnedWindowingMode()) {
            try {
                this.mWmService.mActivityTaskManager.notifyPinnedStackAnimationStarted();
            }
            catch (RemoteException var4_5) {
                // empty catch block
            }
            if ((schedulePipModeChangedCallback || animationType == 1) && this.mActivityStack != null) {
                this.mActivityStack.updatePictureInPictureModeForPinnedStackAnimation(null, forceUpdate);
            }
        }
        return true;
    }

    @Override
    public void onAnimationEnd(boolean schedulePipModeChangedCallback, Rect finalStackSize, boolean moveToFullscreen) {
        if (this.inPinnedWindowingMode()) {
            if (schedulePipModeChangedCallback) {
                this.mActivityStack.updatePictureInPictureModeForPinnedStackAnimation(this.mBoundsAnimationTarget, false);
            }
            if (this.mAnimationType == 1) {
                this.setPinnedStackAlpha(1.0f);
                this.mActivityStack.mService.notifyPinnedStackAnimationEnded();
                return;
            }
            if (finalStackSize != null && !this.mCancelCurrentBoundsAnimation) {
                this.setPinnedStackSize(finalStackSize, null);
            } else {
                this.onPipAnimationEndResize();
            }
            this.mActivityStack.mService.notifyPinnedStackAnimationEnded();
            if (moveToFullscreen) {
                this.mActivityStack.mService.moveTasksToFullscreenStack(this.mStackId, true);
            }
        } else {
            this.onPipAnimationEndResize();
        }
    }

    Rect getPictureInPictureBounds(float aspectRatio, Rect stackBounds) {
        if (!this.mWmService.mSupportsPictureInPicture) {
            return null;
        }
        DisplayContent displayContent = this.getDisplayContent();
        if (displayContent == null) {
            return null;
        }
        if (!this.inPinnedWindowingMode()) {
            return null;
        }
        PinnedStackController pinnedStackController = displayContent.getPinnedStackController();
        if (stackBounds == null) {
            stackBounds = pinnedStackController.getDefaultOrLastSavedBounds();
        }
        if (pinnedStackController.isValidPictureInPictureAspectRatio(aspectRatio)) {
            return pinnedStackController.transformBoundsToAspectRatio(stackBounds, aspectRatio, true);
        }
        return stackBounds;
    }

    void animateResizePinnedStack(Rect toBounds, Rect sourceHintBounds, int animationDuration, boolean fromFullscreen) {
        boolean toFullscreen;
        if (!this.inPinnedWindowingMode()) {
            return;
        }
        Rect fromBounds = new Rect();
        this.getBounds(fromBounds);
        int schedulePipModeChangedState = 0;
        boolean bl = toFullscreen = toBounds == null;
        if (toFullscreen) {
            if (fromFullscreen) {
                throw new IllegalArgumentException("Should not defer scheduling PiP mode change on animation to fullscreen.");
            }
            schedulePipModeChangedState = 1;
            this.mWmService.getStackBounds(1, 1, this.mTmpToBounds);
            if (!this.mTmpToBounds.isEmpty()) {
                toBounds = new Rect(this.mTmpToBounds);
            } else {
                toBounds = new Rect();
                this.getDisplayContent().getBounds(toBounds);
            }
        } else if (fromFullscreen) {
            schedulePipModeChangedState = 2;
        }
        this.setAnimationFinalBounds(sourceHintBounds, toBounds, toFullscreen);
        Rect finalToBounds = toBounds;
        int finalSchedulePipModeChangedState = schedulePipModeChangedState;
        DisplayContent displayContent = this.getDisplayContent();
        int intendedAnimationType = displayContent.mBoundsAnimationController.getAnimationType();
        if (intendedAnimationType == 1) {
            if (fromFullscreen) {
                this.setPinnedStackAlpha(0.0f);
            }
            if (toBounds.width() == fromBounds.width() && toBounds.height() == fromBounds.height()) {
                intendedAnimationType = 0;
            }
        }
        int animationType = intendedAnimationType;
        this.mCancelCurrentBoundsAnimation = false;
        displayContent.mBoundsAnimationController.getHandler().post(() -> displayContent.mBoundsAnimationController.animateBounds(this, fromBounds, finalToBounds, animationDuration, finalSchedulePipModeChangedState, fromFullscreen, toFullscreen, animationType));
    }

    void setPictureInPictureAspectRatio(float aspectRatio) {
        if (!this.mWmService.mSupportsPictureInPicture) {
            return;
        }
        if (!this.inPinnedWindowingMode()) {
            return;
        }
        PinnedStackController pinnedStackController = this.getDisplayContent().getPinnedStackController();
        if (Float.compare(aspectRatio, pinnedStackController.getAspectRatio()) == 0) {
            return;
        }
        this.getAnimationOrCurrentBounds(this.mTmpFromBounds);
        this.mTmpToBounds.set(this.mTmpFromBounds);
        this.getPictureInPictureBounds(aspectRatio, this.mTmpToBounds);
        if (!this.mTmpToBounds.equals(this.mTmpFromBounds)) {
            this.animateResizePinnedStack(this.mTmpToBounds, null, -1, false);
        }
        pinnedStackController.setAspectRatio(pinnedStackController.isValidPictureInPictureAspectRatio(aspectRatio) ? aspectRatio : -1.0f);
    }

    void setPictureInPictureActions(List<RemoteAction> actions) {
        if (!this.mWmService.mSupportsPictureInPicture) {
            return;
        }
        if (!this.inPinnedWindowingMode()) {
            return;
        }
        this.getDisplayContent().getPinnedStackController().setActions(actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isAttached() {
        boolean bl;
        WindowManagerGlobalLock windowManagerGlobalLock = this.mWmService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                bl = this.mDisplayContent != null;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPipAnimationEndResize() {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mWmService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mBoundsAnimating = false;
                for (int i = 0; i < this.mChildren.size(); ++i) {
                    Task t = (Task)this.mChildren.get(i);
                    t.clearPreserveNonFloatingState();
                }
                this.mWmService.requestTraversal();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldDeferStartOnMoveToFullscreen() {
        AppWindowToken homeApp;
        block10: {
            Task homeTask;
            block9: {
                TaskStack homeStack;
                block8: {
                    block7: {
                        boolean bl;
                        WindowManagerGlobalLock windowManagerGlobalLock = this.mWmService.mGlobalLock;
                        // MONITORENTER : windowManagerGlobalLock
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            if (this.isAttached()) break block7;
                            bl = false;
                            // MONITOREXIT : windowManagerGlobalLock
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT : windowManagerGlobalLock
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                        WindowManagerService.resetPriorityAfterLockedSection();
                        return bl;
                    }
                    homeStack = this.mDisplayContent.getHomeStack();
                    if (homeStack != null) break block8;
                    boolean bl = true;
                    // MONITOREXIT : windowManagerGlobalLock
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return bl;
                }
                homeTask = (Task)homeStack.getTopChild();
                if (homeTask != null) break block9;
                boolean bl = true;
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                return bl;
            }
            homeApp = homeTask.getTopVisibleAppToken();
            if (homeTask.isVisible() && homeApp != null) break block10;
            boolean bl = true;
            // MONITOREXIT : windowManagerGlobalLock
            WindowManagerService.resetPriorityAfterLockedSection();
            return bl;
        }
        boolean bl = !homeApp.allDrawn;
        // MONITOREXIT : windowManagerGlobalLock
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    public boolean deferScheduleMultiWindowModeChanged() {
        if (this.inPinnedWindowingMode()) {
            return this.mBoundsAnimatingRequested || this.mBoundsAnimating;
        }
        return false;
    }

    public boolean isForceScaled() {
        return this.mBoundsAnimating;
    }

    public boolean isAnimatingBounds() {
        return this.mBoundsAnimating;
    }

    public boolean lastAnimatingBoundsWasToFullscreen() {
        return this.mBoundsAnimatingToFullscreen;
    }

    public boolean isAnimatingBoundsToFullscreen() {
        return this.isAnimatingBounds() && this.lastAnimatingBoundsWasToFullscreen();
    }

    public boolean pinnedStackResizeDisallowed() {
        return this.mBoundsAnimating && this.mCancelCurrentBoundsAnimation;
    }

    @Override
    boolean checkCompleteDeferredRemoval() {
        if (this.isSelfOrChildAnimating()) {
            return true;
        }
        if (this.mDeferRemoval) {
            this.removeImmediately();
        }
        return super.checkCompleteDeferredRemoval();
    }

    @Override
    int getOrientation() {
        return this.canSpecifyOrientation() ? super.getOrientation() : -2;
    }

    private boolean canSpecifyOrientation() {
        int windowingMode = this.getWindowingMode();
        int activityType = this.getActivityType();
        return windowingMode == 1 || activityType == 2 || activityType == 3 || activityType == 4;
    }

    @Override
    Dimmer getDimmer() {
        return this.mDimmer;
    }

    @Override
    void prepareSurfaces() {
        this.mDimmer.resetDimStates();
        super.prepareSurfaces();
        this.getDimBounds(this.mTmpDimBoundsRect);
        this.mTmpDimBoundsRect.offsetTo(0, 0);
        if (this.mDimmer.updateDims(this.getPendingTransaction(), this.mTmpDimBoundsRect)) {
            this.scheduleAnimation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean setPinnedStackAlpha(float alpha) {
        SurfaceControl sc;
        block4: {
            boolean bl;
            WindowManagerGlobalLock windowManagerGlobalLock = this.mWmService.mGlobalLock;
            // MONITORENTER : windowManagerGlobalLock
            try {
                WindowManagerService.boostPriorityForLockedSection();
                sc = this.getSurfaceControl();
                if (sc != null && sc.isValid()) break block4;
                bl = false;
                // MONITOREXIT : windowManagerGlobalLock
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return bl;
        }
        this.getPendingTransaction().setAlpha(sc, this.mCancelCurrentBoundsAnimation ? 1.0f : alpha);
        this.scheduleAnimation();
        boolean bl = !this.mCancelCurrentBoundsAnimation;
        // MONITOREXIT : windowManagerGlobalLock
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    public DisplayInfo getDisplayInfo() {
        return this.mDisplayContent.getDisplayInfo();
    }

    void dim(float alpha) {
        this.mDimmer.dimAbove(this.getPendingTransaction(), alpha);
        this.scheduleAnimation();
    }

    void stopDimming() {
        this.mDimmer.stopDim(this.getPendingTransaction());
        this.scheduleAnimation();
    }

    AnimatingAppWindowTokenRegistry getAnimatingAppWindowTokenRegistry() {
        return this.mAnimatingAppWindowTokenRegistry;
    }

    private static /* synthetic */ void lambda$onAnimationStart$2(WindowState w) {
        w.mWinAnimator.resetDrawState();
    }
}

