/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceControl;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.WindowManagerService;

class Watermark {
    private final Display mDisplay;
    private final String[] mTokens;
    private final String mText;
    private final Paint mTextPaint;
    private final int mTextWidth;
    private final int mTextHeight;
    private final int mDeltaX;
    private final int mDeltaY;
    private final SurfaceControl mSurfaceControl;
    private final Surface mSurface = new Surface();
    private int mLastDW;
    private int mLastDH;
    private boolean mDrawNeeded;

    Watermark(DisplayContent dc, DisplayMetrics dm, String[] tokens) {
        this.mDisplay = dc.getDisplay();
        this.mTokens = tokens;
        StringBuilder builder = new StringBuilder(32);
        int len = this.mTokens[0].length();
        len &= 0xFFFFFFFE;
        for (int i = 0; i < len; i += 2) {
            int c1 = this.mTokens[0].charAt(i);
            int c2 = this.mTokens[0].charAt(i + 1);
            c1 = c1 >= 97 && c1 <= 102 ? c1 - 97 + 10 : (c1 >= 65 && c1 <= 70 ? c1 - 65 + 10 : (c1 -= 48));
            c2 = c2 >= 97 && c2 <= 102 ? c2 - 97 + 10 : (c2 >= 65 && c2 <= 70 ? c2 - 65 + 10 : (c2 -= 48));
            builder.append((char)(255 - (c1 * 16 + c2)));
        }
        this.mText = builder.toString();
        int fontSize = WindowManagerService.getPropertyInt(tokens, 1, 1, 20, dm);
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setTextSize(fontSize);
        this.mTextPaint.setTypeface(Typeface.create(Typeface.SANS_SERIF, 1));
        Paint.FontMetricsInt fm = this.mTextPaint.getFontMetricsInt();
        this.mTextWidth = (int)this.mTextPaint.measureText(this.mText);
        this.mTextHeight = fm.descent - fm.ascent;
        this.mDeltaX = WindowManagerService.getPropertyInt(tokens, 2, 0, this.mTextWidth * 2, dm);
        this.mDeltaY = WindowManagerService.getPropertyInt(tokens, 3, 0, this.mTextHeight * 3, dm);
        int shadowColor = WindowManagerService.getPropertyInt(tokens, 4, 0, -1342177280, dm);
        int color2 = WindowManagerService.getPropertyInt(tokens, 5, 0, 0x60FFFFFF, dm);
        int shadowRadius = WindowManagerService.getPropertyInt(tokens, 6, 0, 7, dm);
        int shadowDx = WindowManagerService.getPropertyInt(tokens, 8, 0, 0, dm);
        int shadowDy = WindowManagerService.getPropertyInt(tokens, 9, 0, 0, dm);
        this.mTextPaint.setColor(color2);
        this.mTextPaint.setShadowLayer((float)shadowRadius, (float)shadowDx, (float)shadowDy, shadowColor);
        SurfaceControl ctrl = null;
        try {
            ctrl = dc.makeOverlay().setName("WatermarkSurface").setBufferSize(1, 1).setFormat(-3).build();
            ctrl.setLayerStack(this.mDisplay.getLayerStack());
            ctrl.setLayer(1000000);
            ctrl.setPosition(0.0f, 0.0f);
            ctrl.show();
            this.mSurface.copyFrom(ctrl);
        }
        catch (Surface.OutOfResourcesException outOfResourcesException) {
            // empty catch block
        }
        this.mSurfaceControl = ctrl;
    }

    void positionSurface(int dw, int dh) {
        if (this.mLastDW != dw || this.mLastDH != dh) {
            this.mLastDW = dw;
            this.mLastDH = dh;
            this.mSurfaceControl.setBufferSize(dw, dh);
            this.mDrawNeeded = true;
        }
    }

    void drawIfNeeded() {
        if (this.mDrawNeeded) {
            int dw = this.mLastDW;
            int dh = this.mLastDH;
            this.mDrawNeeded = false;
            Rect dirty = new Rect(0, 0, dw, dh);
            Canvas c = null;
            try {
                c = this.mSurface.lockCanvas(dirty);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Surface.OutOfResourcesException outOfResourcesException) {
                // empty catch block
            }
            if (c != null) {
                c.drawColor(0, PorterDuff.Mode.CLEAR);
                int deltaX = this.mDeltaX;
                int deltaY = this.mDeltaY;
                int div = (dw + this.mTextWidth) / deltaX;
                int rem = dw + this.mTextWidth - div * deltaX;
                int qdelta = deltaX / 4;
                if (rem < qdelta || rem > deltaX - qdelta) {
                    deltaX += deltaX / 3;
                }
                int y = -this.mTextHeight;
                int x = -this.mTextWidth;
                while (y < dh + this.mTextHeight) {
                    c.drawText(this.mText, x, y, this.mTextPaint);
                    if ((x += deltaX) < dw) continue;
                    x -= dw + this.mTextWidth;
                    y += deltaY;
                }
                this.mSurface.unlockCanvasAndPost(c);
            }
        }
    }
}

