/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.SystemClock;
import android.util.proto.ProtoOutputStream;
import android.view.SurfaceControl;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.view.animation.TranslateAnimation;
import com.android.server.wm.LocalAnimationAdapter;
import java.io.PrintWriter;

public class WindowAnimationSpec
implements LocalAnimationAdapter.AnimationSpec {
    private Animation mAnimation;
    private final Point mPosition = new Point();
    private final ThreadLocal<TmpValues> mThreadLocalTmps = ThreadLocal.withInitial(() -> new TmpValues());
    private final boolean mCanSkipFirstFrame;
    private final boolean mIsAppAnimation;
    private final Rect mStackBounds = new Rect();
    private int mStackClipMode;
    private final Rect mTmpRect = new Rect();
    private final float mWindowCornerRadius;

    public WindowAnimationSpec(Animation animation, Point position, boolean canSkipFirstFrame, float windowCornerRadius) {
        this(animation, position, null, canSkipFirstFrame, 2, false, windowCornerRadius);
    }

    public WindowAnimationSpec(Animation animation, Point position, Rect stackBounds, boolean canSkipFirstFrame, int stackClipMode, boolean isAppAnimation, float windowCornerRadius) {
        this.mAnimation = animation;
        if (position != null) {
            this.mPosition.set(position.x, position.y);
        }
        this.mWindowCornerRadius = windowCornerRadius;
        this.mCanSkipFirstFrame = canSkipFirstFrame;
        this.mIsAppAnimation = isAppAnimation;
        this.mStackClipMode = stackClipMode;
        if (stackBounds != null) {
            this.mStackBounds.set(stackBounds);
        }
    }

    @Override
    public boolean getShowWallpaper() {
        return this.mAnimation.getShowWallpaper();
    }

    @Override
    public int getBackgroundColor() {
        return this.mAnimation.getBackgroundColor();
    }

    @Override
    public long getDuration() {
        return this.mAnimation.computeDurationHint();
    }

    @Override
    public void apply(SurfaceControl.Transaction t, SurfaceControl leash, long currentPlayTime) {
        TmpValues tmp = this.mThreadLocalTmps.get();
        tmp.transformation.clear();
        this.mAnimation.getTransformation(currentPlayTime, tmp.transformation);
        tmp.transformation.getMatrix().postTranslate(this.mPosition.x, this.mPosition.y);
        t.setMatrix(leash, tmp.transformation.getMatrix(), tmp.floats);
        t.setAlpha(leash, tmp.transformation.getAlpha());
        boolean cropSet = false;
        if (this.mStackClipMode == 2) {
            if (tmp.transformation.hasClipRect()) {
                t.setWindowCrop(leash, tmp.transformation.getClipRect());
                cropSet = true;
            }
        } else {
            this.mTmpRect.set(this.mStackBounds);
            if (tmp.transformation.hasClipRect()) {
                this.mTmpRect.intersect(tmp.transformation.getClipRect());
            }
            t.setWindowCrop(leash, this.mTmpRect);
            cropSet = true;
        }
        if (cropSet && this.mAnimation.hasRoundedCorners() && this.mWindowCornerRadius > 0.0f) {
            t.setCornerRadius(leash, this.mWindowCornerRadius);
        }
    }

    @Override
    public long calculateStatusBarTransitionStartTime() {
        TranslateAnimation openTranslateAnimation = WindowAnimationSpec.findTranslateAnimation(this.mAnimation);
        if (openTranslateAnimation != null) {
            float t = WindowAnimationSpec.findAlmostThereFraction(openTranslateAnimation.getInterpolator());
            return SystemClock.uptimeMillis() + openTranslateAnimation.getStartOffset() + (long)((float)openTranslateAnimation.getDuration() * t) - 120L;
        }
        return SystemClock.uptimeMillis();
    }

    @Override
    public boolean canSkipFirstFrame() {
        return this.mCanSkipFirstFrame;
    }

    @Override
    public boolean needsEarlyWakeup() {
        return this.mIsAppAnimation;
    }

    @Override
    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println(this.mAnimation);
    }

    @Override
    public void writeToProtoInner(ProtoOutputStream proto) {
        long token = proto.start(0x10B00000001L);
        proto.write(0x10900000001L, this.mAnimation.toString());
        proto.end(token);
    }

    private static TranslateAnimation findTranslateAnimation(Animation animation) {
        if (animation instanceof TranslateAnimation) {
            return (TranslateAnimation)animation;
        }
        if (animation instanceof AnimationSet) {
            AnimationSet set = (AnimationSet)animation;
            for (int i = 0; i < set.getAnimations().size(); ++i) {
                Animation a = set.getAnimations().get(i);
                if (!(a instanceof TranslateAnimation)) continue;
                return (TranslateAnimation)a;
            }
        }
        return null;
    }

    private static float findAlmostThereFraction(Interpolator interpolator2) {
        float val = 0.5f;
        for (float adj = 0.25f; adj >= 0.01f; adj /= 2.0f) {
            if (interpolator2.getInterpolation(val) < 0.99f) {
                val += adj;
                continue;
            }
            val -= adj;
        }
        return val;
    }

    private static class TmpValues {
        final Transformation transformation = new Transformation();
        final float[] floats = new float[9];

        private TmpValues() {
        }
    }
}

