/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.SystemClock;
import android.util.proto.ProtoOutputStream;
import android.view.DisplayInfo;
import android.view.SurfaceControl;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.ClipRectAnimation;
import android.view.animation.ScaleAnimation;
import android.view.animation.Transformation;
import android.view.animation.TranslateAnimation;
import com.android.server.wm.LocalAnimationAdapter;
import java.io.PrintWriter;

public class WindowChangeAnimationSpec
implements LocalAnimationAdapter.AnimationSpec {
    private final ThreadLocal<TmpValues> mThreadLocalTmps = ThreadLocal.withInitial(() -> new TmpValues());
    private final boolean mIsAppAnimation;
    private final Rect mStartBounds;
    private final Rect mEndBounds;
    private final Rect mTmpRect = new Rect();
    private Animation mAnimation;
    private final boolean mIsThumbnail;
    static final int ANIMATION_DURATION = 336;

    public WindowChangeAnimationSpec(Rect startBounds, Rect endBounds, DisplayInfo displayInfo, float durationScale, boolean isAppAnimation, boolean isThumbnail) {
        this.mStartBounds = new Rect(startBounds);
        this.mEndBounds = new Rect(endBounds);
        this.mIsAppAnimation = isAppAnimation;
        this.mIsThumbnail = isThumbnail;
        this.createBoundsInterpolator((int)(336.0f * durationScale), displayInfo);
    }

    @Override
    public boolean getShowWallpaper() {
        return false;
    }

    @Override
    public int getBackgroundColor() {
        return 0;
    }

    @Override
    public long getDuration() {
        return this.mAnimation.getDuration();
    }

    private void createBoundsInterpolator(long duration, DisplayInfo displayInfo) {
        boolean growing = this.mEndBounds.width() - this.mStartBounds.width() + this.mEndBounds.height() - this.mStartBounds.height() >= 0;
        float scalePart = 0.7f;
        long scalePeriod = (long)((float)duration * scalePart);
        float startScaleX = scalePart * (float)this.mStartBounds.width() / (float)this.mEndBounds.width() + (1.0f - scalePart);
        float startScaleY = scalePart * (float)this.mStartBounds.height() / (float)this.mEndBounds.height() + (1.0f - scalePart);
        if (this.mIsThumbnail) {
            AnimationSet animSet = new AnimationSet(true);
            Animation anim2 = new AlphaAnimation(1.0f, 0.0f);
            anim2.setDuration(scalePeriod);
            if (!growing) {
                anim2.setStartOffset(duration - scalePeriod);
            }
            animSet.addAnimation(anim2);
            float endScaleX = 1.0f / startScaleX;
            float endScaleY = 1.0f / startScaleY;
            anim2 = new ScaleAnimation(endScaleX, endScaleX, endScaleY, endScaleY);
            anim2.setDuration(duration);
            animSet.addAnimation(anim2);
            this.mAnimation = animSet;
            this.mAnimation.initialize(this.mStartBounds.width(), this.mStartBounds.height(), this.mEndBounds.width(), this.mEndBounds.height());
        } else {
            AnimationSet animSet = new AnimationSet(true);
            ScaleAnimation scaleAnim = new ScaleAnimation(startScaleX, 1.0f, startScaleY, 1.0f);
            scaleAnim.setDuration(scalePeriod);
            if (!growing) {
                scaleAnim.setStartOffset(duration - scalePeriod);
            }
            animSet.addAnimation(scaleAnim);
            TranslateAnimation translateAnim = new TranslateAnimation(this.mStartBounds.left, this.mEndBounds.left, this.mStartBounds.top, this.mEndBounds.top);
            translateAnim.setDuration(duration);
            animSet.addAnimation(translateAnim);
            Rect startClip = new Rect(this.mStartBounds);
            Rect endClip = new Rect(this.mEndBounds);
            startClip.offsetTo(0, 0);
            endClip.offsetTo(0, 0);
            ClipRectAnimation clipAnim = new ClipRectAnimation(startClip, endClip);
            clipAnim.setDuration(duration);
            animSet.addAnimation(clipAnim);
            this.mAnimation = animSet;
            this.mAnimation.initialize(this.mStartBounds.width(), this.mStartBounds.height(), displayInfo.appWidth, displayInfo.appHeight);
        }
    }

    @Override
    public void apply(SurfaceControl.Transaction t, SurfaceControl leash, long currentPlayTime) {
        TmpValues tmp = this.mThreadLocalTmps.get();
        if (this.mIsThumbnail) {
            this.mAnimation.getTransformation(currentPlayTime, tmp.mTransformation);
            t.setMatrix(leash, tmp.mTransformation.getMatrix(), tmp.mFloats);
            t.setAlpha(leash, tmp.mTransformation.getAlpha());
        } else {
            this.mAnimation.getTransformation(currentPlayTime, tmp.mTransformation);
            Matrix matrix = tmp.mTransformation.getMatrix();
            t.setMatrix(leash, matrix, tmp.mFloats);
            tmp.mVecs[2] = 0.0f;
            tmp.mVecs[1] = 0.0f;
            tmp.mVecs[3] = 1.0f;
            tmp.mVecs[0] = 1.0f;
            matrix.mapVectors(tmp.mVecs);
            tmp.mVecs[0] = 1.0f / tmp.mVecs[0];
            tmp.mVecs[3] = 1.0f / tmp.mVecs[3];
            Rect clipRect = tmp.mTransformation.getClipRect();
            this.mTmpRect.left = (int)((float)clipRect.left * tmp.mVecs[0] + 0.5f);
            this.mTmpRect.right = (int)((float)clipRect.right * tmp.mVecs[0] + 0.5f);
            this.mTmpRect.top = (int)((float)clipRect.top * tmp.mVecs[3] + 0.5f);
            this.mTmpRect.bottom = (int)((float)clipRect.bottom * tmp.mVecs[3] + 0.5f);
            t.setWindowCrop(leash, this.mTmpRect);
        }
    }

    @Override
    public long calculateStatusBarTransitionStartTime() {
        long uptime = SystemClock.uptimeMillis();
        return Math.max(uptime, uptime + (long)((float)this.mAnimation.getDuration() * 0.99f) - 120L);
    }

    @Override
    public boolean canSkipFirstFrame() {
        return false;
    }

    @Override
    public boolean needsEarlyWakeup() {
        return this.mIsAppAnimation;
    }

    @Override
    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println(this.mAnimation.getDuration());
    }

    @Override
    public void writeToProtoInner(ProtoOutputStream proto) {
        long token = proto.start(0x10B00000001L);
        proto.write(0x10900000001L, this.mAnimation.toString());
        proto.end(token);
    }

    private static class TmpValues {
        final Transformation mTransformation = new Transformation();
        final float[] mFloats = new float[9];
        final float[] mVecs = new float[4];

        private TmpValues() {
        }
    }
}

