/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.util.proto.ProtoOutputStream;
import com.android.server.wm.utils.InsetUtils;
import com.android.server.wm.utils.WmDisplayCutout;
import java.io.PrintWriter;

public class WindowFrames {
    private static final StringBuilder sTmpSB = new StringBuilder();
    public final Rect mParentFrame = new Rect();
    public final Rect mDisplayFrame = new Rect();
    public final Rect mOverscanFrame = new Rect();
    public final Rect mVisibleFrame = new Rect();
    public final Rect mDecorFrame = new Rect();
    public final Rect mContentFrame = new Rect();
    public final Rect mStableFrame = new Rect();
    public final Rect mOutsetFrame = new Rect();
    final Rect mContainingFrame = new Rect();
    final Rect mFrame = new Rect();
    final Rect mLastFrame = new Rect();
    private boolean mFrameSizeChanged = false;
    final Rect mCompatFrame = new Rect();
    private boolean mParentFrameWasClippedByDisplayCutout;
    WmDisplayCutout mDisplayCutout = WmDisplayCutout.NO_CUTOUT;
    private WmDisplayCutout mLastDisplayCutout = WmDisplayCutout.NO_CUTOUT;
    private boolean mDisplayCutoutChanged;
    final Rect mOverscanInsets = new Rect();
    final Rect mLastOverscanInsets = new Rect();
    private boolean mOverscanInsetsChanged;
    final Rect mStableInsets = new Rect();
    final Rect mLastStableInsets = new Rect();
    private boolean mStableInsetsChanged;
    final Rect mOutsets = new Rect();
    final Rect mLastOutsets = new Rect();
    private boolean mOutsetsChanged = false;
    final Rect mVisibleInsets = new Rect();
    final Rect mLastVisibleInsets = new Rect();
    private boolean mVisibleInsetsChanged;
    final Rect mContentInsets = new Rect();
    final Rect mLastContentInsets = new Rect();
    private boolean mContentInsetsChanged;
    private final Rect mTmpRect = new Rect();
    private boolean mHasOutsets;
    private boolean mContentChanged;

    public WindowFrames() {
    }

    public WindowFrames(Rect parentFrame, Rect displayFrame, Rect overscanFrame, Rect contentFrame, Rect visibleFrame, Rect decorFrame, Rect stableFrame, Rect outsetFrame) {
        this.setFrames(parentFrame, displayFrame, overscanFrame, contentFrame, visibleFrame, decorFrame, stableFrame, outsetFrame);
    }

    public void setFrames(Rect parentFrame, Rect displayFrame, Rect overscanFrame, Rect contentFrame, Rect visibleFrame, Rect decorFrame, Rect stableFrame, Rect outsetFrame) {
        this.mParentFrame.set(parentFrame);
        this.mDisplayFrame.set(displayFrame);
        this.mOverscanFrame.set(overscanFrame);
        this.mContentFrame.set(contentFrame);
        this.mVisibleFrame.set(visibleFrame);
        this.mDecorFrame.set(decorFrame);
        this.mStableFrame.set(stableFrame);
        this.mOutsetFrame.set(outsetFrame);
    }

    public void setParentFrameWasClippedByDisplayCutout(boolean parentFrameWasClippedByDisplayCutout) {
        this.mParentFrameWasClippedByDisplayCutout = parentFrameWasClippedByDisplayCutout;
    }

    boolean parentFrameWasClippedByDisplayCutout() {
        return this.mParentFrameWasClippedByDisplayCutout;
    }

    public void setDisplayCutout(WmDisplayCutout displayCutout) {
        this.mDisplayCutout = displayCutout;
    }

    private boolean didFrameSizeChange() {
        return this.mLastFrame.width() != this.mFrame.width() || this.mLastFrame.height() != this.mFrame.height();
    }

    void calculateOutsets() {
        if (this.mHasOutsets) {
            InsetUtils.insetsBetweenFrames(this.mOutsetFrame, this.mContentFrame, this.mOutsets);
        }
    }

    void calculateDockedDividerInsets(Rect cutoutInsets) {
        this.mTmpRect.set(this.mDisplayFrame);
        this.mTmpRect.inset(cutoutInsets);
        this.mTmpRect.intersectUnchecked(this.mStableFrame);
        InsetUtils.insetsBetweenFrames(this.mDisplayFrame, this.mTmpRect, this.mStableInsets);
        this.mContentInsets.setEmpty();
        this.mVisibleInsets.setEmpty();
        this.mDisplayCutout = WmDisplayCutout.NO_CUTOUT;
    }

    void calculateInsets(boolean windowsAreFloating, boolean inFullscreenContainer, Rect windowBounds) {
        boolean overrideRightInset = !windowsAreFloating && !inFullscreenContainer && this.mFrame.right > windowBounds.right;
        boolean overrideBottomInset = !windowsAreFloating && !inFullscreenContainer && this.mFrame.bottom > windowBounds.bottom;
        this.mTmpRect.set(this.mFrame.left, this.mFrame.top, overrideRightInset ? windowBounds.right : this.mFrame.right, overrideBottomInset ? windowBounds.bottom : this.mFrame.bottom);
        InsetUtils.insetsBetweenFrames(this.mTmpRect, this.mContentFrame, this.mContentInsets);
        InsetUtils.insetsBetweenFrames(this.mTmpRect, this.mVisibleFrame, this.mVisibleInsets);
        InsetUtils.insetsBetweenFrames(this.mTmpRect, this.mStableFrame, this.mStableInsets);
    }

    void scaleInsets(float scale) {
        this.mOverscanInsets.scale(scale);
        this.mContentInsets.scale(scale);
        this.mVisibleInsets.scale(scale);
        this.mStableInsets.scale(scale);
        this.mOutsets.scale(scale);
    }

    void offsetFrames(int layoutXDiff, int layoutYDiff) {
        this.mFrame.offset(layoutXDiff, layoutYDiff);
        this.mContentFrame.offset(layoutXDiff, layoutYDiff);
        this.mVisibleFrame.offset(layoutXDiff, layoutYDiff);
        this.mStableFrame.offset(layoutXDiff, layoutYDiff);
    }

    boolean setReportResizeHints() {
        this.mOverscanInsetsChanged |= !this.mLastOverscanInsets.equals(this.mOverscanInsets);
        this.mContentInsetsChanged |= !this.mLastContentInsets.equals(this.mContentInsets);
        this.mVisibleInsetsChanged |= !this.mLastVisibleInsets.equals(this.mVisibleInsets);
        this.mStableInsetsChanged |= !this.mLastStableInsets.equals(this.mStableInsets);
        this.mOutsetsChanged |= !this.mLastOutsets.equals(this.mOutsets);
        this.mFrameSizeChanged |= this.didFrameSizeChange();
        this.mDisplayCutoutChanged |= !this.mLastDisplayCutout.equals(this.mDisplayCutout);
        return this.mOverscanInsetsChanged || this.mContentInsetsChanged || this.mVisibleInsetsChanged || this.mStableInsetsChanged || this.mOutsetsChanged || this.mFrameSizeChanged || this.mDisplayCutoutChanged;
    }

    void resetInsetsChanged() {
        this.mOverscanInsetsChanged = false;
        this.mContentInsetsChanged = false;
        this.mVisibleInsetsChanged = false;
        this.mStableInsetsChanged = false;
        this.mOutsetsChanged = false;
        this.mFrameSizeChanged = false;
        this.mDisplayCutoutChanged = false;
    }

    void updateLastInsetValues() {
        this.mLastOverscanInsets.set(this.mOverscanInsets);
        this.mLastContentInsets.set(this.mContentInsets);
        this.mLastVisibleInsets.set(this.mVisibleInsets);
        this.mLastStableInsets.set(this.mStableInsets);
        this.mLastOutsets.set(this.mOutsets);
        this.mLastDisplayCutout = this.mDisplayCutout;
    }

    void resetLastContentInsets() {
        this.mLastContentInsets.set(-1, -1, -1, -1);
    }

    public void setHasOutsets(boolean hasOutsets) {
        if (this.mHasOutsets == hasOutsets) {
            return;
        }
        this.mHasOutsets = hasOutsets;
        if (!hasOutsets) {
            this.mOutsets.setEmpty();
        }
    }

    public void setContentChanged(boolean contentChanged) {
        this.mContentChanged = contentChanged;
    }

    boolean hasContentChanged() {
        return this.mContentChanged;
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        this.mParentFrame.writeToProto(proto, 1146756268040L);
        this.mContentFrame.writeToProto(proto, 1146756268034L);
        this.mDisplayFrame.writeToProto(proto, 1146756268036L);
        this.mOverscanFrame.writeToProto(proto, 1146756268039L);
        this.mVisibleFrame.writeToProto(proto, 1146756268041L);
        this.mDecorFrame.writeToProto(proto, 1146756268035L);
        this.mOutsetFrame.writeToProto(proto, 1146756268038L);
        this.mContainingFrame.writeToProto(proto, 0x10B00000001L);
        this.mFrame.writeToProto(proto, 1146756268037L);
        this.mDisplayCutout.getDisplayCutout().writeToProto(proto, 1146756268042L);
        this.mContentInsets.writeToProto(proto, 0x10B0000000BL);
        this.mOverscanInsets.writeToProto(proto, 1146756268044L);
        this.mVisibleInsets.writeToProto(proto, 1146756268045L);
        this.mStableInsets.writeToProto(proto, 1146756268046L);
        this.mOutsets.writeToProto(proto, 1146756268047L);
        proto.end(token);
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "Frames: containing=" + this.mContainingFrame.toShortString(sTmpSB) + " parent=" + this.mParentFrame.toShortString(sTmpSB));
        pw.println(prefix + "    display=" + this.mDisplayFrame.toShortString(sTmpSB) + " overscan=" + this.mOverscanFrame.toShortString(sTmpSB));
        pw.println(prefix + "    content=" + this.mContentFrame.toShortString(sTmpSB) + " visible=" + this.mVisibleFrame.toShortString(sTmpSB));
        pw.println(prefix + "    decor=" + this.mDecorFrame.toShortString(sTmpSB));
        pw.println(prefix + "    outset=" + this.mOutsetFrame.toShortString(sTmpSB));
        pw.println(prefix + "mFrame=" + this.mFrame.toShortString(sTmpSB) + " last=" + this.mLastFrame.toShortString(sTmpSB));
        pw.println(prefix + " cutout=" + this.mDisplayCutout.getDisplayCutout() + " last=" + this.mLastDisplayCutout.getDisplayCutout());
        pw.print(prefix + "Cur insets: overscan=" + this.mOverscanInsets.toShortString(sTmpSB) + " content=" + this.mContentInsets.toShortString(sTmpSB) + " visible=" + this.mVisibleInsets.toShortString(sTmpSB) + " stable=" + this.mStableInsets.toShortString(sTmpSB) + " outsets=" + this.mOutsets.toShortString(sTmpSB));
        pw.println(prefix + "Lst insets: overscan=" + this.mLastOverscanInsets.toShortString(sTmpSB) + " content=" + this.mLastContentInsets.toShortString(sTmpSB) + " visible=" + this.mLastVisibleInsets.toShortString(sTmpSB) + " stable=" + this.mLastStableInsets.toShortString(sTmpSB) + " outset=" + this.mLastOutsets.toShortString(sTmpSB));
    }

    String getInsetsInfo() {
        return "ci=" + this.mContentInsets.toShortString() + " vi=" + this.mVisibleInsets.toShortString() + " si=" + this.mStableInsets.toShortString() + " of=" + this.mOutsets.toShortString();
    }

    String getInsetsChangedInfo() {
        return "contentInsetsChanged=" + this.mContentInsetsChanged + " " + this.mContentInsets.toShortString() + " visibleInsetsChanged=" + this.mVisibleInsetsChanged + " " + this.mVisibleInsets.toShortString() + " stableInsetsChanged=" + this.mStableInsetsChanged + " " + this.mStableInsets.toShortString() + " outsetsChanged=" + this.mOutsetsChanged + " " + this.mOutsets.toShortString() + " displayCutoutChanged=" + this.mDisplayCutoutChanged;
    }
}

