/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.os.RemoteException;
import android.os.ShellCommand;
import android.view.IWindowManager;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WindowManagerShellCommand
extends ShellCommand {
    private final IWindowManager mInterface;
    private final WindowManagerService mInternal;

    public WindowManagerShellCommand(WindowManagerService service) {
        this.mInterface = service;
        this.mInternal = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        try {
            switch (cmd) {
                case "size": {
                    return this.runDisplaySize(pw);
                }
                case "density": {
                    return this.runDisplayDensity(pw);
                }
                case "folded-area": {
                    return this.runDisplayFoldedArea(pw);
                }
                case "overscan": {
                    return this.runDisplayOverscan(pw);
                }
                case "scaling": {
                    return this.runDisplayScaling(pw);
                }
                case "dismiss-keyguard": {
                    return this.runDismissKeyguard(pw);
                }
                case "tracing": {
                    return this.mInternal.mWindowTracing.onShellCommand(this);
                }
                case "set-user-rotation": {
                    return this.runSetDisplayUserRotation(pw);
                }
                case "set-fix-to-user-rotation": {
                    return this.runSetFixToUserRotation(pw);
                }
            }
            return this.handleDefaultCommands(cmd);
        }
        catch (RemoteException e) {
            pw.println("Remote exception: " + e);
            return -1;
        }
    }

    private int getDisplayId(String opt) {
        String option;
        int displayId = 0;
        String string2 = option = "-d".equals(opt) ? opt : this.getNextOption();
        if (option != null && "-d".equals(option)) {
            try {
                displayId = Integer.parseInt(this.getNextArgRequired());
            }
            catch (NumberFormatException e) {
                this.getErrPrintWriter().println("Error: bad number " + e);
            }
            catch (IllegalArgumentException e) {
                this.getErrPrintWriter().println("Error: " + e);
            }
        }
        return displayId;
    }

    private void printInitialDisplaySize(PrintWriter pw, int displayId) {
        Point initialSize = new Point();
        Point baseSize = new Point();
        try {
            this.mInterface.getInitialDisplaySize(displayId, initialSize);
            this.mInterface.getBaseDisplaySize(displayId, baseSize);
            pw.println("Physical size: " + initialSize.x + "x" + initialSize.y);
            if (!initialSize.equals(baseSize)) {
                pw.println("Override size: " + baseSize.x + "x" + baseSize.y);
            }
        }
        catch (RemoteException e) {
            pw.println("Remote exception: " + e);
        }
    }

    private int runDisplaySize(PrintWriter pw) throws RemoteException {
        int w;
        int h;
        String size = this.getNextArg();
        int displayId = this.getDisplayId(size);
        if (size == null) {
            this.printInitialDisplaySize(pw, displayId);
            return 0;
        }
        if ("-d".equals(size)) {
            this.printInitialDisplaySize(pw, displayId);
            return 0;
        }
        if ("reset".equals(size)) {
            h = -1;
            w = -1;
        } else {
            int div = size.indexOf(120);
            if (div <= 0 || div >= size.length() - 1) {
                this.getErrPrintWriter().println("Error: bad size " + size);
                return -1;
            }
            String wstr = size.substring(0, div);
            String hstr = size.substring(div + 1);
            try {
                w = this.parseDimension(wstr, displayId);
                h = this.parseDimension(hstr, displayId);
            }
            catch (NumberFormatException e) {
                this.getErrPrintWriter().println("Error: bad number " + e);
                return -1;
            }
        }
        if (w >= 0 && h >= 0) {
            this.mInterface.setForcedDisplaySize(displayId, w, h);
        } else {
            this.mInterface.clearForcedDisplaySize(displayId);
        }
        return 0;
    }

    private void printInitialDisplayDensity(PrintWriter pw, int displayId) {
        try {
            int initialDensity = this.mInterface.getInitialDisplayDensity(displayId);
            int baseDensity = this.mInterface.getBaseDisplayDensity(displayId);
            pw.println("Physical density: " + initialDensity);
            if (initialDensity != baseDensity) {
                pw.println("Override density: " + baseDensity);
            }
        }
        catch (RemoteException e) {
            pw.println("Remote exception: " + e);
        }
    }

    private int runDisplayDensity(PrintWriter pw) throws RemoteException {
        int density;
        String densityStr = this.getNextArg();
        int displayId = this.getDisplayId(densityStr);
        if (densityStr == null) {
            this.printInitialDisplayDensity(pw, displayId);
            return 0;
        }
        if ("-d".equals(densityStr)) {
            this.printInitialDisplayDensity(pw, displayId);
            return 0;
        }
        if ("reset".equals(densityStr)) {
            density = -1;
        } else {
            try {
                density = Integer.parseInt(densityStr);
            }
            catch (NumberFormatException e) {
                this.getErrPrintWriter().println("Error: bad number " + e);
                return -1;
            }
            if (density < 72) {
                this.getErrPrintWriter().println("Error: density must be >= 72");
                return -1;
            }
        }
        if (density > 0) {
            this.mInterface.setForcedDisplayDensityForUser(displayId, density, -2);
        } else {
            this.mInterface.clearForcedDisplayDensityForUser(displayId, -2);
        }
        return 0;
    }

    private void printFoldedArea(PrintWriter pw) {
        Rect foldedArea = this.mInternal.getFoldedArea();
        if (foldedArea.isEmpty()) {
            pw.println("Folded area: none");
        } else {
            pw.println("Folded area: " + foldedArea.left + "," + foldedArea.top + "," + foldedArea.right + "," + foldedArea.bottom);
        }
    }

    private int runDisplayFoldedArea(PrintWriter pw) {
        String areaStr = this.getNextArg();
        Rect rect = new Rect();
        if (areaStr == null) {
            this.printFoldedArea(pw);
            return 0;
        }
        if ("reset".equals(areaStr)) {
            rect.setEmpty();
        } else {
            Pattern flattenedPattern = Pattern.compile("(-?\\d+),(-?\\d+),(-?\\d+),(-?\\d+)");
            Matcher matcher = flattenedPattern.matcher(areaStr);
            if (!matcher.matches()) {
                this.getErrPrintWriter().println("Error: area should be LEFT,TOP,RIGHT,BOTTOM");
                return -1;
            }
            rect.set(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
        }
        this.mInternal.setOverrideFoldedArea(rect);
        return 0;
    }

    private int runDisplayOverscan(PrintWriter pw) throws RemoteException {
        String overscanStr = this.getNextArgRequired();
        Rect rect = new Rect();
        int displayId = this.getDisplayId(overscanStr);
        if ("reset".equals(overscanStr)) {
            rect.set(0, 0, 0, 0);
        } else {
            Pattern FLATTENED_PATTERN = Pattern.compile("(-?\\d+),(-?\\d+),(-?\\d+),(-?\\d+)");
            Matcher matcher = FLATTENED_PATTERN.matcher(overscanStr);
            if (!matcher.matches()) {
                this.getErrPrintWriter().println("Error: bad rectangle arg: " + overscanStr);
                return -1;
            }
            rect.left = Integer.parseInt(matcher.group(1));
            rect.top = Integer.parseInt(matcher.group(2));
            rect.right = Integer.parseInt(matcher.group(3));
            rect.bottom = Integer.parseInt(matcher.group(4));
        }
        this.mInterface.setOverscan(displayId, rect.left, rect.top, rect.right, rect.bottom);
        return 0;
    }

    private int runDisplayScaling(PrintWriter pw) throws RemoteException {
        String scalingStr = this.getNextArgRequired();
        if ("auto".equals(scalingStr)) {
            this.mInterface.setForcedDisplayScalingMode(this.getDisplayId(scalingStr), 0);
        } else if ("off".equals(scalingStr)) {
            this.mInterface.setForcedDisplayScalingMode(this.getDisplayId(scalingStr), 1);
        } else {
            this.getErrPrintWriter().println("Error: scaling must be 'auto' or 'off'");
            return -1;
        }
        return 0;
    }

    private int runDismissKeyguard(PrintWriter pw) throws RemoteException {
        this.mInterface.dismissKeyguard(null, null);
        return 0;
    }

    private int parseDimension(String s, int displayId) throws NumberFormatException {
        if (s.endsWith("px")) {
            return Integer.parseInt(s.substring(0, s.length() - 2));
        }
        if (s.endsWith("dp")) {
            int density;
            try {
                density = this.mInterface.getBaseDisplayDensity(displayId);
            }
            catch (RemoteException e) {
                density = 160;
            }
            return Integer.parseInt(s.substring(0, s.length() - 2)) * density / 160;
        }
        return Integer.parseInt(s);
    }

    private int runSetDisplayUserRotation(PrintWriter pw) {
        String lockMode = this.getNextArgRequired();
        int displayId = 0;
        String arg = this.getNextArg();
        if ("-d".equals(arg)) {
            displayId = Integer.parseInt(this.getNextArgRequired());
            arg = this.getNextArg();
        }
        if ("free".equals(lockMode)) {
            this.mInternal.thawDisplayRotation(displayId);
            return 0;
        }
        if (!lockMode.equals("lock")) {
            this.getErrPrintWriter().println("Error: lock mode needs to be either free or lock.");
            return -1;
        }
        try {
            int rotation = arg != null ? Integer.parseInt(arg) : 0;
            this.mInternal.freezeDisplayRotation(displayId, rotation);
            return 0;
        }
        catch (IllegalArgumentException e) {
            this.getErrPrintWriter().println("Error: " + e.getMessage());
            return -1;
        }
    }

    private int runSetFixToUserRotation(PrintWriter pw) {
        int fixedToUserRotation;
        int displayId = 0;
        String arg = this.getNextArgRequired();
        if ("-d".equals(arg)) {
            displayId = Integer.parseInt(this.getNextArgRequired());
            arg = this.getNextArgRequired();
        }
        switch (arg) {
            case "enabled": {
                fixedToUserRotation = 2;
                break;
            }
            case "disabled": {
                fixedToUserRotation = 1;
                break;
            }
            case "default": {
                fixedToUserRotation = 1;
                break;
            }
            default: {
                this.getErrPrintWriter().println("Error: expecting enabled, disabled or default, but we get " + arg);
                return -1;
            }
        }
        this.mInternal.setRotateForApp(displayId, fixedToUserRotation);
        return 0;
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("Window manager (window) commands:");
        pw.println("  help");
        pw.println("      Print this help text.");
        pw.println("  size [reset|WxH|WdpxHdp] [-d DISPLAY_ID]");
        pw.println("    Return or override display size.");
        pw.println("    width and height in pixels unless suffixed with 'dp'.");
        pw.println("  density [reset|DENSITY] [-d DISPLAY_ID]");
        pw.println("    Return or override display density.");
        pw.println("  folded-area [reset|LEFT,TOP,RIGHT,BOTTOM]");
        pw.println("    Return or override folded area.");
        pw.println("  overscan [reset|LEFT,TOP,RIGHT,BOTTOM] [-d DISPLAY ID]");
        pw.println("    Set overscan area for display.");
        pw.println("  scaling [off|auto] [-d DISPLAY_ID]");
        pw.println("    Set display scaling mode.");
        pw.println("  dismiss-keyguard");
        pw.println("    Dismiss the keyguard, prompting user for auth if\u00a0necessary.");
        pw.println("  set-user-rotation [free|lock] [-d DISPLAY_ID] [rotation]");
        pw.println("    Set user rotation mode and user rotation.");
        pw.println("  set-fix-to-user-rotation [-d DISPLAY_ID] [enabled|disabled]");
        pw.println("    Enable or disable rotating display for app requested orientation.");
        if (!Build.IS_USER) {
            pw.println("  tracing (start | stop)");
            pw.println("    Start or stop window tracing.");
        }
    }
}

