/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityThread;
import android.app.IApplicationThread;
import android.app.ProfilerInfo;
import android.app.servertransaction.ConfigurationChangeItem;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.Watchdog;
import com.android.server.am.ActivityManagerService;
import com.android.server.wm.ActivityDisplay;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.ConfigurationContainerListener;
import com.android.server.wm.TaskRecord;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowProcessListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class WindowProcessController
extends ConfigurationContainer<ConfigurationContainer>
implements ConfigurationContainerListener {
    private static final String TAG = "ActivityTaskManager";
    private static final String TAG_RELEASE = "ActivityTaskManager";
    private static final String TAG_CONFIGURATION = "ActivityTaskManager";
    final ApplicationInfo mInfo;
    final String mName;
    final int mUid;
    private volatile int mPid;
    final int mUserId;
    public final Object mOwner;
    final ArraySet<String> mPkgList = new ArraySet();
    private final WindowProcessListener mListener;
    private final ActivityTaskManagerService mAtm;
    private IApplicationThread mThread;
    private volatile int mCurSchedGroup;
    private volatile int mCurProcState = 21;
    private volatile int mRepProcState = 21;
    private volatile boolean mCrashing;
    private volatile boolean mNotResponding;
    private volatile boolean mPersistent;
    private volatile String mRequiredAbi;
    private volatile boolean mHasForegroundServices;
    private volatile boolean mHasForegroundActivities;
    private volatile boolean mHasClientActivities;
    private volatile boolean mHasTopUi;
    private volatile boolean mHasOverlayUi;
    private volatile boolean mPendingUiClean;
    private volatile long mInteractionEventTime;
    private volatile long mFgInteractionTime;
    private volatile long mWhenUnimportant;
    private volatile boolean mDebugging;
    private volatile boolean mInstrumenting;
    private volatile boolean mInstrumentingWithBackgroundActivityStartPrivileges;
    private volatile boolean mPerceptible;
    private volatile boolean mUsingWrapper;
    private volatile boolean mAllowBackgroundActivityStarts;
    private volatile ArraySet<Integer> mBoundClientUids = new ArraySet();
    int mVrThreadTid;
    private final ArrayList<ActivityRecord> mActivities = new ArrayList();
    private final ArrayList<TaskRecord> mRecentTasks = new ArrayList();
    private ActivityRecord mPreQTopResumedActivity = null;
    private long mLastActivityLaunchTime;
    private long mLastActivityFinishTime;
    private final Configuration mLastReportedConfiguration;
    private int mDisplayId;

    public WindowProcessController(ActivityTaskManagerService atm, ApplicationInfo info, String name, int uid, int userId, Object owner, WindowProcessListener listener) {
        this.mInfo = info;
        this.mName = name;
        this.mUid = uid;
        this.mUserId = userId;
        this.mOwner = owner;
        this.mListener = listener;
        this.mAtm = atm;
        this.mLastReportedConfiguration = new Configuration();
        this.mDisplayId = -1;
        if (atm != null) {
            this.onConfigurationChanged(atm.getGlobalConfiguration());
        }
    }

    public void setPid(int pid) {
        this.mPid = pid;
    }

    public int getPid() {
        return this.mPid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThread(IApplicationThread thread) {
        Object object = this.mAtm.mGlobalLockWithoutBoost;
        synchronized (object) {
            this.mThread = thread;
        }
    }

    IApplicationThread getThread() {
        return this.mThread;
    }

    boolean hasThread() {
        return this.mThread != null;
    }

    public void setCurrentSchedulingGroup(int curSchedGroup) {
        this.mCurSchedGroup = curSchedGroup;
    }

    int getCurrentSchedulingGroup() {
        return this.mCurSchedGroup;
    }

    public void setCurrentProcState(int curProcState) {
        this.mCurProcState = curProcState;
    }

    int getCurrentProcState() {
        return this.mCurProcState;
    }

    public void setReportedProcState(int repProcState) {
        this.mRepProcState = repProcState;
    }

    int getReportedProcState() {
        return this.mRepProcState;
    }

    public void setCrashing(boolean crashing) {
        this.mCrashing = crashing;
    }

    boolean isCrashing() {
        return this.mCrashing;
    }

    public void setNotResponding(boolean notResponding) {
        this.mNotResponding = notResponding;
    }

    boolean isNotResponding() {
        return this.mNotResponding;
    }

    public void setPersistent(boolean persistent) {
        this.mPersistent = persistent;
    }

    boolean isPersistent() {
        return this.mPersistent;
    }

    public void setHasForegroundServices(boolean hasForegroundServices) {
        this.mHasForegroundServices = hasForegroundServices;
    }

    boolean hasForegroundServices() {
        return this.mHasForegroundServices;
    }

    public void setHasForegroundActivities(boolean hasForegroundActivities) {
        this.mHasForegroundActivities = hasForegroundActivities;
    }

    boolean hasForegroundActivities() {
        return this.mHasForegroundActivities;
    }

    public void setHasClientActivities(boolean hasClientActivities) {
        this.mHasClientActivities = hasClientActivities;
    }

    boolean hasClientActivities() {
        return this.mHasClientActivities;
    }

    public void setHasTopUi(boolean hasTopUi) {
        this.mHasTopUi = hasTopUi;
    }

    boolean hasTopUi() {
        return this.mHasTopUi;
    }

    public void setHasOverlayUi(boolean hasOverlayUi) {
        this.mHasOverlayUi = hasOverlayUi;
    }

    boolean hasOverlayUi() {
        return this.mHasOverlayUi;
    }

    public void setPendingUiClean(boolean hasPendingUiClean) {
        this.mPendingUiClean = hasPendingUiClean;
    }

    boolean hasPendingUiClean() {
        return this.mPendingUiClean;
    }

    boolean registeredForDisplayConfigChanges() {
        return this.mDisplayId != -1;
    }

    void postPendingUiCleanMsg(boolean pendingUiClean) {
        if (this.mListener == null) {
            return;
        }
        Message m = PooledLambda.obtainMessage(WindowProcessListener::setPendingUiClean, this.mListener, pendingUiClean);
        this.mAtm.mH.sendMessage(m);
    }

    public void setInteractionEventTime(long interactionEventTime) {
        this.mInteractionEventTime = interactionEventTime;
    }

    long getInteractionEventTime() {
        return this.mInteractionEventTime;
    }

    public void setFgInteractionTime(long fgInteractionTime) {
        this.mFgInteractionTime = fgInteractionTime;
    }

    long getFgInteractionTime() {
        return this.mFgInteractionTime;
    }

    public void setWhenUnimportant(long whenUnimportant) {
        this.mWhenUnimportant = whenUnimportant;
    }

    long getWhenUnimportant() {
        return this.mWhenUnimportant;
    }

    public void setRequiredAbi(String requiredAbi) {
        this.mRequiredAbi = requiredAbi;
    }

    String getRequiredAbi() {
        return this.mRequiredAbi;
    }

    @VisibleForTesting
    int getDisplayId() {
        return this.mDisplayId;
    }

    public void setDebugging(boolean debugging) {
        this.mDebugging = debugging;
    }

    boolean isDebugging() {
        return this.mDebugging;
    }

    public void setUsingWrapper(boolean usingWrapper) {
        this.mUsingWrapper = usingWrapper;
    }

    boolean isUsingWrapper() {
        return this.mUsingWrapper;
    }

    void setLastActivityLaunchTime(long launchTime) {
        if (launchTime <= this.mLastActivityLaunchTime) {
            return;
        }
        this.mLastActivityLaunchTime = launchTime;
    }

    void setLastActivityFinishTimeIfNeeded(long finishTime) {
        if (finishTime <= this.mLastActivityFinishTime || !this.hasActivityInVisibleTask()) {
            return;
        }
        this.mLastActivityFinishTime = finishTime;
    }

    public void setAllowBackgroundActivityStarts(boolean allowBackgroundActivityStarts) {
        this.mAllowBackgroundActivityStarts = allowBackgroundActivityStarts;
    }

    boolean areBackgroundActivityStartsAllowed() {
        if (this.mAllowBackgroundActivityStarts) {
            return true;
        }
        long now = SystemClock.uptimeMillis();
        if (!(now - this.mLastActivityLaunchTime >= 10000L && now - this.mLastActivityFinishTime >= 10000L || this.mLastActivityLaunchTime <= this.mAtm.getLastStopAppSwitchesTime() && this.mLastActivityFinishTime <= this.mAtm.getLastStopAppSwitchesTime())) {
            return true;
        }
        if (this.mInstrumentingWithBackgroundActivityStartPrivileges) {
            return true;
        }
        if (this.hasActivityInVisibleTask()) {
            return true;
        }
        return this.isBoundByForegroundUid();
    }

    private boolean isBoundByForegroundUid() {
        for (int i = this.mBoundClientUids.size() - 1; i >= 0; --i) {
            if (!this.mAtm.isUidForeground(this.mBoundClientUids.valueAt(i))) continue;
            return true;
        }
        return false;
    }

    public void setBoundClientUids(ArraySet<Integer> boundClientUids) {
        this.mBoundClientUids = boundClientUids;
    }

    public void setInstrumenting(boolean instrumenting, boolean hasBackgroundActivityStartPrivileges) {
        this.mInstrumenting = instrumenting;
        this.mInstrumentingWithBackgroundActivityStartPrivileges = hasBackgroundActivityStartPrivileges;
    }

    boolean isInstrumenting() {
        return this.mInstrumenting;
    }

    public void setPerceptible(boolean perceptible) {
        this.mPerceptible = perceptible;
    }

    boolean isPerceptible() {
        return this.mPerceptible;
    }

    @Override
    protected int getChildCount() {
        return 0;
    }

    @Override
    protected ConfigurationContainer getChildAt(int index) {
        return null;
    }

    @Override
    protected ConfigurationContainer getParent() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackage(String packageName) {
        Object object = this.mAtm.mGlobalLockWithoutBoost;
        synchronized (object) {
            this.mPkgList.add(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPackageList() {
        Object object = this.mAtm.mGlobalLockWithoutBoost;
        synchronized (object) {
            this.mPkgList.clear();
        }
    }

    void addActivityIfNeeded(ActivityRecord r) {
        this.setLastActivityLaunchTime(r.lastLaunchTime);
        if (this.mActivities.contains(r)) {
            return;
        }
        this.mActivities.add(r);
    }

    void removeActivity(ActivityRecord r) {
        this.mActivities.remove(r);
    }

    void makeFinishingForProcessRemoved() {
        for (int i = this.mActivities.size() - 1; i >= 0; --i) {
            this.mActivities.get(i).makeFinishingLocked();
        }
    }

    void clearActivities() {
        this.mActivities.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActivities() {
        Object object = this.mAtm.mGlobalLockWithoutBoost;
        synchronized (object) {
            return !this.mActivities.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasVisibleActivities() {
        Object object = this.mAtm.mGlobalLockWithoutBoost;
        synchronized (object) {
            for (int i = this.mActivities.size() - 1; i >= 0; --i) {
                ActivityRecord r = this.mActivities.get(i);
                if (!r.visible) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActivitiesOrRecentTasks() {
        Object object = this.mAtm.mGlobalLockWithoutBoost;
        synchronized (object) {
            return !this.mActivities.isEmpty() || !this.mRecentTasks.isEmpty();
        }
    }

    private boolean hasActivityInVisibleTask() {
        for (int i = this.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord topActivity;
            TaskRecord task = this.mActivities.get(i).getTaskRecord();
            if (task == null || (topActivity = task.getTopActivity()) == null || !topActivity.visible && !topActivity.isState(ActivityStack.ActivityState.INITIALIZING)) continue;
            return true;
        }
        return false;
    }

    boolean updateTopResumingActivityInProcessIfNeeded(ActivityRecord activity) {
        ActivityDisplay topDisplay;
        if (this.mInfo.targetSdkVersion >= 29 || this.mPreQTopResumedActivity == activity) {
            return true;
        }
        ActivityDisplay display = activity.getDisplay();
        if (display == null) {
            return false;
        }
        boolean canUpdate = false;
        ActivityDisplay activityDisplay = topDisplay = this.mPreQTopResumedActivity != null ? this.mPreQTopResumedActivity.getDisplay() : null;
        if (topDisplay == null || !this.mPreQTopResumedActivity.visible) {
            canUpdate = true;
        }
        if (!canUpdate && topDisplay.mDisplayContent.compareTo(display.mDisplayContent) < 0) {
            canUpdate = true;
        }
        if (display == topDisplay && ((ActivityStack)this.mPreQTopResumedActivity.getActivityStack()).mTaskStack.compareTo(((ActivityStack)activity.getActivityStack()).mTaskStack) <= 0) {
            canUpdate = true;
        }
        if (canUpdate) {
            Object stack;
            if (this.mPreQTopResumedActivity != null && this.mPreQTopResumedActivity.isState(ActivityStack.ActivityState.RESUMED) && (stack = this.mPreQTopResumedActivity.getActivityStack()) != null) {
                ((ActivityStack)stack).startPausingLocked(false, false, null, false);
            }
            this.mPreQTopResumedActivity = activity;
        }
        return canUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFreezingActivities() {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mAtm.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                int i = this.mActivities.size();
                while (i > 0) {
                    this.mActivities.get(--i).stopFreezingScreenLocked(true);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void finishActivities() {
        ArrayList<ActivityRecord> activities = new ArrayList<ActivityRecord>(this.mActivities);
        for (int i = 0; i < activities.size(); ++i) {
            ActivityRecord r = activities.get(i);
            if (r.finishing || !r.isInStackLocked()) continue;
            ((ActivityStack)r.getActivityStack()).finishActivityLocked(r, 0, null, "finish-heavy", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterestingToUser() {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mAtm.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            boolean bl;
            try {
                WindowManagerService.boostPriorityForLockedSection();
                int size = this.mActivities.size();
                for (int i = 0; i < size; ++i) {
                    ActivityRecord r = this.mActivities.get(i);
                    if (!r.isInterestingToUserLocked()) break block5;
                    bl = true;
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl18 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            {
                block5: {
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return bl;
                }
                continue;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRunningActivity(String packageName) {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mAtm.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            boolean bl;
            try {
                WindowManagerService.boostPriorityForLockedSection();
                for (int i = this.mActivities.size() - 1; i >= 0; --i) {
                    ActivityRecord r = this.mActivities.get(i);
                    if (!packageName.equals(r.packageName)) break block5;
                    bl = true;
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 4] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            {
                block5: {
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return bl;
                }
                continue;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPackagePreferredForHomeActivities() {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mAtm.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                for (int i = this.mActivities.size() - 1; i >= 0; --i) {
                    ActivityRecord r = this.mActivities.get(i);
                    if (!r.isActivityTypeHome()) continue;
                    Log.i("ActivityTaskManager", "Clearing package preferred activities from " + r.packageName);
                    try {
                        ActivityThread.getPackageManager().clearPackagePreferredActivities(r.packageName);
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl19 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    boolean hasStartedActivity(ActivityRecord launchedActivity) {
        for (int i = this.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord activity = this.mActivities.get(i);
            if (launchedActivity == activity || activity.stopped) continue;
            return true;
        }
        return false;
    }

    void updateIntentForHeavyWeightActivity(Intent intent) {
        if (this.mActivities.isEmpty()) {
            return;
        }
        ActivityRecord hist = this.mActivities.get(0);
        intent.putExtra("cur_app", hist.packageName);
        intent.putExtra("cur_task", hist.getTaskRecord().taskId);
    }

    boolean shouldKillProcessForRemovedTask(TaskRecord tr) {
        for (int k = 0; k < this.mActivities.size(); ++k) {
            ActivityRecord activity = this.mActivities.get(k);
            if (!activity.stopped) {
                return false;
            }
            TaskRecord otherTask = activity.getTaskRecord();
            if (tr.taskId == otherTask.taskId || !otherTask.inRecents) continue;
            return false;
        }
        return true;
    }

    ArraySet<TaskRecord> getReleaseSomeActivitiesTasks() {
        TaskRecord firstTask = null;
        ArraySet<TaskRecord> tasks = null;
        for (int i = 0; i < this.mActivities.size(); ++i) {
            TaskRecord task;
            ActivityRecord r = this.mActivities.get(i);
            if (r.finishing || r.isState(ActivityStack.ActivityState.DESTROYING, ActivityStack.ActivityState.DESTROYED)) {
                return null;
            }
            if (r.visible || !r.stopped || !r.haveState || r.isState(ActivityStack.ActivityState.RESUMED, ActivityStack.ActivityState.PAUSING, ActivityStack.ActivityState.PAUSED, ActivityStack.ActivityState.STOPPING) || (task = r.getTaskRecord()) == null) continue;
            if (firstTask == null) {
                firstTask = task;
                continue;
            }
            if (firstTask == task) continue;
            if (tasks == null) {
                tasks = new ArraySet<TaskRecord>();
                tasks.add(firstTask);
            }
            tasks.add(task);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int computeOomAdjFromActivities(int minTaskLayer, ComputeOomAdjCallback callback) {
        Object object = this.mAtm.mGlobalLockWithoutBoost;
        synchronized (object) {
            int activitiesSize = this.mActivities.size();
            for (int j = 0; j < activitiesSize; ++j) {
                ActivityRecord r = this.mActivities.get(j);
                if (r.app != this) {
                    Log.e("ActivityTaskManager", "Found activity " + r + " in proc activity list using " + r.app + " instead of expected " + this);
                    if (r.app != null && r.app.mUid != this.mUid) continue;
                    r.setProcess(this);
                }
                if (r.visible) {
                    int layer;
                    callback.onVisibleActivity();
                    TaskRecord task = r.getTaskRecord();
                    if (task == null || minTaskLayer <= 0 || (layer = task.mLayerRank) < 0 || minTaskLayer <= layer) break;
                    minTaskLayer = layer;
                    break;
                }
                if (r.isState(ActivityStack.ActivityState.PAUSING, ActivityStack.ActivityState.PAUSED)) {
                    callback.onPausedActivity();
                    continue;
                }
                if (r.isState(ActivityStack.ActivityState.STOPPING)) {
                    callback.onStoppingActivity(r.finishing);
                    continue;
                }
                callback.onOtherActivity();
            }
        }
        return minTaskLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int computeRelaunchReason() {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mAtm.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            int n;
            try {
                WindowManagerService.boostPriorityForLockedSection();
                int activitiesSize = this.mActivities.size();
                for (int i = activitiesSize - 1; i >= 0; --i) {
                    ActivityRecord r = this.mActivities.get(i);
                    if (r.mRelaunchReason == 0) break block5;
                    n = r.mRelaunchReason;
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl18 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            {
                block5: {
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return n;
                }
                continue;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getInputDispatchingTimeout() {
        long l;
        WindowManagerGlobalLock windowManagerGlobalLock = this.mAtm.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                l = this.isInstrumenting() || this.isUsingWrapper() ? 60000L : 5000L;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return l;
    }

    void clearProfilerIfNeeded() {
        if (this.mListener == null) {
            return;
        }
        this.mAtm.mH.sendMessage(PooledLambda.obtainMessage(WindowProcessListener::clearProfilerIfNeeded, this.mListener));
    }

    void updateProcessInfo(boolean updateServiceConnectionActivities, boolean activityChange, boolean updateOomAdj) {
        if (this.mListener == null) {
            return;
        }
        Message m = PooledLambda.obtainMessage(WindowProcessListener::updateProcessInfo, this.mListener, updateServiceConnectionActivities, activityChange, updateOomAdj);
        this.mAtm.mH.sendMessage(m);
    }

    void updateServiceConnectionActivities() {
        if (this.mListener == null) {
            return;
        }
        this.mAtm.mH.sendMessage(PooledLambda.obtainMessage(WindowProcessListener::updateServiceConnectionActivities, this.mListener));
    }

    void setPendingUiCleanAndForceProcessStateUpTo(int newState) {
        if (this.mListener == null) {
            return;
        }
        Message m = PooledLambda.obtainMessage(WindowProcessListener::setPendingUiCleanAndForceProcessStateUpTo, this.mListener, newState);
        this.mAtm.mH.sendMessage(m);
    }

    boolean isRemoved() {
        return this.mListener == null ? false : this.mListener.isRemoved();
    }

    private boolean shouldSetProfileProc() {
        return this.mAtm.mProfileApp != null && this.mAtm.mProfileApp.equals(this.mName) && (this.mAtm.mProfileProc == null || this.mAtm.mProfileProc == this);
    }

    ProfilerInfo createProfilerInfoIfNeeded() {
        ProfilerInfo currentProfilerInfo = this.mAtm.mProfilerInfo;
        if (currentProfilerInfo == null || currentProfilerInfo.profileFile == null || !this.shouldSetProfileProc()) {
            return null;
        }
        if (currentProfilerInfo.profileFd != null) {
            try {
                currentProfilerInfo.profileFd = currentProfilerInfo.profileFd.dup();
            }
            catch (IOException e) {
                currentProfilerInfo.closeFd();
            }
        }
        return new ProfilerInfo(currentProfilerInfo);
    }

    void onStartActivity(int topProcessState, ActivityInfo info) {
        if (this.mListener == null) {
            return;
        }
        String packageName = null;
        if ((info.flags & 1) == 0 || !"android".equals(info.packageName)) {
            packageName = info.packageName;
        }
        Message m = PooledLambda.obtainMessage(WindowProcessListener::onStartActivity, this.mListener, topProcessState, this.shouldSetProfileProc(), packageName, info.applicationInfo.longVersionCode);
        this.mAtm.mH.sendMessageAtFrontOfQueue(m);
    }

    public void appDied() {
        if (this.mListener == null) {
            return;
        }
        Message m = PooledLambda.obtainMessage(WindowProcessListener::appDied, this.mListener);
        this.mAtm.mH.sendMessage(m);
    }

    void registerDisplayConfigurationListenerLocked(ActivityDisplay activityDisplay) {
        if (activityDisplay == null) {
            return;
        }
        this.unregisterDisplayConfigurationListenerLocked();
        this.mDisplayId = activityDisplay.mDisplayId;
        activityDisplay.registerConfigurationChangeListener(this);
    }

    @VisibleForTesting
    void unregisterDisplayConfigurationListenerLocked() {
        if (this.mDisplayId == -1) {
            return;
        }
        ActivityDisplay activityDisplay = this.mAtm.mRootActivityContainer.getActivityDisplay(this.mDisplayId);
        if (activityDisplay != null) {
            activityDisplay.unregisterConfigurationChangeListener(this);
        }
        this.mDisplayId = -1;
    }

    @Override
    public void onConfigurationChanged(Configuration newGlobalConfig) {
        super.onConfigurationChanged(newGlobalConfig);
        this.updateConfiguration();
    }

    @Override
    public void onRequestedOverrideConfigurationChanged(Configuration newOverrideConfig) {
        super.onRequestedOverrideConfigurationChanged(newOverrideConfig);
        this.updateConfiguration();
    }

    private void updateConfiguration() {
        Configuration config = this.getConfiguration();
        if (this.mLastReportedConfiguration.diff(config) == 0) {
            return;
        }
        try {
            if (this.mThread == null) {
                return;
            }
            config.seq = this.mAtm.increaseConfigurationSeqLocked();
            this.mAtm.getLifecycleManager().scheduleTransaction(this.mThread, ConfigurationChangeItem.obtain(config));
            this.setLastReportedConfiguration(config);
        }
        catch (Exception e) {
            Slog.e("ActivityTaskManager", "Failed to schedule configuration change", e);
        }
    }

    private void setLastReportedConfiguration(Configuration config) {
        this.mLastReportedConfiguration.setTo(config);
    }

    Configuration getLastReportedConfiguration() {
        return this.mLastReportedConfiguration;
    }

    public long getCpuTime() {
        return this.mListener != null ? this.mListener.getCpuTime() : 0L;
    }

    void addRecentTask(TaskRecord task) {
        this.mRecentTasks.add(task);
    }

    void removeRecentTask(TaskRecord task) {
        this.mRecentTasks.remove(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRecentTasks() {
        Object object = this.mAtm.mGlobalLockWithoutBoost;
        synchronized (object) {
            return !this.mRecentTasks.isEmpty();
        }
    }

    void clearRecentTasks() {
        for (int i = this.mRecentTasks.size() - 1; i >= 0; --i) {
            this.mRecentTasks.get(i).clearRootProcess();
        }
        this.mRecentTasks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void appEarlyNotResponding(String annotation, Runnable killAppCallback) {
        block7: {
            WindowManagerGlobalLock windowManagerGlobalLock = this.mAtm.mGlobalLock;
            // MONITORENTER : windowManagerGlobalLock
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mAtm.mController != null) break block7;
                // MONITOREXIT : windowManagerGlobalLock
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        try {
            int res = this.mAtm.mController.appEarlyNotResponding(this.mName, this.mPid, annotation);
            if (res < 0 && this.mPid != ActivityManagerService.MY_PID) {
                killAppCallback.run();
            }
        }
        catch (RemoteException e) {
            this.mAtm.mController = null;
            Watchdog.getInstance().setActivityController(null);
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean appNotResponding(String info, Runnable killAppCallback, Runnable serviceTimeoutCallback) {
        Runnable targetRunnable;
        block8: {
            boolean bl;
            targetRunnable = null;
            WindowManagerGlobalLock windowManagerGlobalLock = this.mAtm.mGlobalLock;
            // MONITORENTER : windowManagerGlobalLock
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mAtm.mController != null) break block8;
                bl = false;
                // MONITOREXIT : windowManagerGlobalLock
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return bl;
        }
        try {
            int res = this.mAtm.mController.appNotResponding(this.mName, this.mPid, info);
            if (res != 0) {
                targetRunnable = res < 0 && this.mPid != ActivityManagerService.MY_PID ? killAppCallback : serviceTimeoutCallback;
            }
        }
        catch (RemoteException e) {
            this.mAtm.mController = null;
            Watchdog.getInstance().setActivityController(null);
            // MONITOREXIT : windowManagerGlobalLock
            WindowManagerService.resetPriorityAfterLockedSection();
            return false;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        if (targetRunnable == null) return false;
        targetRunnable.run();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTopProcChanged() {
        Object object = this.mAtm.mGlobalLockWithoutBoost;
        synchronized (object) {
            this.mAtm.mVrController.onTopProcChangedLocked(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHomeProcess() {
        Object object = this.mAtm.mGlobalLockWithoutBoost;
        synchronized (object) {
            return this == this.mAtm.mHomeProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPreviousProcess() {
        Object object = this.mAtm.mGlobalLockWithoutBoost;
        synchronized (object) {
            return this == this.mAtm.mPreviousProcess;
        }
    }

    public String toString() {
        return this.mOwner != null ? this.mOwner.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix) {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mAtm.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                int i;
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mActivities.size() > 0) {
                    pw.print(prefix);
                    pw.println("Activities:");
                    for (i = 0; i < this.mActivities.size(); ++i) {
                        pw.print(prefix);
                        pw.print("  - ");
                        pw.println(this.mActivities.get(i));
                    }
                }
                if (this.mRecentTasks.size() > 0) {
                    pw.println(prefix + "Recent Tasks:");
                    for (i = 0; i < this.mRecentTasks.size(); ++i) {
                        pw.println(prefix + "  - " + this.mRecentTasks.get(i));
                    }
                }
                if (this.mVrThreadTid != 0) {
                    pw.print(prefix);
                    pw.print("mVrThreadTid=");
                    pw.println(this.mVrThreadTid);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl25 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        pw.println(prefix + " Configuration=" + this.getConfiguration());
        pw.println(prefix + " OverrideConfiguration=" + this.getRequestedOverrideConfiguration());
        pw.println(prefix + " mLastReportedConfiguration=" + this.mLastReportedConfiguration);
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        if (this.mListener != null) {
            this.mListener.writeToProto(proto, fieldId);
        }
    }

    public static interface ComputeOomAdjCallback {
        public void onVisibleActivity();

        public void onPausedActivity();

        public void onStoppingActivity(boolean var1);

        public void onOtherActivity();
    }
}

