/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.util.ArraySet;
import android.util.SparseArray;
import com.android.server.wm.WindowProcessController;
import java.util.HashMap;
import java.util.Map;

final class WindowProcessControllerMap {
    private final SparseArray<WindowProcessController> mPidMap = new SparseArray();
    private final Map<Integer, ArraySet<WindowProcessController>> mUidMap = new HashMap<Integer, ArraySet<WindowProcessController>>();

    WindowProcessControllerMap() {
    }

    WindowProcessController getProcess(int pid) {
        return this.mPidMap.get(pid);
    }

    ArraySet<WindowProcessController> getProcesses(int uid) {
        return this.mUidMap.get(uid);
    }

    SparseArray<WindowProcessController> getPidMap() {
        return this.mPidMap;
    }

    void put(int pid, WindowProcessController proc) {
        WindowProcessController prevProc = this.mPidMap.get(pid);
        if (prevProc != null) {
            this.removeProcessFromUidMap(prevProc);
        }
        this.mPidMap.put(pid, proc);
        int uid = proc.mUid;
        ArraySet<WindowProcessController> procSet = this.mUidMap.getOrDefault(uid, new ArraySet());
        procSet.add(proc);
        this.mUidMap.put(uid, procSet);
    }

    void remove(int pid) {
        WindowProcessController proc = this.mPidMap.get(pid);
        if (proc != null) {
            this.mPidMap.remove(pid);
            this.removeProcessFromUidMap(proc);
        }
    }

    private void removeProcessFromUidMap(WindowProcessController proc) {
        if (proc == null) {
            return;
        }
        int uid = proc.mUid;
        ArraySet<WindowProcessController> procSet = this.mUidMap.get(uid);
        if (procSet != null) {
            procSet.remove(proc);
            if (procSet.isEmpty()) {
                this.mUidMap.remove(uid);
            }
        }
    }
}

