/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.MergedConfiguration;
import android.util.Slog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.Gravity;
import android.view.IApplicationToken;
import android.view.IWindow;
import android.view.IWindowFocusObserver;
import android.view.IWindowId;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.InputWindowHandle;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.WindowInfo;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ToBooleanFunction;
import com.android.server.am.ActivityManagerService;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.wm.AccessibilityController;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.Dimmer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.InsetsSourceProvider;
import com.android.server.wm.InsetsStateController;
import com.android.server.wm.LocalAnimationAdapter;
import com.android.server.wm.SeamlessRotator;
import com.android.server.wm.Session;
import com.android.server.wm.TapExcludeRegionHolder;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowAnimationSpec;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowFrames;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowProcessController;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import com.android.server.wm.utils.InsetUtils;
import com.android.server.wm.utils.WmDisplayCutout;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;

class WindowState
extends WindowContainer<WindowState>
implements WindowManagerPolicy.WindowState {
    static final String TAG = "WindowManager";
    static final int MINIMUM_VISIBLE_WIDTH_IN_DP = 48;
    static final int MINIMUM_VISIBLE_HEIGHT_IN_DP = 32;
    static final int RESIZE_HANDLE_WIDTH_IN_DP = 30;
    final WindowManagerPolicy mPolicy;
    final Context mContext;
    final Session mSession;
    final IWindow mClient;
    final int mAppOp;
    final int mOwnerUid;
    final boolean mOwnerCanAddInternalSystemWindow;
    final WindowId mWindowId;
    WindowToken mToken;
    AppWindowToken mAppToken;
    final WindowManager.LayoutParams mAttrs = new WindowManager.LayoutParams();
    final DeathRecipient mDeathRecipient;
    private boolean mIsChildWindow;
    final int mBaseLayer;
    final int mSubLayer;
    final boolean mLayoutAttached;
    final boolean mIsImWindow;
    final boolean mIsWallpaper;
    private final boolean mIsFloatingLayer;
    int mSeq;
    int mViewVisibility;
    int mSystemUiVisibility;
    static final int LEGACY_POLICY_VISIBILITY = 1;
    private static final int VISIBLE_FOR_USER = 2;
    private static final int POLICY_VISIBILITY_ALL = 3;
    private int mPolicyVisibility = 3;
    boolean mLegacyPolicyVisibilityAfterAnim = true;
    private boolean mHiddenWhileSuspended;
    private boolean mAppOpVisibility = true;
    boolean mPermanentlyHidden;
    private boolean mForceHideNonSystemOverlayWindow;
    boolean mAppFreezing;
    boolean mHidden = true;
    boolean mWallpaperVisible;
    private boolean mDragResizing;
    private boolean mDragResizingChangeReported = true;
    private int mResizeMode;
    final boolean mForceSeamlesslyRotate;
    SeamlessRotator mPendingSeamlessRotate;
    long mFinishSeamlessRotateFrameNumber;
    private RemoteCallbackList<IWindowFocusObserver> mFocusCallbacks;
    int mRequestedWidth;
    int mRequestedHeight;
    private int mLastRequestedWidth;
    private int mLastRequestedHeight;
    int mLayer;
    boolean mHaveFrame;
    boolean mObscured;
    int mLayoutSeq = -1;
    private final MergedConfiguration mLastReportedConfiguration = new MergedConfiguration();
    private boolean mLastConfigReportedToClient;
    private final Configuration mTempConfiguration = new Configuration();
    final Rect mLastRelayoutContentInsets = new Rect();
    boolean mGivenInsetsPending;
    final Rect mGivenContentInsets = new Rect();
    final Rect mGivenVisibleInsets = new Rect();
    final Region mGivenTouchableRegion = new Region();
    int mTouchableInsets = 0;
    float mGlobalScale = 1.0f;
    float mInvGlobalScale = 1.0f;
    float mHScale = 1.0f;
    float mVScale = 1.0f;
    float mLastHScale = 1.0f;
    float mLastVScale = 1.0f;
    final Matrix mTmpMatrix = new Matrix();
    private final WindowFrames mWindowFrames = new WindowFrames();
    private final Rect mInsetFrame = new Rect();
    private final List<Rect> mExclusionRects = new ArrayList<Rect>();
    float mWallpaperX = -1.0f;
    float mWallpaperY = -1.0f;
    float mWallpaperXStep = -1.0f;
    float mWallpaperYStep = -1.0f;
    int mWallpaperDisplayOffsetX = Integer.MIN_VALUE;
    int mWallpaperDisplayOffsetY = Integer.MIN_VALUE;
    boolean mRelayoutCalled;
    boolean mInRelayout;
    boolean mLayoutNeeded;
    boolean mAnimatingExit;
    boolean mDestroying;
    boolean mRemoveOnExit;
    boolean mAppDied;
    private boolean mOrientationChanging;
    private boolean mOrientationChangeTimedOut;
    int mLastVisibleLayoutRotation = -1;
    boolean mReportOrientationChanged;
    int mLastFreezeDuration;
    boolean mRemoved;
    boolean mWindowRemovalAllowed;
    final InputWindowHandle mInputWindowHandle;
    InputChannel mInputChannel;
    private InputChannel mClientChannel;
    private String mStringNameCache;
    private CharSequence mLastTitle;
    private boolean mWasExiting;
    final WindowStateAnimator mWinAnimator;
    boolean mHasSurface = false;
    private boolean mShowToOwnerOnly;
    private boolean mWasVisibleBeforeClientHidden;
    boolean mWillReplaceWindow = false;
    private boolean mReplacingRemoveRequested = false;
    private boolean mAnimateReplacingWindow = false;
    private WindowState mReplacementWindow = null;
    boolean mSkipEnterAnimationForSeamlessReplacement = false;
    private boolean mMovedByResize;
    private PowerManager.WakeLock mDrawLock;
    private final Rect mTmpRect = new Rect();
    private final Point mTmpPoint = new Point();
    boolean mResizedWhileGone = false;
    boolean mSeamlesslyRotated = false;
    final Rect mLastSurfaceInsets = new Rect();
    private boolean mDrawnStateEvaluated;
    private final Point mSurfacePosition = new Point();
    private TapExcludeRegionHolder mTapExcludeRegionHolder;
    private PowerManagerWrapper mPowerManagerWrapper;
    private long mFrameNumber = -1L;
    private static final StringBuilder sTmpSB = new StringBuilder();
    private static final Comparator<WindowState> sWindowSubLayerComparator = new Comparator<WindowState>(){

        @Override
        public int compare(WindowState w1, WindowState w2) {
            int layer1 = w1.mSubLayer;
            int layer2 = w2.mSubLayer;
            if (layer1 < layer2 || layer1 == layer2 && layer2 < 0) {
                return -1;
            }
            return 1;
        }
    };
    private boolean mIsDimming = false;
    private InsetsSourceProvider mInsetProvider;
    private static final float DEFAULT_DIM_AMOUNT_DEAD_WINDOW = 0.5f;
    private DeadWindowEventReceiver mDeadWindowEventReceiver;

    void seamlesslyRotateIfAllowed(SurfaceControl.Transaction transaction, int oldRotation, int rotation, boolean requested) {
        if (!this.isVisibleNow() || this.mIsWallpaper) {
            return;
        }
        if (this.mPendingSeamlessRotate != null) {
            oldRotation = this.mPendingSeamlessRotate.getOldRotation();
        }
        if (this.mForceSeamlesslyRotate || requested) {
            this.mPendingSeamlessRotate = new SeamlessRotator(oldRotation, rotation, this.getDisplayInfo());
            this.mPendingSeamlessRotate.unrotate(transaction, this);
            this.mWmService.markForSeamlessRotation(this, true);
        }
    }

    void finishSeamlessRotation(boolean timeout) {
        if (this.mPendingSeamlessRotate != null) {
            this.mPendingSeamlessRotate.finish(this, timeout);
            this.mFinishSeamlessRotateFrameNumber = this.getFrameNumber();
            this.mPendingSeamlessRotate = null;
            this.mWmService.markForSeamlessRotation(this, false);
        }
    }

    List<Rect> getSystemGestureExclusion() {
        return this.mExclusionRects;
    }

    boolean setSystemGestureExclusion(List<Rect> exclusionRects) {
        if (this.mExclusionRects.equals(exclusionRects)) {
            return false;
        }
        this.mExclusionRects.clear();
        this.mExclusionRects.addAll(exclusionRects);
        return true;
    }

    boolean isImplicitlyExcludingAllSystemGestures() {
        int immersiveStickyFlags = 4098;
        boolean immersiveSticky = (this.mSystemUiVisibility & 0x1002) == 4098;
        return immersiveSticky && this.mWmService.mSystemGestureExcludedByPreQStickyImmersive && this.mAppToken != null && this.mAppToken.mTargetSdk < 29;
    }

    WindowState(final WindowManagerService service, Session s, IWindow c, WindowToken token, WindowState parentWindow, int appOp, int seq, WindowManager.LayoutParams a, int viewVisibility, int ownerId, boolean ownerCanAddInternalSystemWindow) {
        this(service, s, c, token, parentWindow, appOp, seq, a, viewVisibility, ownerId, ownerCanAddInternalSystemWindow, new PowerManagerWrapper(){

            @Override
            public void wakeUp(long time, int reason, String details) {
                service.mPowerManager.wakeUp(time, reason, details);
            }

            @Override
            public boolean isInteractive() {
                return service.mPowerManager.isInteractive();
            }
        });
    }

    WindowState(WindowManagerService service, Session s, IWindow c, WindowToken token, WindowState parentWindow, int appOp, int seq, WindowManager.LayoutParams a, int viewVisibility, int ownerId, boolean ownerCanAddInternalSystemWindow, PowerManagerWrapper powerManagerWrapper) {
        super(service);
        this.mSession = s;
        this.mClient = c;
        this.mAppOp = appOp;
        this.mToken = token;
        this.mAppToken = this.mToken.asAppWindowToken();
        this.mOwnerUid = ownerId;
        this.mOwnerCanAddInternalSystemWindow = ownerCanAddInternalSystemWindow;
        this.mWindowId = new WindowId(this);
        this.mAttrs.copyFrom(a);
        this.mLastSurfaceInsets.set(this.mAttrs.surfaceInsets);
        this.mViewVisibility = viewVisibility;
        this.mPolicy = this.mWmService.mPolicy;
        this.mContext = this.mWmService.mContext;
        DeathRecipient deathRecipient = new DeathRecipient();
        this.mSeq = seq;
        this.mPowerManagerWrapper = powerManagerWrapper;
        this.mForceSeamlesslyRotate = token.mRoundedCornerOverlay;
        try {
            c.asBinder().linkToDeath(deathRecipient, 0);
        }
        catch (RemoteException e) {
            this.mDeathRecipient = null;
            this.mIsChildWindow = false;
            this.mLayoutAttached = false;
            this.mIsImWindow = false;
            this.mIsWallpaper = false;
            this.mIsFloatingLayer = false;
            this.mBaseLayer = 0;
            this.mSubLayer = 0;
            this.mInputWindowHandle = null;
            this.mWinAnimator = null;
            return;
        }
        this.mDeathRecipient = deathRecipient;
        if (this.mAttrs.type >= 1000 && this.mAttrs.type <= 1999) {
            this.mBaseLayer = this.mPolicy.getWindowLayerLw(parentWindow) * 10000 + 1000;
            this.mSubLayer = this.mPolicy.getSubWindowLayerFromTypeLw(a.type);
            this.mIsChildWindow = true;
            parentWindow.addChild(this, sWindowSubLayerComparator);
            this.mLayoutAttached = this.mAttrs.type != 1003;
            this.mIsImWindow = parentWindow.mAttrs.type == 2011 || parentWindow.mAttrs.type == 2012;
            this.mIsWallpaper = parentWindow.mAttrs.type == 2013;
        } else {
            this.mBaseLayer = this.mPolicy.getWindowLayerLw(this) * 10000 + 1000;
            this.mSubLayer = 0;
            this.mIsChildWindow = false;
            this.mLayoutAttached = false;
            this.mIsImWindow = this.mAttrs.type == 2011 || this.mAttrs.type == 2012;
            this.mIsWallpaper = this.mAttrs.type == 2013;
        }
        boolean bl = this.mIsFloatingLayer = this.mIsImWindow || this.mIsWallpaper;
        if (this.mAppToken != null && this.mAppToken.mShowForAllUsers) {
            this.mAttrs.flags |= 0x80000;
        }
        this.mWinAnimator = new WindowStateAnimator(this);
        this.mWinAnimator.mAlpha = a.alpha;
        this.mRequestedWidth = 0;
        this.mRequestedHeight = 0;
        this.mLastRequestedWidth = 0;
        this.mLastRequestedHeight = 0;
        this.mLayer = 0;
        this.mInputWindowHandle = new InputWindowHandle(this.mAppToken != null ? this.mAppToken.mInputApplicationHandle : null, c, this.getDisplayId());
    }

    void attach() {
        this.mSession.windowAddedLocked(this.mAttrs.packageName);
    }

    boolean inSizeCompatMode() {
        return (this.mAttrs.privateFlags & 0x80) != 0 || this.mAppToken != null && this.mAppToken.inSizeCompatMode() && this.mAttrs.type != 3;
    }

    boolean getDrawnStateEvaluated() {
        return this.mDrawnStateEvaluated;
    }

    void setDrawnStateEvaluated(boolean evaluated) {
        this.mDrawnStateEvaluated = evaluated;
    }

    @Override
    void onParentChanged() {
        super.onParentChanged();
        this.setDrawnStateEvaluated(false);
        this.getDisplayContent().reapplyMagnificationSpec();
    }

    @Override
    public int getOwningUid() {
        return this.mOwnerUid;
    }

    @Override
    public String getOwningPackage() {
        return this.mAttrs.packageName;
    }

    @Override
    public boolean canAddInternalSystemWindow() {
        return this.mOwnerCanAddInternalSystemWindow;
    }

    @Override
    public boolean canAcquireSleepToken() {
        return this.mSession.mCanAcquireSleepToken;
    }

    private void subtractInsets(Rect frame, Rect layoutFrame, Rect insetFrame, Rect displayFrame) {
        int left = Math.max(0, insetFrame.left - Math.max(layoutFrame.left, displayFrame.left));
        int top = Math.max(0, insetFrame.top - Math.max(layoutFrame.top, displayFrame.top));
        int right = Math.max(0, Math.min(layoutFrame.right, displayFrame.right) - insetFrame.right);
        int bottom = Math.max(0, Math.min(layoutFrame.bottom, displayFrame.bottom) - insetFrame.bottom);
        frame.inset(left, top, right, bottom);
    }

    @Override
    public Rect getDisplayedBounds() {
        Rect bounds;
        Task task = this.getTask();
        if (task != null && !(bounds = task.getOverrideDisplayedBounds()).isEmpty()) {
            return bounds;
        }
        return super.getDisplayedBounds();
    }

    @Override
    public void computeFrameLw() {
        DisplayContent displayContent;
        int layoutYDiff;
        int layoutXDiff;
        Rect layoutContainingFrame;
        Rect layoutDisplayFrame;
        boolean isImeTarget;
        if (this.mWillReplaceWindow && (this.mAnimatingExit || !this.mReplacingRemoveRequested)) {
            return;
        }
        this.mHaveFrame = true;
        Task task = this.getTask();
        boolean isFullscreenAndFillsDisplay = !this.inMultiWindowMode() && this.matchesDisplayBounds();
        boolean windowsAreFloating = task != null && task.isFloating();
        DisplayContent dc = this.getDisplayContent();
        this.mInsetFrame.set(this.getBounds());
        WindowState imeWin = this.mWmService.mRoot.getCurrentInputMethodWindow();
        boolean bl = isImeTarget = imeWin != null && imeWin.isVisibleNow() && this.isInputMethodTarget();
        if (isFullscreenAndFillsDisplay || this.layoutInParentFrame()) {
            this.mWindowFrames.mContainingFrame.set(this.mWindowFrames.mParentFrame);
            layoutDisplayFrame = this.mWindowFrames.mDisplayFrame;
            layoutContainingFrame = this.mWindowFrames.mParentFrame;
            layoutXDiff = 0;
            layoutYDiff = 0;
        } else {
            this.mWindowFrames.mContainingFrame.set(this.getDisplayedBounds());
            if (this.mAppToken != null && !this.mAppToken.mFrozenBounds.isEmpty()) {
                Rect frozen = this.mAppToken.mFrozenBounds.peek();
                this.mWindowFrames.mContainingFrame.right = this.mWindowFrames.mContainingFrame.left + frozen.width();
                this.mWindowFrames.mContainingFrame.bottom = this.mWindowFrames.mContainingFrame.top + frozen.height();
            }
            if (isImeTarget) {
                if (this.inFreeformWindowingMode()) {
                    int bottomOverlap = this.mWindowFrames.mContainingFrame.bottom - this.mWindowFrames.mVisibleFrame.bottom;
                    if (bottomOverlap > 0) {
                        int distanceToTop = Math.max(this.mWindowFrames.mContainingFrame.top - this.mWindowFrames.mDisplayFrame.top, 0);
                        int offs = Math.min(bottomOverlap, distanceToTop);
                        this.mWindowFrames.mContainingFrame.top -= offs;
                    }
                } else if (!this.inPinnedWindowingMode() && this.mWindowFrames.mContainingFrame.bottom > this.mWindowFrames.mParentFrame.bottom) {
                    this.mWindowFrames.mContainingFrame.bottom = this.mWindowFrames.mParentFrame.bottom;
                }
            }
            if (windowsAreFloating && this.mWindowFrames.mContainingFrame.isEmpty()) {
                this.mWindowFrames.mContainingFrame.set(this.mWindowFrames.mContentFrame);
            }
            TaskStack stack = this.getStack();
            if (this.inPinnedWindowingMode() && stack != null && stack.lastAnimatingBoundsWasToFullscreen()) {
                this.mInsetFrame.intersectUnchecked(this.mWindowFrames.mParentFrame);
                this.mWindowFrames.mContainingFrame.intersectUnchecked(this.mWindowFrames.mParentFrame);
            }
            layoutDisplayFrame = new Rect(this.mWindowFrames.mDisplayFrame);
            this.mWindowFrames.mDisplayFrame.set(this.mWindowFrames.mContainingFrame);
            layoutXDiff = this.mInsetFrame.left - this.mWindowFrames.mContainingFrame.left;
            layoutYDiff = this.mInsetFrame.top - this.mWindowFrames.mContainingFrame.top;
            layoutContainingFrame = this.mInsetFrame;
            this.mTmpRect.set(0, 0, dc.getDisplayInfo().logicalWidth, dc.getDisplayInfo().logicalHeight);
            this.subtractInsets(this.mWindowFrames.mDisplayFrame, layoutContainingFrame, layoutDisplayFrame, this.mTmpRect);
            if (!this.layoutInParentFrame()) {
                this.subtractInsets(this.mWindowFrames.mContainingFrame, layoutContainingFrame, this.mWindowFrames.mParentFrame, this.mTmpRect);
                this.subtractInsets(this.mInsetFrame, layoutContainingFrame, this.mWindowFrames.mParentFrame, this.mTmpRect);
            }
            layoutDisplayFrame.intersect(layoutContainingFrame);
        }
        int pw = this.mWindowFrames.mContainingFrame.width();
        int ph = this.mWindowFrames.mContainingFrame.height();
        if (this.mRequestedWidth != this.mLastRequestedWidth || this.mRequestedHeight != this.mLastRequestedHeight) {
            this.mLastRequestedWidth = this.mRequestedWidth;
            this.mLastRequestedHeight = this.mRequestedHeight;
            this.mWindowFrames.setContentChanged(true);
        }
        int fw = this.mWindowFrames.mFrame.width();
        int fh = this.mWindowFrames.mFrame.height();
        this.applyGravityAndUpdateFrame(layoutContainingFrame, layoutDisplayFrame);
        this.mWindowFrames.calculateOutsets();
        if (windowsAreFloating && !this.mWindowFrames.mFrame.isEmpty()) {
            int visBottom = this.mWindowFrames.mVisibleFrame.bottom;
            int contentBottom = this.mWindowFrames.mContentFrame.bottom;
            this.mWindowFrames.mContentFrame.set(this.mWindowFrames.mFrame);
            this.mWindowFrames.mVisibleFrame.set(this.mWindowFrames.mContentFrame);
            this.mWindowFrames.mStableFrame.set(this.mWindowFrames.mContentFrame);
            if (isImeTarget && this.inFreeformWindowingMode()) {
                if (contentBottom + layoutYDiff < this.mWindowFrames.mContentFrame.bottom) {
                    this.mWindowFrames.mContentFrame.bottom = contentBottom + layoutYDiff;
                }
                if (visBottom + layoutYDiff < this.mWindowFrames.mVisibleFrame.bottom) {
                    this.mWindowFrames.mVisibleFrame.bottom = visBottom + layoutYDiff;
                }
            }
        } else if (this.mAttrs.type == 2034) {
            dc.getDockedDividerController().positionDockedStackedDivider(this.mWindowFrames.mFrame);
            this.mWindowFrames.mContentFrame.set(this.mWindowFrames.mFrame);
            if (!this.mWindowFrames.mFrame.equals(this.mWindowFrames.mLastFrame)) {
                this.mMovedByResize = true;
            }
        } else {
            this.mWindowFrames.mContentFrame.set(Math.max(this.mWindowFrames.mContentFrame.left, this.mWindowFrames.mFrame.left), Math.max(this.mWindowFrames.mContentFrame.top, this.mWindowFrames.mFrame.top), Math.min(this.mWindowFrames.mContentFrame.right, this.mWindowFrames.mFrame.right), Math.min(this.mWindowFrames.mContentFrame.bottom, this.mWindowFrames.mFrame.bottom));
            this.mWindowFrames.mVisibleFrame.set(Math.max(this.mWindowFrames.mVisibleFrame.left, this.mWindowFrames.mFrame.left), Math.max(this.mWindowFrames.mVisibleFrame.top, this.mWindowFrames.mFrame.top), Math.min(this.mWindowFrames.mVisibleFrame.right, this.mWindowFrames.mFrame.right), Math.min(this.mWindowFrames.mVisibleFrame.bottom, this.mWindowFrames.mFrame.bottom));
            this.mWindowFrames.mStableFrame.set(Math.max(this.mWindowFrames.mStableFrame.left, this.mWindowFrames.mFrame.left), Math.max(this.mWindowFrames.mStableFrame.top, this.mWindowFrames.mFrame.top), Math.min(this.mWindowFrames.mStableFrame.right, this.mWindowFrames.mFrame.right), Math.min(this.mWindowFrames.mStableFrame.bottom, this.mWindowFrames.mFrame.bottom));
        }
        if (isFullscreenAndFillsDisplay && !windowsAreFloating) {
            InsetUtils.insetsBetweenFrames(layoutContainingFrame, this.mWindowFrames.mOverscanFrame, this.mWindowFrames.mOverscanInsets);
        }
        if (this.mAttrs.type == 2034) {
            WmDisplayCutout c = this.mWindowFrames.mDisplayCutout.calculateRelativeTo(this.mWindowFrames.mDisplayFrame);
            this.mWindowFrames.calculateDockedDividerInsets(c.getDisplayCutout().getSafeInsets());
        } else {
            this.getDisplayContent().getBounds(this.mTmpRect);
            this.mWindowFrames.calculateInsets(windowsAreFloating, isFullscreenAndFillsDisplay, this.mTmpRect);
        }
        this.mWindowFrames.setDisplayCutout(this.mWindowFrames.mDisplayCutout.calculateRelativeTo(this.mWindowFrames.mFrame));
        this.mWindowFrames.offsetFrames(-layoutXDiff, -layoutYDiff);
        this.mWindowFrames.mCompatFrame.set(this.mWindowFrames.mFrame);
        if (this.inSizeCompatMode()) {
            this.mWindowFrames.scaleInsets(this.mInvGlobalScale);
            this.mWindowFrames.mCompatFrame.scale(this.mInvGlobalScale);
        }
        if (this.mIsWallpaper && (fw != this.mWindowFrames.mFrame.width() || fh != this.mWindowFrames.mFrame.height()) && (displayContent = this.getDisplayContent()) != null) {
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            this.getDisplayContent().mWallpaperController.updateWallpaperOffset(this, displayInfo.logicalWidth, displayInfo.logicalHeight, false);
        }
    }

    @Override
    public Rect getBounds() {
        if (this.mAppToken != null) {
            return this.mAppToken.getBounds();
        }
        return super.getBounds();
    }

    @Override
    public Rect getFrameLw() {
        return this.mWindowFrames.mFrame;
    }

    @Override
    public Rect getDisplayFrameLw() {
        return this.mWindowFrames.mDisplayFrame;
    }

    @Override
    public Rect getOverscanFrameLw() {
        return this.mWindowFrames.mOverscanFrame;
    }

    @Override
    public Rect getContentFrameLw() {
        return this.mWindowFrames.mContentFrame;
    }

    @Override
    public Rect getVisibleFrameLw() {
        return this.mWindowFrames.mVisibleFrame;
    }

    Rect getStableFrameLw() {
        return this.mWindowFrames.mStableFrame;
    }

    Rect getDecorFrame() {
        return this.mWindowFrames.mDecorFrame;
    }

    Rect getParentFrame() {
        return this.mWindowFrames.mParentFrame;
    }

    Rect getContainingFrame() {
        return this.mWindowFrames.mContainingFrame;
    }

    WmDisplayCutout getWmDisplayCutout() {
        return this.mWindowFrames.mDisplayCutout;
    }

    void getCompatFrame(Rect outFrame) {
        outFrame.set(this.mWindowFrames.mCompatFrame);
    }

    void getCompatFrameSize(Rect outFrame) {
        outFrame.set(0, 0, this.mWindowFrames.mCompatFrame.width(), this.mWindowFrames.mCompatFrame.height());
    }

    @Override
    public boolean getGivenInsetsPendingLw() {
        return this.mGivenInsetsPending;
    }

    @Override
    public Rect getGivenContentInsetsLw() {
        return this.mGivenContentInsets;
    }

    @Override
    public Rect getGivenVisibleInsetsLw() {
        return this.mGivenVisibleInsets;
    }

    @Override
    public WindowManager.LayoutParams getAttrs() {
        return this.mAttrs;
    }

    @Override
    public boolean getNeedsMenuLw(WindowManagerPolicy.WindowState bottom) {
        return this.getDisplayContent().getNeedsMenu(this, bottom);
    }

    @Override
    public int getSystemUiVisibility() {
        return this.mSystemUiVisibility;
    }

    @Override
    public int getSurfaceLayer() {
        return this.mLayer;
    }

    @Override
    public int getBaseType() {
        return this.getTopParentWindow().mAttrs.type;
    }

    @Override
    public IApplicationToken getAppToken() {
        return this.mAppToken != null ? this.mAppToken.appToken : null;
    }

    @Override
    public boolean isVoiceInteraction() {
        return this.mAppToken != null && this.mAppToken.mVoiceInteraction;
    }

    boolean setReportResizeHints() {
        return this.mWindowFrames.setReportResizeHints();
    }

    void updateResizingWindowIfNeeded() {
        WindowStateAnimator winAnimator = this.mWinAnimator;
        if (!this.mHasSurface || this.getDisplayContent().mLayoutSeq != this.mLayoutSeq || this.isGoneForLayoutLw()) {
            return;
        }
        Task task = this.getTask();
        if (task != null && task.mStack.isAnimatingBounds()) {
            return;
        }
        boolean didFrameInsetsChange = this.setReportResizeHints();
        boolean configChanged = !this.isLastConfigReportedToClient();
        boolean dragResizingChanged = this.isDragResizeChanged() && !this.isDragResizingChangeReported();
        this.mWindowFrames.mLastFrame.set(this.mWindowFrames.mFrame);
        if (didFrameInsetsChange || winAnimator.mSurfaceResized || configChanged || dragResizingChanged || this.mReportOrientationChanged) {
            if (this.mAppToken != null && this.mAppDied) {
                this.mAppToken.removeDeadWindows();
                return;
            }
            this.updateLastInsetValues();
            this.mWmService.makeWindowFreezingScreenIfNeededLocked(this);
            if (this.getOrientationChanging() || dragResizingChanged) {
                winAnimator.mDrawState = 1;
                if (this.mAppToken != null) {
                    this.mAppToken.clearAllDrawn();
                }
            }
            if (!this.mWmService.mResizingWindows.contains(this)) {
                this.mWmService.mResizingWindows.add(this);
            }
        } else if (this.getOrientationChanging() && this.isDrawnLw()) {
            this.setOrientationChanging(false);
            this.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mWmService.mDisplayFreezeTime);
        }
    }

    boolean getOrientationChanging() {
        return (this.mOrientationChanging || this.isVisible() && this.getConfiguration().orientation != this.getLastReportedConfiguration().orientation) && !this.mSeamlesslyRotated && !this.mOrientationChangeTimedOut;
    }

    void setOrientationChanging(boolean changing) {
        this.mOrientationChanging = changing;
        this.mOrientationChangeTimedOut = false;
    }

    void orientationChangeTimedOut() {
        this.mOrientationChangeTimedOut = true;
    }

    @Override
    DisplayContent getDisplayContent() {
        return this.mToken.getDisplayContent();
    }

    @Override
    void onDisplayChanged(DisplayContent dc) {
        super.onDisplayChanged(dc);
        if (dc != null && this.mInputWindowHandle.displayId != dc.getDisplayId()) {
            this.mLayoutSeq = dc.mLayoutSeq - 1;
            this.mInputWindowHandle.displayId = dc.getDisplayId();
        }
    }

    DisplayInfo getDisplayInfo() {
        DisplayContent displayContent = this.getDisplayContent();
        return displayContent != null ? displayContent.getDisplayInfo() : null;
    }

    @Override
    public int getDisplayId() {
        DisplayContent displayContent = this.getDisplayContent();
        if (displayContent == null) {
            return -1;
        }
        return displayContent.getDisplayId();
    }

    Task getTask() {
        return this.mAppToken != null ? this.mAppToken.getTask() : null;
    }

    TaskStack getStack() {
        Task task = this.getTask();
        if (task != null && task.mStack != null) {
            return task.mStack;
        }
        DisplayContent dc = this.getDisplayContent();
        return this.mAttrs.type >= 2000 && dc != null ? dc.getHomeStack() : null;
    }

    void getVisibleBounds(Rect bounds) {
        Task task = this.getTask();
        boolean intersectWithStackBounds = task != null && task.cropWindowsToStackBounds();
        bounds.setEmpty();
        this.mTmpRect.setEmpty();
        if (intersectWithStackBounds) {
            TaskStack stack = task.mStack;
            if (stack != null) {
                stack.getDimBounds(this.mTmpRect);
            } else {
                intersectWithStackBounds = false;
            }
        }
        bounds.set(this.mWindowFrames.mVisibleFrame);
        if (intersectWithStackBounds) {
            bounds.intersect(this.mTmpRect);
        }
        if (bounds.isEmpty()) {
            bounds.set(this.mWindowFrames.mFrame);
            if (intersectWithStackBounds) {
                bounds.intersect(this.mTmpRect);
            }
            return;
        }
    }

    public long getInputDispatchingTimeoutNanos() {
        return this.mAppToken != null ? this.mAppToken.mInputDispatchingTimeoutNanos : 5000000000L;
    }

    @Override
    public boolean hasAppShownWindows() {
        return this.mAppToken != null && (this.mAppToken.firstWindowDrawn || this.mAppToken.startingDisplayed);
    }

    boolean isIdentityMatrix(float dsdx, float dtdx, float dsdy, float dtdy) {
        if (dsdx < 0.99999f || dsdx > 1.00001f) {
            return false;
        }
        if (dtdy < 0.99999f || dtdy > 1.00001f) {
            return false;
        }
        if (dtdx < -1.0E-6f || dtdx > 1.0E-6f) {
            return false;
        }
        return !(dsdy < -1.0E-6f) && !(dsdy > 1.0E-6f);
    }

    void prelayout() {
        if (this.inSizeCompatMode()) {
            this.mGlobalScale = this.mToken.getSizeCompatScale();
            this.mInvGlobalScale = 1.0f / this.mGlobalScale;
        } else {
            this.mInvGlobalScale = 1.0f;
            this.mGlobalScale = 1.0f;
        }
    }

    @Override
    boolean hasContentToDisplay() {
        if (!this.mAppFreezing && this.isDrawnLw() && (this.mViewVisibility == 0 || this.isAnimating() && !this.getDisplayContent().mAppTransition.isTransitionSet())) {
            return true;
        }
        return super.hasContentToDisplay();
    }

    @Override
    boolean isVisible() {
        return this.wouldBeVisibleIfPolicyIgnored() && this.isVisibleByPolicy() && (this.mInsetProvider == null || this.mInsetProvider.isClientVisible());
    }

    boolean isVisibleByPolicy() {
        return (this.mPolicyVisibility & 3) == 3;
    }

    void clearPolicyVisibilityFlag(int policyVisibilityFlag) {
        this.mPolicyVisibility &= ~policyVisibilityFlag;
        this.mWmService.scheduleAnimationLocked();
    }

    void setPolicyVisibilityFlag(int policyVisibilityFlag) {
        this.mPolicyVisibility |= policyVisibilityFlag;
        this.mWmService.scheduleAnimationLocked();
    }

    private boolean isLegacyPolicyVisibility() {
        return (this.mPolicyVisibility & 1) != 0;
    }

    boolean wouldBeVisibleIfPolicyIgnored() {
        return this.mHasSurface && !this.isParentWindowHidden() && !this.mAnimatingExit && !this.mDestroying && (!this.mIsWallpaper || this.mWallpaperVisible);
    }

    @Override
    public boolean isVisibleLw() {
        return this.isVisible();
    }

    boolean isWinVisibleLw() {
        return (this.mAppToken == null || !this.mAppToken.hiddenRequested || this.mAppToken.isSelfAnimating()) && this.isVisible();
    }

    boolean isVisibleNow() {
        return (!this.mToken.isHidden() || this.mAttrs.type == 3) && this.isVisible();
    }

    boolean isPotentialDragTarget() {
        return this.isVisibleNow() && !this.mRemoved && this.mInputChannel != null && this.mInputWindowHandle != null;
    }

    boolean isVisibleOrAdding() {
        AppWindowToken atoken = this.mAppToken;
        return (this.mHasSurface || !this.mRelayoutCalled && this.mViewVisibility == 0) && this.isVisibleByPolicy() && !this.isParentWindowHidden() && (atoken == null || !atoken.hiddenRequested) && !this.mAnimatingExit && !this.mDestroying;
    }

    boolean isOnScreen() {
        if (!this.mHasSurface || this.mDestroying || !this.isVisibleByPolicy()) {
            return false;
        }
        AppWindowToken atoken = this.mAppToken;
        if (atoken != null) {
            return !this.isParentWindowHidden() && !atoken.hiddenRequested || this.isAnimating();
        }
        return !this.isParentWindowHidden() || this.isAnimating();
    }

    boolean mightAffectAllDrawn() {
        boolean isAppType = this.mWinAnimator.mAttrType == 1 || this.mWinAnimator.mAttrType == 4;
        return (this.isOnScreen() || isAppType) && !this.mAnimatingExit && !this.mDestroying;
    }

    boolean isInteresting() {
        return this.mAppToken != null && !this.mAppDied && (!this.mAppToken.isFreezingScreen() || !this.mAppFreezing) && this.mViewVisibility == 0;
    }

    boolean isReadyForDisplay() {
        if (this.mToken.waitingToShow && this.getDisplayContent().mAppTransition.isTransitionSet()) {
            return false;
        }
        boolean parentAndClientVisible = !this.isParentWindowHidden() && this.mViewVisibility == 0 && !this.mToken.isHidden();
        return this.mHasSurface && this.isVisibleByPolicy() && !this.mDestroying && (parentAndClientVisible || this.isAnimating());
    }

    @Override
    public boolean canAffectSystemUiFlags() {
        boolean translucent;
        boolean bl = translucent = this.mAttrs.alpha == 0.0f;
        if (translucent) {
            return false;
        }
        if (this.mAppToken == null) {
            boolean shown = this.mWinAnimator.getShown();
            boolean exiting = this.mAnimatingExit || this.mDestroying;
            return shown && !exiting;
        }
        Task task = this.getTask();
        boolean canFromTask = task != null && task.canAffectSystemUiFlags();
        return canFromTask && !this.mAppToken.isHidden();
    }

    @Override
    public boolean isDisplayedLw() {
        AppWindowToken atoken = this.mAppToken;
        return this.isDrawnLw() && this.isVisibleByPolicy() && (!this.isParentWindowHidden() && (atoken == null || !atoken.hiddenRequested) || this.isAnimating());
    }

    @Override
    public boolean isAnimatingLw() {
        return this.isAnimating();
    }

    @Override
    public boolean isGoneForLayoutLw() {
        AppWindowToken atoken = this.mAppToken;
        return this.mViewVisibility == 8 || !this.mRelayoutCalled || atoken == null && this.mToken.isHidden() || atoken != null && atoken.hiddenRequested || this.isParentWindowGoneForLayout() || this.mAnimatingExit && !this.isAnimatingLw() || this.mDestroying;
    }

    public boolean isDrawFinishedLw() {
        return this.mHasSurface && !this.mDestroying && (this.mWinAnimator.mDrawState == 2 || this.mWinAnimator.mDrawState == 3 || this.mWinAnimator.mDrawState == 4);
    }

    @Override
    public boolean isDrawnLw() {
        return this.mHasSurface && !this.mDestroying && (this.mWinAnimator.mDrawState == 3 || this.mWinAnimator.mDrawState == 4);
    }

    private boolean isOpaqueDrawn() {
        return (!this.mIsWallpaper && this.mAttrs.format == -1 || this.mIsWallpaper && this.mWallpaperVisible) && this.isDrawnLw() && !this.isAnimating();
    }

    @Override
    void onMovedByResize() {
        this.mMovedByResize = true;
        super.onMovedByResize();
    }

    boolean onAppVisibilityChanged(boolean visible, boolean runningAppAnimation) {
        boolean changed = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            changed |= c.onAppVisibilityChanged(visible, runningAppAnimation);
        }
        if (this.mAttrs.type == 3) {
            if (!visible && this.isVisibleNow() && this.mAppToken.isSelfAnimating()) {
                this.mAnimatingExit = true;
                this.mRemoveOnExit = true;
                this.mWindowRemovalAllowed = true;
            }
            return changed;
        }
        boolean isVisibleNow = this.isVisibleNow();
        if (visible != isVisibleNow) {
            if (!runningAppAnimation && isVisibleNow) {
                AccessibilityController accessibilityController = this.mWmService.mAccessibilityController;
                int winTransit = 2;
                this.mWinAnimator.applyAnimationLocked(2, false);
                if (accessibilityController != null) {
                    accessibilityController.onWindowTransitionLocked(this, 2);
                }
            }
            changed = true;
            this.setDisplayLayoutNeeded();
        }
        return changed;
    }

    boolean onSetAppExiting() {
        DisplayContent displayContent = this.getDisplayContent();
        boolean changed = false;
        if (this.isVisibleNow()) {
            this.mWinAnimator.applyAnimationLocked(2, false);
            if (this.mWmService.mAccessibilityController != null) {
                this.mWmService.mAccessibilityController.onWindowTransitionLocked(this, 2);
            }
            changed = true;
            if (displayContent != null) {
                displayContent.setLayoutNeeded();
            }
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            changed |= c.onSetAppExiting();
        }
        return changed;
    }

    @Override
    void onResize() {
        ArrayList<WindowState> resizingWindows = this.mWmService.mResizingWindows;
        if (this.mHasSurface && !this.isGoneForLayoutLw() && !resizingWindows.contains(this)) {
            resizingWindows.add(this);
        }
        if (this.isGoneForLayoutLw()) {
            this.mResizedWhileGone = true;
        }
        super.onResize();
    }

    void onUnfreezeBounds() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.onUnfreezeBounds();
        }
        if (!this.mHasSurface) {
            return;
        }
        this.mLayoutNeeded = true;
        this.setDisplayLayoutNeeded();
        if (!this.mWmService.mResizingWindows.contains(this)) {
            this.mWmService.mResizingWindows.add(this);
        }
    }

    void handleWindowMovedIfNeeded() {
        boolean adjustedForMinimizedDockOrIme;
        if (!this.hasMoved()) {
            return;
        }
        int left = this.mWindowFrames.mFrame.left;
        int top = this.mWindowFrames.mFrame.top;
        Task task = this.getTask();
        boolean bl = adjustedForMinimizedDockOrIme = task != null && (task.mStack.isAdjustedForMinimizedDockedStack() || task.mStack.isAdjustedForIme());
        if (this.mToken.okToAnimate() && (this.mAttrs.privateFlags & 0x40) == 0 && !this.isDragResizing() && !adjustedForMinimizedDockOrIme && this.getWindowConfiguration().hasMovementAnimations() && !this.mWinAnimator.mLastHidden && !this.mSeamlesslyRotated) {
            this.startMoveAnimation(left, top);
        }
        if (this.mWmService.mAccessibilityController != null && this.getDisplayContent().getDisplayId() == 0) {
            this.mWmService.mAccessibilityController.onSomeWindowResizedOrMovedLocked();
        }
        try {
            this.mClient.moved(left, top);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.mMovedByResize = false;
    }

    private boolean hasMoved() {
        return !(!this.mHasSurface || !this.mWindowFrames.hasContentChanged() && !this.mMovedByResize || this.mAnimatingExit || this.mWindowFrames.mFrame.top == this.mWindowFrames.mLastFrame.top && this.mWindowFrames.mFrame.left == this.mWindowFrames.mLastFrame.left || this.mIsChildWindow && this.getParentWindow().hasMoved());
    }

    boolean isObscuringDisplay() {
        Task task = this.getTask();
        if (task != null && task.mStack != null && !task.mStack.fillsParent()) {
            return false;
        }
        return this.isOpaqueDrawn() && this.fillsDisplay();
    }

    boolean fillsDisplay() {
        DisplayInfo displayInfo = this.getDisplayInfo();
        return this.mWindowFrames.mFrame.left <= 0 && this.mWindowFrames.mFrame.top <= 0 && this.mWindowFrames.mFrame.right >= displayInfo.appWidth && this.mWindowFrames.mFrame.bottom >= displayInfo.appHeight;
    }

    private boolean matchesDisplayBounds() {
        return this.getDisplayContent().getBounds().equals(this.getBounds());
    }

    boolean isLastConfigReportedToClient() {
        return this.mLastConfigReportedToClient;
    }

    @Override
    void onMergedOverrideConfigurationChanged() {
        super.onMergedOverrideConfigurationChanged();
        this.mLastConfigReportedToClient = false;
    }

    void onWindowReplacementTimeout() {
        if (this.mWillReplaceWindow) {
            this.removeImmediately();
        } else {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                WindowState c = (WindowState)this.mChildren.get(i);
                c.onWindowReplacementTimeout();
            }
        }
    }

    @Override
    void forceWindowsScaleableInTransaction(boolean force) {
        if (this.mWinAnimator != null && this.mWinAnimator.hasSurface()) {
            this.mWinAnimator.mSurfaceController.forceScaleableInTransaction(force);
        }
        super.forceWindowsScaleableInTransaction(force);
    }

    @Override
    void removeImmediately() {
        int type;
        super.removeImmediately();
        if (this.mRemoved) {
            return;
        }
        this.mRemoved = true;
        this.mWillReplaceWindow = false;
        if (this.mReplacementWindow != null) {
            this.mReplacementWindow.mSkipEnterAnimationForSeamlessReplacement = false;
        }
        DisplayContent dc = this.getDisplayContent();
        if (this.isInputMethodTarget()) {
            dc.computeImeTarget(true);
        }
        if (WindowManagerService.excludeWindowTypeFromTapOutTask(type = this.mAttrs.type)) {
            dc.mTapExcludedWindows.remove(this);
        }
        if (this.mTapExcludeRegionHolder != null) {
            dc.mTapExcludeProvidingWindows.remove(this);
        }
        dc.getDisplayPolicy().removeWindowLw(this);
        this.disposeInputChannel();
        this.mWinAnimator.destroyDeferredSurfaceLocked();
        this.mWinAnimator.destroySurfaceLocked();
        this.mSession.windowRemovedLocked();
        try {
            this.mClient.asBinder().unlinkToDeath(this.mDeathRecipient, 0);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.mWmService.postWindowRemoveCleanupLocked(this);
    }

    @Override
    void removeIfPossible() {
        super.removeIfPossible();
        this.removeIfPossible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIfPossible(boolean keepVisibleDeadWindow) {
        boolean startingWindow;
        this.mWindowRemovalAllowed = true;
        boolean bl = startingWindow = this.mAttrs.type == 3;
        if (startingWindow) {
            // empty if block
        }
        long origId = Binder.clearCallingIdentity();
        try {
            DisplayContent displayContent;
            this.disposeInputChannel();
            boolean wasVisible = false;
            int displayId = this.getDisplayId();
            if (this.mHasSurface && this.mToken.okToAnimate()) {
                boolean lastWindowIsStartingWindow;
                if (this.mWillReplaceWindow) {
                    this.mAnimatingExit = true;
                    this.mReplacingRemoveRequested = true;
                    return;
                }
                wasVisible = this.isWinVisibleLw();
                if (keepVisibleDeadWindow) {
                    this.mAppDied = true;
                    this.setDisplayLayoutNeeded();
                    this.mWmService.mWindowPlacerLocked.performSurfacePlacement();
                    this.openInputChannel(null);
                    this.getDisplayContent().getInputMonitor().updateInputWindowsLw(true);
                    return;
                }
                if (wasVisible) {
                    int transit;
                    int n = transit = !startingWindow ? 2 : 5;
                    if (this.mWinAnimator.applyAnimationLocked(transit, false)) {
                        this.mAnimatingExit = true;
                        this.setDisplayLayoutNeeded();
                        this.mWmService.requestTraversal();
                    }
                    if (this.mWmService.mAccessibilityController != null) {
                        this.mWmService.mAccessibilityController.onWindowTransitionLocked(this, transit);
                    }
                }
                boolean isAnimating = this.isAnimating() && (this.mAppToken == null || !this.mAppToken.isWaitingForTransitionStart());
                boolean bl2 = lastWindowIsStartingWindow = startingWindow && this.mAppToken != null && this.mAppToken.isLastWindow(this);
                if (this.mWinAnimator.getShown() && this.mAnimatingExit && (!lastWindowIsStartingWindow || isAnimating)) {
                    this.setupWindowForRemoveOnExit();
                    if (this.mAppToken != null) {
                        this.mAppToken.updateReportedVisibilityLocked();
                    }
                    return;
                }
            }
            this.removeImmediately();
            if (wasVisible && (displayContent = this.getDisplayContent()).updateOrientationFromAppTokens()) {
                displayContent.sendNewConfiguration();
            }
            this.mWmService.updateFocusedWindowLocked(this.isFocused() ? 4 : 0, true);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    private void setupWindowForRemoveOnExit() {
        this.mRemoveOnExit = true;
        this.setDisplayLayoutNeeded();
        boolean focusChanged = this.mWmService.updateFocusedWindowLocked(3, false);
        this.mWmService.mWindowPlacerLocked.performSurfacePlacement();
        if (focusChanged) {
            this.getDisplayContent().getInputMonitor().updateInputWindowsLw(false);
        }
    }

    void setHasSurface(boolean hasSurface) {
        this.mHasSurface = hasSurface;
    }

    boolean canBeImeTarget() {
        boolean windowsAreFocusable;
        if (this.mIsImWindow) {
            return false;
        }
        boolean bl = windowsAreFocusable = this.mAppToken == null || this.mAppToken.windowsAreFocusable();
        if (!windowsAreFocusable) {
            return false;
        }
        int fl = this.mAttrs.flags & 0x20008;
        int type = this.mAttrs.type;
        if (fl != 0 && fl != 131080 && type != 3) {
            return false;
        }
        return this.isVisibleOrAdding();
    }

    void openInputChannel(InputChannel outInputChannel) {
        if (this.mInputChannel != null) {
            throw new IllegalStateException("Window already has an input channel.");
        }
        String name = this.getName();
        InputChannel[] inputChannels = InputChannel.openInputChannelPair(name);
        this.mInputChannel = inputChannels[0];
        this.mClientChannel = inputChannels[1];
        this.mInputWindowHandle.token = this.mClient.asBinder();
        if (outInputChannel != null) {
            this.mClientChannel.transferTo(outInputChannel);
            this.mClientChannel.dispose();
            this.mClientChannel = null;
        } else {
            this.mDeadWindowEventReceiver = new DeadWindowEventReceiver(this.mClientChannel);
        }
        this.mWmService.mInputManager.registerInputChannel(this.mInputChannel, this.mClient.asBinder());
    }

    void disposeInputChannel() {
        if (this.mDeadWindowEventReceiver != null) {
            this.mDeadWindowEventReceiver.dispose();
            this.mDeadWindowEventReceiver = null;
        }
        if (this.mInputChannel != null) {
            this.mWmService.mInputManager.unregisterInputChannel(this.mInputChannel);
            this.mInputChannel.dispose();
            this.mInputChannel = null;
        }
        if (this.mClientChannel != null) {
            this.mClientChannel.dispose();
            this.mClientChannel = null;
        }
        this.mInputWindowHandle.token = null;
    }

    boolean removeReplacedWindowIfNeeded(WindowState replacement) {
        if (this.mWillReplaceWindow && this.mReplacementWindow == replacement && replacement.hasDrawnLw()) {
            replacement.mSkipEnterAnimationForSeamlessReplacement = false;
            this.removeReplacedWindow();
            return true;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            if (!c.removeReplacedWindowIfNeeded(replacement)) continue;
            return true;
        }
        return false;
    }

    private void removeReplacedWindow() {
        this.mWillReplaceWindow = false;
        this.mAnimateReplacingWindow = false;
        this.mReplacingRemoveRequested = false;
        this.mReplacementWindow = null;
        if (this.mAnimatingExit || !this.mAnimateReplacingWindow) {
            this.removeImmediately();
        }
    }

    boolean setReplacementWindowIfNeeded(WindowState replacementCandidate) {
        boolean replacementSet = false;
        if (this.mWillReplaceWindow && this.mReplacementWindow == null && this.getWindowTag().toString().equals(replacementCandidate.getWindowTag().toString())) {
            this.mReplacementWindow = replacementCandidate;
            replacementCandidate.mSkipEnterAnimationForSeamlessReplacement = !this.mAnimateReplacingWindow;
            replacementSet = true;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            replacementSet |= c.setReplacementWindowIfNeeded(replacementCandidate);
        }
        return replacementSet;
    }

    void setDisplayLayoutNeeded() {
        DisplayContent dc = this.getDisplayContent();
        if (dc != null) {
            dc.setLayoutNeeded();
        }
    }

    void applyAdjustForImeIfNeeded() {
        Task task = this.getTask();
        if (task != null && task.mStack != null && task.mStack.isAdjustedForIme()) {
            task.mStack.applyAdjustForImeIfNeeded(task);
        }
    }

    @Override
    void switchUser() {
        super.switchUser();
        if (this.isHiddenFromUserLocked()) {
            this.clearPolicyVisibilityFlag(2);
        } else {
            this.setPolicyVisibilityFlag(2);
        }
    }

    int getSurfaceTouchableRegion(InputWindowHandle inputWindowHandle, int flags) {
        Rect appOverrideBounds;
        boolean modal = (flags & 0x28) == 0;
        Region region = inputWindowHandle.touchableRegion;
        this.setTouchableRegionCropIfNeeded(inputWindowHandle);
        Rect rect = appOverrideBounds = this.mAppToken != null ? this.mAppToken.getResolvedOverrideBounds() : null;
        if (appOverrideBounds != null && !appOverrideBounds.isEmpty()) {
            if (modal) {
                flags |= 0x20;
                this.mTmpRect.set(0, 0, appOverrideBounds.width(), appOverrideBounds.height());
            } else {
                this.mTmpRect.set(this.mWindowFrames.mCompatFrame);
            }
            int surfaceOffsetX = this.mAppToken.inSizeCompatMode() ? this.mAppToken.getBounds().left : 0;
            this.mTmpRect.offset(surfaceOffsetX - this.mWindowFrames.mFrame.left, -this.mWindowFrames.mFrame.top);
            region.set(this.mTmpRect);
            return flags;
        }
        if (modal && this.mAppToken != null) {
            flags |= 0x20;
            this.mAppToken.getLetterboxInnerBounds(this.mTmpRect);
            if (this.mTmpRect.isEmpty()) {
                Task task = this.getTask();
                if (task != null) {
                    task.getDimBounds(this.mTmpRect);
                } else {
                    this.getStack().getDimBounds(this.mTmpRect);
                }
            }
            if (this.inFreeformWindowingMode()) {
                DisplayMetrics displayMetrics = this.getDisplayContent().getDisplayMetrics();
                int delta = WindowManagerService.dipToPixel(30, displayMetrics);
                this.mTmpRect.inset(-delta, -delta);
            }
            region.set(this.mTmpRect);
            this.cropRegionToStackBoundsIfNeeded(region);
            this.subtractTouchExcludeRegionIfNeeded(region);
        } else if (modal && this.mTapExcludeRegionHolder != null) {
            Region touchExcludeRegion = Region.obtain();
            this.amendTapExcludeRegion(touchExcludeRegion);
            if (!touchExcludeRegion.isEmpty()) {
                flags |= 0x20;
                this.getDisplayContent().getBounds(this.mTmpRect);
                int dw = this.mTmpRect.width();
                int dh = this.mTmpRect.height();
                region.set(-dw, -dh, dw + dw, dh + dh);
                region.op(touchExcludeRegion, Region.Op.DIFFERENCE);
                inputWindowHandle.setTouchableRegionCrop(null);
            }
            touchExcludeRegion.recycle();
        } else {
            this.getTouchableRegion(region);
        }
        region.translate(-this.mWindowFrames.mFrame.left, -this.mWindowFrames.mFrame.top);
        return flags;
    }

    void checkPolicyVisibilityChange() {
        if (this.isLegacyPolicyVisibility() != this.mLegacyPolicyVisibilityAfterAnim) {
            if (this.mLegacyPolicyVisibilityAfterAnim) {
                this.setPolicyVisibilityFlag(1);
            } else {
                this.clearPolicyVisibilityFlag(1);
            }
            if (!this.isVisibleByPolicy()) {
                this.mWinAnimator.hide("checkPolicyVisibilityChange");
                if (this.isFocused()) {
                    this.mWmService.mFocusMayChange = true;
                }
                this.setDisplayLayoutNeeded();
                this.mWmService.enableScreenIfNeededLocked();
            }
        }
    }

    void setRequestedSize(int requestedWidth, int requestedHeight) {
        if (this.mRequestedWidth != requestedWidth || this.mRequestedHeight != requestedHeight) {
            this.mLayoutNeeded = true;
            this.mRequestedWidth = requestedWidth;
            this.mRequestedHeight = requestedHeight;
        }
    }

    void prepareWindowToDisplayDuringRelayout(boolean wasVisible) {
        boolean hasTurnScreenOnFlag;
        boolean bl = hasTurnScreenOnFlag = (this.mAttrs.flags & 0x200000) != 0;
        if (hasTurnScreenOnFlag) {
            boolean canTurnScreenOn;
            boolean allowTheaterMode = this.mWmService.mAllowTheaterModeWakeFromLayout || Settings.Global.getInt(this.mWmService.mContext.getContentResolver(), "theater_mode_on", 0) == 0;
            boolean bl2 = canTurnScreenOn = this.mAppToken == null || this.mAppToken.canTurnScreenOn();
            if (allowTheaterMode && canTurnScreenOn && !this.mPowerManagerWrapper.isInteractive()) {
                this.mPowerManagerWrapper.wakeUp(SystemClock.uptimeMillis(), 2, "android.server.wm:SCREEN_ON_FLAG");
            }
            if (this.mAppToken != null) {
                this.mAppToken.setCanTurnScreenOn(false);
            }
        }
        if (wasVisible) {
            return;
        }
        if ((this.mAttrs.softInputMode & 0xF0) == 16) {
            this.mLayoutNeeded = true;
        }
        if (this.isDrawnLw() && this.mToken.okToAnimate()) {
            this.mWinAnimator.applyEnterAnimationLocked();
        }
    }

    private Configuration getProcessGlobalConfiguration() {
        WindowState parentWindow = this.getParentWindow();
        int pid = parentWindow != null ? parentWindow.mSession.mPid : this.mSession.mPid;
        Configuration processConfig = this.mWmService.mAtmService.getGlobalConfigurationForPid(pid);
        return processConfig;
    }

    void getMergedConfiguration(MergedConfiguration outConfiguration) {
        Configuration globalConfig = this.getProcessGlobalConfiguration();
        Configuration overrideConfig = this.getMergedOverrideConfiguration();
        outConfiguration.setConfiguration(globalConfig, overrideConfig);
    }

    void setLastReportedMergedConfiguration(MergedConfiguration config) {
        this.mLastReportedConfiguration.setTo(config);
        this.mLastConfigReportedToClient = true;
    }

    void getLastReportedMergedConfiguration(MergedConfiguration config) {
        config.setTo(this.mLastReportedConfiguration);
    }

    private Configuration getLastReportedConfiguration() {
        return this.mLastReportedConfiguration.getMergedConfiguration();
    }

    void adjustStartingWindowFlags() {
        if (this.mAttrs.type == 1 && this.mAppToken != null && this.mAppToken.startingWindow != null) {
            int mask = 4718593;
            WindowManager.LayoutParams sa = this.mAppToken.startingWindow.mAttrs;
            sa.flags = sa.flags & 0xFFB7FFFE | this.mAttrs.flags & 0x480001;
        }
    }

    void setWindowScale(int requestedWidth, int requestedHeight) {
        boolean scaledWindow;
        boolean bl = scaledWindow = (this.mAttrs.flags & 0x4000) != 0;
        if (scaledWindow) {
            this.mHScale = this.mAttrs.width != requestedWidth ? (float)this.mAttrs.width / (float)requestedWidth : 1.0f;
            this.mVScale = this.mAttrs.height != requestedHeight ? (float)this.mAttrs.height / (float)requestedHeight : 1.0f;
        } else {
            this.mVScale = 1.0f;
            this.mHScale = 1.0f;
        }
    }

    private boolean shouldKeepVisibleDeadAppWindow() {
        if (!this.isWinVisibleLw() || this.mAppToken == null || this.mAppToken.isClientHidden()) {
            return false;
        }
        if (this.mAttrs.token != this.mClient.asBinder()) {
            return false;
        }
        if (this.mAttrs.type == 3) {
            return false;
        }
        return this.getWindowConfiguration().keepVisibleDeadAppWindowOnScreen();
    }

    @Override
    public boolean canReceiveKeys() {
        return this.isVisibleOrAdding() && this.mViewVisibility == 0 && !this.mRemoveOnExit && (this.mAttrs.flags & 8) == 0 && (this.mAppToken == null || this.mAppToken.windowsAreFocusable()) && !this.cantReceiveTouchInput();
    }

    @Override
    public boolean canShowWhenLocked() {
        boolean showBecauseOfActivity = this.mAppToken != null && this.mAppToken.mActivityRecord.canShowWhenLocked();
        boolean showBecauseOfWindow = (this.getAttrs().flags & 0x80000) != 0;
        return showBecauseOfActivity || showBecauseOfWindow;
    }

    boolean cantReceiveTouchInput() {
        return this.mAppToken != null && this.mAppToken.getTask() != null && (this.mAppToken.getTask().mStack.shouldIgnoreInput() || this.mAppToken.hiddenRequested);
    }

    @Override
    public boolean hasDrawnLw() {
        return this.mWinAnimator.mDrawState == 4;
    }

    @Override
    public boolean showLw(boolean doAnimation) {
        return this.showLw(doAnimation, true);
    }

    boolean showLw(boolean doAnimation, boolean requestAnim) {
        if (this.isLegacyPolicyVisibility() && this.mLegacyPolicyVisibilityAfterAnim) {
            return false;
        }
        if (this.isHiddenFromUserLocked()) {
            return false;
        }
        if (!this.mAppOpVisibility) {
            return false;
        }
        if (this.mPermanentlyHidden) {
            return false;
        }
        if (this.mHiddenWhileSuspended) {
            return false;
        }
        if (this.mForceHideNonSystemOverlayWindow) {
            return false;
        }
        if (doAnimation) {
            if (!this.mToken.okToAnimate()) {
                doAnimation = false;
            } else if (this.isLegacyPolicyVisibility() && !this.isAnimating()) {
                doAnimation = false;
            }
        }
        this.setPolicyVisibilityFlag(1);
        this.mLegacyPolicyVisibilityAfterAnim = true;
        if (doAnimation) {
            this.mWinAnimator.applyAnimationLocked(1, true);
        }
        if (requestAnim) {
            this.mWmService.scheduleAnimationLocked();
        }
        if ((this.mAttrs.flags & 8) == 0) {
            this.mWmService.updateFocusedWindowLocked(0, false);
        }
        return true;
    }

    @Override
    public boolean hideLw(boolean doAnimation) {
        return this.hideLw(doAnimation, true);
    }

    boolean hideLw(boolean doAnimation, boolean requestAnim) {
        boolean current;
        if (doAnimation && !this.mToken.okToAnimate()) {
            doAnimation = false;
        }
        boolean bl = current = doAnimation ? this.mLegacyPolicyVisibilityAfterAnim : this.isLegacyPolicyVisibility();
        if (!current) {
            return false;
        }
        if (doAnimation) {
            this.mWinAnimator.applyAnimationLocked(2, false);
            if (!this.isAnimating()) {
                doAnimation = false;
            }
        }
        this.mLegacyPolicyVisibilityAfterAnim = false;
        boolean isFocused = this.isFocused();
        if (!doAnimation) {
            this.clearPolicyVisibilityFlag(1);
            this.mWmService.enableScreenIfNeededLocked();
            if (isFocused) {
                this.mWmService.mFocusMayChange = true;
            }
        }
        if (requestAnim) {
            this.mWmService.scheduleAnimationLocked();
        }
        if (isFocused) {
            this.mWmService.updateFocusedWindowLocked(0, false);
        }
        return true;
    }

    void setForceHideNonSystemOverlayWindowIfNeeded(boolean forceHide) {
        if (this.mOwnerCanAddInternalSystemWindow || !WindowManager.LayoutParams.isSystemAlertWindowType(this.mAttrs.type) && this.mAttrs.type != 2005) {
            return;
        }
        if (this.mForceHideNonSystemOverlayWindow == forceHide) {
            return;
        }
        this.mForceHideNonSystemOverlayWindow = forceHide;
        if (forceHide) {
            this.hideLw(true, true);
        } else {
            this.showLw(true, true);
        }
    }

    void setHiddenWhileSuspended(boolean hide) {
        if (this.mOwnerCanAddInternalSystemWindow || !WindowManager.LayoutParams.isSystemAlertWindowType(this.mAttrs.type) && this.mAttrs.type != 2005) {
            return;
        }
        if (this.mHiddenWhileSuspended == hide) {
            return;
        }
        this.mHiddenWhileSuspended = hide;
        if (hide) {
            this.hideLw(true, true);
        } else {
            this.showLw(true, true);
        }
    }

    private void setAppOpVisibilityLw(boolean state) {
        if (this.mAppOpVisibility != state) {
            this.mAppOpVisibility = state;
            if (state) {
                this.showLw(true, true);
            } else {
                this.hideLw(true, true);
            }
        }
    }

    void initAppOpsState() {
        if (this.mAppOp == -1 || !this.mAppOpVisibility) {
            return;
        }
        int mode = this.mWmService.mAppOps.startOpNoThrow(this.mAppOp, this.getOwningUid(), this.getOwningPackage(), true);
        if (mode != 0 && mode != 3) {
            this.setAppOpVisibilityLw(false);
        }
    }

    void resetAppOpsState() {
        if (this.mAppOp != -1 && this.mAppOpVisibility) {
            this.mWmService.mAppOps.finishOp(this.mAppOp, this.getOwningUid(), this.getOwningPackage());
        }
    }

    void updateAppOpsState() {
        if (this.mAppOp == -1) {
            return;
        }
        int uid = this.getOwningUid();
        String packageName = this.getOwningPackage();
        if (this.mAppOpVisibility) {
            int mode = this.mWmService.mAppOps.checkOpNoThrow(this.mAppOp, uid, packageName);
            if (mode != 0 && mode != 3) {
                this.mWmService.mAppOps.finishOp(this.mAppOp, uid, packageName);
                this.setAppOpVisibilityLw(false);
            }
        } else {
            int mode = this.mWmService.mAppOps.startOpNoThrow(this.mAppOp, uid, packageName, true);
            if (mode == 0 || mode == 3) {
                this.setAppOpVisibilityLw(true);
            }
        }
    }

    public void hidePermanentlyLw() {
        if (!this.mPermanentlyHidden) {
            this.mPermanentlyHidden = true;
            this.hideLw(true, true);
        }
    }

    public void pokeDrawLockLw(long timeout) {
        if (this.isVisibleOrAdding()) {
            if (this.mDrawLock == null) {
                CharSequence tag = this.getWindowTag();
                this.mDrawLock = this.mWmService.mPowerManager.newWakeLock(128, "Window:" + tag);
                this.mDrawLock.setReferenceCounted(false);
                this.mDrawLock.setWorkSource(new WorkSource(this.mOwnerUid, this.mAttrs.packageName));
            }
            this.mDrawLock.acquire(timeout);
        }
    }

    @Override
    public boolean isAlive() {
        return this.mClient.asBinder().isBinderAlive();
    }

    boolean isClosing() {
        return this.mAnimatingExit || this.mAppToken != null && this.mAppToken.isClosingOrEnteringPip();
    }

    void addWinAnimatorToList(ArrayList<WindowStateAnimator> animators) {
        animators.add(this.mWinAnimator);
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.addWinAnimatorToList(animators);
        }
    }

    @Override
    void sendAppVisibilityToClients() {
        super.sendAppVisibilityToClients();
        boolean clientHidden = this.mAppToken.isClientHidden();
        if (this.mAttrs.type == 3 && clientHidden) {
            return;
        }
        if (clientHidden) {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                WindowState c = (WindowState)this.mChildren.get(i);
                c.mWinAnimator.detachChildren();
            }
            this.mWinAnimator.detachChildren();
        }
        try {
            this.mClient.dispatchAppVisibility(!clientHidden);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void onStartFreezingScreen() {
        this.mAppFreezing = true;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.onStartFreezingScreen();
        }
    }

    boolean onStopFreezingScreen() {
        boolean unfrozeWindows = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            unfrozeWindows |= c.onStopFreezingScreen();
        }
        if (!this.mAppFreezing) {
            return unfrozeWindows;
        }
        this.mAppFreezing = false;
        if (this.mHasSurface && !this.getOrientationChanging() && this.mWmService.mWindowsFreezingScreen != 2) {
            this.setOrientationChanging(true);
            this.mWmService.mRoot.mOrientationChangeComplete = false;
        }
        this.mLastFreezeDuration = 0;
        this.setDisplayLayoutNeeded();
        return true;
    }

    boolean destroySurface(boolean cleanupOnResume, boolean appStopped) {
        boolean destroyedSomething = false;
        ArrayList childWindows = new ArrayList(this.mChildren);
        for (int i = childWindows.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)childWindows.get(i);
            destroyedSomething |= c.destroySurface(cleanupOnResume, appStopped);
        }
        if (!(appStopped || this.mWindowRemovalAllowed || cleanupOnResume)) {
            return destroyedSomething;
        }
        if (appStopped || this.mWindowRemovalAllowed) {
            this.mWinAnimator.destroyPreservedSurfaceLocked();
        }
        if (this.mDestroying) {
            if (!cleanupOnResume || this.mRemoveOnExit) {
                this.destroySurfaceUnchecked();
            }
            if (this.mRemoveOnExit) {
                this.removeImmediately();
            }
            if (cleanupOnResume) {
                this.requestUpdateWallpaperIfNeeded();
            }
            this.mDestroying = false;
            destroyedSomething = true;
            if (this.getDisplayContent().mAppTransition.isTransitionSet() && this.getDisplayContent().mOpeningApps.contains(this.mAppToken)) {
                this.mWmService.mWindowPlacerLocked.requestTraversal();
            }
        }
        return destroyedSomething;
    }

    void destroySurfaceUnchecked() {
        this.mWinAnimator.destroySurfaceLocked();
        this.mAnimatingExit = false;
    }

    @Override
    public boolean isDefaultDisplay() {
        DisplayContent displayContent = this.getDisplayContent();
        if (displayContent == null) {
            return false;
        }
        return displayContent.isDefaultDisplay;
    }

    void setShowToOwnerOnlyLocked(boolean showToOwnerOnly) {
        this.mShowToOwnerOnly = showToOwnerOnly;
    }

    private boolean isHiddenFromUserLocked() {
        WindowState win = this.getTopParentWindow();
        if (win.mAttrs.type < 2000 && win.mAppToken != null && win.mAppToken.mShowForAllUsers && win.getFrameLw().left <= win.getDisplayFrameLw().left && win.getFrameLw().top <= win.getDisplayFrameLw().top && win.getFrameLw().right >= win.getStableFrameLw().right && win.getFrameLw().bottom >= win.getStableFrameLw().bottom) {
            return false;
        }
        return win.mShowToOwnerOnly && !this.mWmService.isCurrentProfileLocked(UserHandle.getUserId(win.mOwnerUid));
    }

    private static void applyInsets(Region outRegion, Rect frame, Rect inset) {
        outRegion.set(frame.left + inset.left, frame.top + inset.top, frame.right - inset.right, frame.bottom - inset.bottom);
    }

    void getTouchableRegion(Region outRegion) {
        Rect frame = this.mWindowFrames.mFrame;
        switch (this.mTouchableInsets) {
            default: {
                outRegion.set(frame);
                break;
            }
            case 1: {
                WindowState.applyInsets(outRegion, frame, this.mGivenContentInsets);
                break;
            }
            case 2: {
                WindowState.applyInsets(outRegion, frame, this.mGivenVisibleInsets);
                break;
            }
            case 3: {
                outRegion.set(this.mGivenTouchableRegion);
                outRegion.translate(frame.left, frame.top);
            }
        }
        this.cropRegionToStackBoundsIfNeeded(outRegion);
        this.subtractTouchExcludeRegionIfNeeded(outRegion);
    }

    void getEffectiveTouchableRegion(Region outRegion) {
        boolean modal = (this.mAttrs.flags & 0x28) == 0;
        DisplayContent dc = this.getDisplayContent();
        if (modal && dc != null) {
            outRegion.set(dc.getBounds());
            this.cropRegionToStackBoundsIfNeeded(outRegion);
            this.subtractTouchExcludeRegionIfNeeded(outRegion);
        } else {
            this.getTouchableRegion(outRegion);
        }
    }

    private void setTouchableRegionCropIfNeeded(InputWindowHandle handle) {
        Task task = this.getTask();
        if (task == null || !task.cropWindowsToStackBounds()) {
            return;
        }
        TaskStack stack = task.mStack;
        if (stack == null) {
            return;
        }
        handle.setTouchableRegionCrop(stack.getSurfaceControl());
    }

    private void cropRegionToStackBoundsIfNeeded(Region region) {
        Task task = this.getTask();
        if (task == null || !task.cropWindowsToStackBounds()) {
            return;
        }
        TaskStack stack = task.mStack;
        if (stack == null) {
            return;
        }
        stack.getDimBounds(this.mTmpRect);
        region.op(this.mTmpRect, Region.Op.INTERSECT);
    }

    private void subtractTouchExcludeRegionIfNeeded(Region touchableRegion) {
        if (this.mTapExcludeRegionHolder == null) {
            return;
        }
        Region touchExcludeRegion = Region.obtain();
        this.amendTapExcludeRegion(touchExcludeRegion);
        if (!touchExcludeRegion.isEmpty()) {
            touchableRegion.op(touchExcludeRegion, Region.Op.DIFFERENCE);
        }
        touchExcludeRegion.recycle();
    }

    void reportFocusChangedSerialized(boolean focused, boolean inTouchMode) {
        try {
            this.mClient.windowFocusChanged(focused, inTouchMode);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.mFocusCallbacks != null) {
            int N = this.mFocusCallbacks.beginBroadcast();
            for (int i = 0; i < N; ++i) {
                IWindowFocusObserver obs = this.mFocusCallbacks.getBroadcastItem(i);
                try {
                    if (focused) {
                        obs.focusGained(this.mWindowId.asBinder());
                        continue;
                    }
                    obs.focusLost(this.mWindowId.asBinder());
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mFocusCallbacks.finishBroadcast();
        }
    }

    @Override
    public Configuration getConfiguration() {
        if (this.mAppToken != null && this.mAppToken.mFrozenMergedConfig.size() > 0) {
            return this.mAppToken.mFrozenMergedConfig.peek();
        }
        if (!this.registeredForDisplayConfigChanges()) {
            return super.getConfiguration();
        }
        this.mTempConfiguration.setTo(this.getProcessGlobalConfiguration());
        this.mTempConfiguration.updateFrom(this.getMergedOverrideConfiguration());
        return this.mTempConfiguration;
    }

    private boolean registeredForDisplayConfigChanges() {
        Session session;
        WindowState parentWindow = this.getParentWindow();
        Session session2 = session = parentWindow != null ? parentWindow.mSession : this.mSession;
        if (session.mPid == ActivityManagerService.MY_PID || session.mPid < 0) {
            return false;
        }
        WindowProcessController app = this.mWmService.mAtmService.getProcessController(session.mPid, session.mUid);
        return app != null && app.registeredForDisplayConfigChanges();
    }

    void reportResized() {
        Trace.traceBegin(32L, "wm.reportResized_" + this.getWindowTag());
        try {
            final MergedConfiguration mergedConfiguration = new MergedConfiguration(this.mWmService.mRoot.getConfiguration(), this.getMergedOverrideConfiguration());
            this.setLastReportedMergedConfiguration(mergedConfiguration);
            final Rect frame = this.mWindowFrames.mCompatFrame;
            final Rect overscanInsets = this.mWindowFrames.mLastOverscanInsets;
            final Rect contentInsets = this.mWindowFrames.mLastContentInsets;
            final Rect visibleInsets = this.mWindowFrames.mLastVisibleInsets;
            final Rect stableInsets = this.mWindowFrames.mLastStableInsets;
            final Rect outsets = this.mWindowFrames.mLastOutsets;
            final boolean reportDraw = this.mWinAnimator.mDrawState == 1;
            final boolean reportOrientation = this.mReportOrientationChanged;
            final int displayId = this.getDisplayId();
            final DisplayCutout displayCutout = this.getWmDisplayCutout().getDisplayCutout();
            if (this.mAttrs.type != 3 && this.mClient instanceof IWindow.Stub) {
                this.mWmService.mH.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            WindowState.this.dispatchResized(frame, overscanInsets, contentInsets, visibleInsets, stableInsets, outsets, reportDraw, mergedConfiguration, reportOrientation, displayId, displayCutout);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                });
            } else {
                this.dispatchResized(frame, overscanInsets, contentInsets, visibleInsets, stableInsets, outsets, reportDraw, mergedConfiguration, reportOrientation, displayId, displayCutout);
            }
            if (this.mWmService.mAccessibilityController != null && (this.getDisplayId() == 0 || this.getDisplayContent().getParentWindow() != null)) {
                this.mWmService.mAccessibilityController.onSomeWindowResizedOrMovedLocked();
            }
            this.mWindowFrames.resetInsetsChanged();
            this.mWinAnimator.mSurfaceResized = false;
            this.mReportOrientationChanged = false;
        }
        catch (RemoteException e) {
            this.setOrientationChanging(false);
            this.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mWmService.mDisplayFreezeTime);
            Slog.w(TAG, "Failed to report 'resized' to the client of " + this + ", removing this window.");
            this.mWmService.mPendingRemove.add(this);
            this.mWmService.mWindowPlacerLocked.requestTraversal();
        }
        Trace.traceEnd(32L);
    }

    void notifyInsetsChanged() {
        try {
            this.mClient.insetsChanged(this.getDisplayContent().getInsetsStateController().getInsetsForDispatch(this));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Failed to deliver inset state change", e);
        }
    }

    void notifyInsetsControlChanged() {
        InsetsStateController stateController = this.getDisplayContent().getInsetsStateController();
        try {
            this.mClient.insetsControlChanged(stateController.getInsetsForDispatch(this), stateController.getControlsForDispatch(this));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Failed to deliver inset state change", e);
        }
    }

    Rect getBackdropFrame(Rect frame) {
        boolean resizing;
        boolean bl = resizing = this.isDragResizing() || this.isDragResizeChanged();
        if (this.getWindowConfiguration().useWindowFrameForBackdrop() || !resizing) {
            this.mTmpRect.set(frame);
            this.mTmpRect.offsetTo(0, 0);
            return this.mTmpRect;
        }
        DisplayInfo displayInfo = this.getDisplayInfo();
        this.mTmpRect.set(0, 0, displayInfo.logicalWidth, displayInfo.logicalHeight);
        return this.mTmpRect;
    }

    private int getStackId() {
        TaskStack stack = this.getStack();
        if (stack == null) {
            return -1;
        }
        return stack.mStackId;
    }

    private void dispatchResized(Rect frame, Rect overscanInsets, Rect contentInsets, Rect visibleInsets, Rect stableInsets, Rect outsets, boolean reportDraw, MergedConfiguration mergedConfiguration, boolean reportOrientation, int displayId, DisplayCutout displayCutout) throws RemoteException {
        boolean forceRelayout = this.isDragResizeChanged() || reportOrientation;
        this.mClient.resized(frame, overscanInsets, contentInsets, visibleInsets, stableInsets, outsets, reportDraw, mergedConfiguration, this.getBackdropFrame(frame), forceRelayout, this.getDisplayContent().getDisplayPolicy().areSystemBarsForcedShownLw(this), displayId, new DisplayCutout.ParcelableWrapper(displayCutout));
        this.mDragResizingChangeReported = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFocusObserver(IWindowFocusObserver observer) {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mWmService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mFocusCallbacks == null) {
                    this.mFocusCallbacks = new RemoteCallbackList();
                }
                this.mFocusCallbacks.register(observer);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFocusObserver(IWindowFocusObserver observer) {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mWmService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mFocusCallbacks != null) {
                    this.mFocusCallbacks.unregister(observer);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    boolean isFocused() {
        return this.getDisplayContent().mCurrentFocus == this;
    }

    private boolean inAppWindowThatMatchesParentBounds() {
        return this.mAppToken == null || this.mAppToken.matchParentBounds() && !this.inMultiWindowMode();
    }

    boolean isLetterboxedAppWindow() {
        return !this.inMultiWindowMode() && !this.matchesDisplayBounds() || this.isLetterboxedForDisplayCutoutLw();
    }

    @Override
    public boolean isLetterboxedForDisplayCutoutLw() {
        if (this.mAppToken == null) {
            return false;
        }
        if (!this.mWindowFrames.parentFrameWasClippedByDisplayCutout()) {
            return false;
        }
        if (this.mAttrs.layoutInDisplayCutoutMode == 1) {
            return false;
        }
        if (!this.mAttrs.isFullscreen()) {
            return false;
        }
        return !this.frameCoversEntireAppTokenBounds();
    }

    private boolean frameCoversEntireAppTokenBounds() {
        this.mTmpRect.set(this.mAppToken.getBounds());
        this.mTmpRect.intersectUnchecked(this.mWindowFrames.mFrame);
        return this.mAppToken.getBounds().equals(this.mTmpRect);
    }

    @Override
    public boolean isLetterboxedOverlappingWith(Rect rect) {
        return this.mAppToken != null && this.mAppToken.isLetterboxOverlappingWith(rect);
    }

    boolean isDragResizeChanged() {
        return this.mDragResizing != this.computeDragResizing();
    }

    @Override
    void setWaitingForDrawnIfResizingChanged() {
        if (this.isDragResizeChanged()) {
            this.mWmService.mWaitingForDrawn.add(this);
        }
        super.setWaitingForDrawnIfResizingChanged();
    }

    private boolean isDragResizingChangeReported() {
        return this.mDragResizingChangeReported;
    }

    @Override
    void resetDragResizingChangeReported() {
        this.mDragResizingChangeReported = false;
        super.resetDragResizingChangeReported();
    }

    int getResizeMode() {
        return this.mResizeMode;
    }

    private boolean computeDragResizing() {
        Task task = this.getTask();
        if (task == null) {
            return false;
        }
        if (!this.inSplitScreenWindowingMode() && !this.inFreeformWindowingMode()) {
            return false;
        }
        if (this.mAttrs.width != -1 || this.mAttrs.height != -1) {
            return false;
        }
        if (task.isDragResizing()) {
            return true;
        }
        return (this.getDisplayContent().mDividerControllerLocked.isResizing() || this.mAppToken != null && !this.mAppToken.mFrozenBounds.isEmpty()) && !task.inFreeformWindowingMode() && !this.isGoneForLayoutLw();
    }

    void setDragResizing() {
        boolean resizing = this.computeDragResizing();
        if (resizing == this.mDragResizing) {
            return;
        }
        this.mDragResizing = resizing;
        Task task = this.getTask();
        this.mResizeMode = task != null && task.isDragResizing() ? task.getDragResizeMode() : (this.mDragResizing && this.getDisplayContent().mDividerControllerLocked.isResizing() ? 1 : 0);
    }

    boolean isDragResizing() {
        return this.mDragResizing;
    }

    boolean isDockedResizing() {
        return this.mDragResizing && this.getResizeMode() == 1 || this.isChildWindow() && this.getParentWindow().isDockedResizing();
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, int logLevel) {
        boolean isVisible = this.isVisible();
        if (logLevel == 2 && !isVisible) {
            return;
        }
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, logLevel);
        this.writeIdentifierToProto(proto, 1146756268034L);
        proto.write(1120986464259L, this.getDisplayId());
        proto.write(1120986464260L, this.getStackId());
        this.mAttrs.writeToProto(proto, 1146756268037L);
        this.mGivenContentInsets.writeToProto(proto, 1146756268038L);
        this.mWindowFrames.writeToProto(proto, 1146756268073L);
        this.mAttrs.surfaceInsets.writeToProto(proto, 1146756268044L);
        this.mSurfacePosition.writeToProto(proto, 0x10B00000010L);
        this.mWinAnimator.writeToProto(proto, 1146756268045L);
        proto.write(1133871366158L, this.mAnimatingExit);
        for (int i = 0; i < this.mChildren.size(); ++i) {
            ((WindowState)this.mChildren.get(i)).writeToProto(proto, 2246267895823L, logLevel);
        }
        proto.write(1120986464274L, this.mRequestedWidth);
        proto.write(1120986464275L, this.mRequestedHeight);
        proto.write(1120986464276L, this.mViewVisibility);
        proto.write(0x10500000015L, this.mSystemUiVisibility);
        proto.write(1133871366166L, this.mHasSurface);
        proto.write(1133871366167L, this.isReadyForDisplay());
        proto.write(1133871366178L, this.mRemoveOnExit);
        proto.write(1133871366179L, this.mDestroying);
        proto.write(1133871366180L, this.mRemoved);
        proto.write(1133871366181L, this.isOnScreen());
        proto.write(1133871366182L, isVisible);
        proto.write(1133871366183L, this.mPendingSeamlessRotate != null);
        proto.write(1112396529704L, this.mFinishSeamlessRotateFrameNumber);
        proto.write(1133871366186L, this.mForceSeamlesslyRotate);
        proto.end(token);
    }

    @Override
    public void writeIdentifierToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, System.identityHashCode(this));
        proto.write(1120986464258L, UserHandle.getUserId(this.mOwnerUid));
        CharSequence title = this.getWindowTag();
        if (title != null) {
            proto.write(1138166333443L, title.toString());
        }
        proto.end(token);
    }

    @Override
    void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        TaskStack stack = this.getStack();
        pw.print(prefix + "mDisplayId=" + this.getDisplayId());
        if (stack != null) {
            pw.print(" stackId=" + stack.mStackId);
        }
        pw.println(" mSession=" + this.mSession + " mClient=" + this.mClient.asBinder());
        pw.println(prefix + "mOwnerUid=" + this.mOwnerUid + " mShowToOwnerOnly=" + this.mShowToOwnerOnly + " package=" + this.mAttrs.packageName + " appop=" + AppOpsManager.opToName(this.mAppOp));
        pw.println(prefix + "mAttrs=" + this.mAttrs.toString(prefix));
        pw.println(prefix + "Requested w=" + this.mRequestedWidth + " h=" + this.mRequestedHeight + " mLayoutSeq=" + this.mLayoutSeq);
        if (this.mRequestedWidth != this.mLastRequestedWidth || this.mRequestedHeight != this.mLastRequestedHeight) {
            pw.println(prefix + "LastRequested w=" + this.mLastRequestedWidth + " h=" + this.mLastRequestedHeight);
        }
        if (this.mIsChildWindow || this.mLayoutAttached) {
            pw.println(prefix + "mParentWindow=" + this.getParentWindow() + " mLayoutAttached=" + this.mLayoutAttached);
        }
        if (this.mIsImWindow || this.mIsWallpaper || this.mIsFloatingLayer) {
            pw.println(prefix + "mIsImWindow=" + this.mIsImWindow + " mIsWallpaper=" + this.mIsWallpaper + " mIsFloatingLayer=" + this.mIsFloatingLayer + " mWallpaperVisible=" + this.mWallpaperVisible);
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mBaseLayer=");
            pw.print(this.mBaseLayer);
            pw.print(" mSubLayer=");
            pw.print(this.mSubLayer);
        }
        if (dumpAll) {
            pw.println(prefix + "mToken=" + this.mToken);
            if (this.mAppToken != null) {
                pw.println(prefix + "mAppToken=" + this.mAppToken);
                pw.print(prefix + "mAppDied=" + this.mAppDied);
                pw.print(prefix + "drawnStateEvaluated=" + this.getDrawnStateEvaluated());
                pw.println(prefix + "mightAffectAllDrawn=" + this.mightAffectAllDrawn());
            }
            pw.println(prefix + "mViewVisibility=0x" + Integer.toHexString(this.mViewVisibility) + " mHaveFrame=" + this.mHaveFrame + " mObscured=" + this.mObscured);
            pw.println(prefix + "mSeq=" + this.mSeq + " mSystemUiVisibility=0x" + Integer.toHexString(this.mSystemUiVisibility));
        }
        if (!this.isVisibleByPolicy() || !this.mLegacyPolicyVisibilityAfterAnim || !this.mAppOpVisibility || this.isParentWindowHidden() || this.mPermanentlyHidden || this.mForceHideNonSystemOverlayWindow || this.mHiddenWhileSuspended) {
            pw.println(prefix + "mPolicyVisibility=" + this.isVisibleByPolicy() + " mLegacyPolicyVisibilityAfterAnim=" + this.mLegacyPolicyVisibilityAfterAnim + " mAppOpVisibility=" + this.mAppOpVisibility + " parentHidden=" + this.isParentWindowHidden() + " mPermanentlyHidden=" + this.mPermanentlyHidden + " mHiddenWhileSuspended=" + this.mHiddenWhileSuspended + " mForceHideNonSystemOverlayWindow=" + this.mForceHideNonSystemOverlayWindow);
        }
        if (!this.mRelayoutCalled || this.mLayoutNeeded) {
            pw.println(prefix + "mRelayoutCalled=" + this.mRelayoutCalled + " mLayoutNeeded=" + this.mLayoutNeeded);
        }
        if (dumpAll) {
            pw.println(prefix + "mGivenContentInsets=" + this.mGivenContentInsets.toShortString(sTmpSB) + " mGivenVisibleInsets=" + this.mGivenVisibleInsets.toShortString(sTmpSB));
            if (this.mTouchableInsets != 0 || this.mGivenInsetsPending) {
                pw.println(prefix + "mTouchableInsets=" + this.mTouchableInsets + " mGivenInsetsPending=" + this.mGivenInsetsPending);
                Region region = new Region();
                this.getTouchableRegion(region);
                pw.println(prefix + "touchable region=" + region);
            }
            pw.println(prefix + "mFullConfiguration=" + this.getConfiguration());
            pw.println(prefix + "mLastReportedConfiguration=" + this.getLastReportedConfiguration());
        }
        pw.println(prefix + "mHasSurface=" + this.mHasSurface + " isReadyForDisplay()=" + this.isReadyForDisplay() + " mWindowRemovalAllowed=" + this.mWindowRemovalAllowed);
        if (this.inSizeCompatMode()) {
            pw.println(prefix + "mCompatFrame=" + this.mWindowFrames.mCompatFrame.toShortString(sTmpSB));
        }
        if (dumpAll) {
            this.mWindowFrames.dump(pw, prefix);
            pw.println(prefix + " surface=" + this.mAttrs.surfaceInsets.toShortString(sTmpSB));
        }
        super.dump(pw, prefix, dumpAll);
        pw.println(prefix + this.mWinAnimator + ":");
        this.mWinAnimator.dump(pw, prefix + "  ", dumpAll);
        if (this.mAnimatingExit || this.mRemoveOnExit || this.mDestroying || this.mRemoved) {
            pw.println(prefix + "mAnimatingExit=" + this.mAnimatingExit + " mRemoveOnExit=" + this.mRemoveOnExit + " mDestroying=" + this.mDestroying + " mRemoved=" + this.mRemoved);
        }
        if (this.getOrientationChanging() || this.mAppFreezing || this.mReportOrientationChanged) {
            pw.println(prefix + "mOrientationChanging=" + this.mOrientationChanging + " configOrientationChanging=" + (this.getLastReportedConfiguration().orientation != this.getConfiguration().orientation) + " mAppFreezing=" + this.mAppFreezing + " mReportOrientationChanged=" + this.mReportOrientationChanged);
        }
        if (this.mLastFreezeDuration != 0) {
            pw.print(prefix + "mLastFreezeDuration=");
            TimeUtils.formatDuration((long)this.mLastFreezeDuration, pw);
            pw.println();
        }
        pw.print(prefix + "mForceSeamlesslyRotate=" + this.mForceSeamlesslyRotate + " seamlesslyRotate: pending=");
        if (this.mPendingSeamlessRotate != null) {
            this.mPendingSeamlessRotate.dump(pw);
        } else {
            pw.print("null");
        }
        pw.println(" finishedFrameNumber=" + this.mFinishSeamlessRotateFrameNumber);
        if (this.mHScale != 1.0f || this.mVScale != 1.0f) {
            pw.println(prefix + "mHScale=" + this.mHScale + " mVScale=" + this.mVScale);
        }
        if (this.mWallpaperX != -1.0f || this.mWallpaperY != -1.0f) {
            pw.println(prefix + "mWallpaperX=" + this.mWallpaperX + " mWallpaperY=" + this.mWallpaperY);
        }
        if (this.mWallpaperXStep != -1.0f || this.mWallpaperYStep != -1.0f) {
            pw.println(prefix + "mWallpaperXStep=" + this.mWallpaperXStep + " mWallpaperYStep=" + this.mWallpaperYStep);
        }
        if (this.mWallpaperDisplayOffsetX != Integer.MIN_VALUE || this.mWallpaperDisplayOffsetY != Integer.MIN_VALUE) {
            pw.println(prefix + "mWallpaperDisplayOffsetX=" + this.mWallpaperDisplayOffsetX + " mWallpaperDisplayOffsetY=" + this.mWallpaperDisplayOffsetY);
        }
        if (this.mDrawLock != null) {
            pw.println(prefix + "mDrawLock=" + this.mDrawLock);
        }
        if (this.isDragResizing()) {
            pw.println(prefix + "isDragResizing=" + this.isDragResizing());
        }
        if (this.computeDragResizing()) {
            pw.println(prefix + "computeDragResizing=" + this.computeDragResizing());
        }
        pw.println(prefix + "isOnScreen=" + this.isOnScreen());
        pw.println(prefix + "isVisible=" + this.isVisible());
    }

    @Override
    String getName() {
        return Integer.toHexString(System.identityHashCode(this)) + " " + this.getWindowTag();
    }

    CharSequence getWindowTag() {
        CharSequence tag = this.mAttrs.getTitle();
        if (tag == null || tag.length() <= 0) {
            tag = this.mAttrs.packageName;
        }
        return tag;
    }

    public String toString() {
        CharSequence title = this.getWindowTag();
        if (this.mStringNameCache == null || this.mLastTitle != title || this.mWasExiting != this.mAnimatingExit) {
            this.mLastTitle = title;
            this.mWasExiting = this.mAnimatingExit;
            this.mStringNameCache = "Window{" + Integer.toHexString(System.identityHashCode(this)) + " u" + UserHandle.getUserId(this.mOwnerUid) + " " + this.mLastTitle + (this.mAnimatingExit ? " EXITING}" : "}");
        }
        return this.mStringNameCache;
    }

    void transformClipRectFromScreenToSurfaceSpace(Rect clipRect) {
        if (this.mHScale == 1.0f && this.mVScale == 1.0f) {
            return;
        }
        if (this.mHScale >= 0.0f) {
            clipRect.left = (int)((float)clipRect.left / this.mHScale);
            clipRect.right = (int)Math.ceil((float)clipRect.right / this.mHScale);
        }
        if (this.mVScale >= 0.0f) {
            clipRect.top = (int)((float)clipRect.top / this.mVScale);
            clipRect.bottom = (int)Math.ceil((float)clipRect.bottom / this.mVScale);
        }
    }

    private void applyGravityAndUpdateFrame(Rect containingFrame, Rect displayFrame) {
        float y;
        float x;
        int h;
        int w;
        int pw = containingFrame.width();
        int ph = containingFrame.height();
        Task task = this.getTask();
        boolean inNonFullscreenContainer = !this.inAppWindowThatMatchesParentBounds();
        boolean noLimits = (this.mAttrs.flags & 0x200) != 0;
        boolean fitToDisplay = task == null || !inNonFullscreenContainer || this.mAttrs.type != 1 && !noLimits;
        boolean inSizeCompatMode = this.inSizeCompatMode();
        if ((this.mAttrs.flags & 0x4000) != 0) {
            w = this.mAttrs.width < 0 ? pw : (inSizeCompatMode ? (int)((float)this.mAttrs.width * this.mGlobalScale + 0.5f) : this.mAttrs.width);
            h = this.mAttrs.height < 0 ? ph : (inSizeCompatMode ? (int)((float)this.mAttrs.height * this.mGlobalScale + 0.5f) : this.mAttrs.height);
        } else {
            w = this.mAttrs.width == -1 ? pw : (inSizeCompatMode ? (int)((float)this.mRequestedWidth * this.mGlobalScale + 0.5f) : this.mRequestedWidth);
            h = this.mAttrs.height == -1 ? ph : (inSizeCompatMode ? (int)((float)this.mRequestedHeight * this.mGlobalScale + 0.5f) : this.mRequestedHeight);
        }
        if (inSizeCompatMode) {
            x = (float)this.mAttrs.x * this.mGlobalScale;
            y = (float)this.mAttrs.y * this.mGlobalScale;
        } else {
            x = this.mAttrs.x;
            y = this.mAttrs.y;
        }
        if (inNonFullscreenContainer && !this.layoutInParentFrame()) {
            w = Math.min(w, pw);
            h = Math.min(h, ph);
        }
        Gravity.apply(this.mAttrs.gravity, w, h, containingFrame, (int)(x + this.mAttrs.horizontalMargin * (float)pw), (int)(y + this.mAttrs.verticalMargin * (float)ph), this.mWindowFrames.mFrame);
        if (fitToDisplay) {
            Gravity.applyDisplay(this.mAttrs.gravity, displayFrame, this.mWindowFrames.mFrame);
        }
        this.mWindowFrames.mCompatFrame.set(this.mWindowFrames.mFrame);
        if (inSizeCompatMode) {
            this.mWindowFrames.mCompatFrame.scale(this.mInvGlobalScale);
        }
    }

    boolean isChildWindow() {
        return this.mIsChildWindow;
    }

    boolean layoutInParentFrame() {
        return this.mIsChildWindow && (this.mAttrs.privateFlags & 0x10000) != 0;
    }

    boolean hideNonSystemOverlayWindowsWhenVisible() {
        return (this.mAttrs.privateFlags & 0x80000) != 0 && this.mSession.mCanHideNonSystemOverlayWindows;
    }

    WindowState getParentWindow() {
        return this.mIsChildWindow ? (WindowState)super.getParent() : null;
    }

    WindowState getTopParentWindow() {
        WindowState current;
        WindowState topParent = current = this;
        while (current != null && current.mIsChildWindow) {
            if ((current = current.getParentWindow()) == null) continue;
            topParent = current;
        }
        return topParent;
    }

    boolean isParentWindowHidden() {
        WindowState parent = this.getParentWindow();
        return parent != null && parent.mHidden;
    }

    private boolean isParentWindowGoneForLayout() {
        WindowState parent = this.getParentWindow();
        return parent != null && parent.isGoneForLayoutLw();
    }

    void setWillReplaceWindow(boolean animate) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.setWillReplaceWindow(animate);
        }
        if ((this.mAttrs.privateFlags & 0x8000) != 0 || this.mAttrs.type == 3) {
            return;
        }
        this.mWillReplaceWindow = true;
        this.mReplacementWindow = null;
        this.mAnimateReplacingWindow = animate;
    }

    void clearWillReplaceWindow() {
        this.mWillReplaceWindow = false;
        this.mReplacementWindow = null;
        this.mAnimateReplacingWindow = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.clearWillReplaceWindow();
        }
    }

    boolean waitingForReplacement() {
        if (this.mWillReplaceWindow) {
            return true;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            if (!c.waitingForReplacement()) continue;
            return true;
        }
        return false;
    }

    void requestUpdateWallpaperIfNeeded() {
        DisplayContent dc = this.getDisplayContent();
        if (dc != null && (this.mAttrs.flags & 0x100000) != 0) {
            dc.pendingLayoutChanges |= 4;
            dc.setLayoutNeeded();
            this.mWmService.mWindowPlacerLocked.requestTraversal();
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.requestUpdateWallpaperIfNeeded();
        }
    }

    float translateToWindowX(float x) {
        float winX = x - (float)this.mWindowFrames.mFrame.left;
        if (this.inSizeCompatMode()) {
            winX *= this.mGlobalScale;
        }
        return winX;
    }

    float translateToWindowY(float y) {
        float winY = y - (float)this.mWindowFrames.mFrame.top;
        if (this.inSizeCompatMode()) {
            winY *= this.mGlobalScale;
        }
        return winY;
    }

    boolean shouldBeReplacedWithChildren() {
        return this.mIsChildWindow || this.mAttrs.type == 2 || this.mAttrs.type == 4;
    }

    void setWillReplaceChildWindows() {
        if (this.shouldBeReplacedWithChildren()) {
            this.setWillReplaceWindow(false);
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.setWillReplaceChildWindows();
        }
    }

    WindowState getReplacingWindow() {
        if (this.mAnimatingExit && this.mWillReplaceWindow && this.mAnimateReplacingWindow) {
            return this;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            WindowState replacing = c.getReplacingWindow();
            if (replacing == null) continue;
            return replacing;
        }
        return null;
    }

    @Override
    public int getRotationAnimationHint() {
        if (this.mAppToken != null) {
            return this.mAppToken.mRotationAnimationHint;
        }
        return -1;
    }

    @Override
    public boolean isInputMethodWindow() {
        return this.mIsImWindow;
    }

    boolean performShowLocked() {
        if (this.isHiddenFromUserLocked()) {
            this.clearPolicyVisibilityFlag(2);
            return false;
        }
        this.logPerformShow("performShow on ");
        int drawState = this.mWinAnimator.mDrawState;
        if ((drawState == 4 || drawState == 3) && this.mAttrs.type != 3 && this.mAppToken != null) {
            this.mAppToken.onFirstWindowDrawn(this, this.mWinAnimator);
        }
        if (this.mWinAnimator.mDrawState != 3 || !this.isReadyForDisplay()) {
            return false;
        }
        this.logPerformShow("Showing ");
        this.mWmService.enableScreenIfNeededLocked();
        this.mWinAnimator.applyEnterAnimationLocked();
        this.mWinAnimator.mLastAlpha = -1.0f;
        this.mWinAnimator.mDrawState = 4;
        this.mWmService.scheduleAnimationLocked();
        if (this.mHidden) {
            this.mHidden = false;
            DisplayContent displayContent = this.getDisplayContent();
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                WindowState c = (WindowState)this.mChildren.get(i);
                if (c.mWinAnimator.mSurfaceController == null) continue;
                c.performShowLocked();
                if (displayContent == null) continue;
                displayContent.setLayoutNeeded();
            }
        }
        if (this.mAttrs.type == 2011) {
            this.getDisplayContent().mDividerControllerLocked.resetImeHideRequested();
        }
        return true;
    }

    private void logPerformShow(String prefix) {
    }

    WindowInfo getWindowInfo() {
        int childCount;
        boolean isAccessibilityOverlay;
        WindowInfo windowInfo = WindowInfo.obtain();
        windowInfo.type = this.mAttrs.type;
        windowInfo.layer = this.mLayer;
        windowInfo.token = this.mClient.asBinder();
        if (this.mAppToken != null) {
            windowInfo.activityToken = this.mAppToken.appToken.asBinder();
        }
        windowInfo.title = this.mAttrs.accessibilityTitle;
        boolean isPanelWindow = this.mAttrs.type >= 1000 && this.mAttrs.type <= 1999;
        boolean bl = isAccessibilityOverlay = windowInfo.type == 2032;
        if (TextUtils.isEmpty(windowInfo.title) && (isPanelWindow || isAccessibilityOverlay)) {
            CharSequence title = this.mAttrs.getTitle();
            windowInfo.title = TextUtils.isEmpty(title) ? null : title;
        }
        windowInfo.accessibilityIdOfAnchor = this.mAttrs.accessibilityIdOfAnchor;
        windowInfo.focused = this.isFocused();
        Task task = this.getTask();
        windowInfo.inPictureInPicture = task != null && task.inPinnedWindowingMode();
        boolean bl2 = windowInfo.hasFlagWatchOutsideTouch = (this.mAttrs.flags & 0x40000) != 0;
        if (this.mIsChildWindow) {
            windowInfo.parentToken = this.getParentWindow().mClient.asBinder();
        }
        if ((childCount = this.mChildren.size()) > 0) {
            if (windowInfo.childTokens == null) {
                windowInfo.childTokens = new ArrayList<IBinder>(childCount);
            }
            for (int j = 0; j < childCount; ++j) {
                WindowState child = (WindowState)this.mChildren.get(j);
                windowInfo.childTokens.add(child.mClient.asBinder());
            }
        }
        return windowInfo;
    }

    @Override
    boolean forAllWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        if (this.mChildren.isEmpty()) {
            return this.applyInOrderWithImeWindows(callback, traverseTopToBottom);
        }
        if (traverseTopToBottom) {
            return this.forAllWindowTopToBottom(callback);
        }
        return this.forAllWindowBottomToTop(callback);
    }

    private boolean forAllWindowBottomToTop(ToBooleanFunction<WindowState> callback) {
        int i = 0;
        int count = this.mChildren.size();
        WindowState child = (WindowState)this.mChildren.get(i);
        while (i < count && child.mSubLayer < 0) {
            if (child.applyInOrderWithImeWindows(callback, false)) {
                return true;
            }
            if (++i >= count) break;
            child = (WindowState)this.mChildren.get(i);
        }
        if (this.applyInOrderWithImeWindows(callback, false)) {
            return true;
        }
        while (i < count) {
            if (child.applyInOrderWithImeWindows(callback, false)) {
                return true;
            }
            if (++i >= count) break;
            child = (WindowState)this.mChildren.get(i);
        }
        return false;
    }

    private boolean forAllWindowTopToBottom(ToBooleanFunction<WindowState> callback) {
        int i = this.mChildren.size() - 1;
        WindowState child = (WindowState)this.mChildren.get(i);
        while (i >= 0 && child.mSubLayer >= 0) {
            if (child.applyInOrderWithImeWindows(callback, true)) {
                return true;
            }
            if (--i < 0) break;
            child = (WindowState)this.mChildren.get(i);
        }
        if (this.applyInOrderWithImeWindows(callback, true)) {
            return true;
        }
        while (i >= 0) {
            if (child.applyInOrderWithImeWindows(callback, true)) {
                return true;
            }
            if (--i < 0) break;
            child = (WindowState)this.mChildren.get(i);
        }
        return false;
    }

    private boolean applyImeWindowsIfNeeded(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        return this.isInputMethodTarget() && !this.inSplitScreenWindowingMode() && this.getDisplayContent().forAllImeWindows(callback, traverseTopToBottom);
    }

    private boolean applyInOrderWithImeWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        return traverseTopToBottom ? this.applyImeWindowsIfNeeded(callback, traverseTopToBottom) || callback.apply(this) : callback.apply(this) || this.applyImeWindowsIfNeeded(callback, traverseTopToBottom);
    }

    @Override
    WindowState getWindow(Predicate<WindowState> callback) {
        if (this.mChildren.isEmpty()) {
            return callback.test(this) ? this : null;
        }
        int i = this.mChildren.size() - 1;
        WindowState child = (WindowState)this.mChildren.get(i);
        while (i >= 0 && child.mSubLayer >= 0) {
            if (callback.test(child)) {
                return child;
            }
            if (--i < 0) break;
            child = (WindowState)this.mChildren.get(i);
        }
        if (callback.test(this)) {
            return this;
        }
        while (i >= 0) {
            if (callback.test(child)) {
                return child;
            }
            if (--i < 0) break;
            child = (WindowState)this.mChildren.get(i);
        }
        return null;
    }

    @VisibleForTesting
    boolean isSelfOrAncestorWindowAnimatingExit() {
        WindowState window = this;
        do {
            if (!window.mAnimatingExit) continue;
            return true;
        } while ((window = window.getParentWindow()) != null);
        return false;
    }

    void onExitAnimationDone() {
        if (!this.mChildren.isEmpty()) {
            ArrayList childWindows = new ArrayList(this.mChildren);
            for (int i = childWindows.size() - 1; i >= 0; --i) {
                ((WindowState)childWindows.get(i)).onExitAnimationDone();
            }
        }
        if (this.mWinAnimator.mEnteringAnimation) {
            this.mWinAnimator.mEnteringAnimation = false;
            this.mWmService.requestTraversal();
            if (this.mAppToken == null) {
                try {
                    this.mClient.dispatchWindowShown();
                }
                catch (RemoteException childWindows) {
                    // empty catch block
                }
            }
        }
        if (this.isSelfAnimating()) {
            return;
        }
        if (this.mWmService.mAccessibilityController != null && (this.getDisplayId() == 0 || this.getDisplayContent().getParentWindow() != null)) {
            this.mWmService.mAccessibilityController.onSomeWindowResizedOrMovedLocked();
        }
        if (!this.isSelfOrAncestorWindowAnimatingExit()) {
            return;
        }
        this.mDestroying = true;
        boolean hasSurface = this.mWinAnimator.hasSurface();
        this.mWinAnimator.hide(this.getPendingTransaction(), "onExitAnimationDone");
        if (this.mAppToken != null) {
            this.mAppToken.destroySurfaces();
        } else {
            if (hasSurface) {
                this.mWmService.mDestroySurface.add(this);
            }
            if (this.mRemoveOnExit) {
                this.mWmService.mPendingRemove.add(this);
                this.mRemoveOnExit = false;
            }
        }
        this.mAnimatingExit = false;
        this.getDisplayContent().mWallpaperController.hideWallpapers(this);
    }

    boolean clearAnimatingFlags() {
        boolean didSomething = false;
        if (!this.mWillReplaceWindow && !this.mRemoveOnExit) {
            if (this.mAnimatingExit) {
                this.mAnimatingExit = false;
                didSomething = true;
            }
            if (this.mDestroying) {
                this.mDestroying = false;
                this.mWmService.mDestroySurface.remove(this);
                didSomething = true;
            }
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            didSomething |= ((WindowState)this.mChildren.get(i)).clearAnimatingFlags();
        }
        return didSomething;
    }

    public boolean isRtl() {
        return this.getConfiguration().getLayoutDirection() == 1;
    }

    void hideWallpaperWindow(boolean wasDeferred, String reason) {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            WindowState c = (WindowState)this.mChildren.get(j);
            c.hideWallpaperWindow(wasDeferred, reason);
        }
        if (!this.mWinAnimator.mLastHidden || wasDeferred) {
            this.mWinAnimator.hide(reason);
            this.getDisplayContent().mWallpaperController.mDeferredHideWallpaper = null;
            this.dispatchWallpaperVisibility(false);
            DisplayContent displayContent = this.getDisplayContent();
            if (displayContent != null) {
                displayContent.pendingLayoutChanges |= 4;
            }
        }
    }

    void dispatchWallpaperVisibility(boolean visible) {
        boolean hideAllowed;
        boolean bl = hideAllowed = this.getDisplayContent().mWallpaperController.mDeferredHideWallpaper == null;
        if (this.mWallpaperVisible != visible && (hideAllowed || visible)) {
            this.mWallpaperVisible = visible;
            try {
                this.mClient.dispatchAppVisibility(visible);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    boolean hasVisibleNotDrawnWallpaper() {
        if (this.mWallpaperVisible && !this.isDrawnLw()) {
            return true;
        }
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            WindowState c = (WindowState)this.mChildren.get(j);
            if (!c.hasVisibleNotDrawnWallpaper()) continue;
            return true;
        }
        return false;
    }

    void updateReportedVisibility(UpdateReportedVisibilityResults results) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.updateReportedVisibility(results);
        }
        if (this.mAppFreezing || this.mViewVisibility != 0 || this.mAttrs.type == 3 || this.mDestroying) {
            return;
        }
        ++results.numInteresting;
        if (this.isDrawnLw()) {
            ++results.numDrawn;
            if (!this.isAnimating()) {
                ++results.numVisible;
            }
            results.nowGone = false;
        } else if (this.isAnimating()) {
            results.nowGone = false;
        }
    }

    private boolean skipDecorCrop() {
        if (this.mWindowFrames.mDecorFrame.isEmpty()) {
            return true;
        }
        if (this.mAppToken != null) {
            return false;
        }
        return this.mToken.canLayerAboveSystemBars();
    }

    void calculatePolicyCrop(Rect policyCrop) {
        DisplayContent displayContent = this.getDisplayContent();
        if (!displayContent.isDefaultDisplay && !displayContent.supportsSystemDecorations()) {
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            policyCrop.set(0, 0, this.mWindowFrames.mCompatFrame.width(), this.mWindowFrames.mCompatFrame.height());
            policyCrop.intersect(-this.mWindowFrames.mCompatFrame.left, -this.mWindowFrames.mCompatFrame.top, displayInfo.logicalWidth - this.mWindowFrames.mCompatFrame.left, displayInfo.logicalHeight - this.mWindowFrames.mCompatFrame.top);
        } else if (this.skipDecorCrop()) {
            policyCrop.set(0, 0, this.mWindowFrames.mCompatFrame.width(), this.mWindowFrames.mCompatFrame.height());
        } else {
            this.calculateSystemDecorRect(policyCrop);
        }
    }

    private void calculateSystemDecorRect(Rect systemDecorRect) {
        boolean cropToDecor;
        Rect decorRect = this.mWindowFrames.mDecorFrame;
        int width = this.mWindowFrames.mFrame.width();
        int height = this.mWindowFrames.mFrame.height();
        int left = this.mWindowFrames.mFrame.left;
        int top = this.mWindowFrames.mFrame.top;
        if (this.isDockedResizing()) {
            DisplayInfo displayInfo = this.getDisplayContent().getDisplayInfo();
            systemDecorRect.set(0, 0, Math.max(width, displayInfo.logicalWidth), Math.max(height, displayInfo.logicalHeight));
        } else {
            systemDecorRect.set(0, 0, width, height);
        }
        boolean bl = cropToDecor = (!this.inFreeformWindowingMode() || !this.isAnimatingLw()) && !this.isDockedResizing();
        if (cropToDecor) {
            systemDecorRect.intersect(decorRect.left - left, decorRect.top - top, decorRect.right - left, decorRect.bottom - top);
        }
        if (this.mInvGlobalScale != 1.0f && this.inSizeCompatMode()) {
            float scale = this.mInvGlobalScale;
            systemDecorRect.left = (int)((float)systemDecorRect.left * scale - 0.5f);
            systemDecorRect.top = (int)((float)systemDecorRect.top * scale - 0.5f);
            systemDecorRect.right = (int)((float)(systemDecorRect.right + 1) * scale - 0.5f);
            systemDecorRect.bottom = (int)((float)(systemDecorRect.bottom + 1) * scale - 0.5f);
        }
    }

    void expandForSurfaceInsets(Rect r) {
        r.inset(-this.mAttrs.surfaceInsets.left, -this.mAttrs.surfaceInsets.top, -this.mAttrs.surfaceInsets.right, -this.mAttrs.surfaceInsets.bottom);
    }

    boolean surfaceInsetsChanging() {
        return !this.mLastSurfaceInsets.equals(this.mAttrs.surfaceInsets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int relayoutVisibleWindow(int result, int attrChanges) {
        boolean wasVisible = this.isVisibleLw();
        result |= !wasVisible || !this.isDrawnLw() ? 2 : 0;
        if (this.mAnimatingExit) {
            Slog.d(TAG, "relayoutVisibleWindow: " + this + " mAnimatingExit=true, mRemoveOnExit=" + this.mRemoveOnExit + ", mDestroying=" + this.mDestroying);
            if (this.isSelfAnimating()) {
                this.cancelAnimation();
                this.destroySurfaceUnchecked();
            }
            this.mAnimatingExit = false;
        }
        if (this.mDestroying) {
            this.mDestroying = false;
            this.mWmService.mDestroySurface.remove(this);
        }
        if (!wasVisible) {
            this.mWinAnimator.mEnterAnimationPending = true;
        }
        this.mLastVisibleLayoutRotation = this.getDisplayContent().getRotation();
        this.mWinAnimator.mEnteringAnimation = true;
        Trace.traceBegin(32L, "prepareToDisplay");
        try {
            this.prepareWindowToDisplayDuringRelayout(wasVisible);
        }
        finally {
            Trace.traceEnd(32L);
        }
        if ((attrChanges & 8) != 0 && !this.mWinAnimator.tryChangeFormatInPlaceLocked()) {
            this.mWinAnimator.preserveSurfaceLocked();
            result |= 6;
        }
        if (this.isDragResizeChanged()) {
            this.setDragResizing();
            if (this.mHasSurface && !this.isChildWindow()) {
                this.mWinAnimator.preserveSurfaceLocked();
                result |= 6;
            }
        }
        boolean freeformResizing = this.isDragResizing() && this.getResizeMode() == 0;
        boolean dockedResizing = this.isDragResizing() && this.getResizeMode() == 1;
        result |= freeformResizing ? 16 : 0;
        return result |= dockedResizing ? 8 : 0;
    }

    boolean isLaidOut() {
        return this.mLayoutSeq != -1;
    }

    void updateLastInsetValues() {
        this.mWindowFrames.updateLastInsetValues();
    }

    void startAnimation(Animation anim2) {
        if (this.mInsetProvider != null && this.mInsetProvider.isControllable()) {
            return;
        }
        DisplayInfo displayInfo = this.getDisplayContent().getDisplayInfo();
        anim2.initialize(this.mWindowFrames.mFrame.width(), this.mWindowFrames.mFrame.height(), displayInfo.appWidth, displayInfo.appHeight);
        anim2.restrictDuration(10000L);
        anim2.scaleCurrentDuration(this.mWmService.getWindowAnimationScaleLocked());
        LocalAnimationAdapter adapter = new LocalAnimationAdapter(new WindowAnimationSpec(anim2, this.mSurfacePosition, false, 0.0f), this.mWmService.mSurfaceAnimationRunner);
        this.startAnimation(this.getPendingTransaction(), adapter);
        this.commitPendingTransaction();
    }

    private void startMoveAnimation(int left, int top) {
        if (this.mInsetProvider != null && this.mInsetProvider.isControllable()) {
            return;
        }
        Point oldPosition = new Point();
        Point newPosition = new Point();
        this.transformFrameToSurfacePosition(this.mWindowFrames.mLastFrame.left, this.mWindowFrames.mLastFrame.top, oldPosition);
        this.transformFrameToSurfacePosition(left, top, newPosition);
        LocalAnimationAdapter adapter = new LocalAnimationAdapter(new MoveAnimationSpec(oldPosition.x, oldPosition.y, newPosition.x, newPosition.y), this.mWmService.mSurfaceAnimationRunner);
        this.startAnimation(this.getPendingTransaction(), adapter);
    }

    private void startAnimation(SurfaceControl.Transaction t, AnimationAdapter adapter) {
        this.startAnimation(t, adapter, this.mWinAnimator.mLastHidden);
    }

    @Override
    protected void onAnimationFinished() {
        super.onAnimationFinished();
        this.mWinAnimator.onAnimationFinished();
    }

    void getTransformationMatrix(float[] float9, Matrix outMatrix) {
        float9[0] = this.mWinAnimator.mDsDx;
        float9[3] = this.mWinAnimator.mDtDx;
        float9[1] = this.mWinAnimator.mDtDy;
        float9[4] = this.mWinAnimator.mDsDy;
        int x = this.mSurfacePosition.x;
        int y = this.mSurfacePosition.y;
        DisplayContent dc = this.getDisplayContent();
        while (dc != null && dc.getParentWindow() != null) {
            WindowState displayParent = dc.getParentWindow();
            x = (int)((float)x + ((float)(displayParent.mWindowFrames.mFrame.left - displayParent.mAttrs.surfaceInsets.left) + ((float)dc.getLocationInParentWindow().x * displayParent.mGlobalScale + 0.5f)));
            y = (int)((float)y + ((float)(displayParent.mWindowFrames.mFrame.top - displayParent.mAttrs.surfaceInsets.top) + ((float)dc.getLocationInParentWindow().y * displayParent.mGlobalScale + 0.5f)));
            dc = displayParent.getDisplayContent();
        }
        WindowContainer parent = this.getParent();
        if (this.isChildWindow()) {
            WindowState parentWindow = this.getParentWindow();
            x += parentWindow.mWindowFrames.mFrame.left - parentWindow.mAttrs.surfaceInsets.left;
            y += parentWindow.mWindowFrames.mFrame.top - parentWindow.mAttrs.surfaceInsets.top;
        } else if (parent != null) {
            Rect parentBounds = parent.getBounds();
            x += parentBounds.left;
            y += parentBounds.top;
        }
        float9[2] = x;
        float9[5] = y;
        float9[6] = 0.0f;
        float9[7] = 0.0f;
        float9[8] = 1.0f;
        outMatrix.setValues(float9);
    }

    @Override
    boolean shouldMagnify() {
        return this.mAttrs.type != 2011 && this.mAttrs.type != 2012 && this.mAttrs.type != 2027 && this.mAttrs.type != 2019 && this.mAttrs.type != 2024;
    }

    @Override
    SurfaceSession getSession() {
        if (this.mSession.mSurfaceSession != null) {
            return this.mSession.mSurfaceSession;
        }
        return this.getParent().getSession();
    }

    @Override
    boolean needsZBoost() {
        AppWindowToken appToken;
        WindowState inputMethodTarget = this.getDisplayContent().mInputMethodTarget;
        if (this.mIsImWindow && inputMethodTarget != null && (appToken = inputMethodTarget.mAppToken) != null) {
            return appToken.needsZBoost();
        }
        return this.mWillReplaceWindow;
    }

    private void applyDims(Dimmer dimmer) {
        if (!this.mAnimatingExit && this.mAppDied) {
            this.mIsDimming = true;
            dimmer.dimAbove(this.getPendingTransaction(), this, 0.5f);
        } else if ((this.mAttrs.flags & 2) != 0 && this.isVisibleNow() && !this.mHidden) {
            this.mIsDimming = true;
            dimmer.dimBelow(this.getPendingTransaction(), this, this.mAttrs.dimAmount);
        }
    }

    @Override
    void prepareSurfaces() {
        Dimmer dimmer = this.getDimmer();
        this.mIsDimming = false;
        if (dimmer != null) {
            this.applyDims(dimmer);
        }
        this.updateSurfacePosition();
        this.mWinAnimator.prepareSurfaceLocked(true);
        super.prepareSurfaces();
    }

    @Override
    public void onAnimationLeashCreated(SurfaceControl.Transaction t, SurfaceControl leash) {
        super.onAnimationLeashCreated(t, leash);
        t.setPosition(this.mSurfaceControl, 0.0f, 0.0f);
        this.mLastSurfacePosition.set(0, 0);
    }

    @Override
    public void onAnimationLeashLost(SurfaceControl.Transaction t) {
        super.onAnimationLeashLost(t);
        this.updateSurfacePosition(t);
    }

    @Override
    void updateSurfacePosition() {
        this.updateSurfacePosition(this.getPendingTransaction());
    }

    @VisibleForTesting
    void updateSurfacePosition(SurfaceControl.Transaction t) {
        if (this.mSurfaceControl == null) {
            return;
        }
        this.transformFrameToSurfacePosition(this.mWindowFrames.mFrame.left, this.mWindowFrames.mFrame.top, this.mSurfacePosition);
        if (!this.mSurfaceAnimator.hasLeash() && this.mPendingSeamlessRotate == null && !this.mLastSurfacePosition.equals(this.mSurfacePosition)) {
            t.setPosition(this.mSurfaceControl, this.mSurfacePosition.x, this.mSurfacePosition.y);
            this.mLastSurfacePosition.set(this.mSurfacePosition.x, this.mSurfacePosition.y);
            if (this.surfaceInsetsChanging() && this.mWinAnimator.hasSurface()) {
                this.mLastSurfaceInsets.set(this.mAttrs.surfaceInsets);
                t.deferTransactionUntil(this.mSurfaceControl, this.mWinAnimator.mSurfaceController.mSurfaceControl.getHandle(), this.getFrameNumber());
            }
        }
    }

    private void transformFrameToSurfacePosition(int left, int top, Point outPoint) {
        outPoint.set(left, top);
        WindowContainer parentWindowContainer = this.getParent();
        if (this.isChildWindow()) {
            WindowState parent = this.getParentWindow();
            this.transformSurfaceInsetsPosition(this.mTmpPoint, parent.mAttrs.surfaceInsets);
            outPoint.offset(-parent.mWindowFrames.mFrame.left + this.mTmpPoint.x, -parent.mWindowFrames.mFrame.top + this.mTmpPoint.y);
        } else if (parentWindowContainer != null) {
            Rect parentBounds = parentWindowContainer.getDisplayedBounds();
            outPoint.offset(-parentBounds.left, -parentBounds.top);
        }
        TaskStack stack = this.getStack();
        if (stack != null) {
            int outset = stack.getStackOutset();
            outPoint.offset(outset, outset);
        }
        this.transformSurfaceInsetsPosition(this.mTmpPoint, this.mAttrs.surfaceInsets);
        outPoint.offset(-this.mTmpPoint.x, -this.mTmpPoint.y);
    }

    private void transformSurfaceInsetsPosition(Point outPos, Rect surfaceInsets) {
        if (!this.inSizeCompatMode()) {
            outPos.x = surfaceInsets.left;
            outPos.y = surfaceInsets.top;
            return;
        }
        outPos.x = (int)((float)surfaceInsets.left * this.mGlobalScale + 0.5f);
        outPos.y = (int)((float)surfaceInsets.top * this.mGlobalScale + 0.5f);
    }

    boolean needsRelativeLayeringToIme() {
        if (!this.inSplitScreenWindowingMode()) {
            return false;
        }
        if (this.isChildWindow()) {
            if (this.getParentWindow().isInputMethodTarget()) {
                return true;
            }
        } else if (this.mAppToken != null) {
            WindowState imeTarget = this.getDisplayContent().mInputMethodTarget;
            boolean inTokenWithAndAboveImeTarget = imeTarget != null && imeTarget != this && imeTarget.mToken == this.mToken && imeTarget.compareTo(this) <= 0;
            return inTokenWithAndAboveImeTarget;
        }
        return false;
    }

    @Override
    void assignLayer(SurfaceControl.Transaction t, int layer) {
        if (this.needsRelativeLayeringToIme()) {
            this.getDisplayContent().assignRelativeLayerForImeTargetChild(t, this);
            return;
        }
        super.assignLayer(t, layer);
    }

    @Override
    public boolean isDimming() {
        return this.mIsDimming;
    }

    @Override
    public void assignChildLayers(SurfaceControl.Transaction t) {
        int layer = 2;
        for (int i = 0; i < this.mChildren.size(); ++i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            if (w.mAttrs.type == 1001) {
                w.assignLayer(t, -2);
            } else if (w.mAttrs.type == 1004) {
                w.assignLayer(t, -1);
            } else {
                w.assignLayer(t, layer);
            }
            w.assignChildLayers(t);
            ++layer;
        }
    }

    void updateTapExcludeRegion(int regionId, Region region) {
        DisplayContent currentDisplay = this.getDisplayContent();
        if (currentDisplay == null) {
            throw new IllegalStateException("Trying to update window not attached to any display.");
        }
        if (this.mTapExcludeRegionHolder == null) {
            this.mTapExcludeRegionHolder = new TapExcludeRegionHolder();
            currentDisplay.mTapExcludeProvidingWindows.add(this);
        }
        this.mTapExcludeRegionHolder.updateRegion(regionId, region);
        currentDisplay.updateTouchExcludeRegion();
        currentDisplay.getInputMonitor().updateInputWindowsLw(true);
    }

    void amendTapExcludeRegion(Region region) {
        Region tempRegion = Region.obtain();
        this.mTmpRect.set(this.mWindowFrames.mFrame);
        this.mTmpRect.offsetTo(0, 0);
        this.mTapExcludeRegionHolder.amendRegion(tempRegion, this.mTmpRect);
        tempRegion.translate(this.mWindowFrames.mFrame.left, this.mWindowFrames.mFrame.top);
        region.op(tempRegion, Region.Op.UNION);
        tempRegion.recycle();
    }

    @Override
    public boolean isInputMethodTarget() {
        return this.getDisplayContent().mInputMethodTarget == this;
    }

    long getFrameNumber() {
        return this.mFrameNumber;
    }

    void setFrameNumber(long frameNumber) {
        this.mFrameNumber = frameNumber;
    }

    public void getMaxVisibleBounds(Rect out) {
        if (out.isEmpty()) {
            out.set(this.mWindowFrames.mVisibleFrame);
            return;
        }
        if (this.mWindowFrames.mVisibleFrame.left < out.left) {
            out.left = this.mWindowFrames.mVisibleFrame.left;
        }
        if (this.mWindowFrames.mVisibleFrame.top < out.top) {
            out.top = this.mWindowFrames.mVisibleFrame.top;
        }
        if (this.mWindowFrames.mVisibleFrame.right > out.right) {
            out.right = this.mWindowFrames.mVisibleFrame.right;
        }
        if (this.mWindowFrames.mVisibleFrame.bottom > out.bottom) {
            out.bottom = this.mWindowFrames.mVisibleFrame.bottom;
        }
    }

    void getInsetsForRelayout(Rect outOverscanInsets, Rect outContentInsets, Rect outVisibleInsets, Rect outStableInsets, Rect outOutsets) {
        outOverscanInsets.set(this.mWindowFrames.mOverscanInsets);
        outContentInsets.set(this.mWindowFrames.mContentInsets);
        outVisibleInsets.set(this.mWindowFrames.mVisibleInsets);
        outStableInsets.set(this.mWindowFrames.mStableInsets);
        outOutsets.set(this.mWindowFrames.mOutsets);
        this.mLastRelayoutContentInsets.set(this.mWindowFrames.mContentInsets);
    }

    void getContentInsets(Rect outContentInsets) {
        outContentInsets.set(this.mWindowFrames.mContentInsets);
    }

    Rect getContentInsets() {
        return this.mWindowFrames.mContentInsets;
    }

    void getStableInsets(Rect outStableInsets) {
        outStableInsets.set(this.mWindowFrames.mStableInsets);
    }

    Rect getStableInsets() {
        return this.mWindowFrames.mStableInsets;
    }

    void resetLastContentInsets() {
        this.mWindowFrames.resetLastContentInsets();
    }

    Rect getVisibleInsets() {
        return this.mWindowFrames.mVisibleInsets;
    }

    @Override
    public WindowFrames getWindowFrames() {
        return this.mWindowFrames;
    }

    void resetContentChanged() {
        this.mWindowFrames.setContentChanged(false);
    }

    void setInsetProvider(InsetsSourceProvider insetProvider) {
        this.mInsetProvider = insetProvider;
    }

    InsetsSourceProvider getInsetProvider() {
        return this.mInsetProvider;
    }

    private final class MoveAnimationSpec
    implements LocalAnimationAdapter.AnimationSpec {
        private final long mDuration;
        private Interpolator mInterpolator;
        private Point mFrom = new Point();
        private Point mTo = new Point();

        private MoveAnimationSpec(int fromX, int fromY, int toX, int toY) {
            Animation anim2 = AnimationUtils.loadAnimation(WindowState.this.mContext, 17432916);
            this.mDuration = (long)((float)anim2.computeDurationHint() * WindowState.this.mWmService.getWindowAnimationScaleLocked());
            this.mInterpolator = anim2.getInterpolator();
            this.mFrom.set(fromX, fromY);
            this.mTo.set(toX, toY);
        }

        @Override
        public long getDuration() {
            return this.mDuration;
        }

        @Override
        public void apply(SurfaceControl.Transaction t, SurfaceControl leash, long currentPlayTime) {
            float fraction2 = (float)currentPlayTime / (float)this.getDuration();
            float v = this.mInterpolator.getInterpolation(fraction2);
            t.setPosition(leash, (float)this.mFrom.x + (float)(this.mTo.x - this.mFrom.x) * v, (float)this.mFrom.y + (float)(this.mTo.y - this.mFrom.y) * v);
        }

        @Override
        public void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + "from=" + this.mFrom + " to=" + this.mTo + " duration=" + this.mDuration);
        }

        @Override
        public void writeToProtoInner(ProtoOutputStream proto) {
            long token = proto.start(1146756268034L);
            this.mFrom.writeToProto(proto, 0x10B00000001L);
            this.mTo.writeToProto(proto, 1146756268034L);
            proto.write(0x10300000003L, this.mDuration);
            proto.end(token);
        }
    }

    private static final class WindowId
    extends IWindowId.Stub {
        private final WeakReference<WindowState> mOuter;

        private WindowId(WindowState outer) {
            this.mOuter = new WeakReference<WindowState>(outer);
        }

        @Override
        public void registerFocusObserver(IWindowFocusObserver observer) {
            WindowState outer = (WindowState)this.mOuter.get();
            if (outer != null) {
                outer.registerFocusObserver(observer);
            }
        }

        @Override
        public void unregisterFocusObserver(IWindowFocusObserver observer) {
            WindowState outer = (WindowState)this.mOuter.get();
            if (outer != null) {
                outer.unregisterFocusObserver(observer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isFocused() {
            boolean bl;
            WindowState outer = (WindowState)this.mOuter.get();
            if (outer == null) {
                return false;
            }
            WindowManagerGlobalLock windowManagerGlobalLock = outer.mWmService.mGlobalLock;
            synchronized (windowManagerGlobalLock) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    bl = outer.isFocused();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return bl;
        }
    }

    static final class UpdateReportedVisibilityResults {
        int numInteresting;
        int numVisible;
        int numDrawn;
        boolean nowGone = true;

        UpdateReportedVisibilityResults() {
        }

        void reset() {
            this.numInteresting = 0;
            this.numVisible = 0;
            this.numDrawn = 0;
            this.nowGone = true;
        }
    }

    private class DeathRecipient
    implements IBinder.DeathRecipient {
        private DeathRecipient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            block13: {
                try {
                    boolean resetSplitScreenResizing = false;
                    WindowManagerGlobalLock windowManagerGlobalLock = WindowState.this.mWmService.mGlobalLock;
                    synchronized (windowManagerGlobalLock) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            WindowState win = WindowState.this.mWmService.windowForClientLocked(WindowState.this.mSession, WindowState.this.mClient, false);
                            Slog.i(WindowState.TAG, "WIN DEATH: " + win);
                            if (win != null) {
                                DisplayContent dc = WindowState.this.getDisplayContent();
                                if (win.mAppToken != null && win.mAppToken.findMainWindow() == win) {
                                    WindowState.this.mWmService.mTaskSnapshotController.onAppDied(win.mAppToken);
                                }
                                win.removeIfPossible(WindowState.this.shouldKeepVisibleDeadAppWindow());
                                if (win.mAttrs.type == 2034) {
                                    TaskStack stack = dc.getSplitScreenPrimaryStackIgnoringVisibility();
                                    if (stack != null) {
                                        stack.resetDockedStackToMiddle();
                                    }
                                    resetSplitScreenResizing = true;
                                }
                            } else if (WindowState.this.mHasSurface) {
                                Slog.e(WindowState.TAG, "!!! LEAK !!! Window removed but surface still valid.");
                                WindowState.this.removeIfPossible();
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[0, 3, 4] lbl29 : MonitorExitStatement: MONITOREXIT : var2_3
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    if (!resetSplitScreenResizing) break block13;
                    try {
                        WindowState.this.mWmService.mActivityTaskManager.setSplitScreenResizing(false);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowAsRuntimeException();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private final class DeadWindowEventReceiver
    extends InputEventReceiver {
        DeadWindowEventReceiver(InputChannel inputChannel) {
            super(inputChannel, WindowState.this.mWmService.mH.getLooper());
        }

        @Override
        public void onInputEvent(InputEvent event) {
            this.finishInputEvent(event, true);
        }
    }

    static interface PowerManagerWrapper {
        public void wakeUp(long var1, int var3, String var4);

        public boolean isInteractive();
    }
}

