/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PixelFormat;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Trace;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.DisplayInfo;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.Session;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowAnimator;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowSurfaceController;
import java.io.PrintWriter;

class WindowStateAnimator {
    static final String TAG = "WindowManager";
    static final int WINDOW_FREEZE_LAYER = 2000000;
    static final int PRESERVED_SURFACE_LAYER = 1;
    static final int STACK_CLIP_AFTER_ANIM = 0;
    static final int STACK_CLIP_BEFORE_ANIM = 1;
    static final int STACK_CLIP_NONE = 2;
    final WindowManagerService mService;
    final WindowState mWin;
    final WindowAnimator mAnimator;
    final Session mSession;
    final WindowManagerPolicy mPolicy;
    final Context mContext;
    final boolean mIsWallpaper;
    private final WallpaperController mWallpaperControllerLocked;
    boolean mAnimationIsEntrance;
    boolean mSurfaceResized;
    boolean mReportSurfaceResized;
    WindowSurfaceController mSurfaceController;
    private WindowSurfaceController mPendingDestroySurface;
    boolean mSurfaceDestroyDeferred;
    private boolean mDestroyPreservedSurfaceUponRedraw;
    float mShownAlpha = 0.0f;
    float mAlpha = 0.0f;
    float mLastAlpha = 0.0f;
    Rect mTmpClipRect = new Rect();
    Rect mLastClipRect = new Rect();
    Rect mLastFinalClipRect = new Rect();
    Rect mTmpStackBounds = new Rect();
    private Rect mTmpAnimatingBounds = new Rect();
    private Rect mTmpSourceBounds = new Rect();
    private final Rect mSystemDecorRect = new Rect();
    float mDsDx = 1.0f;
    float mDtDx = 0.0f;
    float mDsDy = 0.0f;
    float mDtDy = 1.0f;
    private float mLastDsDx = 1.0f;
    private float mLastDtDx = 0.0f;
    private float mLastDsDy = 0.0f;
    private float mLastDtDy = 1.0f;
    boolean mHaveMatrix;
    boolean mEnterAnimationPending;
    boolean mEnteringAnimation;
    private final SurfaceControl.Transaction mTmpTransaction = new SurfaceControl.Transaction();
    int mSurfaceFormat;
    static final int NO_SURFACE = 0;
    static final int DRAW_PENDING = 1;
    static final int COMMIT_DRAW_PENDING = 2;
    static final int READY_TO_SHOW = 3;
    static final int HAS_DRAWN = 4;
    int mDrawState;
    boolean mLastHidden;
    int mAttrType;
    boolean mForceScaleUntilResize;
    float mExtraHScale = 1.0f;
    float mExtraVScale = 1.0f;
    int mXOffset = 0;
    int mYOffset = 0;
    private boolean mOffsetPositionForStackResize;
    private final Rect mTmpSize = new Rect();
    private final SurfaceControl.Transaction mReparentTransaction = new SurfaceControl.Transaction();
    boolean mChildrenDetached = false;
    boolean mPipAnimationStarted = false;
    private final Point mTmpPos = new Point();

    String drawStateToString() {
        switch (this.mDrawState) {
            case 0: {
                return "NO_SURFACE";
            }
            case 1: {
                return "DRAW_PENDING";
            }
            case 2: {
                return "COMMIT_DRAW_PENDING";
            }
            case 3: {
                return "READY_TO_SHOW";
            }
            case 4: {
                return "HAS_DRAWN";
            }
        }
        return Integer.toString(this.mDrawState);
    }

    WindowStateAnimator(WindowState win) {
        WindowManagerService service;
        this.mService = service = win.mWmService;
        this.mAnimator = service.mAnimator;
        this.mPolicy = service.mPolicy;
        this.mContext = service.mContext;
        this.mWin = win;
        this.mSession = win.mSession;
        this.mAttrType = win.mAttrs.type;
        this.mIsWallpaper = win.mIsWallpaper;
        this.mWallpaperControllerLocked = win.getDisplayContent().mWallpaperController;
    }

    void onAnimationFinished() {
        this.mWin.checkPolicyVisibilityChange();
        DisplayContent displayContent = this.mWin.getDisplayContent();
        if (this.mAttrType == 2000 && this.mWin.isVisibleByPolicy() && displayContent != null) {
            displayContent.setLayoutNeeded();
        }
        this.mWin.onExitAnimationDone();
        int displayId = this.mWin.getDisplayId();
        int pendingLayoutChanges = 8;
        if (displayContent.mWallpaperController.isWallpaperTarget(this.mWin)) {
            pendingLayoutChanges |= 4;
        }
        this.mAnimator.setPendingLayoutChanges(displayId, pendingLayoutChanges);
        if (this.mWin.mAppToken != null) {
            this.mWin.mAppToken.updateReportedVisibilityLocked();
        }
    }

    void hide(SurfaceControl.Transaction transaction, String reason) {
        if (!this.mLastHidden) {
            this.mLastHidden = true;
            this.markPreservedSurfaceForDestroy();
            if (this.mSurfaceController != null) {
                this.mSurfaceController.hide(transaction, reason);
            }
        }
    }

    void hide(String reason) {
        this.hide(this.mTmpTransaction, reason);
        SurfaceControl.mergeToGlobalTransaction(this.mTmpTransaction);
    }

    boolean finishDrawingLocked() {
        boolean startingWindow = this.mWin.mAttrs.type == 3;
        boolean layoutNeeded = false;
        if (this.mDrawState == 1) {
            this.mDrawState = 2;
            layoutNeeded = true;
        }
        return layoutNeeded;
    }

    boolean commitFinishDrawingLocked() {
        if (this.mDrawState != 2 && this.mDrawState != 3) {
            return false;
        }
        this.mDrawState = 3;
        boolean result = false;
        AppWindowToken atoken = this.mWin.mAppToken;
        if (atoken == null || atoken.canShowWindows() || this.mWin.mAttrs.type == 3) {
            result = this.mWin.performShowLocked();
        }
        return result;
    }

    void preserveSurfaceLocked() {
        if (this.mDestroyPreservedSurfaceUponRedraw) {
            this.mSurfaceDestroyDeferred = false;
            this.destroySurfaceLocked();
            this.mSurfaceDestroyDeferred = true;
            return;
        }
        if (this.mSurfaceController != null) {
            this.mSurfaceController.mSurfaceControl.setLayer(1);
        }
        this.mDestroyPreservedSurfaceUponRedraw = true;
        this.mSurfaceDestroyDeferred = true;
        this.destroySurfaceLocked();
    }

    void destroyPreservedSurfaceLocked() {
        if (!this.mDestroyPreservedSurfaceUponRedraw) {
            return;
        }
        if (!(this.mSurfaceController == null || this.mPendingDestroySurface == null || this.mWin.mAppToken != null && this.mWin.mAppToken.isRelaunching())) {
            this.mReparentTransaction.reparentChildren(this.mPendingDestroySurface.mSurfaceControl, this.mSurfaceController.mSurfaceControl.getHandle()).apply();
        }
        this.destroyDeferredSurfaceLocked();
        this.mDestroyPreservedSurfaceUponRedraw = false;
    }

    void markPreservedSurfaceForDestroy() {
        if (this.mDestroyPreservedSurfaceUponRedraw && !this.mService.mDestroyPreservedSurface.contains(this.mWin)) {
            this.mService.mDestroyPreservedSurface.add(this.mWin);
        }
    }

    private int getLayerStack() {
        return this.mWin.getDisplayContent().getDisplay().getLayerStack();
    }

    void resetDrawState() {
        this.mDrawState = 1;
        if (this.mWin.mAppToken == null) {
            return;
        }
        if (!this.mWin.mAppToken.isSelfAnimating()) {
            this.mWin.mAppToken.clearAllDrawn();
        } else {
            this.mWin.mAppToken.deferClearAllDrawn = true;
        }
    }

    WindowSurfaceController createSurfaceLocked(int windowType, int ownerUid) {
        WindowState w = this.mWin;
        if (this.mSurfaceController != null) {
            return this.mSurfaceController;
        }
        this.mChildrenDetached = false;
        if ((this.mWin.mAttrs.privateFlags & 0x100000) != 0) {
            windowType = 441731;
        }
        w.setHasSurface(false);
        this.resetDrawState();
        this.mService.makeWindowFreezingScreenIfNeededLocked(w);
        int flags = 4;
        WindowManager.LayoutParams attrs = w.mAttrs;
        if (this.mService.isSecureLocked(w)) {
            flags |= 0x80;
        }
        this.calculateSurfaceBounds(w, attrs, this.mTmpSize);
        int width = this.mTmpSize.width();
        int height = this.mTmpSize.height();
        this.mLastClipRect.set(0, 0, 0, 0);
        try {
            int format;
            boolean isHwAccelerated = (attrs.flags & 0x1000000) != 0;
            int n = format = isHwAccelerated ? -3 : attrs.format;
            if (!PixelFormat.formatHasAlpha(attrs.format) && attrs.surfaceInsets.left == 0 && attrs.surfaceInsets.top == 0 && attrs.surfaceInsets.right == 0 && attrs.surfaceInsets.bottom == 0 && !w.isDragResizing()) {
                flags |= 0x400;
            }
            this.mSurfaceController = new WindowSurfaceController(this.mSession.mSurfaceSession, attrs.getTitle().toString(), width, height, format, flags, this, windowType, ownerUid);
            this.mSurfaceController.setColorSpaceAgnostic((attrs.privateFlags & 0x1000000) != 0);
            this.setOffsetPositionForStackResize(false);
            this.mSurfaceFormat = format;
            w.setHasSurface(true);
        }
        catch (Surface.OutOfResourcesException e) {
            Slog.w(TAG, "OutOfResourcesException creating surface");
            this.mService.mRoot.reclaimSomeSurfaceMemory(this, "create", true);
            this.mDrawState = 0;
            return null;
        }
        catch (Exception e) {
            Slog.e(TAG, "Exception creating surface (parent dead?)", e);
            this.mDrawState = 0;
            return null;
        }
        this.mLastHidden = true;
        return this.mSurfaceController;
    }

    private void calculateSurfaceBounds(WindowState w, WindowManager.LayoutParams attrs, Rect outSize) {
        outSize.setEmpty();
        if ((attrs.flags & 0x4000) != 0) {
            outSize.right = w.mRequestedWidth;
            outSize.bottom = w.mRequestedHeight;
        } else if (w.isDragResizing()) {
            DisplayInfo displayInfo = w.getDisplayInfo();
            outSize.right = displayInfo.logicalWidth;
            outSize.bottom = displayInfo.logicalHeight;
        } else {
            w.getCompatFrameSize(outSize);
        }
        if (outSize.width() < 1) {
            outSize.right = 1;
        }
        if (outSize.height() < 1) {
            outSize.bottom = 1;
        }
        outSize.inset(-attrs.surfaceInsets.left, -attrs.surfaceInsets.top, -attrs.surfaceInsets.right, -attrs.surfaceInsets.bottom);
    }

    boolean hasSurface() {
        return this.mSurfaceController != null && this.mSurfaceController.hasSurface();
    }

    void destroySurfaceLocked() {
        AppWindowToken wtoken = this.mWin.mAppToken;
        if (wtoken != null && this.mWin == wtoken.startingWindow) {
            wtoken.startingDisplayed = false;
        }
        if (this.mSurfaceController == null) {
            return;
        }
        if (!this.mDestroyPreservedSurfaceUponRedraw) {
            this.mWin.mHidden = true;
        }
        try {
            if (this.mSurfaceDestroyDeferred) {
                if (this.mSurfaceController != null && this.mPendingDestroySurface != this.mSurfaceController) {
                    if (this.mPendingDestroySurface != null) {
                        this.mPendingDestroySurface.destroyNotInTransaction();
                    }
                    this.mPendingDestroySurface = this.mSurfaceController;
                }
            } else {
                this.destroySurface();
            }
            if (!this.mDestroyPreservedSurfaceUponRedraw) {
                this.mWallpaperControllerLocked.hideWallpapers(this.mWin);
            }
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Exception thrown when destroying Window " + this + " surface " + this.mSurfaceController + " session " + this.mSession + ": " + e.toString());
        }
        this.mWin.setHasSurface(false);
        if (this.mSurfaceController != null) {
            this.mSurfaceController.setShown(false);
        }
        this.mSurfaceController = null;
        this.mDrawState = 0;
    }

    void destroyDeferredSurfaceLocked() {
        try {
            if (this.mPendingDestroySurface != null) {
                this.mPendingDestroySurface.destroyNotInTransaction();
                if (!this.mDestroyPreservedSurfaceUponRedraw) {
                    this.mWallpaperControllerLocked.hideWallpapers(this.mWin);
                }
            }
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Exception thrown when destroying Window " + this + " surface " + this.mPendingDestroySurface + " session " + this.mSession + ": " + e.toString());
        }
        this.mSurfaceDestroyDeferred = false;
        this.mPendingDestroySurface = null;
    }

    void computeShownFrameLocked() {
        boolean screenAnimation;
        int displayId = this.mWin.getDisplayId();
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(displayId);
        boolean windowParticipatesInScreenRotationAnimation = !this.mWin.mForceSeamlesslyRotate;
        boolean bl = screenAnimation = screenRotationAnimation != null && screenRotationAnimation.isAnimating() && windowParticipatesInScreenRotationAnimation;
        if (screenAnimation) {
            Rect frame = this.mWin.getFrameLw();
            float[] tmpFloats = this.mService.mTmpFloats;
            Matrix tmpMatrix = this.mWin.mTmpMatrix;
            if (screenRotationAnimation.isRotating()) {
                float w = frame.width();
                float h = frame.height();
                if (w >= 1.0f && h >= 1.0f) {
                    tmpMatrix.setScale(1.0f + 2.0f / w, 1.0f + 2.0f / h, w / 2.0f, h / 2.0f);
                } else {
                    tmpMatrix.reset();
                }
            } else {
                tmpMatrix.reset();
            }
            tmpMatrix.postScale(this.mWin.mGlobalScale, this.mWin.mGlobalScale);
            tmpMatrix.postTranslate(this.mWin.mAttrs.surfaceInsets.left, this.mWin.mAttrs.surfaceInsets.top);
            this.mHaveMatrix = true;
            tmpMatrix.getValues(tmpFloats);
            this.mDsDx = tmpFloats[0];
            this.mDtDx = tmpFloats[3];
            this.mDtDy = tmpFloats[1];
            this.mDsDy = tmpFloats[4];
            this.mShownAlpha = this.mAlpha;
            if ((!this.mService.mLimitedAlphaCompositing || !PixelFormat.formatHasAlpha(this.mWin.mAttrs.format) || this.mWin.isIdentityMatrix(this.mDsDx, this.mDtDx, this.mDtDy, this.mDsDy)) && screenAnimation) {
                this.mShownAlpha *= screenRotationAnimation.getEnterTransformation().getAlpha();
            }
            return;
        }
        if (this.mIsWallpaper && this.mService.mRoot.mWallpaperActionPending) {
            return;
        }
        if (this.mWin.isDragResizeChanged()) {
            return;
        }
        this.mShownAlpha = this.mAlpha;
        this.mHaveMatrix = false;
        this.mDsDx = this.mWin.mGlobalScale;
        this.mDtDx = 0.0f;
        this.mDtDy = 0.0f;
        this.mDsDy = this.mWin.mGlobalScale;
    }

    private boolean calculateCrop(Rect clipRect) {
        WindowState w = this.mWin;
        DisplayContent displayContent = w.getDisplayContent();
        clipRect.setEmpty();
        if (displayContent == null) {
            return false;
        }
        if (w.getWindowConfiguration().tasksAreFloating()) {
            return false;
        }
        if (w.mForceSeamlesslyRotate) {
            return false;
        }
        if (w.mAttrs.type == 2013) {
            return false;
        }
        w.calculatePolicyCrop(this.mSystemDecorRect);
        clipRect.set(this.mSystemDecorRect);
        w.expandForSurfaceInsets(clipRect);
        clipRect.offset(w.mAttrs.surfaceInsets.left, w.mAttrs.surfaceInsets.top);
        w.transformClipRectFromScreenToSurfaceSpace(clipRect);
        return true;
    }

    private void applyCrop(Rect clipRect, boolean recoveringMemory) {
        if (clipRect != null) {
            if (!clipRect.equals(this.mLastClipRect)) {
                this.mLastClipRect.set(clipRect);
                this.mSurfaceController.setCropInTransaction(clipRect, recoveringMemory);
            }
        } else {
            this.mSurfaceController.clearCropInTransaction(recoveringMemory);
        }
    }

    void setSurfaceBoundariesLocked(boolean recoveringMemory) {
        if (this.mSurfaceController == null) {
            return;
        }
        WindowState w = this.mWin;
        WindowManager.LayoutParams attrs = this.mWin.getAttrs();
        Task task = w.getTask();
        this.calculateSurfaceBounds(w, attrs, this.mTmpSize);
        this.mExtraHScale = 1.0f;
        this.mExtraVScale = 1.0f;
        boolean wasForceScaled = this.mForceScaleUntilResize;
        boolean relayout = !w.mRelayoutCalled || w.mInRelayout;
        this.mSurfaceResized = relayout ? this.mSurfaceController.setBufferSizeInTransaction(this.mTmpSize.width(), this.mTmpSize.height(), recoveringMemory) : false;
        this.mForceScaleUntilResize = this.mForceScaleUntilResize && !this.mSurfaceResized;
        Rect clipRect = null;
        if (this.calculateCrop(this.mTmpClipRect)) {
            clipRect = this.mTmpClipRect;
        }
        float surfaceWidth = this.mSurfaceController.getWidth();
        float surfaceHeight = this.mSurfaceController.getHeight();
        Rect insets = attrs.surfaceInsets;
        if (this.isForceScaled()) {
            int hInsets = insets.left + insets.right;
            int vInsets = insets.top + insets.bottom;
            float surfaceContentWidth = surfaceWidth - (float)hInsets;
            float surfaceContentHeight = surfaceHeight - (float)vInsets;
            if (!this.mForceScaleUntilResize) {
                this.mSurfaceController.forceScaleableInTransaction(true);
            }
            int posX = 0;
            int posY = 0;
            task.mStack.getDimBounds(this.mTmpStackBounds);
            boolean allowStretching = false;
            task.mStack.getFinalAnimationSourceHintBounds(this.mTmpSourceBounds);
            if (this.mTmpSourceBounds.isEmpty() && (this.mWin.mLastRelayoutContentInsets.width() > 0 || this.mWin.mLastRelayoutContentInsets.height() > 0) && !task.mStack.lastAnimatingBoundsWasToFullscreen()) {
                this.mTmpSourceBounds.set(task.mStack.mPreAnimationBounds);
                this.mTmpSourceBounds.inset(this.mWin.mLastRelayoutContentInsets);
                allowStretching = true;
            }
            this.mTmpStackBounds.intersectUnchecked(w.getParentFrame());
            this.mTmpSourceBounds.intersectUnchecked(w.getParentFrame());
            this.mTmpAnimatingBounds.intersectUnchecked(w.getParentFrame());
            if (!this.mTmpSourceBounds.isEmpty()) {
                float tw;
                task.mStack.getFinalAnimationBounds(this.mTmpAnimatingBounds);
                float finalWidth = this.mTmpAnimatingBounds.width();
                float initialWidth = this.mTmpSourceBounds.width();
                float th = tw = (surfaceContentWidth - (float)this.mTmpStackBounds.width()) / (surfaceContentWidth - (float)this.mTmpAnimatingBounds.width());
                this.mExtraHScale = (initialWidth + tw * (finalWidth - initialWidth)) / initialWidth;
                if (allowStretching) {
                    float finalHeight = this.mTmpAnimatingBounds.height();
                    float initialHeight = this.mTmpSourceBounds.height();
                    th = (surfaceContentHeight - (float)this.mTmpStackBounds.height()) / (surfaceContentHeight - (float)this.mTmpAnimatingBounds.height());
                    this.mExtraVScale = (initialHeight + tw * (finalHeight - initialHeight)) / initialHeight;
                } else {
                    this.mExtraVScale = this.mExtraHScale;
                }
                posX -= (int)(tw * this.mExtraHScale * (float)this.mTmpSourceBounds.left);
                posY -= (int)(th * this.mExtraVScale * (float)this.mTmpSourceBounds.top);
                clipRect = this.mTmpClipRect;
                clipRect.set((int)((float)(insets.left + this.mTmpSourceBounds.left) * tw), (int)((float)(insets.top + this.mTmpSourceBounds.top) * th), insets.left + (int)(surfaceWidth - tw * (surfaceWidth - (float)this.mTmpSourceBounds.right)), insets.top + (int)(surfaceHeight - th * (surfaceHeight - (float)this.mTmpSourceBounds.bottom)));
            } else {
                this.mExtraHScale = (float)this.mTmpStackBounds.width() / surfaceContentWidth;
                this.mExtraVScale = (float)this.mTmpStackBounds.height() / surfaceContentHeight;
                clipRect = null;
            }
            posX -= (int)((float)attrs.x * (1.0f - this.mExtraHScale));
            posY -= (int)((float)attrs.y * (1.0f - this.mExtraVScale));
            posX = (int)((float)posX + (float)insets.left * (1.0f - this.mExtraHScale));
            posY = (int)((float)posY + (float)insets.top * (1.0f - this.mExtraVScale));
            this.mSurfaceController.setPositionInTransaction((float)Math.floor(posX), (float)Math.floor(posY), recoveringMemory);
            if (!this.mPipAnimationStarted) {
                this.mForceScaleUntilResize = true;
                this.mPipAnimationStarted = true;
            }
        } else {
            this.mPipAnimationStarted = false;
            if (!w.mSeamlesslyRotated) {
                int xOffset = this.mXOffset;
                int yOffset = this.mYOffset;
                if (this.mOffsetPositionForStackResize) {
                    if (relayout) {
                        this.setOffsetPositionForStackResize(false);
                        this.mSurfaceController.deferTransactionUntil(this.mSurfaceController.getHandle(), this.mWin.getFrameNumber());
                    } else {
                        TaskStack stack = this.mWin.getStack();
                        this.mTmpPos.x = 0;
                        this.mTmpPos.y = 0;
                        if (stack != null) {
                            stack.getRelativeDisplayedPosition(this.mTmpPos);
                        }
                        xOffset = -this.mTmpPos.x;
                        yOffset = -this.mTmpPos.y;
                        if (clipRect != null) {
                            clipRect.right += this.mTmpPos.x;
                            clipRect.bottom += this.mTmpPos.y;
                        }
                    }
                }
                this.mSurfaceController.setPositionInTransaction(xOffset, yOffset, recoveringMemory);
            }
        }
        if (wasForceScaled && !this.mForceScaleUntilResize) {
            this.mSurfaceController.deferTransactionUntil(this.mSurfaceController.getHandle(), this.mWin.getFrameNumber());
            this.mSurfaceController.forceScaleableInTransaction(false);
        }
        if (!w.mSeamlesslyRotated) {
            this.applyCrop(clipRect, recoveringMemory);
            this.mSurfaceController.setMatrixInTransaction(this.mDsDx * w.mHScale * this.mExtraHScale, this.mDtDx * w.mVScale * this.mExtraVScale, this.mDtDy * w.mHScale * this.mExtraHScale, this.mDsDy * w.mVScale * this.mExtraVScale, recoveringMemory);
        }
        if (this.mSurfaceResized) {
            this.mReportSurfaceResized = true;
            this.mAnimator.setPendingLayoutChanges(w.getDisplayId(), 4);
        }
    }

    void getContainerRect(Rect rect) {
        Task task = this.mWin.getTask();
        if (task != null) {
            task.getDimBounds(rect);
        } else {
            rect.bottom = 0;
            rect.right = 0;
            rect.top = 0;
            rect.left = 0;
        }
    }

    void prepareSurfaceLocked(boolean recoveringMemory) {
        WindowState w = this.mWin;
        if (!this.hasSurface()) {
            if (w.getOrientationChanging() && w.isGoneForLayoutLw()) {
                w.setOrientationChanging(false);
            }
            return;
        }
        boolean displayed = false;
        this.computeShownFrameLocked();
        this.setSurfaceBoundariesLocked(recoveringMemory);
        if (this.mIsWallpaper && !w.mWallpaperVisible) {
            this.hide("prepareSurfaceLocked");
        } else if (w.isParentWindowHidden() || !w.isOnScreen()) {
            this.hide("prepareSurfaceLocked");
            this.mWallpaperControllerLocked.hideWallpapers(w);
            if (w.getOrientationChanging() && w.isGoneForLayoutLw()) {
                w.setOrientationChanging(false);
            }
        } else if (this.mLastAlpha != this.mShownAlpha || this.mLastDsDx != this.mDsDx || this.mLastDtDx != this.mDtDx || this.mLastDsDy != this.mDsDy || this.mLastDtDy != this.mDtDy || w.mLastHScale != w.mHScale || w.mLastVScale != w.mVScale || this.mLastHidden) {
            displayed = true;
            this.mLastAlpha = this.mShownAlpha;
            this.mLastDsDx = this.mDsDx;
            this.mLastDtDx = this.mDtDx;
            this.mLastDsDy = this.mDsDy;
            this.mLastDtDy = this.mDtDy;
            w.mLastHScale = w.mHScale;
            w.mLastVScale = w.mVScale;
            boolean prepared = this.mSurfaceController.prepareToShowInTransaction(this.mShownAlpha, this.mDsDx * w.mHScale * this.mExtraHScale, this.mDtDx * w.mVScale * this.mExtraVScale, this.mDtDy * w.mHScale * this.mExtraHScale, this.mDsDy * w.mVScale * this.mExtraVScale, recoveringMemory);
            if (prepared && this.mDrawState == 4 && this.mLastHidden) {
                if (this.showSurfaceRobustlyLocked()) {
                    this.markPreservedSurfaceForDestroy();
                    this.mAnimator.requestRemovalOfReplacedWindows(w);
                    this.mLastHidden = false;
                    if (this.mIsWallpaper) {
                        w.dispatchWallpaperVisibility(true);
                    }
                    if (!w.getDisplayContent().getLastHasContent()) {
                        this.mAnimator.setPendingLayoutChanges(w.getDisplayId(), 8);
                    }
                } else {
                    w.setOrientationChanging(false);
                }
            }
            if (this.hasSurface()) {
                w.mToken.hasVisible = true;
            }
        } else {
            displayed = true;
        }
        if (w.getOrientationChanging()) {
            if (!w.isDrawnLw()) {
                this.mAnimator.mBulkUpdateParams &= 0xFFFFFFFB;
                this.mAnimator.mLastWindowFreezeSource = w;
            } else {
                w.setOrientationChanging(false);
            }
        }
        if (displayed) {
            w.mToken.hasVisible = true;
        }
    }

    void setTransparentRegionHintLocked(Region region) {
        if (this.mSurfaceController == null) {
            Slog.w(TAG, "setTransparentRegionHint: null mSurface after mHasSurface true");
            return;
        }
        this.mSurfaceController.setTransparentRegionHint(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setWallpaperOffset(int dx, int dy) {
        if (this.mXOffset == dx && this.mYOffset == dy) {
            return false;
        }
        this.mXOffset = dx;
        this.mYOffset = dy;
        try {
            this.mService.openSurfaceTransaction();
            this.mSurfaceController.setPositionInTransaction(dx, dy, false);
            this.applyCrop(null, false);
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Error positioning surface of " + this.mWin + " pos=(" + dx + "," + dy + ")", e);
        }
        finally {
            this.mService.closeSurfaceTransaction("setWallpaperOffset");
            return true;
        }
    }

    boolean tryChangeFormatInPlaceLocked() {
        int format;
        if (this.mSurfaceController == null) {
            return false;
        }
        WindowManager.LayoutParams attrs = this.mWin.getAttrs();
        boolean isHwAccelerated = (attrs.flags & 0x1000000) != 0;
        int n = format = isHwAccelerated ? -3 : attrs.format;
        if (format == this.mSurfaceFormat) {
            this.setOpaqueLocked(!PixelFormat.formatHasAlpha(attrs.format));
            return true;
        }
        return false;
    }

    void setOpaqueLocked(boolean isOpaque) {
        if (this.mSurfaceController == null) {
            return;
        }
        this.mSurfaceController.setOpaque(isOpaque);
    }

    void setSecureLocked(boolean isSecure) {
        if (this.mSurfaceController == null) {
            return;
        }
        this.mSurfaceController.setSecure(isSecure);
    }

    void setColorSpaceAgnosticLocked(boolean agnostic) {
        if (this.mSurfaceController == null) {
            return;
        }
        this.mSurfaceController.setColorSpaceAgnostic(agnostic);
    }

    private boolean showSurfaceRobustlyLocked() {
        boolean shown;
        if (this.mWin.getWindowConfiguration().windowsAreScaleable()) {
            this.mSurfaceController.forceScaleableInTransaction(true);
        }
        if (!(shown = this.mSurfaceController.showRobustlyInTransaction())) {
            return false;
        }
        if (this.mPendingDestroySurface != null && this.mDestroyPreservedSurfaceUponRedraw) {
            this.mPendingDestroySurface.mSurfaceControl.hide();
            this.mPendingDestroySurface.reparentChildrenInTransaction(this.mSurfaceController);
        }
        return true;
    }

    void applyEnterAnimationLocked() {
        int transit;
        if (this.mWin.mSkipEnterAnimationForSeamlessReplacement) {
            return;
        }
        if (this.mEnterAnimationPending) {
            this.mEnterAnimationPending = false;
            transit = 1;
        } else {
            transit = 3;
        }
        if (this.mAttrType != 1) {
            this.applyAnimationLocked(transit, true);
        }
        if (this.mService.mAccessibilityController != null) {
            this.mService.mAccessibilityController.onWindowTransitionLocked(this.mWin, transit);
        }
    }

    boolean applyAnimationLocked(int transit, boolean isEntrance) {
        if (this.mWin.isSelfAnimating() && this.mAnimationIsEntrance == isEntrance) {
            return true;
        }
        if (isEntrance && this.mWin.mAttrs.type == 2011) {
            this.mWin.getDisplayContent().adjustForImeIfNeeded();
            this.mWin.setDisplayLayoutNeeded();
            this.mService.mWindowPlacerLocked.requestTraversal();
        }
        Trace.traceBegin(32L, "WSA#applyAnimationLocked");
        if (this.mWin.mToken.okToAnimate()) {
            int anim2 = this.mWin.getDisplayContent().getDisplayPolicy().selectAnimationLw(this.mWin, transit);
            int attr2 = -1;
            Animation a = null;
            if (anim2 != 0) {
                a = anim2 != -1 ? AnimationUtils.loadAnimation(this.mContext, anim2) : null;
            } else {
                switch (transit) {
                    case 1: {
                        attr2 = 0;
                        break;
                    }
                    case 2: {
                        attr2 = 1;
                        break;
                    }
                    case 3: {
                        attr2 = 2;
                        break;
                    }
                    case 4: {
                        attr2 = 3;
                    }
                }
                if (attr2 >= 0) {
                    a = this.mWin.getDisplayContent().mAppTransition.loadAnimationAttr(this.mWin.mAttrs, attr2, 0);
                }
            }
            if (a != null) {
                this.mWin.startAnimation(a);
                this.mAnimationIsEntrance = isEntrance;
            }
        } else {
            this.mWin.cancelAnimation();
        }
        if (!isEntrance && this.mWin.mAttrs.type == 2011) {
            this.mWin.getDisplayContent().adjustForImeIfNeeded();
        }
        Trace.traceEnd(32L);
        return this.mWin.isAnimating();
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        this.mLastClipRect.writeToProto(proto, 0x10B00000001L);
        if (this.mSurfaceController != null) {
            this.mSurfaceController.writeToProto(proto, 1146756268034L);
        }
        proto.write(1159641169923L, this.mDrawState);
        this.mSystemDecorRect.writeToProto(proto, 1146756268036L);
        proto.end(token);
    }

    public void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        if (this.mAnimationIsEntrance) {
            pw.print(prefix);
            pw.print(" mAnimationIsEntrance=");
            pw.print(this.mAnimationIsEntrance);
        }
        if (this.mSurfaceController != null) {
            this.mSurfaceController.dump(pw, prefix, dumpAll);
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mDrawState=");
            pw.print(this.drawStateToString());
            pw.print(prefix);
            pw.print(" mLastHidden=");
            pw.println(this.mLastHidden);
            pw.print(prefix);
            pw.print("mSystemDecorRect=");
            this.mSystemDecorRect.printShortString(pw);
            pw.print(" mLastClipRect=");
            this.mLastClipRect.printShortString(pw);
            if (!this.mLastFinalClipRect.isEmpty()) {
                pw.print(" mLastFinalClipRect=");
                this.mLastFinalClipRect.printShortString(pw);
            }
            pw.println();
        }
        if (this.mPendingDestroySurface != null) {
            pw.print(prefix);
            pw.print("mPendingDestroySurface=");
            pw.println(this.mPendingDestroySurface);
        }
        if (this.mSurfaceResized || this.mSurfaceDestroyDeferred) {
            pw.print(prefix);
            pw.print("mSurfaceResized=");
            pw.print(this.mSurfaceResized);
            pw.print(" mSurfaceDestroyDeferred=");
            pw.println(this.mSurfaceDestroyDeferred);
        }
        if (this.mShownAlpha != 1.0f || this.mAlpha != 1.0f || this.mLastAlpha != 1.0f) {
            pw.print(prefix);
            pw.print("mShownAlpha=");
            pw.print(this.mShownAlpha);
            pw.print(" mAlpha=");
            pw.print(this.mAlpha);
            pw.print(" mLastAlpha=");
            pw.println(this.mLastAlpha);
        }
        if (this.mHaveMatrix || this.mWin.mGlobalScale != 1.0f) {
            pw.print(prefix);
            pw.print("mGlobalScale=");
            pw.print(this.mWin.mGlobalScale);
            pw.print(" mDsDx=");
            pw.print(this.mDsDx);
            pw.print(" mDtDx=");
            pw.print(this.mDtDx);
            pw.print(" mDtDy=");
            pw.print(this.mDtDy);
            pw.print(" mDsDy=");
            pw.println(this.mDsDy);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("WindowStateAnimator{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        sb.append(this.mWin.mAttrs.getTitle());
        sb.append('}');
        return sb.toString();
    }

    void reclaimSomeSurfaceMemory(String operation, boolean secure) {
        this.mService.mRoot.reclaimSomeSurfaceMemory(this, operation, secure);
    }

    boolean getShown() {
        if (this.mSurfaceController != null) {
            return this.mSurfaceController.getShown();
        }
        return false;
    }

    void destroySurface() {
        try {
            if (this.mSurfaceController != null) {
                this.mSurfaceController.destroyNotInTransaction();
            }
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Exception thrown when destroying surface " + this + " surface " + this.mSurfaceController + " session " + this.mSession + ": " + e);
        }
        finally {
            this.mWin.setHasSurface(false);
            this.mSurfaceController = null;
            this.mDrawState = 0;
        }
    }

    boolean isForceScaled() {
        Task task = this.mWin.getTask();
        if (task != null && task.mStack.isForceScaled()) {
            return true;
        }
        return this.mForceScaleUntilResize;
    }

    void detachChildren() {
        if (this.mSurfaceController != null) {
            this.mSurfaceController.detachChildren();
        }
        this.mChildrenDetached = true;
    }

    void setOffsetPositionForStackResize(boolean offsetPositionForStackResize) {
        this.mOffsetPositionForStackResize = offsetPositionForStackResize;
    }
}

