/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.Debug;
import android.os.Trace;
import android.util.Slog;
import android.util.SparseIntArray;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;

class WindowSurfacePlacer {
    private static final String TAG = "WindowManager";
    private final WindowManagerService mService;
    private boolean mInLayout = false;
    private int mLayoutRepeatCount;
    static final int SET_UPDATE_ROTATION = 1;
    static final int SET_ORIENTATION_CHANGE_COMPLETE = 4;
    static final int SET_WALLPAPER_ACTION_PENDING = 8;
    private boolean mTraversalScheduled;
    private int mDeferDepth = 0;
    private final SparseIntArray mTempTransitionReasons = new SparseIntArray();
    private final Runnable mPerformSurfacePlacement;

    public WindowSurfacePlacer(WindowManagerService service) {
        this.mService = service;
        this.mPerformSurfacePlacement = () -> {
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            synchronized (windowManagerGlobalLock) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    this.performSurfacePlacement();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        };
    }

    void deferLayout() {
        ++this.mDeferDepth;
    }

    void continueLayout() {
        --this.mDeferDepth;
        if (this.mDeferDepth <= 0) {
            this.performSurfacePlacement();
        }
    }

    boolean isLayoutDeferred() {
        return this.mDeferDepth > 0;
    }

    void performSurfacePlacementIfScheduled() {
        if (this.mTraversalScheduled) {
            this.performSurfacePlacement();
        }
    }

    final void performSurfacePlacement() {
        this.performSurfacePlacement(false);
    }

    final void performSurfacePlacement(boolean force) {
        if (this.mDeferDepth > 0 && !force) {
            return;
        }
        int loopCount = 6;
        do {
            this.mTraversalScheduled = false;
            this.performSurfacePlacementLoop();
            this.mService.mAnimationHandler.removeCallbacks(this.mPerformSurfacePlacement);
        } while (this.mTraversalScheduled && --loopCount > 0);
        this.mService.mRoot.mWallpaperActionPending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSurfacePlacementLoop() {
        if (this.mInLayout) {
            Slog.w(TAG, "performLayoutAndPlaceSurfacesLocked called while in layout. Callers=" + Debug.getCallers(3));
            return;
        }
        DisplayContent defaultDisplay = this.mService.getDefaultDisplayContentLocked();
        if (defaultDisplay.mWaitingForConfig) {
            return;
        }
        if (!this.mService.mDisplayReady) {
            return;
        }
        Trace.traceBegin(32L, "wmLayout");
        this.mInLayout = true;
        boolean recoveringMemory = false;
        if (!this.mService.mForceRemoves.isEmpty()) {
            Object tmp;
            recoveringMemory = true;
            while (!this.mService.mForceRemoves.isEmpty()) {
                WindowState ws = this.mService.mForceRemoves.remove(0);
                Slog.i(TAG, "Force removing: " + ws);
                ws.removeImmediately();
            }
            Slog.w(TAG, "Due to memory failure, waiting a bit for next layout");
            Object object = tmp = new Object();
            synchronized (object) {
                try {
                    tmp.wait(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            this.mService.mRoot.performSurfacePlacement(recoveringMemory);
            this.mInLayout = false;
            if (this.mService.mRoot.isLayoutNeeded()) {
                if (++this.mLayoutRepeatCount < 6) {
                    this.requestTraversal();
                } else {
                    Slog.e(TAG, "Performed 6 layouts in a row. Skipping");
                    this.mLayoutRepeatCount = 0;
                }
            } else {
                this.mLayoutRepeatCount = 0;
            }
            if (this.mService.mWindowsChanged && !this.mService.mWindowChangeListeners.isEmpty()) {
                this.mService.mH.removeMessages(19);
                this.mService.mH.sendEmptyMessage(19);
            }
        }
        catch (RuntimeException e) {
            this.mInLayout = false;
            Slog.wtf(TAG, "Unhandled exception while laying out windows", e);
        }
        Trace.traceEnd(32L);
    }

    void debugLayoutRepeats(String msg, int pendingLayoutChanges) {
        if (this.mLayoutRepeatCount >= 4) {
            Slog.v(TAG, "Layouts looping: " + msg + ", mPendingLayoutChanges = 0x" + Integer.toHexString(pendingLayoutChanges));
        }
    }

    boolean isInLayout() {
        return this.mInLayout;
    }

    void requestTraversal() {
        if (!this.mTraversalScheduled) {
            this.mTraversalScheduled = true;
            this.mService.mAnimationHandler.post(this.mPerformSurfacePlacement);
        }
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "mTraversalScheduled=" + this.mTraversalScheduled);
        pw.println(prefix + "mHoldScreenWindow=" + this.mService.mRoot.mHoldScreenWindow);
        pw.println(prefix + "mObscuringWindow=" + this.mService.mRoot.mObscuringWindow);
    }
}

